// This file is part of the FXT library.
// Copyright (C) 2010, 2012 Joerg Arndt
// License: GNU General Public License version 3 or later,
// see the file COPYING.txt in the main directory.

#include "array-len.h"
#include "fxttypes.h"
#include "bits/bitsperlong.h"

extern const ulong highbit_normal_primpoly[]=
//
//  Normal primitive polynomials over GF(2)
//  with lowest non-constant term as high as possible.
//
//  Generated by Joerg Arndt, 2003-December-12
//
{
    //  hex_val,  // ==dec_val  (deg)  [weight]
    0x1,         // 1  (0)  [1]
    0x3,         // 3  (1)  [2]
    0x7UL,   // ==7  (2)  [3]
    0xdUL,   // ==13  (3)  [3]
    0x19UL,   // ==25  (4)  [3]
    0x3dUL,   // ==61  (5)  [5]
    0x61UL,   // ==97  (6)  [3]
    0xc1UL,   // ==193  (7)  [3]
    0x1a9UL,   // ==425  (8)  [5]
    0x331UL,   // ==817  (9)  [5]
    0x6c1UL,   // ==1729  (10)  [5]
    0xe81UL,   // ==3713  (11)  [5]
    0x1941UL,   // ==6465  (12)  [5]
    0x3601UL,   // ==13825  (13)  [5]
    0x6a01UL,   // ==27137  (14)  [5]
    0xc001UL,   // ==49153  (15)  [3]
    0x1f801UL,   // ==129025  (16)  [7]
    0x3c001UL,   // ==245761  (17)  [5]
    0x72001UL,   // ==466945  (18)  [5]
    0xe4001UL,   // ==933889  (19)  [5]
    0x194001UL,   // ==1654785  (20)  [5]
    0x390001UL,   // ==3735553  (21)  [5]
    0x600001UL,   // ==6291457  (22)  [3]
    0xd40001UL,   // ==13893633  (23)  [5]
    0x1c20001UL,   // ==29491201  (24)  [5]
    0x3c00001UL,   // ==62914561  (25)  [5]
    0x7100001UL,   // ==118489089  (26)  [5]
    0xd700001UL,   // ==225443841  (27)  [7]
    0x1dc00001UL,   // ==499122177  (28)  [7]
    0x3a000001UL,   // ==973078529  (29)  [5]
    0x65000001UL,   // ==1694498817  (30)  [5]
    0xd1000001UL,   // ==3506438145  (31)  [5]

#if  ( BITS_PER_LONG <= 32 )
    0xea000001UL,   // ==3925868545  (32)  [7]  // highest bit stripped
#endif

#if  ( BITS_PER_LONG > 32 )
    0x1ea000001UL,   // ==8220835841  (32)  [7]
    0x328000001UL,   // ==13555990529  (33)  [5]
    0x738000001UL,   // ==31004295169  (34)  [7]
    0xfa0000001UL,   // ==67108864001  (35)  [7]
    0x1830000001UL,   // ==103884521473  (36)  [5]
    0x3f00000001UL,   // ==270582939649  (37)  [7]
    0x6300000001UL,   // ==425201762305  (38)  [5]
    0xe380000001UL,   // ==977105059841  (39)  [7]
    0x1d600000001UL,   // ==2018634629121  (40)  [7]
    0x3c000000001UL,   // ==4123168604161  (41)  [5]
    0x7e000000001UL,   // ==8658654068737  (42)  [7]
    0xc6000000001UL,   // ==13606456393729  (43)  [5]
    0x1ba000000001UL,   // ==30374008717313  (44)  [7]
    0x328000000001UL,   // ==55525337202689  (45)  [5]
    0x7a4000000001UL,   // ==134415296495617  (46)  [7]
    0xcc0000000001UL,   // ==224300372066305  (47)  [5]
    0x1da0000000001UL,   // ==521168511565825  (48)  [7]
    0x3740000000001UL,   // ==971968278953985  (49)  [7]
    0x69c0000000001UL,   // ==1860373674196993  (50)  [7]
    0xd200000000001UL,   // ==3694359069327361  (51)  [5]
    0x1a400000000001UL,   // ==7388718138654721  (52)  [5]
    0x38800000000001UL,   // ==15903336184152065  (53)  [5]
    0x76400000000001UL,   // ==33284415996035073  (54)  [7]
    0xe2000000000001UL,   // ==63613344736608257  (55)  [5]
    0x1b3000000000001UL,   // ==122441614869135361  (56)  [7]
    0x3c6000000000001UL,   // ==271904827502493697  (57)  [7]
    0x630000000000001UL,   // ==445856363109679105  (58)  [5]
    0xde0000000000001UL,   // ==999799117276250113  (59)  [7]
    0x1800000000000001UL,   // ==1729382256910270465  (60)  [3]
    0x3900000000000001UL,   // ==4107282860161892353  (61)  [5]
    0x7a80000000000001UL,   // ==8827055269646172161  (62)  [7]
    0xc000000000000001UL,   // ==13835058055282163713  (63)  [3]
//#if 0
    0xb000000000000001UL,   // ==12682136550675316737  (64)  [5]
//#endif  // 0
#endif  // ( BITS_PER_LONG > 32 )
};
// -------------------------

extern const ulong highbit_normal_primpoly_len = ARRAY_LEN(highbit_normal_primpoly);

