// This file is part of the FXT library.
// Copyright (C) 2010, 2012 Joerg Arndt
// License: GNU General Public License version 3 or later,
// see the file COPYING.txt in the main directory.

#include "array-len.h"
#include "fxttypes.h"
#include "bits/bitsperlong.h"

extern const ulong highbit_normal_irredpoly[]=
//  Normal (irreducible) polynomials over GF(2)
//  with lowest non-constant term as high as possible.
{
    //  hex_val,  // ==dec_val  (deg)  [weight]
    0x1,         // 1  (0)  [1]
    0x3,         // 3  (1)  [2]
    0x7UL,   // ==7  (2)  [3]
    0xdUL,   // ==13  (3)  [3]
    0x19UL,   // ==25  (4)  [3]
    0x3dUL,   // ==61  (5)  [5]
    0x61UL,   // ==97  (6)  [3]
    0xc1UL,   // ==193  (7)  [3]
    0x1b1UL,   // ==433  (8)  [5]
    0x301UL,   // ==769  (9)  [3]
    0x781UL,   // ==1921  (10)  [5]
    0xe81UL,   // ==3713  (11)  [5]
    0x1d01UL,   // ==7425  (12)  [5]
    0x3601UL,   // ==13825  (13)  [5]
    0x6a01UL,   // ==27137  (14)  [5]
    0xc001UL,   // ==49153  (15)  [3]
    0x1a801UL,   // ==108545  (16)  [5]
    0x3c001UL,   // ==245761  (17)  [5]
    0x72001UL,   // ==466945  (18)  [5]
    0xe4001UL,   // ==933889  (19)  [5]
    0x1e0001UL,   // ==1966081  (20)  [5]
    0x390001UL,   // ==3735553  (21)  [5]
    0x600001UL,   // ==6291457  (22)  [3]
    0xd40001UL,   // ==13893633  (23)  [5]
    0x1ec0001UL,   // ==32243713  (24)  [7]
    0x3c00001UL,   // ==62914561  (25)  [5]
    0x6c00001UL,   // ==113246209  (26)  [5]
    0xd700001UL,   // ==225443841  (27)  [7]
    0x18000001UL,   // ==402653185  (28)  [3]
    0x3a000001UL,   // ==973078529  (29)  [5]
    0x60000001UL,   // ==1610612737  (30)  [3]
    0xd1000001UL,   // ==3506438145  (31)  [5]

#if  ( BITS_PER_LONG <= 32 )
    0xea000001UL,   // ==3925868545  (32)  [7]  // highest bit stripped
#endif

#if  ( BITS_PER_LONG > 32 )
    0x1ea000001UL,   // ==8220835841  (32)  [7]
    0x348000001UL,   // ==14092861441  (33)  [5]
    0x6c0000001UL,   // ==28991029249  (34)  [5]
    0xfa0000001UL,   // ==67108864001  (35)  [7]
    0x1f80000001UL,   // ==135291469825  (36)  [7]
    0x3f00000001UL,   // ==270582939649  (37)  [7]
    0x6300000001UL,   // ==425201762305  (38)  [5]
    0xc500000001UL,   // ==846108557313  (39)  [5]
    0x1d600000001UL,   // ==2018634629121  (40)  [7]
    0x3c000000001UL,   // ==4123168604161  (41)  [5]
    0x72000000001UL,   // ==7834020347905  (42)  [5]
    0xc6000000001UL,   // ==13606456393729  (43)  [5]
    0x198000000001UL,   // ==28037546508289  (44)  [5]
    0x328000000001UL,   // ==55525337202689  (45)  [5]
    0x600000000001UL,   // ==105553116266497  (46)  [3]
    0xcc0000000001UL,   // ==224300372066305  (47)  [5]
    0x1ec0000000001UL,   // ==540959720865793  (48)  [7]
    0x3740000000001UL,   // ==971968278953985  (49)  [7]
    0x7c40000000001UL,   // ==2185829116018689  (50)  [7]
    0xd200000000001UL,   // ==3694359069327361  (51)  [5]
    0x1e000000000001UL,   // ==8444249301319681  (52)  [5]
    0x38800000000001UL,   // ==15903336184152065  (53)  [5]
    0x76400000000001UL,   // ==33284415996035073  (54)  [7]
    0xe2000000000001UL,   // ==63613344736608257  (55)  [5]
    0x1b3000000000001UL,   // ==122441614869135361  (56)  [7]
    0x324000000000001UL,   // ==226305881275367425  (57)  [5]
    0x630000000000001UL,   // ==445856363109679105  (58)  [5]
    0xde0000000000001UL,   // ==999799117276250113  (59)  [7]
    0x1800000000000001UL,   // ==1729382256910270465  (60)  [3]
    0x3900000000000001UL,   // ==4107282860161892353  (61)  [5]
    0x7a80000000000001UL,   // ==8827055269646172161  (62)  [7]
    0xc000000000000001UL,   // ==13835058055282163713  (63)  [3]
    0xb000000000000001UL,   // ==12682136550675316737  (64)  [5]
#endif  // ( BITS_PER_LONG > 32 )
};
// -------------------------

extern const ulong highbit_normal_irredpoly_len = ARRAY_LEN(highbit_normal_irredpoly);

