
#include "comb/mixedradix.h"


#include "nextarg.h"  // NXARG()
#include "fxttypes.h"
#include "fxtalloca.h"
#include "fxtio.h"
#include "jjassert.h"

#include <cstdlib>  // strtoul()

//% Mixed radix counting.


//#define TIMING  // uncomment to disable printing

int
main(int argc, char **argv)
{
    ulong n = 3;
    NXARG(n, "Number of digits");

    ulong rr = 4;
    NXARG(rr, "Base (radix) of digits (0==>falling factorial, 1==>rising factorial)");
    ulong ct = 0;

#ifdef TIMING
    bool bq = 0;
    NXARG(bq, "Benchmark: whether to generate in backward order");
    mixedradix M(n, rr);

    if ( ! bq )
    {
        cout << "forward:" << endl;
        M.first();
        do  { ++ct; }  while ( M.next() );
    }
    else
    {
        cout << "backward:" << endl;
        M.last();
        do  { ++ct; }  while ( M.prev() );
    }

#else  // TIMING

    ALLOCA(ulong, r, n);
    for (ulong j=0; j<n; ++j)  r[j] = rr;
    RESTARGS("Optionally supply radix for all digits (rr ignored)");
    if ( argc>3 )  jjassert( argc == (int)n+3 );
    for (ulong k=3;  k<(ulong)argc; ++k)  r[k-3] = strtoul(argv[k], nullptr, 10);

    mixedradix M(n, rr, ( argc > 3 ? r : nullptr ) );
    M.print_nines("Nines: ");  cout << endl;

    do
    {
        cout << setw(6) << ct << ":";
        M.print("  ", true );
        cout << "  " << M.pos();
        cout << endl;
        ++ct;
    }
    while ( M.next() );
#endif  // TIMING

    cout << " ct=" << ct << endl;

    return 0;
}
// -------------------------

/*
Timing:
Timing: (Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz)

GCC 8.30

 time ./bin 30 2  ## binary is worst case
arg 1: 30 == n  [Number of digits]  default=3
arg 2: 2 == rr  [Base (radix) of digits (0==>falling factorial, 1==>rising factorial)]  default=4
arg 3: 0 == bq  [Benchmark: whether to generate in backward order]  default=0
forward:
 ct=1073741824
./bin 30 2  1.44s user 0.00s system 99% cpu 1.442 total
 ==> 1073741824/1.44 == 745,654,044 per second

 time ./bin 19 3
arg 1: 19 == n  [Number of digits]  default=3
arg 2: 3 == rr  [Base (radix) of digits (0==>falling factorial, 1==>rising factorial)]  default=4
arg 3: 0 == bq  [Benchmark: whether to generate in backward order]  default=0
forward:
 ct=1162261467
./bin 19 3  1.34s user 0.00s system 99% cpu 1.337 total
 ==> 1162261467/1.34 == 867,359,303 per second

 time ./bin 16 4
arg 1: 16 == n  [Number of digits]  default=3
arg 2: 4 == rr  [Base (radix) of digits (0==>falling factorial, 1==>rising factorial)]  default=4
arg 3: 0 == bq  [Benchmark: whether to generate in backward order]  default=0
forward:
 ct=4294967296
./bin 16 4  4.04s user 0.00s system 99% cpu 4.045 total
 ==> 4294967296/4.04 == 1,063,110,716 per second

 time ./bin 10 8
arg 1: 10 == n  [Number of digits]  default=3
arg 2: 8 == rr  [Base (radix) of digits (0==>falling factorial, 1==>rising factorial)]  default=4
arg 3: 0 == bq  [Benchmark: whether to generate in backward order]  default=0
forward:
 ct=1073741824
./bin 10 8  1.19s user 0.00s system 99% cpu 1.193 total
 ==> 1073741824/1.19 == 902,304,053 per second

 time ./bin 8 16
arg 1: 8 == n  [Number of digits]  default=3
arg 2: 16 == rr  [Base (radix) of digits (0==>falling factorial, 1==>rising factorial)]  default=4
arg 3: 0 == bq  [Benchmark: whether to generate in backward order]  default=0
forward:
 ct=4294967296
./bin 8 16  4.77s user 0.00s system 99% cpu 4.770 total
 ==> 4294967296/4.77 == 900,412,431 per second

 time ./bin 12 1  ## rising factorial
arg 1: 12 == n  [Number of digits]  default=3
arg 2: 1 == rr  [Base (radix) of digits (0==>falling factorial, 1==>rising factorial)]  default=4
arg 3: 0 == bq  [Benchmark: whether to generate in backward order]  default=0
forward:
 ct=6227020800
./bin 12 1  7.07s user 0.00s system 99% cpu 7.074 total
 ==> 6227020800/7.07 == 880,766,732 per second

 time ./bin 12 0  ## falling factorial
arg 1: 12 == n  [Number of digits]  default=3
arg 2: 0 == rr  [Base (radix) of digits (0==>falling factorial, 1==>rising factorial)]  default=4
arg 3: 0 == bq  [Benchmark: whether to generate in backward order]  default=0
forward:
 ct=6227020800
./bin 12 0  6.70s user 0.00s system 99% cpu 6.697 total
 ==> 6227020800/6.70 == 929,406,089 per second

*/


/*

BENCHARGS=30 2 0
BENCHARGS=30 2 1
BENCHARGS=19 3 0
BENCHARGS=19 3 1
BENCHARGS=16 4 0
BENCHARGS=16 4 1
BENCHARGS=10 8 0
BENCHARGS=10 8 1
BENCHARGS=8 16 0
BENCHARGS=8 16 1

BENCHARGS=12 0 0
BENCHARGS=12 0 1
BENCHARGS=12 1 0
BENCHARGS=12 1 1


*/


/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/mixedradix-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/mixedradix-demo.cc DEMOFLAGS=-DTIMING"
/// End:

