from fusil.project_agent import ProjectAgent
from termios import tcgetattr, tcsetattr, ECHO, TCSADRAIN
from sys import stdin, stdout

TERMIO_LFLAGS = 3

class TerminalEcho(ProjectAgent):
    def __init__(self, project):
        ProjectAgent.__init__(self, project, "terminal")

    def deinit(self):
        fd = stdin.fileno()
        state = tcgetattr(fd)
        if state[TERMIO_LFLAGS] & ECHO:
            return
        self.error("Terminal: restore echo mode to stdin")
        state[TERMIO_LFLAGS] = state[TERMIO_LFLAGS] | ECHO
        tcsetattr(fd, TCSADRAIN, state)


