from os.path import basename
from fusil.project_agent import ProjectAgent
from fusil.directory import Directory

class ProjectDirectory(ProjectAgent, Directory):
    def __init__(self, project):
        Directory.__init__(self, None)
        self.directory = self._uniqueFilename(None, 'run', count=1)
        ProjectAgent.__init__(self, project, "directory:%s" % basename(self.directory))
        self.warning("Create directory: %s" % self.directory)
        self.mkdir()

    def destroy(self):
        if self.isEmpty(True):
            self.info("Remove directory: %s" % self.directory)
            self.rmtree()
        else:
            self.error("Keep non-empty directory: %s" % self.directory)

    def uniqueFilename(self, name=None, count=None):
        return self._uniqueFilename(self.directory, name, count)

