/******************************************************************************
* This file is Copyright 1993 by Philip G. Richards.  All Rights Reserved.
* See the file README that came with this distribution for permissions on
* code usage, copying, and distribution.  It comes with absolutely no warranty.
* email: <pgr@prg.ox.ac.uk>
* Copyright 2005 by Radim Kolar
******************************************************************************/

/* ---INFOBEGIN--- *  DO NOT DELETE THIS COMMENT BLOCK!!!
COMMAND maxdelay none "set the maximum retry period (in milliseconds)"
 *  ---INFOEND---  */

#include "client.h"
#include "util.h"
#include "table.h"
#include <stdlib.h>

int
lmaxdelay_main(int argc, char *const *argv, char **envp)
{
    char *newdelaytime;

    if (argc < 2)
    {
	ffprintf(STDINFO, "maximum retry time set to %ld msec.\n", target_maxdelay);
	return 0;
    }
    else
	newdelaytime = argv[1];

    if (newdelaytime == (char*) 0)
	return 1;

    target_maxdelay = atoi(newdelaytime);
    if (target_maxdelay == 0)
       target_maxdelay = DEFAULTMAXDELAY;
    if (target_maxdelay < MINDELAY)
       target_maxdelay = MINDELAY;
    if (target_maxdelay > MAXDELAY)
       target_maxdelay = MAXDELAY;

    return 0;
}
