//==========================================================================
// Basic enum-related operations 
//
// (c) Microsoft Corporation 2005-2007.  
//=========================================================================

#light 

namespace Microsoft.FSharp.Core

open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections

/// Simple operations to convert between .NET enuemration types and integers
[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module Enum= 

    /// Convert an enumeration value to an integer.  The argument type is inferred from context.
    [<System.Obsolete("Use the 'int' or 'int32' conversion function instead. You may also need to add a type annotation to indicate the source enumeration type")>]
    val to_int: 'a -> int             when 'a :> System.Enum

    /// Convert an integer to an enumeration value.  The result type is inferred from context.
    [<System.Obsolete("Use the 'enum' conversion function instead, e.g. 'enum<EnumType>(3)'. You may also need to add a type annotation to indicate the source enumeration type")>]
    val of_int: int -> 'a             when 'a :> System.Enum

    /// Combine enum values using 'logical or'. The relevant enumeration type is inferred from context.
    [<System.Obsolete("Use the '|||' bitwise-or operator on enumeration values instead, e.g. 'e1 ||| e2 ||| e3'")>]
    val combine: 'a list -> 'a  when 'a :> System.Enum

    /// Test if an enumeration value has a particular flag set, using 'logical and'. 
    /// The relevant enumeration type is inferred from context.
    [<System.Obsolete("Use the '&&&' bitwise-and operator on enumeration values instead, e.g. 'e1 &&& e2 <> enum 0'")>]
    val test: 'a -> 'a -> bool   when 'a :> System.Enum
