// (c) Microsoft Corporation 2005-2007. 

#light

namespace System
    open Microsoft.FSharp.Core
    open Microsoft.FSharp.Core

#if CLI_AT_MOST_1_1
    type Converter            = delegate of obj -> obj
#else
    type Action<'A1,'A2>                   = delegate of 'A1 * 'A2 -> unit
    type Action<'A1,'A2,'A3>               = delegate of 'A1 * 'A2 * 'A3 -> unit
    type Action<'A1,'A2,'A3,'A4>           = delegate of 'A1 * 'A2 * 'A3 * 'A4 -> unit
    type Action<'A1,'A2,'A3,'A4,'A5>       = delegate of 'A1 * 'A2 * 'A3 * 'A4 * 'A5 -> unit
    type Converter<'A1,'A2,'B>             = delegate of 'A1 * 'A2 -> 'B
    type Converter<'A1,'A2,'A3,'B>         = delegate of 'A1 * 'A2 * 'A3 -> 'B
    type Converter<'A1,'A2,'A3,'A4,'B>     = delegate of 'A1 * 'A2 * 'A3 * 'A4 -> 'B
    type Converter<'A1,'A2,'A3,'A4,'A5,'B> = delegate of 'A1 * 'A2 * 'A3 * 'A4 * 'A5 -> 'B
#endif
    
namespace Microsoft.FSharp.Core
    open Microsoft.FSharp.Core
    open Microsoft.FSharp.Primitives.Basics
    open Microsoft.FSharp.Core.Operators
    open System

    type FuncConvert = 
#if CLI_AT_MOST_1_1
        [<OverloadID("Converter1")>]
        static member  ToFastFunc( f : Converter) = (fun t -> unbox (f.Invoke(box t)))
#else
    
        [<OverloadID("Action1")>]
        static member  ToFastFunc( f : Action<_>) = (fun t -> f.Invoke(t))
        [<OverloadID("Converter1")>]
        static member  ToFastFunc( f : Converter<_,_>) = (fun t -> f.Invoke(t))
        [<OverloadID("Action2")>]
        static member  ToFastFunc( f : Action<_,_>) = (fun a1 a2 -> f.Invoke(a1,a2))
        [<OverloadID("Converter2")>]
        static member  ToFastFunc( f : Converter<_,_,_>) = (fun a1 a2 -> f.Invoke(a1,a2))
        [<OverloadID("Action3")>]
        static member  ToFastFunc( f : Action<_,_,_>) = (fun a1 a2 a3 -> f.Invoke(a1,a2,a3))
        [<OverloadID("Converter3")>]
        static member  ToFastFunc( f : Converter<_,_,_,_>) = (fun a1 a2 a3 -> f.Invoke(a1,a2,a3))
        [<OverloadID("Action2")>]
        static member  ToTupledFastFunc( f : Action<_,_>) = (fun (a1,a2) -> f.Invoke(a1,a2))
        [<OverloadID("Converter2")>]
        static member  ToTupledFastFunc( f : Converter<_,_,_>) = (fun (a1,a2) -> f.Invoke(a1,a2))
        [<OverloadID("Action3")>]
        static member  ToTupledFastFunc( f : Action<_,_,_>) = (fun (a1,a2,a3) -> f.Invoke(a1,a2,a3))
        [<OverloadID("Converter3")>]
        static member  ToTupledFastFunc( f : Converter<_,_,_,_>) = (fun (a1,a2,a3) -> f.Invoke(a1,a2,a3))

        // This method is used by the CodeDOM provider when calling a delegate with a "tupled" function as an argument
        // (which is required because member methods must take tuple as an argument in CodeDOM)
        [<OverloadID("FuncFromTupled1")>]
        static member FuncFromTupled (f:'a -> 'b) = (fun a -> f a)
        [<OverloadID("FuncFromTupled2")>]
        static member FuncFromTupled (f:'a * 'b -> 'c) = (fun a b -> f (a, b))
        [<OverloadID("FuncFromTupled3")>]
        static member FuncFromTupled (f:'a * 'b * 'c -> 'd) = (fun a b c -> f (a, b, c))
        [<OverloadID("FuncFromTupled4")>]
        static member FuncFromTupled (f:'a * 'b * 'c * 'd -> 'e) = (fun a b c d -> f (a, b, c, d))
        [<OverloadID("FuncFromTupled5")>]
        static member FuncFromTupled (f:'a * 'b * 'c * 'd * 'e -> 'f) = (fun a b c d e-> f (a, b, c, d, e))
#endif

