#!/usr/bin/perl -w 
# -*- Perl -*-
# $Id: fs-check.t.in,v 1.13 2006/02/25 18:48:36 rockyb Exp $
use strict;
# require 'driver-init.pl';

my $test='fs-check';

# Remove any timestamp files
system("rm -f /tmp/fs-check*.timestamp");

print "1..6\n";


#
# First simple test -- nothing should trigger.
#
my @output=`../fs-check --pidfile ./fs-check.pid --df ../test/bogus-df --mail mailtest -n -v -1 -f ./fs-check-t1.cnf 2>&1`;

if (!open(TEST_LOG, "<", "./fs-check-t1.log")) {
  print "not ok 1\n";
  print "not ok 2\n";
} else {
  print "ok 1\n";
  my @good_output=<TEST_LOG>;
  close(TEST_LOG);

  # Remove top_builddir differences.
  $output[1] =~ s|program:.*bogus-df|program: bogus-df|;
  $good_output[1] =~ s|program:.*bogus-df|program: bogus-df|;

  if (@good_output != @output) {
    print "not ok 2\n";
  } else {
    my $i=0;
    for ($i=0; $i <= $#good_output; $i++) {
      last if $good_output[$i] ne $output[$i];
    }
    printf "%sok 2\n", ($i == @good_output) ? "" : "not ";
  }
}

#
# Check basic operation when a threshhold is exceeded.
#

# Remove any timestamp files
system("rm -f /tmp/fs-check*.timestamp");

@output=`../fs-check --pidfile ./fs-check.pid --noinode --df ../test/bogus-df --mail mailtest -n -v -1 -f ./fs-check-t2.cnf 2>&1`;

if (!open(TEST_LOG, "<", "./fs-check-t2.log")) {
  print "not ok 3\n";
  print "not ok 4\n";
} else {
  print "ok 3\n";
  my @good_output=<TEST_LOG>;
  close(TEST_LOG);
  if (@good_output != @output) {
    print "not ok 4\n";
  } else {
    my $i=0;
    # Remove top_builddir differences.
    $output[1] =~ s|program:.*bogus-df|program: bogus-df|;
    $good_output[1] =~ s|program:.*bogus-df|program: bogus-df|;
    for ($i=0; $i <= $#good_output; $i++) {
      if ($i == 17) {
	last if $output[17] !~
	m|ALERT: .* disks filling \(/: 27%>=10%, /usr: 50%>=20%\).|
      } else {
	  if ($good_output[$i] ne $output[$i]) {
	    print "good: $good_output[$i]\n";
	    print "saw : $output[$i]\n";
	    last;
	  }
      }
    }
    printf "%sok 4\n", ($i == @good_output) ? "" : "not ";
  }
}

#
# Check that inode testing works.
#

# Remove any timestamp files
system("rm -f /tmp/fs-check*.timestamp");

if (1) {
  @output=`../fs-check --pidfile ./fs-check.pid --df ../test/bogus-df --mail mailtest -n -v -1 -f ./fs-check-ti.cnf 2>&1`;

  if (!open(TEST_LOG, "<", "./fs-check-ti.log")) {
    print "not ok 5\n";
    print "not ok 6\n";
  } else {
    print "ok 5\n";
    my @good_output=<TEST_LOG>;
    close(TEST_LOG);

    # Remove top_builddir differences.
    $output[1] =~ s|program:.*bogus-df|program: bogus-df|;
    $good_output[1] =~ s|program:.*bogus-df|program: bogus-df|;

    if (@good_output != @output) {
      print "not ok 6\n";
    } else {
      my $i=0;
      for ($i=0; $i <= $#good_output; $i++) {
	if ($i == 16) {
	  last if $output[16] !~
	    m|ALERT: .* disks filling \(/: 27%>=10%, /usr: 50%>=20%\).|
	  } else {
  	    if ($good_output[$i] ne $output[$i]) {
	      print "good: $good_output[$i]\n";
	      print "saw : $output[$i]\n";
	      last;
	    }
	  }
      }
      printf "%sok 6\n", ($i == @good_output) ? "" : "not ";
    }
  }
} else {
  print "ok 5\n"; # skip Your df doesn't support --inodes
  print "ok 6\n"; # skip Your df doesn't support --inodes
}
