
#include <iostream>
#include "freeling.h"
#include "freeling/morfo/util.h"
#include "freeling/morfo/traces.h"

using namespace std;
using namespace freeling;


list<analysis> printRetokenizable(const list<word> &rtk, list<word>::const_iterator w, const wstring &lem, const wstring &tag) {
  
  list<analysis> s;
  if (w==rtk.end()) 
    s.push_back(analysis(lem.substr(1),tag.substr(1)));
		
  else {
    list<analysis> s1;
    list<word>::const_iterator w1=w; w1++;
    for (word::const_iterator a=w->begin(); a!=w->end(); a++) {
      s1=printRetokenizable(rtk, w1, lem+L"+"+a->get_lemma(), tag+L"+"+a->get_tag());
      s.splice(s.end(),s1);
    }
  }
  return s;
}  


int main(int argc, char *argv[]) {

  util::init_locale(L"default");

  wstring form,lemma,tag,dummy;
  wstring lang(util::string2wstring(argv[1]));
  wstring path(util::string2wstring(argv[2]));
  path=path+lang+L"/";

  maco_options opt(lang);  

  traces::TraceLevel=0;
  traces::TraceModule=0xFFFFF;

  // alternatively, you can set active modules in a single call:
  opt.set_active_modules(false, true, false, true, false, false, false, true, true, false, false);

  // and provide files for morphological submodules. Note that it is not necessary
  // to set opt.QuantitiesFile, since Quantities module was deactivated.  
  opt.set_data_files(L"", L"", L"", 
                     path+L"afixos.dat", path+L"probabilitats.dat", 
                     opt.DictionaryFile=path+L"dicc.src",
                     L"", L"", L"");

  // create the analyzer with the just build set of maco_options
  maco morfo(opt); 

  wstring line;
  while (getline(wcin,line)) {

    if (line.empty()) 
      // empty line, keep it (sentence split)
      wcout<<endl;

    else {

      wistringstream sin;
      sin.str (line);
      
      sin >> form >> lemma >> tag >> dummy; 	// get word form, plus "#"
      
      if (tag[0]==L'Z' or tag[0]==L'W' or tag[0]==L'F' or tag.substr(0,2)==L"NP" or form.find(L"_")!=wstring::npos)
	// Z, W, F, NP, or multiword:  keep as is.
	wcout<<line<<endl;
      
      else {
	// other words, analyze
	
	word w(form);
	sentence s; s.push_back(w);
	list<sentence> ls; ls.push_back(s);
	
	morfo.analyze(ls);
	wcout<<form<<L" "<<lemma<<L" "<<tag<<L" "<<dummy;
	for (word::iterator a=ls.begin()->begin()->begin(); a!=ls.begin()->begin()->end(); a++) {

	  if (a->is_retokenizable ()) {
	    list <word> rtk = a->get_retokenizable ();
	    list <analysis> la=printRetokenizable(rtk, rtk.begin(), L"", L"");
	    for (list<analysis>::iterator x=la.begin(); x!=la.end(); x++) {
	      wcout << L" " << x->get_lemma() << L" " << x->get_tag() << L" " << a->get_prob()/la.size();
	    }
	  }
	  else 
	    wcout<<L" "<<a->get_lemma()<<L" "<<a->get_tag()<<L" "<<a->get_prob();
	}
	wcout<<endl;      
      } 
    }
  }
}
