////////////////////////////////////////////////////////////////
//
//    FreeLing - Open Source Language Analyzers
//
//    Copyright (C) 2004   TALP Research Center
//                         Universitat Politecnica de Catalunya
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU General Public
//    License as published by the Free Software Foundation; either
//    version 3 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    General Public License for more details.
//
//    You should have received a copy of the GNU General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//    contact: Lluis Padro (padro@lsi.upc.es)
//             TALP Research Center
//             despatx C6.212 - Campus Nord UPC
//             08034 Barcelona.  SPAIN
//
////////////////////////////////////////////////////////////////

#ifndef _FREELING
#define _FREELING

#include "freeling/windll.h"

#include "freeling/version.h"

#include "freeling/morfo/lang_ident.h"
#include "freeling/morfo/tokenizer.h"
#include "freeling/morfo/tagset.h"
#include "freeling/morfo/splitter.h"
#include "freeling/morfo/maco.h"
#include "freeling/morfo/nec.h"
#include "freeling/morfo/phonetics.h"
#include "freeling/morfo/alternatives.h"
#include "freeling/morfo/senses.h"
#include "freeling/morfo/ukb.h"
#include "freeling/morfo/semdb.h"
#include "freeling/morfo/hmm_tagger.h"
#include "freeling/morfo/relax_tagger.h"
#include "freeling/morfo/chart_parser.h"
#include "freeling/morfo/dependency_parser.h"
#include "freeling/morfo/dependencies.h"
#include "freeling/morfo/coref.h"
#include "freeling/morfo/fex.h"

#include "freeling/omlet/adaboost.h"
#include "freeling/omlet/dataset.h"
#include "freeling/omlet/example.h"
#include "freeling/omlet/weakrule.h"
#include "freeling/omlet/viterbi.h"
#include "freeling/omlet/svm.h"

#endif
