/***************************************************************************
 *   Copyright (c) 2011 Joe Dowsett <j-dowsett[at]users.sourceforge.net>   *
 *   Copyright (c) 2014  Luke Parry <l.parry@warwick.ac.uk>                *
 *                                                                         *
 *   This file is part of the FreeCAD CAx development system.              *
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Library General Public           *
 *   License as published by the Free Software Foundation; either          *
 *   version 2 of the License, or (at your option) any later version.      *
 *                                                                         *
 *   This library  is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU Library General Public License for more details.                  *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this library; see the file COPYING.LIB. If not,    *
 *   write to the Free Software Foundation, Inc., 59 Temple Place,         *
 *   Suite 330, Boston, MA  02111-1307, USA                                *
 *                                                                         *
 ***************************************************************************/

#ifndef GUI_TASKVIEW_TASKVIEWGROUP_H
#define GUI_TASKVIEW_TASKVIEWGROUP_H

#include <QString>

#include <Base/BoundBox.h>
#include <Base/Vector3D.h>
#include <Gui/TaskView/TaskView.h>
#include <Gui/TaskView/TaskDialog.h>

#include "MDIViewPage.h"

#include <Mod/TechDraw/Gui/ui_TaskProjGroup.h>

#include <Mod/TechDraw/App/DrawProjGroup.h>
#include <Mod/TechDraw/App/DrawProjGroupItem.h>


class Ui_TaskProjGroup;

namespace TechDraw {
class DrawProjGroup;
class DrawPage;
}

namespace TechDrawGui
{
class MDIViewPage;
class ViewProviderProjGroup;

class TaskProjGroup : public QWidget
{
    Q_OBJECT

public:
    TaskProjGroup(TechDraw::DrawProjGroup* featView, bool mode);
    ~TaskProjGroup();

public:
    virtual bool accept();
    virtual bool reject();
    void updateTask();
    std::pair<int, int> nearestFraction(const double val, const long int maxDenom = 999) const;
    // Sets the numerator and denominator widgets to match newScale
    void setFractionalScale(double newScale);
    void setCreateMode(bool b) { m_createMode = b;}
    bool getCreateMode() { return m_createMode; }

protected Q_SLOTS:
    void viewToggled(bool toggle);

    /// Requests appropriate rotation of our DrawProjGroup
    void rotateButtonClicked(void);

    void on3DClicked(void);
    void onResetClicked(void);
    
    void projectionTypeChanged(int index);
    void scaleTypeChanged(int index);
    void scaleManuallyChanged(int i);

protected:
    void changeEvent(QEvent *e);

    /// Connects and updates state of view checkboxes to match the state of multiView
    /*!
     * If addConnections is true, then also sets up Qt connections
     * between checkboxes and viewToggled()
     */
    void setupViewCheckboxes(bool addConnections = false);
    std::pair<Base::Vector3d,Base::Vector3d> get3DViewDir(void);
    void setUiPrimary(void);
    QString formatVector(Base::Vector3d v);

private:
    //class Private;
    Ui_TaskProjGroup * ui;
    bool blockUpdate;
    /// Translate a view checkbox index into represented view string, depending on projection type
    const char * viewChkIndexToCStr(int index);

protected:
  //ViewProviderProjGroup *viewProvider;
  TechDraw::DrawProjGroup* multiView;
  bool m_createMode;
  TechDraw::DrawPage* m_page;
  MDIViewPage* m_mdi;

};

/// Simulation dialog for the TaskView
class TaskDlgProjGroup : public Gui::TaskView::TaskDialog
{
    Q_OBJECT

public:
    TaskDlgProjGroup(TechDraw::DrawProjGroup* featView,bool mode);
    ~TaskDlgProjGroup();

    const ViewProviderProjGroup * getViewProvider() const { return viewProvider; }
    TechDraw::DrawProjGroup * getMultiView() const { return multiView; }
public:
    /// is called the TaskView when the dialog is opened
    virtual void open();
    /// is called by the framework if an button is clicked which has no accept or reject role
    virtual void clicked(int);
    /// is called by the framework if the dialog is accepted (Ok)
    virtual bool accept();
    /// is called by the framework if the dialog is rejected (Cancel)
    virtual bool reject();
    /// is called by the framework if the user presses the help button
    virtual void helpRequested() { return;}
    virtual bool isAllowedAlterDocument(void) const
    { return false; }
    void setCreateMode(bool b);

    void update();

protected:
    const ViewProviderProjGroup *viewProvider;
    TechDraw::DrawProjGroup *multiView;

private:
    TaskProjGroup * widget;
    Gui::TaskView::TaskBox* taskbox;
};

} //namespace TechDrawGui

#endif // #ifndef GUI_TASKVIEW_TASKVIEWGROUP_H
