/*
 * Decompiled with CFR 0.152.
 */
package fpc.tools.javapp;

import fpc.tools.javapp.JavapEnvironment;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSignature {
    String parameters = null;
    String parameterdes = null;
    String returntype = null;
    String fieldtype = null;
    int argumentlength = 0;

    protected TypeSignature() {
    }

    public TypeSignature(String JVMSignature) {
        this.init(JVMSignature);
    }

    protected void init(String JVMSignature) {
        if (JVMSignature != null) {
            if (JVMSignature.indexOf("(") == -1) {
                this.fieldtype = this.getFieldTypeSignature(JVMSignature);
            } else {
                if (JVMSignature.indexOf(")") - 1 > JVMSignature.indexOf("(")) {
                    this.parameterdes = JVMSignature.substring(JVMSignature.indexOf("(") + 1, JVMSignature.indexOf(")"));
                    this.parameters = this.getParametersHelper(this.parameterdes);
                } else {
                    this.parameters = "()";
                }
                String returndes = JVMSignature.substring(JVMSignature.lastIndexOf(")") + 1);
                this.returntype = this.getReturnTypeHelper(returndes);
            }
        }
    }

    public static boolean checkAccess(String[] accflags, JavapEnvironment env) {
        boolean ispublic = false;
        boolean isprotected = false;
        boolean isprivate = false;
        boolean ispackage = false;
        int i = 0;
        while (i < accflags.length) {
            if (accflags[i].equals("public")) {
                ispublic = true;
            } else if (accflags[i].indexOf("protected") != -1) {
                isprotected = true;
            } else if (accflags[i].indexOf("private") != -1) {
                isprivate = true;
            }
            ++i;
        }
        if (!(ispublic || isprotected || isprivate)) {
            ispackage = true;
        }
        if (env.showAccess == 3 && (isprotected || isprivate || ispackage)) {
            return false;
        }
        if (env.showAccess == 1 && (isprivate || ispackage)) {
            return false;
        }
        return env.showAccess != 2 || !isprivate;
    }

    public String getFieldTypeSignature(String fielddes) {
        if (fielddes.startsWith("L")) {
            return this.getObjectType(fielddes);
        }
        if (fielddes.startsWith("[")) {
            return this.getArrayType(fielddes);
        }
        return this.getBaseType(fielddes);
    }

    public Vector<String> getParametersList(String parameterdes) {
        Vector<String> parameters = new Vector<String>();
        int startindex = -1;
        int endindex = -1;
        String param = "";
        while (parameterdes != null) {
            if (parameterdes.startsWith("L")) {
                startindex = parameterdes.indexOf("L");
                endindex = parameterdes.indexOf(";");
                if (startindex >= parameterdes.length()) continue;
                if (endindex == parameterdes.length() - 1) {
                    param = parameterdes.substring(startindex);
                    parameterdes = null;
                } else if (endindex + 1 < parameterdes.length()) {
                    param = parameterdes.substring(startindex, endindex + 1);
                    parameterdes = parameterdes.substring(endindex + 1);
                }
                parameters.add(this.getObjectType(param));
                continue;
            }
            if (parameterdes.startsWith("[")) {
                int stotherparam;
                String componentType = "";
                int enddim = -1;
                int st = 0;
                while (st < parameterdes.length() && parameterdes.charAt(st) == '[') {
                    enddim = st++;
                }
                if (enddim + 1 < parameterdes.length()) {
                    param = parameterdes.substring(0, enddim + 1);
                }
                if ((stotherparam = param.lastIndexOf("[") + 1) < parameterdes.length()) {
                    componentType = parameterdes.substring(stotherparam);
                }
                if (componentType.startsWith("L")) {
                    startindex = parameterdes.indexOf("L");
                    endindex = parameterdes.indexOf(";");
                    if (endindex == parameterdes.length() - 1) {
                        param = String.valueOf(param) + parameterdes.substring(startindex);
                        parameterdes = null;
                    } else if (endindex + 1 < parameterdes.length()) {
                        param = String.valueOf(param) + parameterdes.substring(startindex, endindex + 1);
                        parameterdes = parameterdes.substring(endindex + 1);
                    }
                } else if (componentType.length() == 1) {
                    param = String.valueOf(param) + componentType;
                    parameterdes = null;
                } else if (componentType.length() > 1) {
                    param = String.valueOf(param) + componentType.substring(0, 1);
                    parameterdes = componentType.substring(1);
                }
                parameters.add(this.getArrayType(param));
                continue;
            }
            if (parameterdes.length() == 1) {
                param = parameterdes;
                parameterdes = null;
            } else if (parameterdes.length() > 1) {
                param = parameterdes.substring(0, 1);
                parameterdes = parameterdes.substring(1);
            }
            parameters.add(this.getBaseType(param));
        }
        return parameters;
    }

    public String getParametersHelper(String parameterdes) {
        Vector<String> parameters = this.getParametersList(parameterdes);
        String parametersignature = this.parameterSignatureFromParameters(parameters);
        return parametersignature;
    }

    public String getReturnTypeHelper(String returndes) {
        return this.getFieldTypeSignature(returndes);
    }

    public String getBaseType(String baseType) {
        if (baseType != null) {
            if (baseType.equals("B")) {
                return "byte";
            }
            if (baseType.equals("C")) {
                return "char";
            }
            if (baseType.equals("D")) {
                return "double";
            }
            if (baseType.equals("F")) {
                return "float";
            }
            if (baseType.equals("I")) {
                return "int";
            }
            if (baseType.equals("J")) {
                return "long";
            }
            if (baseType.equals("S")) {
                return "short";
            }
            if (baseType.equals("Z")) {
                return "boolean";
            }
            if (baseType.equals("V")) {
                return "void";
            }
        }
        return null;
    }

    public String getObjectType(String JVMobjectType) {
        String objectType = "";
        int startindex = JVMobjectType.indexOf("L") + 1;
        int endindex = JVMobjectType.indexOf(";");
        if (startindex != -1 && endindex != -1) {
            if (startindex < JVMobjectType.length() && endindex < JVMobjectType.length()) {
                objectType = JVMobjectType.substring(startindex, endindex);
            }
            objectType = objectType.replace('/', '.');
            return objectType;
        }
        return null;
    }

    public String getArrayType(String arrayType) {
        if (arrayType != null) {
            String dimention = "";
            while (arrayType.indexOf("[") != -1) {
                dimention = String.valueOf(dimention) + "[]";
                int startindex = arrayType.indexOf("[") + 1;
                if (startindex > arrayType.length()) continue;
                arrayType = arrayType.substring(startindex);
            }
            String componentType = "";
            componentType = arrayType.startsWith("L") ? this.getObjectType(arrayType) : this.getBaseType(arrayType);
            return String.valueOf(componentType) + dimention;
        }
        return null;
    }

    public String getParameters() {
        return this.parameters;
    }

    public String getReturnType() {
        return this.returntype;
    }

    public String getFieldType() {
        return this.fieldtype;
    }

    public int getArgumentlength() {
        return this.argumentlength;
    }

    protected String parameterSignatureFromParameters(Vector<String> parameters) {
        this.argumentlength = parameters.size();
        String parametersignature = "(";
        int i = 0;
        while (i < parameters.size()) {
            parametersignature = String.valueOf(parametersignature) + parameters.elementAt(i);
            if (i != parameters.size() - 1) {
                parametersignature = String.valueOf(parametersignature) + ", ";
            }
            ++i;
        }
        parametersignature = String.valueOf(parametersignature) + ")";
        return parametersignature;
    }
}

