---
project: Fortran-lang/stdlib
summary: A community driven standard library for (modern) Fortran
src_dir: src
include: src
         include
exclude_dir: src/tests
output_dir: API-doc
page_dir: doc
media_dir: doc/media
fpp_extensions: fypp
preprocess: true
macro: MAXRANK=3
       PROJECT_VERSION_MAJOR=0
       PROJECT_VERSION_MINOR=0
       PROJECT_VERSION_PATCH=0
preprocessor: fypp
display: public
         protected
source: true
proc_internals: true
md_extensions: markdown.extensions.toc
graph: true
graph_maxnodes: 250
graph_maxdepth: 5
coloured_edges: true
sort: permission-alpha
extra_mods: iso_fortran_env:https://gcc.gnu.org/onlinedocs/gfortran/ISO_005fFORTRAN_005fENV.html
            iso_c_binding:https://gcc.gnu.org/onlinedocs/gfortran/ISO_005fC_005fBINDING.html#ISO_005fC_005fBINDING
print_creation_date: true
creation_date: %Y-%m-%d %H:%M %z
project_github: https://github.com/fortran-lang/stdlib
project_download: https://github.com/fortran-lang/stdlib/archive/HEAD.zip
project_website: https://stdlib.fortran-lang.org
favicon: doc/media/favicon.ico
license: by-sa
author: fortran-lang/stdlib contributors
author_pic: https://fortran-lang.org/assets/img/fortran_logo_512x512.png
author_email: fortran-lang@groups.io
github: https://github.com/fortran-lang
twitter: https://twitter.com/fortranlang
website: https://fortran-lang.org
dbg: true
---

[TOC]

@warning This API documentation for the Fortran-lang/stdlib is a work in progress

@note
Use the navigation bar at the top of the screen to browse modules, procedures, source files, etc.
The listings near the bottom of the page are incomplete.

Fortran stdlib API Documentation
================================

This is the main API documentation landing page generated by [FORD].
The documentation for comment markup in source code, running [FORD] and the [FORD project file] are all maintained on the [FORD wiki].

[FORD]: https://github.com/Fortran-FOSS-Programmers/ford#readme
[FORD wiki]: https://github.com/Fortran-FOSS-Programmers/ford/wiki
[FORD project file]: https://github.com/fortran-lang/stdlib/blob/HEAD/API-doc-FORD-file.md

Goals and Motivation
====================

The Fortran Standard, as published by the ISO (https://wg5-fortran.org/), does
not have a Standard Library. The goal of this project is to provide a community
driven and agreed upon *de facto* "standard" library for Fortran, called a
Fortran Standard Library (`stdlib`). We have a rigorous process how `stdlib` is
developed as documented in our [Workflow](page/contributing/Workflow.html). `stdlib` is both a
specification and a reference implementation. We are cooperating with the
Fortran Standards Committee (e.g., the effort
[started](https://github.com/j3-fortran/fortran_proposals/issues/104) at the J3
committee repository) and the plan is to continue working with the Committee in
the future (such as in the step 5. in the [Workflow](page/contributing/Workflow.html) document), so
that if the Committee wants to standardize some feature already available in `stdlib`, it would
base it on `stdlib`'s implementation.

Scope
=====

The goal of the Fortran Standard Library is to achieve the following general scope:

* Utilities (containers, strings, files, OS/environment integration, unit
  testing & assertions, logging,  ...)
* Algorithms (searching and sorting, merging, ...)
* Mathematics (linear algebra, sparse matrices, special functions, fast Fourier
  transform, random numbers, statistics, ordinary differential equations,
  numerical integration, optimization, ...)

Code of Conduct
===============

In the interest of fostering an open and welcoming environment, we as contributors and maintainers pledge to make participation in our project and our community a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, gender identity and expression, level of experience, nationality, personal appearance, race, religion, or sexual identity and orientation. Please read first [this Code of Conduct](./page/contributing/CodeOfConduct.html)

License
=======

The `stdlib` source code and related files and documentation are distributed under the [MIT license](page/License.html).
