module stdlib_linalg_lapack_z
     use stdlib_linalg_constants
     use stdlib_linalg_blas
     use stdlib_linalg_lapack_aux
     use stdlib_linalg_lapack_s
     use stdlib_linalg_lapack_d
     use stdlib_linalg_lapack_c
     implicit none(type, external)
     private

     public :: sp, dp, lk, ilp
     public :: stdlib_zbbcsd
     public :: stdlib_zbdsqr
     public :: stdlib_zcgesv
     public :: stdlib_zcposv
     public :: stdlib_zdrscl
     public :: stdlib_zgbbrd
     public :: stdlib_zgbcon
     public :: stdlib_zgbequ
     public :: stdlib_zgbequb
     public :: stdlib_zgbrfs
     public :: stdlib_zgbsv
     public :: stdlib_zgbsvx
     public :: stdlib_zgbtf2
     public :: stdlib_zgbtrf
     public :: stdlib_zgbtrs
     public :: stdlib_zgebak
     public :: stdlib_zgebal
     public :: stdlib_zgebd2
     public :: stdlib_zgebrd
     public :: stdlib_zgecon
     public :: stdlib_zgeequ
     public :: stdlib_zgeequb
     public :: stdlib_zgees
     public :: stdlib_zgeesx
     public :: stdlib_zgeev
     public :: stdlib_zgeevx
     public :: stdlib_zgehd2
     public :: stdlib_zgehrd
     public :: stdlib_zgejsv
     public :: stdlib_zgelq
     public :: stdlib_zgelq2
     public :: stdlib_zgelqf
     public :: stdlib_zgelqt
     public :: stdlib_zgelqt3
     public :: stdlib_zgels
     public :: stdlib_zgelsd
     public :: stdlib_zgelss
     public :: stdlib_zgelsy
     public :: stdlib_zgemlq
     public :: stdlib_zgemlqt
     public :: stdlib_zgemqr
     public :: stdlib_zgemqrt
     public :: stdlib_zgeql2
     public :: stdlib_zgeqlf
     public :: stdlib_zgeqp3
     public :: stdlib_zgeqr
     public :: stdlib_zgeqr2
     public :: stdlib_zgeqr2p
     public :: stdlib_zgeqrf
     public :: stdlib_zgeqrfp
     public :: stdlib_zgeqrt
     public :: stdlib_zgeqrt2
     public :: stdlib_zgeqrt3
     public :: stdlib_zgerfs
     public :: stdlib_zgerq2
     public :: stdlib_zgerqf
     public :: stdlib_zgesc2
     public :: stdlib_zgesdd
     public :: stdlib_zgesv
     public :: stdlib_zgesvd
     public :: stdlib_zgesvdq
     public :: stdlib_zgesvj
     public :: stdlib_zgesvx
     public :: stdlib_zgetc2
     public :: stdlib_zgetf2
     public :: stdlib_zgetrf
     public :: stdlib_zgetrf2
     public :: stdlib_zgetri
     public :: stdlib_zgetrs
     public :: stdlib_zgetsls
     public :: stdlib_zgetsqrhrt
     public :: stdlib_zggbak
     public :: stdlib_zggbal
     public :: stdlib_zgges
     public :: stdlib_zgges3
     public :: stdlib_zggesx
     public :: stdlib_zggev
     public :: stdlib_zggev3
     public :: stdlib_zggevx
     public :: stdlib_zggglm
     public :: stdlib_zgghd3
     public :: stdlib_zgghrd
     public :: stdlib_zgglse
     public :: stdlib_zggqrf
     public :: stdlib_zggrqf
     public :: stdlib_zgsvj0
     public :: stdlib_zgsvj1
     public :: stdlib_zgtcon
     public :: stdlib_zgtrfs
     public :: stdlib_zgtsv
     public :: stdlib_zgtsvx
     public :: stdlib_zgttrf
     public :: stdlib_zgttrs
     public :: stdlib_zgtts2
     public :: stdlib_zhb2st_kernels
     public :: stdlib_zhbev
     public :: stdlib_zhbevd
     public :: stdlib_zhbevx
     public :: stdlib_zhbgst
     public :: stdlib_zhbgv
     public :: stdlib_zhbgvd
     public :: stdlib_zhbgvx
     public :: stdlib_zhbtrd
     public :: stdlib_zhecon
     public :: stdlib_zhecon_rook
     public :: stdlib_zheequb
     public :: stdlib_zheev
     public :: stdlib_zheevd
     public :: stdlib_zheevr
     public :: stdlib_zheevx
     public :: stdlib_zhegs2
     public :: stdlib_zhegst
     public :: stdlib_zhegv
     public :: stdlib_zhegvd
     public :: stdlib_zhegvx
     public :: stdlib_zherfs
     public :: stdlib_zhesv
     public :: stdlib_zhesv_aa
     public :: stdlib_zhesv_rk
     public :: stdlib_zhesv_rook
     public :: stdlib_zhesvx
     public :: stdlib_zheswapr
     public :: stdlib_zhetd2
     public :: stdlib_zhetf2
     public :: stdlib_zhetf2_rk
     public :: stdlib_zhetf2_rook
     public :: stdlib_zhetrd
     public :: stdlib_zhetrd_hb2st
     public :: stdlib_zhetrd_he2hb
     public :: stdlib_zhetrf
     public :: stdlib_zhetrf_aa
     public :: stdlib_zhetrf_rk
     public :: stdlib_zhetrf_rook
     public :: stdlib_zhetri
     public :: stdlib_zhetri_rook
     public :: stdlib_zhetrs
     public :: stdlib_zhetrs2
     public :: stdlib_zhetrs_3
     public :: stdlib_zhetrs_aa
     public :: stdlib_zhetrs_rook
     public :: stdlib_zhfrk
     public :: stdlib_zhgeqz
     public :: stdlib_zhpcon
     public :: stdlib_zhpev
     public :: stdlib_zhpevd
     public :: stdlib_zhpevx
     public :: stdlib_zhpgst
     public :: stdlib_zhpgv
     public :: stdlib_zhpgvd
     public :: stdlib_zhpgvx
     public :: stdlib_zhprfs
     public :: stdlib_zhpsv
     public :: stdlib_zhpsvx
     public :: stdlib_zhptrd
     public :: stdlib_zhptrf
     public :: stdlib_zhptri
     public :: stdlib_zhptrs
     public :: stdlib_zhsein
     public :: stdlib_zhseqr
     public :: stdlib_zla_gbamv
     public :: stdlib_zla_gbrcond_c
     public :: stdlib_zla_gbrpvgrw
     public :: stdlib_zla_geamv
     public :: stdlib_zla_gercond_c
     public :: stdlib_zla_gerpvgrw
     public :: stdlib_zla_heamv
     public :: stdlib_zla_hercond_c
     public :: stdlib_zla_herpvgrw
     public :: stdlib_zla_lin_berr
     public :: stdlib_zla_porcond_c
     public :: stdlib_zla_porpvgrw
     public :: stdlib_zla_syamv
     public :: stdlib_zla_syrcond_c
     public :: stdlib_zla_syrpvgrw
     public :: stdlib_zla_wwaddw
     public :: stdlib_zlabrd
     public :: stdlib_zlacgv
     public :: stdlib_zlacn2
     public :: stdlib_zlacon
     public :: stdlib_zlacp2
     public :: stdlib_zlacpy
     public :: stdlib_zlacrm
     public :: stdlib_zlacrt
     public :: stdlib_zladiv
     public :: stdlib_zlaed0
     public :: stdlib_zlaed7
     public :: stdlib_zlaed8
     public :: stdlib_zlaein
     public :: stdlib_zlaesy
     public :: stdlib_zlaev2
     public :: stdlib_zlag2c
     public :: stdlib_zlags2
     public :: stdlib_zlagtm
     public :: stdlib_zlahef
     public :: stdlib_zlahef_aa
     public :: stdlib_zlahef_rk
     public :: stdlib_zlahef_rook
     public :: stdlib_zlahqr
     public :: stdlib_zlahr2
     public :: stdlib_zlaic1
     public :: stdlib_zlals0
     public :: stdlib_zlalsa
     public :: stdlib_zlalsd
     public :: stdlib_zlamswlq
     public :: stdlib_zlamtsqr
     public :: stdlib_zlangb
     public :: stdlib_zlange
     public :: stdlib_zlangt
     public :: stdlib_zlanhb
     public :: stdlib_zlanhe
     public :: stdlib_zlanhf
     public :: stdlib_zlanhp
     public :: stdlib_zlanhs
     public :: stdlib_zlanht
     public :: stdlib_zlansb
     public :: stdlib_zlansp
     public :: stdlib_zlansy
     public :: stdlib_zlantb
     public :: stdlib_zlantp
     public :: stdlib_zlantr
     public :: stdlib_zlapll
     public :: stdlib_zlapmr
     public :: stdlib_zlapmt
     public :: stdlib_zlaqgb
     public :: stdlib_zlaqge
     public :: stdlib_zlaqhb
     public :: stdlib_zlaqhe
     public :: stdlib_zlaqhp
     public :: stdlib_zlaqp2
     public :: stdlib_zlaqps
     public :: stdlib_zlaqr0
     public :: stdlib_zlaqr1
     public :: stdlib_zlaqr2
     public :: stdlib_zlaqr3
     public :: stdlib_zlaqr4
     public :: stdlib_zlaqr5
     public :: stdlib_zlaqsb
     public :: stdlib_zlaqsp
     public :: stdlib_zlaqsy
     public :: stdlib_zlaqz0
     public :: stdlib_zlaqz1
     public :: stdlib_zlaqz2
     public :: stdlib_zlaqz3
     public :: stdlib_zlar1v
     public :: stdlib_zlar2v
     public :: stdlib_zlarcm
     public :: stdlib_zlarf
     public :: stdlib_zlarfb
     public :: stdlib_zlarfb_gett
     public :: stdlib_zlarfg
     public :: stdlib_zlarfgp
     public :: stdlib_zlarft
     public :: stdlib_zlarfx
     public :: stdlib_zlarfy
     public :: stdlib_zlargv
     public :: stdlib_zlarnv
     public :: stdlib_zlarrv
     public :: stdlib_zlartg
     public :: stdlib_zlartv
     public :: stdlib_zlarz
     public :: stdlib_zlarzb
     public :: stdlib_zlarzt
     public :: stdlib_zlascl
     public :: stdlib_zlaset
     public :: stdlib_zlasr
     public :: stdlib_zlassq
     public :: stdlib_zlaswlq
     public :: stdlib_zlaswp
     public :: stdlib_zlasyf
     public :: stdlib_zlasyf_aa
     public :: stdlib_zlasyf_rk
     public :: stdlib_zlasyf_rook
     public :: stdlib_zlat2c
     public :: stdlib_zlatbs
     public :: stdlib_zlatdf
     public :: stdlib_zlatps
     public :: stdlib_zlatrd
     public :: stdlib_zlatrs
     public :: stdlib_zlatrz
     public :: stdlib_zlatsqr
     public :: stdlib_zlaunhr_col_getrfnp
     public :: stdlib_zlaunhr_col_getrfnp2
     public :: stdlib_zlauu2
     public :: stdlib_zlauum
     public :: stdlib_zpbcon
     public :: stdlib_zpbequ
     public :: stdlib_zpbrfs
     public :: stdlib_zpbstf
     public :: stdlib_zpbsv
     public :: stdlib_zpbsvx
     public :: stdlib_zpbtf2
     public :: stdlib_zpbtrf
     public :: stdlib_zpbtrs
     public :: stdlib_zpftrf
     public :: stdlib_zpftri
     public :: stdlib_zpftrs
     public :: stdlib_zpocon
     public :: stdlib_zpoequ
     public :: stdlib_zpoequb
     public :: stdlib_zporfs
     public :: stdlib_zposv
     public :: stdlib_zposvx
     public :: stdlib_zpotf2
     public :: stdlib_zpotrf
     public :: stdlib_zpotrf2
     public :: stdlib_zpotri
     public :: stdlib_zpotrs
     public :: stdlib_zppcon
     public :: stdlib_zppequ
     public :: stdlib_zpprfs
     public :: stdlib_zppsv
     public :: stdlib_zppsvx
     public :: stdlib_zpptrf
     public :: stdlib_zpptri
     public :: stdlib_zpptrs
     public :: stdlib_zpstf2
     public :: stdlib_zpstrf
     public :: stdlib_zptcon
     public :: stdlib_zpteqr
     public :: stdlib_zptrfs
     public :: stdlib_zptsv
     public :: stdlib_zptsvx
     public :: stdlib_zpttrf
     public :: stdlib_zpttrs
     public :: stdlib_zptts2
     public :: stdlib_zrot
     public :: stdlib_zspcon
     public :: stdlib_zspmv
     public :: stdlib_zspr
     public :: stdlib_zsprfs
     public :: stdlib_zspsv
     public :: stdlib_zspsvx
     public :: stdlib_zsptrf
     public :: stdlib_zsptri
     public :: stdlib_zsptrs
     public :: stdlib_zstedc
     public :: stdlib_zstegr
     public :: stdlib_zstein
     public :: stdlib_zstemr
     public :: stdlib_zsteqr
     public :: stdlib_zsycon
     public :: stdlib_zsycon_rook
     public :: stdlib_zsyconv
     public :: stdlib_zsyconvf
     public :: stdlib_zsyconvf_rook
     public :: stdlib_zsyequb
     public :: stdlib_zsymv
     public :: stdlib_zsyr
     public :: stdlib_zsyrfs
     public :: stdlib_zsysv
     public :: stdlib_zsysv_aa
     public :: stdlib_zsysv_rk
     public :: stdlib_zsysv_rook
     public :: stdlib_zsysvx
     public :: stdlib_zsyswapr
     public :: stdlib_zsytf2
     public :: stdlib_zsytf2_rk
     public :: stdlib_zsytf2_rook
     public :: stdlib_zsytrf
     public :: stdlib_zsytrf_aa
     public :: stdlib_zsytrf_rk
     public :: stdlib_zsytrf_rook
     public :: stdlib_zsytri
     public :: stdlib_zsytri_rook
     public :: stdlib_zsytrs
     public :: stdlib_zsytrs2
     public :: stdlib_zsytrs_3
     public :: stdlib_zsytrs_aa
     public :: stdlib_zsytrs_rook
     public :: stdlib_ztbcon
     public :: stdlib_ztbrfs
     public :: stdlib_ztbtrs
     public :: stdlib_ztfsm
     public :: stdlib_ztftri
     public :: stdlib_ztfttp
     public :: stdlib_ztfttr
     public :: stdlib_ztgevc
     public :: stdlib_ztgex2
     public :: stdlib_ztgexc
     public :: stdlib_ztgsen
     public :: stdlib_ztgsja
     public :: stdlib_ztgsna
     public :: stdlib_ztgsy2
     public :: stdlib_ztgsyl
     public :: stdlib_ztpcon
     public :: stdlib_ztplqt
     public :: stdlib_ztplqt2
     public :: stdlib_ztpmlqt
     public :: stdlib_ztpmqrt
     public :: stdlib_ztpqrt
     public :: stdlib_ztpqrt2
     public :: stdlib_ztprfb
     public :: stdlib_ztprfs
     public :: stdlib_ztptri
     public :: stdlib_ztptrs
     public :: stdlib_ztpttf
     public :: stdlib_ztpttr
     public :: stdlib_ztrcon
     public :: stdlib_ztrevc
     public :: stdlib_ztrevc3
     public :: stdlib_ztrexc
     public :: stdlib_ztrrfs
     public :: stdlib_ztrsen
     public :: stdlib_ztrsna
     public :: stdlib_ztrsyl
     public :: stdlib_ztrti2
     public :: stdlib_ztrtri
     public :: stdlib_ztrtrs
     public :: stdlib_ztrttf
     public :: stdlib_ztrttp
     public :: stdlib_ztzrzf
     public :: stdlib_zunbdb
     public :: stdlib_zunbdb1
     public :: stdlib_zunbdb2
     public :: stdlib_zunbdb3
     public :: stdlib_zunbdb4
     public :: stdlib_zunbdb5
     public :: stdlib_zunbdb6
     public :: stdlib_zuncsd
     public :: stdlib_zuncsd2by1
     public :: stdlib_zung2l
     public :: stdlib_zung2r
     public :: stdlib_zungbr
     public :: stdlib_zunghr
     public :: stdlib_zungl2
     public :: stdlib_zunglq
     public :: stdlib_zungql
     public :: stdlib_zungqr
     public :: stdlib_zungr2
     public :: stdlib_zungrq
     public :: stdlib_zungtr
     public :: stdlib_zungtsqr
     public :: stdlib_zungtsqr_row
     public :: stdlib_zunhr_col
     public :: stdlib_zunm22
     public :: stdlib_zunm2l
     public :: stdlib_zunm2r
     public :: stdlib_zunmbr
     public :: stdlib_zunmhr
     public :: stdlib_zunml2
     public :: stdlib_zunmlq
     public :: stdlib_zunmql
     public :: stdlib_zunmqr
     public :: stdlib_zunmr2
     public :: stdlib_zunmr3
     public :: stdlib_zunmrq
     public :: stdlib_zunmrz
     public :: stdlib_zunmtr
     public :: stdlib_zupgtr
     public :: stdlib_zupmtr

     ! 64-bit real constants
     real(dp), parameter, private :: zero = 0.00_dp
     real(dp), parameter, private :: half = 0.50_dp
     real(dp), parameter, private :: one = 1.00_dp
     real(dp), parameter, private :: two = 2.00_dp
     real(dp), parameter, private :: three = 3.00_dp
     real(dp), parameter, private :: four = 4.00_dp
     real(dp), parameter, private :: eight = 8.00_dp
     real(dp), parameter, private :: ten = 10.00_dp

     ! 64-bit complex constants
     complex(dp), parameter, private :: czero = (0.0_dp, 0.0_dp)
     complex(dp), parameter, private :: chalf = (0.5_dp, 0.0_dp)
     complex(dp), parameter, private :: cone = (1.0_dp, 0.0_dp)

     ! 64-bit scaling constants
     integer, parameter, private :: maxexp = maxexponent(zero)
     integer, parameter, private :: minexp = minexponent(zero)
     real(dp), parameter, private :: rradix = real(radix(zero), dp)
     real(dp), parameter, private :: ulp = epsilon(zero)
     real(dp), parameter, private :: eps = ulp*half
     real(dp), parameter, private :: safmin = rradix**max(minexp - 1, 1 - maxexp)
     real(dp), parameter, private :: safmax = one/safmin
     real(dp), parameter, private :: smlnum = safmin/ulp
     real(dp), parameter, private :: bignum = safmax*ulp
     real(dp), parameter, private :: rtmin = sqrt(smlnum)
     real(dp), parameter, private :: rtmax = sqrt(bignum)

     ! 64-bit Blue's scaling constants
     ! ssml>=1/s and sbig==1/S with s,S as defined in https://doi.org/10.1145/355769.355771
     real(dp), parameter, private :: tsml = rradix**ceiling((minexp - 1)*half)
     real(dp), parameter, private :: tbig = rradix**floor((maxexp - digits(zero) + 1)*half)
     real(dp), parameter, private :: ssml = rradix**(-floor((minexp - digits(zero))*half))
     real(dp), parameter, private :: sbig = rradix**(-ceiling((maxexp + digits(zero) - 1)*half))

     contains

     ! ZDRSCL multiplies an n-element complex vector x by the real scalar
     ! 1/a.  This is done without overflow or underflow as long as
     ! the final result x/a does not overflow or underflow.

     subroutine stdlib_zdrscl(n, sa, sx, incx)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: incx, n
           real(dp) :: sa
           ! .. array arguments ..
           complex(dp) :: sx(*)
       ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: done
           real(dp) :: bignum, cden, cden1, cnum, cnum1, mul, smlnum
     
           ! .. intrinsic functions ..
           intrinsic :: abs
           ! .. executable statements ..
           ! quick return if possible
           if (n <= 0) return
           ! get machine parameters
           smlnum = stdlib_dlamch('s')
           bignum = one/smlnum
           call stdlib_dlabad(smlnum, bignum)
           ! initialize the denominator to sa and the numerator to 1.
           cden = sa
           cnum = one
10      continue
           cden1 = cden*smlnum
           cnum1 = cnum/bignum
           if (abs(cden1) > abs(cnum) .and. cnum /= zero) then
              ! pre-multiply x by smlnum if cden is large compared to cnum.
              mul = smlnum
              done = .false.
              cden = cden1
           else if (abs(cnum1) > abs(cden)) then
              ! pre-multiply x by bignum if cden is small compared to cnum.
              mul = bignum
              done = .false.
              cnum = cnum1
           else
              ! multiply x by cnum / cden and return.
              mul = cnum/cden
              done = .true.
           end if
           ! scale the vector x by mul
           call stdlib_zdscal(n, mul, sx, incx)
           if (.not. done) go to 10
           return
           ! end of stdlib_zdrscl
     end subroutine stdlib_zdrscl

     ! ZGBEQU computes row and column scalings intended to equilibrate an
     ! M-by-N band matrix A and reduce its condition number.  R returns the
     ! row scale factors and C the column scale factors, chosen to try to
     ! make the largest element in each row and column of the matrix B with
     ! elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.
     ! R(i) and C(j) are restricted to be between SMLNUM = smallest safe
     ! number and BIGNUM = largest safe number.  Use of these scaling
     ! factors is not guaranteed to reduce the condition number of A but
     ! works well in practice.

     subroutine stdlib_zgbequ(m, n, kl, ku, ab, ldab, r, c, rowcnd, colcnd, amax, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: info, kl, ku, ldab, m, n
           real(dp) :: amax, colcnd, rowcnd
           ! .. array arguments ..
           real(dp) :: c(*), r(*)
           complex(dp) :: ab(ldab, *)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i, j, kd
           real(dp) :: bignum, rcmax, rcmin, smlnum
           complex(dp) :: zdum
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, aimag, max, min
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(zdum) = abs(real(zdum, KIND=dp)) + abs(aimag(zdum))
           ! .. executable statements ..
           ! test the input parameters
           info = 0
           if (m < 0) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (kl < 0) then
              info = -3
           else if (ku < 0) then
              info = -4
           else if (ldab < kl + ku + 1) then
              info = -6
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zgbequ', -info)
              return
           end if
           ! quick return if possible
           if (m == 0 .or. n == 0) then
              rowcnd = one
              colcnd = one
              amax = zero
              return
           end if
           ! get machine constants.
           smlnum = stdlib_dlamch('s')
           bignum = one/smlnum
           ! compute row scale factors.
           do i = 1, m
              r(i) = zero
           end do
           ! find the maximum element in each row.
           kd = ku + 1
           do j = 1, n
              do i = max(j - ku, 1), min(j + kl, m)
                 r(i) = max(r(i), cabs1(ab(kd + i - j, j)))
              end do
           end do
           ! find the maximum and minimum scale factors.
           rcmin = bignum
           rcmax = zero
           do i = 1, m
              rcmax = max(rcmax, r(i))
              rcmin = min(rcmin, r(i))
           end do
           amax = rcmax
           if (rcmin == zero) then
              ! find the first zero scale factor and return an error code.
              do i = 1, m
                 if (r(i) == zero) then
                    info = i
                    return
                 end if
              end do
           else
              ! invert the scale factors.
              do i = 1, m
                 r(i) = one/min(max(r(i), smlnum), bignum)
              end do
              ! compute rowcnd = min(r(i)) / max(r(i))
              rowcnd = max(rcmin, smlnum)/min(rcmax, bignum)
           end if
           ! compute column scale factors
           do j = 1, n
              c(j) = zero
           end do
           ! find the maximum element in each column,
           ! assuming the row scaling computed above.
           kd = ku + 1
           do j = 1, n
              do i = max(j - ku, 1), min(j + kl, m)
                 c(j) = max(c(j), cabs1(ab(kd + i - j, j))*r(i))
              end do
           end do
           ! find the maximum and minimum scale factors.
           rcmin = bignum
           rcmax = zero
           do j = 1, n
              rcmin = min(rcmin, c(j))
              rcmax = max(rcmax, c(j))
           end do
           if (rcmin == zero) then
              ! find the first zero scale factor and return an error code.
              do j = 1, n
                 if (c(j) == zero) then
                    info = m + j
                    return
                 end if
              end do
           else
              ! invert the scale factors.
              do j = 1, n
                 c(j) = one/min(max(c(j), smlnum), bignum)
              end do
              ! compute colcnd = min(c(j)) / max(c(j))
              colcnd = max(rcmin, smlnum)/min(rcmax, bignum)
           end if
           return
           ! end of stdlib_zgbequ
     end subroutine stdlib_zgbequ

     ! ZGBEQUB computes row and column scalings intended to equilibrate an
     ! M-by-N matrix A and reduce its condition number.  R returns the row
     ! scale factors and C the column scale factors, chosen to try to make
     ! the largest element in each row and column of the matrix B with
     ! elements B(i,j)=R(i)*A(i,j)*C(j) have an absolute value of at most
     ! the radix.
     ! R(i) and C(j) are restricted to be a power of the radix between
     ! SMLNUM = smallest safe number and BIGNUM = largest safe number.  Use
     ! of these scaling factors is not guaranteed to reduce the condition
     ! number of A but works well in practice.
     ! This routine differs from ZGEEQU by restricting the scaling factors
     ! to a power of the radix.  Barring over- and underflow, scaling by
     ! these factors introduces no additional rounding errors.  However, the
     ! scaled entries' magnitudes are no longer approximately 1 but lie
     ! between sqrt(radix) and 1/sqrt(radix).

     subroutine stdlib_zgbequb(m, n, kl, ku, ab, ldab, r, c, rowcnd, colcnd, amax, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: info, kl, ku, ldab, m, n
           real(dp) :: amax, colcnd, rowcnd
           ! .. array arguments ..
           real(dp) :: c(*), r(*)
           complex(dp) :: ab(ldab, *)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i, j, kd
           real(dp) :: bignum, rcmax, rcmin, smlnum, radix, logrdx
           complex(dp) :: zdum
     
           ! .. intrinsic functions ..
           intrinsic :: abs, max, min, log, real, aimag
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(zdum) = abs(real(zdum, KIND=dp)) + abs(aimag(zdum))
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           if (m < 0) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (kl < 0) then
              info = -3
           else if (ku < 0) then
              info = -4
           else if (ldab < kl + ku + 1) then
              info = -6
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zgbequb', -info)
              return
           end if
           ! quick return if possible.
           if (m == 0 .or. n == 0) then
              rowcnd = one
              colcnd = one
              amax = zero
              return
           end if
           ! get machine constants.  assume smlnum is a power of the radix.
           smlnum = stdlib_dlamch('s')
           bignum = one/smlnum
           radix = stdlib_dlamch('b')
           logrdx = log(radix)
           ! compute row scale factors.
           do i = 1, m
              r(i) = zero
           end do
           ! find the maximum element in each row.
           kd = ku + 1
           do j = 1, n
              do i = max(j - ku, 1), min(j + kl, m)
                 r(i) = max(r(i), cabs1(ab(kd + i - j, j)))
              end do
           end do
           do i = 1, m
              if (r(i) > zero) then
                 r(i) = radix**int(log(r(i))/logrdx)
              end if
           end do
           ! find the maximum and minimum scale factors.
           rcmin = bignum
           rcmax = zero
           do i = 1, m
              rcmax = max(rcmax, r(i))
              rcmin = min(rcmin, r(i))
           end do
           amax = rcmax
           if (rcmin == zero) then
              ! find the first zero scale factor and return an error code.
              do i = 1, m
                 if (r(i) == zero) then
                    info = i
                    return
                 end if
              end do
           else
              ! invert the scale factors.
              do i = 1, m
                 r(i) = one/min(max(r(i), smlnum), bignum)
              end do
              ! compute rowcnd = min(r(i)) / max(r(i)).
              rowcnd = max(rcmin, smlnum)/min(rcmax, bignum)
           end if
           ! compute column scale factors.
           do j = 1, n
              c(j) = zero
           end do
           ! find the maximum element in each column,
           ! assuming the row scaling computed above.
           do j = 1, n
              do i = max(j - ku, 1), min(j + kl, m)
                 c(j) = max(c(j), cabs1(ab(kd + i - j, j))*r(i))
              end do
              if (c(j) > zero) then
                 c(j) = radix**int(log(c(j))/logrdx)
              end if
           end do
           ! find the maximum and minimum scale factors.
           rcmin = bignum
           rcmax = zero
           do j = 1, n
              rcmin = min(rcmin, c(j))
              rcmax = max(rcmax, c(j))
           end do
           if (rcmin == zero) then
              ! find the first zero scale factor and return an error code.
              do j = 1, n
                 if (c(j) == zero) then
                    info = m + j
                    return
                 end if
              end do
           else
              ! invert the scale factors.
              do j = 1, n
                 c(j) = one/min(max(c(j), smlnum), bignum)
              end do
              ! compute colcnd = min(c(j)) / max(c(j)).
              colcnd = max(rcmin, smlnum)/min(rcmax, bignum)
           end if
           return
           ! end of stdlib_zgbequb
     end subroutine stdlib_zgbequb

     ! ZGBTF2 computes an LU factorization of a complex m-by-n band matrix
     ! A using partial pivoting with row interchanges.
     ! This is the unblocked version of the algorithm, calling Level 2 BLAS.

     subroutine stdlib_zgbtf2(m, n, kl, ku, ab, ldab, ipiv, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: info, kl, ku, ldab, m, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: ab(ldab, *)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i, j, jp, ju, km, kv
     
           ! .. intrinsic functions ..
           intrinsic :: max, min
           ! .. executable statements ..
           ! kv is the number of superdiagonals in the factor u, allowing for
           ! fill-in.
           kv = ku + kl
           ! test the input parameters.
           info = 0
           if (m < 0) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (kl < 0) then
              info = -3
           else if (ku < 0) then
              info = -4
           else if (ldab < kl + kv + 1) then
              info = -6
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zgbtf2', -info)
              return
           end if
           ! quick return if possible
           if (m == 0 .or. n == 0) return
           ! gaussian elimination with partial pivoting
           ! set fill-in elements in columns ku+2 to kv to czero.
           do j = ku + 2, min(kv, n)
              do i = kv - j + 2, kl
                 ab(i, j) = czero
              end do
           end do
           ! ju is the index of the last column affected by the current stage
           ! of the factorization.
           ju = 1
           loop_40: do j = 1, min(m, n)
              ! set fill-in elements in column j+kv to czero.
              if (j + kv <= n) then
                 do i = 1, kl
                    ab(i, j + kv) = czero
                 end do
              end if
              ! find pivot and test for singularity. km is the number of
              ! subdiagonal elements in the current column.
              km = min(kl, m - j)
              jp = stdlib_izamax(km + 1, ab(kv + 1, j), 1)
              ipiv(j) = jp + j - 1
              if (ab(kv + jp, j) /= czero) then
                 ju = max(ju, min(j + ku + jp - 1, n))
                 ! apply interchange to columns j to ju.
                 if (jp /= 1) call stdlib_zswap(ju - j + 1, ab(kv + jp, j), ldab - 1, ab(kv + 1, j), ldab - &
                           1)
                 if (km > 0) then
                    ! compute multipliers.
                    call stdlib_zscal(km, cone/ab(kv + 1, j), ab(kv + 2, j), 1)
                    ! update trailing submatrix within the band.
                    if (ju > j) call stdlib_zgeru(km, ju - j, -cone, ab(kv + 2, j), 1, ab(kv, j + 1), &
                              ldab - 1, ab(kv + 1, j + 1), ldab - 1)
                 end if
              else
                 ! if pivot is czero, set info to the index of the pivot
                 ! unless a czero pivot has already been found.
                 if (info == 0) info = j
              end if
           end do loop_40
           return
           ! end of stdlib_zgbtf2
     end subroutine stdlib_zgbtf2

     ! ZGEBAK forms the right or left eigenvectors of a complex general
     ! matrix by backward transformation on the computed eigenvectors of the
     ! balanced matrix output by ZGEBAL.

     subroutine stdlib_zgebak(job, side, n, ilo, ihi, scale, m, v, ldv, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: job, side
           integer(ilp) :: ihi, ilo, info, ldv, m, n
           ! .. array arguments ..
           real(dp) :: scale(*)
           complex(dp) :: v(ldv, *)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: leftv, rightv
           integer(ilp) :: i, ii, k
           real(dp) :: s
     
           ! .. intrinsic functions ..
           intrinsic :: max, min
           ! .. executable statements ..
           ! decode and test the input parameters
           rightv = stdlib_lsame(side, 'r')
           leftv = stdlib_lsame(side, 'l')
           info = 0
           if (.not. stdlib_lsame(job, 'n') .and. .not. stdlib_lsame(job, 'p') &
                     .and. .not. stdlib_lsame(job, 's') .and. .not. stdlib_lsame(job, 'b')) then
              info = -1
           else if (.not. rightv .and. .not. leftv) then
              info = -2
           else if (n < 0) then
              info = -3
           else if (ilo < 1 .or. ilo > max(1, n)) then
              info = -4
           else if (ihi < min(ilo, n) .or. ihi > n) then
              info = -5
           else if (m < 0) then
              info = -7
           else if (ldv < max(1, n)) then
              info = -9
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zgebak', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           if (m == 0) return
           if (stdlib_lsame(job, 'n')) return
           if (ilo == ihi) go to 30
           ! backward balance
           if (stdlib_lsame(job, 's') .or. stdlib_lsame(job, 'b')) then
              if (rightv) then
                 do i = ilo, ihi
                    s = scale(i)
                    call stdlib_zdscal(m, s, v(i, 1), ldv)
                 end do
              end if
              if (leftv) then
                 do i = ilo, ihi
                    s = one/scale(i)
                    call stdlib_zdscal(m, s, v(i, 1), ldv)
                 end do
              end if
           end if
           ! backward permutation
           ! for  i = ilo-1 step -1 until 1,
                    ! ihi+1 step 1 until n do --
30      continue
           if (stdlib_lsame(job, 'p') .or. stdlib_lsame(job, 'b')) then
              if (rightv) then
                 loop_40: do ii = 1, n
                    i = ii
                    if (i >= ilo .and. i <= ihi) cycle loop_40
                    if (i < ilo) i = ilo - ii
                    k = scale(i)
                    if (k == i) cycle loop_40
                    call stdlib_zswap(m, v(i, 1), ldv, v(k, 1), ldv)
                 end do loop_40
              end if
              if (leftv) then
                 loop_50: do ii = 1, n
                    i = ii
                    if (i >= ilo .and. i <= ihi) cycle loop_50
                    if (i < ilo) i = ilo - ii
                    k = scale(i)
                    if (k == i) cycle loop_50
                    call stdlib_zswap(m, v(i, 1), ldv, v(k, 1), ldv)
                 end do loop_50
              end if
           end if
           return
           ! end of stdlib_zgebak
     end subroutine stdlib_zgebak

     ! ZGEBAL balances a general complex matrix A.  This involves, first,
     ! permuting A by a similarity transformation to isolate eigenvalues
     ! in the first 1 to ILO-1 and last IHI+1 to N elements on the
     ! diagonal; and second, applying a diagonal similarity transformation
     ! to rows and columns ILO to IHI to make the rows and columns as
     ! close in norm as possible.  Both steps are optional.
     ! Balancing may reduce the 1-norm of the matrix, and improve the
     ! accuracy of the computed eigenvalues and/or eigenvectors.

     subroutine stdlib_zgebal(job, n, a, lda, ilo, ihi, scale, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: job
           integer(ilp) :: ihi, ilo, info, lda, n
           ! .. array arguments ..
           real(dp) :: scale(*)
           complex(dp) :: a(lda, *)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: sclfac = 2.0_dp
           real(dp), parameter :: factor = 0.95_dp
           
           ! .. local scalars ..
           logical(lk) :: noconv
           integer(ilp) :: i, ica, iexc, ira, j, k, l, m
           real(dp) :: c, ca, f, g, r, ra, s, sfmax1, sfmax2, sfmin1, sfmin2
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, aimag, max, min
           ! test the input parameters
           info = 0
           if (.not. stdlib_lsame(job, 'n') .and. .not. stdlib_lsame(job, 'p') &
                     .and. .not. stdlib_lsame(job, 's') .and. .not. stdlib_lsame(job, 'b')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, n)) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zgebal', -info)
              return
           end if
           k = 1
           l = n
           if (n == 0) go to 210
           if (stdlib_lsame(job, 'n')) then
              do i = 1, n
                 scale(i) = one
              end do
              go to 210
           end if
           if (stdlib_lsame(job, 's')) go to 120
           ! permutation to isolate eigenvalues if possible
           go to 50
           ! row and column exchange.
20      continue
           scale(m) = j
           if (j == m) go to 30
           call stdlib_zswap(l, a(1, j), 1, a(1, m), 1)
           call stdlib_zswap(n - k + 1, a(j, k), lda, a(m, k), lda)
30      continue
           go to(40, 80) iexc
           ! search for rows isolating an eigenvalue and push them down.
40      continue
           if (l == 1) go to 210
           l = l - 1
50      continue
           loop_70: do j = l, 1, -1
              loop_60: do i = 1, l
                 if (i == j) cycle loop_60
                 if (real(a(j, i), KIND=dp) /= zero .or. aimag(a(j, i)) /= zero) cycle &
                           loop_70
              end do loop_60
              m = l
              iexc = 1
              go to 20
           end do loop_70
           go to 90
           ! search for columns isolating an eigenvalue and push them left.
80      continue
           k = k + 1
90      continue
           loop_110: do j = k, l
              loop_100: do i = k, l
                 if (i == j) cycle loop_100
                 if (real(a(i, j), KIND=dp) /= zero .or. aimag(a(i, j)) /= zero) cycle &
                           loop_110
              end do loop_100
              m = k
              iexc = 2
              go to 20
           end do loop_110
120    continue
           do i = k, l
              scale(i) = one
           end do
           if (stdlib_lsame(job, 'p')) go to 210
           ! balance the submatrix in rows k to l.
           ! iterative loop for norm reduction
           sfmin1 = stdlib_dlamch('s')/stdlib_dlamch('p')
           sfmax1 = one/sfmin1
           sfmin2 = sfmin1*sclfac
           sfmax2 = one/sfmin2
140    continue
           noconv = .false.
           loop_200: do i = k, l
              c = stdlib_dznrm2(l - k + 1, a(k, i), 1)
              r = stdlib_dznrm2(l - k + 1, a(i, k), lda)
              ica = stdlib_izamax(l, a(1, i), 1)
              ca = abs(a(ica, i))
              ira = stdlib_izamax(n - k + 1, a(i, k), lda)
              ra = abs(a(i, ira + k - 1))
              ! guard against zero c or r due to underflow.
              if (c == zero .or. r == zero) cycle loop_200
              g = r/sclfac
              f = one
              s = c + r
160    continue
              if (c >= g .or. max(f, c, ca) >= sfmax2 .or. min(r, g, ra) <= sfmin2) go to 170
                 if (stdlib_disnan(c + f + ca + r + g + ra)) then
                 ! exit if nan to avoid infinite loop
                 info = -3
                 call stdlib_xerbla('stdlib_zgebal', -info)
                 return
              end if
              f = f*sclfac
              c = c*sclfac
              ca = ca*sclfac
              r = r/sclfac
              g = g/sclfac
              ra = ra/sclfac
              go to 160
170    continue
              g = c/sclfac
180    continue
              if (g < r .or. max(r, ra) >= sfmax2 .or. min(f, c, g, ca) <= sfmin2) go to 190
              f = f/sclfac
              c = c/sclfac
              g = g/sclfac
              ca = ca/sclfac
              r = r*sclfac
              ra = ra*sclfac
              go to 180
              ! now balance.
190    continue
              if ((c + r) >= factor*s) cycle loop_200
              if (f < one .and. scale(i) < one) then
                 if (f*scale(i) <= sfmin1) cycle loop_200
              end if
              if (f > one .and. scale(i) > one) then
                 if (scale(i) >= sfmax1/f) cycle loop_200
              end if
              g = one/f
              scale(i) = scale(i)*f
              noconv = .true.
              call stdlib_zdscal(n - k + 1, g, a(i, k), lda)
              call stdlib_zdscal(l, f, a(1, i), 1)
           end do loop_200
           if (noconv) go to 140
210    continue
           ilo = k
           ihi = l
           return
           ! end of stdlib_zgebal
     end subroutine stdlib_zgebal

     ! ZGEEQU computes row and column scalings intended to equilibrate an
     ! M-by-N matrix A and reduce its condition number.  R returns the row
     ! scale factors and C the column scale factors, chosen to try to make
     ! the largest element in each row and column of the matrix B with
     ! elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.
     ! R(i) and C(j) are restricted to be between SMLNUM = smallest safe
     ! number and BIGNUM = largest safe number.  Use of these scaling
     ! factors is not guaranteed to reduce the condition number of A but
     ! works well in practice.

     subroutine stdlib_zgeequ(m, n, a, lda, r, c, rowcnd, colcnd, amax, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: info, lda, m, n
           real(dp) :: amax, colcnd, rowcnd
           ! .. array arguments ..
           real(dp) :: c(*), r(*)
           complex(dp) :: a(lda, *)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i, j
           real(dp) :: bignum, rcmax, rcmin, smlnum
           complex(dp) :: zdum
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, aimag, max, min
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(zdum) = abs(real(zdum, KIND=dp)) + abs(aimag(zdum))
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           if (m < 0) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, m)) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zgeequ', -info)
              return
           end if
           ! quick return if possible
           if (m == 0 .or. n == 0) then
              rowcnd = one
              colcnd = one
              amax = zero
              return
           end if
           ! get machine constants.
           smlnum = stdlib_dlamch('s')
           bignum = one/smlnum
           ! compute row scale factors.
           do i = 1, m
              r(i) = zero
           end do
           ! find the maximum element in each row.
           do j = 1, n
              do i = 1, m
                 r(i) = max(r(i), cabs1(a(i, j)))
              end do
           end do
           ! find the maximum and minimum scale factors.
           rcmin = bignum
           rcmax = zero
           do i = 1, m
              rcmax = max(rcmax, r(i))
              rcmin = min(rcmin, r(i))
           end do
           amax = rcmax
           if (rcmin == zero) then
              ! find the first zero scale factor and return an error code.
              do i = 1, m
                 if (r(i) == zero) then
                    info = i
                    return
                 end if
              end do
           else
              ! invert the scale factors.
              do i = 1, m
                 r(i) = one/min(max(r(i), smlnum), bignum)
              end do
              ! compute rowcnd = min(r(i)) / max(r(i))
              rowcnd = max(rcmin, smlnum)/min(rcmax, bignum)
           end if
           ! compute column scale factors
           do j = 1, n
              c(j) = zero
           end do
           ! find the maximum element in each column,
           ! assuming the row scaling computed above.
           do j = 1, n
              do i = 1, m
                 c(j) = max(c(j), cabs1(a(i, j))*r(i))
              end do
           end do
           ! find the maximum and minimum scale factors.
           rcmin = bignum
           rcmax = zero
           do j = 1, n
              rcmin = min(rcmin, c(j))
              rcmax = max(rcmax, c(j))
           end do
           if (rcmin == zero) then
              ! find the first zero scale factor and return an error code.
              do j = 1, n
                 if (c(j) == zero) then
                    info = m + j
                    return
                 end if
              end do
           else
              ! invert the scale factors.
              do j = 1, n
                 c(j) = one/min(max(c(j), smlnum), bignum)
              end do
              ! compute colcnd = min(c(j)) / max(c(j))
              colcnd = max(rcmin, smlnum)/min(rcmax, bignum)
           end if
           return
           ! end of stdlib_zgeequ
     end subroutine stdlib_zgeequ

     ! ZGEEQUB computes row and column scalings intended to equilibrate an
     ! M-by-N matrix A and reduce its condition number.  R returns the row
     ! scale factors and C the column scale factors, chosen to try to make
     ! the largest element in each row and column of the matrix B with
     ! elements B(i,j)=R(i)*A(i,j)*C(j) have an absolute value of at most
     ! the radix.
     ! R(i) and C(j) are restricted to be a power of the radix between
     ! SMLNUM = smallest safe number and BIGNUM = largest safe number.  Use
     ! of these scaling factors is not guaranteed to reduce the condition
     ! number of A but works well in practice.
     ! This routine differs from ZGEEQU by restricting the scaling factors
     ! to a power of the radix.  Barring over- and underflow, scaling by
     ! these factors introduces no additional rounding errors.  However, the
     ! scaled entries' magnitudes are no longer approximately 1 but lie
     ! between sqrt(radix) and 1/sqrt(radix).

     subroutine stdlib_zgeequb(m, n, a, lda, r, c, rowcnd, colcnd, amax, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: info, lda, m, n
           real(dp) :: amax, colcnd, rowcnd
           ! .. array arguments ..
           real(dp) :: c(*), r(*)
           complex(dp) :: a(lda, *)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i, j
           real(dp) :: bignum, rcmax, rcmin, smlnum, radix, logrdx
           complex(dp) :: zdum
     
           ! .. intrinsic functions ..
           intrinsic :: abs, max, min, log, dble, aimag
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(zdum) = abs(real(zdum, KIND=dp)) + abs(aimag(zdum))
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           if (m < 0) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, m)) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zgeequb', -info)
              return
           end if
           ! quick return if possible.
           if (m == 0 .or. n == 0) then
              rowcnd = one
              colcnd = one
              amax = zero
              return
           end if
           ! get machine constants.  assume smlnum is a power of the radix.
           smlnum = stdlib_dlamch('s')
           bignum = one/smlnum
           radix = stdlib_dlamch('b')
           logrdx = log(radix)
           ! compute row scale factors.
           do i = 1, m
              r(i) = zero
           end do
           ! find the maximum element in each row.
           do j = 1, n
              do i = 1, m
                 r(i) = max(r(i), cabs1(a(i, j)))
              end do
           end do
           do i = 1, m
              if (r(i) > zero) then
                 r(i) = radix**int(log(r(i))/logrdx)
              end if
           end do
           ! find the maximum and minimum scale factors.
           rcmin = bignum
           rcmax = zero
           do i = 1, m
              rcmax = max(rcmax, r(i))
              rcmin = min(rcmin, r(i))
           end do
           amax = rcmax
           if (rcmin == zero) then
              ! find the first zero scale factor and return an error code.
              do i = 1, m
                 if (r(i) == zero) then
                    info = i
                    return
                 end if
              end do
           else
              ! invert the scale factors.
              do i = 1, m
                 r(i) = one/min(max(r(i), smlnum), bignum)
              end do
              ! compute rowcnd = min(r(i)) / max(r(i)).
              rowcnd = max(rcmin, smlnum)/min(rcmax, bignum)
           end if
           ! compute column scale factors.
           do j = 1, n
              c(j) = zero
           end do
           ! find the maximum element in each column,
           ! assuming the row scaling computed above.
           do j = 1, n
              do i = 1, m
                 c(j) = max(c(j), cabs1(a(i, j))*r(i))
              end do
              if (c(j) > zero) then
                 c(j) = radix**int(log(c(j))/logrdx)
              end if
           end do
           ! find the maximum and minimum scale factors.
           rcmin = bignum
           rcmax = zero
           do j = 1, n
              rcmin = min(rcmin, c(j))
              rcmax = max(rcmax, c(j))
           end do
           if (rcmin == zero) then
              ! find the first zero scale factor and return an error code.
              do j = 1, n
                 if (c(j) == zero) then
                    info = m + j
                    return
                 end if
              end do
           else
              ! invert the scale factors.
              do j = 1, n
                 c(j) = one/min(max(c(j), smlnum), bignum)
              end do
              ! compute colcnd = min(c(j)) / max(c(j)).
              colcnd = max(rcmin, smlnum)/min(rcmax, bignum)
           end if
           return
           ! end of stdlib_zgeequb
     end subroutine stdlib_zgeequb

     ! ZGETC2 computes an LU factorization, using complete pivoting, of the
     ! n-by-n matrix A. The factorization has the form A = P * L * U * Q,
     ! where P and Q are permutation matrices, L is lower triangular with
     ! unit diagonal elements and U is upper triangular.
     ! This is a level 1 BLAS version of the algorithm.

     subroutine stdlib_zgetc2(n, a, lda, ipiv, jpiv, info)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: info, lda, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*), jpiv(*)
           complex(dp) :: a(lda, *)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i, ip, ipv, j, jp, jpv
           real(dp) :: bignum, eps, smin, smlnum, xmax
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dcmplx, max
           ! .. executable statements ..
           info = 0
           ! quick return if possible
           if (n == 0) return
           ! set constants to control overflow
           eps = stdlib_dlamch('p')
           smlnum = stdlib_dlamch('s')/eps
           bignum = one/smlnum
           call stdlib_dlabad(smlnum, bignum)
           ! handle the case n=1 by itself
           if (n == 1) then
              ipiv(1) = 1
              jpiv(1) = 1
              if (abs(a(1, 1)) < smlnum) then
                 info = 1
                 a(1, 1) = cmplx(smlnum, zero, KIND=dp)
              end if
              return
           end if
           ! factorize a using complete pivoting.
           ! set pivots less than smin to smin
           loop_40: do i = 1, n - 1
              ! find max element in matrix a
              xmax = zero
              do ip = i, n
                 do jp = i, n
                    if (abs(a(ip, jp)) >= xmax) then
                       xmax = abs(a(ip, jp))
                       ipv = ip
                       jpv = jp
                    end if
                 end do
              end do
              if (i == 1) smin = max(eps*xmax, smlnum)
              ! swap rows
              if (ipv /= i) call stdlib_zswap(n, a(ipv, 1), lda, a(i, 1), lda)
              ipiv(i) = ipv
              ! swap columns
              if (jpv /= i) call stdlib_zswap(n, a(1, jpv), 1, a(1, i), 1)
              jpiv(i) = jpv
              ! check for singularity
              if (abs(a(i, i)) < smin) then
                 info = i
                 a(i, i) = cmplx(smin, zero, KIND=dp)
              end if
              do j = i + 1, n
                 a(j, i) = a(j, i)/a(i, i)
              end do
              call stdlib_zgeru(n - i, n - i, -cmplx(one, KIND=dp), a(i + 1, i), 1, a(i, i + 1), lda, &
                         a(i + 1, i + 1), lda)
           end do loop_40
           if (abs(a(n, n)) < smin) then
              info = n
              a(n, n) = cmplx(smin, zero, KIND=dp)
           end if
           ! set last pivots to n
           ipiv(n) = n
           jpiv(n) = n
           return
           ! end of stdlib_zgetc2
     end subroutine stdlib_zgetc2

     ! ZGETF2 computes an LU factorization of a general m-by-n matrix A
     ! using partial pivoting with row interchanges.
     ! The factorization has the form
     ! A = P * L * U
     ! where P is a permutation matrix, L is lower triangular with unit
     ! diagonal elements (lower trapezoidal if m > n), and U is upper
     ! triangular (upper trapezoidal if m < n).
     ! This is the right-looking Level 2 BLAS version of the algorithm.

     subroutine stdlib_zgetf2(m, n, a, lda, ipiv, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: info, lda, m, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *)
        ! =====================================================================
           
           ! .. local scalars ..
           real(dp) :: sfmin
           integer(ilp) :: i, j, jp
     
           ! .. intrinsic functions ..
           intrinsic :: max, min
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           if (m < 0) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, m)) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zgetf2', -info)
              return
           end if
           ! quick return if possible
           if (m == 0 .or. n == 0) return
           ! compute machine safe minimum
           sfmin = stdlib_dlamch('s')
           do j = 1, min(m, n)
              ! find pivot and test for singularity.
              jp = j - 1 + stdlib_izamax(m - j + 1, a(j, j), 1)
              ipiv(j) = jp
              if (a(jp, j) /= czero) then
                 ! apply the interchange to columns 1:n.
                 if (jp /= j) call stdlib_zswap(n, a(j, 1), lda, a(jp, 1), lda)
                 ! compute elements j+1:m of j-th column.
                 if (j < m) then
                    if (abs(a(j, j)) >= sfmin) then
                       call stdlib_zscal(m - j, cone/a(j, j), a(j + 1, j), 1)
                    else
                       do i = 1, m - j
                          a(j + i, j) = a(j + i, j)/a(j, j)
                       end do
                    end if
                 end if
              else if (info == 0) then
                 info = j
              end if
              if (j < min(m, n)) then
                 ! update trailing submatrix.
                 call stdlib_zgeru(m - j, n - j, -cone, a(j + 1, j), 1, a(j, j + 1), lda, a(j + 1, j + 1 &
                           ), lda)
              end if
           end do
           return
           ! end of stdlib_zgetf2
     end subroutine stdlib_zgetf2

     ! ZGGBAK forms the right or left eigenvectors of a complex generalized
     ! eigenvalue problem A*x = lambda*B*x, by backward transformation on
     ! the computed eigenvectors of the balanced pair of matrices output by
     ! ZGGBAL.

     subroutine stdlib_zggbak(job, side, n, ilo, ihi, lscale, rscale, m, v, ldv, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: job, side
           integer(ilp) :: ihi, ilo, info, ldv, m, n
           ! .. array arguments ..
           real(dp) :: lscale(*), rscale(*)
           complex(dp) :: v(ldv, *)
        ! =====================================================================
           ! .. local scalars ..
           logical(lk) :: leftv, rightv
           integer(ilp) :: i, k
     
           ! .. intrinsic functions ..
           intrinsic :: max, int
           ! .. executable statements ..
           ! test the input parameters
           rightv = stdlib_lsame(side, 'r')
           leftv = stdlib_lsame(side, 'l')
           info = 0
           if (.not. stdlib_lsame(job, 'n') .and. .not. stdlib_lsame(job, 'p') &
                     .and. .not. stdlib_lsame(job, 's') .and. .not. stdlib_lsame(job, 'b')) then
              info = -1
           else if (.not. rightv .and. .not. leftv) then
              info = -2
           else if (n < 0) then
              info = -3
           else if (ilo < 1) then
              info = -4
           else if (n == 0 .and. ihi == 0 .and. ilo /= 1) then
              info = -4
           else if (n > 0 .and. (ihi < ilo .or. ihi > max(1, n))) then
              info = -5
           else if (n == 0 .and. ilo == 1 .and. ihi /= 0) then
              info = -5
           else if (m < 0) then
              info = -8
           else if (ldv < max(1, n)) then
              info = -10
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zggbak', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           if (m == 0) return
           if (stdlib_lsame(job, 'n')) return
           if (ilo == ihi) go to 30
           ! backward balance
           if (stdlib_lsame(job, 's') .or. stdlib_lsame(job, 'b')) then
              ! backward transformation on right eigenvectors
              if (rightv) then
                 do i = ilo, ihi
                    call stdlib_zdscal(m, rscale(i), v(i, 1), ldv)
                 end do
              end if
              ! backward transformation on left eigenvectors
              if (leftv) then
                 do i = ilo, ihi
                    call stdlib_zdscal(m, lscale(i), v(i, 1), ldv)
                 end do
              end if
           end if
           ! backward permutation
30      continue
           if (stdlib_lsame(job, 'p') .or. stdlib_lsame(job, 'b')) then
              ! backward permutation on right eigenvectors
              if (rightv) then
                 if (ilo == 1) go to 50
                 loop_40: do i = ilo - 1, 1, -1
                    k = int(rscale(i), KIND=ilp)
                    if (k == i) cycle loop_40
                    call stdlib_zswap(m, v(i, 1), ldv, v(k, 1), ldv)
                 end do loop_40
50      continue
                 if (ihi == n) go to 70
                 loop_60: do i = ihi + 1, n
                    k = int(rscale(i), KIND=ilp)
                    if (k == i) cycle loop_60
                    call stdlib_zswap(m, v(i, 1), ldv, v(k, 1), ldv)
                 end do loop_60
              end if
              ! backward permutation on left eigenvectors
70      continue
              if (leftv) then
                 if (ilo == 1) go to 90
                 loop_80: do i = ilo - 1, 1, -1
                    k = int(lscale(i), KIND=ilp)
                    if (k == i) cycle loop_80
                    call stdlib_zswap(m, v(i, 1), ldv, v(k, 1), ldv)
                 end do loop_80
90      continue
                 if (ihi == n) go to 110
                 loop_100: do i = ihi + 1, n
                    k = int(lscale(i), KIND=ilp)
                    if (k == i) cycle loop_100
                    call stdlib_zswap(m, v(i, 1), ldv, v(k, 1), ldv)
                 end do loop_100
              end if
           end if
110    continue
           return
           ! end of stdlib_zggbak
     end subroutine stdlib_zggbak

     ! ZGGBAL balances a pair of general complex matrices (A,B).  This
     ! involves, first, permuting A and B by similarity transformations to
     ! isolate eigenvalues in the first 1 to ILO$-$1 and last IHI+1 to N
     ! elements on the diagonal; and second, applying a diagonal similarity
     ! transformation to rows and columns ILO to IHI to make the rows
     ! and columns as close in norm as possible. Both steps are optional.
     ! Balancing may reduce the 1-norm of the matrices, and improve the
     ! accuracy of the computed eigenvalues and/or eigenvectors in the
     ! generalized eigenvalue problem A*x = lambda*B*x.

     subroutine stdlib_zggbal(job, n, a, lda, b, ldb, ilo, ihi, lscale, rscale, work, info)
               
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: job
           integer(ilp) :: ihi, ilo, info, lda, ldb, n
           ! .. array arguments ..
           real(dp) :: lscale(*), rscale(*), work(*)
           complex(dp) :: a(lda, *), b(ldb, *)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: sclfac = 1.0d+1
           
           ! .. local scalars ..
           integer(ilp) :: i, icab, iflow, ip1, ir, irab, it, j, jc, jp1, k, kount, l, lcab, lm1, &
                     lrab, lsfmax, lsfmin, m, nr, nrp2
           real(dp) :: alpha, basl, beta, cab, cmax, coef, coef2, coef5, cor, ew, ewc, gamma, &
                     pgamma, rab, sfmax, sfmin, sum, t, ta, tb, tc
           complex(dp) :: cdum
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, aimag, int, log10, max, min, sign
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(cdum) = abs(real(cdum, KIND=dp)) + abs(aimag(cdum))
           ! .. executable statements ..
           ! test the input parameters
           info = 0
           if (.not. stdlib_lsame(job, 'n') .and. .not. stdlib_lsame(job, 'p') &
                     .and. .not. stdlib_lsame(job, 's') .and. .not. stdlib_lsame(job, 'b')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, n)) then
              info = -4
           else if (ldb < max(1, n)) then
              info = -6
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zggbal', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) then
              ilo = 1
              ihi = n
              return
           end if
           if (n == 1) then
              ilo = 1
              ihi = n
              lscale(1) = one
              rscale(1) = one
              return
           end if
           if (stdlib_lsame(job, 'n')) then
              ilo = 1
              ihi = n
              do i = 1, n
                 lscale(i) = one
                 rscale(i) = one
              end do
              return
           end if
           k = 1
           l = n
           if (stdlib_lsame(job, 's')) go to 190
           go to 30
           ! permute the matrices a and b to isolate the eigenvalues.
           ! find row with one nonzero in columns 1 through l
20      continue
           l = lm1
           if (l /= 1) go to 30
           rscale(1) = 1
           lscale(1) = 1
           go to 190
30      continue
           lm1 = l - 1
           loop_80: do i = l, 1, -1
              do j = 1, lm1
                 jp1 = j + 1
                 if (a(i, j) /= czero .or. b(i, j) /= czero) go to 50
              end do
              j = l
              go to 70
50      continue
              do j = jp1, l
                 if (a(i, j) /= czero .or. b(i, j) /= czero) cycle loop_80
              end do
              j = jp1 - 1
70      continue
              m = l
              iflow = 1
              go to 160
           end do loop_80
           go to 100
           ! find column with one nonzero in rows k through n
90      continue
           k = k + 1
100    continue
           loop_150: do j = k, l
              do i = k, lm1
                 ip1 = i + 1
                 if (a(i, j) /= czero .or. b(i, j) /= czero) go to 120
              end do
              i = l
              go to 140
120    continue
              do i = ip1, l
                 if (a(i, j) /= czero .or. b(i, j) /= czero) cycle loop_150
              end do
              i = ip1 - 1
140    continue
              m = k
              iflow = 2
              go to 160
           end do loop_150
           go to 190
           ! permute rows m and i
160    continue
           lscale(m) = i
           if (i == m) go to 170
           call stdlib_zswap(n - k + 1, a(i, k), lda, a(m, k), lda)
           call stdlib_zswap(n - k + 1, b(i, k), ldb, b(m, k), ldb)
           ! permute columns m and j
170    continue
           rscale(m) = j
           if (j == m) go to 180
           call stdlib_zswap(l, a(1, j), 1, a(1, m), 1)
           call stdlib_zswap(l, b(1, j), 1, b(1, m), 1)
180    continue
           go to(20, 90) iflow
190    continue
           ilo = k
           ihi = l
           if (stdlib_lsame(job, 'p')) then
              do i = ilo, ihi
                 lscale(i) = one
                 rscale(i) = one
              end do
              return
           end if
           if (ilo == ihi) return
           ! balance the submatrix in rows ilo to ihi.
           nr = ihi - ilo + 1
           do i = ilo, ihi
              rscale(i) = zero
              lscale(i) = zero
              work(i) = zero
              work(i + n) = zero
              work(i + 2*n) = zero
              work(i + 3*n) = zero
              work(i + 4*n) = zero
              work(i + 5*n) = zero
           end do
           ! compute right side vector in resulting linear equations
           basl = log10(sclfac)
           do i = ilo, ihi
              do j = ilo, ihi
                 if (a(i, j) == czero) then
                    ta = zero
                    go to 210
                 end if
                 ta = log10(cabs1(a(i, j)))/basl
210    continue
                 if (b(i, j) == czero) then
                    tb = zero
                    go to 220
                 end if
                 tb = log10(cabs1(b(i, j)))/basl
220    continue
                 work(i + 4*n) = work(i + 4*n) - ta - tb
                 work(j + 5*n) = work(j + 5*n) - ta - tb
              end do
           end do
           coef = one/real(2*nr, KIND=dp)
           coef2 = coef*coef
           coef5 = half*coef2
           nrp2 = nr + 2
           beta = zero
           it = 1
           ! start generalized conjugate gradient iteration
250    continue
           gamma = stdlib_ddot(nr, work(ilo + 4*n), 1, work(ilo + 4*n), 1) + stdlib_ddot(nr, &
                     work(ilo + 5*n), 1, work(ilo + 5*n), 1)
           ew = zero
           ewc = zero
           do i = ilo, ihi
              ew = ew + work(i + 4*n)
              ewc = ewc + work(i + 5*n)
           end do
           gamma = coef*gamma - coef2*(ew**2 + ewc**2) - coef5*(ew - ewc)**2
           if (gamma == zero) go to 350
           if (it /= 1) beta = gamma/pgamma
           t = coef5*(ewc - three*ew)
           tc = coef5*(ew - three*ewc)
           call stdlib_dscal(nr, beta, work(ilo), 1)
           call stdlib_dscal(nr, beta, work(ilo + n), 1)
           call stdlib_daxpy(nr, coef, work(ilo + 4*n), 1, work(ilo + n), 1)
           call stdlib_daxpy(nr, coef, work(ilo + 5*n), 1, work(ilo), 1)
           do i = ilo, ihi
              work(i) = work(i) + tc
              work(i + n) = work(i + n) + t
           end do
           ! apply matrix to vector
           do i = ilo, ihi
              kount = 0
              sum = zero
              loop_290: do j = ilo, ihi
                 if (a(i, j) == czero) go to 280
                 kount = kount + 1
                 sum = sum + work(j)
280    continue
                 if (b(i, j) == czero) cycle loop_290
                 kount = kount + 1
                 sum = sum + work(j)
              end do loop_290
              work(i + 2*n) = real(kount, KIND=dp)*work(i + n) + sum
           end do
           do j = ilo, ihi
              kount = 0
              sum = zero
              loop_320: do i = ilo, ihi
                 if (a(i, j) == czero) go to 310
                 kount = kount + 1
                 sum = sum + work(i + n)
310    continue
                 if (b(i, j) == czero) cycle loop_320
                 kount = kount + 1
                 sum = sum + work(i + n)
              end do loop_320
              work(j + 3*n) = real(kount, KIND=dp)*work(j) + sum
           end do
           sum = stdlib_ddot(nr, work(ilo + n), 1, work(ilo + 2*n), 1) + stdlib_ddot(nr, work( &
                     ilo), 1, work(ilo + 3*n), 1)
           alpha = gamma/sum
           ! determine correction to current iteration
           cmax = zero
           do i = ilo, ihi
              cor = alpha*work(i + n)
              if (abs(cor) > cmax) cmax = abs(cor)
              lscale(i) = lscale(i) + cor
              cor = alpha*work(i)
              if (abs(cor) > cmax) cmax = abs(cor)
              rscale(i) = rscale(i) + cor
           end do
           if (cmax < half) go to 350
           call stdlib_daxpy(nr, -alpha, work(ilo + 2*n), 1, work(ilo + 4*n), 1)
           call stdlib_daxpy(nr, -alpha, work(ilo + 3*n), 1, work(ilo + 5*n), 1)
           pgamma = gamma
           it = it + 1
           if (it <= nrp2) go to 250
           ! end generalized conjugate gradient iteration
350    continue
           sfmin = stdlib_dlamch('s')
           sfmax = one/sfmin
           lsfmin = int(log10(sfmin)/basl + one, KIND=ilp)
           lsfmax = int(log10(sfmax)/basl, KIND=ilp)
           do i = ilo, ihi
              irab = stdlib_izamax(n - ilo + 1, a(i, ilo), lda)
              rab = abs(a(i, irab + ilo - 1))
              irab = stdlib_izamax(n - ilo + 1, b(i, ilo), ldb)
              rab = max(rab, abs(b(i, irab + ilo - 1)))
              lrab = int(log10(rab + sfmin)/basl + one, KIND=ilp)
              ir = int(lscale(i) + sign(half, lscale(i)))
              ir = min(max(ir, lsfmin), lsfmax, lsfmax - lrab)
              lscale(i) = sclfac**ir
              icab = stdlib_izamax(ihi, a(1, i), 1)
              cab = abs(a(icab, i))
              icab = stdlib_izamax(ihi, b(1, i), 1)
              cab = max(cab, abs(b(icab, i)))
              lcab = int(log10(cab + sfmin)/basl + one, KIND=ilp)
              jc = int(rscale(i) + sign(half, rscale(i)))
              jc = min(max(jc, lsfmin), lsfmax, lsfmax - lcab)
              rscale(i) = sclfac**jc
           end do
           ! row scaling of matrices a and b
           do i = ilo, ihi
              call stdlib_zdscal(n - ilo + 1, lscale(i), a(i, ilo), lda)
              call stdlib_zdscal(n - ilo + 1, lscale(i), b(i, ilo), ldb)
           end do
           ! column scaling of matrices a and b
           do j = ilo, ihi
              call stdlib_zdscal(ihi, rscale(j), a(1, j), 1)
              call stdlib_zdscal(ihi, rscale(j), b(1, j), 1)
           end do
           return
           ! end of stdlib_zggbal
     end subroutine stdlib_zggbal

     ! ZGTSV  solves the equation
     ! A*X = B,
     ! where A is an N-by-N tridiagonal matrix, by Gaussian elimination with
     ! partial pivoting.
     ! Note that the equation  A**T *X = B  may be solved by interchanging the
     ! order of the arguments DU and DL.

     subroutine stdlib_zgtsv(n, nrhs, dl, d, du, b, ldb, info)
        ! -- lapack driver routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: info, ldb, n, nrhs
           ! .. array arguments ..
           complex(dp) :: b(ldb, *), d(*), dl(*), du(*)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: j, k
           complex(dp) :: mult, temp, zdum
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, aimag, max
     
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(zdum) = abs(real(zdum, KIND=dp)) + abs(aimag(zdum))
           ! .. executable statements ..
           info = 0
           if (n < 0) then
              info = -1
           else if (nrhs < 0) then
              info = -2
           else if (ldb < max(1, n)) then
              info = -7
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zgtsv ', -info)
              return
           end if
           if (n == 0) return
           loop_30: do k = 1, n - 1
              if (dl(k) == czero) then
                 ! subdiagonal is czero, no elimination is required.
                 if (d(k) == czero) then
                    ! diagonal is czero: set info = k and return; a unique
                    ! solution can not be found.
                    info = k
                    return
                 end if
              else if (cabs1(d(k)) >= cabs1(dl(k))) then
                 ! no row interchange required
                 mult = dl(k)/d(k)
                 d(k + 1) = d(k + 1) - mult*du(k)
                 do j = 1, nrhs
                    b(k + 1, j) = b(k + 1, j) - mult*b(k, j)
                 end do
                 if (k < (n - 1)) dl(k) = czero
              else
                 ! interchange rows k and k+1
                 mult = d(k)/dl(k)
                 d(k) = dl(k)
                 temp = d(k + 1)
                 d(k + 1) = du(k) - mult*temp
                 if (k < (n - 1)) then
                    dl(k) = du(k + 1)
                    du(k + 1) = -mult*dl(k)
                 end if
                 du(k) = temp
                 do j = 1, nrhs
                    temp = b(k, j)
                    b(k, j) = b(k + 1, j)
                    b(k + 1, j) = temp - mult*b(k + 1, j)
                 end do
              end if
           end do loop_30
           if (d(n) == czero) then
              info = n
              return
           end if
           ! back solve with the matrix u from the factorization.
           do j = 1, nrhs
              b(n, j) = b(n, j)/d(n)
              if (n > 1) b(n - 1, j) = (b(n - 1, j) - du(n - 1)*b(n, j))/d(n - 1)
              do k = n - 2, 1, -1
                 b(k, j) = (b(k, j) - du(k)*b(k + 1, j) - dl(k)*b(k + 2, j))/d(k)
                           
              end do
           end do
           return
           ! end of stdlib_zgtsv
     end subroutine stdlib_zgtsv

     ! ZGTTRF computes an LU factorization of a complex tridiagonal matrix A
     ! using elimination with partial pivoting and row interchanges.
     ! The factorization has the form
     ! A = L * U
     ! where L is a product of permutation and unit lower bidiagonal
     ! matrices and U is upper triangular with nonzeros in only the main
     ! diagonal and first two superdiagonals.

     subroutine stdlib_zgttrf(n, dl, d, du, du2, ipiv, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: info, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: d(*), dl(*), du(*), du2(*)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i
           complex(dp) :: fact, temp, zdum
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, aimag
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(zdum) = abs(real(zdum, KIND=dp)) + abs(aimag(zdum))
           ! .. executable statements ..
           info = 0
           if (n < 0) then
              info = -1
              call stdlib_xerbla('stdlib_zgttrf', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           ! initialize ipiv(i) = i and du2(i) = 0
           do i = 1, n
              ipiv(i) = i
           end do
           do i = 1, n - 2
              du2(i) = zero
           end do
           do i = 1, n - 2
              if (cabs1(d(i)) >= cabs1(dl(i))) then
                 ! no row interchange required, eliminate dl(i)
                 if (cabs1(d(i)) /= zero) then
                    fact = dl(i)/d(i)
                    dl(i) = fact
                    d(i + 1) = d(i + 1) - fact*du(i)
                 end if
              else
                 ! interchange rows i and i+1, eliminate dl(i)
                 fact = d(i)/dl(i)
                 d(i) = dl(i)
                 dl(i) = fact
                 temp = du(i)
                 du(i) = d(i + 1)
                 d(i + 1) = temp - fact*d(i + 1)
                 du2(i) = du(i + 1)
                 du(i + 1) = -fact*du(i + 1)
                 ipiv(i) = i + 1
              end if
           end do
           if (n > 1) then
              i = n - 1
              if (cabs1(d(i)) >= cabs1(dl(i))) then
                 if (cabs1(d(i)) /= zero) then
                    fact = dl(i)/d(i)
                    dl(i) = fact
                    d(i + 1) = d(i + 1) - fact*du(i)
                 end if
              else
                 fact = d(i)/dl(i)
                 d(i) = dl(i)
                 dl(i) = fact
                 temp = du(i)
                 du(i) = d(i + 1)
                 d(i + 1) = temp - fact*d(i + 1)
                 ipiv(i) = i + 1
              end if
           end if
           ! check for a zero on the diagonal of u.
           do i = 1, n
              if (cabs1(d(i)) == zero) then
                 info = i
                 go to 50
              end if
           end do
50      continue
           return
           ! end of stdlib_zgttrf
     end subroutine stdlib_zgttrf

     ! ZGTTS2 solves one of the systems of equations
     ! A * X = B,  A**T * X = B,  or  A**H * X = B,
     ! with a tridiagonal matrix A using the LU factorization computed
     ! by ZGTTRF.

     subroutine stdlib_zgtts2(itrans, n, nrhs, dl, d, du, du2, ipiv, b, ldb)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: itrans, ldb, n, nrhs
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: b(ldb, *), d(*), dl(*), du(*), du2(*)
        ! =====================================================================
           ! .. local scalars ..
           integer(ilp) :: i, j
           complex(dp) :: temp
           ! .. intrinsic functions ..
           intrinsic :: conjg
           ! .. executable statements ..
           ! quick return if possible
           if (n == 0 .or. nrhs == 0) return
           if (itrans == 0) then
              ! solve a*x = b using the lu factorization of a,
              ! overwriting each right hand side vector with its solution.
              if (nrhs <= 1) then
                 j = 1
10      continue
                 ! solve l*x = b.
                 do i = 1, n - 1
                    if (ipiv(i) == i) then
                       b(i + 1, j) = b(i + 1, j) - dl(i)*b(i, j)
                    else
                       temp = b(i, j)
                       b(i, j) = b(i + 1, j)
                       b(i + 1, j) = temp - dl(i)*b(i, j)
                    end if
                 end do
                 ! solve u*x = b.
                 b(n, j) = b(n, j)/d(n)
                 if (n > 1) b(n - 1, j) = (b(n - 1, j) - du(n - 1)*b(n, j))/d(n - 1)
                 do i = n - 2, 1, -1
                    b(i, j) = (b(i, j) - du(i)*b(i + 1, j) - du2(i)*b(i + 2, j))/d(i)
                              
                 end do
                 if (j < nrhs) then
                    j = j + 1
                    go to 10
                 end if
              else
                 do j = 1, nrhs
                 ! solve l*x = b.
                    do i = 1, n - 1
                       if (ipiv(i) == i) then
                          b(i + 1, j) = b(i + 1, j) - dl(i)*b(i, j)
                       else
                          temp = b(i, j)
                          b(i, j) = b(i + 1, j)
                          b(i + 1, j) = temp - dl(i)*b(i, j)
                       end if
                    end do
                 ! solve u*x = b.
                    b(n, j) = b(n, j)/d(n)
                    if (n > 1) b(n - 1, j) = (b(n - 1, j) - du(n - 1)*b(n, j))/d(n - 1)
                    do i = n - 2, 1, -1
                       b(i, j) = (b(i, j) - du(i)*b(i + 1, j) - du2(i)*b(i + 2, j))/d(i)
                                 
                    end do
                 end do
              end if
           else if (itrans == 1) then
              ! solve a**t * x = b.
              if (nrhs <= 1) then
                 j = 1
70      continue
                 ! solve u**t * x = b.
                 b(1, j) = b(1, j)/d(1)
                 if (n > 1) b(2, j) = (b(2, j) - du(1)*b(1, j))/d(2)
                 do i = 3, n
                    b(i, j) = (b(i, j) - du(i - 1)*b(i - 1, j) - du2(i - 2)*b(i - 2, j))/d(i &
                              )
                 end do
                 ! solve l**t * x = b.
                 do i = n - 1, 1, -1
                    if (ipiv(i) == i) then
                       b(i, j) = b(i, j) - dl(i)*b(i + 1, j)
                    else
                       temp = b(i + 1, j)
                       b(i + 1, j) = b(i, j) - dl(i)*temp
                       b(i, j) = temp
                    end if
                 end do
                 if (j < nrhs) then
                    j = j + 1
                    go to 70
                 end if
              else
                 do j = 1, nrhs
                 ! solve u**t * x = b.
                    b(1, j) = b(1, j)/d(1)
                    if (n > 1) b(2, j) = (b(2, j) - du(1)*b(1, j))/d(2)
                    do i = 3, n
                       b(i, j) = (b(i, j) - du(i - 1)*b(i - 1, j) - du2(i - 2)*b(i - 2, j))/d( &
                                  i)
                    end do
                 ! solve l**t * x = b.
                    do i = n - 1, 1, -1
                       if (ipiv(i) == i) then
                          b(i, j) = b(i, j) - dl(i)*b(i + 1, j)
                       else
                          temp = b(i + 1, j)
                          b(i + 1, j) = b(i, j) - dl(i)*temp
                          b(i, j) = temp
                       end if
                    end do
                 end do
              end if
           else
              ! solve a**h * x = b.
              if (nrhs <= 1) then
                 j = 1
130    continue
                 ! solve u**h * x = b.
                 b(1, j) = b(1, j)/conjg(d(1))
                 if (n > 1) b(2, j) = (b(2, j) - conjg(du(1))*b(1, j))/conjg(d(2))
                           
                 do i = 3, n
                    b(i, j) = (b(i, j) - conjg(du(i - 1))*b(i - 1, j) - conjg(du2(i - 2))*b( &
                              i - 2, j))/conjg(d(i))
                 end do
                 ! solve l**h * x = b.
                 do i = n - 1, 1, -1
                    if (ipiv(i) == i) then
                       b(i, j) = b(i, j) - conjg(dl(i))*b(i + 1, j)
                    else
                       temp = b(i + 1, j)
                       b(i + 1, j) = b(i, j) - conjg(dl(i))*temp
                       b(i, j) = temp
                    end if
                 end do
                 if (j < nrhs) then
                    j = j + 1
                    go to 130
                 end if
              else
                 do j = 1, nrhs
                 ! solve u**h * x = b.
                    b(1, j) = b(1, j)/conjg(d(1))
                    if (n > 1) b(2, j) = (b(2, j) - conjg(du(1))*b(1, j))/conjg(d(2))
                              
                    do i = 3, n
                       b(i, j) = (b(i, j) - conjg(du(i - 1))*b(i - 1, j) - conjg(du2(i - 2)) &
                                 *b(i - 2, j))/conjg(d(i))
                    end do
                 ! solve l**h * x = b.
                    do i = n - 1, 1, -1
                       if (ipiv(i) == i) then
                          b(i, j) = b(i, j) - conjg(dl(i))*b(i + 1, j)
                       else
                          temp = b(i + 1, j)
                          b(i + 1, j) = b(i, j) - conjg(dl(i))*temp
                          b(i, j) = temp
                       end if
                    end do
                 end do
              end if
           end if
           ! end of stdlib_zgtts2
     end subroutine stdlib_zgtts2

     ! ZHESWAPR applies an elementary permutation on the rows and the columns of
     ! a hermitian matrix.

     subroutine stdlib_zheswapr(uplo, n, a, lda, i1, i2)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: i1, i2, lda, n
           ! .. array arguments ..
           complex(dp) :: a(lda, n)
        ! =====================================================================
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: i
           complex(dp) :: tmp
     
           ! .. executable statements ..
           upper = stdlib_lsame(uplo, 'u')
           if (upper) then
               ! upper
               ! first swap
                ! - swap column i1 and i2 from i1 to i1-1
              call stdlib_zswap(i1 - 1, a(1, i1), 1, a(1, i2), 1)
                ! second swap :
                ! - swap a(i1,i1) and a(i2,i2)
                ! - swap row i1 from i1+1 to i2-1 with col i2 from i1+1 to i2-1
                ! - swap a(i2,i1) and a(i1,i2)
              tmp = a(i1, i1)
              a(i1, i1) = a(i2, i2)
              a(i2, i2) = tmp
              do i = 1, i2 - i1 - 1
                 tmp = a(i1, i1 + i)
                 a(i1, i1 + i) = conjg(a(i1 + i, i2))
                 a(i1 + i, i2) = conjg(tmp)
              end do
               a(i1, i2) = conjg(a(i1, i2))
                ! third swap
                ! - swap row i1 and i2 from i2+1 to n
              do i = i2 + 1, n
                 tmp = a(i1, i)
                 a(i1, i) = a(i2, i)
                 a(i2, i) = tmp
              end do
             else
               ! lower
               ! first swap
                ! - swap row i1 and i2 from 1 to i1-1
              call stdlib_zswap(i1 - 1, a(i1, 1), lda, a(i2, 1), lda)
               ! second swap :
                ! - swap a(i1,i1) and a(i2,i2)
                ! - swap col i1 from i1+1 to i2-1 with row i2 from i1+1 to i2-1
                ! - swap a(i2,i1) and a(i1,i2)
               tmp = a(i1, i1)
               a(i1, i1) = a(i2, i2)
               a(i2, i2) = tmp
               do i = 1, i2 - i1 - 1
                  tmp = a(i1 + i, i1)
                  a(i1 + i, i1) = conjg(a(i2, i1 + i))
                  a(i2, i1 + i) = conjg(tmp)
               end do
               a(i2, i1) = conjg(a(i2, i1))
               ! third swap
                ! - swap col i1 and i2 from i2+1 to n
               do i = i2 + 1, n
                  tmp = a(i, i1)
                  a(i, i1) = a(i, i2)
                  a(i, i2) = tmp
               end do
           end if
     end subroutine stdlib_zheswapr

     ! ZHETF2 computes the factorization of a complex Hermitian matrix A
     ! using the Bunch-Kaufman diagonal pivoting method:
     ! A = U*D*U**H  or  A = L*D*L**H
     ! where U (or L) is a product of permutation and unit upper (lower)
     ! triangular matrices, U**H is the conjugate transpose of U, and D is
     ! Hermitian and block diagonal with 1-by-1 and 2-by-2 diagonal blocks.
     ! This is the unblocked version of the algorithm, calling Level 2 BLAS.

     subroutine stdlib_zhetf2(uplo, n, a, lda, ipiv, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, lda, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: sevten = 17.0_dp
           
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: i, imax, j, jmax, k, kk, kp, kstep
           real(dp) :: absakk, alpha, colmax, d, d11, d22, r1, rowmax, tt
           complex(dp) :: d12, d21, t, wk, wkm1, wkp1, zdum
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, dcmplx, conjg, aimag, max, sqrt
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(zdum) = abs(real(zdum, KIND=dp)) + abs(aimag(zdum))
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, n)) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zhetf2', -info)
              return
           end if
           ! initialize alpha for use in choosing pivot block size.
           alpha = (one + sqrt(sevten))/eight
           if (upper) then
              ! factorize a as u*d*u**h using the upper triangle of a
              ! k is the main loop index, decreasing from n to 1 in steps of
              ! 1 or 2
              k = n
10      continue
              ! if k < 1, exit from loop
              if (k < 1) go to 90
              kstep = 1
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = abs(real(a(k, k), KIND=dp))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k > 1) then
                 imax = stdlib_izamax(k - 1, a(1, k), 1)
                 colmax = cabs1(a(imax, k))
              else
                 colmax = zero
              end if
              if ((max(absakk, colmax) == zero) .or. stdlib_disnan(absakk)) then
                 ! column k is zero or underflow, or contains a nan:
                 ! set info and continue
                 if (info == 0) info = k
                 kp = k
                 a(k, k) = real(a(k, k), KIND=dp)
              else
                 ! ============================================================
                 ! test for interchange
                 if (absakk >= alpha*colmax) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    ! jmax is the column-index of the largest off-diagonal
                    ! element in row imax, and rowmax is its absolute value.
                    ! determine only rowmax.
                    jmax = imax + stdlib_izamax(k - imax, a(imax, imax + 1), lda)
                    rowmax = cabs1(a(imax, jmax))
                    if (imax > 1) then
                       jmax = stdlib_izamax(imax - 1, a(1, imax), 1)
                       rowmax = max(rowmax, cabs1(a(jmax, imax)))
                    end if
                    if (absakk >= alpha*colmax*(colmax/rowmax)) then
                       ! no interchange, use 1-by-1 pivot block
                       kp = k
                    else if (abs(real(a(imax, imax), KIND=dp)) >= alpha*rowmax) then
                       ! interchange rows and columns k and imax, use 1-by-1
                       ! pivot block
                       kp = imax
                    else
                       ! interchange rows and columns k-1 and imax, use 2-by-2
                       ! pivot block
                       kp = imax
                       kstep = 2
                    end if
                 end if
                 ! ============================================================
                 kk = k - kstep + 1
                 if (kp /= kk) then
                    ! interchange rows and columns kk and kp in the leading
                    ! submatrix a(1:k,1:k)
                    call stdlib_zswap(kp - 1, a(1, kk), 1, a(1, kp), 1)
                    do j = kp + 1, kk - 1
                       t = conjg(a(j, kk))
                       a(j, kk) = conjg(a(kp, j))
                       a(kp, j) = t
                    end do
                    a(kp, kk) = conjg(a(kp, kk))
                    r1 = real(a(kk, kk), KIND=dp)
                    a(kk, kk) = real(a(kp, kp), KIND=dp)
                    a(kp, kp) = r1
                    if (kstep == 2) then
                       a(k, k) = real(a(k, k), KIND=dp)
                       t = a(k - 1, k)
                       a(k - 1, k) = a(kp, k)
                       a(kp, k) = t
                    end if
                 else
                    a(k, k) = real(a(k, k), KIND=dp)
                    if (kstep == 2) a(k - 1, k - 1) = real(a(k - 1, k - 1), KIND=dp)
                 end if
                 ! update the leading submatrix
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k now holds
                    ! w(k) = u(k)*d(k)
                    ! where u(k) is the k-th column of u
                    ! perform a rank-1 update of a(1:k-1,1:k-1) as
                    ! a := a - u(k)*d(k)*u(k)**h = a - w(k)*1/d(k)*w(k)**h
                    r1 = one/real(a(k, k), KIND=dp)
                    call stdlib_zher(uplo, k - 1, -r1, a(1, k), 1, a, lda)
                    ! store u(k) in column k
                    call stdlib_zdscal(k - 1, r1, a(1, k), 1)
                 else
                    ! 2-by-2 pivot block d(k): columns k and k-1 now hold
                    ! ( w(k-1) w(k) ) = ( u(k-1) u(k) )*d(k)
                    ! where u(k) and u(k-1) are the k-th and (k-1)-th columns
                    ! of u
                    ! perform a rank-2 update of a(1:k-2,1:k-2) as
                    ! a := a - ( u(k-1) u(k) )*d(k)*( u(k-1) u(k) )**h
                       ! = a - ( w(k-1) w(k) )*inv(d(k))*( w(k-1) w(k) )**h
                    if (k > 2) then
                       d = stdlib_dlapy2(real(a(k - 1, k), KIND=dp), aimag(a(k - 1, k)))
                                 
                       d22 = real(a(k - 1, k - 1), KIND=dp)/d
                       d11 = real(a(k, k), KIND=dp)/d
                       tt = one/(d11*d22 - one)
                       d12 = a(k - 1, k)/d
                       d = tt/d
                       do j = k - 2, 1, -1
                          wkm1 = d*(d11*a(j, k - 1) - conjg(d12)*a(j, k))
                          wk = d*(d22*a(j, k) - d12*a(j, k - 1))
                          do i = j, 1, -1
                             a(i, j) = a(i, j) - a(i, k)*conjg(wk) - a(i, k - 1)*conjg( &
                                       wkm1)
                          end do
                          a(j, k) = wk
                          a(j, k - 1) = wkm1
                          a(j, j) = dcmplx(real(a(j, j), KIND=dp), 0.0_dp)
                       end do
                    end if
                 end if
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -kp
                 ipiv(k - 1) = -kp
              end if
              ! decrease k and return to the start of the main loop
              k = k - kstep
              go to 10
           else
              ! factorize a as l*d*l**h using the lower triangle of a
              ! k is the main loop index, increasing from 1 to n in steps of
              ! 1 or 2
              k = 1
50      continue
              ! if k > n, exit from loop
              if (k > n) go to 90
              kstep = 1
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = abs(real(a(k, k), KIND=dp))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k < n) then
                 imax = k + stdlib_izamax(n - k, a(k + 1, k), 1)
                 colmax = cabs1(a(imax, k))
              else
                 colmax = zero
              end if
              if ((max(absakk, colmax) == zero) .or. stdlib_disnan(absakk)) then
                 ! column k is zero or underflow, or contains a nan:
                 ! set info and continue
                 if (info == 0) info = k
                 kp = k
                 a(k, k) = real(a(k, k), KIND=dp)
              else
                 ! ============================================================
                 ! test for interchange
                 if (absakk >= alpha*colmax) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    ! jmax is the column-index of the largest off-diagonal
                    ! element in row imax, and rowmax is its absolute value.
                    ! determine only rowmax.
                    jmax = k - 1 + stdlib_izamax(imax - k, a(imax, k), lda)
                    rowmax = cabs1(a(imax, jmax))
                    if (imax < n) then
                       jmax = imax + stdlib_izamax(n - imax, a(imax + 1, imax), 1)
                       rowmax = max(rowmax, cabs1(a(jmax, imax)))
                    end if
                    if (absakk >= alpha*colmax*(colmax/rowmax)) then
                       ! no interchange, use 1-by-1 pivot block
                       kp = k
                    else if (abs(real(a(imax, imax), KIND=dp)) >= alpha*rowmax) then
                       ! interchange rows and columns k and imax, use 1-by-1
                       ! pivot block
                       kp = imax
                    else
                       ! interchange rows and columns k+1 and imax, use 2-by-2
                       ! pivot block
                       kp = imax
                       kstep = 2
                    end if
                 end if
                 ! ============================================================
                 kk = k + kstep - 1
                 if (kp /= kk) then
                    ! interchange rows and columns kk and kp in the trailing
                    ! submatrix a(k:n,k:n)
                    if (kp < n) call stdlib_zswap(n - kp, a(kp + 1, kk), 1, a(kp + 1, kp), 1)
                              
                    do j = kk + 1, kp - 1
                       t = conjg(a(j, kk))
                       a(j, kk) = conjg(a(kp, j))
                       a(kp, j) = t
                    end do
                    a(kp, kk) = conjg(a(kp, kk))
                    r1 = real(a(kk, kk), KIND=dp)
                    a(kk, kk) = real(a(kp, kp), KIND=dp)
                    a(kp, kp) = r1
                    if (kstep == 2) then
                       a(k, k) = real(a(k, k), KIND=dp)
                       t = a(k + 1, k)
                       a(k + 1, k) = a(kp, k)
                       a(kp, k) = t
                    end if
                 else
                    a(k, k) = real(a(k, k), KIND=dp)
                    if (kstep == 2) a(k + 1, k + 1) = real(a(k + 1, k + 1), KIND=dp)
                 end if
                 ! update the trailing submatrix
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k now holds
                    ! w(k) = l(k)*d(k)
                    ! where l(k) is the k-th column of l
                    if (k < n) then
                       ! perform a rank-1 update of a(k+1:n,k+1:n) as
                       ! a := a - l(k)*d(k)*l(k)**h = a - w(k)*(1/d(k))*w(k)**h
                       r1 = one/real(a(k, k), KIND=dp)
                       call stdlib_zher(uplo, n - k, -r1, a(k + 1, k), 1, a(k + 1, k + 1), lda)
                                 
                       ! store l(k) in column k
                       call stdlib_zdscal(n - k, r1, a(k + 1, k), 1)
                    end if
                 else
                    ! 2-by-2 pivot block d(k)
                    if (k < n - 1) then
                       ! perform a rank-2 update of a(k+2:n,k+2:n) as
                       ! a := a - ( l(k) l(k+1) )*d(k)*( l(k) l(k+1) )**h
                          ! = a - ( w(k) w(k+1) )*inv(d(k))*( w(k) w(k+1) )**h
                       ! where l(k) and l(k+1) are the k-th and (k+1)-th
                       ! columns of l
                       d = stdlib_dlapy2(real(a(k + 1, k), KIND=dp), aimag(a(k + 1, k)))
                                 
                       d11 = real(a(k + 1, k + 1), KIND=dp)/d
                       d22 = real(a(k, k), KIND=dp)/d
                       tt = one/(d11*d22 - one)
                       d21 = a(k + 1, k)/d
                       d = tt/d
                       do j = k + 2, n
                          wk = d*(d11*a(j, k) - d21*a(j, k + 1))
                          wkp1 = d*(d22*a(j, k + 1) - conjg(d21)*a(j, k))
                          do i = j, n
                             a(i, j) = a(i, j) - a(i, k)*conjg(wk) - a(i, k + 1)*conjg( &
                                       wkp1)
                          end do
                          a(j, k) = wk
                          a(j, k + 1) = wkp1
                          a(j, j) = dcmplx(real(a(j, j), KIND=dp), 0.0_dp)
                       end do
                    end if
                 end if
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -kp
                 ipiv(k + 1) = -kp
              end if
              ! increase k and return to the start of the main loop
              k = k + kstep
              go to 50
           end if
90      continue
           return
           ! end of stdlib_zhetf2
     end subroutine stdlib_zhetf2

     ! ZHETF2_RK computes the factorization of a complex Hermitian matrix A
     ! using the bounded Bunch-Kaufman (rook) diagonal pivoting method:
     ! A = P*U*D*(U**H)*(P**T) or A = P*L*D*(L**H)*(P**T),
     ! where U (or L) is unit upper (or lower) triangular matrix,
     ! U**H (or L**H) is the conjugate of U (or L), P is a permutation
     ! matrix, P**T is the transpose of P, and D is Hermitian and block
     ! diagonal with 1-by-1 and 2-by-2 diagonal blocks.
     ! This is the unblocked version of the algorithm, calling Level 2 BLAS.
     ! For more information see Further Details section.

     subroutine stdlib_zhetf2_rk(uplo, n, a, lda, e, ipiv, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, lda, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *), e(*)
        ! ======================================================================
           ! .. parameters ..
           real(dp), parameter :: sevten = 17.0_dp
           
           ! .. local scalars ..
           logical(lk) :: done, upper
           integer(ilp) :: i, ii, imax, itemp, j, jmax, k, kk, kp, kstep, p
           real(dp) :: absakk, alpha, colmax, d, d11, d22, r1, dtemp, rowmax, tt, sfmin
           complex(dp) :: d12, d21, t, wk, wkm1, wkp1, z
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, dcmplx, conjg, aimag, max, sqrt
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(z) = abs(real(z, KIND=dp)) + abs(aimag(z))
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, n)) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zhetf2_rk', -info)
              return
           end if
           ! initialize alpha for use in choosing pivot block size.
           alpha = (one + sqrt(sevten))/eight
           ! compute machine safe minimum
           sfmin = stdlib_dlamch('s')
           if (upper) then
              ! factorize a as u*d*u**h using the upper triangle of a
              ! initialize the first entry of array e, where superdiagonal
              ! elements of d are stored
              e(1) = czero
              ! k is the main loop index, decreasing from n to 1 in steps of
              ! 1 or 2
              k = n
10      continue
              ! if k < 1, exit from loop
              if (k < 1) go to 34
              kstep = 1
              p = k
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = abs(real(a(k, k), KIND=dp))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k > 1) then
                 imax = stdlib_izamax(k - 1, a(1, k), 1)
                 colmax = cabs1(a(imax, k))
              else
                 colmax = zero
              end if
              if ((max(absakk, colmax) == zero)) then
                 ! column k is zero or underflow: set info and continue
                 if (info == 0) info = k
                 kp = k
                 a(k, k) = real(a(k, k), KIND=dp)
                 ! set e( k ) to zero
                 if (k > 1) e(k) = czero
              else
                 ! ============================================================
                 ! begin pivot search
                 ! case(1)
                 ! equivalent to testing for absakk>=alpha*colmax
                 ! (used to handle nan and inf)
                 if (.not. (absakk < alpha*colmax)) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    done = .false.
                    ! loop until pivot found
12      continue
                       ! begin pivot search loop body
                       ! jmax is the column-index of the largest off-diagonal
                       ! element in row imax, and rowmax is its absolute value.
                       ! determine both rowmax and jmax.
                       if (imax /= k) then
                          jmax = imax + stdlib_izamax(k - imax, a(imax, imax + 1), lda)
                          rowmax = cabs1(a(imax, jmax))
                       else
                          rowmax = zero
                       end if
                       if (imax > 1) then
                          itemp = stdlib_izamax(imax - 1, a(1, imax), 1)
                          dtemp = cabs1(a(itemp, imax))
                          if (dtemp > rowmax) then
                             rowmax = dtemp
                             jmax = itemp
                          end if
                       end if
                       ! case(2)
                       ! equivalent to testing for
                       ! abs( real( w( imax,kw-1 ) ,KIND=dp) )>=alpha*rowmax
                       ! (used to handle nan and inf)
                       if (.not. (abs(real(a(imax, imax), KIND=dp)) < alpha*rowmax)) &
                                 then
                          ! interchange rows and columns k and imax,
                          ! use 1-by-1 pivot block
                          kp = imax
                          done = .true.
                       ! case(3)
                       ! equivalent to testing for rowmax==colmax,
                       ! (used to handle nan and inf)
                       else if ((p == jmax) .or. (rowmax <= colmax)) then
                          ! interchange rows and columns k-1 and imax,
                          ! use 2-by-2 pivot block
                          kp = imax
                          kstep = 2
                          done = .true.
                       ! case(4)
                       else
                          ! pivot not found: set params and repeat
                          p = imax
                          colmax = rowmax
                          imax = jmax
                       end if
                       ! end pivot search loop body
                    if (.not. done) goto 12
                 end if
                 ! end pivot search
                 ! ============================================================
                 ! kk is the column of a where pivoting step stopped
                 kk = k - kstep + 1
                 ! for only a 2x2 pivot, interchange rows and columns k and p
                 ! in the leading submatrix a(1:k,1:k)
                 if ((kstep == 2) .and. (p /= k)) then
                    ! (1) swap columnar parts
                    if (p > 1) call stdlib_zswap(p - 1, a(1, k), 1, a(1, p), 1)
                    ! (2) swap and conjugate middle parts
                    do j = p + 1, k - 1
                       t = conjg(a(j, k))
                       a(j, k) = conjg(a(p, j))
                       a(p, j) = t
                    end do
                    ! (3) swap and conjugate corner elements at row-col interserction
                    a(p, k) = conjg(a(p, k))
                    ! (4) swap diagonal elements at row-col intersection
                    r1 = real(a(k, k), KIND=dp)
                    a(k, k) = real(a(p, p), KIND=dp)
                    a(p, p) = r1
                    ! convert upper triangle of a into u form by applying
                    ! the interchanges in columns k+1:n.
                    if (k < n) call stdlib_zswap(n - k, a(k, k + 1), lda, a(p, k + 1), lda)
                 end if
                 ! for both 1x1 and 2x2 pivots, interchange rows and
                 ! columns kk and kp in the leading submatrix a(1:k,1:k)
                 if (kp /= kk) then
                    ! (1) swap columnar parts
                    if (kp > 1) call stdlib_zswap(kp - 1, a(1, kk), 1, a(1, kp), 1)
                    ! (2) swap and conjugate middle parts
                    do j = kp + 1, kk - 1
                       t = conjg(a(j, kk))
                       a(j, kk) = conjg(a(kp, j))
                       a(kp, j) = t
                    end do
                    ! (3) swap and conjugate corner elements at row-col interserction
                    a(kp, kk) = conjg(a(kp, kk))
                    ! (4) swap diagonal elements at row-col intersection
                    r1 = real(a(kk, kk), KIND=dp)
                    a(kk, kk) = real(a(kp, kp), KIND=dp)
                    a(kp, kp) = r1
                    if (kstep == 2) then
                       ! (*) make sure that diagonal element of pivot is real
                       a(k, k) = real(a(k, k), KIND=dp)
                       ! (5) swap row elements
                       t = a(k - 1, k)
                       a(k - 1, k) = a(kp, k)
                       a(kp, k) = t
                    end if
                    ! convert upper triangle of a into u form by applying
                    ! the interchanges in columns k+1:n.
                    if (k < n) call stdlib_zswap(n - k, a(kk, k + 1), lda, a(kp, k + 1), lda)
                 else
                    ! (*) make sure that diagonal element of pivot is real
                    a(k, k) = real(a(k, k), KIND=dp)
                    if (kstep == 2) a(k - 1, k - 1) = real(a(k - 1, k - 1), KIND=dp)
                 end if
                 ! update the leading submatrix
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k now holds
                    ! w(k) = u(k)*d(k)
                    ! where u(k) is the k-th column of u
                    if (k > 1) then
                       ! perform a rank-1 update of a(1:k-1,1:k-1) and
                       ! store u(k) in column k
                       if (abs(real(a(k, k), KIND=dp)) >= sfmin) then
                          ! perform a rank-1 update of a(1:k-1,1:k-1) as
                          ! a := a - u(k)*d(k)*u(k)**t
                             ! = a - w(k)*1/d(k)*w(k)**t
                          d11 = one/real(a(k, k), KIND=dp)
                          call stdlib_zher(uplo, k - 1, -d11, a(1, k), 1, a, lda)
                          ! store u(k) in column k
                          call stdlib_zdscal(k - 1, d11, a(1, k), 1)
                       else
                          ! store l(k) in column k
                          d11 = real(a(k, k), KIND=dp)
                          do ii = 1, k - 1
                             a(ii, k) = a(ii, k)/d11
                          end do
                          ! perform a rank-1 update of a(k+1:n,k+1:n) as
                          ! a := a - u(k)*d(k)*u(k)**t
                             ! = a - w(k)*(1/d(k))*w(k)**t
                             ! = a - (w(k)/d(k))*(d(k))*(w(k)/d(k))**t
                          call stdlib_zher(uplo, k - 1, -d11, a(1, k), 1, a, lda)
                       end if
                       ! store the superdiagonal element of d in array e
                       e(k) = czero
                    end if
                 else
                    ! 2-by-2 pivot block d(k): columns k and k-1 now hold
                    ! ( w(k-1) w(k) ) = ( u(k-1) u(k) )*d(k)
                    ! where u(k) and u(k-1) are the k-th and (k-1)-th columns
                    ! of u
                    ! perform a rank-2 update of a(1:k-2,1:k-2) as
                    ! a := a - ( u(k-1) u(k) )*d(k)*( u(k-1) u(k) )**t
                       ! = a - ( ( a(k-1)a(k) )*inv(d(k)) ) * ( a(k-1)a(k) )**t
                    ! and store l(k) and l(k+1) in columns k and k+1
                    if (k > 2) then
                       ! d = |a12|
                       d = stdlib_dlapy2(real(a(k - 1, k), KIND=dp), aimag(a(k - 1, k)))
                                 
                       d11 = real(a(k, k)/d, KIND=dp)
                       d22 = real(a(k - 1, k - 1)/d, KIND=dp)
                       d12 = a(k - 1, k)/d
                       tt = one/(d11*d22 - one)
                       do j = k - 2, 1, -1
                          ! compute  d21 * ( w(k)w(k+1) ) * inv(d(k)) for row j
                          wkm1 = tt*(d11*a(j, k - 1) - conjg(d12)*a(j, k))
                          wk = tt*(d22*a(j, k) - d12*a(j, k - 1))
                          ! perform a rank-2 update of a(1:k-2,1:k-2)
                          do i = j, 1, -1
                             a(i, j) = a(i, j) - (a(i, k)/d)*conjg(wk) - (a(i, k - 1) &
                                       /d)*conjg(wkm1)
                          end do
                          ! store u(k) and u(k-1) in cols k and k-1 for row j
                          a(j, k) = wk/d
                          a(j, k - 1) = wkm1/d
                          ! (*) make sure that diagonal element of pivot is real
                          a(j, j) = dcmplx(real(a(j, j), KIND=dp), zero)
                       end do
                    end if
                    ! copy superdiagonal elements of d(k) to e(k) and
                    ! zero out superdiagonal entry of a
                    e(k) = a(k - 1, k)
                    e(k - 1) = czero
                    a(k - 1, k) = czero
                 end if
                 ! end column k is nonsingular
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -p
                 ipiv(k - 1) = -kp
              end if
              ! decrease k and return to the start of the main loop
              k = k - kstep
              go to 10
34      continue
           else
              ! factorize a as l*d*l**h using the lower triangle of a
              ! initialize the unused last entry of the subdiagonal array e.
              e(n) = czero
              ! k is the main loop index, increasing from 1 to n in steps of
              ! 1 or 2
              k = 1
40      continue
              ! if k > n, exit from loop
              if (k > n) go to 64
              kstep = 1
              p = k
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = abs(real(a(k, k), KIND=dp))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k < n) then
                 imax = k + stdlib_izamax(n - k, a(k + 1, k), 1)
                 colmax = cabs1(a(imax, k))
              else
                 colmax = zero
              end if
              if (max(absakk, colmax) == zero) then
                 ! column k is zero or underflow: set info and continue
                 if (info == 0) info = k
                 kp = k
                 a(k, k) = real(a(k, k), KIND=dp)
                 ! set e( k ) to zero
                 if (k < n) e(k) = czero
              else
                 ! ============================================================
                 ! begin pivot search
                 ! case(1)
                 ! equivalent to testing for absakk>=alpha*colmax
                 ! (used to handle nan and inf)
                 if (.not. (absakk < alpha*colmax)) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    done = .false.
                    ! loop until pivot found
42      continue
                       ! begin pivot search loop body
                       ! jmax is the column-index of the largest off-diagonal
                       ! element in row imax, and rowmax is its absolute value.
                       ! determine both rowmax and jmax.
                       if (imax /= k) then
                          jmax = k - 1 + stdlib_izamax(imax - k, a(imax, k), lda)
                          rowmax = cabs1(a(imax, jmax))
                       else
                          rowmax = zero
                       end if
                       if (imax < n) then
                          itemp = imax + stdlib_izamax(n - imax, a(imax + 1, imax), 1)
                          dtemp = cabs1(a(itemp, imax))
                          if (dtemp > rowmax) then
                             rowmax = dtemp
                             jmax = itemp
                          end if
                       end if
                       ! case(2)
                       ! equivalent to testing for
                       ! abs( real( w( imax,kw-1 ) ,KIND=dp) )>=alpha*rowmax
                       ! (used to handle nan and inf)
                       if (.not. (abs(real(a(imax, imax), KIND=dp)) < alpha*rowmax)) &
                                 then
                          ! interchange rows and columns k and imax,
                          ! use 1-by-1 pivot block
                          kp = imax
                          done = .true.
                       ! case(3)
                       ! equivalent to testing for rowmax==colmax,
                       ! (used to handle nan and inf)
                       else if ((p == jmax) .or. (rowmax <= colmax)) then
                          ! interchange rows and columns k+1 and imax,
                          ! use 2-by-2 pivot block
                          kp = imax
                          kstep = 2
                          done = .true.
                       ! case(4)
                       else
                          ! pivot not found: set params and repeat
                          p = imax
                          colmax = rowmax
                          imax = jmax
                       end if
                       ! end pivot search loop body
                    if (.not. done) goto 42
                 end if
                 ! end pivot search
                 ! ============================================================
                 ! kk is the column of a where pivoting step stopped
                 kk = k + kstep - 1
                 ! for only a 2x2 pivot, interchange rows and columns k and p
                 ! in the trailing submatrix a(k:n,k:n)
                 if ((kstep == 2) .and. (p /= k)) then
                    ! (1) swap columnar parts
                    if (p < n) call stdlib_zswap(n - p, a(p + 1, k), 1, a(p + 1, p), 1)
                    ! (2) swap and conjugate middle parts
                    do j = k + 1, p - 1
                       t = conjg(a(j, k))
                       a(j, k) = conjg(a(p, j))
                       a(p, j) = t
                    end do
                    ! (3) swap and conjugate corner elements at row-col interserction
                    a(p, k) = conjg(a(p, k))
                    ! (4) swap diagonal elements at row-col intersection
                    r1 = real(a(k, k), KIND=dp)
                    a(k, k) = real(a(p, p), KIND=dp)
                    a(p, p) = r1
                    ! convert lower triangle of a into l form by applying
                    ! the interchanges in columns 1:k-1.
                    if (k > 1) call stdlib_zswap(k - 1, a(k, 1), lda, a(p, 1), lda)
                 end if
                 ! for both 1x1 and 2x2 pivots, interchange rows and
                 ! columns kk and kp in the trailing submatrix a(k:n,k:n)
                 if (kp /= kk) then
                    ! (1) swap columnar parts
                    if (kp < n) call stdlib_zswap(n - kp, a(kp + 1, kk), 1, a(kp + 1, kp), 1)
                              
                    ! (2) swap and conjugate middle parts
                    do j = kk + 1, kp - 1
                       t = conjg(a(j, kk))
                       a(j, kk) = conjg(a(kp, j))
                       a(kp, j) = t
                    end do
                    ! (3) swap and conjugate corner elements at row-col interserction
                    a(kp, kk) = conjg(a(kp, kk))
                    ! (4) swap diagonal elements at row-col intersection
                    r1 = real(a(kk, kk), KIND=dp)
                    a(kk, kk) = real(a(kp, kp), KIND=dp)
                    a(kp, kp) = r1
                    if (kstep == 2) then
                       ! (*) make sure that diagonal element of pivot is real
                       a(k, k) = real(a(k, k), KIND=dp)
                       ! (5) swap row elements
                       t = a(k + 1, k)
                       a(k + 1, k) = a(kp, k)
                       a(kp, k) = t
                    end if
                    ! convert lower triangle of a into l form by applying
                    ! the interchanges in columns 1:k-1.
                    if (k > 1) call stdlib_zswap(k - 1, a(kk, 1), lda, a(kp, 1), lda)
                 else
                    ! (*) make sure that diagonal element of pivot is real
                    a(k, k) = real(a(k, k), KIND=dp)
                    if (kstep == 2) a(k + 1, k + 1) = real(a(k + 1, k + 1), KIND=dp)
                 end if
                 ! update the trailing submatrix
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k of a now holds
                    ! w(k) = l(k)*d(k),
                    ! where l(k) is the k-th column of l
                    if (k < n) then
                       ! perform a rank-1 update of a(k+1:n,k+1:n) and
                       ! store l(k) in column k
                       ! handle division by a small number
                       if (abs(real(a(k, k), KIND=dp)) >= sfmin) then
                          ! perform a rank-1 update of a(k+1:n,k+1:n) as
                          ! a := a - l(k)*d(k)*l(k)**t
                             ! = a - w(k)*(1/d(k))*w(k)**t
                          d11 = one/real(a(k, k), KIND=dp)
                          call stdlib_zher(uplo, n - k, -d11, a(k + 1, k), 1, a(k + 1, k + 1), lda)
                                    
                          ! store l(k) in column k
                          call stdlib_zdscal(n - k, d11, a(k + 1, k), 1)
                       else
                          ! store l(k) in column k
                          d11 = real(a(k, k), KIND=dp)
                          do ii = k + 1, n
                             a(ii, k) = a(ii, k)/d11
                          end do
                          ! perform a rank-1 update of a(k+1:n,k+1:n) as
                          ! a := a - l(k)*d(k)*l(k)**t
                             ! = a - w(k)*(1/d(k))*w(k)**t
                             ! = a - (w(k)/d(k))*(d(k))*(w(k)/d(k))**t
                          call stdlib_zher(uplo, n - k, -d11, a(k + 1, k), 1, a(k + 1, k + 1), lda)
                                    
                       end if
                       ! store the subdiagonal element of d in array e
                       e(k) = czero
                    end if
                 else
                    ! 2-by-2 pivot block d(k): columns k and k+1 now hold
                    ! ( w(k) w(k+1) ) = ( l(k) l(k+1) )*d(k)
                    ! where l(k) and l(k+1) are the k-th and (k+1)-th columns
                    ! of l
                    ! perform a rank-2 update of a(k+2:n,k+2:n) as
                    ! a := a - ( l(k) l(k+1) ) * d(k) * ( l(k) l(k+1) )**t
                       ! = a - ( ( a(k)a(k+1) )*inv(d(k) ) * ( a(k)a(k+1) )**t
                    ! and store l(k) and l(k+1) in columns k and k+1
                    if (k < n - 1) then
                       ! d = |a21|
                       d = stdlib_dlapy2(real(a(k + 1, k), KIND=dp), aimag(a(k + 1, k)))
                                 
                       d11 = real(a(k + 1, k + 1), KIND=dp)/d
                       d22 = real(a(k, k), KIND=dp)/d
                       d21 = a(k + 1, k)/d
                       tt = one/(d11*d22 - one)
                       do j = k + 2, n
                          ! compute  d21 * ( w(k)w(k+1) ) * inv(d(k)) for row j
                          wk = tt*(d11*a(j, k) - d21*a(j, k + 1))
                          wkp1 = tt*(d22*a(j, k + 1) - conjg(d21)*a(j, k))
                          ! perform a rank-2 update of a(k+2:n,k+2:n)
                          do i = j, n
                             a(i, j) = a(i, j) - (a(i, k)/d)*conjg(wk) - (a(i, k + 1) &
                                       /d)*conjg(wkp1)
                          end do
                          ! store l(k) and l(k+1) in cols k and k+1 for row j
                          a(j, k) = wk/d
                          a(j, k + 1) = wkp1/d
                          ! (*) make sure that diagonal element of pivot is real
                          a(j, j) = dcmplx(real(a(j, j), KIND=dp), zero)
                       end do
                    end if
                    ! copy subdiagonal elements of d(k) to e(k) and
                    ! zero out subdiagonal entry of a
                    e(k) = a(k + 1, k)
                    e(k + 1) = czero
                    a(k + 1, k) = czero
                 end if
                 ! end column k is nonsingular
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -p
                 ipiv(k + 1) = -kp
              end if
              ! increase k and return to the start of the main loop
              k = k + kstep
              go to 40
64      continue
           end if
           return
           ! end of stdlib_zhetf2_rk
     end subroutine stdlib_zhetf2_rk

     ! ZHETF2_ROOK computes the factorization of a complex Hermitian matrix A
     ! using the bounded Bunch-Kaufman ("rook") diagonal pivoting method:
     ! A = U*D*U**H  or  A = L*D*L**H
     ! where U (or L) is a product of permutation and unit upper (lower)
     ! triangular matrices, U**H is the conjugate transpose of U, and D is
     ! Hermitian and block diagonal with 1-by-1 and 2-by-2 diagonal blocks.
     ! This is the unblocked version of the algorithm, calling Level 2 BLAS.

     subroutine stdlib_zhetf2_rook(uplo, n, a, lda, ipiv, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, lda, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *)
        ! ======================================================================
           ! .. parameters ..
           real(dp), parameter :: sevten = 17.0_dp
           
           ! .. local scalars ..
           logical(lk) :: done, upper
           integer(ilp) :: i, ii, imax, itemp, j, jmax, k, kk, kp, kstep, p
           real(dp) :: absakk, alpha, colmax, d, d11, d22, r1, dtemp, rowmax, tt, sfmin
           complex(dp) :: d12, d21, t, wk, wkm1, wkp1, z
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, dcmplx, conjg, aimag, max, sqrt
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(z) = abs(real(z, KIND=dp)) + abs(aimag(z))
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, n)) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zhetf2_rook', -info)
              return
           end if
           ! initialize alpha for use in choosing pivot block size.
           alpha = (one + sqrt(sevten))/eight
           ! compute machine safe minimum
           sfmin = stdlib_dlamch('s')
           if (upper) then
              ! factorize a as u*d*u**h using the upper triangle of a
              ! k is the main loop index, decreasing from n to 1 in steps of
              ! 1 or 2
              k = n
10      continue
              ! if k < 1, exit from loop
              if (k < 1) go to 70
              kstep = 1
              p = k
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = abs(real(a(k, k), KIND=dp))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k > 1) then
                 imax = stdlib_izamax(k - 1, a(1, k), 1)
                 colmax = cabs1(a(imax, k))
              else
                 colmax = zero
              end if
              if ((max(absakk, colmax) == zero)) then
                 ! column k is zero or underflow: set info and continue
                 if (info == 0) info = k
                 kp = k
                 a(k, k) = real(a(k, k), KIND=dp)
              else
                 ! ============================================================
                 ! begin pivot search
                 ! case(1)
                 ! equivalent to testing for absakk>=alpha*colmax
                 ! (used to handle nan and inf)
                 if (.not. (absakk < alpha*colmax)) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    done = .false.
                    ! loop until pivot found
12      continue
                       ! begin pivot search loop body
                       ! jmax is the column-index of the largest off-diagonal
                       ! element in row imax, and rowmax is its absolute value.
                       ! determine both rowmax and jmax.
                       if (imax /= k) then
                          jmax = imax + stdlib_izamax(k - imax, a(imax, imax + 1), lda)
                          rowmax = cabs1(a(imax, jmax))
                       else
                          rowmax = zero
                       end if
                       if (imax > 1) then
                          itemp = stdlib_izamax(imax - 1, a(1, imax), 1)
                          dtemp = cabs1(a(itemp, imax))
                          if (dtemp > rowmax) then
                             rowmax = dtemp
                             jmax = itemp
                          end if
                       end if
                       ! case(2)
                       ! equivalent to testing for
                       ! abs( real( w( imax,kw-1 ) ,KIND=dp) )>=alpha*rowmax
                       ! (used to handle nan and inf)
                       if (.not. (abs(real(a(imax, imax), KIND=dp)) < alpha*rowmax)) &
                                 then
                          ! interchange rows and columns k and imax,
                          ! use 1-by-1 pivot block
                          kp = imax
                          done = .true.
                       ! case(3)
                       ! equivalent to testing for rowmax==colmax,
                       ! (used to handle nan and inf)
                       else if ((p == jmax) .or. (rowmax <= colmax)) then
                          ! interchange rows and columns k-1 and imax,
                          ! use 2-by-2 pivot block
                          kp = imax
                          kstep = 2
                          done = .true.
                       ! case(4)
                       else
                          ! pivot not found: set params and repeat
                          p = imax
                          colmax = rowmax
                          imax = jmax
                       end if
                       ! end pivot search loop body
                    if (.not. done) goto 12
                 end if
                 ! end pivot search
                 ! ============================================================
                 ! kk is the column of a where pivoting step stopped
                 kk = k - kstep + 1
                 ! for only a 2x2 pivot, interchange rows and columns k and p
                 ! in the leading submatrix a(1:k,1:k)
                 if ((kstep == 2) .and. (p /= k)) then
                    ! (1) swap columnar parts
                    if (p > 1) call stdlib_zswap(p - 1, a(1, k), 1, a(1, p), 1)
                    ! (2) swap and conjugate middle parts
                    do j = p + 1, k - 1
                       t = conjg(a(j, k))
                       a(j, k) = conjg(a(p, j))
                       a(p, j) = t
                    end do
                    ! (3) swap and conjugate corner elements at row-col interserction
                    a(p, k) = conjg(a(p, k))
                    ! (4) swap diagonal elements at row-col intersection
                    r1 = real(a(k, k), KIND=dp)
                    a(k, k) = real(a(p, p), KIND=dp)
                    a(p, p) = r1
                 end if
                 ! for both 1x1 and 2x2 pivots, interchange rows and
                 ! columns kk and kp in the leading submatrix a(1:k,1:k)
                 if (kp /= kk) then
                    ! (1) swap columnar parts
                    if (kp > 1) call stdlib_zswap(kp - 1, a(1, kk), 1, a(1, kp), 1)
                    ! (2) swap and conjugate middle parts
                    do j = kp + 1, kk - 1
                       t = conjg(a(j, kk))
                       a(j, kk) = conjg(a(kp, j))
                       a(kp, j) = t
                    end do
                    ! (3) swap and conjugate corner elements at row-col interserction
                    a(kp, kk) = conjg(a(kp, kk))
                    ! (4) swap diagonal elements at row-col intersection
                    r1 = real(a(kk, kk), KIND=dp)
                    a(kk, kk) = real(a(kp, kp), KIND=dp)
                    a(kp, kp) = r1
                    if (kstep == 2) then
                       ! (*) make sure that diagonal element of pivot is real
                       a(k, k) = real(a(k, k), KIND=dp)
                       ! (5) swap row elements
                       t = a(k - 1, k)
                       a(k - 1, k) = a(kp, k)
                       a(kp, k) = t
                    end if
                 else
                    ! (*) make sure that diagonal element of pivot is real
                    a(k, k) = real(a(k, k), KIND=dp)
                    if (kstep == 2) a(k - 1, k - 1) = real(a(k - 1, k - 1), KIND=dp)
                 end if
                 ! update the leading submatrix
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k now holds
                    ! w(k) = u(k)*d(k)
                    ! where u(k) is the k-th column of u
                    if (k > 1) then
                       ! perform a rank-1 update of a(1:k-1,1:k-1) and
                       ! store u(k) in column k
                       if (abs(real(a(k, k), KIND=dp)) >= sfmin) then
                          ! perform a rank-1 update of a(1:k-1,1:k-1) as
                          ! a := a - u(k)*d(k)*u(k)**t
                             ! = a - w(k)*1/d(k)*w(k)**t
                          d11 = one/real(a(k, k), KIND=dp)
                          call stdlib_zher(uplo, k - 1, -d11, a(1, k), 1, a, lda)
                          ! store u(k) in column k
                          call stdlib_zdscal(k - 1, d11, a(1, k), 1)
                       else
                          ! store l(k) in column k
                          d11 = real(a(k, k), KIND=dp)
                          do ii = 1, k - 1
                             a(ii, k) = a(ii, k)/d11
                          end do
                          ! perform a rank-1 update of a(k+1:n,k+1:n) as
                          ! a := a - u(k)*d(k)*u(k)**t
                             ! = a - w(k)*(1/d(k))*w(k)**t
                             ! = a - (w(k)/d(k))*(d(k))*(w(k)/d(k))**t
                          call stdlib_zher(uplo, k - 1, -d11, a(1, k), 1, a, lda)
                       end if
                    end if
                 else
                    ! 2-by-2 pivot block d(k): columns k and k-1 now hold
                    ! ( w(k-1) w(k) ) = ( u(k-1) u(k) )*d(k)
                    ! where u(k) and u(k-1) are the k-th and (k-1)-th columns
                    ! of u
                    ! perform a rank-2 update of a(1:k-2,1:k-2) as
                    ! a := a - ( u(k-1) u(k) )*d(k)*( u(k-1) u(k) )**t
                       ! = a - ( ( a(k-1)a(k) )*inv(d(k)) ) * ( a(k-1)a(k) )**t
                    ! and store l(k) and l(k+1) in columns k and k+1
                    if (k > 2) then
                       ! d = |a12|
                       d = stdlib_dlapy2(real(a(k - 1, k), KIND=dp), aimag(a(k - 1, k)))
                                 
                       d11 = real(a(k, k)/d, KIND=dp)
                       d22 = real(a(k - 1, k - 1)/d, KIND=dp)
                       d12 = a(k - 1, k)/d
                       tt = one/(d11*d22 - one)
                       do j = k - 2, 1, -1
                          ! compute  d21 * ( w(k)w(k+1) ) * inv(d(k)) for row j
                          wkm1 = tt*(d11*a(j, k - 1) - conjg(d12)*a(j, k))
                          wk = tt*(d22*a(j, k) - d12*a(j, k - 1))
                          ! perform a rank-2 update of a(1:k-2,1:k-2)
                          do i = j, 1, -1
                             a(i, j) = a(i, j) - (a(i, k)/d)*conjg(wk) - (a(i, k - 1) &
                                       /d)*conjg(wkm1)
                          end do
                          ! store u(k) and u(k-1) in cols k and k-1 for row j
                          a(j, k) = wk/d
                          a(j, k - 1) = wkm1/d
                          ! (*) make sure that diagonal element of pivot is real
                          a(j, j) = dcmplx(real(a(j, j), KIND=dp), zero)
                       end do
                    end if
                 end if
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -p
                 ipiv(k - 1) = -kp
              end if
              ! decrease k and return to the start of the main loop
              k = k - kstep
              go to 10
           else
              ! factorize a as l*d*l**h using the lower triangle of a
              ! k is the main loop index, increasing from 1 to n in steps of
              ! 1 or 2
              k = 1
40      continue
              ! if k > n, exit from loop
              if (k > n) go to 70
              kstep = 1
              p = k
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = abs(real(a(k, k), KIND=dp))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k < n) then
                 imax = k + stdlib_izamax(n - k, a(k + 1, k), 1)
                 colmax = cabs1(a(imax, k))
              else
                 colmax = zero
              end if
              if (max(absakk, colmax) == zero) then
                 ! column k is zero or underflow: set info and continue
                 if (info == 0) info = k
                 kp = k
                 a(k, k) = real(a(k, k), KIND=dp)
              else
                 ! ============================================================
                 ! begin pivot search
                 ! case(1)
                 ! equivalent to testing for absakk>=alpha*colmax
                 ! (used to handle nan and inf)
                 if (.not. (absakk < alpha*colmax)) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    done = .false.
                    ! loop until pivot found
42      continue
                       ! begin pivot search loop body
                       ! jmax is the column-index of the largest off-diagonal
                       ! element in row imax, and rowmax is its absolute value.
                       ! determine both rowmax and jmax.
                       if (imax /= k) then
                          jmax = k - 1 + stdlib_izamax(imax - k, a(imax, k), lda)
                          rowmax = cabs1(a(imax, jmax))
                       else
                          rowmax = zero
                       end if
                       if (imax < n) then
                          itemp = imax + stdlib_izamax(n - imax, a(imax + 1, imax), 1)
                          dtemp = cabs1(a(itemp, imax))
                          if (dtemp > rowmax) then
                             rowmax = dtemp
                             jmax = itemp
                          end if
                       end if
                       ! case(2)
                       ! equivalent to testing for
                       ! abs( real( w( imax,kw-1 ) ,KIND=dp) )>=alpha*rowmax
                       ! (used to handle nan and inf)
                       if (.not. (abs(real(a(imax, imax), KIND=dp)) < alpha*rowmax)) &
                                 then
                          ! interchange rows and columns k and imax,
                          ! use 1-by-1 pivot block
                          kp = imax
                          done = .true.
                       ! case(3)
                       ! equivalent to testing for rowmax==colmax,
                       ! (used to handle nan and inf)
                       else if ((p == jmax) .or. (rowmax <= colmax)) then
                          ! interchange rows and columns k+1 and imax,
                          ! use 2-by-2 pivot block
                          kp = imax
                          kstep = 2
                          done = .true.
                       ! case(4)
                       else
                          ! pivot not found: set params and repeat
                          p = imax
                          colmax = rowmax
                          imax = jmax
                       end if
                       ! end pivot search loop body
                    if (.not. done) goto 42
                 end if
                 ! end pivot search
                 ! ============================================================
                 ! kk is the column of a where pivoting step stopped
                 kk = k + kstep - 1
                 ! for only a 2x2 pivot, interchange rows and columns k and p
                 ! in the trailing submatrix a(k:n,k:n)
                 if ((kstep == 2) .and. (p /= k)) then
                    ! (1) swap columnar parts
                    if (p < n) call stdlib_zswap(n - p, a(p + 1, k), 1, a(p + 1, p), 1)
                    ! (2) swap and conjugate middle parts
                    do j = k + 1, p - 1
                       t = conjg(a(j, k))
                       a(j, k) = conjg(a(p, j))
                       a(p, j) = t
                    end do
                    ! (3) swap and conjugate corner elements at row-col interserction
                    a(p, k) = conjg(a(p, k))
                    ! (4) swap diagonal elements at row-col intersection
                    r1 = real(a(k, k), KIND=dp)
                    a(k, k) = real(a(p, p), KIND=dp)
                    a(p, p) = r1
                 end if
                 ! for both 1x1 and 2x2 pivots, interchange rows and
                 ! columns kk and kp in the trailing submatrix a(k:n,k:n)
                 if (kp /= kk) then
                    ! (1) swap columnar parts
                    if (kp < n) call stdlib_zswap(n - kp, a(kp + 1, kk), 1, a(kp + 1, kp), 1)
                              
                    ! (2) swap and conjugate middle parts
                    do j = kk + 1, kp - 1
                       t = conjg(a(j, kk))
                       a(j, kk) = conjg(a(kp, j))
                       a(kp, j) = t
                    end do
                    ! (3) swap and conjugate corner elements at row-col interserction
                    a(kp, kk) = conjg(a(kp, kk))
                    ! (4) swap diagonal elements at row-col intersection
                    r1 = real(a(kk, kk), KIND=dp)
                    a(kk, kk) = real(a(kp, kp), KIND=dp)
                    a(kp, kp) = r1
                    if (kstep == 2) then
                       ! (*) make sure that diagonal element of pivot is real
                       a(k, k) = real(a(k, k), KIND=dp)
                       ! (5) swap row elements
                       t = a(k + 1, k)
                       a(k + 1, k) = a(kp, k)
                       a(kp, k) = t
                    end if
                 else
                    ! (*) make sure that diagonal element of pivot is real
                    a(k, k) = real(a(k, k), KIND=dp)
                    if (kstep == 2) a(k + 1, k + 1) = real(a(k + 1, k + 1), KIND=dp)
                 end if
                 ! update the trailing submatrix
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k of a now holds
                    ! w(k) = l(k)*d(k),
                    ! where l(k) is the k-th column of l
                    if (k < n) then
                       ! perform a rank-1 update of a(k+1:n,k+1:n) and
                       ! store l(k) in column k
                       ! handle division by a small number
                       if (abs(real(a(k, k), KIND=dp)) >= sfmin) then
                          ! perform a rank-1 update of a(k+1:n,k+1:n) as
                          ! a := a - l(k)*d(k)*l(k)**t
                             ! = a - w(k)*(1/d(k))*w(k)**t
                          d11 = one/real(a(k, k), KIND=dp)
                          call stdlib_zher(uplo, n - k, -d11, a(k + 1, k), 1, a(k + 1, k + 1), lda)
                                    
                          ! store l(k) in column k
                          call stdlib_zdscal(n - k, d11, a(k + 1, k), 1)
                       else
                          ! store l(k) in column k
                          d11 = real(a(k, k), KIND=dp)
                          do ii = k + 1, n
                             a(ii, k) = a(ii, k)/d11
                          end do
                          ! perform a rank-1 update of a(k+1:n,k+1:n) as
                          ! a := a - l(k)*d(k)*l(k)**t
                             ! = a - w(k)*(1/d(k))*w(k)**t
                             ! = a - (w(k)/d(k))*(d(k))*(w(k)/d(k))**t
                          call stdlib_zher(uplo, n - k, -d11, a(k + 1, k), 1, a(k + 1, k + 1), lda)
                                    
                       end if
                    end if
                 else
                    ! 2-by-2 pivot block d(k): columns k and k+1 now hold
                    ! ( w(k) w(k+1) ) = ( l(k) l(k+1) )*d(k)
                    ! where l(k) and l(k+1) are the k-th and (k+1)-th columns
                    ! of l
                    ! perform a rank-2 update of a(k+2:n,k+2:n) as
                    ! a := a - ( l(k) l(k+1) ) * d(k) * ( l(k) l(k+1) )**t
                       ! = a - ( ( a(k)a(k+1) )*inv(d(k) ) * ( a(k)a(k+1) )**t
                    ! and store l(k) and l(k+1) in columns k and k+1
                    if (k < n - 1) then
                       ! d = |a21|
                       d = stdlib_dlapy2(real(a(k + 1, k), KIND=dp), aimag(a(k + 1, k)))
                                 
                       d11 = real(a(k + 1, k + 1), KIND=dp)/d
                       d22 = real(a(k, k), KIND=dp)/d
                       d21 = a(k + 1, k)/d
                       tt = one/(d11*d22 - one)
                       do j = k + 2, n
                          ! compute  d21 * ( w(k)w(k+1) ) * inv(d(k)) for row j
                          wk = tt*(d11*a(j, k) - d21*a(j, k + 1))
                          wkp1 = tt*(d22*a(j, k + 1) - conjg(d21)*a(j, k))
                          ! perform a rank-2 update of a(k+2:n,k+2:n)
                          do i = j, n
                             a(i, j) = a(i, j) - (a(i, k)/d)*conjg(wk) - (a(i, k + 1) &
                                       /d)*conjg(wkp1)
                          end do
                          ! store l(k) and l(k+1) in cols k and k+1 for row j
                          a(j, k) = wk/d
                          a(j, k + 1) = wkp1/d
                          ! (*) make sure that diagonal element of pivot is real
                          a(j, j) = dcmplx(real(a(j, j), KIND=dp), zero)
                       end do
                    end if
                 end if
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -p
                 ipiv(k + 1) = -kp
              end if
              ! increase k and return to the start of the main loop
              k = k + kstep
              go to 40
           end if
70      continue
           return
           ! end of stdlib_zhetf2_rook
     end subroutine stdlib_zhetf2_rook

     ! ZHETRI computes the inverse of a complex Hermitian indefinite matrix
     ! A using the factorization A = U*D*U**H or A = L*D*L**H computed by
     ! ZHETRF.

     subroutine stdlib_zhetri(uplo, n, a, lda, ipiv, work, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, lda, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *), work(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: j, k, kp, kstep
           real(dp) :: ak, akp1, d, t
           complex(dp) :: akkp1, temp
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, conjg, max
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, n)) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zhetri', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           ! check that the diagonal matrix d is nonsingular.
           if (upper) then
              ! upper triangular storage: examine d from bottom to top
              do info = n, 1, -1
                 if (ipiv(info) > 0 .and. a(info, info) == czero) return
              end do
           else
              ! lower triangular storage: examine d from top to bottom.
              do info = 1, n
                 if (ipiv(info) > 0 .and. a(info, info) == czero) return
              end do
           end if
           info = 0
           if (upper) then
              ! compute inv(a) from the factorization a = u*d*u**h.
              ! k is the main loop index, increasing from 1 to n in steps of
              ! 1 or 2, depending on the size of the diagonal blocks.
              k = 1
30      continue
              ! if k > n, exit from loop.
              if (k > n) go to 50
              if (ipiv(k) > 0) then
                 ! 1 x 1 diagonal block
                 ! invert the diagonal block.
                 a(k, k) = one/real(a(k, k), KIND=dp)
                 ! compute column k of the inverse.
                 if (k > 1) then
                    call stdlib_zcopy(k - 1, a(1, k), 1, work, 1)
                    call stdlib_zhemv(uplo, k - 1, -cone, a, lda, work, 1, czero, a(1, k), 1)
                              
                    a(k, k) = a(k, k) - dble(stdlib_zdotc(k - 1, work, 1, a(1, k), 1))
                              
                 end if
                 kstep = 1
              else
                 ! 2 x 2 diagonal block
                 ! invert the diagonal block.
                 t = abs(a(k, k + 1))
                 ak = real(a(k, k), KIND=dp)/t
                 akp1 = real(a(k + 1, k + 1), KIND=dp)/t
                 akkp1 = a(k, k + 1)/t
                 d = t*(ak*akp1 - one)
                 a(k, k) = akp1/d
                 a(k + 1, k + 1) = ak/d
                 a(k, k + 1) = -akkp1/d
                 ! compute columns k and k+1 of the inverse.
                 if (k > 1) then
                    call stdlib_zcopy(k - 1, a(1, k), 1, work, 1)
                    call stdlib_zhemv(uplo, k - 1, -cone, a, lda, work, 1, czero, a(1, k), 1)
                              
                    a(k, k) = a(k, k) - dble(stdlib_zdotc(k - 1, work, 1, a(1, k), 1))
                              
                    a(k, k + 1) = a(k, k + 1) - stdlib_zdotc(k - 1, a(1, k), 1, a(1, k + 1), 1)
                              
                    call stdlib_zcopy(k - 1, a(1, k + 1), 1, work, 1)
                    call stdlib_zhemv(uplo, k - 1, -cone, a, lda, work, 1, czero, a(1, k + 1), 1)
                              
                    a(k + 1, k + 1) = a(k + 1, k + 1) - dble(stdlib_zdotc(k - 1, work, 1, a(1, k + 1), &
                              1))
                 end if
                 kstep = 2
              end if
              kp = abs(ipiv(k))
              if (kp /= k) then
                 ! interchange rows and columns k and kp in the leading
                 ! submatrix a(1:k+1,1:k+1)
                 call stdlib_zswap(kp - 1, a(1, k), 1, a(1, kp), 1)
                 do j = kp + 1, k - 1
                    temp = conjg(a(j, k))
                    a(j, k) = conjg(a(kp, j))
                    a(kp, j) = temp
                 end do
                 a(kp, k) = conjg(a(kp, k))
                 temp = a(k, k)
                 a(k, k) = a(kp, kp)
                 a(kp, kp) = temp
                 if (kstep == 2) then
                    temp = a(k, k + 1)
                    a(k, k + 1) = a(kp, k + 1)
                    a(kp, k + 1) = temp
                 end if
              end if
              k = k + kstep
              go to 30
50      continue
           else
              ! compute inv(a) from the factorization a = l*d*l**h.
              ! k is the main loop index, increasing from 1 to n in steps of
              ! 1 or 2, depending on the size of the diagonal blocks.
              k = n
60      continue
              ! if k < 1, exit from loop.
              if (k < 1) go to 80
              if (ipiv(k) > 0) then
                 ! 1 x 1 diagonal block
                 ! invert the diagonal block.
                 a(k, k) = one/real(a(k, k), KIND=dp)
                 ! compute column k of the inverse.
                 if (k < n) then
                    call stdlib_zcopy(n - k, a(k + 1, k), 1, work, 1)
                    call stdlib_zhemv(uplo, n - k, -cone, a(k + 1, k + 1), lda, work, 1, czero, a(k + &
                              1, k), 1)
                    a(k, k) = a(k, k) - dble(stdlib_zdotc(n - k, work, 1, a(k + 1, k), 1))
                              
                 end if
                 kstep = 1
              else
                 ! 2 x 2 diagonal block
                 ! invert the diagonal block.
                 t = abs(a(k, k - 1))
                 ak = real(a(k - 1, k - 1), KIND=dp)/t
                 akp1 = real(a(k, k), KIND=dp)/t
                 akkp1 = a(k, k - 1)/t
                 d = t*(ak*akp1 - one)
                 a(k - 1, k - 1) = akp1/d
                 a(k, k) = ak/d
                 a(k, k - 1) = -akkp1/d
                 ! compute columns k-1 and k of the inverse.
                 if (k < n) then
                    call stdlib_zcopy(n - k, a(k + 1, k), 1, work, 1)
                    call stdlib_zhemv(uplo, n - k, -cone, a(k + 1, k + 1), lda, work, 1, czero, a(k + &
                              1, k), 1)
                    a(k, k) = a(k, k) - dble(stdlib_zdotc(n - k, work, 1, a(k + 1, k), 1))
                              
                    a(k, k - 1) = a(k, k - 1) - stdlib_zdotc(n - k, a(k + 1, k), 1, a(k + 1, k - 1), 1 &
                              )
                    call stdlib_zcopy(n - k, a(k + 1, k - 1), 1, work, 1)
                    call stdlib_zhemv(uplo, n - k, -cone, a(k + 1, k + 1), lda, work, 1, czero, a(k + &
                              1, k - 1), 1)
                    a(k - 1, k - 1) = a(k - 1, k - 1) - dble(stdlib_zdotc(n - k, work, 1, a(k + 1, k - 1) &
                              , 1))
                 end if
                 kstep = 2
              end if
              kp = abs(ipiv(k))
              if (kp /= k) then
                 ! interchange rows and columns k and kp in the trailing
                 ! submatrix a(k-1:n,k-1:n)
                 if (kp < n) call stdlib_zswap(n - kp, a(kp + 1, k), 1, a(kp + 1, kp), 1)
                 do j = k + 1, kp - 1
                    temp = conjg(a(j, k))
                    a(j, k) = conjg(a(kp, j))
                    a(kp, j) = temp
                 end do
                 a(kp, k) = conjg(a(kp, k))
                 temp = a(k, k)
                 a(k, k) = a(kp, kp)
                 a(kp, kp) = temp
                 if (kstep == 2) then
                    temp = a(k, k - 1)
                    a(k, k - 1) = a(kp, k - 1)
                    a(kp, k - 1) = temp
                 end if
              end if
              k = k - kstep
              go to 60
80      continue
           end if
           return
           ! end of stdlib_zhetri
     end subroutine stdlib_zhetri

     ! ZHETRI_ROOK computes the inverse of a complex Hermitian indefinite matrix
     ! A using the factorization A = U*D*U**H or A = L*D*L**H computed by
     ! ZHETRF_ROOK.

     subroutine stdlib_zhetri_rook(uplo, n, a, lda, ipiv, work, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, lda, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *), work(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: j, k, kp, kstep
           real(dp) :: ak, akp1, d, t
           complex(dp) :: akkp1, temp
     
           ! .. intrinsic functions ..
           intrinsic :: abs, conjg, max, dble
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, n)) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zhetri_rook', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           ! check that the diagonal matrix d is nonsingular.
           if (upper) then
              ! upper triangular storage: examine d from bottom to top
              do info = n, 1, -1
                 if (ipiv(info) > 0 .and. a(info, info) == czero) return
              end do
           else
              ! lower triangular storage: examine d from top to bottom.
              do info = 1, n
                 if (ipiv(info) > 0 .and. a(info, info) == czero) return
              end do
           end if
           info = 0
           if (upper) then
              ! compute inv(a) from the factorization a = u*d*u**h.
              ! k is the main loop index, increasing from 1 to n in steps of
              ! 1 or 2, depending on the size of the diagonal blocks.
              k = 1
30      continue
              ! if k > n, exit from loop.
              if (k > n) go to 70
              if (ipiv(k) > 0) then
                 ! 1 x 1 diagonal block
                 ! invert the diagonal block.
                 a(k, k) = one/real(a(k, k), KIND=dp)
                 ! compute column k of the inverse.
                 if (k > 1) then
                    call stdlib_zcopy(k - 1, a(1, k), 1, work, 1)
                    call stdlib_zhemv(uplo, k - 1, -cone, a, lda, work, 1, czero, a(1, k), 1)
                              
                    a(k, k) = a(k, k) - dble(stdlib_zdotc(k - 1, work, 1, a(1, k), 1))
                              
                 end if
                 kstep = 1
              else
                 ! 2 x 2 diagonal block
                 ! invert the diagonal block.
                 t = abs(a(k, k + 1))
                 ak = real(a(k, k), KIND=dp)/t
                 akp1 = real(a(k + 1, k + 1), KIND=dp)/t
                 akkp1 = a(k, k + 1)/t
                 d = t*(ak*akp1 - one)
                 a(k, k) = akp1/d
                 a(k + 1, k + 1) = ak/d
                 a(k, k + 1) = -akkp1/d
                 ! compute columns k and k+1 of the inverse.
                 if (k > 1) then
                    call stdlib_zcopy(k - 1, a(1, k), 1, work, 1)
                    call stdlib_zhemv(uplo, k - 1, -cone, a, lda, work, 1, czero, a(1, k), 1)
                              
                    a(k, k) = a(k, k) - dble(stdlib_zdotc(k - 1, work, 1, a(1, k), 1))
                              
                    a(k, k + 1) = a(k, k + 1) - stdlib_zdotc(k - 1, a(1, k), 1, a(1, k + 1), 1)
                              
                    call stdlib_zcopy(k - 1, a(1, k + 1), 1, work, 1)
                    call stdlib_zhemv(uplo, k - 1, -cone, a, lda, work, 1, czero, a(1, k + 1), 1)
                              
                    a(k + 1, k + 1) = a(k + 1, k + 1) - dble(stdlib_zdotc(k - 1, work, 1, a(1, k + 1), &
                              1))
                 end if
                 kstep = 2
              end if
              if (kstep == 1) then
                 ! interchange rows and columns k and ipiv(k) in the leading
                 ! submatrix a(1:k,1:k)
                 kp = ipiv(k)
                 if (kp /= k) then
                    if (kp > 1) call stdlib_zswap(kp - 1, a(1, k), 1, a(1, kp), 1)
                    do j = kp + 1, k - 1
                       temp = conjg(a(j, k))
                       a(j, k) = conjg(a(kp, j))
                       a(kp, j) = temp
                    end do
                    a(kp, k) = conjg(a(kp, k))
                    temp = a(k, k)
                    a(k, k) = a(kp, kp)
                    a(kp, kp) = temp
                 end if
              else
                 ! interchange rows and columns k and k+1 with -ipiv(k) and
                 ! -ipiv(k+1) in the leading submatrix a(k+1:n,k+1:n)
                 ! (1) interchange rows and columns k and -ipiv(k)
                 kp = -ipiv(k)
                 if (kp /= k) then
                    if (kp > 1) call stdlib_zswap(kp - 1, a(1, k), 1, a(1, kp), 1)
                    do j = kp + 1, k - 1
                       temp = conjg(a(j, k))
                       a(j, k) = conjg(a(kp, j))
                       a(kp, j) = temp
                    end do
                    a(kp, k) = conjg(a(kp, k))
                    temp = a(k, k)
                    a(k, k) = a(kp, kp)
                    a(kp, kp) = temp
                    temp = a(k, k + 1)
                    a(k, k + 1) = a(kp, k + 1)
                    a(kp, k + 1) = temp
                 end if
                 ! (2) interchange rows and columns k+1 and -ipiv(k+1)
                 k = k + 1
                 kp = -ipiv(k)
                 if (kp /= k) then
                    if (kp > 1) call stdlib_zswap(kp - 1, a(1, k), 1, a(1, kp), 1)
                    do j = kp + 1, k - 1
                       temp = conjg(a(j, k))
                       a(j, k) = conjg(a(kp, j))
                       a(kp, j) = temp
                    end do
                    a(kp, k) = conjg(a(kp, k))
                    temp = a(k, k)
                    a(k, k) = a(kp, kp)
                    a(kp, kp) = temp
                 end if
              end if
              k = k + 1
              go to 30
70      continue
           else
              ! compute inv(a) from the factorization a = l*d*l**h.
              ! k is the main loop index, decreasing from n to 1 in steps of
              ! 1 or 2, depending on the size of the diagonal blocks.
              k = n
80      continue
              ! if k < 1, exit from loop.
              if (k < 1) go to 120
              if (ipiv(k) > 0) then
                 ! 1 x 1 diagonal block
                 ! invert the diagonal block.
                 a(k, k) = one/real(a(k, k), KIND=dp)
                 ! compute column k of the inverse.
                 if (k < n) then
                    call stdlib_zcopy(n - k, a(k + 1, k), 1, work, 1)
                    call stdlib_zhemv(uplo, n - k, -cone, a(k + 1, k + 1), lda, work, 1, czero, a(k + &
                              1, k), 1)
                    a(k, k) = a(k, k) - dble(stdlib_zdotc(n - k, work, 1, a(k + 1, k), 1))
                              
                 end if
                 kstep = 1
              else
                 ! 2 x 2 diagonal block
                 ! invert the diagonal block.
                 t = abs(a(k, k - 1))
                 ak = real(a(k - 1, k - 1), KIND=dp)/t
                 akp1 = real(a(k, k), KIND=dp)/t
                 akkp1 = a(k, k - 1)/t
                 d = t*(ak*akp1 - one)
                 a(k - 1, k - 1) = akp1/d
                 a(k, k) = ak/d
                 a(k, k - 1) = -akkp1/d
                 ! compute columns k-1 and k of the inverse.
                 if (k < n) then
                    call stdlib_zcopy(n - k, a(k + 1, k), 1, work, 1)
                    call stdlib_zhemv(uplo, n - k, -cone, a(k + 1, k + 1), lda, work, 1, czero, a(k + &
                              1, k), 1)
                    a(k, k) = a(k, k) - dble(stdlib_zdotc(n - k, work, 1, a(k + 1, k), 1))
                              
                    a(k, k - 1) = a(k, k - 1) - stdlib_zdotc(n - k, a(k + 1, k), 1, a(k + 1, k - 1), 1 &
                              )
                    call stdlib_zcopy(n - k, a(k + 1, k - 1), 1, work, 1)
                    call stdlib_zhemv(uplo, n - k, -cone, a(k + 1, k + 1), lda, work, 1, czero, a(k + &
                              1, k - 1), 1)
                    a(k - 1, k - 1) = a(k - 1, k - 1) - dble(stdlib_zdotc(n - k, work, 1, a(k + 1, k - 1) &
                              , 1))
                 end if
                 kstep = 2
              end if
              if (kstep == 1) then
                 ! interchange rows and columns k and ipiv(k) in the trailing
                 ! submatrix a(k:n,k:n)
                 kp = ipiv(k)
                 if (kp /= k) then
                    if (kp < n) call stdlib_zswap(n - kp, a(kp + 1, k), 1, a(kp + 1, kp), 1)
                    do j = k + 1, kp - 1
                       temp = conjg(a(j, k))
                       a(j, k) = conjg(a(kp, j))
                       a(kp, j) = temp
                    end do
                    a(kp, k) = conjg(a(kp, k))
                    temp = a(k, k)
                    a(k, k) = a(kp, kp)
                    a(kp, kp) = temp
                 end if
              else
                 ! interchange rows and columns k and k-1 with -ipiv(k) and
                 ! -ipiv(k-1) in the trailing submatrix a(k-1:n,k-1:n)
                 ! (1) interchange rows and columns k and -ipiv(k)
                 kp = -ipiv(k)
                 if (kp /= k) then
                    if (kp < n) call stdlib_zswap(n - kp, a(kp + 1, k), 1, a(kp + 1, kp), 1)
                    do j = k + 1, kp - 1
                       temp = conjg(a(j, k))
                       a(j, k) = conjg(a(kp, j))
                       a(kp, j) = temp
                    end do
                    a(kp, k) = conjg(a(kp, k))
                    temp = a(k, k)
                    a(k, k) = a(kp, kp)
                    a(kp, kp) = temp
                    temp = a(k, k - 1)
                    a(k, k - 1) = a(kp, k - 1)
                    a(kp, k - 1) = temp
                 end if
                 ! (2) interchange rows and columns k-1 and -ipiv(k-1)
                 k = k - 1
                 kp = -ipiv(k)
                 if (kp /= k) then
                    if (kp < n) call stdlib_zswap(n - kp, a(kp + 1, k), 1, a(kp + 1, kp), 1)
                    do j = k + 1, kp - 1
                       temp = conjg(a(j, k))
                       a(j, k) = conjg(a(kp, j))
                       a(kp, j) = temp
                    end do
                    a(kp, k) = conjg(a(kp, k))
                    temp = a(k, k)
                    a(k, k) = a(kp, kp)
                    a(kp, kp) = temp
                 end if
              end if
              k = k - 1
              go to 80
120    continue
           end if
           return
           ! end of stdlib_zhetri_rook
     end subroutine stdlib_zhetri_rook

     ! ZHETRS_3 solves a system of linear equations A * X = B with a complex
     ! Hermitian matrix A using the factorization computed
     ! by ZHETRF_RK or ZHETRF_BK:
     ! A = P*U*D*(U**H)*(P**T) or A = P*L*D*(L**H)*(P**T),
     ! where U (or L) is unit upper (or lower) triangular matrix,
     ! U**H (or L**H) is the conjugate of U (or L), P is a permutation
     ! matrix, P**T is the transpose of P, and D is Hermitian and block
     ! diagonal with 1-by-1 and 2-by-2 diagonal blocks.
     ! This algorithm is using Level 3 BLAS.

     subroutine stdlib_zhetrs_3(uplo, n, nrhs, a, lda, e, ipiv, b, ldb, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, lda, ldb, n, nrhs
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *), b(ldb, *), e(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: i, j, k, kp
           real(dp) :: s
           complex(dp) :: ak, akm1, akm1k, bk, bkm1, denom
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, conjg, max
           ! .. executable statements ..
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (nrhs < 0) then
              info = -3
           else if (lda < max(1, n)) then
              info = -5
           else if (ldb < max(1, n)) then
              info = -9
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zhetrs_3', -info)
              return
           end if
           ! quick return if possible
           if (n == 0 .or. nrhs == 0) return
           if (upper) then
              ! begin upper
              ! solve a*x = b, where a = u*d*u**h.
              ! p**t * b
              ! interchange rows k and ipiv(k) of matrix b in the same order
              ! that the formation order of ipiv(i) vector for upper case.
              ! (we can do the simple loop over ipiv with decrement -1,
              ! since the abs value of ipiv(i) represents the row index
              ! of the interchange with row i in both 1x1 and 2x2 pivot cases)
              do k = n, 1, -1
                 kp = abs(ipiv(k))
                 if (kp /= k) then
                    call stdlib_zswap(nrhs, b(k, 1), ldb, b(kp, 1), ldb)
                 end if
              end do
              ! compute (u \p**t * b) -> b    [ (u \p**t * b) ]
              call stdlib_ztrsm('l', 'u', 'n', 'u', n, nrhs, cone, a, lda, b, ldb)
              ! compute d \ b -> b   [ d \ (u \p**t * b) ]
              i = n
              do while (i >= 1)
                 if (ipiv(i) > 0) then
                    s = real(cone, KIND=dp)/real(a(i, i), KIND=dp)
                    call stdlib_zdscal(nrhs, s, b(i, 1), ldb)
                 else if (i > 1) then
                    akm1k = e(i)
                    akm1 = a(i - 1, i - 1)/akm1k
                    ak = a(i, i)/conjg(akm1k)
                    denom = akm1*ak - cone
                    do j = 1, nrhs
                       bkm1 = b(i - 1, j)/akm1k
                       bk = b(i, j)/conjg(akm1k)
                       b(i - 1, j) = (ak*bkm1 - bk)/denom
                       b(i, j) = (akm1*bk - bkm1)/denom
                    end do
                    i = i - 1
                 end if
                 i = i - 1
              end do
              ! compute (u**h \ b) -> b   [ u**h \ (d \ (u \p**t * b) ) ]
              call stdlib_ztrsm('l', 'u', 'c', 'u', n, nrhs, cone, a, lda, b, ldb)
              ! p * b  [ p * (u**h \ (d \ (u \p**t * b) )) ]
              ! interchange rows k and ipiv(k) of matrix b in reverse order
              ! from the formation order of ipiv(i) vector for upper case.
              ! (we can do the simple loop over ipiv with increment 1,
              ! since the abs value of ipiv(i) represents the row index
              ! of the interchange with row i in both 1x1 and 2x2 pivot cases)
              do k = 1, n, 1
                 kp = abs(ipiv(k))
                 if (kp /= k) then
                    call stdlib_zswap(nrhs, b(k, 1), ldb, b(kp, 1), ldb)
                 end if
              end do
           else
              ! begin lower
              ! solve a*x = b, where a = l*d*l**h.
              ! p**t * b
              ! interchange rows k and ipiv(k) of matrix b in the same order
              ! that the formation order of ipiv(i) vector for lower case.
              ! (we can do the simple loop over ipiv with increment 1,
              ! since the abs value of ipiv(i) represents the row index
              ! of the interchange with row i in both 1x1 and 2x2 pivot cases)
              do k = 1, n, 1
                 kp = abs(ipiv(k))
                 if (kp /= k) then
                    call stdlib_zswap(nrhs, b(k, 1), ldb, b(kp, 1), ldb)
                 end if
              end do
              ! compute (l \p**t * b) -> b    [ (l \p**t * b) ]
              call stdlib_ztrsm('l', 'l', 'n', 'u', n, nrhs, cone, a, lda, b, ldb)
              ! compute d \ b -> b   [ d \ (l \p**t * b) ]
              i = 1
              do while (i <= n)
                 if (ipiv(i) > 0) then
                    s = real(cone, KIND=dp)/real(a(i, i), KIND=dp)
                    call stdlib_zdscal(nrhs, s, b(i, 1), ldb)
                 else if (i < n) then
                    akm1k = e(i)
                    akm1 = a(i, i)/conjg(akm1k)
                    ak = a(i + 1, i + 1)/akm1k
                    denom = akm1*ak - cone
                    do j = 1, nrhs
                       bkm1 = b(i, j)/conjg(akm1k)
                       bk = b(i + 1, j)/akm1k
                       b(i, j) = (ak*bkm1 - bk)/denom
                       b(i + 1, j) = (akm1*bk - bkm1)/denom
                    end do
                    i = i + 1
                 end if
                 i = i + 1
              end do
              ! compute (l**h \ b) -> b   [ l**h \ (d \ (l \p**t * b) ) ]
              call stdlib_ztrsm('l', 'l', 'c', 'u', n, nrhs, cone, a, lda, b, ldb)
              ! p * b  [ p * (l**h \ (d \ (l \p**t * b) )) ]
              ! interchange rows k and ipiv(k) of matrix b in reverse order
              ! from the formation order of ipiv(i) vector for lower case.
              ! (we can do the simple loop over ipiv with decrement -1,
              ! since the abs value of ipiv(i) represents the row index
              ! of the interchange with row i in both 1x1 and 2x2 pivot cases)
              do k = n, 1, -1
                 kp = abs(ipiv(k))
                 if (kp /= k) then
                    call stdlib_zswap(nrhs, b(k, 1), ldb, b(kp, 1), ldb)
                 end if
              end do
              ! end lower
           end if
           return
           ! end of stdlib_zhetrs_3
     end subroutine stdlib_zhetrs_3

     ! Level 3 BLAS like routine for C in RFP Format.
     ! ZHFRK performs one of the Hermitian rank--k operations
     ! C := alpha*A*A**H + beta*C,
     ! or
     ! C := alpha*A**H*A + beta*C,
     ! where alpha and beta are real scalars, C is an n--by--n Hermitian
     ! matrix and A is an n--by--k matrix in the first case and a k--by--n
     ! matrix in the second case.

     subroutine stdlib_zhfrk(transr, uplo, trans, n, k, alpha, a, lda, beta, c)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           real(dp) :: alpha, beta
           integer(ilp) :: k, lda, n
           character :: trans, transr, uplo
           ! .. array arguments ..
           complex(dp) :: a(lda, *), c(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: lower, normaltransr, nisodd, notrans
           integer(ilp) :: info, nrowa, j, nk, n1, n2
           complex(dp) :: calpha, cbeta
     
           ! .. intrinsic functions ..
           intrinsic :: max, dcmplx
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           normaltransr = stdlib_lsame(transr, 'n')
           lower = stdlib_lsame(uplo, 'l')
           notrans = stdlib_lsame(trans, 'n')
           if (notrans) then
              nrowa = n
           else
              nrowa = k
           end if
           if (.not. normaltransr .and. .not. stdlib_lsame(transr, 'c')) then
              info = -1
           else if (.not. lower .and. .not. stdlib_lsame(uplo, 'u')) then
              info = -2
           else if (.not. notrans .and. .not. stdlib_lsame(trans, 'c')) then
              info = -3
           else if (n < 0) then
              info = -4
           else if (k < 0) then
              info = -5
           else if (lda < max(1, nrowa)) then
              info = -8
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zhfrk ', -info)
              return
           end if
           ! quick return if possible.
           ! the quick return case: ((alpha==0).and.(beta/=zero)) is not
           ! done (it is in stdlib_zherk for example) and left in the general case.
           if ((n == 0) .or. (((alpha == zero) .or. (k == 0)) .and. (beta == one))) &
                     return
           if ((alpha == zero) .and. (beta == zero)) then
              do j = 1, ((n*(n + 1))/2)
                 c(j) = czero
              end do
              return
           end if
           calpha = cmplx(alpha, zero, KIND=dp)
           cbeta = cmplx(beta, zero, KIND=dp)
           ! c is n-by-n.
           ! if n is odd, set nisodd = .true., and n1 and n2.
           ! if n is even, nisodd = .false., and nk.
           if (mod(n, 2) == 0) then
              nisodd = .false.
              nk = n/2
           else
              nisodd = .true.
              if (lower) then
                 n2 = n/2
                 n1 = n - n2
              else
                 n1 = n/2
                 n2 = n - n1
              end if
           end if
           if (nisodd) then
              ! n is odd
              if (normaltransr) then
                 ! n is odd and transr = 'n'
                 if (lower) then
                    ! n is odd, transr = 'n', and uplo = 'l'
                    if (notrans) then
                       ! n is odd, transr = 'n', uplo = 'l', and trans = 'n'
                       call stdlib_zherk('l', 'n', n1, k, alpha, a(1, 1), lda, beta, c(1), n)
                                 
                       call stdlib_zherk('u', 'n', n2, k, alpha, a(n1 + 1, 1), lda, beta, c(n + 1) &
                                 , n)
                       call stdlib_zgemm('n', 'c', n2, n1, k, calpha, a(n1 + 1, 1), lda, a(1, 1) &
                                 , lda, cbeta, c(n1 + 1), n)
                    else
                       ! n is odd, transr = 'n', uplo = 'l', and trans = 'c'
                       call stdlib_zherk('l', 'c', n1, k, alpha, a(1, 1), lda, beta, c(1), n)
                                 
                       call stdlib_zherk('u', 'c', n2, k, alpha, a(1, n1 + 1), lda, beta, c(n + 1) &
                                 , n)
                       call stdlib_zgemm('c', 'n', n2, n1, k, calpha, a(1, n1 + 1), lda, a(1, 1) &
                                 , lda, cbeta, c(n1 + 1), n)
                    end if
                 else
                    ! n is odd, transr = 'n', and uplo = 'u'
                    if (notrans) then
                       ! n is odd, transr = 'n', uplo = 'u', and trans = 'n'
                       call stdlib_zherk('l', 'n', n1, k, alpha, a(1, 1), lda, beta, c(n2 + 1), &
                                 n)
                       call stdlib_zherk('u', 'n', n2, k, alpha, a(n2, 1), lda, beta, c(n1 + 1), &
                                  n)
                       call stdlib_zgemm('n', 'c', n1, n2, k, calpha, a(1, 1), lda, a(n2, 1), &
                                 lda, cbeta, c(1), n)
                    else
                       ! n is odd, transr = 'n', uplo = 'u', and trans = 'c'
                       call stdlib_zherk('l', 'c', n1, k, alpha, a(1, 1), lda, beta, c(n2 + 1), &
                                 n)
                       call stdlib_zherk('u', 'c', n2, k, alpha, a(1, n2), lda, beta, c(n1 + 1), &
                                  n)
                       call stdlib_zgemm('c', 'n', n1, n2, k, calpha, a(1, 1), lda, a(1, n2), &
                                 lda, cbeta, c(1), n)
                    end if
                 end if
              else
                 ! n is odd, and transr = 'c'
                 if (lower) then
                    ! n is odd, transr = 'c', and uplo = 'l'
                    if (notrans) then
                       ! n is odd, transr = 'c', uplo = 'l', and trans = 'n'
                       call stdlib_zherk('u', 'n', n1, k, alpha, a(1, 1), lda, beta, c(1), n1 &
                                 )
                       call stdlib_zherk('l', 'n', n2, k, alpha, a(n1 + 1, 1), lda, beta, c(2), &
                                 n1)
                       call stdlib_zgemm('n', 'c', n1, n2, k, calpha, a(1, 1), lda, a(n1 + 1, 1) &
                                 , lda, cbeta, c(n1*n1 + 1), n1)
                    else
                       ! n is odd, transr = 'c', uplo = 'l', and trans = 'c'
                       call stdlib_zherk('u', 'c', n1, k, alpha, a(1, 1), lda, beta, c(1), n1 &
                                 )
                       call stdlib_zherk('l', 'c', n2, k, alpha, a(1, n1 + 1), lda, beta, c(2), &
                                 n1)
                       call stdlib_zgemm('c', 'n', n1, n2, k, calpha, a(1, 1), lda, a(1, n1 + 1) &
                                 , lda, cbeta, c(n1*n1 + 1), n1)
                    end if
                 else
                    ! n is odd, transr = 'c', and uplo = 'u'
                    if (notrans) then
                       ! n is odd, transr = 'c', uplo = 'u', and trans = 'n'
                       call stdlib_zherk('u', 'n', n1, k, alpha, a(1, 1), lda, beta, c(n2*n2 + 1 &
                                 ), n2)
                       call stdlib_zherk('l', 'n', n2, k, alpha, a(n1 + 1, 1), lda, beta, c( &
                                 n1*n2 + 1), n2)
                       call stdlib_zgemm('n', 'c', n2, n1, k, calpha, a(n1 + 1, 1), lda, a(1, 1) &
                                 , lda, cbeta, c(1), n2)
                    else
                       ! n is odd, transr = 'c', uplo = 'u', and trans = 'c'
                       call stdlib_zherk('u', 'c', n1, k, alpha, a(1, 1), lda, beta, c(n2*n2 + 1 &
                                 ), n2)
                       call stdlib_zherk('l', 'c', n2, k, alpha, a(1, n1 + 1), lda, beta, c( &
                                 n1*n2 + 1), n2)
                       call stdlib_zgemm('c', 'n', n2, n1, k, calpha, a(1, n1 + 1), lda, a(1, 1) &
                                 , lda, cbeta, c(1), n2)
                    end if
                 end if
              end if
           else
              ! n is even
              if (normaltransr) then
                 ! n is even and transr = 'n'
                 if (lower) then
                    ! n is even, transr = 'n', and uplo = 'l'
                    if (notrans) then
                       ! n is even, transr = 'n', uplo = 'l', and trans = 'n'
                       call stdlib_zherk('l', 'n', nk, k, alpha, a(1, 1), lda, beta, c(2), n + &
                                 1)
                       call stdlib_zherk('u', 'n', nk, k, alpha, a(nk + 1, 1), lda, beta, c(1), &
                                 n + 1)
                       call stdlib_zgemm('n', 'c', nk, nk, k, calpha, a(nk + 1, 1), lda, a(1, 1) &
                                 , lda, cbeta, c(nk + 2), n + 1)
                    else
                       ! n is even, transr = 'n', uplo = 'l', and trans = 'c'
                       call stdlib_zherk('l', 'c', nk, k, alpha, a(1, 1), lda, beta, c(2), n + &
                                 1)
                       call stdlib_zherk('u', 'c', nk, k, alpha, a(1, nk + 1), lda, beta, c(1), &
                                 n + 1)
                       call stdlib_zgemm('c', 'n', nk, nk, k, calpha, a(1, nk + 1), lda, a(1, 1) &
                                 , lda, cbeta, c(nk + 2), n + 1)
                    end if
                 else
                    ! n is even, transr = 'n', and uplo = 'u'
                    if (notrans) then
                       ! n is even, transr = 'n', uplo = 'u', and trans = 'n'
                       call stdlib_zherk('l', 'n', nk, k, alpha, a(1, 1), lda, beta, c(nk + 2), &
                                 n + 1)
                       call stdlib_zherk('u', 'n', nk, k, alpha, a(nk + 1, 1), lda, beta, c(nk + 1 &
                                 ), n + 1)
                       call stdlib_zgemm('n', 'c', nk, nk, k, calpha, a(1, 1), lda, a(nk + 1, 1) &
                                 , lda, cbeta, c(1), n + 1)
                    else
                       ! n is even, transr = 'n', uplo = 'u', and trans = 'c'
                       call stdlib_zherk('l', 'c', nk, k, alpha, a(1, 1), lda, beta, c(nk + 2), &
                                 n + 1)
                       call stdlib_zherk('u', 'c', nk, k, alpha, a(1, nk + 1), lda, beta, c(nk + 1 &
                                 ), n + 1)
                       call stdlib_zgemm('c', 'n', nk, nk, k, calpha, a(1, 1), lda, a(1, nk + 1) &
                                 , lda, cbeta, c(1), n + 1)
                    end if
                 end if
              else
                 ! n is even, and transr = 'c'
                 if (lower) then
                    ! n is even, transr = 'c', and uplo = 'l'
                    if (notrans) then
                       ! n is even, transr = 'c', uplo = 'l', and trans = 'n'
                       call stdlib_zherk('u', 'n', nk, k, alpha, a(1, 1), lda, beta, c(nk + 1), &
                                 nk)
                       call stdlib_zherk('l', 'n', nk, k, alpha, a(nk + 1, 1), lda, beta, c(1), &
                                 nk)
                       call stdlib_zgemm('n', 'c', nk, nk, k, calpha, a(1, 1), lda, a(nk + 1, 1) &
                                 , lda, cbeta, c(((nk + 1)*nk) + 1), nk)
                    else
                       ! n is even, transr = 'c', uplo = 'l', and trans = 'c'
                       call stdlib_zherk('u', 'c', nk, k, alpha, a(1, 1), lda, beta, c(nk + 1), &
                                 nk)
                       call stdlib_zherk('l', 'c', nk, k, alpha, a(1, nk + 1), lda, beta, c(1), &
                                 nk)
                       call stdlib_zgemm('c', 'n', nk, nk, k, calpha, a(1, 1), lda, a(1, nk + 1) &
                                 , lda, cbeta, c(((nk + 1)*nk) + 1), nk)
                    end if
                 else
                    ! n is even, transr = 'c', and uplo = 'u'
                    if (notrans) then
                       ! n is even, transr = 'c', uplo = 'u', and trans = 'n'
                       call stdlib_zherk('u', 'n', nk, k, alpha, a(1, 1), lda, beta, c(nk*(nk + &
                                 1) + 1), nk)
                       call stdlib_zherk('l', 'n', nk, k, alpha, a(nk + 1, 1), lda, beta, c( &
                                 nk*nk + 1), nk)
                       call stdlib_zgemm('n', 'c', nk, nk, k, calpha, a(nk + 1, 1), lda, a(1, 1) &
                                 , lda, cbeta, c(1), nk)
                    else
                       ! n is even, transr = 'c', uplo = 'u', and trans = 'c'
                       call stdlib_zherk('u', 'c', nk, k, alpha, a(1, 1), lda, beta, c(nk*(nk + &
                                 1) + 1), nk)
                       call stdlib_zherk('l', 'c', nk, k, alpha, a(1, nk + 1), lda, beta, c( &
                                 nk*nk + 1), nk)
                       call stdlib_zgemm('c', 'n', nk, nk, k, calpha, a(1, nk + 1), lda, a(1, 1) &
                                 , lda, cbeta, c(1), nk)
                    end if
                 end if
              end if
           end if
           return
           ! end of stdlib_zhfrk
     end subroutine stdlib_zhfrk

     ! ZHPGST reduces a complex Hermitian-definite generalized
     ! eigenproblem to standard form, using packed storage.
     ! If ITYPE = 1, the problem is A*x = lambda*B*x,
     ! and A is overwritten by inv(U**H)*A*inv(U) or inv(L)*A*inv(L**H)
     ! If ITYPE = 2 or 3, the problem is A*B*x = lambda*x or
     ! B*A*x = lambda*x, and A is overwritten by U*A*U**H or L**H*A*L.
     ! B must have been previously factorized as U**H*U or L*L**H by ZPPTRF.

     subroutine stdlib_zhpgst(itype, uplo, n, ap, bp, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, itype, n
           ! .. array arguments ..
           complex(dp) :: ap(*), bp(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: j, j1, j1j1, jj, k, k1, k1k1, kk
           real(dp) :: ajj, akk, bjj, bkk
           complex(dp) :: ct
     
           ! .. intrinsic functions ..
           intrinsic :: dble
     
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (itype < 1 .or. itype > 3) then
              info = -1
           else if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -2
           else if (n < 0) then
              info = -3
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zhpgst', -info)
              return
           end if
           if (itype == 1) then
              if (upper) then
                 ! compute inv(u**h)*a*inv(u)
                 ! j1 and jj are the indices of a(1,j) and a(j,j)
                 jj = 0
                 do j = 1, n
                    j1 = jj + 1
                    jj = jj + j
                    ! compute the j-th column of the upper triangle of a
                    ap(jj) = real(ap(jj), KIND=dp)
                    bjj = real(bp(jj), KIND=dp)
                    call stdlib_ztpsv(uplo, 'conjugate transpose', 'non-unit', j, bp, ap(j1), 1 &
                              )
                    call stdlib_zhpmv(uplo, j - 1, -cone, ap, bp(j1), 1, cone, ap(j1), 1)
                              
                    call stdlib_zdscal(j - 1, one/bjj, ap(j1), 1)
                    ap(jj) = (ap(jj) - stdlib_zdotc(j - 1, ap(j1), 1, bp(j1), 1))/ &
                              bjj
                 end do
              else
                 ! compute inv(l)*a*inv(l**h)
                 ! kk and k1k1 are the indices of a(k,k) and a(k+1,k+1)
                 kk = 1
                 do k = 1, n
                    k1k1 = kk + n - k + 1
                    ! update the lower triangle of a(k:n,k:n)
                    akk = real(ap(kk), KIND=dp)
                    bkk = real(bp(kk), KIND=dp)
                    akk = akk/bkk**2
                    ap(kk) = akk
                    if (k < n) then
                       call stdlib_zdscal(n - k, one/bkk, ap(kk + 1), 1)
                       ct = -half*akk
                       call stdlib_zaxpy(n - k, ct, bp(kk + 1), 1, ap(kk + 1), 1)
                       call stdlib_zhpr2(uplo, n - k, -cone, ap(kk + 1), 1, bp(kk + 1), 1, ap(k1k1 &
                                 ))
                       call stdlib_zaxpy(n - k, ct, bp(kk + 1), 1, ap(kk + 1), 1)
                       call stdlib_ztpsv(uplo, 'no transpose', 'non-unit', n - k, bp(k1k1), ap( &
                                 kk + 1), 1)
                    end if
                    kk = k1k1
                 end do
              end if
           else
              if (upper) then
                 ! compute u*a*u**h
                 ! k1 and kk are the indices of a(1,k) and a(k,k)
                 kk = 0
                 do k = 1, n
                    k1 = kk + 1
                    kk = kk + k
                    ! update the upper triangle of a(1:k,1:k)
                    akk = real(ap(kk), KIND=dp)
                    bkk = real(bp(kk), KIND=dp)
                    call stdlib_ztpmv(uplo, 'no transpose', 'non-unit', k - 1, bp, ap(k1), 1)
                              
                    ct = half*akk
                    call stdlib_zaxpy(k - 1, ct, bp(k1), 1, ap(k1), 1)
                    call stdlib_zhpr2(uplo, k - 1, cone, ap(k1), 1, bp(k1), 1, ap)
                    call stdlib_zaxpy(k - 1, ct, bp(k1), 1, ap(k1), 1)
                    call stdlib_zdscal(k - 1, bkk, ap(k1), 1)
                    ap(kk) = akk*bkk**2
                 end do
              else
                 ! compute l**h *a*l
                 ! jj and j1j1 are the indices of a(j,j) and a(j+1,j+1)
                 jj = 1
                 do j = 1, n
                    j1j1 = jj + n - j + 1
                    ! compute the j-th column of the lower triangle of a
                    ajj = real(ap(jj), KIND=dp)
                    bjj = real(bp(jj), KIND=dp)
                    ap(jj) = ajj*bjj + stdlib_zdotc(n - j, ap(jj + 1), 1, bp(jj + 1), 1)
                    call stdlib_zdscal(n - j, bjj, ap(jj + 1), 1)
                    call stdlib_zhpmv(uplo, n - j, cone, ap(j1j1), bp(jj + 1), 1, cone, ap(jj + 1) &
                              , 1)
                    call stdlib_ztpmv(uplo, 'conjugate transpose', 'non-unit', n - j + 1, bp(jj), &
                              ap(jj), 1)
                    jj = j1j1
                 end do
              end if
           end if
           return
           ! end of stdlib_zhpgst
     end subroutine stdlib_zhpgst

     ! ZHPTRF computes the factorization of a complex Hermitian packed
     ! matrix A using the Bunch-Kaufman diagonal pivoting method:
     ! A = U*D*U**H  or  A = L*D*L**H
     ! where U (or L) is a product of permutation and unit upper (lower)
     ! triangular matrices, and D is Hermitian and block diagonal with
     ! 1-by-1 and 2-by-2 diagonal blocks.

     subroutine stdlib_zhptrf(uplo, n, ap, ipiv, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: ap(*)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: sevten = 17.0_dp
           
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: i, imax, j, jmax, k, kc, kk, knc, kp, kpc, kstep, kx, npp
           real(dp) :: absakk, alpha, colmax, d, d11, d22, r1, rowmax, tt
           complex(dp) :: d12, d21, t, wk, wkm1, wkp1, zdum
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, dcmplx, conjg, aimag, max, sqrt
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(zdum) = abs(real(zdum, KIND=dp)) + abs(aimag(zdum))
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zhptrf', -info)
              return
           end if
           ! initialize alpha for use in choosing pivot block size.
           alpha = (one + sqrt(sevten))/eight
           if (upper) then
              ! factorize a as u*d*u**h using the upper triangle of a
              ! k is the main loop index, decreasing from n to 1 in steps of
              ! 1 or 2
              k = n
              kc = (n - 1)*n/2 + 1
10      continue
              knc = kc
              ! if k < 1, exit from loop
              if (k < 1) go to 110
              kstep = 1
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = abs(real(ap(kc + k - 1), KIND=dp))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value
              if (k > 1) then
                 imax = stdlib_izamax(k - 1, ap(kc), 1)
                 colmax = cabs1(ap(kc + imax - 1))
              else
                 colmax = zero
              end if
              if (max(absakk, colmax) == zero) then
                 ! column k is zero: set info and continue
                 if (info == 0) info = k
                 kp = k
                 ap(kc + k - 1) = real(ap(kc + k - 1), KIND=dp)
              else
                 if (absakk >= alpha*colmax) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    ! jmax is the column-index of the largest off-diagonal
                    ! element in row imax, and rowmax is its absolute value
                    rowmax = zero
                    jmax = imax
                    kx = imax*(imax + 1)/2 + imax
                    do j = imax + 1, k
                       if (cabs1(ap(kx)) > rowmax) then
                          rowmax = cabs1(ap(kx))
                          jmax = j
                       end if
                       kx = kx + j
                    end do
                    kpc = (imax - 1)*imax/2 + 1
                    if (imax > 1) then
                       jmax = stdlib_izamax(imax - 1, ap(kpc), 1)
                       rowmax = max(rowmax, cabs1(ap(kpc + jmax - 1)))
                    end if
                    if (absakk >= alpha*colmax*(colmax/rowmax)) then
                       ! no interchange, use 1-by-1 pivot block
                       kp = k
                    else if (abs(real(ap(kpc + imax - 1), KIND=dp)) >= alpha*rowmax) then
                       ! interchange rows and columns k and imax, use 1-by-1
                       ! pivot block
                       kp = imax
                    else
                       ! interchange rows and columns k-1 and imax, use 2-by-2
                       ! pivot block
                       kp = imax
                       kstep = 2
                    end if
                 end if
                 kk = k - kstep + 1
                 if (kstep == 2) knc = knc - k + 1
                 if (kp /= kk) then
                    ! interchange rows and columns kk and kp in the leading
                    ! submatrix a(1:k,1:k)
                    call stdlib_zswap(kp - 1, ap(knc), 1, ap(kpc), 1)
                    kx = kpc + kp - 1
                    do j = kp + 1, kk - 1
                       kx = kx + j - 1
                       t = conjg(ap(knc + j - 1))
                       ap(knc + j - 1) = conjg(ap(kx))
                       ap(kx) = t
                    end do
                    ap(kx + kk - 1) = conjg(ap(kx + kk - 1))
                    r1 = real(ap(knc + kk - 1), KIND=dp)
                    ap(knc + kk - 1) = real(ap(kpc + kp - 1), KIND=dp)
                    ap(kpc + kp - 1) = r1
                    if (kstep == 2) then
                       ap(kc + k - 1) = real(ap(kc + k - 1), KIND=dp)
                       t = ap(kc + k - 2)
                       ap(kc + k - 2) = ap(kc + kp - 1)
                       ap(kc + kp - 1) = t
                    end if
                 else
                    ap(kc + k - 1) = real(ap(kc + k - 1), KIND=dp)
                    if (kstep == 2) ap(kc - 1) = real(ap(kc - 1), KIND=dp)
                 end if
                 ! update the leading submatrix
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k now holds
                    ! w(k) = u(k)*d(k)
                    ! where u(k) is the k-th column of u
                    ! perform a rank-1 update of a(1:k-1,1:k-1) as
                    ! a := a - u(k)*d(k)*u(k)**h = a - w(k)*1/d(k)*w(k)**h
                    r1 = one/real(ap(kc + k - 1), KIND=dp)
                    call stdlib_zhpr(uplo, k - 1, -r1, ap(kc), 1, ap)
                    ! store u(k) in column k
                    call stdlib_zdscal(k - 1, r1, ap(kc), 1)
                 else
                    ! 2-by-2 pivot block d(k): columns k and k-1 now hold
                    ! ( w(k-1) w(k) ) = ( u(k-1) u(k) )*d(k)
                    ! where u(k) and u(k-1) are the k-th and (k-1)-th columns
                    ! of u
                    ! perform a rank-2 update of a(1:k-2,1:k-2) as
                    ! a := a - ( u(k-1) u(k) )*d(k)*( u(k-1) u(k) )**h
                       ! = a - ( w(k-1) w(k) )*inv(d(k))*( w(k-1) w(k) )**h
                    if (k > 2) then
                       d = stdlib_dlapy2(dble(ap(k - 1 + (k - 1)*k/2)), aimag(ap(k - 1 + (k - 1) &
                                 *k/2)))
                       d22 = dble(ap(k - 1 + (k - 2)*(k - 1)/2))/d
                       d11 = dble(ap(k + (k - 1)*k/2))/d
                       tt = one/(d11*d22 - one)
                       d12 = ap(k - 1 + (k - 1)*k/2)/d
                       d = tt/d
                       do j = k - 2, 1, -1
                          wkm1 = d*(d11*ap(j + (k - 2)*(k - 1)/2) - conjg(d12)*ap(j + (k - 1)*k &
                                    /2))
                          wk = d*(d22*ap(j + (k - 1)*k/2) - d12*ap(j + (k - 2)*(k - 1)/2))
                                    
                          do i = j, 1, -1
                             ap(i + (j - 1)*j/2) = ap(i + (j - 1)*j/2) - ap(i + (k - 1)*k/2) &
                                       *conjg(wk) - ap(i + (k - 2)*(k - 1)/2)*conjg(wkm1)
                          end do
                          ap(j + (k - 1)*k/2) = wk
                          ap(j + (k - 2)*(k - 1)/2) = wkm1
                          ap(j + (j - 1)*j/2) = dcmplx(dble(ap(j + (j - 1)*j/2)), 0.0_dp)
                                    
                       end do
                    end if
                 end if
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -kp
                 ipiv(k - 1) = -kp
              end if
              ! decrease k and return to the start of the main loop
              k = k - kstep
              kc = knc - k
              go to 10
           else
              ! factorize a as l*d*l**h using the lower triangle of a
              ! k is the main loop index, increasing from 1 to n in steps of
              ! 1 or 2
              k = 1
              kc = 1
              npp = n*(n + 1)/2
60      continue
              knc = kc
              ! if k > n, exit from loop
              if (k > n) go to 110
              kstep = 1
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = abs(real(ap(kc), KIND=dp))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value
              if (k < n) then
                 imax = k + stdlib_izamax(n - k, ap(kc + 1), 1)
                 colmax = cabs1(ap(kc + imax - k))
              else
                 colmax = zero
              end if
              if (max(absakk, colmax) == zero) then
                 ! column k is zero: set info and continue
                 if (info == 0) info = k
                 kp = k
                 ap(kc) = real(ap(kc), KIND=dp)
              else
                 if (absakk >= alpha*colmax) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    ! jmax is the column-index of the largest off-diagonal
                    ! element in row imax, and rowmax is its absolute value
                    rowmax = zero
                    kx = kc + imax - k
                    do j = k, imax - 1
                       if (cabs1(ap(kx)) > rowmax) then
                          rowmax = cabs1(ap(kx))
                          jmax = j
                       end if
                       kx = kx + n - j
                    end do
                    kpc = npp - (n - imax + 1)*(n - imax + 2)/2 + 1
                    if (imax < n) then
                       jmax = imax + stdlib_izamax(n - imax, ap(kpc + 1), 1)
                       rowmax = max(rowmax, cabs1(ap(kpc + jmax - imax)))
                    end if
                    if (absakk >= alpha*colmax*(colmax/rowmax)) then
                       ! no interchange, use 1-by-1 pivot block
                       kp = k
                    else if (abs(real(ap(kpc), KIND=dp)) >= alpha*rowmax) then
                       ! interchange rows and columns k and imax, use 1-by-1
                       ! pivot block
                       kp = imax
                    else
                       ! interchange rows and columns k+1 and imax, use 2-by-2
                       ! pivot block
                       kp = imax
                       kstep = 2
                    end if
                 end if
                 kk = k + kstep - 1
                 if (kstep == 2) knc = knc + n - k + 1
                 if (kp /= kk) then
                    ! interchange rows and columns kk and kp in the trailing
                    ! submatrix a(k:n,k:n)
                    if (kp < n) call stdlib_zswap(n - kp, ap(knc + kp - kk + 1), 1, ap(kpc + 1), 1)
                              
                    kx = knc + kp - kk
                    do j = kk + 1, kp - 1
                       kx = kx + n - j + 1
                       t = conjg(ap(knc + j - kk))
                       ap(knc + j - kk) = conjg(ap(kx))
                       ap(kx) = t
                    end do
                    ap(knc + kp - kk) = conjg(ap(knc + kp - kk))
                    r1 = real(ap(knc), KIND=dp)
                    ap(knc) = real(ap(kpc), KIND=dp)
                    ap(kpc) = r1
                    if (kstep == 2) then
                       ap(kc) = real(ap(kc), KIND=dp)
                       t = ap(kc + 1)
                       ap(kc + 1) = ap(kc + kp - k)
                       ap(kc + kp - k) = t
                    end if
                 else
                    ap(kc) = real(ap(kc), KIND=dp)
                    if (kstep == 2) ap(knc) = real(ap(knc), KIND=dp)
                 end if
                 ! update the trailing submatrix
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k now holds
                    ! w(k) = l(k)*d(k)
                    ! where l(k) is the k-th column of l
                    if (k < n) then
                       ! perform a rank-1 update of a(k+1:n,k+1:n) as
                       ! a := a - l(k)*d(k)*l(k)**h = a - w(k)*(1/d(k))*w(k)**h
                       r1 = one/real(ap(kc), KIND=dp)
                       call stdlib_zhpr(uplo, n - k, -r1, ap(kc + 1), 1, ap(kc + n - k + 1))
                       ! store l(k) in column k
                       call stdlib_zdscal(n - k, r1, ap(kc + 1), 1)
                    end if
                 else
                    ! 2-by-2 pivot block d(k): columns k and k+1 now hold
                    ! ( w(k) w(k+1) ) = ( l(k) l(k+1) )*d(k)
                    ! where l(k) and l(k+1) are the k-th and (k+1)-th columns
                    ! of l
                    if (k < n - 1) then
                       ! perform a rank-2 update of a(k+2:n,k+2:n) as
                       ! a := a - ( l(k) l(k+1) )*d(k)*( l(k) l(k+1) )**h
                          ! = a - ( w(k) w(k+1) )*inv(d(k))*( w(k) w(k+1) )**h
                       ! where l(k) and l(k+1) are the k-th and (k+1)-th
                       ! columns of l
                       d = stdlib_dlapy2(dble(ap(k + 1 + (k - 1)*(2*n - k)/2)), aimag(ap(k + 1 + ( &
                                  k - 1)*(2*n - k)/2)))
                       d11 = dble(ap(k + 1 + k*(2*n - k - 1)/2))/d
                       d22 = dble(ap(k + (k - 1)*(2*n - k)/2))/d
                       tt = one/(d11*d22 - one)
                       d21 = ap(k + 1 + (k - 1)*(2*n - k)/2)/d
                       d = tt/d
                       do j = k + 2, n
                          wk = d*(d11*ap(j + (k - 1)*(2*n - k)/2) - d21*ap(j + k*(2*n - k - 1)/2) &
                                     )
                          wkp1 = d*(d22*ap(j + k*(2*n - k - 1)/2) - conjg(d21)*ap(j + (k - 1)*( &
                                    2*n - k)/2))
                          do i = j, n
                             ap(i + (j - 1)*(2*n - j)/2) = ap(i + (j - 1)*(2*n - j)/2) - ap( &
                             i + (k - 1)*(2*n - k)/2)*conjg(wk) - ap(i + k*(2*n - k - 1)/2) &
                                       *conjg(wkp1)
                          end do
                          ap(j + (k - 1)*(2*n - k)/2) = wk
                          ap(j + k*(2*n - k - 1)/2) = wkp1
                          ap(j + (j - 1)*(2*n - j)/2) = dcmplx(dble(ap(j + (j - 1)*(2*n - j)/ &
                                    2)), 0.0_dp)
                       end do
                    end if
                 end if
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -kp
                 ipiv(k + 1) = -kp
              end if
              ! increase k and return to the start of the main loop
              k = k + kstep
              kc = knc + n - k + 2
              go to 60
           end if
110    continue
           return
           ! end of stdlib_zhptrf
     end subroutine stdlib_zhptrf

     ! ZHPTRI computes the inverse of a complex Hermitian indefinite matrix
     ! A in packed storage using the factorization A = U*D*U**H or
     ! A = L*D*L**H computed by ZHPTRF.

     subroutine stdlib_zhptri(uplo, n, ap, ipiv, work, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: ap(*), work(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: j, k, kc, kcnext, kp, kpc, kstep, kx, npp
           real(dp) :: ak, akp1, d, t
           complex(dp) :: akkp1, temp
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, conjg
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zhptri', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           ! check that the diagonal matrix d is nonsingular.
           if (upper) then
              ! upper triangular storage: examine d from bottom to top
              kp = n*(n + 1)/2
              do info = n, 1, -1
                 if (ipiv(info) > 0 .and. ap(kp) == czero) return
                 kp = kp - info
              end do
           else
              ! lower triangular storage: examine d from top to bottom.
              kp = 1
              do info = 1, n
                 if (ipiv(info) > 0 .and. ap(kp) == czero) return
                 kp = kp + n - info + 1
              end do
           end if
           info = 0
           if (upper) then
              ! compute inv(a) from the factorization a = u*d*u**h.
              ! k is the main loop index, increasing from 1 to n in steps of
              ! 1 or 2, depending on the size of the diagonal blocks.
              k = 1
              kc = 1
30      continue
              ! if k > n, exit from loop.
              if (k > n) go to 50
              kcnext = kc + k
              if (ipiv(k) > 0) then
                 ! 1 x 1 diagonal block
                 ! invert the diagonal block.
                 ap(kc + k - 1) = one/real(ap(kc + k - 1), KIND=dp)
                 ! compute column k of the inverse.
                 if (k > 1) then
                    call stdlib_zcopy(k - 1, ap(kc), 1, work, 1)
                    call stdlib_zhpmv(uplo, k - 1, -cone, ap, work, 1, czero, ap(kc), 1)
                    ap(kc + k - 1) = ap(kc + k - 1) - dble(stdlib_zdotc(k - 1, work, 1, ap(kc), 1))
                              
                 end if
                 kstep = 1
              else
                 ! 2 x 2 diagonal block
                 ! invert the diagonal block.
                 t = abs(ap(kcnext + k - 1))
                 ak = real(ap(kc + k - 1), KIND=dp)/t
                 akp1 = real(ap(kcnext + k), KIND=dp)/t
                 akkp1 = ap(kcnext + k - 1)/t
                 d = t*(ak*akp1 - one)
                 ap(kc + k - 1) = akp1/d
                 ap(kcnext + k) = ak/d
                 ap(kcnext + k - 1) = -akkp1/d
                 ! compute columns k and k+1 of the inverse.
                 if (k > 1) then
                    call stdlib_zcopy(k - 1, ap(kc), 1, work, 1)
                    call stdlib_zhpmv(uplo, k - 1, -cone, ap, work, 1, czero, ap(kc), 1)
                    ap(kc + k - 1) = ap(kc + k - 1) - dble(stdlib_zdotc(k - 1, work, 1, ap(kc), 1))
                              
                    ap(kcnext + k - 1) = ap(kcnext + k - 1) - stdlib_zdotc(k - 1, ap(kc), 1, ap( &
                              kcnext), 1)
                    call stdlib_zcopy(k - 1, ap(kcnext), 1, work, 1)
                    call stdlib_zhpmv(uplo, k - 1, -cone, ap, work, 1, czero, ap(kcnext), 1)
                              
                    ap(kcnext + k) = ap(kcnext + k) - dble(stdlib_zdotc(k - 1, work, 1, ap(kcnext &
                              ), 1))
                 end if
                 kstep = 2
                 kcnext = kcnext + k + 1
              end if
              kp = abs(ipiv(k))
              if (kp /= k) then
                 ! interchange rows and columns k and kp in the leading
                 ! submatrix a(1:k+1,1:k+1)
                 kpc = (kp - 1)*kp/2 + 1
                 call stdlib_zswap(kp - 1, ap(kc), 1, ap(kpc), 1)
                 kx = kpc + kp - 1
                 do j = kp + 1, k - 1
                    kx = kx + j - 1
                    temp = conjg(ap(kc + j - 1))
                    ap(kc + j - 1) = conjg(ap(kx))
                    ap(kx) = temp
                 end do
                 ap(kc + kp - 1) = conjg(ap(kc + kp - 1))
                 temp = ap(kc + k - 1)
                 ap(kc + k - 1) = ap(kpc + kp - 1)
                 ap(kpc + kp - 1) = temp
                 if (kstep == 2) then
                    temp = ap(kc + k + k - 1)
                    ap(kc + k + k - 1) = ap(kc + k + kp - 1)
                    ap(kc + k + kp - 1) = temp
                 end if
              end if
              k = k + kstep
              kc = kcnext
              go to 30
50      continue
           else
              ! compute inv(a) from the factorization a = l*d*l**h.
              ! k is the main loop index, increasing from 1 to n in steps of
              ! 1 or 2, depending on the size of the diagonal blocks.
              npp = n*(n + 1)/2
              k = n
              kc = npp
60      continue
              ! if k < 1, exit from loop.
              if (k < 1) go to 80
              kcnext = kc - (n - k + 2)
              if (ipiv(k) > 0) then
                 ! 1 x 1 diagonal block
                 ! invert the diagonal block.
                 ap(kc) = one/real(ap(kc), KIND=dp)
                 ! compute column k of the inverse.
                 if (k < n) then
                    call stdlib_zcopy(n - k, ap(kc + 1), 1, work, 1)
                    call stdlib_zhpmv(uplo, n - k, -cone, ap(kc + n - k + 1), work, 1, czero, ap(kc + 1) &
                              , 1)
                    ap(kc) = ap(kc) - dble(stdlib_zdotc(n - k, work, 1, ap(kc + 1), 1))
                              
                 end if
                 kstep = 1
              else
                 ! 2 x 2 diagonal block
                 ! invert the diagonal block.
                 t = abs(ap(kcnext + 1))
                 ak = real(ap(kcnext), KIND=dp)/t
                 akp1 = real(ap(kc), KIND=dp)/t
                 akkp1 = ap(kcnext + 1)/t
                 d = t*(ak*akp1 - one)
                 ap(kcnext) = akp1/d
                 ap(kc) = ak/d
                 ap(kcnext + 1) = -akkp1/d
                 ! compute columns k-1 and k of the inverse.
                 if (k < n) then
                    call stdlib_zcopy(n - k, ap(kc + 1), 1, work, 1)
                    call stdlib_zhpmv(uplo, n - k, -cone, ap(kc + (n - k + 1)), work, 1, czero, ap( &
                              kc + 1), 1)
                    ap(kc) = ap(kc) - dble(stdlib_zdotc(n - k, work, 1, ap(kc + 1), 1))
                              
                    ap(kcnext + 1) = ap(kcnext + 1) - stdlib_zdotc(n - k, ap(kc + 1), 1, ap(kcnext + &
                              2), 1)
                    call stdlib_zcopy(n - k, ap(kcnext + 2), 1, work, 1)
                    call stdlib_zhpmv(uplo, n - k, -cone, ap(kc + (n - k + 1)), work, 1, czero, ap( &
                              kcnext + 2), 1)
                    ap(kcnext) = ap(kcnext) - dble(stdlib_zdotc(n - k, work, 1, ap(kcnext + 2), &
                              1))
                 end if
                 kstep = 2
                 kcnext = kcnext - (n - k + 3)
              end if
              kp = abs(ipiv(k))
              if (kp /= k) then
                 ! interchange rows and columns k and kp in the trailing
                 ! submatrix a(k-1:n,k-1:n)
                 kpc = npp - (n - kp + 1)*(n - kp + 2)/2 + 1
                 if (kp < n) call stdlib_zswap(n - kp, ap(kc + kp - k + 1), 1, ap(kpc + 1), 1)
                 kx = kc + kp - k
                 do j = k + 1, kp - 1
                    kx = kx + n - j + 1
                    temp = conjg(ap(kc + j - k))
                    ap(kc + j - k) = conjg(ap(kx))
                    ap(kx) = temp
                 end do
                 ap(kc + kp - k) = conjg(ap(kc + kp - k))
                 temp = ap(kc)
                 ap(kc) = ap(kpc)
                 ap(kpc) = temp
                 if (kstep == 2) then
                    temp = ap(kc - n + k - 1)
                    ap(kc - n + k - 1) = ap(kc - n + kp - 1)
                    ap(kc - n + kp - 1) = temp
                 end if
              end if
              k = k - kstep
              kc = kcnext
              go to 60
80      continue
           end if
           return
           ! end of stdlib_zhptri
     end subroutine stdlib_zhptri

     ! ZLA_GBAMV  performs one of the matrix-vector operations
     ! y := alpha*abs(A)*abs(x) + beta*abs(y),
     ! or   y := alpha*abs(A)**T*abs(x) + beta*abs(y),
     ! where alpha and beta are scalars, x and y are vectors and A is an
     ! m by n matrix.
     ! This function is primarily used in calculating error bounds.
     ! To protect against underflow during evaluation, components in
     ! the resulting vector are perturbed away from zero by (N+1)
     ! times the underflow threshold.  To prevent unnecessarily large
     ! errors for block-structure embedded in general matrices,
     ! "symbolically" zero components are not perturbed.  A zero
     ! entry is considered "symbolic" if all multiplications involved
     ! in computing that entry have at least one zero multiplicand.

     subroutine stdlib_zla_gbamv(trans, m, n, kl, ku, alpha, ab, ldab, x, incx, beta, y, incy)
               
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           real(dp) :: alpha, beta
           integer(ilp) :: incx, incy, ldab, m, n, kl, ku, trans
           ! .. array arguments ..
           complex(dp) :: ab(ldab, *), x(*)
           real(dp) :: y(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: symb_zero
           real(dp) :: temp, safe1
           integer(ilp) :: i, info, iy, j, jx, kx, ky, lenx, leny, kd, ke
           complex(dp) :: cdum
     
           ! .. intrinsic functions ..
           intrinsic :: max, abs, real, aimag, sign
           ! .. statement functions
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(cdum) = abs(real(cdum, KIND=dp)) + abs(aimag(cdum))
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           if (.not. ((trans == stdlib_ilatrans('n')) .or. (trans == stdlib_ilatrans('t')) &
                     .or. (trans == stdlib_ilatrans('c')))) then
              info = 1
           else if (m < 0) then
              info = 2
           else if (n < 0) then
              info = 3
           else if (kl < 0 .or. kl > m - 1) then
              info = 4
           else if (ku < 0 .or. ku > n - 1) then
              info = 5
           else if (ldab < kl + ku + 1) then
              info = 6
           else if (incx == 0) then
              info = 8
           else if (incy == 0) then
              info = 11
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zla_gbamv ', info)
              return
           end if
           ! quick return if possible.
           if ((m == 0) .or. (n == 0) .or. ((alpha == czero) .and. (beta == cone))) return
           ! set  lenx  and  leny, the lengths of the vectors x and y, and set
           ! up the start points in  x  and  y.
           if (trans == stdlib_ilatrans('n')) then
              lenx = n
              leny = m
           else
              lenx = m
              leny = n
           end if
           if (incx > 0) then
              kx = 1
           else
              kx = 1 - (lenx - 1)*incx
           end if
           if (incy > 0) then
              ky = 1
           else
              ky = 1 - (leny - 1)*incy
           end if
           ! set safe1 essentially to be the underflow threshold times the
           ! number of additions in each row.
           safe1 = stdlib_dlamch('safe minimum')
           safe1 = (n + 1)*safe1
           ! form  y := alpha*abs(a)*abs(x) + beta*abs(y).
           ! the o(m*n) symb_zero tests could be replaced by o(n) queries to
           ! the inexact flag.  still doesn't help change the iteration order
           ! to per-column.
           kd = ku + 1
           ke = kl + 1
           iy = ky
           if (incx == 1) then
              if (trans == stdlib_ilatrans('n')) then
                 do i = 1, leny
                    if (beta == 0.0_dp) then
                       symb_zero = .true.
                       y(iy) = 0.0_dp
                    else if (y(iy) == 0.0_dp) then
                       symb_zero = .true.
                    else
                       symb_zero = .false.
                       y(iy) = beta*abs(y(iy))
                    end if
                    if (alpha /= 0.0_dp) then
                       do j = max(i - kl, 1), min(i + ku, lenx)
                          temp = cabs1(ab(kd + i - j, j))
                          symb_zero = symb_zero .and. (x(j) == czero .or. temp == czero)
                                    
                          y(iy) = y(iy) + alpha*cabs1(x(j))*temp
                       end do
                    end if
                    if (.not. symb_zero) y(iy) = y(iy) + sign(safe1, y(iy))
                    iy = iy + incy
                 end do
              else
                 do i = 1, leny
                    if (beta == 0.0_dp) then
                       symb_zero = .true.
                       y(iy) = 0.0_dp
                    else if (y(iy) == 0.0_dp) then
                       symb_zero = .true.
                    else
                       symb_zero = .false.
                       y(iy) = beta*abs(y(iy))
                    end if
                    if (alpha /= 0.0_dp) then
                       do j = max(i - kl, 1), min(i + ku, lenx)
                          temp = cabs1(ab(ke - i + j, i))
                          symb_zero = symb_zero .and. (x(j) == czero .or. temp == czero)
                                    
                          y(iy) = y(iy) + alpha*cabs1(x(j))*temp
                       end do
                    end if
                    if (.not. symb_zero) y(iy) = y(iy) + sign(safe1, y(iy))
                    iy = iy + incy
                 end do
              end if
           else
              if (trans == stdlib_ilatrans('n')) then
                 do i = 1, leny
                    if (beta == 0.0_dp) then
                       symb_zero = .true.
                       y(iy) = 0.0_dp
                    else if (y(iy) == 0.0_dp) then
                       symb_zero = .true.
                    else
                       symb_zero = .false.
                       y(iy) = beta*abs(y(iy))
                    end if
                    if (alpha /= 0.0_dp) then
                       jx = kx
                       do j = max(i - kl, 1), min(i + ku, lenx)
                          temp = cabs1(ab(kd + i - j, j))
                          symb_zero = symb_zero .and. (x(jx) == czero .or. temp == czero)
                                    
                          y(iy) = y(iy) + alpha*cabs1(x(jx))*temp
                          jx = jx + incx
                       end do
                    end if
                    if (.not. symb_zero) y(iy) = y(iy) + sign(safe1, y(iy))
                    iy = iy + incy
                 end do
              else
                 do i = 1, leny
                    if (beta == 0.0_dp) then
                       symb_zero = .true.
                       y(iy) = 0.0_dp
                    else if (y(iy) == 0.0_dp) then
                       symb_zero = .true.
                    else
                       symb_zero = .false.
                       y(iy) = beta*abs(y(iy))
                    end if
                    if (alpha /= 0.0_dp) then
                       jx = kx
                       do j = max(i - kl, 1), min(i + ku, lenx)
                          temp = cabs1(ab(ke - i + j, i))
                          symb_zero = symb_zero .and. (x(jx) == czero .or. temp == czero)
                                    
                          y(iy) = y(iy) + alpha*cabs1(x(jx))*temp
                          jx = jx + incx
                       end do
                    end if
                    if (.not. symb_zero) y(iy) = y(iy) + sign(safe1, y(iy))
                    iy = iy + incy
                 end do
              end if
           end if
           return
           ! end of stdlib_zla_gbamv
     end subroutine stdlib_zla_gbamv

     ! ZLA_GBRPVGRW computes the reciprocal pivot growth factor
     ! norm(A)/norm(U). The "max absolute element" norm is used. If this is
     ! much less than 1, the stability of the LU factorization of the
     ! (equilibrated) matrix A could be poor. This also means that the
     ! solution X, estimated condition numbers, and error bounds could be
     ! unreliable.

     real(dp) function stdlib_zla_gbrpvgrw(n, kl, ku, ncols, ab, ldab, afb, ldafb)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: n, kl, ku, ncols, ldab, ldafb
           ! .. array arguments ..
           complex(dp) :: ab(ldab, *), afb(ldafb, *)
        ! =====================================================================
           ! .. local scalars ..
           integer(ilp) :: i, j, kd
           real(dp) :: amax, umax, rpvgrw
           complex(dp) :: zdum
           ! .. intrinsic functions ..
           intrinsic :: abs, max, min, real, aimag
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(zdum) = abs(real(zdum, KIND=dp)) + abs(aimag(zdum))
           ! .. executable statements ..
           rpvgrw = 1.0_dp
           kd = ku + 1
           do j = 1, ncols
              amax = 0.0_dp
              umax = 0.0_dp
              do i = max(j - ku, 1), min(j + kl, n)
                 amax = max(cabs1(ab(kd + i - j, j)), amax)
              end do
              do i = max(j - ku, 1), j
                 umax = max(cabs1(afb(kd + i - j, j)), umax)
              end do
              if (umax /= 0.0_dp) then
                 rpvgrw = min(amax/umax, rpvgrw)
              end if
           end do
           stdlib_zla_gbrpvgrw = rpvgrw
           ! end of stdlib_zla_gbrpvgrw
     end function stdlib_zla_gbrpvgrw

     ! ZLA_GEAMV  performs one of the matrix-vector operations
     ! y := alpha*abs(A)*abs(x) + beta*abs(y),
     ! or   y := alpha*abs(A)**T*abs(x) + beta*abs(y),
     ! where alpha and beta are scalars, x and y are vectors and A is an
     ! m by n matrix.
     ! This function is primarily used in calculating error bounds.
     ! To protect against underflow during evaluation, components in
     ! the resulting vector are perturbed away from zero by (N+1)
     ! times the underflow threshold.  To prevent unnecessarily large
     ! errors for block-structure embedded in general matrices,
     ! "symbolically" zero components are not perturbed.  A zero
     ! entry is considered "symbolic" if all multiplications involved
     ! in computing that entry have at least one zero multiplicand.

     subroutine stdlib_zla_geamv(trans, m, n, alpha, a, lda, x, incx, beta, y, incy)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           real(dp) :: alpha, beta
           integer(ilp) :: incx, incy, lda, m, n
           integer(ilp) :: trans
           ! .. array arguments ..
           complex(dp) :: a(lda, *), x(*)
           real(dp) :: y(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: symb_zero
           real(dp) :: temp, safe1
           integer(ilp) :: i, info, iy, j, jx, kx, ky, lenx, leny
           complex(dp) :: cdum
     
           ! .. intrinsic functions ..
           intrinsic :: max, abs, real, aimag, sign
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(cdum) = abs(real(cdum, KIND=dp)) + abs(aimag(cdum))
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           if (.not. ((trans == stdlib_ilatrans('n')) .or. (trans == stdlib_ilatrans('t')) &
                     .or. (trans == stdlib_ilatrans('c')))) then
              info = 1
           else if (m < 0) then
              info = 2
           else if (n < 0) then
              info = 3
           else if (lda < max(1, m)) then
              info = 6
           else if (incx == 0) then
              info = 8
           else if (incy == 0) then
              info = 11
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zla_geamv ', info)
              return
           end if
           ! quick return if possible.
           if ((m == 0) .or. (n == 0) .or. ((alpha == czero) .and. (beta == cone))) return
           ! set  lenx  and  leny, the lengths of the vectors x and y, and set
           ! up the start points in  x  and  y.
           if (trans == stdlib_ilatrans('n')) then
              lenx = n
              leny = m
           else
              lenx = m
              leny = n
           end if
           if (incx > 0) then
              kx = 1
           else
              kx = 1 - (lenx - 1)*incx
           end if
           if (incy > 0) then
              ky = 1
           else
              ky = 1 - (leny - 1)*incy
           end if
           ! set safe1 essentially to be the underflow threshold times the
           ! number of additions in each row.
           safe1 = stdlib_dlamch('safe minimum')
           safe1 = (n + 1)*safe1
           ! form  y := alpha*abs(a)*abs(x) + beta*abs(y).
           ! the o(m*n) symb_zero tests could be replaced by o(n) queries to
           ! the inexact flag.  still doesn't help change the iteration order
           ! to per-column.
           iy = ky
           if (incx == 1) then
              if (trans == stdlib_ilatrans('n')) then
                 do i = 1, leny
                    if (beta == 0.0_dp) then
                       symb_zero = .true.
                       y(iy) = 0.0_dp
                    else if (y(iy) == 0.0_dp) then
                       symb_zero = .true.
                    else
                       symb_zero = .false.
                       y(iy) = beta*abs(y(iy))
                    end if
                    if (alpha /= 0.0_dp) then
                       do j = 1, lenx
                          temp = cabs1(a(i, j))
                          symb_zero = symb_zero .and. (x(j) == czero .or. temp == czero)
                                    
                          y(iy) = y(iy) + alpha*cabs1(x(j))*temp
                       end do
                    end if
                    if (.not. symb_zero) y(iy) = y(iy) + sign(safe1, y(iy))
                    iy = iy + incy
                 end do
              else
                 do i = 1, leny
                    if (beta == 0.0_dp) then
                       symb_zero = .true.
                       y(iy) = 0.0_dp
                    else if (y(iy) == 0.0_dp) then
                       symb_zero = .true.
                    else
                       symb_zero = .false.
                       y(iy) = beta*abs(y(iy))
                    end if
                    if (alpha /= 0.0_dp) then
                       do j = 1, lenx
                          temp = cabs1(a(j, i))
                          symb_zero = symb_zero .and. (x(j) == czero .or. temp == czero)
                                    
                          y(iy) = y(iy) + alpha*cabs1(x(j))*temp
                       end do
                    end if
                    if (.not. symb_zero) y(iy) = y(iy) + sign(safe1, y(iy))
                    iy = iy + incy
                 end do
              end if
           else
              if (trans == stdlib_ilatrans('n')) then
                 do i = 1, leny
                    if (beta == 0.0_dp) then
                       symb_zero = .true.
                       y(iy) = 0.0_dp
                    else if (y(iy) == 0.0_dp) then
                       symb_zero = .true.
                    else
                       symb_zero = .false.
                       y(iy) = beta*abs(y(iy))
                    end if
                    if (alpha /= 0.0_dp) then
                       jx = kx
                       do j = 1, lenx
                          temp = cabs1(a(i, j))
                          symb_zero = symb_zero .and. (x(jx) == czero .or. temp == czero)
                                    
                          y(iy) = y(iy) + alpha*cabs1(x(jx))*temp
                          jx = jx + incx
                       end do
                    end if
                    if (.not. symb_zero) y(iy) = y(iy) + sign(safe1, y(iy))
                    iy = iy + incy
                 end do
              else
                 do i = 1, leny
                    if (beta == 0.0_dp) then
                       symb_zero = .true.
                       y(iy) = 0.0_dp
                    else if (y(iy) == 0.0_dp) then
                       symb_zero = .true.
                    else
                       symb_zero = .false.
                       y(iy) = beta*abs(y(iy))
                    end if
                    if (alpha /= 0.0_dp) then
                       jx = kx
                       do j = 1, lenx
                          temp = cabs1(a(j, i))
                          symb_zero = symb_zero .and. (x(jx) == czero .or. temp == czero)
                                    
                          y(iy) = y(iy) + alpha*cabs1(x(jx))*temp
                          jx = jx + incx
                       end do
                    end if
                    if (.not. symb_zero) y(iy) = y(iy) + sign(safe1, y(iy))
                    iy = iy + incy
                 end do
              end if
           end if
           return
           ! end of stdlib_zla_geamv
     end subroutine stdlib_zla_geamv

     ! ZLA_GERPVGRW computes the reciprocal pivot growth factor
     ! norm(A)/norm(U). The "max absolute element" norm is used. If this is
     ! much less than 1, the stability of the LU factorization of the
     ! (equilibrated) matrix A could be poor. This also means that the
     ! solution X, estimated condition numbers, and error bounds could be
     ! unreliable.

     real(dp) function stdlib_zla_gerpvgrw(n, ncols, a, lda, af, ldaf)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: n, ncols, lda, ldaf
           ! .. array arguments ..
           complex(dp) :: a(lda, *), af(ldaf, *)
        ! =====================================================================
           ! .. local scalars ..
           integer(ilp) :: i, j
           real(dp) :: amax, umax, rpvgrw
           complex(dp) :: zdum
           ! .. intrinsic functions ..
           intrinsic :: max, min, abs, real, aimag
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(zdum) = abs(real(zdum, KIND=dp)) + abs(aimag(zdum))
           ! .. executable statements ..
           rpvgrw = 1.0_dp
           do j = 1, ncols
              amax = 0.0_dp
              umax = 0.0_dp
              do i = 1, n
                 amax = max(cabs1(a(i, j)), amax)
              end do
              do i = 1, j
                 umax = max(cabs1(af(i, j)), umax)
              end do
              if (umax /= 0.0_dp) then
                 rpvgrw = min(amax/umax, rpvgrw)
              end if
           end do
           stdlib_zla_gerpvgrw = rpvgrw
           ! end of stdlib_zla_gerpvgrw
     end function stdlib_zla_gerpvgrw

     ! ZLA_SYAMV  performs the matrix-vector operation
     ! y := alpha*abs(A)*abs(x) + beta*abs(y),
     ! where alpha and beta are scalars, x and y are vectors and A is an
     ! n by n symmetric matrix.
     ! This function is primarily used in calculating error bounds.
     ! To protect against underflow during evaluation, components in
     ! the resulting vector are perturbed away from zero by (N+1)
     ! times the underflow threshold.  To prevent unnecessarily large
     ! errors for block-structure embedded in general matrices,
     ! "symbolically" zero components are not perturbed.  A zero
     ! entry is considered "symbolic" if all multiplications involved
     ! in computing that entry have at least one zero multiplicand.

     subroutine stdlib_zla_heamv(uplo, n, alpha, a, lda, x, incx, beta, y, incy)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           real(dp) :: alpha, beta
           integer(ilp) :: incx, incy, lda, n, uplo
           ! .. array arguments ..
           complex(dp) :: a(lda, *), x(*)
           real(dp) :: y(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: symb_zero
           real(dp) :: temp, safe1
           integer(ilp) :: i, info, iy, j, jx, kx, ky
           complex(dp) :: zdum
     
           ! .. intrinsic functions ..
           intrinsic :: max, abs, sign, real, aimag
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(zdum) = abs(dble(zdum)) + abs(aimag(zdum))
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           if (uplo /= stdlib_ilauplo('u') .and. uplo /= stdlib_ilauplo('l')) then
              info = 1
           else if (n < 0) then
              info = 2
           else if (lda < max(1, n)) then
              info = 5
           else if (incx == 0) then
              info = 7
           else if (incy == 0) then
              info = 10
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zhemv ', info)
              return
           end if
           ! quick return if possible.
           if ((n == 0) .or. ((alpha == zero) .and. (beta == one))) return
           ! set up the start points in  x  and  y.
           if (incx > 0) then
              kx = 1
           else
              kx = 1 - (n - 1)*incx
           end if
           if (incy > 0) then
              ky = 1
           else
              ky = 1 - (n - 1)*incy
           end if
           ! set safe1 essentially to be the underflow threshold times the
           ! number of additions in each row.
           safe1 = stdlib_dlamch('safe minimum')
           safe1 = (n + 1)*safe1
           ! form  y := alpha*abs(a)*abs(x) + beta*abs(y).
           ! the o(n^2) symb_zero tests could be replaced by o(n) queries to
           ! the inexact flag.  still doesn't help change the iteration order
           ! to per-column.
           iy = ky
           if (incx == 1) then
              if (uplo == stdlib_ilauplo('u')) then
                 do i = 1, n
                    if (beta == zero) then
                       symb_zero = .true.
                       y(iy) = 0.0_dp
                    else if (y(iy) == zero) then
                       symb_zero = .true.
                    else
                       symb_zero = .false.
                       y(iy) = beta*abs(y(iy))
                    end if
                    if (alpha /= zero) then
                       do j = 1, i
                          temp = cabs1(a(j, i))
                          symb_zero = symb_zero .and. (x(j) == zero .or. temp == zero)
                          y(iy) = y(iy) + alpha*cabs1(x(j))*temp
                       end do
                       do j = i + 1, n
                          temp = cabs1(a(i, j))
                          symb_zero = symb_zero .and. (x(j) == zero .or. temp == zero)
                          y(iy) = y(iy) + alpha*cabs1(x(j))*temp
                       end do
                    end if
                    if (.not. symb_zero) y(iy) = y(iy) + sign(safe1, y(iy))
                    iy = iy + incy
                 end do
              else
                 do i = 1, n
                    if (beta == zero) then
                       symb_zero = .true.
                       y(iy) = 0.0_dp
                    else if (y(iy) == zero) then
                       symb_zero = .true.
                    else
                       symb_zero = .false.
                       y(iy) = beta*abs(y(iy))
                    end if
                    if (alpha /= zero) then
                       do j = 1, i
                          temp = cabs1(a(i, j))
                          symb_zero = symb_zero .and. (x(j) == zero .or. temp == zero)
                          y(iy) = y(iy) + alpha*cabs1(x(j))*temp
                       end do
                       do j = i + 1, n
                          temp = cabs1(a(j, i))
                          symb_zero = symb_zero .and. (x(j) == zero .or. temp == zero)
                          y(iy) = y(iy) + alpha*cabs1(x(j))*temp
                       end do
                    end if
                    if (.not. symb_zero) y(iy) = y(iy) + sign(safe1, y(iy))
                    iy = iy + incy
                 end do
              end if
           else
              if (uplo == stdlib_ilauplo('u')) then
                 do i = 1, n
                    if (beta == zero) then
                       symb_zero = .true.
                       y(iy) = 0.0_dp
                    else if (y(iy) == zero) then
                       symb_zero = .true.
                    else
                       symb_zero = .false.
                       y(iy) = beta*abs(y(iy))
                    end if
                    jx = kx
                    if (alpha /= zero) then
                       do j = 1, i
                          temp = cabs1(a(j, i))
                          symb_zero = symb_zero .and. (x(j) == zero .or. temp == zero)
                          y(iy) = y(iy) + alpha*cabs1(x(jx))*temp
                          jx = jx + incx
                       end do
                       do j = i + 1, n
                          temp = cabs1(a(i, j))
                          symb_zero = symb_zero .and. (x(j) == zero .or. temp == zero)
                          y(iy) = y(iy) + alpha*cabs1(x(jx))*temp
                          jx = jx + incx
                       end do
                    end if
                    if (.not. symb_zero) y(iy) = y(iy) + sign(safe1, y(iy))
                    iy = iy + incy
                 end do
              else
                 do i = 1, n
                    if (beta == zero) then
                       symb_zero = .true.
                       y(iy) = 0.0_dp
                    else if (y(iy) == zero) then
                       symb_zero = .true.
                    else
                       symb_zero = .false.
                       y(iy) = beta*abs(y(iy))
                    end if
                    jx = kx
                    if (alpha /= zero) then
                       do j = 1, i
                          temp = cabs1(a(i, j))
                          symb_zero = symb_zero .and. (x(j) == zero .or. temp == zero)
                          y(iy) = y(iy) + alpha*cabs1(x(jx))*temp
                          jx = jx + incx
                       end do
                       do j = i + 1, n
                          temp = cabs1(a(j, i))
                          symb_zero = symb_zero .and. (x(j) == zero .or. temp == zero)
                          y(iy) = y(iy) + alpha*cabs1(x(jx))*temp
                          jx = jx + incx
                       end do
                    end if
                    if (.not. symb_zero) y(iy) = y(iy) + sign(safe1, y(iy))
                    iy = iy + incy
                 end do
              end if
           end if
           return
           ! end of stdlib_zla_heamv
     end subroutine stdlib_zla_heamv

     ! ZLA_LIN_BERR computes componentwise relative backward error from
     ! the formula
     ! max(i) ( abs(R(i)) / ( abs(op(A_s))*abs(Y) + abs(B_s) )(i) )
     ! where abs(Z) is the componentwise absolute value of the matrix
     ! or vector Z.

     subroutine stdlib_zla_lin_berr(n, nz, nrhs, res, ayb, berr)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: n, nz, nrhs
           ! .. array arguments ..
           real(dp) :: ayb(n, nrhs), berr(nrhs)
           complex(dp) :: res(n, nrhs)
        ! =====================================================================
           ! .. local scalars ..
           real(dp) :: tmp, safe1
           integer(ilp) :: i, j
           complex(dp) :: cdum
           ! .. intrinsic functions ..
           intrinsic :: abs, real, aimag, max
     
           ! .. statement functions ..
           complex(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(cdum) = abs(real(cdum, KIND=dp)) + abs(aimag(cdum))
           ! .. executable statements ..
           ! adding safe1 to the numerator guards against spuriously zero
           ! residuals.  a similar safeguard is in the cla_yyamv routine used
           ! to compute ayb.
           safe1 = stdlib_dlamch('safe minimum')
           safe1 = (nz + 1)*safe1
           do j = 1, nrhs
              berr(j) = 0.0_dp
              do i = 1, n
                 if (ayb(i, j) /= 0.0_dp) then
                    tmp = (safe1 + cabs1(res(i, j)))/ayb(i, j)
                    berr(j) = max(berr(j), tmp)
                 end if
           ! if ayb is exactly 0.0 (and if computed by cla_yyamv), then we know
           ! the true residual also must be exactly 0.0.
              end do
           end do
           ! end of stdlib_zla_lin_berr
     end subroutine stdlib_zla_lin_berr

     ! ZLA_PORPVGRW computes the reciprocal pivot growth factor
     ! norm(A)/norm(U). The "max absolute element" norm is used. If this is
     ! much less than 1, the stability of the LU factorization of the
     ! (equilibrated) matrix A could be poor. This also means that the
     ! solution X, estimated condition numbers, and error bounds could be
     ! unreliable.

     real(dp) function stdlib_zla_porpvgrw(uplo, ncols, a, lda, af, ldaf, work)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character*1 uplo
           integer(ilp) :: ncols, lda, ldaf
           ! .. array arguments ..
           complex(dp) :: a(lda, *), af(ldaf, *)
           real(dp) :: work(*)
        ! =====================================================================
           ! .. local scalars ..
           integer(ilp) :: i, j
           real(dp) :: amax, umax, rpvgrw
           logical(lk) :: upper
           complex(dp) :: zdum
     
           ! .. intrinsic functions ..
           intrinsic :: abs, max, min, real, aimag
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(zdum) = abs(real(zdum, KIND=dp)) + abs(aimag(zdum))
           ! .. executable statements ..
           upper = stdlib_lsame('upper', uplo)
           ! stdlib_dpotrf will have factored only the ncolsxncols leading minor, so
           ! we restrict the growth search to that minor and use only the first
           ! 2*ncols workspace entries.
           rpvgrw = 1.0_dp
           do i = 1, 2*ncols
              work(i) = 0.0_dp
           end do
           ! find the max magnitude entry of each column.
           if (upper) then
              do j = 1, ncols
                 do i = 1, j
                    work(ncols + j) = max(cabs1(a(i, j)), work(ncols + j))
                 end do
              end do
           else
              do j = 1, ncols
                 do i = j, ncols
                    work(ncols + j) = max(cabs1(a(i, j)), work(ncols + j))
                 end do
              end do
           end if
           ! now find the max magnitude entry of each column of the factor in
           ! af.  no pivoting, so no permutations.
           if (stdlib_lsame('upper', uplo)) then
              do j = 1, ncols
                 do i = 1, j
                    work(j) = max(cabs1(af(i, j)), work(j))
                 end do
              end do
           else
              do j = 1, ncols
                 do i = j, ncols
                    work(j) = max(cabs1(af(i, j)), work(j))
                 end do
              end do
           end if
           ! compute the *inverse* of the max element growth factor.  dividing
           ! by zero would imply the largest entry of the factor's column is
           ! zero.  than can happen when either the column of a is zero or
           ! massive pivots made the factor underflow to zero.  neither counts
           ! as growth in itself, so simply ignore terms with zero
           ! denominators.
           if (stdlib_lsame('upper', uplo)) then
              do i = 1, ncols
                 umax = work(i)
                 amax = work(ncols + i)
                 if (umax /= 0.0_dp) then
                    rpvgrw = min(amax/umax, rpvgrw)
                 end if
              end do
           else
              do i = 1, ncols
                 umax = work(i)
                 amax = work(ncols + i)
                 if (umax /= 0.0_dp) then
                    rpvgrw = min(amax/umax, rpvgrw)
                 end if
              end do
           end if
           stdlib_zla_porpvgrw = rpvgrw
           ! end of stdlib_zla_porpvgrw
     end function stdlib_zla_porpvgrw

     ! ZLA_SYAMV  performs the matrix-vector operation
     ! y := alpha*abs(A)*abs(x) + beta*abs(y),
     ! where alpha and beta are scalars, x and y are vectors and A is an
     ! n by n symmetric matrix.
     ! This function is primarily used in calculating error bounds.
     ! To protect against underflow during evaluation, components in
     ! the resulting vector are perturbed away from zero by (N+1)
     ! times the underflow threshold.  To prevent unnecessarily large
     ! errors for block-structure embedded in general matrices,
     ! "symbolically" zero components are not perturbed.  A zero
     ! entry is considered "symbolic" if all multiplications involved
     ! in computing that entry have at least one zero multiplicand.

     subroutine stdlib_zla_syamv(uplo, n, alpha, a, lda, x, incx, beta, y, incy)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           real(dp) :: alpha, beta
           integer(ilp) :: incx, incy, lda, n
           integer(ilp) :: uplo
           ! .. array arguments ..
           complex(dp) :: a(lda, *), x(*)
           real(dp) :: y(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: symb_zero
           real(dp) :: temp, safe1
           integer(ilp) :: i, info, iy, j, jx, kx, ky
           complex(dp) :: zdum
     
           ! .. intrinsic functions ..
           intrinsic :: max, abs, sign, real, aimag
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(zdum) = abs(dble(zdum)) + abs(aimag(zdum))
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           if (uplo /= stdlib_ilauplo('u') .and. uplo /= stdlib_ilauplo('l')) then
              info = 1
           else if (n < 0) then
              info = 2
           else if (lda < max(1, n)) then
              info = 5
           else if (incx == 0) then
              info = 7
           else if (incy == 0) then
              info = 10
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zla_syamv', info)
              return
           end if
           ! quick return if possible.
           if ((n == 0) .or. ((alpha == zero) .and. (beta == one))) return
           ! set up the start points in  x  and  y.
           if (incx > 0) then
              kx = 1
           else
              kx = 1 - (n - 1)*incx
           end if
           if (incy > 0) then
              ky = 1
           else
              ky = 1 - (n - 1)*incy
           end if
           ! set safe1 essentially to be the underflow threshold times the
           ! number of additions in each row.
           safe1 = stdlib_dlamch('safe minimum')
           safe1 = (n + 1)*safe1
           ! form  y := alpha*abs(a)*abs(x) + beta*abs(y).
           ! the o(n^2) symb_zero tests could be replaced by o(n) queries to
           ! the inexact flag.  still doesn't help change the iteration order
           ! to per-column.
           iy = ky
           if (incx == 1) then
              if (uplo == stdlib_ilauplo('u')) then
                 do i = 1, n
                    if (beta == zero) then
                       symb_zero = .true.
                       y(iy) = 0.0_dp
                    else if (y(iy) == zero) then
                       symb_zero = .true.
                    else
                       symb_zero = .false.
                       y(iy) = beta*abs(y(iy))
                    end if
                    if (alpha /= zero) then
                       do j = 1, i
                          temp = cabs1(a(j, i))
                          symb_zero = symb_zero .and. (x(j) == zero .or. temp == zero)
                          y(iy) = y(iy) + alpha*cabs1(x(j))*temp
                       end do
                       do j = i + 1, n
                          temp = cabs1(a(i, j))
                          symb_zero = symb_zero .and. (x(j) == zero .or. temp == zero)
                          y(iy) = y(iy) + alpha*cabs1(x(j))*temp
                       end do
                    end if
                    if (.not. symb_zero) y(iy) = y(iy) + sign(safe1, y(iy))
                    iy = iy + incy
                 end do
              else
                 do i = 1, n
                    if (beta == zero) then
                       symb_zero = .true.
                       y(iy) = 0.0_dp
                    else if (y(iy) == zero) then
                       symb_zero = .true.
                    else
                       symb_zero = .false.
                       y(iy) = beta*abs(y(iy))
                    end if
                    if (alpha /= zero) then
                       do j = 1, i
                          temp = cabs1(a(i, j))
                          symb_zero = symb_zero .and. (x(j) == zero .or. temp == zero)
                          y(iy) = y(iy) + alpha*cabs1(x(j))*temp
                       end do
                       do j = i + 1, n
                          temp = cabs1(a(j, i))
                          symb_zero = symb_zero .and. (x(j) == zero .or. temp == zero)
                          y(iy) = y(iy) + alpha*cabs1(x(j))*temp
                       end do
                    end if
                    if (.not. symb_zero) y(iy) = y(iy) + sign(safe1, y(iy))
                    iy = iy + incy
                 end do
              end if
           else
              if (uplo == stdlib_ilauplo('u')) then
                 do i = 1, n
                    if (beta == zero) then
                       symb_zero = .true.
                       y(iy) = 0.0_dp
                    else if (y(iy) == zero) then
                       symb_zero = .true.
                    else
                       symb_zero = .false.
                       y(iy) = beta*abs(y(iy))
                    end if
                    jx = kx
                    if (alpha /= zero) then
                       do j = 1, i
                          temp = cabs1(a(j, i))
                          symb_zero = symb_zero .and. (x(j) == zero .or. temp == zero)
                          y(iy) = y(iy) + alpha*cabs1(x(jx))*temp
                          jx = jx + incx
                       end do
                       do j = i + 1, n
                          temp = cabs1(a(i, j))
                          symb_zero = symb_zero .and. (x(j) == zero .or. temp == zero)
                          y(iy) = y(iy) + alpha*cabs1(x(jx))*temp
                          jx = jx + incx
                       end do
                    end if
                    if (.not. symb_zero) y(iy) = y(iy) + sign(safe1, y(iy))
                    iy = iy + incy
                 end do
              else
                 do i = 1, n
                    if (beta == zero) then
                       symb_zero = .true.
                       y(iy) = 0.0_dp
                    else if (y(iy) == zero) then
                       symb_zero = .true.
                    else
                       symb_zero = .false.
                       y(iy) = beta*abs(y(iy))
                    end if
                    jx = kx
                    if (alpha /= zero) then
                       do j = 1, i
                          temp = cabs1(a(i, j))
                          symb_zero = symb_zero .and. (x(j) == zero .or. temp == zero)
                          y(iy) = y(iy) + alpha*cabs1(x(jx))*temp
                          jx = jx + incx
                       end do
                       do j = i + 1, n
                          temp = cabs1(a(j, i))
                          symb_zero = symb_zero .and. (x(j) == zero .or. temp == zero)
                          y(iy) = y(iy) + alpha*cabs1(x(jx))*temp
                          jx = jx + incx
                       end do
                    end if
                    if (.not. symb_zero) y(iy) = y(iy) + sign(safe1, y(iy))
                    iy = iy + incy
                 end do
              end if
           end if
           return
           ! end of stdlib_zla_syamv
     end subroutine stdlib_zla_syamv

     ! ZLA_WWADDW adds a vector W into a doubled-single vector (X, Y).
     ! This works for all extant IBM's hex and binary floating point
     ! arithmetic, but not for decimal.

     subroutine stdlib_zla_wwaddw(n, x, y, w)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: n
           ! .. array arguments ..
           complex(dp) :: x(*), y(*), w(*)
        ! =====================================================================
           ! .. local scalars ..
           complex(dp) :: s
           integer(ilp) :: i
           ! .. executable statements ..
           do 10 i = 1, n
             s = x(i) + w(i)
             s = (s + s) - s
             y(i) = ((x(i) - s) + w(i)) + y(i)
             x(i) = s
10      continue
           return
           ! end of stdlib_zla_wwaddw
     end subroutine stdlib_zla_wwaddw

     ! ZLACGV conjugates a complex vector of length N.

     subroutine stdlib_zlacgv(n, x, incx)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: incx, n
           ! .. array arguments ..
           complex(dp) :: x(*)
       ! =====================================================================
           ! .. local scalars ..
           integer(ilp) :: i, ioff
           ! .. intrinsic functions ..
           intrinsic :: conjg
           ! .. executable statements ..
           if (incx == 1) then
              do i = 1, n
                 x(i) = conjg(x(i))
              end do
           else
              ioff = 1
              if (incx < 0) ioff = 1 - (n - 1)*incx
              do i = 1, n
                 x(ioff) = conjg(x(ioff))
                 ioff = ioff + incx
              end do
           end if
           return
           ! end of stdlib_zlacgv
     end subroutine stdlib_zlacgv

     ! ZLACN2 estimates the 1-norm of a square, complex matrix A.
     ! Reverse communication is used for evaluating matrix-vector products.

     subroutine stdlib_zlacn2(n, v, x, est, kase, isave)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: kase, n
           real(dp) :: est
           ! .. array arguments ..
           integer(ilp) :: isave(3)
           complex(dp) :: v(*), x(*)
        ! =====================================================================
           ! .. parameters ..
           integer(ilp), parameter :: itmax = 5
           
           ! .. local scalars ..
           integer(ilp) :: i, jlast
           real(dp) :: absxi, altsgn, estold, safmin, temp
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, dcmplx, aimag
           ! .. executable statements ..
           safmin = stdlib_dlamch('safe minimum')
           if (kase == 0) then
              do i = 1, n
                 x(i) = cmplx(one/real(n, KIND=dp), KIND=dp)
              end do
              kase = 1
              isave(1) = 1
              return
           end if
           go to(20, 40, 70, 90, 120) isave(1)
           ! ................ entry   (isave( 1 ) = 1)
           ! first iteration.  x has been overwritten by a*x.
20      continue
           if (n == 1) then
              v(1) = x(1)
              est = abs(v(1))
              ! ... quit
              go to 130
           end if
           est = stdlib_dzsum1(n, x, 1)
           do i = 1, n
              absxi = abs(x(i))
              if (absxi > safmin) then
                 x(i) = dcmplx(real(x(i), KIND=dp)/absxi, aimag(x(i))/absxi)
              else
                 x(i) = cone
              end if
           end do
           kase = 2
           isave(1) = 2
           return
           ! ................ entry   (isave( 1 ) = 2)
           ! first iteration.  x has been overwritten by ctrans(a)*x.
40      continue
           isave(2) = stdlib_izmax1(n, x, 1)
           isave(3) = 2
           ! main loop - iterations 2,3,...,itmax.
50      continue
           do i = 1, n
              x(i) = czero
           end do
           x(isave(2)) = cone
           kase = 1
           isave(1) = 3
           return
           ! ................ entry   (isave( 1 ) = 3)
           ! x has been overwritten by a*x.
70      continue
           call stdlib_zcopy(n, x, 1, v, 1)
           estold = est
           est = stdlib_dzsum1(n, v, 1)
           ! test for cycling.
           if (est <= estold) go to 100
           do i = 1, n
              absxi = abs(x(i))
              if (absxi > safmin) then
                 x(i) = dcmplx(real(x(i), KIND=dp)/absxi, aimag(x(i))/absxi)
              else
                 x(i) = cone
              end if
           end do
           kase = 2
           isave(1) = 4
           return
           ! ................ entry   (isave( 1 ) = 4)
           ! x has been overwritten by ctrans(a)*x.
90      continue
           jlast = isave(2)
           isave(2) = stdlib_izmax1(n, x, 1)
           if ((abs(x(jlast)) /= abs(x(isave(2)))) .and. (isave(3) < itmax)) &
                     then
              isave(3) = isave(3) + 1
              go to 50
           end if
           ! iteration complete.  final stage.
100    continue
           altsgn = one
           do i = 1, n
              x(i) = dcmplx(altsgn*(one + real(i - 1, KIND=dp)/real(n - 1, KIND=dp)))
              altsgn = -altsgn
           end do
           kase = 1
           isave(1) = 5
           return
           ! ................ entry   (isave( 1 ) = 5)
           ! x has been overwritten by a*x.
120    continue
           temp = two*(stdlib_dzsum1(n, x, 1)/real(3*n, KIND=dp))
           if (temp > est) then
              call stdlib_zcopy(n, x, 1, v, 1)
              est = temp
           end if
130    continue
           kase = 0
           return
           ! end of stdlib_zlacn2
     end subroutine stdlib_zlacn2

     ! ZLACON estimates the 1-norm of a square, complex matrix A.
     ! Reverse communication is used for evaluating matrix-vector products.

     subroutine stdlib_zlacon(n, v, x, est, kase)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: kase, n
           real(dp) :: est
           ! .. array arguments ..
           complex(dp) :: v(n), x(n)
        ! =====================================================================
           ! .. parameters ..
           integer(ilp), parameter :: itmax = 5
           
           ! .. local scalars ..
           integer(ilp) :: i, iter, j, jlast, jump
           real(dp) :: absxi, altsgn, estold, safmin, temp
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, dcmplx, aimag
           ! .. save statement ..
           save
           ! .. executable statements ..
           safmin = stdlib_dlamch('safe minimum')
           if (kase == 0) then
              do i = 1, n
                 x(i) = cmplx(one/real(n, KIND=dp), KIND=dp)
              end do
              kase = 1
              jump = 1
              return
           end if
           go to(20, 40, 70, 90, 120) jump
           ! ................ entry   (jump = 1)
           ! first iteration.  x has been overwritten by a*x.
20      continue
           if (n == 1) then
              v(1) = x(1)
              est = abs(v(1))
              ! ... quit
              go to 130
           end if
           est = stdlib_dzsum1(n, x, 1)
           do i = 1, n
              absxi = abs(x(i))
              if (absxi > safmin) then
                 x(i) = dcmplx(real(x(i), KIND=dp)/absxi, aimag(x(i))/absxi)
              else
                 x(i) = cone
              end if
           end do
           kase = 2
           jump = 2
           return
           ! ................ entry   (jump = 2)
           ! first iteration.  x has been overwritten by ctrans(a)*x.
40      continue
           j = stdlib_izmax1(n, x, 1)
           iter = 2
           ! main loop - iterations 2,3,...,itmax.
50      continue
           do i = 1, n
              x(i) = czero
           end do
           x(j) = cone
           kase = 1
           jump = 3
           return
           ! ................ entry   (jump = 3)
           ! x has been overwritten by a*x.
70      continue
           call stdlib_zcopy(n, x, 1, v, 1)
           estold = est
           est = stdlib_dzsum1(n, v, 1)
           ! test for cycling.
           if (est <= estold) go to 100
           do i = 1, n
              absxi = abs(x(i))
              if (absxi > safmin) then
                 x(i) = dcmplx(real(x(i), KIND=dp)/absxi, aimag(x(i))/absxi)
              else
                 x(i) = cone
              end if
           end do
           kase = 2
           jump = 4
           return
           ! ................ entry   (jump = 4)
           ! x has been overwritten by ctrans(a)*x.
90      continue
           jlast = j
           j = stdlib_izmax1(n, x, 1)
           if ((abs(x(jlast)) /= abs(x(j))) .and. (iter < itmax)) then
              iter = iter + 1
              go to 50
           end if
           ! iteration complete.  final stage.
100    continue
           altsgn = one
           do i = 1, n
              x(i) = dcmplx(altsgn*(one + real(i - 1, KIND=dp)/real(n - 1, KIND=dp)))
              altsgn = -altsgn
           end do
           kase = 1
           jump = 5
           return
           ! ................ entry   (jump = 5)
           ! x has been overwritten by a*x.
120    continue
           temp = two*(stdlib_dzsum1(n, x, 1)/real(3*n, KIND=dp))
           if (temp > est) then
              call stdlib_zcopy(n, x, 1, v, 1)
              est = temp
           end if
130    continue
           kase = 0
           return
           ! end of stdlib_zlacon
     end subroutine stdlib_zlacon

     ! ZLACP2 copies all or part of a real two-dimensional matrix A to a
     ! complex matrix B.

     subroutine stdlib_zlacp2(uplo, m, n, a, lda, b, ldb)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: lda, ldb, m, n
           ! .. array arguments ..
           real(dp) :: a(lda, *)
           complex(dp) :: b(ldb, *)
        ! =====================================================================
           ! .. local scalars ..
           integer(ilp) :: i, j
     
           ! .. intrinsic functions ..
           intrinsic :: min
           ! .. executable statements ..
           if (stdlib_lsame(uplo, 'u')) then
              do j = 1, n
                 do i = 1, min(j, m)
                    b(i, j) = a(i, j)
                 end do
              end do
           else if (stdlib_lsame(uplo, 'l')) then
              do j = 1, n
                 do i = j, m
                    b(i, j) = a(i, j)
                 end do
              end do
           else
              do j = 1, n
                 do i = 1, m
                    b(i, j) = a(i, j)
                 end do
              end do
           end if
           return
           ! end of stdlib_zlacp2
     end subroutine stdlib_zlacp2

     ! ZLACPY copies all or part of a two-dimensional matrix A to another
     ! matrix B.

     subroutine stdlib_zlacpy(uplo, m, n, a, lda, b, ldb)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: lda, ldb, m, n
           ! .. array arguments ..
           complex(dp) :: a(lda, *), b(ldb, *)
        ! =====================================================================
           ! .. local scalars ..
           integer(ilp) :: i, j
     
           ! .. intrinsic functions ..
           intrinsic :: min
           ! .. executable statements ..
           if (stdlib_lsame(uplo, 'u')) then
              do j = 1, n
                 do i = 1, min(j, m)
                    b(i, j) = a(i, j)
                 end do
              end do
           else if (stdlib_lsame(uplo, 'l')) then
              do j = 1, n
                 do i = j, m
                    b(i, j) = a(i, j)
                 end do
              end do
           else
              do j = 1, n
                 do i = 1, m
                    b(i, j) = a(i, j)
                 end do
              end do
           end if
           return
           ! end of stdlib_zlacpy
     end subroutine stdlib_zlacpy

     ! ZLACRM performs a very simple matrix-matrix multiplication:
     ! C := A * B,
     ! where A is M by N and complex; B is N by N and real;
     ! C is M by N and complex.

     subroutine stdlib_zlacrm(m, n, a, lda, b, ldb, c, ldc, rwork)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: lda, ldb, ldc, m, n
           ! .. array arguments ..
           real(dp) :: b(ldb, *), rwork(*)
           complex(dp) :: a(lda, *), c(ldc, *)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i, j, l
           ! .. intrinsic functions ..
           intrinsic :: dble, dcmplx, aimag
     
           ! .. executable statements ..
           ! quick return if possible.
           if ((m == 0) .or. (n == 0)) return
           do j = 1, n
              do i = 1, m
                 rwork((j - 1)*m + i) = real(a(i, j), KIND=dp)
              end do
           end do
           l = m*n + 1
           call stdlib_dgemm('n', 'n', m, n, n, one, rwork, m, b, ldb, zero, rwork(l), m)
                     
           do j = 1, n
              do i = 1, m
                 c(i, j) = rwork(l + (j - 1)*m + i - 1)
              end do
           end do
           do j = 1, n
              do i = 1, m
                 rwork((j - 1)*m + i) = aimag(a(i, j))
              end do
           end do
           call stdlib_dgemm('n', 'n', m, n, n, one, rwork, m, b, ldb, zero, rwork(l), m)
                     
           do j = 1, n
              do i = 1, m
                 c(i, j) = dcmplx(real(c(i, j), KIND=dp), rwork(l + (j - 1)*m + i - 1))
              end do
           end do
           return
           ! end of stdlib_zlacrm
     end subroutine stdlib_zlacrm

     ! ZLACRT performs the operation
     ! (  c  s )( x )  ==> ( x )
     ! ( -s  c )( y )      ( y )
     ! where c and s are complex and the vectors x and y are complex.

     subroutine stdlib_zlacrt(n, cx, incx, cy, incy, c, s)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: incx, incy, n
           complex(dp) :: c, s
           ! .. array arguments ..
           complex(dp) :: cx(*), cy(*)
       ! =====================================================================
           ! .. local scalars ..
           integer(ilp) :: i, ix, iy
           complex(dp) :: ctemp
           ! .. executable statements ..
           if (n <= 0) return
           if (incx == 1 .and. incy == 1) go to 20
           ! code for unequal increments or equal increments not equal to 1
           ix = 1
           iy = 1
           if (incx < 0) ix = (-n + 1)*incx + 1
           if (incy < 0) iy = (-n + 1)*incy + 1
           do i = 1, n
              ctemp = c*cx(ix) + s*cy(iy)
              cy(iy) = c*cy(iy) - s*cx(ix)
              cx(ix) = ctemp
              ix = ix + incx
              iy = iy + incy
           end do
           return
           ! code for both increments equal to 1
20      continue
           do i = 1, n
              ctemp = c*cx(i) + s*cy(i)
              cy(i) = c*cy(i) - s*cx(i)
              cx(i) = ctemp
           end do
           return
     end subroutine stdlib_zlacrt

     ! ZLADIV := X / Y, where X and Y are complex.  The computation of X / Y
     ! will not overflow on an intermediary step unless the results
     ! overflows.

     complex(dp) function stdlib_zladiv(x, y)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           complex(dp) :: x, y
        ! =====================================================================
           ! .. local scalars ..
           real(dp) :: zi, zr
     
           ! .. intrinsic functions ..
           intrinsic :: dble, dcmplx, aimag
           ! .. executable statements ..
           call stdlib_dladiv(real(x, KIND=dp), aimag(x), real(y, KIND=dp), aimag(y), zr, &
                     zi)
           stdlib_zladiv = cmplx(zr, zi, KIND=dp)
           return
           ! end of stdlib_zladiv
     end function stdlib_zladiv

     ! ZLAED8 merges the two sets of eigenvalues together into a single
     ! sorted set.  Then it tries to deflate the size of the problem.
     ! There are two ways in which deflation can occur:  when two or more
     ! eigenvalues are close together or if there is a tiny element in the
     ! Z vector.  For each such occurrence the order of the related secular
     ! equation problem is reduced by one.

     subroutine stdlib_zlaed8(k, n, qsiz, q, ldq, d, rho, cutpnt, z, dlamda, q2, ldq2, w, indxp, &
               indx, indxq, perm, givptr, givcol, givnum, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: cutpnt, givptr, info, k, ldq, ldq2, n, qsiz
           real(dp) :: rho
           ! .. array arguments ..
           integer(ilp) :: givcol(2, *), indx(*), indxp(*), indxq(*), perm(*)
           real(dp) :: d(*), dlamda(*), givnum(2, *), w(*), z(*)
           complex(dp) :: q(ldq, *), q2(ldq2, *)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: mone = -1.0d0
           
           ! .. local scalars ..
           integer(ilp) :: i, imax, j, jlam, jmax, jp, k2, n1, n1p1, n2
           real(dp) :: c, eps, s, t, tau, tol
     
           ! .. intrinsic functions ..
           intrinsic :: abs, max, min, sqrt
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           if (n < 0) then
              info = -2
           else if (qsiz < n) then
              info = -3
           else if (ldq < max(1, n)) then
              info = -5
           else if (cutpnt < min(1, n) .or. cutpnt > n) then
              info = -8
           else if (ldq2 < max(1, n)) then
              info = -12
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zlaed8', -info)
              return
           end if
           ! need to initialize givptr to o here in case of quick exit
           ! to prevent an unspecified code behavior (usually sigfault)
           ! when iwork array on entry to *stedc is not zeroed
           ! (or at least some iwork entries which used in *laed7 for givptr).
           givptr = 0
           ! quick return if possible
           if (n == 0) return
           n1 = cutpnt
           n2 = n - n1
           n1p1 = n1 + 1
           if (rho < zero) then
              call stdlib_dscal(n2, mone, z(n1p1), 1)
           end if
           ! normalize z so that norm(z) = 1
           t = one/sqrt(two)
           do j = 1, n
              indx(j) = j
           end do
           call stdlib_dscal(n, t, z, 1)
           rho = abs(two*rho)
           ! sort the eigenvalues into increasing order
           do i = cutpnt + 1, n
              indxq(i) = indxq(i) + cutpnt
           end do
           do i = 1, n
              dlamda(i) = d(indxq(i))
              w(i) = z(indxq(i))
           end do
           i = 1
           j = cutpnt + 1
           call stdlib_dlamrg(n1, n2, dlamda, 1, 1, indx)
           do i = 1, n
              d(i) = dlamda(indx(i))
              z(i) = w(indx(i))
           end do
           ! calculate the allowable deflation tolerance
           imax = stdlib_idamax(n, z, 1)
           jmax = stdlib_idamax(n, d, 1)
           eps = stdlib_dlamch('epsilon')
           tol = eight*eps*abs(d(jmax))
           ! if the rank-1 modifier is small enough, no more needs to be done
           ! -- except to reorganize q so that its columns correspond with the
           ! elements in d.
           if (rho*abs(z(imax)) <= tol) then
              k = 0
              do j = 1, n
                 perm(j) = indxq(indx(j))
                 call stdlib_zcopy(qsiz, q(1, perm(j)), 1, q2(1, j), 1)
              end do
              call stdlib_zlacpy('a', qsiz, n, q2(1, 1), ldq2, q(1, 1), ldq)
              return
           end if
           ! if there are multiple eigenvalues then the problem deflates.  here
           ! the number of equal eigenvalues are found.  as each equal
           ! eigenvalue is found, an elementary reflector is computed to rotate
           ! the corresponding eigensubspace so that the corresponding
           ! components of z are zero in this new basis.
           k = 0
           k2 = n + 1
           do j = 1, n
              if (rho*abs(z(j)) <= tol) then
                 ! deflate due to small z component.
                 k2 = k2 - 1
                 indxp(k2) = j
                 if (j == n) go to 100
              else
                 jlam = j
                 go to 70
              end if
           end do
70      continue
           j = j + 1
           if (j > n) go to 90
           if (rho*abs(z(j)) <= tol) then
              ! deflate due to small z component.
              k2 = k2 - 1
              indxp(k2) = j
           else
              ! check if eigenvalues are close enough to allow deflation.
              s = z(jlam)
              c = z(j)
              ! find sqrt(a**2+b**2) without overflow or
              ! destructive underflow.
              tau = stdlib_dlapy2(c, s)
              t = d(j) - d(jlam)
              c = c/tau
              s = -s/tau
              if (abs(t*c*s) <= tol) then
                 ! deflation is possible.
                 z(j) = tau
                 z(jlam) = zero
                 ! record the appropriate givens rotation
                 givptr = givptr + 1
                 givcol(1, givptr) = indxq(indx(jlam))
                 givcol(2, givptr) = indxq(indx(j))
                 givnum(1, givptr) = c
                 givnum(2, givptr) = s
                 call stdlib_zdrot(qsiz, q(1, indxq(indx(jlam))), 1, q(1, indxq(indx(j) &
                           )), 1, c, s)
                 t = d(jlam)*c*c + d(j)*s*s
                 d(j) = d(jlam)*s*s + d(j)*c*c
                 d(jlam) = t
                 k2 = k2 - 1
                 i = 1
80      continue
                 if (k2 + i <= n) then
                    if (d(jlam) < d(indxp(k2 + i))) then
                       indxp(k2 + i - 1) = indxp(k2 + i)
                       indxp(k2 + i) = jlam
                       i = i + 1
                       go to 80
                    else
                       indxp(k2 + i - 1) = jlam
                    end if
                 else
                    indxp(k2 + i - 1) = jlam
                 end if
                 jlam = j
              else
                 k = k + 1
                 w(k) = z(jlam)
                 dlamda(k) = d(jlam)
                 indxp(k) = jlam
                 jlam = j
              end if
           end if
           go to 70
90      continue
           ! record the last eigenvalue.
           k = k + 1
           w(k) = z(jlam)
           dlamda(k) = d(jlam)
           indxp(k) = jlam
100    continue
           ! sort the eigenvalues and corresponding eigenvectors into dlamda
           ! and q2 respectively.  the eigenvalues/vectors which were not
           ! deflated go into the first k slots of dlamda and q2 respectively,
           ! while those which were deflated go into the last n - k slots.
           do j = 1, n
              jp = indxp(j)
              dlamda(j) = d(jp)
              perm(j) = indxq(indx(jp))
              call stdlib_zcopy(qsiz, q(1, perm(j)), 1, q2(1, j), 1)
           end do
           ! the deflated eigenvalues and their corresponding vectors go back
           ! into the last n - k slots of d and q respectively.
           if (k < n) then
              call stdlib_dcopy(n - k, dlamda(k + 1), 1, d(k + 1), 1)
              call stdlib_zlacpy('a', qsiz, n - k, q2(1, k + 1), ldq2, q(1, k + 1), ldq)
           end if
           return
           ! end of stdlib_zlaed8
     end subroutine stdlib_zlaed8

     ! ZLAESY computes the eigendecomposition of a 2-by-2 symmetric matrix
     ! ( ( A, B );( B, C ) )
     ! provided the norm of the matrix of eigenvectors is larger than
     ! some threshold value.
     ! RT1 is the eigenvalue of larger absolute value, and RT2 of
     ! smaller absolute value.  If the eigenvectors are computed, then
     ! on return ( CS1, SN1 ) is the unit eigenvector for RT1, hence
     ! [  CS1     SN1   ] . [ A  B ] . [ CS1    -SN1   ] = [ RT1  0  ]
     ! [ -SN1     CS1   ]   [ B  C ]   [ SN1     CS1   ]   [  0  RT2 ]

     subroutine stdlib_zlaesy(a, b, c, rt1, rt2, evscal, cs1, sn1)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           complex(dp) :: a, b, c, cs1, evscal, rt1, rt2, sn1
       ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: thresh = 0.1d0
           
           ! .. local scalars ..
           real(dp) :: babs, evnorm, tabs, z
           complex(dp) :: s, t, tmp
           ! .. intrinsic functions ..
           intrinsic :: abs, max, sqrt
           ! .. executable statements ..
           ! special case:  the matrix is actually diagonal.
           ! to avoid divide by zero later, we treat this case separately.
           if (abs(b) == zero) then
              rt1 = a
              rt2 = c
              if (abs(rt1) < abs(rt2)) then
                 tmp = rt1
                 rt1 = rt2
                 rt2 = tmp
                 cs1 = zero
                 sn1 = one
              else
                 cs1 = one
                 sn1 = zero
              end if
           else
              ! compute the eigenvalues and eigenvectors.
              ! the characteristic equation is
                 ! lambda **2 - (a+c) lambda + (a*c - b*b)
              ! and we solve it using the quadratic formula.
              s = (a + c)*half
              t = (a - c)*half
              ! take the square root carefully to avoid over/under flow.
              babs = abs(b)
              tabs = abs(t)
              z = max(babs, tabs)
              if (z > zero) t = z*sqrt((t/z)**2 + (b/z)**2)
              ! compute the two eigenvalues.  rt1 and rt2 are exchanged
              ! if necessary so that rt1 will have the greater magnitude.
              rt1 = s + t
              rt2 = s - t
              if (abs(rt1) < abs(rt2)) then
                 tmp = rt1
                 rt1 = rt2
                 rt2 = tmp
              end if
              ! choose cs1 = 1 and sn1 to satisfy the first equation, then
              ! scale the components of this eigenvector so that the matrix
              ! of eigenvectors x satisfies  x * x**t = i .  (no scaling is
              ! done if the norm of the eigenvalue matrix is less than thresh.)
              sn1 = (rt1 - a)/b
              tabs = abs(sn1)
              if (tabs > one) then
                 t = tabs*sqrt((one/tabs)**2 + (sn1/tabs)**2)
              else
                 t = sqrt(cone + sn1*sn1)
              end if
              evnorm = abs(t)
              if (evnorm >= thresh) then
                 evscal = cone/t
                 cs1 = evscal
                 sn1 = sn1*evscal
              else
                 evscal = zero
              end if
           end if
           return
           ! end of stdlib_zlaesy
     end subroutine stdlib_zlaesy

     ! ZLAEV2 computes the eigendecomposition of a 2-by-2 Hermitian matrix
     ! [  A         B  ]
     ! [  CONJG(B)  C  ].
     ! On return, RT1 is the eigenvalue of larger absolute value, RT2 is the
     ! eigenvalue of smaller absolute value, and (CS1,SN1) is the unit right
     ! eigenvector for RT1, giving the decomposition
     ! [ CS1  CONJG(SN1) ] [    A     B ] [ CS1 -CONJG(SN1) ] = [ RT1  0  ]
     ! [-SN1     CS1     ] [ CONJG(B) C ] [ SN1     CS1     ]   [  0  RT2 ].

     subroutine stdlib_zlaev2(a, b, c, rt1, rt2, cs1, sn1)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           real(dp) :: cs1, rt1, rt2
           complex(dp) :: a, b, c, sn1
       ! =====================================================================
           
           ! .. local scalars ..
           real(dp) :: t
           complex(dp) :: w
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, conjg
           ! .. executable statements ..
           if (abs(b) == zero) then
              w = one
           else
              w = conjg(b)/abs(b)
           end if
           call stdlib_dlaev2(real(a, KIND=dp), abs(b), real(c, KIND=dp), rt1, rt2, cs1, t)
                     
           sn1 = w*t
           return
           ! end of stdlib_zlaev2
     end subroutine stdlib_zlaev2

     ! ZLAG2C converts a COMPLEX*16 matrix, SA, to a COMPLEX matrix, A.
     ! RMAX is the overflow for the SINGLE PRECISION arithmetic
     ! ZLAG2C checks that all the entries of A are between -RMAX and
     ! RMAX. If not the conversion is aborted and a flag is raised.
     ! This is an auxiliary routine so there is no argument checking.

     subroutine stdlib_zlag2c(m, n, a, lda, sa, ldsa, info)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: info, lda, ldsa, m, n
           ! .. array arguments ..
           complex(sp) :: sa(ldsa, *)
           complex(dp) :: a(lda, *)
        ! =====================================================================
           ! .. local scalars ..
           integer(ilp) :: i, j
           real(dp) :: rmax
           ! .. intrinsic functions ..
           intrinsic :: dble, aimag
     
           ! .. executable statements ..
           rmax = stdlib_slamch('o')
           do j = 1, n
              do i = 1, m
                 if ((real(a(i, j), KIND=dp) < -rmax) .or. (real(a(i, j), KIND=dp) > rmax) &
                           .or. (aimag(a(i, j)) < -rmax) .or. (aimag(a(i, j)) > rmax)) then
                    info = 1
                    go to 30
                 end if
                 sa(i, j) = a(i, j)
              end do
           end do
           info = 0
30      continue
           return
           ! end of stdlib_zlag2c
     end subroutine stdlib_zlag2c

     ! ZLAGTM performs a matrix-vector product of the form
     ! B := alpha * A * X + beta * B
     ! where A is a tridiagonal matrix of order N, B and X are N by NRHS
     ! matrices, and alpha and beta are real scalars, each of which may be
     ! 0., 1., or -1.

     subroutine stdlib_zlagtm(trans, n, nrhs, alpha, dl, d, du, x, ldx, beta, b, ldb)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: trans
           integer(ilp) :: ldb, ldx, n, nrhs
           real(dp) :: alpha, beta
           ! .. array arguments ..
           complex(dp) :: b(ldb, *), d(*), dl(*), du(*), x(ldx, *)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i, j
     
           ! .. intrinsic functions ..
           intrinsic :: conjg
           ! .. executable statements ..
           if (n == 0) return
           ! multiply b by beta if beta/=1.
           if (beta == zero) then
              do j = 1, nrhs
                 do i = 1, n
                    b(i, j) = zero
                 end do
              end do
           else if (beta == -one) then
              do j = 1, nrhs
                 do i = 1, n
                    b(i, j) = -b(i, j)
                 end do
              end do
           end if
           if (alpha == one) then
              if (stdlib_lsame(trans, 'n')) then
                 ! compute b := b + a*x
                 do j = 1, nrhs
                    if (n == 1) then
                       b(1, j) = b(1, j) + d(1)*x(1, j)
                    else
                       b(1, j) = b(1, j) + d(1)*x(1, j) + du(1)*x(2, j)
                       b(n, j) = b(n, j) + dl(n - 1)*x(n - 1, j) + d(n)*x(n, j)
                       do i = 2, n - 1
                          b(i, j) = b(i, j) + dl(i - 1)*x(i - 1, j) + d(i)*x(i, j) + du(i &
                                    )*x(i + 1, j)
                       end do
                    end if
                 end do
              else if (stdlib_lsame(trans, 't')) then
                 ! compute b := b + a**t * x
                 do j = 1, nrhs
                    if (n == 1) then
                       b(1, j) = b(1, j) + d(1)*x(1, j)
                    else
                       b(1, j) = b(1, j) + d(1)*x(1, j) + dl(1)*x(2, j)
                       b(n, j) = b(n, j) + du(n - 1)*x(n - 1, j) + d(n)*x(n, j)
                       do i = 2, n - 1
                          b(i, j) = b(i, j) + du(i - 1)*x(i - 1, j) + d(i)*x(i, j) + dl(i &
                                    )*x(i + 1, j)
                       end do
                    end if
                 end do
              else if (stdlib_lsame(trans, 'c')) then
                 ! compute b := b + a**h * x
                 do j = 1, nrhs
                    if (n == 1) then
                       b(1, j) = b(1, j) + conjg(d(1))*x(1, j)
                    else
                       b(1, j) = b(1, j) + conjg(d(1))*x(1, j) + conjg(dl(1))*x(2, &
                                 j)
                       b(n, j) = b(n, j) + conjg(du(n - 1))*x(n - 1, j) + conjg(d(n))*x( &
                                  n, j)
                       do i = 2, n - 1
                          b(i, j) = b(i, j) + conjg(du(i - 1))*x(i - 1, j) + conjg(d(i)) &
                                    *x(i, j) + conjg(dl(i))*x(i + 1, j)
                       end do
                    end if
                 end do
              end if
           else if (alpha == -one) then
              if (stdlib_lsame(trans, 'n')) then
                 ! compute b := b - a*x
                 do j = 1, nrhs
                    if (n == 1) then
                       b(1, j) = b(1, j) - d(1)*x(1, j)
                    else
                       b(1, j) = b(1, j) - d(1)*x(1, j) - du(1)*x(2, j)
                       b(n, j) = b(n, j) - dl(n - 1)*x(n - 1, j) - d(n)*x(n, j)
                       do i = 2, n - 1
                          b(i, j) = b(i, j) - dl(i - 1)*x(i - 1, j) - d(i)*x(i, j) - du(i &
                                    )*x(i + 1, j)
                       end do
                    end if
                 end do
              else if (stdlib_lsame(trans, 't')) then
                 ! compute b := b - a**t *x
                 do j = 1, nrhs
                    if (n == 1) then
                       b(1, j) = b(1, j) - d(1)*x(1, j)
                    else
                       b(1, j) = b(1, j) - d(1)*x(1, j) - dl(1)*x(2, j)
                       b(n, j) = b(n, j) - du(n - 1)*x(n - 1, j) - d(n)*x(n, j)
                       do i = 2, n - 1
                          b(i, j) = b(i, j) - du(i - 1)*x(i - 1, j) - d(i)*x(i, j) - dl(i &
                                    )*x(i + 1, j)
                       end do
                    end if
                 end do
              else if (stdlib_lsame(trans, 'c')) then
                 ! compute b := b - a**h *x
                 do j = 1, nrhs
                    if (n == 1) then
                       b(1, j) = b(1, j) - conjg(d(1))*x(1, j)
                    else
                       b(1, j) = b(1, j) - conjg(d(1))*x(1, j) - conjg(dl(1))*x(2, &
                                 j)
                       b(n, j) = b(n, j) - conjg(du(n - 1))*x(n - 1, j) - conjg(d(n))*x( &
                                  n, j)
                       do i = 2, n - 1
                          b(i, j) = b(i, j) - conjg(du(i - 1))*x(i - 1, j) - conjg(d(i)) &
                                    *x(i, j) - conjg(dl(i))*x(i + 1, j)
                       end do
                    end if
                 end do
              end if
           end if
           return
           ! end of stdlib_zlagtm
     end subroutine stdlib_zlagtm

     ! ZLAHEF computes a partial factorization of a complex Hermitian
     ! matrix A using the Bunch-Kaufman diagonal pivoting method. The
     ! partial factorization has the form:
     ! A  =  ( I  U12 ) ( A11  0  ) (  I      0     )  if UPLO = 'U', or:
     ! ( 0  U22 ) (  0   D  ) ( U12**H U22**H )
     ! A  =  ( L11  0 ) (  D   0  ) ( L11**H L21**H )  if UPLO = 'L'
     ! ( L21  I ) (  0  A22 ) (  0      I     )
     ! where the order of D is at most NB. The actual order is returned in
     ! the argument KB, and is either NB or NB-1, or N if N <= NB.
     ! Note that U**H denotes the conjugate transpose of U.
     ! ZLAHEF is an auxiliary routine called by ZHETRF. It uses blocked code
     ! (calling Level 3 BLAS) to update the submatrix A11 (if UPLO = 'U') or
     ! A22 (if UPLO = 'L').

     subroutine stdlib_zlahef(uplo, n, nb, kb, a, lda, ipiv, w, ldw, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, kb, lda, ldw, n, nb
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *), w(ldw, *)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: sevten = 17.0_dp
           
           ! .. local scalars ..
           integer(ilp) :: imax, j, jb, jj, jmax, jp, k, kk, kkw, kp, kstep, kw
           real(dp) :: absakk, alpha, colmax, r1, rowmax, t
           complex(dp) :: d11, d21, d22, z
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, conjg, aimag, max, min, sqrt
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(z) = abs(real(z, KIND=dp)) + abs(aimag(z))
           ! .. executable statements ..
           info = 0
           ! initialize alpha for use in choosing pivot block size.
           alpha = (one + sqrt(sevten))/eight
           if (stdlib_lsame(uplo, 'u')) then
              ! factorize the trailing columns of a using the upper triangle
              ! of a and working backwards, and compute the matrix w = u12*d
              ! for use in updating a11 (note that conjg(w) is actually stored)
              ! k is the main loop index, decreasing from n in steps of 1 or 2
              ! kw is the column of w which corresponds to column k of a
              k = n
10      continue
              kw = nb + k - n
              ! exit from loop
              if ((k <= n - nb + 1 .and. nb < n) .or. k < 1) go to 30
              kstep = 1
              ! copy column k of a to column kw of w and update it
              call stdlib_zcopy(k - 1, a(1, k), 1, w(1, kw), 1)
              w(k, kw) = real(a(k, k), KIND=dp)
              if (k < n) then
                 call stdlib_zgemv('no transpose', k, n - k, -cone, a(1, k + 1), lda, w(k, kw + 1), &
                           ldw, cone, w(1, kw), 1)
                 w(k, kw) = real(w(k, kw), KIND=dp)
              end if
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = abs(real(w(k, kw), KIND=dp))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k > 1) then
                 imax = stdlib_izamax(k - 1, w(1, kw), 1)
                 colmax = cabs1(w(imax, kw))
              else
                 colmax = zero
              end if
              if (max(absakk, colmax) == zero) then
                 ! column k is zero or underflow: set info and continue
                 if (info == 0) info = k
                 kp = k
                 a(k, k) = real(a(k, k), KIND=dp)
              else
                 ! ============================================================
                 ! begin pivot search
                 ! case(1)
                 if (absakk >= alpha*colmax) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    ! begin pivot search along imax row
                    ! copy column imax to column kw-1 of w and update it
                    call stdlib_zcopy(imax - 1, a(1, imax), 1, w(1, kw - 1), 1)
                    w(imax, kw - 1) = real(a(imax, imax), KIND=dp)
                    call stdlib_zcopy(k - imax, a(imax, imax + 1), lda, w(imax + 1, kw - 1), 1)
                              
                    call stdlib_zlacgv(k - imax, w(imax + 1, kw - 1), 1)
                    if (k < n) then
                       call stdlib_zgemv('no transpose', k, n - k, -cone, a(1, k + 1), lda, w(imax, &
                                  kw + 1), ldw, cone, w(1, kw - 1), 1)
                       w(imax, kw - 1) = real(w(imax, kw - 1), KIND=dp)
                    end if
                    ! jmax is the column-index of the largest off-diagonal
                    ! element in row imax, and rowmax is its absolute value.
                    ! determine only rowmax.
                    jmax = imax + stdlib_izamax(k - imax, w(imax + 1, kw - 1), 1)
                    rowmax = cabs1(w(jmax, kw - 1))
                    if (imax > 1) then
                       jmax = stdlib_izamax(imax - 1, w(1, kw - 1), 1)
                       rowmax = max(rowmax, cabs1(w(jmax, kw - 1)))
                    end if
                    ! case(2)
                    if (absakk >= alpha*colmax*(colmax/rowmax)) then
                       ! no interchange, use 1-by-1 pivot block
                       kp = k
                    ! case(3)
                    else if (abs(real(w(imax, kw - 1), KIND=dp)) >= alpha*rowmax) then
                       ! interchange rows and columns k and imax, use 1-by-1
                       ! pivot block
                       kp = imax
                       ! copy column kw-1 of w to column kw of w
                       call stdlib_zcopy(k, w(1, kw - 1), 1, w(1, kw), 1)
                    ! case(4)
                    else
                       ! interchange rows and columns k-1 and imax, use 2-by-2
                       ! pivot block
                       kp = imax
                       kstep = 2
                    end if
                    ! end pivot search along imax row
                 end if
                 ! end pivot search
                 ! ============================================================
                 ! kk is the column of a where pivoting step stopped
                 kk = k - kstep + 1
                 ! kkw is the column of w which corresponds to column kk of a
                 kkw = nb + kk - n
                 ! interchange rows and columns kp and kk.
                 ! updated column kp is already stored in column kkw of w.
                 if (kp /= kk) then
                    ! copy non-updated column kk to column kp of submatrix a
                    ! at step k. no need to copy element into column k
                    ! (or k and k-1 for 2-by-2 pivot) of a, since these columns
                    ! will be later overwritten.
                    a(kp, kp) = real(a(kk, kk), KIND=dp)
                    call stdlib_zcopy(kk - 1 - kp, a(kp + 1, kk), 1, a(kp, kp + 1), lda)
                    call stdlib_zlacgv(kk - 1 - kp, a(kp, kp + 1), lda)
                    if (kp > 1) call stdlib_zcopy(kp - 1, a(1, kk), 1, a(1, kp), 1)
                    ! interchange rows kk and kp in last k+1 to n columns of a
                    ! (columns k (or k and k-1 for 2-by-2 pivot) of a will be
                    ! later overwritten). interchange rows kk and kp
                    ! in last kkw to nb columns of w.
                    if (k < n) call stdlib_zswap(n - k, a(kk, k + 1), lda, a(kp, k + 1), lda)
                    call stdlib_zswap(n - kk + 1, w(kk, kkw), ldw, w(kp, kkw), ldw)
                 end if
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column kw of w now holds
                    ! w(kw) = u(k)*d(k),
                    ! where u(k) is the k-th column of u
                    ! (1) store subdiag. elements of column u(k)
                    ! and 1-by-1 block d(k) in column k of a.
                    ! (note: diagonal element u(k,k) is a unit element
                    ! and not stored)
                       ! a(k,k) := d(k,k) = w(k,kw)
                       ! a(1:k-1,k) := u(1:k-1,k) = w(1:k-1,kw)/d(k,k)
                    ! (note: no need to use for hermitian matrix
                    ! a( k, k ) = real( w( k, k) ,KIND=dp) to separately copy diagonal
                    ! element d(k,k) from w (potentially saves only one load))
                    call stdlib_zcopy(k, w(1, kw), 1, a(1, k), 1)
                    if (k > 1) then
                       ! (note: no need to check if a(k,k) is not zero,
                        ! since that was ensured earlier in pivot search:
                        ! case a(k,k) = 0 falls into 2x2 pivot case(4))
                       r1 = one/real(a(k, k), KIND=dp)
                       call stdlib_zdscal(k - 1, r1, a(1, k), 1)
                       ! (2) conjugate column w(kw)
                       call stdlib_zlacgv(k - 1, w(1, kw), 1)
                    end if
                 else
                    ! 2-by-2 pivot block d(k): columns kw and kw-1 of w now hold
                    ! ( w(kw-1) w(kw) ) = ( u(k-1) u(k) )*d(k)
                    ! where u(k) and u(k-1) are the k-th and (k-1)-th columns
                    ! of u
                    ! (1) store u(1:k-2,k-1) and u(1:k-2,k) and 2-by-2
                    ! block d(k-1:k,k-1:k) in columns k-1 and k of a.
                    ! (note: 2-by-2 diagonal block u(k-1:k,k-1:k) is a unit
                    ! block and not stored)
                       ! a(k-1:k,k-1:k) := d(k-1:k,k-1:k) = w(k-1:k,kw-1:kw)
                       ! a(1:k-2,k-1:k) := u(1:k-2,k:k-1:k) =
                       ! = w(1:k-2,kw-1:kw) * ( d(k-1:k,k-1:k)**(-1) )
                    if (k > 2) then
                       ! factor out the columns of the inverse of 2-by-2 pivot
                       ! block d, so that each column contains 1, to reduce the
                       ! number of flops when we multiply panel
                       ! ( w(kw-1) w(kw) ) by this inverse, i.e. by d**(-1).
                       ! d**(-1) = ( d11 cj(d21) )**(-1) =
                                 ! ( d21    d22 )
                       ! = 1/(d11*d22-|d21|**2) * ( ( d22) (-cj(d21) ) ) =
                                                ! ( (-d21) (     d11 ) )
                       ! = 1/(|d21|**2) * 1/((d11/cj(d21))*(d22/d21)-1) *
                         ! * ( d21*( d22/d21 ) conj(d21)*(           - 1 ) ) =
                           ! (     (      -1 )           ( d11/conj(d21) ) )
                       ! = 1/(|d21|**2) * 1/(d22*d11-1) *
                         ! * ( d21*( d11 ) conj(d21)*(  -1 ) ) =
                           ! (     (  -1 )           ( d22 ) )
                       ! = (1/|d21|**2) * t * ( d21*( d11 ) conj(d21)*(  -1 ) ) =
                                            ! (     (  -1 )           ( d22 ) )
                       ! = ( (t/conj(d21))*( d11 ) (t/d21)*(  -1 ) ) =
                         ! (               (  -1 )         ( d22 ) )
                       ! = ( conj(d21)*( d11 ) d21*(  -1 ) )
                         ! (           (  -1 )     ( d22 ) ),
                       ! where d11 = d22/d21,
                             ! d22 = d11/conj(d21),
                             ! d21 = t/d21,
                             ! t = 1/(d22*d11-1).
                       ! (note: no need to check for division by zero,
                        ! since that was ensured earlier in pivot search:
                        ! (a) d21 != 0, since in 2x2 pivot case(4)
                            ! |d21| should be larger than |d11| and |d22|;
                        ! (b) (d22*d11 - 1) != 0, since from (a),
                            ! both |d11| < 1, |d22| < 1, hence |d22*d11| << 1.)
                       d21 = w(k - 1, kw)
                       d11 = w(k, kw)/conjg(d21)
                       d22 = w(k - 1, kw - 1)/d21
                       t = one/(real(d11*d22, KIND=dp) - one)
                       d21 = t/d21
                       ! update elements in columns a(k-1) and a(k) as
                       ! dot products of rows of ( w(kw-1) w(kw) ) and columns
                       ! of d**(-1)
                       do j = 1, k - 2
                          a(j, k - 1) = d21*(d11*w(j, kw - 1) - w(j, kw))
                          a(j, k) = conjg(d21)*(d22*w(j, kw) - w(j, kw - 1))
                       end do
                    end if
                    ! copy d(k) to a
                    a(k - 1, k - 1) = w(k - 1, kw - 1)
                    a(k - 1, k) = w(k - 1, kw)
                    a(k, k) = w(k, kw)
                    ! (2) conjugate columns w(kw) and w(kw-1)
                    call stdlib_zlacgv(k - 1, w(1, kw), 1)
                    call stdlib_zlacgv(k - 2, w(1, kw - 1), 1)
                 end if
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -kp
                 ipiv(k - 1) = -kp
              end if
              ! decrease k and return to the start of the main loop
              k = k - kstep
              go to 10
30      continue
              ! update the upper triangle of a11 (= a(1:k,1:k)) as
              ! a11 := a11 - u12*d*u12**h = a11 - u12*w**h
              ! computing blocks of nb columns at a time (note that conjg(w) is
              ! actually stored)
              do j = ((k - 1)/nb)*nb + 1, 1, -nb
                 jb = min(nb, k - j + 1)
                 ! update the upper triangle of the diagonal block
                 do jj = j, j + jb - 1
                    a(jj, jj) = real(a(jj, jj), KIND=dp)
                    call stdlib_zgemv('no transpose', jj - j + 1, n - k, -cone, a(j, k + 1), lda, w(jj, &
                               kw + 1), ldw, cone, a(j, jj), 1)
                    a(jj, jj) = real(a(jj, jj), KIND=dp)
                 end do
                 ! update the rectangular superdiagonal block
                 call stdlib_zgemm('no transpose', 'transpose', j - 1, jb, n - k, -cone, a(1, k + 1), &
                           lda, w(j, kw + 1), ldw, cone, a(1, j), lda)
              end do
              ! put u12 in standard form by partially undoing the interchanges
              ! in columns k+1:n looping backwards from k+1 to n
              j = k + 1
60      continue
                 ! undo the interchanges (if any) of rows jj and jp at each
                 ! step j
                 ! (here, j is a diagonal index)
                 jj = j
                 jp = ipiv(j)
                 if (jp < 0) then
                    jp = -jp
                    ! (here, j is a diagonal index)
                    j = j + 1
                 end if
                 ! (note: here, j is used to determine row length. length n-j+1
                 ! of the rows to swap back doesn't include diagonal element)
                 j = j + 1
                 if (jp /= jj .and. j <= n) call stdlib_zswap(n - j + 1, a(jp, j), lda, a(jj, j), &
                           lda)
              if (j < n) go to 60
              ! set kb to the number of columns factorized
              kb = n - k
           else
              ! factorize the leading columns of a using the lower triangle
              ! of a and working forwards, and compute the matrix w = l21*d
              ! for use in updating a22 (note that conjg(w) is actually stored)
              ! k is the main loop index, increasing from 1 in steps of 1 or 2
              k = 1
70      continue
              ! exit from loop
              if ((k >= nb .and. nb < n) .or. k > n) go to 90
              kstep = 1
              ! copy column k of a to column k of w and update it
              w(k, k) = real(a(k, k), KIND=dp)
              if (k < n) call stdlib_zcopy(n - k, a(k + 1, k), 1, w(k + 1, k), 1)
              call stdlib_zgemv('no transpose', n - k + 1, k - 1, -cone, a(k, 1), lda, w(k, 1), ldw, &
                         cone, w(k, k), 1)
              w(k, k) = real(w(k, k), KIND=dp)
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = abs(real(w(k, k), KIND=dp))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k < n) then
                 imax = k + stdlib_izamax(n - k, w(k + 1, k), 1)
                 colmax = cabs1(w(imax, k))
              else
                 colmax = zero
              end if
              if (max(absakk, colmax) == zero) then
                 ! column k is zero or underflow: set info and continue
                 if (info == 0) info = k
                 kp = k
                 a(k, k) = real(a(k, k), KIND=dp)
              else
                 ! ============================================================
                 ! begin pivot search
                 ! case(1)
                 if (absakk >= alpha*colmax) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    ! begin pivot search along imax row
                    ! copy column imax to column k+1 of w and update it
                    call stdlib_zcopy(imax - k, a(imax, k), lda, w(k, k + 1), 1)
                    call stdlib_zlacgv(imax - k, w(k, k + 1), 1)
                    w(imax, k + 1) = real(a(imax, imax), KIND=dp)
                    if (imax < n) call stdlib_zcopy(n - imax, a(imax + 1, imax), 1, w(imax + 1, k + 1), &
                              1)
                    call stdlib_zgemv('no transpose', n - k + 1, k - 1, -cone, a(k, 1), lda, w(imax, &
                              1), ldw, cone, w(k, k + 1), 1)
                    w(imax, k + 1) = real(w(imax, k + 1), KIND=dp)
                    ! jmax is the column-index of the largest off-diagonal
                    ! element in row imax, and rowmax is its absolute value.
                    ! determine only rowmax.
                    jmax = k - 1 + stdlib_izamax(imax - k, w(k, k + 1), 1)
                    rowmax = cabs1(w(jmax, k + 1))
                    if (imax < n) then
                       jmax = imax + stdlib_izamax(n - imax, w(imax + 1, k + 1), 1)
                       rowmax = max(rowmax, cabs1(w(jmax, k + 1)))
                    end if
                    ! case(2)
                    if (absakk >= alpha*colmax*(colmax/rowmax)) then
                       ! no interchange, use 1-by-1 pivot block
                       kp = k
                    ! case(3)
                    else if (abs(real(w(imax, k + 1), KIND=dp)) >= alpha*rowmax) then
                       ! interchange rows and columns k and imax, use 1-by-1
                       ! pivot block
                       kp = imax
                       ! copy column k+1 of w to column k of w
                       call stdlib_zcopy(n - k + 1, w(k, k + 1), 1, w(k, k), 1)
                    ! case(4)
                    else
                       ! interchange rows and columns k+1 and imax, use 2-by-2
                       ! pivot block
                       kp = imax
                       kstep = 2
                    end if
                    ! end pivot search along imax row
                 end if
                 ! end pivot search
                 ! ============================================================
                 ! kk is the column of a where pivoting step stopped
                 kk = k + kstep - 1
                 ! interchange rows and columns kp and kk.
                 ! updated column kp is already stored in column kk of w.
                 if (kp /= kk) then
                    ! copy non-updated column kk to column kp of submatrix a
                    ! at step k. no need to copy element into column k
                    ! (or k and k+1 for 2-by-2 pivot) of a, since these columns
                    ! will be later overwritten.
                    a(kp, kp) = real(a(kk, kk), KIND=dp)
                    call stdlib_zcopy(kp - kk - 1, a(kk + 1, kk), 1, a(kp, kk + 1), lda)
                    call stdlib_zlacgv(kp - kk - 1, a(kp, kk + 1), lda)
                    if (kp < n) call stdlib_zcopy(n - kp, a(kp + 1, kk), 1, a(kp + 1, kp), 1)
                              
                    ! interchange rows kk and kp in first k-1 columns of a
                    ! (columns k (or k and k+1 for 2-by-2 pivot) of a will be
                    ! later overwritten). interchange rows kk and kp
                    ! in first kk columns of w.
                    if (k > 1) call stdlib_zswap(k - 1, a(kk, 1), lda, a(kp, 1), lda)
                    call stdlib_zswap(kk, w(kk, 1), ldw, w(kp, 1), ldw)
                 end if
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k of w now holds
                    ! w(k) = l(k)*d(k),
                    ! where l(k) is the k-th column of l
                    ! (1) store subdiag. elements of column l(k)
                    ! and 1-by-1 block d(k) in column k of a.
                    ! (note: diagonal element l(k,k) is a unit element
                    ! and not stored)
                       ! a(k,k) := d(k,k) = w(k,k)
                       ! a(k+1:n,k) := l(k+1:n,k) = w(k+1:n,k)/d(k,k)
                    ! (note: no need to use for hermitian matrix
                    ! a( k, k ) = real( w( k, k) ,KIND=dp) to separately copy diagonal
                    ! element d(k,k) from w (potentially saves only one load))
                    call stdlib_zcopy(n - k + 1, w(k, k), 1, a(k, k), 1)
                    if (k < n) then
                       ! (note: no need to check if a(k,k) is not zero,
                        ! since that was ensured earlier in pivot search:
                        ! case a(k,k) = 0 falls into 2x2 pivot case(4))
                       r1 = one/real(a(k, k), KIND=dp)
                       call stdlib_zdscal(n - k, r1, a(k + 1, k), 1)
                       ! (2) conjugate column w(k)
                       call stdlib_zlacgv(n - k, w(k + 1, k), 1)
                    end if
                 else
                    ! 2-by-2 pivot block d(k): columns k and k+1 of w now hold
                    ! ( w(k) w(k+1) ) = ( l(k) l(k+1) )*d(k)
                    ! where l(k) and l(k+1) are the k-th and (k+1)-th columns
                    ! of l
                    ! (1) store l(k+2:n,k) and l(k+2:n,k+1) and 2-by-2
                    ! block d(k:k+1,k:k+1) in columns k and k+1 of a.
                    ! (note: 2-by-2 diagonal block l(k:k+1,k:k+1) is a unit
                    ! block and not stored)
                       ! a(k:k+1,k:k+1) := d(k:k+1,k:k+1) = w(k:k+1,k:k+1)
                       ! a(k+2:n,k:k+1) := l(k+2:n,k:k+1) =
                       ! = w(k+2:n,k:k+1) * ( d(k:k+1,k:k+1)**(-1) )
                    if (k < n - 1) then
                       ! factor out the columns of the inverse of 2-by-2 pivot
                       ! block d, so that each column contains 1, to reduce the
                       ! number of flops when we multiply panel
                       ! ( w(kw-1) w(kw) ) by this inverse, i.e. by d**(-1).
                       ! d**(-1) = ( d11 cj(d21) )**(-1) =
                                 ! ( d21    d22 )
                       ! = 1/(d11*d22-|d21|**2) * ( ( d22) (-cj(d21) ) ) =
                                                ! ( (-d21) (     d11 ) )
                       ! = 1/(|d21|**2) * 1/((d11/cj(d21))*(d22/d21)-1) *
                         ! * ( d21*( d22/d21 ) conj(d21)*(           - 1 ) ) =
                           ! (     (      -1 )           ( d11/conj(d21) ) )
                       ! = 1/(|d21|**2) * 1/(d22*d11-1) *
                         ! * ( d21*( d11 ) conj(d21)*(  -1 ) ) =
                           ! (     (  -1 )           ( d22 ) )
                       ! = (1/|d21|**2) * t * ( d21*( d11 ) conj(d21)*(  -1 ) ) =
                                            ! (     (  -1 )           ( d22 ) )
                       ! = ( (t/conj(d21))*( d11 ) (t/d21)*(  -1 ) ) =
                         ! (               (  -1 )         ( d22 ) )
                       ! = ( conj(d21)*( d11 ) d21*(  -1 ) )
                         ! (           (  -1 )     ( d22 ) ),
                       ! where d11 = d22/d21,
                             ! d22 = d11/conj(d21),
                             ! d21 = t/d21,
                             ! t = 1/(d22*d11-1).
                       ! (note: no need to check for division by zero,
                        ! since that was ensured earlier in pivot search:
                        ! (a) d21 != 0, since in 2x2 pivot case(4)
                            ! |d21| should be larger than |d11| and |d22|;
                        ! (b) (d22*d11 - 1) != 0, since from (a),
                            ! both |d11| < 1, |d22| < 1, hence |d22*d11| << 1.)
                       d21 = w(k + 1, k)
                       d11 = w(k + 1, k + 1)/d21
                       d22 = w(k, k)/conjg(d21)
                       t = one/(real(d11*d22, KIND=dp) - one)
                       d21 = t/d21
                       ! update elements in columns a(k) and a(k+1) as
                       ! dot products of rows of ( w(k) w(k+1) ) and columns
                       ! of d**(-1)
                       do j = k + 2, n
                          a(j, k) = conjg(d21)*(d11*w(j, k) - w(j, k + 1))
                          a(j, k + 1) = d21*(d22*w(j, k + 1) - w(j, k))
                       end do
                    end if
                    ! copy d(k) to a
                    a(k, k) = w(k, k)
                    a(k + 1, k) = w(k + 1, k)
                    a(k + 1, k + 1) = w(k + 1, k + 1)
                    ! (2) conjugate columns w(k) and w(k+1)
                    call stdlib_zlacgv(n - k, w(k + 1, k), 1)
                    call stdlib_zlacgv(n - k - 1, w(k + 2, k + 1), 1)
                 end if
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -kp
                 ipiv(k + 1) = -kp
              end if
              ! increase k and return to the start of the main loop
              k = k + kstep
              go to 70
90      continue
              ! update the lower triangle of a22 (= a(k:n,k:n)) as
              ! a22 := a22 - l21*d*l21**h = a22 - l21*w**h
              ! computing blocks of nb columns at a time (note that conjg(w) is
              ! actually stored)
              do j = k, n, nb
                 jb = min(nb, n - j + 1)
                 ! update the lower triangle of the diagonal block
                 do jj = j, j + jb - 1
                    a(jj, jj) = real(a(jj, jj), KIND=dp)
                    call stdlib_zgemv('no transpose', j + jb - jj, k - 1, -cone, a(jj, 1), lda, w(jj, &
                               1), ldw, cone, a(jj, jj), 1)
                    a(jj, jj) = real(a(jj, jj), KIND=dp)
                 end do
                 ! update the rectangular subdiagonal block
                 if (j + jb <= n) call stdlib_zgemm('no transpose', 'transpose', n - j - jb + 1, jb, k - 1, - &
                           cone, a(j + jb, 1), lda, w(j, 1), ldw, cone, a(j + jb, j), lda)
              end do
              ! put l21 in standard form by partially undoing the interchanges
              ! of rows in columns 1:k-1 looping backwards from k-1 to 1
              j = k - 1
120    continue
                 ! undo the interchanges (if any) of rows jj and jp at each
                 ! step j
                 ! (here, j is a diagonal index)
                 jj = j
                 jp = ipiv(j)
                 if (jp < 0) then
                    jp = -jp
                    ! (here, j is a diagonal index)
                    j = j - 1
                 end if
                 ! (note: here, j is used to determine row length. length j
                 ! of the rows to swap back doesn't include diagonal element)
                 j = j - 1
                 if (jp /= jj .and. j >= 1) call stdlib_zswap(j, a(jp, 1), lda, a(jj, 1), lda)
                           
              if (j > 1) go to 120
              ! set kb to the number of columns factorized
              kb = k - 1
           end if
           return
           ! end of stdlib_zlahef
     end subroutine stdlib_zlahef

     ! ZLAHEF_RK computes a partial factorization of a complex Hermitian
     ! matrix A using the bounded Bunch-Kaufman (rook) diagonal
     ! pivoting method. The partial factorization has the form:
     ! A  =  ( I  U12 ) ( A11  0  ) (  I       0    )  if UPLO = 'U', or:
     ! ( 0  U22 ) (  0   D  ) ( U12**H U22**H )
     ! A  =  ( L11  0 ) (  D   0  ) ( L11**H L21**H )  if UPLO = 'L',
     ! ( L21  I ) (  0  A22 ) (  0       I    )
     ! where the order of D is at most NB. The actual order is returned in
     ! the argument KB, and is either NB or NB-1, or N if N <= NB.
     ! ZLAHEF_RK is an auxiliary routine called by ZHETRF_RK. It uses
     ! blocked code (calling Level 3 BLAS) to update the submatrix
     ! A11 (if UPLO = 'U') or A22 (if UPLO = 'L').

     subroutine stdlib_zlahef_rk(uplo, n, nb, kb, a, lda, e, ipiv, w, ldw, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, kb, lda, ldw, n, nb
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *), w(ldw, *), e(*)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: sevten = 17.0_dp
           
           ! .. local scalars ..
           logical(lk) :: done
           integer(ilp) :: imax, itemp, ii, j, jb, jj, jmax, k, kk, kkw, kp, kstep, kw, p
           real(dp) :: absakk, alpha, colmax, dtemp, r1, rowmax, t, sfmin
           complex(dp) :: d11, d21, d22, z
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, conjg, aimag, max, min, sqrt
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(z) = abs(real(z, KIND=dp)) + abs(aimag(z))
           ! .. executable statements ..
           info = 0
           ! initialize alpha for use in choosing pivot block size.
           alpha = (one + sqrt(sevten))/eight
           ! compute machine safe minimum
           sfmin = stdlib_dlamch('s')
           if (stdlib_lsame(uplo, 'u')) then
              ! factorize the trailing columns of a using the upper triangle
              ! of a and working backwards, and compute the matrix w = u12*d
              ! for use in updating a11 (note that conjg(w) is actually stored)
              ! initialize the first entry of array e, where superdiagonal
              ! elements of d are stored
              e(1) = czero
              ! k is the main loop index, decreasing from n in steps of 1 or 2
              k = n
10      continue
              ! kw is the column of w which corresponds to column k of a
              kw = nb + k - n
              ! exit from loop
              if ((k <= n - nb + 1 .and. nb < n) .or. k < 1) go to 30
              kstep = 1
              p = k
              ! copy column k of a to column kw of w and update it
              if (k > 1) call stdlib_zcopy(k - 1, a(1, k), 1, w(1, kw), 1)
              w(k, kw) = real(a(k, k), KIND=dp)
              if (k < n) then
                 call stdlib_zgemv('no transpose', k, n - k, -cone, a(1, k + 1), lda, w(k, kw + 1), &
                           ldw, cone, w(1, kw), 1)
                 w(k, kw) = real(w(k, kw), KIND=dp)
              end if
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = abs(real(w(k, kw), KIND=dp))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k > 1) then
                 imax = stdlib_izamax(k - 1, w(1, kw), 1)
                 colmax = cabs1(w(imax, kw))
              else
                 colmax = zero
              end if
              if (max(absakk, colmax) == zero) then
                 ! column k is zero or underflow: set info and continue
                 if (info == 0) info = k
                 kp = k
                 a(k, k) = real(w(k, kw), KIND=dp)
                 if (k > 1) call stdlib_zcopy(k - 1, w(1, kw), 1, a(1, k), 1)
                 ! set e( k ) to zero
                 if (k > 1) e(k) = czero
              else
                 ! ============================================================
                 ! begin pivot search
                 ! case(1)
                 ! equivalent to testing for absakk>=alpha*colmax
                 ! (used to handle nan and inf)
                 if (.not. (absakk < alpha*colmax)) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    ! lop until pivot found
                    done = .false.
12      continue
                       ! begin pivot search loop body
                       ! copy column imax to column kw-1 of w and update it
                       if (imax > 1) call stdlib_zcopy(imax - 1, a(1, imax), 1, w(1, kw - 1), 1)
                                 
                       w(imax, kw - 1) = real(a(imax, imax), KIND=dp)
                       call stdlib_zcopy(k - imax, a(imax, imax + 1), lda, w(imax + 1, kw - 1), 1)
                                 
                       call stdlib_zlacgv(k - imax, w(imax + 1, kw - 1), 1)
                       if (k < n) then
                          call stdlib_zgemv('no transpose', k, n - k, -cone, a(1, k + 1), lda, w( &
                                    imax, kw + 1), ldw, cone, w(1, kw - 1), 1)
                          w(imax, kw - 1) = real(w(imax, kw - 1), KIND=dp)
                       end if
                       ! jmax is the column-index of the largest off-diagonal
                       ! element in row imax, and rowmax is its absolute value.
                       ! determine both rowmax and jmax.
                       if (imax /= k) then
                          jmax = imax + stdlib_izamax(k - imax, w(imax + 1, kw - 1), 1)
                          rowmax = cabs1(w(jmax, kw - 1))
                       else
                          rowmax = zero
                       end if
                       if (imax > 1) then
                          itemp = stdlib_izamax(imax - 1, w(1, kw - 1), 1)
                          dtemp = cabs1(w(itemp, kw - 1))
                          if (dtemp > rowmax) then
                             rowmax = dtemp
                             jmax = itemp
                          end if
                       end if
                       ! case(2)
                       ! equivalent to testing for
                       ! abs( real( w( imax,kw-1 ) ,KIND=dp) )>=alpha*rowmax
                       ! (used to handle nan and inf)
                       if (.not. (abs(real(w(imax, kw - 1), KIND=dp)) < alpha*rowmax)) &
                                 then
                          ! interchange rows and columns k and imax,
                          ! use 1-by-1 pivot block
                          kp = imax
                          ! copy column kw-1 of w to column kw of w
                          call stdlib_zcopy(k, w(1, kw - 1), 1, w(1, kw), 1)
                          done = .true.
                       ! case(3)
                       ! equivalent to testing for rowmax==colmax,
                       ! (used to handle nan and inf)
                       else if ((p == jmax) .or. (rowmax <= colmax)) then
                          ! interchange rows and columns k-1 and imax,
                          ! use 2-by-2 pivot block
                          kp = imax
                          kstep = 2
                          done = .true.
                       ! case(4)
                       else
                          ! pivot not found: set params and repeat
                          p = imax
                          colmax = rowmax
                          imax = jmax
                          ! copy updated jmaxth (next imaxth) column to kth of w
                          call stdlib_zcopy(k, w(1, kw - 1), 1, w(1, kw), 1)
                       end if
                       ! end pivot search loop body
                    if (.not. done) goto 12
                 end if
                 ! end pivot search
                 ! ============================================================
                 ! kk is the column of a where pivoting step stopped
                 kk = k - kstep + 1
                 ! kkw is the column of w which corresponds to column kk of a
                 kkw = nb + kk - n
                 ! interchange rows and columns p and k.
                 ! updated column p is already stored in column kw of w.
                 if ((kstep == 2) .and. (p /= k)) then
                    ! copy non-updated column k to column p of submatrix a
                    ! at step k. no need to copy element into columns
                    ! k and k-1 of a for 2-by-2 pivot, since these columns
                    ! will be later overwritten.
                    a(p, p) = real(a(k, k), KIND=dp)
                    call stdlib_zcopy(k - 1 - p, a(p + 1, k), 1, a(p, p + 1), lda)
                    call stdlib_zlacgv(k - 1 - p, a(p, p + 1), lda)
                    if (p > 1) call stdlib_zcopy(p - 1, a(1, k), 1, a(1, p), 1)
                    ! interchange rows k and p in the last k+1 to n columns of a
                    ! (columns k and k-1 of a for 2-by-2 pivot will be
                    ! later overwritten). interchange rows k and p
                    ! in last kkw to nb columns of w.
                    if (k < n) call stdlib_zswap(n - k, a(k, k + 1), lda, a(p, k + 1), lda)
                    call stdlib_zswap(n - kk + 1, w(k, kkw), ldw, w(p, kkw), ldw)
                 end if
                 ! interchange rows and columns kp and kk.
                 ! updated column kp is already stored in column kkw of w.
                 if (kp /= kk) then
                    ! copy non-updated column kk to column kp of submatrix a
                    ! at step k. no need to copy element into column k
                    ! (or k and k-1 for 2-by-2 pivot) of a, since these columns
                    ! will be later overwritten.
                    a(kp, kp) = real(a(kk, kk), KIND=dp)
                    call stdlib_zcopy(kk - 1 - kp, a(kp + 1, kk), 1, a(kp, kp + 1), lda)
                    call stdlib_zlacgv(kk - 1 - kp, a(kp, kp + 1), lda)
                    if (kp > 1) call stdlib_zcopy(kp - 1, a(1, kk), 1, a(1, kp), 1)
                    ! interchange rows kk and kp in last k+1 to n columns of a
                    ! (columns k (or k and k-1 for 2-by-2 pivot) of a will be
                    ! later overwritten). interchange rows kk and kp
                    ! in last kkw to nb columns of w.
                    if (k < n) call stdlib_zswap(n - k, a(kk, k + 1), lda, a(kp, k + 1), lda)
                    call stdlib_zswap(n - kk + 1, w(kk, kkw), ldw, w(kp, kkw), ldw)
                 end if
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column kw of w now holds
                    ! w(kw) = u(k)*d(k),
                    ! where u(k) is the k-th column of u
                    ! (1) store subdiag. elements of column u(k)
                    ! and 1-by-1 block d(k) in column k of a.
                    ! (note: diagonal element u(k,k) is a unit element
                    ! and not stored)
                       ! a(k,k) := d(k,k) = w(k,kw)
                       ! a(1:k-1,k) := u(1:k-1,k) = w(1:k-1,kw)/d(k,k)
                    ! (note: no need to use for hermitian matrix
                    ! a( k, k ) = real( w( k, k) ,KIND=dp) to separately copy diagonal
                    ! element d(k,k) from w (potentially saves only one load))
                    call stdlib_zcopy(k, w(1, kw), 1, a(1, k), 1)
                    if (k > 1) then
                       ! (note: no need to check if a(k,k) is not zero,
                        ! since that was ensured earlier in pivot search:
                        ! case a(k,k) = 0 falls into 2x2 pivot case(3))
                       ! handle division by a small number
                       t = real(a(k, k), KIND=dp)
                       if (abs(t) >= sfmin) then
                          r1 = one/t
                          call stdlib_zdscal(k - 1, r1, a(1, k), 1)
                       else
                          do ii = 1, k - 1
                             a(ii, k) = a(ii, k)/t
                          end do
                       end if
                       ! (2) conjugate column w(kw)
                       call stdlib_zlacgv(k - 1, w(1, kw), 1)
                       ! store the superdiagonal element of d in array e
                       e(k) = czero
                    end if
                 else
                    ! 2-by-2 pivot block d(k): columns kw and kw-1 of w now hold
                    ! ( w(kw-1) w(kw) ) = ( u(k-1) u(k) )*d(k)
                    ! where u(k) and u(k-1) are the k-th and (k-1)-th columns
                    ! of u
                    ! (1) store u(1:k-2,k-1) and u(1:k-2,k) and 2-by-2
                    ! block d(k-1:k,k-1:k) in columns k-1 and k of a.
                    ! (note: 2-by-2 diagonal block u(k-1:k,k-1:k) is a unit
                    ! block and not stored)
                       ! a(k-1:k,k-1:k) := d(k-1:k,k-1:k) = w(k-1:k,kw-1:kw)
                       ! a(1:k-2,k-1:k) := u(1:k-2,k:k-1:k) =
                       ! = w(1:k-2,kw-1:kw) * ( d(k-1:k,k-1:k)**(-1) )
                    if (k > 2) then
                       ! factor out the columns of the inverse of 2-by-2 pivot
                       ! block d, so that each column contains 1, to reduce the
                       ! number of flops when we multiply panel
                       ! ( w(kw-1) w(kw) ) by this inverse, i.e. by d**(-1).
                       ! d**(-1) = ( d11 cj(d21) )**(-1) =
                                 ! ( d21    d22 )
                       ! = 1/(d11*d22-|d21|**2) * ( ( d22) (-cj(d21) ) ) =
                                                ! ( (-d21) (     d11 ) )
                       ! = 1/(|d21|**2) * 1/((d11/cj(d21))*(d22/d21)-1) *
                         ! * ( d21*( d22/d21 ) conj(d21)*(           - 1 ) ) =
                           ! (     (      -1 )           ( d11/conj(d21) ) )
                       ! = 1/(|d21|**2) * 1/(d22*d11-1) *
                         ! * ( d21*( d11 ) conj(d21)*(  -1 ) ) =
                           ! (     (  -1 )           ( d22 ) )
                       ! = (1/|d21|**2) * t * ( d21*( d11 ) conj(d21)*(  -1 ) ) =
                                            ! (     (  -1 )           ( d22 ) )
                       ! = ( (t/conj(d21))*( d11 ) (t/d21)*(  -1 ) ) =
                         ! (               (  -1 )         ( d22 ) )
                       ! handle division by a small number. (note: order of
                       ! operations is important)
                       ! = ( t*(( d11 )/conj(d21)) t*((  -1 )/d21 ) )
                         ! (   ((  -1 )          )   (( d22 )     ) ),
                       ! where d11 = d22/d21,
                             ! d22 = d11/conj(d21),
                             ! d21 = d21,
                             ! t = 1/(d22*d11-1).
                       ! (note: no need to check for division by zero,
                        ! since that was ensured earlier in pivot search:
                        ! (a) d21 != 0 in 2x2 pivot case(4),
                            ! since |d21| should be larger than |d11| and |d22|;
                        ! (b) (d22*d11 - 1) != 0, since from (a),
                            ! both |d11| < 1, |d22| < 1, hence |d22*d11| << 1.)
                       d21 = w(k - 1, kw)
                       d11 = w(k, kw)/conjg(d21)
                       d22 = w(k - 1, kw - 1)/d21
                       t = one/(real(d11*d22, KIND=dp) - one)
                       ! update elements in columns a(k-1) and a(k) as
                       ! dot products of rows of ( w(kw-1) w(kw) ) and columns
                       ! of d**(-1)
                       do j = 1, k - 2
                          a(j, k - 1) = t*((d11*w(j, kw - 1) - w(j, kw))/d21)
                          a(j, k) = t*((d22*w(j, kw) - w(j, kw - 1))/conjg(d21))
                       end do
                    end if
                    ! copy diagonal elements of d(k) to a,
                    ! copy superdiagonal element of d(k) to e(k) and
                    ! zero out superdiagonal entry of a
                    a(k - 1, k - 1) = w(k - 1, kw - 1)
                    a(k - 1, k) = czero
                    a(k, k) = w(k, kw)
                    e(k) = w(k - 1, kw)
                    e(k - 1) = czero
                    ! (2) conjugate columns w(kw) and w(kw-1)
                    call stdlib_zlacgv(k - 1, w(1, kw), 1)
                    call stdlib_zlacgv(k - 2, w(1, kw - 1), 1)
                 end if
                 ! end column k is nonsingular
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -p
                 ipiv(k - 1) = -kp
              end if
              ! decrease k and return to the start of the main loop
              k = k - kstep
              go to 10
30      continue
              ! update the upper triangle of a11 (= a(1:k,1:k)) as
              ! a11 := a11 - u12*d*u12**h = a11 - u12*w**h
              ! computing blocks of nb columns at a time (note that conjg(w) is
              ! actually stored)
              do j = ((k - 1)/nb)*nb + 1, 1, -nb
                 jb = min(nb, k - j + 1)
                 ! update the upper triangle of the diagonal block
                 do jj = j, j + jb - 1
                    a(jj, jj) = real(a(jj, jj), KIND=dp)
                    call stdlib_zgemv('no transpose', jj - j + 1, n - k, -cone, a(j, k + 1), lda, w(jj, &
                               kw + 1), ldw, cone, a(j, jj), 1)
                    a(jj, jj) = real(a(jj, jj), KIND=dp)
                 end do
                 ! update the rectangular superdiagonal block
                 if (j >= 2) call stdlib_zgemm('no transpose', 'transpose', j - 1, jb, n - k, -cone, a( &
                           1, k + 1), lda, w(j, kw + 1), ldw, cone, a(1, j), lda)
              end do
              ! set kb to the number of columns factorized
              kb = n - k
           else
              ! factorize the leading columns of a using the lower triangle
              ! of a and working forwards, and compute the matrix w = l21*d
              ! for use in updating a22 (note that conjg(w) is actually stored)
              ! initialize the unused last entry of the subdiagonal array e.
              e(n) = czero
              ! k is the main loop index, increasing from 1 in steps of 1 or 2
              k = 1
70      continue
              ! exit from loop
              if ((k >= nb .and. nb < n) .or. k > n) go to 90
              kstep = 1
              p = k
              ! copy column k of a to column k of w and update column k of w
              w(k, k) = real(a(k, k), KIND=dp)
              if (k < n) call stdlib_zcopy(n - k, a(k + 1, k), 1, w(k + 1, k), 1)
              if (k > 1) then
                 call stdlib_zgemv('no transpose', n - k + 1, k - 1, -cone, a(k, 1), lda, w(k, 1), &
                           ldw, cone, w(k, k), 1)
                 w(k, k) = real(w(k, k), KIND=dp)
              end if
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = abs(real(w(k, k), KIND=dp))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k < n) then
                 imax = k + stdlib_izamax(n - k, w(k + 1, k), 1)
                 colmax = cabs1(w(imax, k))
              else
                 colmax = zero
              end if
              if (max(absakk, colmax) == zero) then
                 ! column k is zero or underflow: set info and continue
                 if (info == 0) info = k
                 kp = k
                 a(k, k) = real(w(k, k), KIND=dp)
                 if (k < n) call stdlib_zcopy(n - k, w(k + 1, k), 1, a(k + 1, k), 1)
                 ! set e( k ) to zero
                 if (k < n) e(k) = czero
              else
                 ! ============================================================
                 ! begin pivot search
                 ! case(1)
                 ! equivalent to testing for absakk>=alpha*colmax
                 ! (used to handle nan and inf)
                 if (.not. (absakk < alpha*colmax)) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    done = .false.
                    ! loop until pivot found
72      continue
                       ! begin pivot search loop body
                       ! copy column imax to column k+1 of w and update it
                       call stdlib_zcopy(imax - k, a(imax, k), lda, w(k, k + 1), 1)
                       call stdlib_zlacgv(imax - k, w(k, k + 1), 1)
                       w(imax, k + 1) = real(a(imax, imax), KIND=dp)
                       if (imax < n) call stdlib_zcopy(n - imax, a(imax + 1, imax), 1, w(imax + 1, k + 1 &
                                 ), 1)
                       if (k > 1) then
                          call stdlib_zgemv('no transpose', n - k + 1, k - 1, -cone, a(k, 1), lda, w( &
                                    imax, 1), ldw, cone, w(k, k + 1), 1)
                          w(imax, k + 1) = real(w(imax, k + 1), KIND=dp)
                       end if
                       ! jmax is the column-index of the largest off-diagonal
                       ! element in row imax, and rowmax is its absolute value.
                       ! determine both rowmax and jmax.
                       if (imax /= k) then
                          jmax = k - 1 + stdlib_izamax(imax - k, w(k, k + 1), 1)
                          rowmax = cabs1(w(jmax, k + 1))
                       else
                          rowmax = zero
                       end if
                       if (imax < n) then
                          itemp = imax + stdlib_izamax(n - imax, w(imax + 1, k + 1), 1)
                          dtemp = cabs1(w(itemp, k + 1))
                          if (dtemp > rowmax) then
                             rowmax = dtemp
                             jmax = itemp
                          end if
                       end if
                       ! case(2)
                       ! equivalent to testing for
                       ! abs( real( w( imax,k+1 ) ,KIND=dp) )>=alpha*rowmax
                       ! (used to handle nan and inf)
                       if (.not. (abs(real(w(imax, k + 1), KIND=dp)) < alpha*rowmax)) &
                                 then
                          ! interchange rows and columns k and imax,
                          ! use 1-by-1 pivot block
                          kp = imax
                          ! copy column k+1 of w to column k of w
                          call stdlib_zcopy(n - k + 1, w(k, k + 1), 1, w(k, k), 1)
                          done = .true.
                       ! case(3)
                       ! equivalent to testing for rowmax==colmax,
                       ! (used to handle nan and inf)
                       else if ((p == jmax) .or. (rowmax <= colmax)) then
                          ! interchange rows and columns k+1 and imax,
                          ! use 2-by-2 pivot block
                          kp = imax
                          kstep = 2
                          done = .true.
                       ! case(4)
                       else
                          ! pivot not found: set params and repeat
                          p = imax
                          colmax = rowmax
                          imax = jmax
                          ! copy updated jmaxth (next imaxth) column to kth of w
                          call stdlib_zcopy(n - k + 1, w(k, k + 1), 1, w(k, k), 1)
                       end if
                       ! end pivot search loop body
                    if (.not. done) goto 72
                 end if
                 ! end pivot search
                 ! ============================================================
                 ! kk is the column of a where pivoting step stopped
                 kk = k + kstep - 1
                 ! interchange rows and columns p and k (only for 2-by-2 pivot).
                 ! updated column p is already stored in column k of w.
                 if ((kstep == 2) .and. (p /= k)) then
                    ! copy non-updated column kk-1 to column p of submatrix a
                    ! at step k. no need to copy element into columns
                    ! k and k+1 of a for 2-by-2 pivot, since these columns
                    ! will be later overwritten.
                    a(p, p) = real(a(k, k), KIND=dp)
                    call stdlib_zcopy(p - k - 1, a(k + 1, k), 1, a(p, k + 1), lda)
                    call stdlib_zlacgv(p - k - 1, a(p, k + 1), lda)
                    if (p < n) call stdlib_zcopy(n - p, a(p + 1, k), 1, a(p + 1, p), 1)
                    ! interchange rows k and p in first k-1 columns of a
                    ! (columns k and k+1 of a for 2-by-2 pivot will be
                    ! later overwritten). interchange rows k and p
                    ! in first kk columns of w.
                    if (k > 1) call stdlib_zswap(k - 1, a(k, 1), lda, a(p, 1), lda)
                    call stdlib_zswap(kk, w(k, 1), ldw, w(p, 1), ldw)
                 end if
                 ! interchange rows and columns kp and kk.
                 ! updated column kp is already stored in column kk of w.
                 if (kp /= kk) then
                    ! copy non-updated column kk to column kp of submatrix a
                    ! at step k. no need to copy element into column k
                    ! (or k and k+1 for 2-by-2 pivot) of a, since these columns
                    ! will be later overwritten.
                    a(kp, kp) = real(a(kk, kk), KIND=dp)
                    call stdlib_zcopy(kp - kk - 1, a(kk + 1, kk), 1, a(kp, kk + 1), lda)
                    call stdlib_zlacgv(kp - kk - 1, a(kp, kk + 1), lda)
                    if (kp < n) call stdlib_zcopy(n - kp, a(kp + 1, kk), 1, a(kp + 1, kp), 1)
                              
                    ! interchange rows kk and kp in first k-1 columns of a
                    ! (column k (or k and k+1 for 2-by-2 pivot) of a will be
                    ! later overwritten). interchange rows kk and kp
                    ! in first kk columns of w.
                    if (k > 1) call stdlib_zswap(k - 1, a(kk, 1), lda, a(kp, 1), lda)
                    call stdlib_zswap(kk, w(kk, 1), ldw, w(kp, 1), ldw)
                 end if
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k of w now holds
                    ! w(k) = l(k)*d(k),
                    ! where l(k) is the k-th column of l
                    ! (1) store subdiag. elements of column l(k)
                    ! and 1-by-1 block d(k) in column k of a.
                    ! (note: diagonal element l(k,k) is a unit element
                    ! and not stored)
                       ! a(k,k) := d(k,k) = w(k,k)
                       ! a(k+1:n,k) := l(k+1:n,k) = w(k+1:n,k)/d(k,k)
                    ! (note: no need to use for hermitian matrix
                    ! a( k, k ) = real( w( k, k) ,KIND=dp) to separately copy diagonal
                    ! element d(k,k) from w (potentially saves only one load))
                    call stdlib_zcopy(n - k + 1, w(k, k), 1, a(k, k), 1)
                    if (k < n) then
                       ! (note: no need to check if a(k,k) is not zero,
                        ! since that was ensured earlier in pivot search:
                        ! case a(k,k) = 0 falls into 2x2 pivot case(3))
                       ! handle division by a small number
                       t = real(a(k, k), KIND=dp)
                       if (abs(t) >= sfmin) then
                          r1 = one/t
                          call stdlib_zdscal(n - k, r1, a(k + 1, k), 1)
                       else
                          do ii = k + 1, n
                             a(ii, k) = a(ii, k)/t
                          end do
                       end if
                       ! (2) conjugate column w(k)
                       call stdlib_zlacgv(n - k, w(k + 1, k), 1)
                       ! store the subdiagonal element of d in array e
                       e(k) = czero
                    end if
                 else
                    ! 2-by-2 pivot block d(k): columns k and k+1 of w now hold
                    ! ( w(k) w(k+1) ) = ( l(k) l(k+1) )*d(k)
                    ! where l(k) and l(k+1) are the k-th and (k+1)-th columns
                    ! of l
                    ! (1) store l(k+2:n,k) and l(k+2:n,k+1) and 2-by-2
                    ! block d(k:k+1,k:k+1) in columns k and k+1 of a.
                    ! note: 2-by-2 diagonal block l(k:k+1,k:k+1) is a unit
                    ! block and not stored.
                       ! a(k:k+1,k:k+1) := d(k:k+1,k:k+1) = w(k:k+1,k:k+1)
                       ! a(k+2:n,k:k+1) := l(k+2:n,k:k+1) =
                       ! = w(k+2:n,k:k+1) * ( d(k:k+1,k:k+1)**(-1) )
                    if (k < n - 1) then
                       ! factor out the columns of the inverse of 2-by-2 pivot
                       ! block d, so that each column contains 1, to reduce the
                       ! number of flops when we multiply panel
                       ! ( w(kw-1) w(kw) ) by this inverse, i.e. by d**(-1).
                       ! d**(-1) = ( d11 cj(d21) )**(-1) =
                                 ! ( d21    d22 )
                       ! = 1/(d11*d22-|d21|**2) * ( ( d22) (-cj(d21) ) ) =
                                                ! ( (-d21) (     d11 ) )
                       ! = 1/(|d21|**2) * 1/((d11/cj(d21))*(d22/d21)-1) *
                         ! * ( d21*( d22/d21 ) conj(d21)*(           - 1 ) ) =
                           ! (     (      -1 )           ( d11/conj(d21) ) )
                       ! = 1/(|d21|**2) * 1/(d22*d11-1) *
                         ! * ( d21*( d11 ) conj(d21)*(  -1 ) ) =
                           ! (     (  -1 )           ( d22 ) )
                       ! = (1/|d21|**2) * t * ( d21*( d11 ) conj(d21)*(  -1 ) ) =
                                            ! (     (  -1 )           ( d22 ) )
                       ! = ( (t/conj(d21))*( d11 ) (t/d21)*(  -1 ) ) =
                         ! (               (  -1 )         ( d22 ) )
                       ! handle division by a small number. (note: order of
                       ! operations is important)
                       ! = ( t*(( d11 )/conj(d21)) t*((  -1 )/d21 ) )
                         ! (   ((  -1 )          )   (( d22 )     ) ),
                       ! where d11 = d22/d21,
                             ! d22 = d11/conj(d21),
                             ! d21 = d21,
                             ! t = 1/(d22*d11-1).
                       ! (note: no need to check for division by zero,
                        ! since that was ensured earlier in pivot search:
                        ! (a) d21 != 0 in 2x2 pivot case(4),
                            ! since |d21| should be larger than |d11| and |d22|;
                        ! (b) (d22*d11 - 1) != 0, since from (a),
                            ! both |d11| < 1, |d22| < 1, hence |d22*d11| << 1.)
                       d21 = w(k + 1, k)
                       d11 = w(k + 1, k + 1)/d21
                       d22 = w(k, k)/conjg(d21)
                       t = one/(real(d11*d22, KIND=dp) - one)
                       ! update elements in columns a(k) and a(k+1) as
                       ! dot products of rows of ( w(k) w(k+1) ) and columns
                       ! of d**(-1)
                       do j = k + 2, n
                          a(j, k) = t*((d11*w(j, k) - w(j, k + 1))/conjg(d21))
                          a(j, k + 1) = t*((d22*w(j, k + 1) - w(j, k))/d21)
                       end do
                    end if
                    ! copy diagonal elements of d(k) to a,
                    ! copy subdiagonal element of d(k) to e(k) and
                    ! zero out subdiagonal entry of a
                    a(k, k) = w(k, k)
                    a(k + 1, k) = czero
                    a(k + 1, k + 1) = w(k + 1, k + 1)
                    e(k) = w(k + 1, k)
                    e(k + 1) = czero
                    ! (2) conjugate columns w(k) and w(k+1)
                    call stdlib_zlacgv(n - k, w(k + 1, k), 1)
                    call stdlib_zlacgv(n - k - 1, w(k + 2, k + 1), 1)
                 end if
                 ! end column k is nonsingular
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -p
                 ipiv(k + 1) = -kp
              end if
              ! increase k and return to the start of the main loop
              k = k + kstep
              go to 70
90      continue
              ! update the lower triangle of a22 (= a(k:n,k:n)) as
              ! a22 := a22 - l21*d*l21**h = a22 - l21*w**h
              ! computing blocks of nb columns at a time (note that conjg(w) is
              ! actually stored)
              do j = k, n, nb
                 jb = min(nb, n - j + 1)
                 ! update the lower triangle of the diagonal block
                 do jj = j, j + jb - 1
                    a(jj, jj) = real(a(jj, jj), KIND=dp)
                    call stdlib_zgemv('no transpose', j + jb - jj, k - 1, -cone, a(jj, 1), lda, w(jj, &
                               1), ldw, cone, a(jj, jj), 1)
                    a(jj, jj) = real(a(jj, jj), KIND=dp)
                 end do
                 ! update the rectangular subdiagonal block
                 if (j + jb <= n) call stdlib_zgemm('no transpose', 'transpose', n - j - jb + 1, jb, k - 1, - &
                           cone, a(j + jb, 1), lda, w(j, 1), ldw, cone, a(j + jb, j), lda)
              end do
              ! set kb to the number of columns factorized
              kb = k - 1
           end if
           return
           ! end of stdlib_zlahef_rk
     end subroutine stdlib_zlahef_rk

     ! ZLAHEF_ROOK computes a partial factorization of a complex Hermitian
     ! matrix A using the bounded Bunch-Kaufman ("rook") diagonal pivoting
     ! method. The partial factorization has the form:
     ! A  =  ( I  U12 ) ( A11  0  ) (  I      0     )  if UPLO = 'U', or:
     ! ( 0  U22 ) (  0   D  ) ( U12**H U22**H )
     ! A  =  ( L11  0 ) (  D   0  ) ( L11**H L21**H )  if UPLO = 'L'
     ! ( L21  I ) (  0  A22 ) (  0      I     )
     ! where the order of D is at most NB. The actual order is returned in
     ! the argument KB, and is either NB or NB-1, or N if N <= NB.
     ! Note that U**H denotes the conjugate transpose of U.
     ! ZLAHEF_ROOK is an auxiliary routine called by ZHETRF_ROOK. It uses
     ! blocked code (calling Level 3 BLAS) to update the submatrix
     ! A11 (if UPLO = 'U') or A22 (if UPLO = 'L').

     subroutine stdlib_zlahef_rook(uplo, n, nb, kb, a, lda, ipiv, w, ldw, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, kb, lda, ldw, n, nb
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *), w(ldw, *)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: sevten = 17.0_dp
           
           ! .. local scalars ..
           logical(lk) :: done
           integer(ilp) :: imax, itemp, ii, j, jb, jj, jmax, jp1, jp2, k, kk, kkw, kp, kstep, kw, &
                     p
           real(dp) :: absakk, alpha, colmax, dtemp, r1, rowmax, t, sfmin
           complex(dp) :: d11, d21, d22, z
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, conjg, aimag, max, min, sqrt
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(z) = abs(real(z, KIND=dp)) + abs(aimag(z))
           ! .. executable statements ..
           info = 0
           ! initialize alpha for use in choosing pivot block size.
           alpha = (one + sqrt(sevten))/eight
           ! compute machine safe minimum
           sfmin = stdlib_dlamch('s')
           if (stdlib_lsame(uplo, 'u')) then
              ! factorize the trailing columns of a using the upper triangle
              ! of a and working backwards, and compute the matrix w = u12*d
              ! for use in updating a11 (note that conjg(w) is actually stored)
              ! k is the main loop index, decreasing from n in steps of 1 or 2
              k = n
10      continue
              ! kw is the column of w which corresponds to column k of a
              kw = nb + k - n
              ! exit from loop
              if ((k <= n - nb + 1 .and. nb < n) .or. k < 1) go to 30
              kstep = 1
              p = k
              ! copy column k of a to column kw of w and update it
              if (k > 1) call stdlib_zcopy(k - 1, a(1, k), 1, w(1, kw), 1)
              w(k, kw) = real(a(k, k), KIND=dp)
              if (k < n) then
                 call stdlib_zgemv('no transpose', k, n - k, -cone, a(1, k + 1), lda, w(k, kw + 1), &
                           ldw, cone, w(1, kw), 1)
                 w(k, kw) = real(w(k, kw), KIND=dp)
              end if
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = abs(real(w(k, kw), KIND=dp))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k > 1) then
                 imax = stdlib_izamax(k - 1, w(1, kw), 1)
                 colmax = cabs1(w(imax, kw))
              else
                 colmax = zero
              end if
              if (max(absakk, colmax) == zero) then
                 ! column k is zero or underflow: set info and continue
                 if (info == 0) info = k
                 kp = k
                 a(k, k) = real(w(k, kw), KIND=dp)
                 if (k > 1) call stdlib_zcopy(k - 1, w(1, kw), 1, a(1, k), 1)
              else
                 ! ============================================================
                 ! begin pivot search
                 ! case(1)
                 ! equivalent to testing for absakk>=alpha*colmax
                 ! (used to handle nan and inf)
                 if (.not. (absakk < alpha*colmax)) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    ! lop until pivot found
                    done = .false.
12      continue
                       ! begin pivot search loop body
                       ! copy column imax to column kw-1 of w and update it
                       if (imax > 1) call stdlib_zcopy(imax - 1, a(1, imax), 1, w(1, kw - 1), 1)
                                 
                       w(imax, kw - 1) = real(a(imax, imax), KIND=dp)
                       call stdlib_zcopy(k - imax, a(imax, imax + 1), lda, w(imax + 1, kw - 1), 1)
                                 
                       call stdlib_zlacgv(k - imax, w(imax + 1, kw - 1), 1)
                       if (k < n) then
                          call stdlib_zgemv('no transpose', k, n - k, -cone, a(1, k + 1), lda, w( &
                                    imax, kw + 1), ldw, cone, w(1, kw - 1), 1)
                          w(imax, kw - 1) = real(w(imax, kw - 1), KIND=dp)
                       end if
                       ! jmax is the column-index of the largest off-diagonal
                       ! element in row imax, and rowmax is its absolute value.
                       ! determine both rowmax and jmax.
                       if (imax /= k) then
                          jmax = imax + stdlib_izamax(k - imax, w(imax + 1, kw - 1), 1)
                          rowmax = cabs1(w(jmax, kw - 1))
                       else
                          rowmax = zero
                       end if
                       if (imax > 1) then
                          itemp = stdlib_izamax(imax - 1, w(1, kw - 1), 1)
                          dtemp = cabs1(w(itemp, kw - 1))
                          if (dtemp > rowmax) then
                             rowmax = dtemp
                             jmax = itemp
                          end if
                       end if
                       ! case(2)
                       ! equivalent to testing for
                       ! abs( real( w( imax,kw-1 ) ,KIND=dp) )>=alpha*rowmax
                       ! (used to handle nan and inf)
                       if (.not. (abs(real(w(imax, kw - 1), KIND=dp)) < alpha*rowmax)) &
                                 then
                          ! interchange rows and columns k and imax,
                          ! use 1-by-1 pivot block
                          kp = imax
                          ! copy column kw-1 of w to column kw of w
                          call stdlib_zcopy(k, w(1, kw - 1), 1, w(1, kw), 1)
                          done = .true.
                       ! case(3)
                       ! equivalent to testing for rowmax==colmax,
                       ! (used to handle nan and inf)
                       else if ((p == jmax) .or. (rowmax <= colmax)) then
                          ! interchange rows and columns k-1 and imax,
                          ! use 2-by-2 pivot block
                          kp = imax
                          kstep = 2
                          done = .true.
                       ! case(4)
                       else
                          ! pivot not found: set params and repeat
                          p = imax
                          colmax = rowmax
                          imax = jmax
                          ! copy updated jmaxth (next imaxth) column to kth of w
                          call stdlib_zcopy(k, w(1, kw - 1), 1, w(1, kw), 1)
                       end if
                       ! end pivot search loop body
                    if (.not. done) goto 12
                 end if
                 ! end pivot search
                 ! ============================================================
                 ! kk is the column of a where pivoting step stopped
                 kk = k - kstep + 1
                 ! kkw is the column of w which corresponds to column kk of a
                 kkw = nb + kk - n
                 ! interchange rows and columns p and k.
                 ! updated column p is already stored in column kw of w.
                 if ((kstep == 2) .and. (p /= k)) then
                    ! copy non-updated column k to column p of submatrix a
                    ! at step k. no need to copy element into columns
                    ! k and k-1 of a for 2-by-2 pivot, since these columns
                    ! will be later overwritten.
                    a(p, p) = real(a(k, k), KIND=dp)
                    call stdlib_zcopy(k - 1 - p, a(p + 1, k), 1, a(p, p + 1), lda)
                    call stdlib_zlacgv(k - 1 - p, a(p, p + 1), lda)
                    if (p > 1) call stdlib_zcopy(p - 1, a(1, k), 1, a(1, p), 1)
                    ! interchange rows k and p in the last k+1 to n columns of a
                    ! (columns k and k-1 of a for 2-by-2 pivot will be
                    ! later overwritten). interchange rows k and p
                    ! in last kkw to nb columns of w.
                    if (k < n) call stdlib_zswap(n - k, a(k, k + 1), lda, a(p, k + 1), lda)
                    call stdlib_zswap(n - kk + 1, w(k, kkw), ldw, w(p, kkw), ldw)
                 end if
                 ! interchange rows and columns kp and kk.
                 ! updated column kp is already stored in column kkw of w.
                 if (kp /= kk) then
                    ! copy non-updated column kk to column kp of submatrix a
                    ! at step k. no need to copy element into column k
                    ! (or k and k-1 for 2-by-2 pivot) of a, since these columns
                    ! will be later overwritten.
                    a(kp, kp) = real(a(kk, kk), KIND=dp)
                    call stdlib_zcopy(kk - 1 - kp, a(kp + 1, kk), 1, a(kp, kp + 1), lda)
                    call stdlib_zlacgv(kk - 1 - kp, a(kp, kp + 1), lda)
                    if (kp > 1) call stdlib_zcopy(kp - 1, a(1, kk), 1, a(1, kp), 1)
                    ! interchange rows kk and kp in last k+1 to n columns of a
                    ! (columns k (or k and k-1 for 2-by-2 pivot) of a will be
                    ! later overwritten). interchange rows kk and kp
                    ! in last kkw to nb columns of w.
                    if (k < n) call stdlib_zswap(n - k, a(kk, k + 1), lda, a(kp, k + 1), lda)
                    call stdlib_zswap(n - kk + 1, w(kk, kkw), ldw, w(kp, kkw), ldw)
                 end if
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column kw of w now holds
                    ! w(kw) = u(k)*d(k),
                    ! where u(k) is the k-th column of u
                    ! (1) store subdiag. elements of column u(k)
                    ! and 1-by-1 block d(k) in column k of a.
                    ! (note: diagonal element u(k,k) is a unit element
                    ! and not stored)
                       ! a(k,k) := d(k,k) = w(k,kw)
                       ! a(1:k-1,k) := u(1:k-1,k) = w(1:k-1,kw)/d(k,k)
                    ! (note: no need to use for hermitian matrix
                    ! a( k, k ) = real( w( k, k) ,KIND=dp) to separately copy diagonal
                    ! element d(k,k) from w (potentially saves only one load))
                    call stdlib_zcopy(k, w(1, kw), 1, a(1, k), 1)
                    if (k > 1) then
                       ! (note: no need to check if a(k,k) is not zero,
                        ! since that was ensured earlier in pivot search:
                        ! case a(k,k) = 0 falls into 2x2 pivot case(3))
                       ! handle division by a small number
                       t = real(a(k, k), KIND=dp)
                       if (abs(t) >= sfmin) then
                          r1 = one/t
                          call stdlib_zdscal(k - 1, r1, a(1, k), 1)
                       else
                          do ii = 1, k - 1
                             a(ii, k) = a(ii, k)/t
                          end do
                       end if
                       ! (2) conjugate column w(kw)
                       call stdlib_zlacgv(k - 1, w(1, kw), 1)
                    end if
                 else
                    ! 2-by-2 pivot block d(k): columns kw and kw-1 of w now hold
                    ! ( w(kw-1) w(kw) ) = ( u(k-1) u(k) )*d(k)
                    ! where u(k) and u(k-1) are the k-th and (k-1)-th columns
                    ! of u
                    ! (1) store u(1:k-2,k-1) and u(1:k-2,k) and 2-by-2
                    ! block d(k-1:k,k-1:k) in columns k-1 and k of a.
                    ! (note: 2-by-2 diagonal block u(k-1:k,k-1:k) is a unit
                    ! block and not stored)
                       ! a(k-1:k,k-1:k) := d(k-1:k,k-1:k) = w(k-1:k,kw-1:kw)
                       ! a(1:k-2,k-1:k) := u(1:k-2,k:k-1:k) =
                       ! = w(1:k-2,kw-1:kw) * ( d(k-1:k,k-1:k)**(-1) )
                    if (k > 2) then
                       ! factor out the columns of the inverse of 2-by-2 pivot
                       ! block d, so that each column contains 1, to reduce the
                       ! number of flops when we multiply panel
                       ! ( w(kw-1) w(kw) ) by this inverse, i.e. by d**(-1).
                       ! d**(-1) = ( d11 cj(d21) )**(-1) =
                                 ! ( d21    d22 )
                       ! = 1/(d11*d22-|d21|**2) * ( ( d22) (-cj(d21) ) ) =
                                                ! ( (-d21) (     d11 ) )
                       ! = 1/(|d21|**2) * 1/((d11/cj(d21))*(d22/d21)-1) *
                         ! * ( d21*( d22/d21 ) conj(d21)*(           - 1 ) ) =
                           ! (     (      -1 )           ( d11/conj(d21) ) )
                       ! = 1/(|d21|**2) * 1/(d22*d11-1) *
                         ! * ( d21*( d11 ) conj(d21)*(  -1 ) ) =
                           ! (     (  -1 )           ( d22 ) )
                       ! = (1/|d21|**2) * t * ( d21*( d11 ) conj(d21)*(  -1 ) ) =
                                            ! (     (  -1 )           ( d22 ) )
                       ! = ( (t/conj(d21))*( d11 ) (t/d21)*(  -1 ) ) =
                         ! (               (  -1 )         ( d22 ) )
                       ! handle division by a small number. (note: order of
                       ! operations is important)
                       ! = ( t*(( d11 )/conj(d21)) t*((  -1 )/d21 ) )
                         ! (   ((  -1 )          )   (( d22 )     ) ),
                       ! where d11 = d22/d21,
                             ! d22 = d11/conj(d21),
                             ! d21 = d21,
                             ! t = 1/(d22*d11-1).
                       ! (note: no need to check for division by zero,
                        ! since that was ensured earlier in pivot search:
                        ! (a) d21 != 0 in 2x2 pivot case(4),
                            ! since |d21| should be larger than |d11| and |d22|;
                        ! (b) (d22*d11 - 1) != 0, since from (a),
                            ! both |d11| < 1, |d22| < 1, hence |d22*d11| << 1.)
                       d21 = w(k - 1, kw)
                       d11 = w(k, kw)/conjg(d21)
                       d22 = w(k - 1, kw - 1)/d21
                       t = one/(real(d11*d22, KIND=dp) - one)
                       ! update elements in columns a(k-1) and a(k) as
                       ! dot products of rows of ( w(kw-1) w(kw) ) and columns
                       ! of d**(-1)
                       do j = 1, k - 2
                          a(j, k - 1) = t*((d11*w(j, kw - 1) - w(j, kw))/d21)
                          a(j, k) = t*((d22*w(j, kw) - w(j, kw - 1))/conjg(d21))
                       end do
                    end if
                    ! copy d(k) to a
                    a(k - 1, k - 1) = w(k - 1, kw - 1)
                    a(k - 1, k) = w(k - 1, kw)
                    a(k, k) = w(k, kw)
                    ! (2) conjugate columns w(kw) and w(kw-1)
                    call stdlib_zlacgv(k - 1, w(1, kw), 1)
                    call stdlib_zlacgv(k - 2, w(1, kw - 1), 1)
                 end if
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -p
                 ipiv(k - 1) = -kp
              end if
              ! decrease k and return to the start of the main loop
              k = k - kstep
              go to 10
30      continue
              ! update the upper triangle of a11 (= a(1:k,1:k)) as
              ! a11 := a11 - u12*d*u12**h = a11 - u12*w**h
              ! computing blocks of nb columns at a time (note that conjg(w) is
              ! actually stored)
              do j = ((k - 1)/nb)*nb + 1, 1, -nb
                 jb = min(nb, k - j + 1)
                 ! update the upper triangle of the diagonal block
                 do jj = j, j + jb - 1
                    a(jj, jj) = real(a(jj, jj), KIND=dp)
                    call stdlib_zgemv('no transpose', jj - j + 1, n - k, -cone, a(j, k + 1), lda, w(jj, &
                               kw + 1), ldw, cone, a(j, jj), 1)
                    a(jj, jj) = real(a(jj, jj), KIND=dp)
                 end do
                 ! update the rectangular superdiagonal block
                 if (j >= 2) call stdlib_zgemm('no transpose', 'transpose', j - 1, jb, n - k, -cone, a( &
                           1, k + 1), lda, w(j, kw + 1), ldw, cone, a(1, j), lda)
              end do
              ! put u12 in standard form by partially undoing the interchanges
              ! in of rows in columns k+1:n looping backwards from k+1 to n
              j = k + 1
60      continue
                 ! undo the interchanges (if any) of rows j and jp2
                 ! (or j and jp2, and j+1 and jp1) at each step j
                 kstep = 1
                 jp1 = 1
                 ! (here, j is a diagonal index)
                 jj = j
                 jp2 = ipiv(j)
                 if (jp2 < 0) then
                    jp2 = -jp2
                    ! (here, j is a diagonal index)
                    j = j + 1
                    jp1 = -ipiv(j)
                    kstep = 2
                 end if
                 ! (note: here, j is used to determine row length. length n-j+1
                 ! of the rows to swap back doesn't include diagonal element)
                 j = j + 1
                 if (jp2 /= jj .and. j <= n) call stdlib_zswap(n - j + 1, a(jp2, j), lda, a(jj, j), &
                           lda)
                 jj = jj + 1
                 if (kstep == 2 .and. jp1 /= jj .and. j <= n) call stdlib_zswap(n - j + 1, a(jp1, j), &
                           lda, a(jj, j), lda)
              if (j < n) go to 60
              ! set kb to the number of columns factorized
              kb = n - k
           else
              ! factorize the leading columns of a using the lower triangle
              ! of a and working forwards, and compute the matrix w = l21*d
              ! for use in updating a22 (note that conjg(w) is actually stored)
              ! k is the main loop index, increasing from 1 in steps of 1 or 2
              k = 1
70      continue
              ! exit from loop
              if ((k >= nb .and. nb < n) .or. k > n) go to 90
              kstep = 1
              p = k
              ! copy column k of a to column k of w and update column k of w
              w(k, k) = real(a(k, k), KIND=dp)
              if (k < n) call stdlib_zcopy(n - k, a(k + 1, k), 1, w(k + 1, k), 1)
              if (k > 1) then
                 call stdlib_zgemv('no transpose', n - k + 1, k - 1, -cone, a(k, 1), lda, w(k, 1), &
                           ldw, cone, w(k, k), 1)
                 w(k, k) = real(w(k, k), KIND=dp)
              end if
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = abs(real(w(k, k), KIND=dp))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k < n) then
                 imax = k + stdlib_izamax(n - k, w(k + 1, k), 1)
                 colmax = cabs1(w(imax, k))
              else
                 colmax = zero
              end if
              if (max(absakk, colmax) == zero) then
                 ! column k is zero or underflow: set info and continue
                 if (info == 0) info = k
                 kp = k
                 a(k, k) = real(w(k, k), KIND=dp)
                 if (k < n) call stdlib_zcopy(n - k, w(k + 1, k), 1, a(k + 1, k), 1)
              else
                 ! ============================================================
                 ! begin pivot search
                 ! case(1)
                 ! equivalent to testing for absakk>=alpha*colmax
                 ! (used to handle nan and inf)
                 if (.not. (absakk < alpha*colmax)) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    done = .false.
                    ! loop until pivot found
72      continue
                       ! begin pivot search loop body
                       ! copy column imax to column k+1 of w and update it
                       call stdlib_zcopy(imax - k, a(imax, k), lda, w(k, k + 1), 1)
                       call stdlib_zlacgv(imax - k, w(k, k + 1), 1)
                       w(imax, k + 1) = real(a(imax, imax), KIND=dp)
                       if (imax < n) call stdlib_zcopy(n - imax, a(imax + 1, imax), 1, w(imax + 1, k + 1 &
                                 ), 1)
                       if (k > 1) then
                          call stdlib_zgemv('no transpose', n - k + 1, k - 1, -cone, a(k, 1), lda, w( &
                                    imax, 1), ldw, cone, w(k, k + 1), 1)
                          w(imax, k + 1) = real(w(imax, k + 1), KIND=dp)
                       end if
                       ! jmax is the column-index of the largest off-diagonal
                       ! element in row imax, and rowmax is its absolute value.
                       ! determine both rowmax and jmax.
                       if (imax /= k) then
                          jmax = k - 1 + stdlib_izamax(imax - k, w(k, k + 1), 1)
                          rowmax = cabs1(w(jmax, k + 1))
                       else
                          rowmax = zero
                       end if
                       if (imax < n) then
                          itemp = imax + stdlib_izamax(n - imax, w(imax + 1, k + 1), 1)
                          dtemp = cabs1(w(itemp, k + 1))
                          if (dtemp > rowmax) then
                             rowmax = dtemp
                             jmax = itemp
                          end if
                       end if
                       ! case(2)
                       ! equivalent to testing for
                       ! abs( real( w( imax,k+1 ) ,KIND=dp) )>=alpha*rowmax
                       ! (used to handle nan and inf)
                       if (.not. (abs(real(w(imax, k + 1), KIND=dp)) < alpha*rowmax)) &
                                 then
                          ! interchange rows and columns k and imax,
                          ! use 1-by-1 pivot block
                          kp = imax
                          ! copy column k+1 of w to column k of w
                          call stdlib_zcopy(n - k + 1, w(k, k + 1), 1, w(k, k), 1)
                          done = .true.
                       ! case(3)
                       ! equivalent to testing for rowmax==colmax,
                       ! (used to handle nan and inf)
                       else if ((p == jmax) .or. (rowmax <= colmax)) then
                          ! interchange rows and columns k+1 and imax,
                          ! use 2-by-2 pivot block
                          kp = imax
                          kstep = 2
                          done = .true.
                       ! case(4)
                       else
                          ! pivot not found: set params and repeat
                          p = imax
                          colmax = rowmax
                          imax = jmax
                          ! copy updated jmaxth (next imaxth) column to kth of w
                          call stdlib_zcopy(n - k + 1, w(k, k + 1), 1, w(k, k), 1)
                       end if
                       ! end pivot search loop body
                    if (.not. done) goto 72
                 end if
                 ! end pivot search
                 ! ============================================================
                 ! kk is the column of a where pivoting step stopped
                 kk = k + kstep - 1
                 ! interchange rows and columns p and k (only for 2-by-2 pivot).
                 ! updated column p is already stored in column k of w.
                 if ((kstep == 2) .and. (p /= k)) then
                    ! copy non-updated column kk-1 to column p of submatrix a
                    ! at step k. no need to copy element into columns
                    ! k and k+1 of a for 2-by-2 pivot, since these columns
                    ! will be later overwritten.
                    a(p, p) = real(a(k, k), KIND=dp)
                    call stdlib_zcopy(p - k - 1, a(k + 1, k), 1, a(p, k + 1), lda)
                    call stdlib_zlacgv(p - k - 1, a(p, k + 1), lda)
                    if (p < n) call stdlib_zcopy(n - p, a(p + 1, k), 1, a(p + 1, p), 1)
                    ! interchange rows k and p in first k-1 columns of a
                    ! (columns k and k+1 of a for 2-by-2 pivot will be
                    ! later overwritten). interchange rows k and p
                    ! in first kk columns of w.
                    if (k > 1) call stdlib_zswap(k - 1, a(k, 1), lda, a(p, 1), lda)
                    call stdlib_zswap(kk, w(k, 1), ldw, w(p, 1), ldw)
                 end if
                 ! interchange rows and columns kp and kk.
                 ! updated column kp is already stored in column kk of w.
                 if (kp /= kk) then
                    ! copy non-updated column kk to column kp of submatrix a
                    ! at step k. no need to copy element into column k
                    ! (or k and k+1 for 2-by-2 pivot) of a, since these columns
                    ! will be later overwritten.
                    a(kp, kp) = real(a(kk, kk), KIND=dp)
                    call stdlib_zcopy(kp - kk - 1, a(kk + 1, kk), 1, a(kp, kk + 1), lda)
                    call stdlib_zlacgv(kp - kk - 1, a(kp, kk + 1), lda)
                    if (kp < n) call stdlib_zcopy(n - kp, a(kp + 1, kk), 1, a(kp + 1, kp), 1)
                              
                    ! interchange rows kk and kp in first k-1 columns of a
                    ! (column k (or k and k+1 for 2-by-2 pivot) of a will be
                    ! later overwritten). interchange rows kk and kp
                    ! in first kk columns of w.
                    if (k > 1) call stdlib_zswap(k - 1, a(kk, 1), lda, a(kp, 1), lda)
                    call stdlib_zswap(kk, w(kk, 1), ldw, w(kp, 1), ldw)
                 end if
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k of w now holds
                    ! w(k) = l(k)*d(k),
                    ! where l(k) is the k-th column of l
                    ! (1) store subdiag. elements of column l(k)
                    ! and 1-by-1 block d(k) in column k of a.
                    ! (note: diagonal element l(k,k) is a unit element
                    ! and not stored)
                       ! a(k,k) := d(k,k) = w(k,k)
                       ! a(k+1:n,k) := l(k+1:n,k) = w(k+1:n,k)/d(k,k)
                    ! (note: no need to use for hermitian matrix
                    ! a( k, k ) = real( w( k, k) ,KIND=dp) to separately copy diagonal
                    ! element d(k,k) from w (potentially saves only one load))
                    call stdlib_zcopy(n - k + 1, w(k, k), 1, a(k, k), 1)
                    if (k < n) then
                       ! (note: no need to check if a(k,k) is not zero,
                        ! since that was ensured earlier in pivot search:
                        ! case a(k,k) = 0 falls into 2x2 pivot case(3))
                       ! handle division by a small number
                       t = real(a(k, k), KIND=dp)
                       if (abs(t) >= sfmin) then
                          r1 = one/t
                          call stdlib_zdscal(n - k, r1, a(k + 1, k), 1)
                       else
                          do ii = k + 1, n
                             a(ii, k) = a(ii, k)/t
                          end do
                       end if
                       ! (2) conjugate column w(k)
                       call stdlib_zlacgv(n - k, w(k + 1, k), 1)
                    end if
                 else
                    ! 2-by-2 pivot block d(k): columns k and k+1 of w now hold
                    ! ( w(k) w(k+1) ) = ( l(k) l(k+1) )*d(k)
                    ! where l(k) and l(k+1) are the k-th and (k+1)-th columns
                    ! of l
                    ! (1) store l(k+2:n,k) and l(k+2:n,k+1) and 2-by-2
                    ! block d(k:k+1,k:k+1) in columns k and k+1 of a.
                    ! note: 2-by-2 diagonal block l(k:k+1,k:k+1) is a unit
                    ! block and not stored.
                       ! a(k:k+1,k:k+1) := d(k:k+1,k:k+1) = w(k:k+1,k:k+1)
                       ! a(k+2:n,k:k+1) := l(k+2:n,k:k+1) =
                       ! = w(k+2:n,k:k+1) * ( d(k:k+1,k:k+1)**(-1) )
                    if (k < n - 1) then
                       ! factor out the columns of the inverse of 2-by-2 pivot
                       ! block d, so that each column contains 1, to reduce the
                       ! number of flops when we multiply panel
                       ! ( w(kw-1) w(kw) ) by this inverse, i.e. by d**(-1).
                       ! d**(-1) = ( d11 cj(d21) )**(-1) =
                                 ! ( d21    d22 )
                       ! = 1/(d11*d22-|d21|**2) * ( ( d22) (-cj(d21) ) ) =
                                                ! ( (-d21) (     d11 ) )
                       ! = 1/(|d21|**2) * 1/((d11/cj(d21))*(d22/d21)-1) *
                         ! * ( d21*( d22/d21 ) conj(d21)*(           - 1 ) ) =
                           ! (     (      -1 )           ( d11/conj(d21) ) )
                       ! = 1/(|d21|**2) * 1/(d22*d11-1) *
                         ! * ( d21*( d11 ) conj(d21)*(  -1 ) ) =
                           ! (     (  -1 )           ( d22 ) )
                       ! = (1/|d21|**2) * t * ( d21*( d11 ) conj(d21)*(  -1 ) ) =
                                            ! (     (  -1 )           ( d22 ) )
                       ! = ( (t/conj(d21))*( d11 ) (t/d21)*(  -1 ) ) =
                         ! (               (  -1 )         ( d22 ) )
                       ! handle division by a small number. (note: order of
                       ! operations is important)
                       ! = ( t*(( d11 )/conj(d21)) t*((  -1 )/d21 ) )
                         ! (   ((  -1 )          )   (( d22 )     ) ),
                       ! where d11 = d22/d21,
                             ! d22 = d11/conj(d21),
                             ! d21 = d21,
                             ! t = 1/(d22*d11-1).
                       ! (note: no need to check for division by zero,
                        ! since that was ensured earlier in pivot search:
                        ! (a) d21 != 0 in 2x2 pivot case(4),
                            ! since |d21| should be larger than |d11| and |d22|;
                        ! (b) (d22*d11 - 1) != 0, since from (a),
                            ! both |d11| < 1, |d22| < 1, hence |d22*d11| << 1.)
                       d21 = w(k + 1, k)
                       d11 = w(k + 1, k + 1)/d21
                       d22 = w(k, k)/conjg(d21)
                       t = one/(real(d11*d22, KIND=dp) - one)
                       ! update elements in columns a(k) and a(k+1) as
                       ! dot products of rows of ( w(k) w(k+1) ) and columns
                       ! of d**(-1)
                       do j = k + 2, n
                          a(j, k) = t*((d11*w(j, k) - w(j, k + 1))/conjg(d21))
                          a(j, k + 1) = t*((d22*w(j, k + 1) - w(j, k))/d21)
                       end do
                    end if
                    ! copy d(k) to a
                    a(k, k) = w(k, k)
                    a(k + 1, k) = w(k + 1, k)
                    a(k + 1, k + 1) = w(k + 1, k + 1)
                    ! (2) conjugate columns w(k) and w(k+1)
                    call stdlib_zlacgv(n - k, w(k + 1, k), 1)
                    call stdlib_zlacgv(n - k - 1, w(k + 2, k + 1), 1)
                 end if
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -p
                 ipiv(k + 1) = -kp
              end if
              ! increase k and return to the start of the main loop
              k = k + kstep
              go to 70
90      continue
              ! update the lower triangle of a22 (= a(k:n,k:n)) as
              ! a22 := a22 - l21*d*l21**h = a22 - l21*w**h
              ! computing blocks of nb columns at a time (note that conjg(w) is
              ! actually stored)
              do j = k, n, nb
                 jb = min(nb, n - j + 1)
                 ! update the lower triangle of the diagonal block
                 do jj = j, j + jb - 1
                    a(jj, jj) = real(a(jj, jj), KIND=dp)
                    call stdlib_zgemv('no transpose', j + jb - jj, k - 1, -cone, a(jj, 1), lda, w(jj, &
                               1), ldw, cone, a(jj, jj), 1)
                    a(jj, jj) = real(a(jj, jj), KIND=dp)
                 end do
                 ! update the rectangular subdiagonal block
                 if (j + jb <= n) call stdlib_zgemm('no transpose', 'transpose', n - j - jb + 1, jb, k - 1, - &
                           cone, a(j + jb, 1), lda, w(j, 1), ldw, cone, a(j + jb, j), lda)
              end do
              ! put l21 in standard form by partially undoing the interchanges
              ! of rows in columns 1:k-1 looping backwards from k-1 to 1
              j = k - 1
120    continue
                 ! undo the interchanges (if any) of rows j and jp2
                 ! (or j and jp2, and j-1 and jp1) at each step j
                 kstep = 1
                 jp1 = 1
                 ! (here, j is a diagonal index)
                 jj = j
                 jp2 = ipiv(j)
                 if (jp2 < 0) then
                    jp2 = -jp2
                    ! (here, j is a diagonal index)
                    j = j - 1
                    jp1 = -ipiv(j)
                    kstep = 2
                 end if
                 ! (note: here, j is used to determine row length. length j
                 ! of the rows to swap back doesn't include diagonal element)
                 j = j - 1
                 if (jp2 /= jj .and. j >= 1) call stdlib_zswap(j, a(jp2, 1), lda, a(jj, 1), lda)
                           
                 jj = jj - 1
                 if (kstep == 2 .and. jp1 /= jj .and. j >= 1) call stdlib_zswap(j, a(jp1, 1), lda, a( &
                            jj, 1), lda)
              if (j > 1) go to 120
              ! set kb to the number of columns factorized
              kb = k - 1
           end if
           return
           ! end of stdlib_zlahef_rook
     end subroutine stdlib_zlahef_rook

     ! ZLAIC1 applies one step of incremental condition estimation in
     ! its simplest version:
     ! Let x, twonorm(x) = 1, be an approximate singular vector of an j-by-j
     ! lower triangular matrix L, such that
     ! twonorm(L*x) = sest
     ! Then ZLAIC1 computes sestpr, s, c such that
     ! the vector
     ! [ s*x ]
     ! xhat = [  c  ]
     ! is an approximate singular vector of
     ! [ L       0  ]
     ! Lhat = [ w**H gamma ]
     ! in the sense that
     ! twonorm(Lhat*xhat) = sestpr.
     ! Depending on JOB, an estimate for the largest or smallest singular
     ! value is computed.
     ! Note that [s c]**H and sestpr**2 is an eigenpair of the system
     ! diag(sest*sest, 0) + [alpha  gamma] * [ conjg(alpha) ]
     ! [ conjg(gamma) ]
     ! where  alpha =  x**H * w.

     subroutine stdlib_zlaic1(job, j, x, sest, w, gamma, sestpr, s, c)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: j, job
           real(dp) :: sest, sestpr
           complex(dp) :: c, gamma, s
           ! .. array arguments ..
           complex(dp) :: w(j), x(j)
        ! =====================================================================
           
           ! .. local scalars ..
           real(dp) :: absalp, absest, absgam, b, eps, norma, s1, s2, scl, t, test, tmp, zeta1, &
                     zeta2
           complex(dp) :: alpha, cosine, sine
           ! .. intrinsic functions ..
           intrinsic :: abs, conjg, max, sqrt
     
           ! .. executable statements ..
           eps = stdlib_dlamch('epsilon')
           alpha = stdlib_zdotc(j, x, 1, w, 1)
           absalp = abs(alpha)
           absgam = abs(gamma)
           absest = abs(sest)
           if (job == 1) then
              ! estimating largest singular value
              ! special cases
              if (sest == zero) then
                 s1 = max(absgam, absalp)
                 if (s1 == zero) then
                    s = zero
                    c = one
                    sestpr = zero
                 else
                    s = alpha/s1
                    c = gamma/s1
                    tmp = dble(sqrt(s*conjg(s) + c*conjg(c)))
                    s = s/tmp
                    c = c/tmp
                    sestpr = s1*tmp
                 end if
                 return
              else if (absgam <= eps*absest) then
                 s = one
                 c = zero
                 tmp = max(absest, absalp)
                 s1 = absest/tmp
                 s2 = absalp/tmp
                 sestpr = tmp*sqrt(s1*s1 + s2*s2)
                 return
              else if (absalp <= eps*absest) then
                 s1 = absgam
                 s2 = absest
                 if (s1 <= s2) then
                    s = one
                    c = zero
                    sestpr = s2
                 else
                    s = zero
                    c = one
                    sestpr = s1
                 end if
                 return
              else if (absest <= eps*absalp .or. absest <= eps*absgam) then
                 s1 = absgam
                 s2 = absalp
                 if (s1 <= s2) then
                    tmp = s1/s2
                    scl = sqrt(one + tmp*tmp)
                    sestpr = s2*scl
                    s = (alpha/s2)/scl
                    c = (gamma/s2)/scl
                 else
                    tmp = s2/s1
                    scl = sqrt(one + tmp*tmp)
                    sestpr = s1*scl
                    s = (alpha/s1)/scl
                    c = (gamma/s1)/scl
                 end if
                 return
              else
                 ! normal case
                 zeta1 = absalp/absest
                 zeta2 = absgam/absest
                 b = (one - zeta1*zeta1 - zeta2*zeta2)*half
                 c = zeta1*zeta1
                 if (b > zero) then
                    t = dble(c/(b + sqrt(b*b + c)))
                 else
                    t = real(sqrt(b*b + c) - b, KIND=dp)
                 end if
                 sine = -(alpha/absest)/t
                 cosine = -(gamma/absest)/(one + t)
                 tmp = dble(sqrt(sine*conjg(sine) + cosine*conjg(cosine)))
                 s = sine/tmp
                 c = cosine/tmp
                 sestpr = sqrt(t + one)*absest
                 return
              end if
           else if (job == 2) then
              ! estimating smallest singular value
              ! special cases
              if (sest == zero) then
                 sestpr = zero
                 if (max(absgam, absalp) == zero) then
                    sine = one
                    cosine = zero
                 else
                    sine = -conjg(gamma)
                    cosine = conjg(alpha)
                 end if
                 s1 = max(abs(sine), abs(cosine))
                 s = sine/s1
                 c = cosine/s1
                 tmp = dble(sqrt(s*conjg(s) + c*conjg(c)))
                 s = s/tmp
                 c = c/tmp
                 return
              else if (absgam <= eps*absest) then
                 s = zero
                 c = one
                 sestpr = absgam
                 return
              else if (absalp <= eps*absest) then
                 s1 = absgam
                 s2 = absest
                 if (s1 <= s2) then
                    s = zero
                    c = one
                    sestpr = s1
                 else
                    s = one
                    c = zero
                    sestpr = s2
                 end if
                 return
              else if (absest <= eps*absalp .or. absest <= eps*absgam) then
                 s1 = absgam
                 s2 = absalp
                 if (s1 <= s2) then
                    tmp = s1/s2
                    scl = sqrt(one + tmp*tmp)
                    sestpr = absest*(tmp/scl)
                    s = -(conjg(gamma)/s2)/scl
                    c = (conjg(alpha)/s2)/scl
                 else
                    tmp = s2/s1
                    scl = sqrt(one + tmp*tmp)
                    sestpr = absest/scl
                    s = -(conjg(gamma)/s1)/scl
                    c = (conjg(alpha)/s1)/scl
                 end if
                 return
              else
                 ! normal case
                 zeta1 = absalp/absest
                 zeta2 = absgam/absest
                 norma = max(one + zeta1*zeta1 + zeta1*zeta2, zeta1*zeta2 + zeta2*zeta2)
                 ! see if root is closer to zero or to one
                 test = one + two*(zeta1 - zeta2)*(zeta1 + zeta2)
                 if (test >= zero) then
                    ! root is close to zero, compute directly
                    b = (zeta1*zeta1 + zeta2*zeta2 + one)*half
                    c = zeta2*zeta2
                    t = dble(c/(b + sqrt(abs(b*b - c))))
                    sine = (alpha/absest)/(one - t)
                    cosine = -(gamma/absest)/t
                    sestpr = sqrt(t + four*eps*eps*norma)*absest
                 else
                    ! root is closer to one, shift by that amount
                    b = (zeta2*zeta2 + zeta1*zeta1 - one)*half
                    c = zeta1*zeta1
                    if (b >= zero) then
                       t = -c/(b + sqrt(b*b + c))
                    else
                       t = b - sqrt(b*b + c)
                    end if
                    sine = -(alpha/absest)/t
                    cosine = -(gamma/absest)/(one + t)
                    sestpr = sqrt(one + t + four*eps*eps*norma)*absest
                 end if
                 tmp = dble(sqrt(sine*conjg(sine) + cosine*conjg(cosine)))
                 s = sine/tmp
                 c = cosine/tmp
                 return
              end if
           end if
           return
           ! end of stdlib_zlaic1
     end subroutine stdlib_zlaic1

     ! ZLAPMR rearranges the rows of the M by N matrix X as specified
     ! by the permutation K(1),K(2),...,K(M) of the integers 1,...,M.
     ! If FORWRD = .TRUE.,  forward permutation:
     ! X(K(I),*) is moved X(I,*) for I = 1,2,...,M.
     ! If FORWRD = .FALSE., backward permutation:
     ! X(I,*) is moved to X(K(I),*) for I = 1,2,...,M.

     subroutine stdlib_zlapmr(forwrd, m, n, x, ldx, k)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           logical(lk) :: forwrd
           integer(ilp) :: ldx, m, n
           ! .. array arguments ..
           integer(ilp) :: k(*)
           complex(dp) :: x(ldx, *)
        ! =====================================================================
           ! .. local scalars ..
           integer(ilp) :: i, in, j, jj
           complex(dp) :: temp
           ! .. executable statements ..
           if (m <= 1) return
           do i = 1, m
              k(i) = -k(i)
           end do
           if (forwrd) then
              ! forward permutation
              do i = 1, m
                 if (k(i) > 0) go to 40
                 j = i
                 k(j) = -k(j)
                 in = k(j)
20      continue
                 if (k(in) > 0) go to 40
                 do jj = 1, n
                    temp = x(j, jj)
                    x(j, jj) = x(in, jj)
                    x(in, jj) = temp
                 end do
                 k(in) = -k(in)
                 j = in
                 in = k(in)
                 go to 20
40      continue
              end do
           else
              ! backward permutation
              do i = 1, m
                 if (k(i) > 0) go to 80
                 k(i) = -k(i)
                 j = k(i)
60      continue
                 if (j == i) go to 80
                 do jj = 1, n
                    temp = x(i, jj)
                    x(i, jj) = x(j, jj)
                    x(j, jj) = temp
                 end do
                 k(j) = -k(j)
                 j = k(j)
                 go to 60
80      continue
              end do
           end if
           return
           ! end of stdlib_zlapmr
     end subroutine stdlib_zlapmr

     ! ZLAPMT rearranges the columns of the M by N matrix X as specified
     ! by the permutation K(1),K(2),...,K(N) of the integers 1,...,N.
     ! If FORWRD = .TRUE.,  forward permutation:
     ! X(*,K(J)) is moved X(*,J) for J = 1,2,...,N.
     ! If FORWRD = .FALSE., backward permutation:
     ! X(*,J) is moved to X(*,K(J)) for J = 1,2,...,N.

     subroutine stdlib_zlapmt(forwrd, m, n, x, ldx, k)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           logical(lk) :: forwrd
           integer(ilp) :: ldx, m, n
           ! .. array arguments ..
           integer(ilp) :: k(*)
           complex(dp) :: x(ldx, *)
        ! =====================================================================
           ! .. local scalars ..
           integer(ilp) :: i, ii, in, j
           complex(dp) :: temp
           ! .. executable statements ..
           if (n <= 1) return
           do i = 1, n
              k(i) = -k(i)
           end do
           if (forwrd) then
              ! forward permutation
              do i = 1, n
                 if (k(i) > 0) go to 40
                 j = i
                 k(j) = -k(j)
                 in = k(j)
20      continue
                 if (k(in) > 0) go to 40
                 do ii = 1, m
                    temp = x(ii, j)
                    x(ii, j) = x(ii, in)
                    x(ii, in) = temp
                 end do
                 k(in) = -k(in)
                 j = in
                 in = k(in)
                 go to 20
40      continue
              end do
           else
              ! backward permutation
              do i = 1, n
                 if (k(i) > 0) go to 80
                 k(i) = -k(i)
                 j = k(i)
60      continue
                 if (j == i) go to 80
                 do ii = 1, m
                    temp = x(ii, i)
                    x(ii, i) = x(ii, j)
                    x(ii, j) = temp
                 end do
                 k(j) = -k(j)
                 j = k(j)
                 go to 60
80      continue
              end do
           end if
           return
           ! end of stdlib_zlapmt
     end subroutine stdlib_zlapmt

     ! ZLAQGB equilibrates a general M by N band matrix A with KL
     ! subdiagonals and KU superdiagonals using the row and scaling factors
     ! in the vectors R and C.

     subroutine stdlib_zlaqgb(m, n, kl, ku, ab, ldab, r, c, rowcnd, colcnd, amax, equed)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: equed
           integer(ilp) :: kl, ku, ldab, m, n
           real(dp) :: amax, colcnd, rowcnd
           ! .. array arguments ..
           real(dp) :: c(*), r(*)
           complex(dp) :: ab(ldab, *)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: thresh = 0.1_dp
           
           ! .. local scalars ..
           integer(ilp) :: i, j
           real(dp) :: cj, large, small
     
           ! .. intrinsic functions ..
           intrinsic :: max, min
           ! .. executable statements ..
           ! quick return if possible
           if (m <= 0 .or. n <= 0) then
              equed = 'n'
              return
           end if
           ! initialize large and small.
           small = stdlib_dlamch('safe minimum')/stdlib_dlamch('precision')
           large = one/small
           if (rowcnd >= thresh .and. amax >= small .and. amax <= large) then
              ! no row scaling
              if (colcnd >= thresh) then
                 ! no column scaling
                 equed = 'n'
              else
                 ! column scaling
                 do j = 1, n
                    cj = c(j)
                    do i = max(1, j - ku), min(m, j + kl)
                       ab(ku + 1 + i - j, j) = cj*ab(ku + 1 + i - j, j)
                    end do
                 end do
                 equed = 'c'
              end if
           else if (colcnd >= thresh) then
              ! row scaling, no column scaling
              do j = 1, n
                 do i = max(1, j - ku), min(m, j + kl)
                    ab(ku + 1 + i - j, j) = r(i)*ab(ku + 1 + i - j, j)
                 end do
              end do
              equed = 'r'
           else
              ! row and column scaling
              do j = 1, n
                 cj = c(j)
                 do i = max(1, j - ku), min(m, j + kl)
                    ab(ku + 1 + i - j, j) = cj*r(i)*ab(ku + 1 + i - j, j)
                 end do
              end do
              equed = 'b'
           end if
           return
           ! end of stdlib_zlaqgb
     end subroutine stdlib_zlaqgb

     ! ZLAQGE equilibrates a general M by N matrix A using the row and
     ! column scaling factors in the vectors R and C.

     subroutine stdlib_zlaqge(m, n, a, lda, r, c, rowcnd, colcnd, amax, equed)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: equed
           integer(ilp) :: lda, m, n
           real(dp) :: amax, colcnd, rowcnd
           ! .. array arguments ..
           real(dp) :: c(*), r(*)
           complex(dp) :: a(lda, *)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: thresh = 0.1_dp
           
           ! .. local scalars ..
           integer(ilp) :: i, j
           real(dp) :: cj, large, small
     
           ! .. executable statements ..
           ! quick return if possible
           if (m <= 0 .or. n <= 0) then
              equed = 'n'
              return
           end if
           ! initialize large and small.
           small = stdlib_dlamch('safe minimum')/stdlib_dlamch('precision')
           large = one/small
           if (rowcnd >= thresh .and. amax >= small .and. amax <= large) then
              ! no row scaling
              if (colcnd >= thresh) then
                 ! no column scaling
                 equed = 'n'
              else
                 ! column scaling
                 do j = 1, n
                    cj = c(j)
                    do i = 1, m
                       a(i, j) = cj*a(i, j)
                    end do
                 end do
                 equed = 'c'
              end if
           else if (colcnd >= thresh) then
              ! row scaling, no column scaling
              do j = 1, n
                 do i = 1, m
                    a(i, j) = r(i)*a(i, j)
                 end do
              end do
              equed = 'r'
           else
              ! row and column scaling
              do j = 1, n
                 cj = c(j)
                 do i = 1, m
                    a(i, j) = cj*r(i)*a(i, j)
                 end do
              end do
              equed = 'b'
           end if
           return
           ! end of stdlib_zlaqge
     end subroutine stdlib_zlaqge

     ! ZLAQHB equilibrates a Hermitian band matrix A
     ! using the scaling factors in the vector S.

     subroutine stdlib_zlaqhb(uplo, n, kd, ab, ldab, s, scond, amax, equed)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: equed, uplo
           integer(ilp) :: kd, ldab, n
           real(dp) :: amax, scond
           ! .. array arguments ..
           real(dp) :: s(*)
           complex(dp) :: ab(ldab, *)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: thresh = 0.1_dp
           
           ! .. local scalars ..
           integer(ilp) :: i, j
           real(dp) :: cj, large, small
     
           ! .. intrinsic functions ..
           intrinsic :: dble, max, min
           ! .. executable statements ..
           ! quick return if possible
           if (n <= 0) then
              equed = 'n'
              return
           end if
           ! initialize large and small.
           small = stdlib_dlamch('safe minimum')/stdlib_dlamch('precision')
           large = one/small
           if (scond >= thresh .and. amax >= small .and. amax <= large) then
              ! no equilibration
              equed = 'n'
           else
              ! replace a by diag(s) * a * diag(s).
              if (stdlib_lsame(uplo, 'u')) then
                 ! upper triangle of a is stored in band format.
                 do j = 1, n
                    cj = s(j)
                    do i = max(1, j - kd), j - 1
                       ab(kd + 1 + i - j, j) = cj*s(i)*ab(kd + 1 + i - j, j)
                    end do
                    ab(kd + 1, j) = cj*cj*real(ab(kd + 1, j), KIND=dp)
                 end do
              else
                 ! lower triangle of a is stored.
                 do j = 1, n
                    cj = s(j)
                    ab(1, j) = cj*cj*real(ab(1, j), KIND=dp)
                    do i = j + 1, min(n, j + kd)
                       ab(1 + i - j, j) = cj*s(i)*ab(1 + i - j, j)
                    end do
                 end do
              end if
              equed = 'y'
           end if
           return
           ! end of stdlib_zlaqhb
     end subroutine stdlib_zlaqhb

     ! ZLAQHE equilibrates a Hermitian matrix A using the scaling factors
     ! in the vector S.

     subroutine stdlib_zlaqhe(uplo, n, a, lda, s, scond, amax, equed)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: equed, uplo
           integer(ilp) :: lda, n
           real(dp) :: amax, scond
           ! .. array arguments ..
           real(dp) :: s(*)
           complex(dp) :: a(lda, *)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: thresh = 0.1_dp
           
           ! .. local scalars ..
           integer(ilp) :: i, j
           real(dp) :: cj, large, small
     
           ! .. intrinsic functions ..
           intrinsic :: dble
           ! .. executable statements ..
           ! quick return if possible
           if (n <= 0) then
              equed = 'n'
              return
           end if
           ! initialize large and small.
           small = stdlib_dlamch('safe minimum')/stdlib_dlamch('precision')
           large = one/small
           if (scond >= thresh .and. amax >= small .and. amax <= large) then
              ! no equilibration
              equed = 'n'
           else
              ! replace a by diag(s) * a * diag(s).
              if (stdlib_lsame(uplo, 'u')) then
                 ! upper triangle of a is stored.
                 do j = 1, n
                    cj = s(j)
                    do i = 1, j - 1
                       a(i, j) = cj*s(i)*a(i, j)
                    end do
                    a(j, j) = cj*cj*real(a(j, j), KIND=dp)
                 end do
              else
                 ! lower triangle of a is stored.
                 do j = 1, n
                    cj = s(j)
                    a(j, j) = cj*cj*real(a(j, j), KIND=dp)
                    do i = j + 1, n
                       a(i, j) = cj*s(i)*a(i, j)
                    end do
                 end do
              end if
              equed = 'y'
           end if
           return
           ! end of stdlib_zlaqhe
     end subroutine stdlib_zlaqhe

     ! ZLAQHP equilibrates a Hermitian matrix A using the scaling factors
     ! in the vector S.

     subroutine stdlib_zlaqhp(uplo, n, ap, s, scond, amax, equed)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: equed, uplo
           integer(ilp) :: n
           real(dp) :: amax, scond
           ! .. array arguments ..
           real(dp) :: s(*)
           complex(dp) :: ap(*)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: thresh = 0.1_dp
           
           ! .. local scalars ..
           integer(ilp) :: i, j, jc
           real(dp) :: cj, large, small
     
           ! .. intrinsic functions ..
           intrinsic :: dble
           ! .. executable statements ..
           ! quick return if possible
           if (n <= 0) then
              equed = 'n'
              return
           end if
           ! initialize large and small.
           small = stdlib_dlamch('safe minimum')/stdlib_dlamch('precision')
           large = one/small
           if (scond >= thresh .and. amax >= small .and. amax <= large) then
              ! no equilibration
              equed = 'n'
           else
              ! replace a by diag(s) * a * diag(s).
              if (stdlib_lsame(uplo, 'u')) then
                 ! upper triangle of a is stored.
                 jc = 1
                 do j = 1, n
                    cj = s(j)
                    do i = 1, j - 1
                       ap(jc + i - 1) = cj*s(i)*ap(jc + i - 1)
                    end do
                    ap(jc + j - 1) = cj*cj*real(ap(jc + j - 1), KIND=dp)
                    jc = jc + j
                 end do
              else
                 ! lower triangle of a is stored.
                 jc = 1
                 do j = 1, n
                    cj = s(j)
                    ap(jc) = cj*cj*real(ap(jc), KIND=dp)
                    do i = j + 1, n
                       ap(jc + i - j) = cj*s(i)*ap(jc + i - j)
                    end do
                    jc = jc + n - j + 1
                 end do
              end if
              equed = 'y'
           end if
           return
           ! end of stdlib_zlaqhp
     end subroutine stdlib_zlaqhp

     ! Given a 2-by-2 or 3-by-3 matrix H, ZLAQR1 sets v to a
     ! scalar multiple of the first column of the product
     ! (*)  K = (H - s1*I)*(H - s2*I)
     ! scaling to avoid overflows and most underflows.
     ! This is useful for starting double implicit shift bulges
     ! in the QR algorithm.

     subroutine stdlib_zlaqr1(n, h, ldh, s1, s2, v)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           complex(dp) :: s1, s2
           integer(ilp) :: ldh, n
           ! .. array arguments ..
           complex(dp) :: h(ldh, *), v(*)
        ! ================================================================
           ! .. parameters ..
           real(dp), parameter :: rzero = 0.0_dp
           
           ! .. local scalars ..
           complex(dp) :: cdum, h21s, h31s
           real(dp) :: s
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, aimag
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(cdum) = abs(real(cdum, KIND=dp)) + abs(aimag(cdum))
           ! .. executable statements ..
           ! quick return if possible
           if (n /= 2 .and. n /= 3) then
              return
           end if
           if (n == 2) then
              s = cabs1(h(1, 1) - s2) + cabs1(h(2, 1))
              if (s == rzero) then
                 v(1) = czero
                 v(2) = czero
              else
                 h21s = h(2, 1)/s
                 v(1) = h21s*h(1, 2) + (h(1, 1) - s1)*((h(1, 1) - s2)/s)
                 v(2) = h21s*(h(1, 1) + h(2, 2) - s1 - s2)
              end if
           else
              s = cabs1(h(1, 1) - s2) + cabs1(h(2, 1)) + cabs1(h(3, 1))
              if (s == czero) then
                 v(1) = czero
                 v(2) = czero
                 v(3) = czero
              else
                 h21s = h(2, 1)/s
                 h31s = h(3, 1)/s
                 v(1) = (h(1, 1) - s1)*((h(1, 1) - s2)/s) + h(1, 2)*h21s + h(1, 3) &
                           *h31s
                 v(2) = h21s*(h(1, 1) + h(2, 2) - s1 - s2) + h(2, 3)*h31s
                 v(3) = h31s*(h(1, 1) + h(3, 3) - s1 - s2) + h21s*h(3, 2)
              end if
           end if
     end subroutine stdlib_zlaqr1

     ! ZLAQSB equilibrates a symmetric band matrix A using the scaling
     ! factors in the vector S.

     subroutine stdlib_zlaqsb(uplo, n, kd, ab, ldab, s, scond, amax, equed)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: equed, uplo
           integer(ilp) :: kd, ldab, n
           real(dp) :: amax, scond
           ! .. array arguments ..
           real(dp) :: s(*)
           complex(dp) :: ab(ldab, *)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: thresh = 0.1_dp
           
           ! .. local scalars ..
           integer(ilp) :: i, j
           real(dp) :: cj, large, small
     
           ! .. intrinsic functions ..
           intrinsic :: max, min
           ! .. executable statements ..
           ! quick return if possible
           if (n <= 0) then
              equed = 'n'
              return
           end if
           ! initialize large and small.
           small = stdlib_dlamch('safe minimum')/stdlib_dlamch('precision')
           large = one/small
           if (scond >= thresh .and. amax >= small .and. amax <= large) then
              ! no equilibration
              equed = 'n'
           else
              ! replace a by diag(s) * a * diag(s).
              if (stdlib_lsame(uplo, 'u')) then
                 ! upper triangle of a is stored in band format.
                 do j = 1, n
                    cj = s(j)
                    do i = max(1, j - kd), j
                       ab(kd + 1 + i - j, j) = cj*s(i)*ab(kd + 1 + i - j, j)
                    end do
                 end do
              else
                 ! lower triangle of a is stored.
                 do j = 1, n
                    cj = s(j)
                    do i = j, min(n, j + kd)
                       ab(1 + i - j, j) = cj*s(i)*ab(1 + i - j, j)
                    end do
                 end do
              end if
              equed = 'y'
           end if
           return
           ! end of stdlib_zlaqsb
     end subroutine stdlib_zlaqsb

     ! ZLAQSP equilibrates a symmetric matrix A using the scaling factors
     ! in the vector S.

     subroutine stdlib_zlaqsp(uplo, n, ap, s, scond, amax, equed)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: equed, uplo
           integer(ilp) :: n
           real(dp) :: amax, scond
           ! .. array arguments ..
           real(dp) :: s(*)
           complex(dp) :: ap(*)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: thresh = 0.1_dp
           
           ! .. local scalars ..
           integer(ilp) :: i, j, jc
           real(dp) :: cj, large, small
     
           ! .. executable statements ..
           ! quick return if possible
           if (n <= 0) then
              equed = 'n'
              return
           end if
           ! initialize large and small.
           small = stdlib_dlamch('safe minimum')/stdlib_dlamch('precision')
           large = one/small
           if (scond >= thresh .and. amax >= small .and. amax <= large) then
              ! no equilibration
              equed = 'n'
           else
              ! replace a by diag(s) * a * diag(s).
              if (stdlib_lsame(uplo, 'u')) then
                 ! upper triangle of a is stored.
                 jc = 1
                 do j = 1, n
                    cj = s(j)
                    do i = 1, j
                       ap(jc + i - 1) = cj*s(i)*ap(jc + i - 1)
                    end do
                    jc = jc + j
                 end do
              else
                 ! lower triangle of a is stored.
                 jc = 1
                 do j = 1, n
                    cj = s(j)
                    do i = j, n
                       ap(jc + i - j) = cj*s(i)*ap(jc + i - j)
                    end do
                    jc = jc + n - j + 1
                 end do
              end if
              equed = 'y'
           end if
           return
           ! end of stdlib_zlaqsp
     end subroutine stdlib_zlaqsp

     ! ZLAQSY equilibrates a symmetric matrix A using the scaling factors
     ! in the vector S.

     subroutine stdlib_zlaqsy(uplo, n, a, lda, s, scond, amax, equed)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: equed, uplo
           integer(ilp) :: lda, n
           real(dp) :: amax, scond
           ! .. array arguments ..
           real(dp) :: s(*)
           complex(dp) :: a(lda, *)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: thresh = 0.1_dp
           
           ! .. local scalars ..
           integer(ilp) :: i, j
           real(dp) :: cj, large, small
     
           ! .. executable statements ..
           ! quick return if possible
           if (n <= 0) then
              equed = 'n'
              return
           end if
           ! initialize large and small.
           small = stdlib_dlamch('safe minimum')/stdlib_dlamch('precision')
           large = one/small
           if (scond >= thresh .and. amax >= small .and. amax <= large) then
              ! no equilibration
              equed = 'n'
           else
              ! replace a by diag(s) * a * diag(s).
              if (stdlib_lsame(uplo, 'u')) then
                 ! upper triangle of a is stored.
                 do j = 1, n
                    cj = s(j)
                    do i = 1, j
                       a(i, j) = cj*s(i)*a(i, j)
                    end do
                 end do
              else
                 ! lower triangle of a is stored.
                 do j = 1, n
                    cj = s(j)
                    do i = j, n
                       a(i, j) = cj*s(i)*a(i, j)
                    end do
                 end do
              end if
              equed = 'y'
           end if
           return
           ! end of stdlib_zlaqsy
     end subroutine stdlib_zlaqsy

     ! ZLAR1V computes the (scaled) r-th column of the inverse of
     ! the sumbmatrix in rows B1 through BN of the tridiagonal matrix
     ! L D L**T - sigma I. When sigma is close to an eigenvalue, the
     ! computed vector is an accurate eigenvector. Usually, r corresponds
     ! to the index where the eigenvector is largest in magnitude.
     ! The following steps accomplish this computation :
     ! (a) Stationary qd transform,  L D L**T - sigma I = L(+) D(+) L(+)**T,
     ! (b) Progressive qd transform, L D L**T - sigma I = U(-) D(-) U(-)**T,
     ! (c) Computation of the diagonal elements of the inverse of
     ! L D L**T - sigma I by combining the above transforms, and choosing
     ! r as the index where the diagonal of the inverse is (one of the)
     ! largest in magnitude.
     ! (d) Computation of the (scaled) r-th column of the inverse using the
     ! twisted factorization obtained by combining the top part of the
     ! the stationary and the bottom part of the progressive transform.

     subroutine stdlib_zlar1v(n, b1, bn, lambda, d, l, ld, lld, pivmin, gaptol, z, wantnc, negcnt, &
                ztz, mingma, r, isuppz, nrminv, resid, rqcorr, work)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           logical(lk) :: wantnc
           integer(ilp) :: b1, bn, n, negcnt, r
           real(dp) :: gaptol, lambda, mingma, nrminv, pivmin, resid, rqcorr, ztz
           ! .. array arguments ..
           integer(ilp) :: isuppz(*)
           real(dp) :: d(*), l(*), ld(*), lld(*), work(*)
           complex(dp) :: z(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: sawnan1, sawnan2
           integer(ilp) :: i, indlpl, indp, inds, indumn, neg1, neg2, r1, r2
           real(dp) :: dminus, dplus, eps, s, tmp
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble
           ! .. executable statements ..
           eps = stdlib_dlamch('precision')
           if (r == 0) then
              r1 = b1
              r2 = bn
           else
              r1 = r
              r2 = r
           end if
           ! storage for lplus
           indlpl = 0
           ! storage for uminus
           indumn = n
           inds = 2*n + 1
           indp = 3*n + 1
           if (b1 == 1) then
              work(inds) = zero
           else
              work(inds + b1 - 1) = lld(b1 - 1)
           end if
           ! compute the stationary transform (using the differential form)
           ! until the index r2.
           sawnan1 = .false.
           neg1 = 0
           s = work(inds + b1 - 1) - lambda
           do i = b1, r1 - 1
              dplus = d(i) + s
              work(indlpl + i) = ld(i)/dplus
              if (dplus < zero) neg1 = neg1 + 1
              work(inds + i) = s*work(indlpl + i)*l(i)
              s = work(inds + i) - lambda
           end do
           sawnan1 = stdlib_disnan(s)
           if (sawnan1) goto 60
           do i = r1, r2 - 1
              dplus = d(i) + s
              work(indlpl + i) = ld(i)/dplus
              work(inds + i) = s*work(indlpl + i)*l(i)
              s = work(inds + i) - lambda
           end do
           sawnan1 = stdlib_disnan(s)
60    continue
           if (sawnan1) then
              ! runs a slower version of the above loop if a nan is detected
              neg1 = 0
              s = work(inds + b1 - 1) - lambda
              do i = b1, r1 - 1
                 dplus = d(i) + s
                 if (abs(dplus) < pivmin) dplus = -pivmin
                 work(indlpl + i) = ld(i)/dplus
                 if (dplus < zero) neg1 = neg1 + 1
                 work(inds + i) = s*work(indlpl + i)*l(i)
                 if (work(indlpl + i) == zero) work(inds + i) = lld(i)
                 s = work(inds + i) - lambda
              end do
              do i = r1, r2 - 1
                 dplus = d(i) + s
                 if (abs(dplus) < pivmin) dplus = -pivmin
                 work(indlpl + i) = ld(i)/dplus
                 work(inds + i) = s*work(indlpl + i)*l(i)
                 if (work(indlpl + i) == zero) work(inds + i) = lld(i)
                 s = work(inds + i) - lambda
              end do
           end if
           ! compute the progressive transform (using the differential form)
           ! until the index r1
           sawnan2 = .false.
           neg2 = 0
           work(indp + bn - 1) = d(bn) - lambda
           do i = bn - 1, r1, -1
              dminus = lld(i) + work(indp + i)
              tmp = d(i)/dminus
              if (dminus < zero) neg2 = neg2 + 1
              work(indumn + i) = l(i)*tmp
              work(indp + i - 1) = work(indp + i)*tmp - lambda
           end do
           tmp = work(indp + r1 - 1)
           sawnan2 = stdlib_disnan(tmp)
           if (sawnan2) then
              ! runs a slower version of the above loop if a nan is detected
              neg2 = 0
              do i = bn - 1, r1, -1
                 dminus = lld(i) + work(indp + i)
                 if (abs(dminus) < pivmin) dminus = -pivmin
                 tmp = d(i)/dminus
                 if (dminus < zero) neg2 = neg2 + 1
                 work(indumn + i) = l(i)*tmp
                 work(indp + i - 1) = work(indp + i)*tmp - lambda
                 if (tmp == zero) work(indp + i - 1) = d(i) - lambda
              end do
           end if
           ! find the index (from r1 to r2) of the largest (in magnitude)
           ! diagonal element of the inverse
           mingma = work(inds + r1 - 1) + work(indp + r1 - 1)
           if (mingma < zero) neg1 = neg1 + 1
           if (wantnc) then
              negcnt = neg1 + neg2
           else
              negcnt = -1
           end if
           if (abs(mingma) == zero) mingma = eps*work(inds + r1 - 1)
           r = r1
           do i = r1, r2 - 1
              tmp = work(inds + i) + work(indp + i)
              if (tmp == zero) tmp = eps*work(inds + i)
              if (abs(tmp) <= abs(mingma)) then
                 mingma = tmp
                 r = i + 1
              end if
           end do
           ! compute the fp vector: solve n^t v = e_r
           isuppz(1) = b1
           isuppz(2) = bn
           z(r) = cone
           ztz = one
           ! compute the fp vector upwards from r
           if (.not. sawnan1 .and. .not. sawnan2) then
              do i = r - 1, b1, -1
                 z(i) = -(work(indlpl + i)*z(i + 1))
                 if ((abs(z(i)) + abs(z(i + 1)))*abs(ld(i)) < gaptol) then
                    z(i) = zero
                    isuppz(1) = i + 1
                    goto 220
                 end if
                 ztz = ztz + dble(z(i)*z(i))
              end do
220   continue
           else
              ! run slower loop if nan occurred.
              do i = r - 1, b1, -1
                 if (z(i + 1) == zero) then
                    z(i) = -(ld(i + 1)/ld(i))*z(i + 2)
                 else
                    z(i) = -(work(indlpl + i)*z(i + 1))
                 end if
                 if ((abs(z(i)) + abs(z(i + 1)))*abs(ld(i)) < gaptol) then
                    z(i) = zero
                    isuppz(1) = i + 1
                    go to 240
                 end if
                 ztz = ztz + dble(z(i)*z(i))
              end do
240   continue
           end if
           ! compute the fp vector downwards from r in blocks of size blksiz
           if (.not. sawnan1 .and. .not. sawnan2) then
              do i = r, bn - 1
                 z(i + 1) = -(work(indumn + i)*z(i))
                 if ((abs(z(i)) + abs(z(i + 1)))*abs(ld(i)) < gaptol) then
                    z(i + 1) = zero
                    isuppz(2) = i
                    go to 260
                 end if
                 ztz = ztz + dble(z(i + 1)*z(i + 1))
              end do
260   continue
           else
              ! run slower loop if nan occurred.
              do i = r, bn - 1
                 if (z(i) == zero) then
                    z(i + 1) = -(ld(i - 1)/ld(i))*z(i - 1)
                 else
                    z(i + 1) = -(work(indumn + i)*z(i))
                 end if
                 if ((abs(z(i)) + abs(z(i + 1)))*abs(ld(i)) < gaptol) then
                    z(i + 1) = zero
                    isuppz(2) = i
                    go to 280
                 end if
                 ztz = ztz + dble(z(i + 1)*z(i + 1))
              end do
280   continue
           end if
           ! compute quantities for convergence test
           tmp = one/ztz
           nrminv = sqrt(tmp)
           resid = abs(mingma)*nrminv
           rqcorr = mingma*tmp
           return
           ! end of stdlib_zlar1v
     end subroutine stdlib_zlar1v

     ! ZLAR2V applies a vector of complex plane rotations with real cosines
     ! from both sides to a sequence of 2-by-2 complex Hermitian matrices,
     ! defined by the elements of the vectors x, y and z. For i = 1,2,...,n
     ! (       x(i)  z(i) ) :=
     ! ( conjg(z(i)) y(i) )
     ! (  c(i) conjg(s(i)) ) (       x(i)  z(i) ) ( c(i) -conjg(s(i)) )
     ! ( -s(i)       c(i)  ) ( conjg(z(i)) y(i) ) ( s(i)        c(i)  )

     subroutine stdlib_zlar2v(n, x, y, z, incx, c, s, incc)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: incc, incx, n
           ! .. array arguments ..
           real(dp) :: c(*)
           complex(dp) :: s(*), x(*), y(*), z(*)
        ! =====================================================================
           ! .. local scalars ..
           integer(ilp) :: i, ic, ix
           real(dp) :: ci, sii, sir, t1i, t1r, t5, t6, xi, yi, zii, zir
           complex(dp) :: si, t2, t3, t4, zi
           ! .. intrinsic functions ..
           intrinsic :: dble, dcmplx, conjg, aimag
           ! .. executable statements ..
           ix = 1
           ic = 1
           do i = 1, n
              xi = real(x(ix), KIND=dp)
              yi = real(y(ix), KIND=dp)
              zi = z(ix)
              zir = real(zi, KIND=dp)
              zii = aimag(zi)
              ci = c(ic)
              si = s(ic)
              sir = real(si, KIND=dp)
              sii = aimag(si)
              t1r = sir*zir - sii*zii
              t1i = sir*zii + sii*zir
              t2 = ci*zi
              t3 = t2 - conjg(si)*xi
              t4 = conjg(t2) + si*yi
              t5 = ci*xi + t1r
              t6 = ci*yi - t1r
              x(ix) = ci*t5 + (sir*real(t4, KIND=dp) + sii*aimag(t4))
              y(ix) = ci*t6 - (sir*real(t3, KIND=dp) - sii*aimag(t3))
              z(ix) = ci*t3 + conjg(si)*cmplx(t6, t1i, KIND=dp)
              ix = ix + incx
              ic = ic + incc
           end do
           return
           ! end of stdlib_zlar2v
     end subroutine stdlib_zlar2v

     ! ZLARCM performs a very simple matrix-matrix multiplication:
     ! C := A * B,
     ! where A is M by M and real; B is M by N and complex;
     ! C is M by N and complex.

     subroutine stdlib_zlarcm(m, n, a, lda, b, ldb, c, ldc, rwork)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: lda, ldb, ldc, m, n
           ! .. array arguments ..
           real(dp) :: a(lda, *), rwork(*)
           complex(dp) :: b(ldb, *), c(ldc, *)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i, j, l
           ! .. intrinsic functions ..
           intrinsic :: dble, dcmplx, aimag
     
           ! .. executable statements ..
           ! quick return if possible.
           if ((m == 0) .or. (n == 0)) return
           do j = 1, n
              do i = 1, m
                 rwork((j - 1)*m + i) = real(b(i, j), KIND=dp)
              end do
           end do
           l = m*n + 1
           call stdlib_dgemm('n', 'n', m, n, m, one, a, lda, rwork, m, zero, rwork(l), m)
                     
           do j = 1, n
              do i = 1, m
                 c(i, j) = rwork(l + (j - 1)*m + i - 1)
              end do
           end do
           do j = 1, n
              do i = 1, m
                 rwork((j - 1)*m + i) = aimag(b(i, j))
              end do
           end do
           call stdlib_dgemm('n', 'n', m, n, m, one, a, lda, rwork, m, zero, rwork(l), m)
                     
           do j = 1, n
              do i = 1, m
                 c(i, j) = dcmplx(real(c(i, j), KIND=dp), rwork(l + (j - 1)*m + i - 1))
              end do
           end do
           return
           ! end of stdlib_zlarcm
     end subroutine stdlib_zlarcm

     ! ZLARF applies a complex elementary reflector H to a complex M-by-N
     ! matrix C, from either the left or the right. H is represented in the
     ! form
     ! H = I - tau * v * v**H
     ! where tau is a complex scalar and v is a complex vector.
     ! If tau = 0, then H is taken to be the unit matrix.
     ! To apply H**H, supply conjg(tau) instead
     ! tau.

     subroutine stdlib_zlarf(side, m, n, v, incv, tau, c, ldc, work)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: side
           integer(ilp) :: incv, ldc, m, n
           complex(dp) :: tau
           ! .. array arguments ..
           complex(dp) :: c(ldc, *), v(*), work(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: applyleft
           integer(ilp) :: i, lastv, lastc
     
           ! .. executable statements ..
           applyleft = stdlib_lsame(side, 'l')
           lastv = 0
           lastc = 0
           if (tau /= czero) then
           ! set up variables for scanning v.  lastv begins pointing to the end
           ! of v.
              if (applyleft) then
                 lastv = m
              else
                 lastv = n
              end if
              if (incv > 0) then
                 i = 1 + (lastv - 1)*incv
              else
                 i = 1
              end if
           ! look for the last non-czero row in v.
              do while (lastv > 0 .and. v(i) == czero)
                 lastv = lastv - 1
                 i = i - incv
              end do
              if (applyleft) then
           ! scan for the last non-czero column in c(1:lastv,:).
                 lastc = stdlib_ilazlc(lastv, n, c, ldc)
              else
           ! scan for the last non-czero row in c(:,1:lastv).
                 lastc = stdlib_ilazlr(m, lastv, c, ldc)
              end if
           end if
           ! note that lastc.eq.0 renders the blas operations null; no special
           ! case is needed at this level.
           if (applyleft) then
              ! form  h * c
              if (lastv > 0) then
                 ! w(1:lastc,1) := c(1:lastv,1:lastc)**h * v(1:lastv,1)
                 call stdlib_zgemv('conjugate transpose', lastv, lastc, cone, c, ldc, v, incv, &
                           czero, work, 1)
                 ! c(1:lastv,1:lastc) := c(...) - v(1:lastv,1) * w(1:lastc,1)**h
                 call stdlib_zgerc(lastv, lastc, -tau, v, incv, work, 1, c, ldc)
              end if
           else
              ! form  c * h
              if (lastv > 0) then
                 ! w(1:lastc,1) := c(1:lastc,1:lastv) * v(1:lastv,1)
                 call stdlib_zgemv('no transpose', lastc, lastv, cone, c, ldc, v, incv, czero, &
                           work, 1)
                 ! c(1:lastc,1:lastv) := c(...) - w(1:lastc,1) * v(1:lastv,1)**h
                 call stdlib_zgerc(lastc, lastv, -tau, work, 1, v, incv, c, ldc)
              end if
           end if
           return
           ! end of stdlib_zlarf
     end subroutine stdlib_zlarf

     ! ZLARFB applies a complex block reflector H or its transpose H**H to a
     ! complex M-by-N matrix C, from either the left or the right.

     subroutine stdlib_zlarfb(side, trans, direct, storev, m, n, k, v, ldv, t, ldt, c, ldc, work, &
               ldwork)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: direct, side, storev, trans
           integer(ilp) :: k, ldc, ldt, ldv, ldwork, m, n
           ! .. array arguments ..
           complex(dp) :: c(ldc, *), t(ldt, *), v(ldv, *), work(ldwork, *)
        ! =====================================================================
           
           ! .. local scalars ..
           character :: transt
           integer(ilp) :: i, j
     
           ! .. intrinsic functions ..
           intrinsic :: conjg
           ! .. executable statements ..
           ! quick return if possible
           if (m <= 0 .or. n <= 0) return
           if (stdlib_lsame(trans, 'n')) then
              transt = 'c'
           else
              transt = 'n'
           end if
           if (stdlib_lsame(storev, 'c')) then
              if (stdlib_lsame(direct, 'f')) then
                 ! let  v =  ( v1 )    (first k rows)
                           ! ( v2 )
                 ! where  v1  is unit lower triangular.
                 if (stdlib_lsame(side, 'l')) then
                    ! form  h * c  or  h**h * c  where  c = ( c1 )
                                                          ! ( c2 )
                    ! w := c**h * v  =  (c1**h * v1 + c2**h * v2)  (stored in work)
                    ! w := c1**h
                    do j = 1, k
                       call stdlib_zcopy(n, c(j, 1), ldc, work(1, j), 1)
                       call stdlib_zlacgv(n, work(1, j), 1)
                    end do
                    ! w := w * v1
                    call stdlib_ztrmm('right', 'lower', 'no transpose', 'unit', n, k, cone, v, &
                              ldv, work, ldwork)
                    if (m > k) then
                       ! w := w + c2**h * v2
                       call stdlib_zgemm('conjugate transpose', 'no transpose', n, k, m - k, cone, &
                                 c(k + 1, 1), ldc, v(k + 1, 1), ldv, cone, work, ldwork)
                    end if
                    ! w := w * t**h  or  w * t
                    call stdlib_ztrmm('right', 'upper', transt, 'non-unit', n, k, cone, t, ldt, &
                              work, ldwork)
                    ! c := c - v * w**h
                    if (m > k) then
                       ! c2 := c2 - v2 * w**h
                       call stdlib_zgemm('no transpose', 'conjugate transpose', m - k, n, k, -cone, &
                                 v(k + 1, 1), ldv, work, ldwork, cone, c(k + 1, 1), ldc)
                    end if
                    ! w := w * v1**h
                    call stdlib_ztrmm('right', 'lower', 'conjugate transpose', 'unit', n, k, cone, &
                               v, ldv, work, ldwork)
                    ! c1 := c1 - w**h
                    do j = 1, k
                       do i = 1, n
                          c(j, i) = c(j, i) - conjg(work(i, j))
                       end do
                    end do
                 else if (stdlib_lsame(side, 'r')) then
                    ! form  c * h  or  c * h**h  where  c = ( c1  c2 )
                    ! w := c * v  =  (c1*v1 + c2*v2)  (stored in work)
                    ! w := c1
                    do j = 1, k
                       call stdlib_zcopy(m, c(1, j), 1, work(1, j), 1)
                    end do
                    ! w := w * v1
                    call stdlib_ztrmm('right', 'lower', 'no transpose', 'unit', m, k, cone, v, &
                              ldv, work, ldwork)
                    if (n > k) then
                       ! w := w + c2 * v2
                       call stdlib_zgemm('no transpose', 'no transpose', m, k, n - k, cone, c(1, k + &
                                 1), ldc, v(k + 1, 1), ldv, cone, work, ldwork)
                    end if
                    ! w := w * t  or  w * t**h
                    call stdlib_ztrmm('right', 'upper', trans, 'non-unit', m, k, cone, t, ldt, &
                              work, ldwork)
                    ! c := c - w * v**h
                    if (n > k) then
                       ! c2 := c2 - w * v2**h
                       call stdlib_zgemm('no transpose', 'conjugate transpose', m, n - k, k, -cone, &
                                 work, ldwork, v(k + 1, 1), ldv, cone, c(1, k + 1), ldc)
                    end if
                    ! w := w * v1**h
                    call stdlib_ztrmm('right', 'lower', 'conjugate transpose', 'unit', m, k, cone, &
                               v, ldv, work, ldwork)
                    ! c1 := c1 - w
                    do j = 1, k
                       do i = 1, m
                          c(i, j) = c(i, j) - work(i, j)
                       end do
                    end do
                 end if
              else
                 ! let  v =  ( v1 )
                           ! ( v2 )    (last k rows)
                 ! where  v2  is unit upper triangular.
                 if (stdlib_lsame(side, 'l')) then
                    ! form  h * c  or  h**h * c  where  c = ( c1 )
                                                          ! ( c2 )
                    ! w := c**h * v  =  (c1**h * v1 + c2**h * v2)  (stored in work)
                    ! w := c2**h
                    do j = 1, k
                       call stdlib_zcopy(n, c(m - k + j, 1), ldc, work(1, j), 1)
                       call stdlib_zlacgv(n, work(1, j), 1)
                    end do
                    ! w := w * v2
                    call stdlib_ztrmm('right', 'upper', 'no transpose', 'unit', n, k, cone, v(m - &
                              k + 1, 1), ldv, work, ldwork)
                    if (m > k) then
                       ! w := w + c1**h * v1
                       call stdlib_zgemm('conjugate transpose', 'no transpose', n, k, m - k, cone, &
                                 c, ldc, v, ldv, cone, work, ldwork)
                    end if
                    ! w := w * t**h  or  w * t
                    call stdlib_ztrmm('right', 'lower', transt, 'non-unit', n, k, cone, t, ldt, &
                              work, ldwork)
                    ! c := c - v * w**h
                    if (m > k) then
                       ! c1 := c1 - v1 * w**h
                       call stdlib_zgemm('no transpose', 'conjugate transpose', m - k, n, k, -cone, &
                                 v, ldv, work, ldwork, cone, c, ldc)
                    end if
                    ! w := w * v2**h
                    call stdlib_ztrmm('right', 'upper', 'conjugate transpose', 'unit', n, k, cone, &
                               v(m - k + 1, 1), ldv, work, ldwork)
                    ! c2 := c2 - w**h
                    do j = 1, k
                       do i = 1, n
                          c(m - k + j, i) = c(m - k + j, i) - conjg(work(i, j))
                       end do
                    end do
                 else if (stdlib_lsame(side, 'r')) then
                    ! form  c * h  or  c * h**h  where  c = ( c1  c2 )
                    ! w := c * v  =  (c1*v1 + c2*v2)  (stored in work)
                    ! w := c2
                    do j = 1, k
                       call stdlib_zcopy(m, c(1, n - k + j), 1, work(1, j), 1)
                    end do
                    ! w := w * v2
                    call stdlib_ztrmm('right', 'upper', 'no transpose', 'unit', m, k, cone, v(n - &
                              k + 1, 1), ldv, work, ldwork)
                    if (n > k) then
                       ! w := w + c1 * v1
                       call stdlib_zgemm('no transpose', 'no transpose', m, k, n - k, cone, c, ldc, &
                                 v, ldv, cone, work, ldwork)
                    end if
                    ! w := w * t  or  w * t**h
                    call stdlib_ztrmm('right', 'lower', trans, 'non-unit', m, k, cone, t, ldt, &
                              work, ldwork)
                    ! c := c - w * v**h
                    if (n > k) then
                       ! c1 := c1 - w * v1**h
                       call stdlib_zgemm('no transpose', 'conjugate transpose', m, n - k, k, -cone, &
                                 work, ldwork, v, ldv, cone, c, ldc)
                    end if
                    ! w := w * v2**h
                    call stdlib_ztrmm('right', 'upper', 'conjugate transpose', 'unit', m, k, cone, &
                               v(n - k + 1, 1), ldv, work, ldwork)
                    ! c2 := c2 - w
                    do j = 1, k
                       do i = 1, m
                          c(i, n - k + j) = c(i, n - k + j) - work(i, j)
                       end do
                    end do
                 end if
              end if
           else if (stdlib_lsame(storev, 'r')) then
              if (stdlib_lsame(direct, 'f')) then
                 ! let  v =  ( v1  v2 )    (v1: first k columns)
                 ! where  v1  is unit upper triangular.
                 if (stdlib_lsame(side, 'l')) then
                    ! form  h * c  or  h**h * c  where  c = ( c1 )
                                                          ! ( c2 )
                    ! w := c**h * v**h  =  (c1**h * v1**h + c2**h * v2**h) (stored in work)
                    ! w := c1**h
                    do j = 1, k
                       call stdlib_zcopy(n, c(j, 1), ldc, work(1, j), 1)
                       call stdlib_zlacgv(n, work(1, j), 1)
                    end do
                    ! w := w * v1**h
                    call stdlib_ztrmm('right', 'upper', 'conjugate transpose', 'unit', n, k, cone, &
                               v, ldv, work, ldwork)
                    if (m > k) then
                       ! w := w + c2**h * v2**h
                       call stdlib_zgemm('conjugate transpose', 'conjugate transpose', n, k, m - k, &
                                 cone, c(k + 1, 1), ldc, v(1, k + 1), ldv, cone, work, ldwork)
                    end if
                    ! w := w * t**h  or  w * t
                    call stdlib_ztrmm('right', 'upper', transt, 'non-unit', n, k, cone, t, ldt, &
                              work, ldwork)
                    ! c := c - v**h * w**h
                    if (m > k) then
                       ! c2 := c2 - v2**h * w**h
                       call stdlib_zgemm('conjugate transpose', 'conjugate transpose', m - k, n, k, &
                                 -cone, v(1, k + 1), ldv, work, ldwork, cone, c(k + 1, 1), ldc)
                    end if
                    ! w := w * v1
                    call stdlib_ztrmm('right', 'upper', 'no transpose', 'unit', n, k, cone, v, &
                              ldv, work, ldwork)
                    ! c1 := c1 - w**h
                    do j = 1, k
                       do i = 1, n
                          c(j, i) = c(j, i) - conjg(work(i, j))
                       end do
                    end do
                 else if (stdlib_lsame(side, 'r')) then
                    ! form  c * h  or  c * h**h  where  c = ( c1  c2 )
                    ! w := c * v**h  =  (c1*v1**h + c2*v2**h)  (stored in work)
                    ! w := c1
                    do j = 1, k
                       call stdlib_zcopy(m, c(1, j), 1, work(1, j), 1)
                    end do
                    ! w := w * v1**h
                    call stdlib_ztrmm('right', 'upper', 'conjugate transpose', 'unit', m, k, cone, &
                               v, ldv, work, ldwork)
                    if (n > k) then
                       ! w := w + c2 * v2**h
                       call stdlib_zgemm('no transpose', 'conjugate transpose', m, k, n - k, cone, &
                                 c(1, k + 1), ldc, v(1, k + 1), ldv, cone, work, ldwork)
                    end if
                    ! w := w * t  or  w * t**h
                    call stdlib_ztrmm('right', 'upper', trans, 'non-unit', m, k, cone, t, ldt, &
                              work, ldwork)
                    ! c := c - w * v
                    if (n > k) then
                       ! c2 := c2 - w * v2
                       call stdlib_zgemm('no transpose', 'no transpose', m, n - k, k, -cone, work, &
                                 ldwork, v(1, k + 1), ldv, cone, c(1, k + 1), ldc)
                    end if
                    ! w := w * v1
                    call stdlib_ztrmm('right', 'upper', 'no transpose', 'unit', m, k, cone, v, &
                              ldv, work, ldwork)
                    ! c1 := c1 - w
                    do j = 1, k
                       do i = 1, m
                          c(i, j) = c(i, j) - work(i, j)
                       end do
                    end do
                 end if
              else
                 ! let  v =  ( v1  v2 )    (v2: last k columns)
                 ! where  v2  is unit lower triangular.
                 if (stdlib_lsame(side, 'l')) then
                    ! form  h * c  or  h**h * c  where  c = ( c1 )
                                                          ! ( c2 )
                    ! w := c**h * v**h  =  (c1**h * v1**h + c2**h * v2**h) (stored in work)
                    ! w := c2**h
                    do j = 1, k
                       call stdlib_zcopy(n, c(m - k + j, 1), ldc, work(1, j), 1)
                       call stdlib_zlacgv(n, work(1, j), 1)
                    end do
                    ! w := w * v2**h
                    call stdlib_ztrmm('right', 'lower', 'conjugate transpose', 'unit', n, k, cone, &
                               v(1, m - k + 1), ldv, work, ldwork)
                    if (m > k) then
                       ! w := w + c1**h * v1**h
                       call stdlib_zgemm('conjugate transpose', 'conjugate transpose', n, k, m - k, &
                                 cone, c, ldc, v, ldv, cone, work, ldwork)
                    end if
                    ! w := w * t**h  or  w * t
                    call stdlib_ztrmm('right', 'lower', transt, 'non-unit', n, k, cone, t, ldt, &
                              work, ldwork)
                    ! c := c - v**h * w**h
                    if (m > k) then
                       ! c1 := c1 - v1**h * w**h
                       call stdlib_zgemm('conjugate transpose', 'conjugate transpose', m - k, n, k, &
                                 -cone, v, ldv, work, ldwork, cone, c, ldc)
                    end if
                    ! w := w * v2
                    call stdlib_ztrmm('right', 'lower', 'no transpose', 'unit', n, k, cone, v(1, &
                              m - k + 1), ldv, work, ldwork)
                    ! c2 := c2 - w**h
                    do j = 1, k
                       do i = 1, n
                          c(m - k + j, i) = c(m - k + j, i) - conjg(work(i, j))
                       end do
                    end do
                 else if (stdlib_lsame(side, 'r')) then
                    ! form  c * h  or  c * h**h  where  c = ( c1  c2 )
                    ! w := c * v**h  =  (c1*v1**h + c2*v2**h)  (stored in work)
                    ! w := c2
                    do j = 1, k
                       call stdlib_zcopy(m, c(1, n - k + j), 1, work(1, j), 1)
                    end do
                    ! w := w * v2**h
                    call stdlib_ztrmm('right', 'lower', 'conjugate transpose', 'unit', m, k, cone, &
                               v(1, n - k + 1), ldv, work, ldwork)
                    if (n > k) then
                       ! w := w + c1 * v1**h
                       call stdlib_zgemm('no transpose', 'conjugate transpose', m, k, n - k, cone, &
                                 c, ldc, v, ldv, cone, work, ldwork)
                    end if
                    ! w := w * t  or  w * t**h
                    call stdlib_ztrmm('right', 'lower', trans, 'non-unit', m, k, cone, t, ldt, &
                              work, ldwork)
                    ! c := c - w * v
                    if (n > k) then
                       ! c1 := c1 - w * v1
                       call stdlib_zgemm('no transpose', 'no transpose', m, n - k, k, -cone, work, &
                                 ldwork, v, ldv, cone, c, ldc)
                    end if
                    ! w := w * v2
                    call stdlib_ztrmm('right', 'lower', 'no transpose', 'unit', m, k, cone, v(1, &
                              n - k + 1), ldv, work, ldwork)
                    ! c1 := c1 - w
                    do j = 1, k
                       do i = 1, m
                          c(i, n - k + j) = c(i, n - k + j) - work(i, j)
                       end do
                    end do
                 end if
              end if
           end if
           return
           ! end of stdlib_zlarfb
     end subroutine stdlib_zlarfb

     ! ZLARFB_GETT applies a complex Householder block reflector H from the
     ! left to a complex (K+M)-by-N  "triangular-pentagonal" matrix
     ! composed of two block matrices: an upper trapezoidal K-by-N matrix A
     ! stored in the array A, and a rectangular M-by-(N-K) matrix B, stored
     ! in the array B. The block reflector H is stored in a compact
     ! WY-representation, where the elementary reflectors are in the
     ! arrays A, B and T. See Further Details section.

     subroutine stdlib_zlarfb_gett(ident, m, n, k, t, ldt, a, lda, b, ldb, work, ldwork)
     
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: ident
           integer(ilp) :: k, lda, ldb, ldt, ldwork, m, n
           ! .. array arguments ..
           complex(dp) :: a(lda, *), b(ldb, *), t(ldt, *), work(ldwork, *)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: lnotident
           integer(ilp) :: i, j
     
           ! .. executable statements ..
           ! quick return if possible
           if (m < 0 .or. n <= 0 .or. k == 0 .or. k > n) return
           lnotident = .not. stdlib_lsame(ident, 'i')
           ! ------------------------------------------------------------------
           ! first step. computation of the column block 2:
              ! ( a2 ) := h * ( a2 )
              ! ( b2 )        ( b2 )
           ! ------------------------------------------------------------------
           if (n > k) then
              ! col2_(1) compute w2: = a2. therefore, copy a2 = a(1:k, k+1:n)
              ! into w2=work(1:k, 1:n-k) column-by-column.
              do j = 1, n - k
                 call stdlib_zcopy(k, a(1, k + j), 1, work(1, j), 1)
              end do
              if (lnotident) then
                 ! col2_(2) compute w2: = (v1**h) * w2 = (a1**h) * w2,
                 ! v1 is not an identy matrix, but unit lower-triangular
                 ! v1 stored in a1 (diagonal ones are not stored).
                 call stdlib_ztrmm('l', 'l', 'c', 'u', k, n - k, cone, a, lda, work, ldwork)
                           
              end if
              ! col2_(3) compute w2: = w2 + (v2**h) * b2 = w2 + (b1**h) * b2
              ! v2 stored in b1.
              if (m > 0) then
                 call stdlib_zgemm('c', 'n', k, n - k, m, cone, b, ldb, b(1, k + 1), ldb, cone, &
                           work, ldwork)
              end if
              ! col2_(4) compute w2: = t * w2,
              ! t is upper-triangular.
              call stdlib_ztrmm('l', 'u', 'n', 'n', k, n - k, cone, t, ldt, work, ldwork)
              ! col2_(5) compute b2: = b2 - v2 * w2 = b2 - b1 * w2,
              ! v2 stored in b1.
              if (m > 0) then
                 call stdlib_zgemm('n', 'n', m, n - k, k, -cone, b, ldb, work, ldwork, cone, b(1, &
                           k + 1), ldb)
              end if
              if (lnotident) then
                 ! col2_(6) compute w2: = v1 * w2 = a1 * w2,
                 ! v1 is not an identity matrix, but unit lower-triangular,
                 ! v1 stored in a1 (diagonal ones are not stored).
                 call stdlib_ztrmm('l', 'l', 'n', 'u', k, n - k, cone, a, lda, work, ldwork)
                           
              end if
              ! col2_(7) compute a2: = a2 - w2 =
                                   ! = a(1:k, k+1:n-k) - work(1:k, 1:n-k),
              ! column-by-column.
              do j = 1, n - k
                 do i = 1, k
                    a(i, k + j) = a(i, k + j) - work(i, j)
                 end do
              end do
           end if
           ! ------------------------------------------------------------------
           ! second step. computation of the column block 1:
              ! ( a1 ) := h * ( a1 )
              ! ( b1 )        (  0 )
           ! ------------------------------------------------------------------
           ! col1_(1) compute w1: = a1. copy the upper-triangular
           ! a1 = a(1:k, 1:k) into the upper-triangular
           ! w1 = work(1:k, 1:k) column-by-column.
           do j = 1, k
              call stdlib_zcopy(j, a(1, j), 1, work(1, j), 1)
           end do
           ! set the subdiagonal elements of w1 to zero column-by-column.
           do j = 1, k - 1
              do i = j + 1, k
                 work(i, j) = czero
              end do
           end do
           if (lnotident) then
              ! col1_(2) compute w1: = (v1**h) * w1 = (a1**h) * w1,
              ! v1 is not an identity matrix, but unit lower-triangular
              ! v1 stored in a1 (diagonal ones are not stored),
              ! w1 is upper-triangular with zeroes below the diagonal.
              call stdlib_ztrmm('l', 'l', 'c', 'u', k, k, cone, a, lda, work, ldwork)
           end if
           ! col1_(3) compute w1: = t * w1,
           ! t is upper-triangular,
           ! w1 is upper-triangular with zeroes below the diagonal.
           call stdlib_ztrmm('l', 'u', 'n', 'n', k, k, cone, t, ldt, work, ldwork)
           ! col1_(4) compute b1: = - v2 * w1 = - b1 * w1,
           ! v2 = b1, w1 is upper-triangular with zeroes below the diagonal.
           if (m > 0) then
              call stdlib_ztrmm('r', 'u', 'n', 'n', m, k, -cone, work, ldwork, b, ldb)
           end if
           if (lnotident) then
              ! col1_(5) compute w1: = v1 * w1 = a1 * w1,
              ! v1 is not an identity matrix, but unit lower-triangular
              ! v1 stored in a1 (diagonal ones are not stored),
              ! w1 is upper-triangular on input with zeroes below the diagonal,
              ! and square on output.
              call stdlib_ztrmm('l', 'l', 'n', 'u', k, k, cone, a, lda, work, ldwork)
              ! col1_(6) compute a1: = a1 - w1 = a(1:k, 1:k) - work(1:k, 1:k)
              ! column-by-column. a1 is upper-triangular on input.
              ! if ident, a1 is square on output, and w1 is square,
              ! if not ident, a1 is upper-triangular on output,
              ! w1 is upper-triangular.
              ! col1_(6)_a compute elements of a1 below the diagonal.
              do j = 1, k - 1
                 do i = j + 1, k
                    a(i, j) = -work(i, j)
                 end do
              end do
           end if
           ! col1_(6)_b compute elements of a1 on and above the diagonal.
           do j = 1, k
              do i = 1, j
                 a(i, j) = a(i, j) - work(i, j)
              end do
           end do
           return
           ! end of stdlib_zlarfb_gett
     end subroutine stdlib_zlarfb_gett

     ! ZLARFG generates a complex elementary reflector H of order n, such
     ! that
     ! H**H * ( alpha ) = ( beta ),   H**H * H = I.
     ! (   x   )   (   0  )
     ! where alpha and beta are scalars, with beta real, and x is an
     ! (n-1)-element complex vector. H is represented in the form
     ! H = I - tau * ( 1 ) * ( 1 v**H ) ,
     ! ( v )
     ! where tau is a complex scalar and v is a complex (n-1)-element
     ! vector. Note that H is not hermitian.
     ! If the elements of x are all zero and alpha is real, then tau = 0
     ! and H is taken to be the unit matrix.
     ! Otherwise  1 <= real(tau) <= 2  and  abs(tau-1) <= 1 .

     subroutine stdlib_zlarfg(n, alpha, x, incx, tau)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: incx, n
           complex(dp) :: alpha, tau
           ! .. array arguments ..
           complex(dp) :: x(*)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: j, knt
           real(dp) :: alphi, alphr, beta, rsafmn, safmin, xnorm
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, dcmplx, aimag, sign
     
           ! .. executable statements ..
           if (n <= 0) then
              tau = zero
              return
           end if
           xnorm = stdlib_dznrm2(n - 1, x, incx)
           alphr = real(alpha, KIND=dp)
           alphi = aimag(alpha)
           if (xnorm == zero .and. alphi == zero) then
              ! h  =  i
              tau = zero
           else
              ! general case
              beta = -sign(stdlib_dlapy3(alphr, alphi, xnorm), alphr)
              safmin = stdlib_dlamch('s')/stdlib_dlamch('e')
              rsafmn = one/safmin
              knt = 0
              if (abs(beta) < safmin) then
                 ! xnorm, beta may be inaccurate; scale x and recompute them
10      continue
                 knt = knt + 1
                 call stdlib_zdscal(n - 1, rsafmn, x, incx)
                 beta = beta*rsafmn
                 alphi = alphi*rsafmn
                 alphr = alphr*rsafmn
                 if ((abs(beta) < safmin) .and. (knt < 20)) go to 10
                 ! new beta is at most 1, at least safmin
                 xnorm = stdlib_dznrm2(n - 1, x, incx)
                 alpha = cmplx(alphr, alphi, KIND=dp)
                 beta = -sign(stdlib_dlapy3(alphr, alphi, xnorm), alphr)
              end if
              tau = cmplx((beta - alphr)/beta, -alphi/beta, KIND=dp)
              alpha = stdlib_zladiv(cmplx(one, KIND=dp), alpha - beta)
              call stdlib_zscal(n - 1, alpha, x, incx)
              ! if alpha is subnormal, it may lose relative accuracy
              do j = 1, knt
                 beta = beta*safmin
              end do
              alpha = beta
           end if
           return
           ! end of stdlib_zlarfg
     end subroutine stdlib_zlarfg

     ! ZLARFGP generates a complex elementary reflector H of order n, such
     ! that
     ! H**H * ( alpha ) = ( beta ),   H**H * H = I.
     ! (   x   )   (   0  )
     ! where alpha and beta are scalars, beta is real and non-negative, and
     ! x is an (n-1)-element complex vector.  H is represented in the form
     ! H = I - tau * ( 1 ) * ( 1 v**H ) ,
     ! ( v )
     ! where tau is a complex scalar and v is a complex (n-1)-element
     ! vector. Note that H is not hermitian.
     ! If the elements of x are all zero and alpha is real, then tau = 0
     ! and H is taken to be the unit matrix.

     subroutine stdlib_zlarfgp(n, alpha, x, incx, tau)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: incx, n
           complex(dp) :: alpha, tau
           ! .. array arguments ..
           complex(dp) :: x(*)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: j, knt
           real(dp) :: alphi, alphr, beta, bignum, smlnum, xnorm
           complex(dp) :: savealpha
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, dcmplx, aimag, sign
     
           ! .. executable statements ..
           if (n <= 0) then
              tau = zero
              return
           end if
           xnorm = stdlib_dznrm2(n - 1, x, incx)
           alphr = real(alpha, KIND=dp)
           alphi = aimag(alpha)
           if (xnorm == zero) then
              ! h  =  [1-alpha/abs(alpha) 0; 0 i], sign chosen so alpha >= 0.
              if (alphi == zero) then
                 if (alphr >= zero) then
                    ! when tau.eq.zero, the vector is special-cased to be
                    ! all zeros in the application routines.  we do not need
                    ! to clear it.
                    tau = zero
                 else
                    ! however, the application routines rely on explicit
                    ! zero checks when tau.ne.zero, and we must clear x.
                    tau = two
                    do j = 1, n - 1
                       x(1 + (j - 1)*incx) = zero
                    end do
                    alpha = -alpha
                 end if
              else
                 ! only "reflecting" the diagonal entry to be real and non-negative.
                 xnorm = stdlib_dlapy2(alphr, alphi)
                 tau = cmplx(one - alphr/xnorm, -alphi/xnorm, KIND=dp)
                 do j = 1, n - 1
                    x(1 + (j - 1)*incx) = zero
                 end do
                 alpha = xnorm
              end if
           else
              ! general case
              beta = sign(stdlib_dlapy3(alphr, alphi, xnorm), alphr)
              smlnum = stdlib_dlamch('s')/stdlib_dlamch('e')
              bignum = one/smlnum
              knt = 0
              if (abs(beta) < smlnum) then
                 ! xnorm, beta may be inaccurate; scale x and recompute them
10      continue
                 knt = knt + 1
                 call stdlib_zdscal(n - 1, bignum, x, incx)
                 beta = beta*bignum
                 alphi = alphi*bignum
                 alphr = alphr*bignum
                 if ((abs(beta) < smlnum) .and. (knt < 20)) go to 10
                 ! new beta is at most 1, at least smlnum
                 xnorm = stdlib_dznrm2(n - 1, x, incx)
                 alpha = cmplx(alphr, alphi, KIND=dp)
                 beta = sign(stdlib_dlapy3(alphr, alphi, xnorm), alphr)
              end if
              savealpha = alpha
              alpha = alpha + beta
              if (beta < zero) then
                 beta = -beta
                 tau = -alpha/beta
              else
                 alphr = alphi*(alphi/real(alpha, KIND=dp))
                 alphr = alphr + xnorm*(xnorm/real(alpha, KIND=dp))
                 tau = cmplx(alphr/beta, -alphi/beta, KIND=dp)
                 alpha = cmplx(-alphr, alphi, KIND=dp)
              end if
              alpha = stdlib_zladiv(cmplx(one, KIND=dp), alpha)
              if (abs(tau) <= smlnum) then
                 ! in the case where the computed tau ends up being a denormalized number,
                 ! it loses relative accuracy. this is a big problem. solution: flush tau
                 ! to zero (or two or whatever makes a nonnegative real number for beta).
                 ! (bug report provided by pat quillen from mathworks on jul 29, 2009.)
                 ! (thanks pat. thanks mathworks.)
                 alphr = real(savealpha, KIND=dp)
                 alphi = aimag(savealpha)
                 if (alphi == zero) then
                    if (alphr >= zero) then
                       tau = zero
                    else
                       tau = two
                       do j = 1, n - 1
                          x(1 + (j - 1)*incx) = zero
                       end do
                       beta = real(-savealpha, KIND=dp)
                    end if
                 else
                    xnorm = stdlib_dlapy2(alphr, alphi)
                    tau = cmplx(one - alphr/xnorm, -alphi/xnorm, KIND=dp)
                    do j = 1, n - 1
                       x(1 + (j - 1)*incx) = zero
                    end do
                    beta = xnorm
                 end if
              else
                 ! this is the general case.
                 call stdlib_zscal(n - 1, alpha, x, incx)
              end if
              ! if beta is subnormal, it may lose relative accuracy
              do j = 1, knt
                 beta = beta*smlnum
              end do
              alpha = beta
           end if
           return
           ! end of stdlib_zlarfgp
     end subroutine stdlib_zlarfgp

     ! ZLARFT forms the triangular factor T of a complex block reflector H
     ! of order n, which is defined as a product of k elementary reflectors.
     ! If DIRECT = 'F', H = H(1) H(2) . . . H(k) and T is upper triangular;
     ! If DIRECT = 'B', H = H(k) . . . H(2) H(1) and T is lower triangular.
     ! If STOREV = 'C', the vector which defines the elementary reflector
     ! H(i) is stored in the i-th column of the array V, and
     ! H  =  I - V * T * V**H
     ! If STOREV = 'R', the vector which defines the elementary reflector
     ! H(i) is stored in the i-th row of the array V, and
     ! H  =  I - V**H * T * V

     subroutine stdlib_zlarft(direct, storev, n, k, v, ldv, tau, t, ldt)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: direct, storev
           integer(ilp) :: k, ldt, ldv, n
           ! .. array arguments ..
           complex(dp) :: t(ldt, *), tau(*), v(ldv, *)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i, j, prevlastv, lastv
     
           ! .. executable statements ..
           ! quick return if possible
           if (n == 0) return
           if (stdlib_lsame(direct, 'f')) then
              prevlastv = n
              do i = 1, k
                 prevlastv = max(prevlastv, i)
                 if (tau(i) == czero) then
                    ! h(i)  =  i
                    do j = 1, i
                       t(j, i) = czero
                    end do
                 else
                    ! general case
                    if (stdlib_lsame(storev, 'c')) then
                       ! skip any trailing zeros.
                       do lastv = n, i + 1, -1
                          if (v(lastv, i) /= czero) exit
                       end do
                       do j = 1, i - 1
                          t(j, i) = -tau(i)*conjg(v(i, j))
                       end do
                       j = min(lastv, prevlastv)
                       ! t(1:i-1,i) := - tau(i) * v(i:j,1:i-1)**h * v(i:j,i)
                       call stdlib_zgemv('conjugate transpose', j - i, i - 1, -tau(i), v(i + 1, 1), &
                                 ldv, v(i + 1, i), 1, cone, t(1, i), 1)
                    else
                       ! skip any trailing zeros.
                       do lastv = n, i + 1, -1
                          if (v(i, lastv) /= czero) exit
                       end do
                       do j = 1, i - 1
                          t(j, i) = -tau(i)*v(j, i)
                       end do
                       j = min(lastv, prevlastv)
                       ! t(1:i-1,i) := - tau(i) * v(1:i-1,i:j) * v(i,i:j)**h
                       call stdlib_zgemm('n', 'c', i - 1, 1, j - i, -tau(i), v(1, i + 1), ldv, v(i, &
                                  i + 1), ldv, cone, t(1, i), ldt)
                    end if
                    ! t(1:i-1,i) := t(1:i-1,1:i-1) * t(1:i-1,i)
                    call stdlib_ztrmv('upper', 'no transpose', 'non-unit', i - 1, t, ldt, t(1, i), &
                               1)
                    t(i, i) = tau(i)
                    if (i > 1) then
                       prevlastv = max(prevlastv, lastv)
                    else
                       prevlastv = lastv
                    end if
                  end if
              end do
           else
              prevlastv = 1
              do i = k, 1, -1
                 if (tau(i) == czero) then
                    ! h(i)  =  i
                    do j = i, k
                       t(j, i) = czero
                    end do
                 else
                    ! general case
                    if (i < k) then
                       if (stdlib_lsame(storev, 'c')) then
                          ! skip any leading zeros.
                          do lastv = 1, i - 1
                             if (v(lastv, i) /= czero) exit
                          end do
                          do j = i + 1, k
                             t(j, i) = -tau(i)*conjg(v(n - k + i, j))
                          end do
                          j = max(lastv, prevlastv)
                          ! t(i+1:k,i) = -tau(i) * v(j:n-k+i,i+1:k)**h * v(j:n-k+i,i)
                          call stdlib_zgemv('conjugate transpose', n - k + i - j, k - i, -tau(i), v(j, &
                                    i + 1), ldv, v(j, i), 1, cone, t(i + 1, i), 1)
                       else
                          ! skip any leading zeros.
                          do lastv = 1, i - 1
                             if (v(i, lastv) /= czero) exit
                          end do
                          do j = i + 1, k
                             t(j, i) = -tau(i)*v(j, n - k + i)
                          end do
                          j = max(lastv, prevlastv)
                          ! t(i+1:k,i) = -tau(i) * v(i+1:k,j:n-k+i) * v(i,j:n-k+i)**h
                          call stdlib_zgemm('n', 'c', k - i, 1, n - k + i - j, -tau(i), v(i + 1, j), &
                                    ldv, v(i, j), ldv, cone, t(i + 1, i), ldt)
                       end if
                       ! t(i+1:k,i) := t(i+1:k,i+1:k) * t(i+1:k,i)
                       call stdlib_ztrmv('lower', 'no transpose', 'non-unit', k - i, t(i + 1, i + 1), &
                                 ldt, t(i + 1, i), 1)
                       if (i > 1) then
                          prevlastv = min(prevlastv, lastv)
                       else
                          prevlastv = lastv
                       end if
                    end if
                    t(i, i) = tau(i)
                 end if
              end do
           end if
           return
           ! end of stdlib_zlarft
     end subroutine stdlib_zlarft

     ! ZLARFX applies a complex elementary reflector H to a complex m by n
     ! matrix C, from either the left or the right. H is represented in the
     ! form
     ! H = I - tau * v * v**H
     ! where tau is a complex scalar and v is a complex vector.
     ! If tau = 0, then H is taken to be the unit matrix
     ! This version uses inline code if H has order < 11.

     subroutine stdlib_zlarfx(side, m, n, v, tau, c, ldc, work)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: side
           integer(ilp) :: ldc, m, n
           complex(dp) :: tau
           ! .. array arguments ..
           complex(dp) :: c(ldc, *), v(*), work(*)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: j
           complex(dp) :: sum, t1, t10, t2, t3, t4, t5, t6, t7, t8, t9, v1, v10, v2, v3, v4, v5, &
                     v6, v7, v8, v9
     
           ! .. intrinsic functions ..
           intrinsic :: conjg
           ! .. executable statements ..
           if (tau == czero) return
           if (stdlib_lsame(side, 'l')) then
              ! form  h * c, where h has order m.
              go to(10, 30, 50, 70, 90, 110, 130, 150, 170, 190) m
              ! code for general m
              call stdlib_zlarf(side, m, n, v, 1, tau, c, ldc, work)
              go to 410
10      continue
              ! special code for 1 x 1 householder
              t1 = cone - tau*v(1)*conjg(v(1))
              do j = 1, n
                 c(1, j) = t1*c(1, j)
              end do
              go to 410
30      continue
              ! special code for 2 x 2 householder
              v1 = conjg(v(1))
              t1 = tau*conjg(v1)
              v2 = conjg(v(2))
              t2 = tau*conjg(v2)
              do j = 1, n
                 sum = v1*c(1, j) + v2*c(2, j)
                 c(1, j) = c(1, j) - sum*t1
                 c(2, j) = c(2, j) - sum*t2
              end do
              go to 410
50      continue
              ! special code for 3 x 3 householder
              v1 = conjg(v(1))
              t1 = tau*conjg(v1)
              v2 = conjg(v(2))
              t2 = tau*conjg(v2)
              v3 = conjg(v(3))
              t3 = tau*conjg(v3)
              do j = 1, n
                 sum = v1*c(1, j) + v2*c(2, j) + v3*c(3, j)
                 c(1, j) = c(1, j) - sum*t1
                 c(2, j) = c(2, j) - sum*t2
                 c(3, j) = c(3, j) - sum*t3
              end do
              go to 410
70      continue
              ! special code for 4 x 4 householder
              v1 = conjg(v(1))
              t1 = tau*conjg(v1)
              v2 = conjg(v(2))
              t2 = tau*conjg(v2)
              v3 = conjg(v(3))
              t3 = tau*conjg(v3)
              v4 = conjg(v(4))
              t4 = tau*conjg(v4)
              do j = 1, n
                 sum = v1*c(1, j) + v2*c(2, j) + v3*c(3, j) + v4*c(4, j)
                 c(1, j) = c(1, j) - sum*t1
                 c(2, j) = c(2, j) - sum*t2
                 c(3, j) = c(3, j) - sum*t3
                 c(4, j) = c(4, j) - sum*t4
              end do
              go to 410
90      continue
              ! special code for 5 x 5 householder
              v1 = conjg(v(1))
              t1 = tau*conjg(v1)
              v2 = conjg(v(2))
              t2 = tau*conjg(v2)
              v3 = conjg(v(3))
              t3 = tau*conjg(v3)
              v4 = conjg(v(4))
              t4 = tau*conjg(v4)
              v5 = conjg(v(5))
              t5 = tau*conjg(v5)
              do j = 1, n
                 sum = v1*c(1, j) + v2*c(2, j) + v3*c(3, j) + v4*c(4, j) + v5*c(5, j)
                           
                 c(1, j) = c(1, j) - sum*t1
                 c(2, j) = c(2, j) - sum*t2
                 c(3, j) = c(3, j) - sum*t3
                 c(4, j) = c(4, j) - sum*t4
                 c(5, j) = c(5, j) - sum*t5
              end do
              go to 410
110    continue
              ! special code for 6 x 6 householder
              v1 = conjg(v(1))
              t1 = tau*conjg(v1)
              v2 = conjg(v(2))
              t2 = tau*conjg(v2)
              v3 = conjg(v(3))
              t3 = tau*conjg(v3)
              v4 = conjg(v(4))
              t4 = tau*conjg(v4)
              v5 = conjg(v(5))
              t5 = tau*conjg(v5)
              v6 = conjg(v(6))
              t6 = tau*conjg(v6)
              do j = 1, n
                 sum = v1*c(1, j) + v2*c(2, j) + v3*c(3, j) + v4*c(4, j) + v5*c(5, j) + &
                           v6*c(6, j)
                 c(1, j) = c(1, j) - sum*t1
                 c(2, j) = c(2, j) - sum*t2
                 c(3, j) = c(3, j) - sum*t3
                 c(4, j) = c(4, j) - sum*t4
                 c(5, j) = c(5, j) - sum*t5
                 c(6, j) = c(6, j) - sum*t6
              end do
              go to 410
130    continue
              ! special code for 7 x 7 householder
              v1 = conjg(v(1))
              t1 = tau*conjg(v1)
              v2 = conjg(v(2))
              t2 = tau*conjg(v2)
              v3 = conjg(v(3))
              t3 = tau*conjg(v3)
              v4 = conjg(v(4))
              t4 = tau*conjg(v4)
              v5 = conjg(v(5))
              t5 = tau*conjg(v5)
              v6 = conjg(v(6))
              t6 = tau*conjg(v6)
              v7 = conjg(v(7))
              t7 = tau*conjg(v7)
              do j = 1, n
                 sum = v1*c(1, j) + v2*c(2, j) + v3*c(3, j) + v4*c(4, j) + v5*c(5, j) + &
                           v6*c(6, j) + v7*c(7, j)
                 c(1, j) = c(1, j) - sum*t1
                 c(2, j) = c(2, j) - sum*t2
                 c(3, j) = c(3, j) - sum*t3
                 c(4, j) = c(4, j) - sum*t4
                 c(5, j) = c(5, j) - sum*t5
                 c(6, j) = c(6, j) - sum*t6
                 c(7, j) = c(7, j) - sum*t7
              end do
              go to 410
150    continue
              ! special code for 8 x 8 householder
              v1 = conjg(v(1))
              t1 = tau*conjg(v1)
              v2 = conjg(v(2))
              t2 = tau*conjg(v2)
              v3 = conjg(v(3))
              t3 = tau*conjg(v3)
              v4 = conjg(v(4))
              t4 = tau*conjg(v4)
              v5 = conjg(v(5))
              t5 = tau*conjg(v5)
              v6 = conjg(v(6))
              t6 = tau*conjg(v6)
              v7 = conjg(v(7))
              t7 = tau*conjg(v7)
              v8 = conjg(v(8))
              t8 = tau*conjg(v8)
              do j = 1, n
                 sum = v1*c(1, j) + v2*c(2, j) + v3*c(3, j) + v4*c(4, j) + v5*c(5, j) + &
                           v6*c(6, j) + v7*c(7, j) + v8*c(8, j)
                 c(1, j) = c(1, j) - sum*t1
                 c(2, j) = c(2, j) - sum*t2
                 c(3, j) = c(3, j) - sum*t3
                 c(4, j) = c(4, j) - sum*t4
                 c(5, j) = c(5, j) - sum*t5
                 c(6, j) = c(6, j) - sum*t6
                 c(7, j) = c(7, j) - sum*t7
                 c(8, j) = c(8, j) - sum*t8
              end do
              go to 410
170    continue
              ! special code for 9 x 9 householder
              v1 = conjg(v(1))
              t1 = tau*conjg(v1)
              v2 = conjg(v(2))
              t2 = tau*conjg(v2)
              v3 = conjg(v(3))
              t3 = tau*conjg(v3)
              v4 = conjg(v(4))
              t4 = tau*conjg(v4)
              v5 = conjg(v(5))
              t5 = tau*conjg(v5)
              v6 = conjg(v(6))
              t6 = tau*conjg(v6)
              v7 = conjg(v(7))
              t7 = tau*conjg(v7)
              v8 = conjg(v(8))
              t8 = tau*conjg(v8)
              v9 = conjg(v(9))
              t9 = tau*conjg(v9)
              do j = 1, n
                 sum = v1*c(1, j) + v2*c(2, j) + v3*c(3, j) + v4*c(4, j) + v5*c(5, j) + &
                           v6*c(6, j) + v7*c(7, j) + v8*c(8, j) + v9*c(9, j)
                 c(1, j) = c(1, j) - sum*t1
                 c(2, j) = c(2, j) - sum*t2
                 c(3, j) = c(3, j) - sum*t3
                 c(4, j) = c(4, j) - sum*t4
                 c(5, j) = c(5, j) - sum*t5
                 c(6, j) = c(6, j) - sum*t6
                 c(7, j) = c(7, j) - sum*t7
                 c(8, j) = c(8, j) - sum*t8
                 c(9, j) = c(9, j) - sum*t9
              end do
              go to 410
190    continue
              ! special code for 10 x 10 householder
              v1 = conjg(v(1))
              t1 = tau*conjg(v1)
              v2 = conjg(v(2))
              t2 = tau*conjg(v2)
              v3 = conjg(v(3))
              t3 = tau*conjg(v3)
              v4 = conjg(v(4))
              t4 = tau*conjg(v4)
              v5 = conjg(v(5))
              t5 = tau*conjg(v5)
              v6 = conjg(v(6))
              t6 = tau*conjg(v6)
              v7 = conjg(v(7))
              t7 = tau*conjg(v7)
              v8 = conjg(v(8))
              t8 = tau*conjg(v8)
              v9 = conjg(v(9))
              t9 = tau*conjg(v9)
              v10 = conjg(v(10))
              t10 = tau*conjg(v10)
              do j = 1, n
                 sum = v1*c(1, j) + v2*c(2, j) + v3*c(3, j) + v4*c(4, j) + v5*c(5, j) + &
                           v6*c(6, j) + v7*c(7, j) + v8*c(8, j) + v9*c(9, j) + v10*c(10, j)
                 c(1, j) = c(1, j) - sum*t1
                 c(2, j) = c(2, j) - sum*t2
                 c(3, j) = c(3, j) - sum*t3
                 c(4, j) = c(4, j) - sum*t4
                 c(5, j) = c(5, j) - sum*t5
                 c(6, j) = c(6, j) - sum*t6
                 c(7, j) = c(7, j) - sum*t7
                 c(8, j) = c(8, j) - sum*t8
                 c(9, j) = c(9, j) - sum*t9
                 c(10, j) = c(10, j) - sum*t10
              end do
              go to 410
           else
              ! form  c * h, where h has order n.
              go to(210, 230, 250, 270, 290, 310, 330, 350, 370, 390) n
              ! code for general n
              call stdlib_zlarf(side, m, n, v, 1, tau, c, ldc, work)
              go to 410
210    continue
              ! special code for 1 x 1 householder
              t1 = cone - tau*v(1)*conjg(v(1))
              do j = 1, m
                 c(j, 1) = t1*c(j, 1)
              end do
              go to 410
230    continue
              ! special code for 2 x 2 householder
              v1 = v(1)
              t1 = tau*conjg(v1)
              v2 = v(2)
              t2 = tau*conjg(v2)
              do j = 1, m
                 sum = v1*c(j, 1) + v2*c(j, 2)
                 c(j, 1) = c(j, 1) - sum*t1
                 c(j, 2) = c(j, 2) - sum*t2
              end do
              go to 410
250    continue
              ! special code for 3 x 3 householder
              v1 = v(1)
              t1 = tau*conjg(v1)
              v2 = v(2)
              t2 = tau*conjg(v2)
              v3 = v(3)
              t3 = tau*conjg(v3)
              do j = 1, m
                 sum = v1*c(j, 1) + v2*c(j, 2) + v3*c(j, 3)
                 c(j, 1) = c(j, 1) - sum*t1
                 c(j, 2) = c(j, 2) - sum*t2
                 c(j, 3) = c(j, 3) - sum*t3
              end do
              go to 410
270    continue
              ! special code for 4 x 4 householder
              v1 = v(1)
              t1 = tau*conjg(v1)
              v2 = v(2)
              t2 = tau*conjg(v2)
              v3 = v(3)
              t3 = tau*conjg(v3)
              v4 = v(4)
              t4 = tau*conjg(v4)
              do j = 1, m
                 sum = v1*c(j, 1) + v2*c(j, 2) + v3*c(j, 3) + v4*c(j, 4)
                 c(j, 1) = c(j, 1) - sum*t1
                 c(j, 2) = c(j, 2) - sum*t2
                 c(j, 3) = c(j, 3) - sum*t3
                 c(j, 4) = c(j, 4) - sum*t4
              end do
              go to 410
290    continue
              ! special code for 5 x 5 householder
              v1 = v(1)
              t1 = tau*conjg(v1)
              v2 = v(2)
              t2 = tau*conjg(v2)
              v3 = v(3)
              t3 = tau*conjg(v3)
              v4 = v(4)
              t4 = tau*conjg(v4)
              v5 = v(5)
              t5 = tau*conjg(v5)
              do j = 1, m
                 sum = v1*c(j, 1) + v2*c(j, 2) + v3*c(j, 3) + v4*c(j, 4) + v5*c(j, 5)
                           
                 c(j, 1) = c(j, 1) - sum*t1
                 c(j, 2) = c(j, 2) - sum*t2
                 c(j, 3) = c(j, 3) - sum*t3
                 c(j, 4) = c(j, 4) - sum*t4
                 c(j, 5) = c(j, 5) - sum*t5
              end do
              go to 410
310    continue
              ! special code for 6 x 6 householder
              v1 = v(1)
              t1 = tau*conjg(v1)
              v2 = v(2)
              t2 = tau*conjg(v2)
              v3 = v(3)
              t3 = tau*conjg(v3)
              v4 = v(4)
              t4 = tau*conjg(v4)
              v5 = v(5)
              t5 = tau*conjg(v5)
              v6 = v(6)
              t6 = tau*conjg(v6)
              do j = 1, m
                 sum = v1*c(j, 1) + v2*c(j, 2) + v3*c(j, 3) + v4*c(j, 4) + v5*c(j, 5) + &
                           v6*c(j, 6)
                 c(j, 1) = c(j, 1) - sum*t1
                 c(j, 2) = c(j, 2) - sum*t2
                 c(j, 3) = c(j, 3) - sum*t3
                 c(j, 4) = c(j, 4) - sum*t4
                 c(j, 5) = c(j, 5) - sum*t5
                 c(j, 6) = c(j, 6) - sum*t6
              end do
              go to 410
330    continue
              ! special code for 7 x 7 householder
              v1 = v(1)
              t1 = tau*conjg(v1)
              v2 = v(2)
              t2 = tau*conjg(v2)
              v3 = v(3)
              t3 = tau*conjg(v3)
              v4 = v(4)
              t4 = tau*conjg(v4)
              v5 = v(5)
              t5 = tau*conjg(v5)
              v6 = v(6)
              t6 = tau*conjg(v6)
              v7 = v(7)
              t7 = tau*conjg(v7)
              do j = 1, m
                 sum = v1*c(j, 1) + v2*c(j, 2) + v3*c(j, 3) + v4*c(j, 4) + v5*c(j, 5) + &
                           v6*c(j, 6) + v7*c(j, 7)
                 c(j, 1) = c(j, 1) - sum*t1
                 c(j, 2) = c(j, 2) - sum*t2
                 c(j, 3) = c(j, 3) - sum*t3
                 c(j, 4) = c(j, 4) - sum*t4
                 c(j, 5) = c(j, 5) - sum*t5
                 c(j, 6) = c(j, 6) - sum*t6
                 c(j, 7) = c(j, 7) - sum*t7
              end do
              go to 410
350    continue
              ! special code for 8 x 8 householder
              v1 = v(1)
              t1 = tau*conjg(v1)
              v2 = v(2)
              t2 = tau*conjg(v2)
              v3 = v(3)
              t3 = tau*conjg(v3)
              v4 = v(4)
              t4 = tau*conjg(v4)
              v5 = v(5)
              t5 = tau*conjg(v5)
              v6 = v(6)
              t6 = tau*conjg(v6)
              v7 = v(7)
              t7 = tau*conjg(v7)
              v8 = v(8)
              t8 = tau*conjg(v8)
              do j = 1, m
                 sum = v1*c(j, 1) + v2*c(j, 2) + v3*c(j, 3) + v4*c(j, 4) + v5*c(j, 5) + &
                           v6*c(j, 6) + v7*c(j, 7) + v8*c(j, 8)
                 c(j, 1) = c(j, 1) - sum*t1
                 c(j, 2) = c(j, 2) - sum*t2
                 c(j, 3) = c(j, 3) - sum*t3
                 c(j, 4) = c(j, 4) - sum*t4
                 c(j, 5) = c(j, 5) - sum*t5
                 c(j, 6) = c(j, 6) - sum*t6
                 c(j, 7) = c(j, 7) - sum*t7
                 c(j, 8) = c(j, 8) - sum*t8
              end do
              go to 410
370    continue
              ! special code for 9 x 9 householder
              v1 = v(1)
              t1 = tau*conjg(v1)
              v2 = v(2)
              t2 = tau*conjg(v2)
              v3 = v(3)
              t3 = tau*conjg(v3)
              v4 = v(4)
              t4 = tau*conjg(v4)
              v5 = v(5)
              t5 = tau*conjg(v5)
              v6 = v(6)
              t6 = tau*conjg(v6)
              v7 = v(7)
              t7 = tau*conjg(v7)
              v8 = v(8)
              t8 = tau*conjg(v8)
              v9 = v(9)
              t9 = tau*conjg(v9)
              do j = 1, m
                 sum = v1*c(j, 1) + v2*c(j, 2) + v3*c(j, 3) + v4*c(j, 4) + v5*c(j, 5) + &
                           v6*c(j, 6) + v7*c(j, 7) + v8*c(j, 8) + v9*c(j, 9)
                 c(j, 1) = c(j, 1) - sum*t1
                 c(j, 2) = c(j, 2) - sum*t2
                 c(j, 3) = c(j, 3) - sum*t3
                 c(j, 4) = c(j, 4) - sum*t4
                 c(j, 5) = c(j, 5) - sum*t5
                 c(j, 6) = c(j, 6) - sum*t6
                 c(j, 7) = c(j, 7) - sum*t7
                 c(j, 8) = c(j, 8) - sum*t8
                 c(j, 9) = c(j, 9) - sum*t9
              end do
              go to 410
390    continue
              ! special code for 10 x 10 householder
              v1 = v(1)
              t1 = tau*conjg(v1)
              v2 = v(2)
              t2 = tau*conjg(v2)
              v3 = v(3)
              t3 = tau*conjg(v3)
              v4 = v(4)
              t4 = tau*conjg(v4)
              v5 = v(5)
              t5 = tau*conjg(v5)
              v6 = v(6)
              t6 = tau*conjg(v6)
              v7 = v(7)
              t7 = tau*conjg(v7)
              v8 = v(8)
              t8 = tau*conjg(v8)
              v9 = v(9)
              t9 = tau*conjg(v9)
              v10 = v(10)
              t10 = tau*conjg(v10)
              do j = 1, m
                 sum = v1*c(j, 1) + v2*c(j, 2) + v3*c(j, 3) + v4*c(j, 4) + v5*c(j, 5) + &
                           v6*c(j, 6) + v7*c(j, 7) + v8*c(j, 8) + v9*c(j, 9) + v10*c(j, 10)
                 c(j, 1) = c(j, 1) - sum*t1
                 c(j, 2) = c(j, 2) - sum*t2
                 c(j, 3) = c(j, 3) - sum*t3
                 c(j, 4) = c(j, 4) - sum*t4
                 c(j, 5) = c(j, 5) - sum*t5
                 c(j, 6) = c(j, 6) - sum*t6
                 c(j, 7) = c(j, 7) - sum*t7
                 c(j, 8) = c(j, 8) - sum*t8
                 c(j, 9) = c(j, 9) - sum*t9
                 c(j, 10) = c(j, 10) - sum*t10
              end do
              go to 410
           end if
410    continue
           return
           ! end of stdlib_zlarfx
     end subroutine stdlib_zlarfx

     ! ZLARFY applies an elementary reflector, or Householder matrix, H,
     ! to an n x n Hermitian matrix C, from both the left and the right.
     ! H is represented in the form
     ! H = I - tau * v * v'
     ! where  tau  is a scalar and  v  is a vector.
     ! If  tau  is  zero, then  H  is taken to be the unit matrix.

     subroutine stdlib_zlarfy(uplo, n, v, incv, tau, c, ldc, work)
        ! -- lapack test routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: incv, ldc, n
           complex(dp) :: tau
           ! .. array arguments ..
           complex(dp) :: c(ldc, *), v(*), work(*)
        ! =====================================================================
           
           ! .. local scalars ..
           complex(dp) :: alpha
     
           ! .. executable statements ..
           if (tau == czero) return
           ! form  w:= c * v
           call stdlib_zhemv(uplo, n, cone, c, ldc, v, incv, czero, work, 1)
           alpha = -chalf*tau*stdlib_zdotc(n, work, 1, v, incv)
           call stdlib_zaxpy(n, alpha, v, incv, work, 1)
           ! c := c - v * w' - w * v'
           call stdlib_zher2(uplo, n, -tau, v, incv, work, 1, c, ldc)
           return
           ! end of stdlib_zlarfy
     end subroutine stdlib_zlarfy

     ! ZLARNV returns a vector of n random complex numbers from a uniform or
     ! normal distribution.

     subroutine stdlib_zlarnv(idist, iseed, n, x)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: idist, n
           ! .. array arguments ..
           integer(ilp) :: iseed(4)
           complex(dp) :: x(*)
        ! =====================================================================
           ! .. parameters ..
           integer(ilp), parameter :: lv = 128
           real(dp), parameter :: twopi = 6.28318530717958647692528676655900576839_dp
           
           ! .. local scalars ..
           integer(ilp) :: i, il, iv
           ! .. local arrays ..
           real(dp) :: u(lv)
           ! .. intrinsic functions ..
           intrinsic :: dcmplx, exp, log, min, sqrt
     
           ! .. executable statements ..
           do 60 iv = 1, n, lv/2
              il = min(lv/2, n - iv + 1)
              ! call stdlib_dlaruv to generate 2*il real numbers from a uniform (0,1)
              ! distribution (2*il <= lv)
              call stdlib_dlaruv(iseed, 2*il, u)
              if (idist == 1) then
                 ! copy generated numbers
                 do i = 1, il
                    x(iv + i - 1) = dcmplx(u(2*i - 1), u(2*i))
                 end do
              else if (idist == 2) then
                 ! convert generated numbers to uniform (-1,1) distribution
                 do i = 1, il
                    x(iv + i - 1) = dcmplx(two*u(2*i - 1) - one, two*u(2*i) - one)
                 end do
              else if (idist == 3) then
                 ! convert generated numbers to normal (0,1) distribution
                 do i = 1, il
                    x(iv + i - 1) = sqrt(-two*log(u(2*i - 1)))*exp(cmplx(zero, twopi*u(2*i) &
                              , KIND=dp))
                 end do
              else if (idist == 4) then
                 ! convert generated numbers to complex numbers uniformly
                 ! distributed on the unit disk
                 do i = 1, il
                    x(iv + i - 1) = sqrt(u(2*i - 1))*exp(cmplx(zero, twopi*u(2*i), KIND=dp))
                              
                 end do
              else if (idist == 5) then
                 ! convert generated numbers to complex numbers uniformly
                 ! distributed on the unit circle
                 do i = 1, il
                    x(iv + i - 1) = exp(cmplx(zero, twopi*u(2*i), KIND=dp))
                 end do
              end if
60      continue
           return
           ! end of stdlib_zlarnv
     end subroutine stdlib_zlarnv

     ! !
     ! ZLARTG generates a plane rotation so that
     ! [  C         S  ] . [ F ]  =  [ R ]
     ! [ -conjg(S)  C  ]   [ G ]     [ 0 ]
     ! where C is real and C**2 + |S|**2 = 1.
     ! The mathematical formulas used for C and S are
     ! sgn(x) = {  x / |x|,   x != 0
     ! {  1,         x = 0
     ! R = sgn(F) * sqrt(|F|**2 + |G|**2)
     ! C = |F| / sqrt(|F|**2 + |G|**2)
     ! S = sgn(F) * conjg(G) / sqrt(|F|**2 + |G|**2)
     ! When F and G are real, the formulas simplify to C = F/R and
     ! S = G/R, and the returned values of C, S, and R should be
     ! identical to those returned by DLARTG.
     ! The algorithm used to compute these quantities incorporates scaling
     ! to avoid overflow or underflow in computing the square root of the
     ! sum of squares.
     ! This is a faster version of the BLAS1 routine ZROTG, except for
     ! the following differences:
     ! F and G are unchanged on return.
     ! If G=0, then C=1 and S=0.
     ! If F=0, then C=0 and S is chosen so that R is real.
     ! Below, wp=>dp stands for double precision from LA_CONSTANTS module.

     subroutine stdlib_zlartg(f, g, c, s, r)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! february 2021
        ! .. scalar arguments ..
        real(dp) :: c
        complex(dp) :: f, g, r, s
        ! .. local scalars ..
        real(dp) :: d, f1, f2, g1, g2, h2, p, u, uu, v, vv, w
        complex(dp) :: fs, gs, t
        ! .. intrinsic functions ..
        intrinsic :: abs, aimag, conjg, max, min, real, sqrt
        ! .. statement functions ..
        real(dp) :: abssq
        ! .. statement function definitions ..
        abssq(t) = real(t)**2 + aimag(t)**2
        ! .. executable statements ..
        if (g == czero) then
           c = one
           s = czero
           r = f
        else if (f == czero) then
           c = zero
           g1 = max(abs(real(g)), abs(aimag(g)))
           if (g1 > rtmin .and. g1 < rtmax) then
              ! use unscaled algorithm
              g2 = abssq(g)
              d = sqrt(g2)
              s = conjg(g)/d
              r = d
           else
              ! use scaled algorithm
              u = min(safmax, max(safmin, g1))
              uu = one/u
              gs = g*uu
              g2 = abssq(gs)
              d = sqrt(g2)
              s = conjg(gs)/d
              r = d*u
           end if
        else
           f1 = max(abs(real(f)), abs(aimag(f)))
           g1 = max(abs(real(g)), abs(aimag(g)))
     if (f1 > rtmin .and. f1 < rtmax .and. g1 > rtmin .and. g1 < rtmax) then
              ! use unscaled algorithm
              f2 = abssq(f)
              g2 = abssq(g)
              h2 = f2 + g2
              if (f2 > rtmin .and. h2 < rtmax) then
                 d = sqrt(f2*h2)
              else
                 d = sqrt(f2)*sqrt(h2)
              end if
              p = 1/d
              c = f2*p
              s = conjg(g)*(f*p)
              r = f*(h2*p)
           else
              ! use scaled algorithm
              u = min(safmax, max(safmin, f1, g1))
              uu = one/u
              gs = g*uu
              g2 = abssq(gs)
              if (f1*uu < rtmin) then
                 ! f is not well-scaled when scaled by g1.
                 ! use a different scaling for f.
                 v = min(safmax, max(safmin, f1))
                 vv = one/v
                 w = v*uu
                 fs = f*vv
                 f2 = abssq(fs)
                 h2 = f2*w**2 + g2
              else
                 ! otherwise use the same scaling for f and g.
                 w = one
                 fs = f*uu
                 f2 = abssq(fs)
                 h2 = f2 + g2
              end if
              if (f2 > rtmin .and. h2 < rtmax) then
                 d = sqrt(f2*h2)
              else
                 d = sqrt(f2)*sqrt(h2)
              end if
              p = 1/d
              c = (f2*p)*w
              s = conjg(gs)*(fs*p)
              r = (fs*(h2*p))*u
           end if
        end if
        return
     end subroutine stdlib_zlartg

     ! ZLARTV applies a vector of complex plane rotations with real cosines
     ! to elements of the complex vectors x and y. For i = 1,2,...,n
     ! ( x(i) ) := (        c(i)   s(i) ) ( x(i) )
     ! ( y(i) )    ( -conjg(s(i))  c(i) ) ( y(i) )

     subroutine stdlib_zlartv(n, x, incx, y, incy, c, s, incc)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: incc, incx, incy, n
           ! .. array arguments ..
           real(dp) :: c(*)
           complex(dp) :: s(*), x(*), y(*)
        ! =====================================================================
           ! .. local scalars ..
           integer(ilp) :: i, ic, ix, iy
           complex(dp) :: xi, yi
           ! .. intrinsic functions ..
           intrinsic :: conjg
           ! .. executable statements ..
           ix = 1
           iy = 1
           ic = 1
           do i = 1, n
              xi = x(ix)
              yi = y(iy)
              x(ix) = c(ic)*xi + s(ic)*yi
              y(iy) = c(ic)*yi - conjg(s(ic))*xi
              ix = ix + incx
              iy = iy + incy
              ic = ic + incc
           end do
           return
           ! end of stdlib_zlartv
     end subroutine stdlib_zlartv

     ! ZLARZ applies a complex elementary reflector H to a complex
     ! M-by-N matrix C, from either the left or the right. H is represented
     ! in the form
     ! H = I - tau * v * v**H
     ! where tau is a complex scalar and v is a complex vector.
     ! If tau = 0, then H is taken to be the unit matrix.
     ! To apply H**H (the conjugate transpose of H), supply conjg(tau) instead
     ! tau.
     ! H is a product of k elementary reflectors as returned by ZTZRZF.

     subroutine stdlib_zlarz(side, m, n, l, v, incv, tau, c, ldc, work)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: side
           integer(ilp) :: incv, l, ldc, m, n
           complex(dp) :: tau
           ! .. array arguments ..
           complex(dp) :: c(ldc, *), v(*), work(*)
        ! =====================================================================
           
           ! .. executable statements ..
           if (stdlib_lsame(side, 'l')) then
              ! form  h * c
              if (tau /= czero) then
                 ! w( 1:n ) = conjg( c( 1, 1:n ) )
                 call stdlib_zcopy(n, c, ldc, work, 1)
                 call stdlib_zlacgv(n, work, 1)
                 ! w( 1:n ) = conjg( w( 1:n ) + c( m-l+1:m, 1:n )**h * v( 1:l ) )
                 call stdlib_zgemv('conjugate transpose', l, n, cone, c(m - l + 1, 1), ldc, v, incv, &
                            cone, work, 1)
                 call stdlib_zlacgv(n, work, 1)
                 ! c( 1, 1:n ) = c( 1, 1:n ) - tau * w( 1:n )
                 call stdlib_zaxpy(n, -tau, work, 1, c, ldc)
                 ! c( m-l+1:m, 1:n ) = c( m-l+1:m, 1:n ) - ...
                                     ! tau * v( 1:l ) * w( 1:n )**h
                 call stdlib_zgeru(l, n, -tau, v, incv, work, 1, c(m - l + 1, 1), ldc)
              end if
           else
              ! form  c * h
              if (tau /= czero) then
                 ! w( 1:m ) = c( 1:m, 1 )
                 call stdlib_zcopy(m, c, 1, work, 1)
                 ! w( 1:m ) = w( 1:m ) + c( 1:m, n-l+1:n, 1:n ) * v( 1:l )
                 call stdlib_zgemv('no transpose', m, l, cone, c(1, n - l + 1), ldc, v, incv, cone, &
                           work, 1)
                 ! c( 1:m, 1 ) = c( 1:m, 1 ) - tau * w( 1:m )
                 call stdlib_zaxpy(m, -tau, work, 1, c, 1)
                 ! c( 1:m, n-l+1:n ) = c( 1:m, n-l+1:n ) - ...
                                     ! tau * w( 1:m ) * v( 1:l )**h
                 call stdlib_zgerc(m, l, -tau, work, 1, v, incv, c(1, n - l + 1), ldc)
              end if
           end if
           return
           ! end of stdlib_zlarz
     end subroutine stdlib_zlarz

     ! ZLARZB applies a complex block reflector H or its transpose H**H
     ! to a complex distributed M-by-N  C from the left or the right.
     ! Currently, only STOREV = 'R' and DIRECT = 'B' are supported.

     subroutine stdlib_zlarzb(side, trans, direct, storev, m, n, k, l, v, ldv, t, ldt, c, ldc, &
               work, ldwork)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: direct, side, storev, trans
           integer(ilp) :: k, l, ldc, ldt, ldv, ldwork, m, n
           ! .. array arguments ..
           complex(dp) :: c(ldc, *), t(ldt, *), v(ldv, *), work(ldwork, *)
        ! =====================================================================
           
           ! .. local scalars ..
           character :: transt
           integer(ilp) :: i, info, j
     
           ! .. executable statements ..
           ! quick return if possible
           if (m <= 0 .or. n <= 0) return
           ! check for currently supported options
           info = 0
           if (.not. stdlib_lsame(direct, 'b')) then
              info = -3
           else if (.not. stdlib_lsame(storev, 'r')) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zlarzb', -info)
              return
           end if
           if (stdlib_lsame(trans, 'n')) then
              transt = 'c'
           else
              transt = 'n'
           end if
           if (stdlib_lsame(side, 'l')) then
              ! form  h * c  or  h**h * c
              ! w( 1:n, 1:k ) = c( 1:k, 1:n )**h
              do j = 1, k
                 call stdlib_zcopy(n, c(j, 1), ldc, work(1, j), 1)
              end do
              ! w( 1:n, 1:k ) = w( 1:n, 1:k ) + ...
                              ! c( m-l+1:m, 1:n )**h * v( 1:k, 1:l )**t
              if (l > 0) call stdlib_zgemm('transpose', 'conjugate transpose', n, k, l, cone, c(m - &
                        l + 1, 1), ldc, v, ldv, cone, work, ldwork)
              ! w( 1:n, 1:k ) = w( 1:n, 1:k ) * t**t  or  w( 1:m, 1:k ) * t
              call stdlib_ztrmm('right', 'lower', transt, 'non-unit', n, k, cone, t, ldt, work, &
                        ldwork)
              ! c( 1:k, 1:n ) = c( 1:k, 1:n ) - w( 1:n, 1:k )**h
              do j = 1, n
                 do i = 1, k
                    c(i, j) = c(i, j) - work(j, i)
                 end do
              end do
              ! c( m-l+1:m, 1:n ) = c( m-l+1:m, 1:n ) - ...
                                  ! v( 1:k, 1:l )**h * w( 1:n, 1:k )**h
              if (l > 0) call stdlib_zgemm('transpose', 'transpose', l, n, k, -cone, v, ldv, work, &
                        ldwork, cone, c(m - l + 1, 1), ldc)
           else if (stdlib_lsame(side, 'r')) then
              ! form  c * h  or  c * h**h
              ! w( 1:m, 1:k ) = c( 1:m, 1:k )
              do j = 1, k
                 call stdlib_zcopy(m, c(1, j), 1, work(1, j), 1)
              end do
              ! w( 1:m, 1:k ) = w( 1:m, 1:k ) + ...
                              ! c( 1:m, n-l+1:n ) * v( 1:k, 1:l )**h
              if (l > 0) call stdlib_zgemm('no transpose', 'transpose', m, k, l, cone, c(1, n - l + 1) &
                        , ldc, v, ldv, cone, work, ldwork)
              ! w( 1:m, 1:k ) = w( 1:m, 1:k ) * conjg( t )  or
                              ! w( 1:m, 1:k ) * t**h
              do j = 1, k
                 call stdlib_zlacgv(k - j + 1, t(j, j), 1)
              end do
              call stdlib_ztrmm('right', 'lower', trans, 'non-unit', m, k, cone, t, ldt, work, &
                        ldwork)
              do j = 1, k
                 call stdlib_zlacgv(k - j + 1, t(j, j), 1)
              end do
              ! c( 1:m, 1:k ) = c( 1:m, 1:k ) - w( 1:m, 1:k )
              do j = 1, k
                 do i = 1, m
                    c(i, j) = c(i, j) - work(i, j)
                 end do
              end do
              ! c( 1:m, n-l+1:n ) = c( 1:m, n-l+1:n ) - ...
                                  ! w( 1:m, 1:k ) * conjg( v( 1:k, 1:l ) )
              do j = 1, l
                 call stdlib_zlacgv(k, v(1, j), 1)
              end do
              if (l > 0) call stdlib_zgemm('no transpose', 'no transpose', m, l, k, -cone, work, &
                        ldwork, v, ldv, cone, c(1, n - l + 1), ldc)
              do j = 1, l
                 call stdlib_zlacgv(k, v(1, j), 1)
              end do
           end if
           return
           ! end of stdlib_zlarzb
     end subroutine stdlib_zlarzb

     ! ZLARZT forms the triangular factor T of a complex block reflector
     ! H of order > n, which is defined as a product of k elementary
     ! reflectors.
     ! If DIRECT = 'F', H = H(1) H(2) . . . H(k) and T is upper triangular;
     ! If DIRECT = 'B', H = H(k) . . . H(2) H(1) and T is lower triangular.
     ! If STOREV = 'C', the vector which defines the elementary reflector
     ! H(i) is stored in the i-th column of the array V, and
     ! H  =  I - V * T * V**H
     ! If STOREV = 'R', the vector which defines the elementary reflector
     ! H(i) is stored in the i-th row of the array V, and
     ! H  =  I - V**H * T * V
     ! Currently, only STOREV = 'R' and DIRECT = 'B' are supported.

     subroutine stdlib_zlarzt(direct, storev, n, k, v, ldv, tau, t, ldt)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: direct, storev
           integer(ilp) :: k, ldt, ldv, n
           ! .. array arguments ..
           complex(dp) :: t(ldt, *), tau(*), v(ldv, *)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i, info, j
     
           ! .. executable statements ..
           ! check for currently supported options
           info = 0
           if (.not. stdlib_lsame(direct, 'b')) then
              info = -1
           else if (.not. stdlib_lsame(storev, 'r')) then
              info = -2
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zlarzt', -info)
              return
           end if
           do i = k, 1, -1
              if (tau(i) == czero) then
                 ! h(i)  =  i
                 do j = i, k
                    t(j, i) = czero
                 end do
              else
                 ! general case
                 if (i < k) then
                    ! t(i+1:k,i) = - tau(i) * v(i+1:k,1:n) * v(i,1:n)**h
                    call stdlib_zlacgv(n, v(i, 1), ldv)
                    call stdlib_zgemv('no transpose', k - i, n, -tau(i), v(i + 1, 1), ldv, v(i, &
                              1), ldv, czero, t(i + 1, i), 1)
                    call stdlib_zlacgv(n, v(i, 1), ldv)
                    ! t(i+1:k,i) = t(i+1:k,i+1:k) * t(i+1:k,i)
                    call stdlib_ztrmv('lower', 'no transpose', 'non-unit', k - i, t(i + 1, i + 1), &
                              ldt, t(i + 1, i), 1)
                 end if
                 t(i, i) = tau(i)
              end if
           end do
           return
           ! end of stdlib_zlarzt
     end subroutine stdlib_zlarzt

     ! ZLASCL multiplies the M by N complex matrix A by the real scalar
     ! CTO/CFROM.  This is done without over/underflow as long as the final
     ! result CTO*A(I,J)/CFROM does not over/underflow. TYPE specifies that
     ! A may be full, upper triangular, lower triangular, upper Hessenberg,
     ! or banded.

     subroutine stdlib_zlascl(type, kl, ku, cfrom, cto, m, n, a, lda, info)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: type
           integer(ilp) :: info, kl, ku, lda, m, n
           real(dp) :: cfrom, cto
           ! .. array arguments ..
           complex(dp) :: a(lda, *)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: done
           integer(ilp) :: i, itype, j, k1, k2, k3, k4
           real(dp) :: bignum, cfrom1, cfromc, cto1, ctoc, mul, smlnum
     
           ! .. intrinsic functions ..
           intrinsic :: abs, max, min
     
           ! .. executable statements ..
           ! test the input arguments
           info = 0
           if (stdlib_lsame(type, 'g')) then
              itype = 0
           else if (stdlib_lsame(type, 'l')) then
              itype = 1
           else if (stdlib_lsame(type, 'u')) then
              itype = 2
           else if (stdlib_lsame(type, 'h')) then
              itype = 3
           else if (stdlib_lsame(type, 'b')) then
              itype = 4
           else if (stdlib_lsame(type, 'q')) then
              itype = 5
           else if (stdlib_lsame(type, 'z')) then
              itype = 6
           else
              itype = -1
           end if
           if (itype == -1) then
              info = -1
           else if (cfrom == zero .or. stdlib_disnan(cfrom)) then
              info = -4
           else if (stdlib_disnan(cto)) then
              info = -5
           else if (m < 0) then
              info = -6
           else if (n < 0 .or. (itype == 4 .and. n /= m) .or. (itype == 5 .and. n /= m)) then
              info = -7
           else if (itype <= 3 .and. lda < max(1, m)) then
              info = -9
           else if (itype >= 4) then
              if (kl < 0 .or. kl > max(m - 1, 0)) then
                 info = -2
              else if (ku < 0 .or. ku > max(n - 1, 0) .or. ((itype == 4 .or. itype == 5) .and. kl /= ku) &
                        ) then
                 info = -3
              else if ((itype == 4 .and. lda < kl + 1) .or. (itype == 5 .and. lda < ku + 1) .or. (itype == 6 &
                        .and. lda < 2*kl + ku + 1)) then
                 info = -9
              end if
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zlascl', -info)
              return
           end if
           ! quick return if possible
           if (n == 0 .or. m == 0) return
           ! get machine parameters
           smlnum = stdlib_dlamch('s')
           bignum = one/smlnum
           cfromc = cfrom
           ctoc = cto
10      continue
           cfrom1 = cfromc*smlnum
           if (cfrom1 == cfromc) then
              ! cfromc is an inf.  multiply by a correctly signed zero for
              ! finite ctoc, or a nan if ctoc is infinite.
              mul = ctoc/cfromc
              done = .true.
              cto1 = ctoc
           else
              cto1 = ctoc/bignum
              if (cto1 == ctoc) then
                 ! ctoc is either 0 or an inf.  in both cases, ctoc itself
                 ! serves as the correct multiplication factor.
                 mul = ctoc
                 done = .true.
                 cfromc = one
              else if (abs(cfrom1) > abs(ctoc) .and. ctoc /= zero) then
                 mul = smlnum
                 done = .false.
                 cfromc = cfrom1
              else if (abs(cto1) > abs(cfromc)) then
                 mul = bignum
                 done = .false.
                 ctoc = cto1
              else
                 mul = ctoc/cfromc
                 done = .true.
              end if
           end if
           if (itype == 0) then
              ! full matrix
              do j = 1, n
                 do i = 1, m
                    a(i, j) = a(i, j)*mul
                 end do
              end do
           else if (itype == 1) then
              ! lower triangular matrix
              do j = 1, n
                 do i = j, m
                    a(i, j) = a(i, j)*mul
                 end do
              end do
           else if (itype == 2) then
              ! upper triangular matrix
              do j = 1, n
                 do i = 1, min(j, m)
                    a(i, j) = a(i, j)*mul
                 end do
              end do
           else if (itype == 3) then
              ! upper hessenberg matrix
              do j = 1, n
                 do i = 1, min(j + 1, m)
                    a(i, j) = a(i, j)*mul
                 end do
              end do
           else if (itype == 4) then
              ! lower chalf of a symmetric band matrix
              k3 = kl + 1
              k4 = n + 1
              do j = 1, n
                 do i = 1, min(k3, k4 - j)
                    a(i, j) = a(i, j)*mul
                 end do
              end do
           else if (itype == 5) then
              ! upper chalf of a symmetric band matrix
              k1 = ku + 2
              k3 = ku + 1
              do j = 1, n
                 do i = max(k1 - j, 1), k3
                    a(i, j) = a(i, j)*mul
                 end do
              end do
           else if (itype == 6) then
              ! band matrix
              k1 = kl + ku + 2
              k2 = kl + 1
              k3 = 2*kl + ku + 1
              k4 = kl + ku + 1 + m
              do j = 1, n
                 do i = max(k1 - j, k2), min(k3, k4 - j)
                    a(i, j) = a(i, j)*mul
                 end do
              end do
           end if
           if (.not. done) go to 10
           return
           ! end of stdlib_zlascl
     end subroutine stdlib_zlascl

     ! ZLASET initializes a 2-D array A to BETA on the diagonal and
     ! ALPHA on the offdiagonals.

     subroutine stdlib_zlaset(uplo, m, n, alpha, beta, a, lda)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: lda, m, n
           complex(dp) :: alpha, beta
           ! .. array arguments ..
           complex(dp) :: a(lda, *)
        ! =====================================================================
           ! .. local scalars ..
           integer(ilp) :: i, j
     
           ! .. intrinsic functions ..
           intrinsic :: min
           ! .. executable statements ..
           if (stdlib_lsame(uplo, 'u')) then
              ! set the diagonal to beta and the strictly upper triangular
              ! part of the array to alpha.
              do j = 2, n
                 do i = 1, min(j - 1, m)
                    a(i, j) = alpha
                 end do
              end do
              do i = 1, min(n, m)
                 a(i, i) = beta
              end do
           else if (stdlib_lsame(uplo, 'l')) then
              ! set the diagonal to beta and the strictly lower triangular
              ! part of the array to alpha.
              do j = 1, min(m, n)
                 do i = j + 1, m
                    a(i, j) = alpha
                 end do
              end do
              do i = 1, min(n, m)
                 a(i, i) = beta
              end do
           else
              ! set the array to beta on the diagonal and alpha on the
              ! offdiagonal.
              do j = 1, n
                 do i = 1, m
                    a(i, j) = alpha
                 end do
              end do
              do i = 1, min(m, n)
                 a(i, i) = beta
              end do
           end if
           return
           ! end of stdlib_zlaset
     end subroutine stdlib_zlaset

     ! ZLASR applies a sequence of real plane rotations to a complex matrix
     ! A, from either the left or the right.
     ! When SIDE = 'L', the transformation takes the form
     ! A := P*A
     ! and when SIDE = 'R', the transformation takes the form
     ! A := A*P**T
     ! where P is an orthogonal matrix consisting of a sequence of z plane
     ! rotations, with z = M when SIDE = 'L' and z = N when SIDE = 'R',
     ! and P**T is the transpose of P.
     ! When DIRECT = 'F' (Forward sequence), then
     ! P = P(z-1) * ... * P(2) * P(1)
     ! and when DIRECT = 'B' (Backward sequence), then
     ! P = P(1) * P(2) * ... * P(z-1)
     ! where P(k) is a plane rotation matrix defined by the 2-by-2 rotation
     ! R(k) = (  c(k)  s(k) )
     ! = ( -s(k)  c(k) ).
     ! When PIVOT = 'V' (Variable pivot), the rotation is performed
     ! for the plane (k,k+1), i.e., P(k) has the form
     ! P(k) = (  1                                            )
     ! (       ...                                     )
     ! (              1                                )
     ! (                   c(k)  s(k)                  )
     ! (                  -s(k)  c(k)                  )
     ! (                                1              )
     ! (                                     ...       )
     ! (                                            1  )
     ! where R(k) appears as a rank-2 modification to the identity matrix in
     ! rows and columns k and k+1.
     ! When PIVOT = 'T' (Top pivot), the rotation is performed for the
     ! plane (1,k+1), so P(k) has the form
     ! P(k) = (  c(k)                    s(k)                 )
     ! (         1                                     )
     ! (              ...                              )
     ! (                     1                         )
     ! ( -s(k)                    c(k)                 )
     ! (                                 1             )
     ! (                                      ...      )
     ! (                                             1 )
     ! where R(k) appears in rows and columns 1 and k+1.
     ! Similarly, when PIVOT = 'B' (Bottom pivot), the rotation is
     ! performed for the plane (k,z), giving P(k) the form
     ! P(k) = ( 1                                             )
     ! (      ...                                      )
     ! (             1                                 )
     ! (                  c(k)                    s(k) )
     ! (                         1                     )
     ! (                              ...              )
     ! (                                     1         )
     ! (                 -s(k)                    c(k) )
     ! where R(k) appears in rows and columns k and z.  The rotations are
     ! performed without ever forming P(k) explicitly.

     subroutine stdlib_zlasr(side, pivot, direct, m, n, c, s, a, lda)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: direct, pivot, side
           integer(ilp) :: lda, m, n
           ! .. array arguments ..
           real(dp) :: c(*), s(*)
           complex(dp) :: a(lda, *)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i, info, j
           real(dp) :: ctemp, stemp
           complex(dp) :: temp
           ! .. intrinsic functions ..
           intrinsic :: max
     
           ! .. executable statements ..
           ! test the input parameters
           info = 0
           if (.not. (stdlib_lsame(side, 'l') .or. stdlib_lsame(side, 'r'))) then
              info = 1
           else if (.not. (stdlib_lsame(pivot, 'v') .or. stdlib_lsame(pivot, 't') .or. &
                     stdlib_lsame(pivot, 'b'))) then
              info = 2
           else if (.not. (stdlib_lsame(direct, 'f') .or. stdlib_lsame(direct, 'b'))) &
                     then
              info = 3
           else if (m < 0) then
              info = 4
           else if (n < 0) then
              info = 5
           else if (lda < max(1, m)) then
              info = 9
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zlasr ', info)
              return
           end if
           ! quick return if possible
           if ((m == 0) .or. (n == 0)) return
           if (stdlib_lsame(side, 'l')) then
              ! form  p * a
              if (stdlib_lsame(pivot, 'v')) then
                 if (stdlib_lsame(direct, 'f')) then
                    do j = 1, m - 1
                       ctemp = c(j)
                       stemp = s(j)
                       if ((ctemp /= one) .or. (stemp /= zero)) then
                          do i = 1, n
                             temp = a(j + 1, i)
                             a(j + 1, i) = ctemp*temp - stemp*a(j, i)
                             a(j, i) = stemp*temp + ctemp*a(j, i)
                          end do
                       end if
                    end do
                 else if (stdlib_lsame(direct, 'b')) then
                    do j = m - 1, 1, -1
                       ctemp = c(j)
                       stemp = s(j)
                       if ((ctemp /= one) .or. (stemp /= zero)) then
                          do i = 1, n
                             temp = a(j + 1, i)
                             a(j + 1, i) = ctemp*temp - stemp*a(j, i)
                             a(j, i) = stemp*temp + ctemp*a(j, i)
                          end do
                       end if
                    end do
                 end if
              else if (stdlib_lsame(pivot, 't')) then
                 if (stdlib_lsame(direct, 'f')) then
                    do j = 2, m
                       ctemp = c(j - 1)
                       stemp = s(j - 1)
                       if ((ctemp /= one) .or. (stemp /= zero)) then
                          do i = 1, n
                             temp = a(j, i)
                             a(j, i) = ctemp*temp - stemp*a(1, i)
                             a(1, i) = stemp*temp + ctemp*a(1, i)
                          end do
                       end if
                    end do
                 else if (stdlib_lsame(direct, 'b')) then
                    do j = m, 2, -1
                       ctemp = c(j - 1)
                       stemp = s(j - 1)
                       if ((ctemp /= one) .or. (stemp /= zero)) then
                          do i = 1, n
                             temp = a(j, i)
                             a(j, i) = ctemp*temp - stemp*a(1, i)
                             a(1, i) = stemp*temp + ctemp*a(1, i)
                          end do
                       end if
                    end do
                 end if
              else if (stdlib_lsame(pivot, 'b')) then
                 if (stdlib_lsame(direct, 'f')) then
                    do j = 1, m - 1
                       ctemp = c(j)
                       stemp = s(j)
                       if ((ctemp /= one) .or. (stemp /= zero)) then
                          do i = 1, n
                             temp = a(j, i)
                             a(j, i) = stemp*a(m, i) + ctemp*temp
                             a(m, i) = ctemp*a(m, i) - stemp*temp
                          end do
                       end if
                    end do
                 else if (stdlib_lsame(direct, 'b')) then
                    do j = m - 1, 1, -1
                       ctemp = c(j)
                       stemp = s(j)
                       if ((ctemp /= one) .or. (stemp /= zero)) then
                          do i = 1, n
                             temp = a(j, i)
                             a(j, i) = stemp*a(m, i) + ctemp*temp
                             a(m, i) = ctemp*a(m, i) - stemp*temp
                          end do
                       end if
                    end do
                 end if
              end if
           else if (stdlib_lsame(side, 'r')) then
              ! form a * p**t
              if (stdlib_lsame(pivot, 'v')) then
                 if (stdlib_lsame(direct, 'f')) then
                    do j = 1, n - 1
                       ctemp = c(j)
                       stemp = s(j)
                       if ((ctemp /= one) .or. (stemp /= zero)) then
                          do i = 1, m
                             temp = a(i, j + 1)
                             a(i, j + 1) = ctemp*temp - stemp*a(i, j)
                             a(i, j) = stemp*temp + ctemp*a(i, j)
                          end do
                       end if
                    end do
                 else if (stdlib_lsame(direct, 'b')) then
                    do j = n - 1, 1, -1
                       ctemp = c(j)
                       stemp = s(j)
                       if ((ctemp /= one) .or. (stemp /= zero)) then
                          do i = 1, m
                             temp = a(i, j + 1)
                             a(i, j + 1) = ctemp*temp - stemp*a(i, j)
                             a(i, j) = stemp*temp + ctemp*a(i, j)
                          end do
                       end if
                    end do
                 end if
              else if (stdlib_lsame(pivot, 't')) then
                 if (stdlib_lsame(direct, 'f')) then
                    do j = 2, n
                       ctemp = c(j - 1)
                       stemp = s(j - 1)
                       if ((ctemp /= one) .or. (stemp /= zero)) then
                          do i = 1, m
                             temp = a(i, j)
                             a(i, j) = ctemp*temp - stemp*a(i, 1)
                             a(i, 1) = stemp*temp + ctemp*a(i, 1)
                          end do
                       end if
                    end do
                 else if (stdlib_lsame(direct, 'b')) then
                    do j = n, 2, -1
                       ctemp = c(j - 1)
                       stemp = s(j - 1)
                       if ((ctemp /= one) .or. (stemp /= zero)) then
                          do i = 1, m
                             temp = a(i, j)
                             a(i, j) = ctemp*temp - stemp*a(i, 1)
                             a(i, 1) = stemp*temp + ctemp*a(i, 1)
                          end do
                       end if
                    end do
                 end if
              else if (stdlib_lsame(pivot, 'b')) then
                 if (stdlib_lsame(direct, 'f')) then
                    do j = 1, n - 1
                       ctemp = c(j)
                       stemp = s(j)
                       if ((ctemp /= one) .or. (stemp /= zero)) then
                          do i = 1, m
                             temp = a(i, j)
                             a(i, j) = stemp*a(i, n) + ctemp*temp
                             a(i, n) = ctemp*a(i, n) - stemp*temp
                          end do
                       end if
                    end do
                 else if (stdlib_lsame(direct, 'b')) then
                    do j = n - 1, 1, -1
                       ctemp = c(j)
                       stemp = s(j)
                       if ((ctemp /= one) .or. (stemp /= zero)) then
                          do i = 1, m
                             temp = a(i, j)
                             a(i, j) = stemp*a(i, n) + ctemp*temp
                             a(i, n) = ctemp*a(i, n) - stemp*temp
                          end do
                       end if
                    end do
                 end if
              end if
           end if
           return
           ! end of stdlib_zlasr
     end subroutine stdlib_zlasr

     ! !
     ! ZLASSQ  returns the values  scl  and  smsq  such that
     ! ( scl**2 )*smsq = x( 1 )**2 +...+ x( n )**2 + ( scale**2 )*sumsq,
     ! where  x( i ) = X( 1 + ( i - 1 )*INCX ). The value of  sumsq  is
     ! assumed to be non-negative.
     ! scale and sumsq must be supplied in SCALE and SUMSQ and
     ! scl and smsq are overwritten on SCALE and SUMSQ respectively.
     ! If scale * sqrt( sumsq ) > tbig then
     ! we require:   scale >= sqrt( TINY*EPS ) / sbig   on entry,
     ! and if 0 < scale * sqrt( sumsq ) < tsml then
     ! we require:   scale <= sqrt( HUGE ) / ssml       on entry,
     ! where
     ! tbig -- upper threshold for values whose square is representable;
     ! sbig -- scaling constant for big numbers; \see la_constants.f90
     ! tsml -- lower threshold for values whose square is representable;
     ! ssml -- scaling constant for small numbers; \see la_constants.f90
     ! and
     ! TINY*EPS -- tiniest representable number;
     ! HUGE     -- biggest representable number.

     subroutine stdlib_zlassq(n, x, incx, scl, sumsq)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
        ! .. scalar arguments ..
     integer(ilp) :: incx, n
        real(dp) :: scl, sumsq
        ! .. array arguments ..
        complex(dp) :: x(*)
        ! .. local scalars ..
     integer(ilp) :: i, ix
     logical(lk) :: notbig
        real(dp) :: abig, amed, asml, ax, ymax, ymin
        ! quick return if possible
        if (ieee_is_nan(scl) .or. ieee_is_nan(sumsq)) return
        if (sumsq == zero) scl = one
        if (scl == zero) then
           scl = one
           sumsq = zero
        end if
        if (n <= 0) then
           return
        end if
        ! compute the sum of squares in 3 accumulators:
           ! abig -- sums of squares scaled down to avoid overflow
           ! asml -- sums of squares scaled up to avoid underflow
           ! amed -- sums of squares that do not require scaling
        ! the thresholds and multipliers are
           ! tbig -- values bigger than this are scaled down by sbig
           ! tsml -- values smaller than this are scaled up by ssml
        notbig = .true.
        asml = zero
        amed = zero
        abig = zero
        ix = 1
        if (incx < 0) ix = 1 - (n - 1)*incx
        do i = 1, n
           ax = abs(real(x(ix)))
           if (ax > tbig) then
              abig = abig + (ax*sbig)**2
              notbig = .false.
           else if (ax < tsml) then
              if (notbig) asml = asml + (ax*ssml)**2
           else
              amed = amed + ax**2
           end if
           ax = abs(aimag(x(ix)))
           if (ax > tbig) then
              abig = abig + (ax*sbig)**2
              notbig = .false.
           else if (ax < tsml) then
              if (notbig) asml = asml + (ax*ssml)**2
           else
              amed = amed + ax**2
           end if
           ix = ix + incx
        end do
        ! put the existing sum of squares into one of the accumulators
        if (sumsq > zero) then
           ax = scl*sqrt(sumsq)
           if (ax > tbig) then
              ! we assume scl >= sqrt( tiny*eps ) / sbig
              abig = abig + (scl*sbig)**2*sumsq
           else if (ax < tsml) then
              ! we assume scl <= sqrt( huge ) / ssml
              if (notbig) asml = asml + (scl*ssml)**2*sumsq
           else
              amed = amed + scl**2*sumsq
           end if
        end if
        ! combine abig and amed or amed and asml if more than one
        ! accumulator was used.
        if (abig > zero) then
           ! combine abig and amed if abig > 0.
           if (amed > zero .or. ieee_is_nan(amed)) then
              abig = abig + (amed*sbig)*sbig
           end if
           scl = one/sbig
           sumsq = abig
        else if (asml > zero) then
           ! combine amed and asml if asml > 0.
           if (amed > zero .or. ieee_is_nan(amed)) then
              amed = sqrt(amed)
              asml = sqrt(asml)/ssml
              if (asml > amed) then
                 ymin = amed
                 ymax = asml
              else
                 ymin = asml
                 ymax = amed
              end if
              scl = one
              sumsq = ymax**2*(one + (ymin/ymax)**2)
           else
              scl = one/ssml
              sumsq = asml
           end if
        else
           ! otherwise all values are mid-range or zero
           scl = one
           sumsq = amed
        end if
        return
     end subroutine stdlib_zlassq

     ! ZLASWP performs a series of row interchanges on the matrix A.
     ! One row interchange is initiated for each of rows K1 through K2 of A.

     subroutine stdlib_zlaswp(n, a, lda, k1, k2, ipiv, incx)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: incx, k1, k2, lda, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *)
       ! =====================================================================
           ! .. local scalars ..
           integer(ilp) :: i, i1, i2, inc, ip, ix, ix0, j, k, n32
           complex(dp) :: temp
           ! .. executable statements ..
           ! interchange row i with row ipiv(k1+(i-k1)*abs(incx)) for each of rows
           ! k1 through k2.
           if (incx > 0) then
              ix0 = k1
              i1 = k1
              i2 = k2
              inc = 1
           else if (incx < 0) then
              ix0 = k1 + (k1 - k2)*incx
              i1 = k2
              i2 = k1
              inc = -1
           else
              return
           end if
           n32 = (n/32)*32
           if (n32 /= 0) then
              do j = 1, n32, 32
                 ix = ix0
                 do i = i1, i2, inc
                    ip = ipiv(ix)
                    if (ip /= i) then
                       do k = j, j + 31
                          temp = a(i, k)
                          a(i, k) = a(ip, k)
                          a(ip, k) = temp
                       end do
                    end if
                    ix = ix + incx
                 end do
              end do
           end if
           if (n32 /= n) then
              n32 = n32 + 1
              ix = ix0
              do i = i1, i2, inc
                 ip = ipiv(ix)
                 if (ip /= i) then
                    do k = n32, n
                       temp = a(i, k)
                       a(i, k) = a(ip, k)
                       a(ip, k) = temp
                    end do
                 end if
                 ix = ix + incx
              end do
           end if
           return
           ! end of stdlib_zlaswp
     end subroutine stdlib_zlaswp

     ! ZLASYF computes a partial factorization of a complex symmetric matrix
     ! A using the Bunch-Kaufman diagonal pivoting method. The partial
     ! factorization has the form:
     ! A  =  ( I  U12 ) ( A11  0  ) (  I       0    )  if UPLO = 'U', or:
     ! ( 0  U22 ) (  0   D  ) ( U12**T U22**T )
     ! A  =  ( L11  0 ) ( D    0  ) ( L11**T L21**T )  if UPLO = 'L'
     ! ( L21  I ) ( 0   A22 ) (  0       I    )
     ! where the order of D is at most NB. The actual order is returned in
     ! the argument KB, and is either NB or NB-1, or N if N <= NB.
     ! Note that U**T denotes the transpose of U.
     ! ZLASYF is an auxiliary routine called by ZSYTRF. It uses blocked code
     ! (calling Level 3 BLAS) to update the submatrix A11 (if UPLO = 'U') or
     ! A22 (if UPLO = 'L').

     subroutine stdlib_zlasyf(uplo, n, nb, kb, a, lda, ipiv, w, ldw, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, kb, lda, ldw, n, nb
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *), w(ldw, *)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: sevten = 17.0_dp
           
           ! .. local scalars ..
           integer(ilp) :: imax, j, jb, jj, jmax, jp, k, kk, kkw, kp, kstep, kw
           real(dp) :: absakk, alpha, colmax, rowmax
           complex(dp) :: d11, d21, d22, r1, t, z
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, aimag, max, min, sqrt
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(z) = abs(real(z, KIND=dp)) + abs(aimag(z))
           ! .. executable statements ..
           info = 0
           ! initialize alpha for use in choosing pivot block size.
           alpha = (one + sqrt(sevten))/eight
           if (stdlib_lsame(uplo, 'u')) then
              ! factorize the trailing columns of a using the upper triangle
              ! of a and working backwards, and compute the matrix w = u12*d
              ! for use in updating a11
              ! k is the main loop index, decreasing from n in steps of 1 or 2
              ! kw is the column of w which corresponds to column k of a
              k = n
10      continue
              kw = nb + k - n
              ! exit from loop
              if ((k <= n - nb + 1 .and. nb < n) .or. k < 1) go to 30
              ! copy column k of a to column kw of w and update it
              call stdlib_zcopy(k, a(1, k), 1, w(1, kw), 1)
              if (k < n) call stdlib_zgemv('no transpose', k, n - k, -cone, a(1, k + 1), lda, w(k, &
                        kw + 1), ldw, cone, w(1, kw), 1)
              kstep = 1
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = cabs1(w(k, kw))
              ! imax is the row-index of the largest off-diagonal element in
              if (k > 1) then
                 imax = stdlib_izamax(k - 1, w(1, kw), 1)
                 colmax = cabs1(w(imax, kw))
              else
                 colmax = zero
              end if
              if (max(absakk, colmax) == zero) then
                 ! column k is zero or underflow: set info and continue
                 if (info == 0) info = k
                 kp = k
              else
                 if (absakk >= alpha*colmax) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    ! copy column imax to column kw-1 of w and update it
                    call stdlib_zcopy(imax, a(1, imax), 1, w(1, kw - 1), 1)
                    call stdlib_zcopy(k - imax, a(imax, imax + 1), lda, w(imax + 1, kw - 1), 1)
                              
                    if (k < n) call stdlib_zgemv('no transpose', k, n - k, -cone, a(1, k + 1), lda, w( &
                               imax, kw + 1), ldw, cone, w(1, kw - 1), 1)
                    ! jmax is the column-index of the largest off-diagonal
                    ! element in row imax, and rowmax is its absolute value
                    jmax = imax + stdlib_izamax(k - imax, w(imax + 1, kw - 1), 1)
                    rowmax = cabs1(w(jmax, kw - 1))
                    if (imax > 1) then
                       jmax = stdlib_izamax(imax - 1, w(1, kw - 1), 1)
                       rowmax = max(rowmax, cabs1(w(jmax, kw - 1)))
                    end if
                    if (absakk >= alpha*colmax*(colmax/rowmax)) then
                       ! no interchange, use 1-by-1 pivot block
                       kp = k
                    else if (cabs1(w(imax, kw - 1)) >= alpha*rowmax) then
                       ! interchange rows and columns k and imax, use 1-by-1
                       ! pivot block
                       kp = imax
                       ! copy column kw-1 of w to column kw of w
                       call stdlib_zcopy(k, w(1, kw - 1), 1, w(1, kw), 1)
                    else
                       ! interchange rows and columns k-1 and imax, use 2-by-2
                       ! pivot block
                       kp = imax
                       kstep = 2
                    end if
                 end if
                 ! ============================================================
                 ! kk is the column of a where pivoting step stopped
                 kk = k - kstep + 1
                 ! kkw is the column of w which corresponds to column kk of a
                 kkw = nb + kk - n
                 ! interchange rows and columns kp and kk.
                 ! updated column kp is already stored in column kkw of w.
                 if (kp /= kk) then
                    ! copy non-updated column kk to column kp of submatrix a
                    ! at step k. no need to copy element into column k
                    ! (or k and k-1 for 2-by-2 pivot) of a, since these columns
                    ! will be later overwritten.
                    a(kp, kp) = a(kk, kk)
                    call stdlib_zcopy(kk - 1 - kp, a(kp + 1, kk), 1, a(kp, kp + 1), lda)
                    if (kp > 1) call stdlib_zcopy(kp - 1, a(1, kk), 1, a(1, kp), 1)
                    ! interchange rows kk and kp in last k+1 to n columns of a
                    ! (columns k (or k and k-1 for 2-by-2 pivot) of a will be
                    ! later overwritten). interchange rows kk and kp
                    ! in last kkw to nb columns of w.
                    if (k < n) call stdlib_zswap(n - k, a(kk, k + 1), lda, a(kp, k + 1), lda)
                    call stdlib_zswap(n - kk + 1, w(kk, kkw), ldw, w(kp, kkw), ldw)
                 end if
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column kw of w now holds
                    ! w(kw) = u(k)*d(k),
                    ! where u(k) is the k-th column of u
                    ! store subdiag. elements of column u(k)
                    ! and 1-by-1 block d(k) in column k of a.
                    ! note: diagonal element u(k,k) is a unit element
                    ! and not stored.
                       ! a(k,k) := d(k,k) = w(k,kw)
                       ! a(1:k-1,k) := u(1:k-1,k) = w(1:k-1,kw)/d(k,k)
                    call stdlib_zcopy(k, w(1, kw), 1, a(1, k), 1)
                    r1 = cone/a(k, k)
                    call stdlib_zscal(k - 1, r1, a(1, k), 1)
                 else
                    ! 2-by-2 pivot block d(k): columns kw and kw-1 of w now hold
                    ! ( w(kw-1) w(kw) ) = ( u(k-1) u(k) )*d(k)
                    ! where u(k) and u(k-1) are the k-th and (k-1)-th columns
                    ! of u
                    ! store u(1:k-2,k-1) and u(1:k-2,k) and 2-by-2
                    ! block d(k-1:k,k-1:k) in columns k-1 and k of a.
                    ! note: 2-by-2 diagonal block u(k-1:k,k-1:k) is a unit
                    ! block and not stored.
                       ! a(k-1:k,k-1:k) := d(k-1:k,k-1:k) = w(k-1:k,kw-1:kw)
                       ! a(1:k-2,k-1:k) := u(1:k-2,k:k-1:k) =
                       ! = w(1:k-2,kw-1:kw) * ( d(k-1:k,k-1:k)**(-1) )
                    if (k > 2) then
                       ! compose the columns of the inverse of 2-by-2 pivot
                       ! block d in the following way to reduce the number
                       ! of flops when we myltiply panel ( w(kw-1) w(kw) ) by
                       ! this inverse
                       ! d**(-1) = ( d11 d21 )**(-1) =
                                 ! ( d21 d22 )
                       ! = 1/(d11*d22-d21**2) * ( ( d22 ) (-d21 ) ) =
                                              ! ( (-d21 ) ( d11 ) )
                       ! = 1/d21 * 1/((d11/d21)*(d22/d21)-1) *
                         ! * ( ( d22/d21 ) (      -1 ) ) =
                           ! ( (      -1 ) ( d11/d21 ) )
                       ! = 1/d21 * 1/(d22*d11-1) * ( ( d11 ) (  -1 ) ) =
                                                 ! ( ( -1  ) ( d22 ) )
                       ! = 1/d21 * t * ( ( d11 ) (  -1 ) )
                                     ! ( (  -1 ) ( d22 ) )
                       ! = d21 * ( ( d11 ) (  -1 ) )
                               ! ( (  -1 ) ( d22 ) )
                       d21 = w(k - 1, kw)
                       d11 = w(k, kw)/d21
                       d22 = w(k - 1, kw - 1)/d21
                       t = cone/(d11*d22 - cone)
                       d21 = t/d21
                       ! update elements in columns a(k-1) and a(k) as
                       ! dot products of rows of ( w(kw-1) w(kw) ) and columns
                       ! of d**(-1)
                       do j = 1, k - 2
                          a(j, k - 1) = d21*(d11*w(j, kw - 1) - w(j, kw))
                          a(j, k) = d21*(d22*w(j, kw) - w(j, kw - 1))
                       end do
                    end if
                    ! copy d(k) to a
                    a(k - 1, k - 1) = w(k - 1, kw - 1)
                    a(k - 1, k) = w(k - 1, kw)
                    a(k, k) = w(k, kw)
                 end if
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -kp
                 ipiv(k - 1) = -kp
              end if
              ! decrease k and return to the start of the main loop
              k = k - kstep
              go to 10
30      continue
              ! update the upper triangle of a11 (= a(1:k,1:k)) as
              ! a11 := a11 - u12*d*u12**t = a11 - u12*w**t
              ! computing blocks of nb columns at a time
              do j = ((k - 1)/nb)*nb + 1, 1, -nb
                 jb = min(nb, k - j + 1)
                 ! update the upper triangle of the diagonal block
                 do jj = j, j + jb - 1
                    call stdlib_zgemv('no transpose', jj - j + 1, n - k, -cone, a(j, k + 1), lda, w(jj, &
                               kw + 1), ldw, cone, a(j, jj), 1)
                 end do
                 ! update the rectangular superdiagonal block
                 call stdlib_zgemm('no transpose', 'transpose', j - 1, jb, n - k, -cone, a(1, k + 1), &
                           lda, w(j, kw + 1), ldw, cone, a(1, j), lda)
              end do
              ! put u12 in standard form by partially undoing the interchanges
              ! in columns k+1:n looping backwards from k+1 to n
              j = k + 1
60      continue
                 ! undo the interchanges (if any) of rows jj and jp at each
                 ! step j
                 ! (here, j is a diagonal index)
                 jj = j
                 jp = ipiv(j)
                 if (jp < 0) then
                    jp = -jp
                    ! (here, j is a diagonal index)
                    j = j + 1
                 end if
                 ! (note: here, j is used to determine row length. length n-j+1
                 ! of the rows to swap back doesn't include diagonal element)
                 j = j + 1
                 if (jp /= jj .and. j <= n) call stdlib_zswap(n - j + 1, a(jp, j), lda, a(jj, j), &
                           lda)
              if (j < n) go to 60
              ! set kb to the number of columns factorized
              kb = n - k
           else
              ! factorize the leading columns of a using the lower triangle
              ! of a and working forwards, and compute the matrix w = l21*d
              ! for use in updating a22
              ! k is the main loop index, increasing from 1 in steps of 1 or 2
              k = 1
70      continue
              ! exit from loop
              if ((k >= nb .and. nb < n) .or. k > n) go to 90
              ! copy column k of a to column k of w and update it
              call stdlib_zcopy(n - k + 1, a(k, k), 1, w(k, k), 1)
              call stdlib_zgemv('no transpose', n - k + 1, k - 1, -cone, a(k, 1), lda, w(k, 1), ldw, &
                         cone, w(k, k), 1)
              kstep = 1
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = cabs1(w(k, k))
              ! imax is the row-index of the largest off-diagonal element in
              if (k < n) then
                 imax = k + stdlib_izamax(n - k, w(k + 1, k), 1)
                 colmax = cabs1(w(imax, k))
              else
                 colmax = zero
              end if
              if (max(absakk, colmax) == zero) then
                 ! column k is zero or underflow: set info and continue
                 if (info == 0) info = k
                 kp = k
              else
                 if (absakk >= alpha*colmax) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    ! copy column imax to column k+1 of w and update it
                    call stdlib_zcopy(imax - k, a(imax, k), lda, w(k, k + 1), 1)
                    call stdlib_zcopy(n - imax + 1, a(imax, imax), 1, w(imax, k + 1), 1)
                    call stdlib_zgemv('no transpose', n - k + 1, k - 1, -cone, a(k, 1), lda, w(imax, &
                              1), ldw, cone, w(k, k + 1), 1)
                    ! jmax is the column-index of the largest off-diagonal
                    ! element in row imax, and rowmax is its absolute value
                    jmax = k - 1 + stdlib_izamax(imax - k, w(k, k + 1), 1)
                    rowmax = cabs1(w(jmax, k + 1))
                    if (imax < n) then
                       jmax = imax + stdlib_izamax(n - imax, w(imax + 1, k + 1), 1)
                       rowmax = max(rowmax, cabs1(w(jmax, k + 1)))
                    end if
                    if (absakk >= alpha*colmax*(colmax/rowmax)) then
                       ! no interchange, use 1-by-1 pivot block
                       kp = k
                    else if (cabs1(w(imax, k + 1)) >= alpha*rowmax) then
                       ! interchange rows and columns k and imax, use 1-by-1
                       ! pivot block
                       kp = imax
                       ! copy column k+1 of w to column k of w
                       call stdlib_zcopy(n - k + 1, w(k, k + 1), 1, w(k, k), 1)
                    else
                       ! interchange rows and columns k+1 and imax, use 2-by-2
                       ! pivot block
                       kp = imax
                       kstep = 2
                    end if
                 end if
                 ! ============================================================
                 ! kk is the column of a where pivoting step stopped
                 kk = k + kstep - 1
                 ! interchange rows and columns kp and kk.
                 ! updated column kp is already stored in column kk of w.
                 if (kp /= kk) then
                    ! copy non-updated column kk to column kp of submatrix a
                    ! at step k. no need to copy element into column k
                    ! (or k and k+1 for 2-by-2 pivot) of a, since these columns
                    ! will be later overwritten.
                    a(kp, kp) = a(kk, kk)
                    call stdlib_zcopy(kp - kk - 1, a(kk + 1, kk), 1, a(kp, kk + 1), lda)
                    if (kp < n) call stdlib_zcopy(n - kp, a(kp + 1, kk), 1, a(kp + 1, kp), 1)
                              
                    ! interchange rows kk and kp in first k-1 columns of a
                    ! (columns k (or k and k+1 for 2-by-2 pivot) of a will be
                    ! later overwritten). interchange rows kk and kp
                    ! in first kk columns of w.
                    if (k > 1) call stdlib_zswap(k - 1, a(kk, 1), lda, a(kp, 1), lda)
                    call stdlib_zswap(kk, w(kk, 1), ldw, w(kp, 1), ldw)
                 end if
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k of w now holds
                    ! w(k) = l(k)*d(k),
                    ! where l(k) is the k-th column of l
                    ! store subdiag. elements of column l(k)
                    ! and 1-by-1 block d(k) in column k of a.
                    ! (note: diagonal element l(k,k) is a unit element
                    ! and not stored)
                       ! a(k,k) := d(k,k) = w(k,k)
                       ! a(k+1:n,k) := l(k+1:n,k) = w(k+1:n,k)/d(k,k)
                    call stdlib_zcopy(n - k + 1, w(k, k), 1, a(k, k), 1)
                    if (k < n) then
                       r1 = cone/a(k, k)
                       call stdlib_zscal(n - k, r1, a(k + 1, k), 1)
                    end if
                 else
                    ! 2-by-2 pivot block d(k): columns k and k+1 of w now hold
                    ! ( w(k) w(k+1) ) = ( l(k) l(k+1) )*d(k)
                    ! where l(k) and l(k+1) are the k-th and (k+1)-th columns
                    ! of l
                    ! store l(k+2:n,k) and l(k+2:n,k+1) and 2-by-2
                    ! block d(k:k+1,k:k+1) in columns k and k+1 of a.
                    ! (note: 2-by-2 diagonal block l(k:k+1,k:k+1) is a unit
                    ! block and not stored)
                       ! a(k:k+1,k:k+1) := d(k:k+1,k:k+1) = w(k:k+1,k:k+1)
                       ! a(k+2:n,k:k+1) := l(k+2:n,k:k+1) =
                       ! = w(k+2:n,k:k+1) * ( d(k:k+1,k:k+1)**(-1) )
                    if (k < n - 1) then
                       ! compose the columns of the inverse of 2-by-2 pivot
                       ! block d in the following way to reduce the number
                       ! of flops when we myltiply panel ( w(k) w(k+1) ) by
                       ! this inverse
                       ! d**(-1) = ( d11 d21 )**(-1) =
                                 ! ( d21 d22 )
                       ! = 1/(d11*d22-d21**2) * ( ( d22 ) (-d21 ) ) =
                                              ! ( (-d21 ) ( d11 ) )
                       ! = 1/d21 * 1/((d11/d21)*(d22/d21)-1) *
                         ! * ( ( d22/d21 ) (      -1 ) ) =
                           ! ( (      -1 ) ( d11/d21 ) )
                       ! = 1/d21 * 1/(d22*d11-1) * ( ( d11 ) (  -1 ) ) =
                                                 ! ( ( -1  ) ( d22 ) )
                       ! = 1/d21 * t * ( ( d11 ) (  -1 ) )
                                     ! ( (  -1 ) ( d22 ) )
                       ! = d21 * ( ( d11 ) (  -1 ) )
                               ! ( (  -1 ) ( d22 ) )
                       d21 = w(k + 1, k)
                       d11 = w(k + 1, k + 1)/d21
                       d22 = w(k, k)/d21
                       t = cone/(d11*d22 - cone)
                       d21 = t/d21
                       ! update elements in columns a(k) and a(k+1) as
                       ! dot products of rows of ( w(k) w(k+1) ) and columns
                       ! of d**(-1)
                       do j = k + 2, n
                          a(j, k) = d21*(d11*w(j, k) - w(j, k + 1))
                          a(j, k + 1) = d21*(d22*w(j, k + 1) - w(j, k))
                       end do
                    end if
                    ! copy d(k) to a
                    a(k, k) = w(k, k)
                    a(k + 1, k) = w(k + 1, k)
                    a(k + 1, k + 1) = w(k + 1, k + 1)
                 end if
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -kp
                 ipiv(k + 1) = -kp
              end if
              ! increase k and return to the start of the main loop
              k = k + kstep
              go to 70
90      continue
              ! update the lower triangle of a22 (= a(k:n,k:n)) as
              ! a22 := a22 - l21*d*l21**t = a22 - l21*w**t
              ! computing blocks of nb columns at a time
              do j = k, n, nb
                 jb = min(nb, n - j + 1)
                 ! update the lower triangle of the diagonal block
                 do jj = j, j + jb - 1
                    call stdlib_zgemv('no transpose', j + jb - jj, k - 1, -cone, a(jj, 1), lda, w(jj, &
                               1), ldw, cone, a(jj, jj), 1)
                 end do
                 ! update the rectangular subdiagonal block
                 if (j + jb <= n) call stdlib_zgemm('no transpose', 'transpose', n - j - jb + 1, jb, k - 1, - &
                           cone, a(j + jb, 1), lda, w(j, 1), ldw, cone, a(j + jb, j), lda)
              end do
              ! put l21 in standard form by partially undoing the interchanges
              ! of rows in columns 1:k-1 looping backwards from k-1 to 1
              j = k - 1
120    continue
                 ! undo the interchanges (if any) of rows jj and jp at each
                 ! step j
                 ! (here, j is a diagonal index)
                 jj = j
                 jp = ipiv(j)
                 if (jp < 0) then
                    jp = -jp
                    ! (here, j is a diagonal index)
                    j = j - 1
                 end if
                 ! (note: here, j is used to determine row length. length j
                 ! of the rows to swap back doesn't include diagonal element)
                 j = j - 1
                 if (jp /= jj .and. j >= 1) call stdlib_zswap(j, a(jp, 1), lda, a(jj, 1), lda)
                           
              if (j > 1) go to 120
              ! set kb to the number of columns factorized
              kb = k - 1
           end if
           return
           ! end of stdlib_zlasyf
     end subroutine stdlib_zlasyf

     ! ZLASYF_RK computes a partial factorization of a complex symmetric
     ! matrix A using the bounded Bunch-Kaufman (rook) diagonal
     ! pivoting method. The partial factorization has the form:
     ! A  =  ( I  U12 ) ( A11  0  ) (  I       0    )  if UPLO = 'U', or:
     ! ( 0  U22 ) (  0   D  ) ( U12**T U22**T )
     ! A  =  ( L11  0 ) (  D   0  ) ( L11**T L21**T )  if UPLO = 'L',
     ! ( L21  I ) (  0  A22 ) (  0       I    )
     ! where the order of D is at most NB. The actual order is returned in
     ! the argument KB, and is either NB or NB-1, or N if N <= NB.
     ! ZLASYF_RK is an auxiliary routine called by ZSYTRF_RK. It uses
     ! blocked code (calling Level 3 BLAS) to update the submatrix
     ! A11 (if UPLO = 'U') or A22 (if UPLO = 'L').

     subroutine stdlib_zlasyf_rk(uplo, n, nb, kb, a, lda, e, ipiv, w, ldw, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, kb, lda, ldw, n, nb
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *), e(*), w(ldw, *)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: sevten = 17.0_dp
           
           ! .. local scalars ..
           logical(lk) :: done
           integer(ilp) :: imax, itemp, j, jb, jj, jmax, k, kk, kw, kkw, kp, kstep, p, ii
           real(dp) :: absakk, alpha, colmax, rowmax, sfmin, dtemp
           complex(dp) :: d11, d12, d21, d22, r1, t, z
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, aimag, max, min, sqrt
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(z) = abs(real(z, KIND=dp)) + abs(aimag(z))
           ! .. executable statements ..
           info = 0
           ! initialize alpha for use in choosing pivot block size.
           alpha = (one + sqrt(sevten))/eight
           ! compute machine safe minimum
           sfmin = stdlib_dlamch('s')
           if (stdlib_lsame(uplo, 'u')) then
              ! factorize the trailing columns of a using the upper triangle
              ! of a and working backwards, and compute the matrix w = u12*d
              ! for use in updating a11
              ! initialize the first entry of array e, where superdiagonal
              ! elements of d are stored
              e(1) = czero
              ! k is the main loop index, decreasing from n in steps of 1 or 2
              k = n
10      continue
              ! kw is the column of w which corresponds to column k of a
              kw = nb + k - n
              ! exit from loop
              if ((k <= n - nb + 1 .and. nb < n) .or. k < 1) go to 30
              kstep = 1
              p = k
              ! copy column k of a to column kw of w and update it
              call stdlib_zcopy(k, a(1, k), 1, w(1, kw), 1)
              if (k < n) call stdlib_zgemv('no transpose', k, n - k, -cone, a(1, k + 1), lda, w(k, &
                        kw + 1), ldw, cone, w(1, kw), 1)
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = cabs1(w(k, kw))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k > 1) then
                 imax = stdlib_izamax(k - 1, w(1, kw), 1)
                 colmax = cabs1(w(imax, kw))
              else
                 colmax = zero
              end if
              if (max(absakk, colmax) == zero) then
                 ! column k is zero or underflow: set info and continue
                 if (info == 0) info = k
                 kp = k
                 call stdlib_zcopy(k, w(1, kw), 1, a(1, k), 1)
                 ! set e( k ) to zero
                 if (k > 1) e(k) = czero
              else
                 ! ============================================================
                 ! test for interchange
                 ! equivalent to testing for absakk>=alpha*colmax
                 ! (used to handle nan and inf)
                 if (.not. (absakk < alpha*colmax)) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    done = .false.
                    ! loop until pivot found
12      continue
                       ! begin pivot search loop body
                       ! copy column imax to column kw-1 of w and update it
                       call stdlib_zcopy(imax, a(1, imax), 1, w(1, kw - 1), 1)
                       call stdlib_zcopy(k - imax, a(imax, imax + 1), lda, w(imax + 1, kw - 1), 1)
                                 
                       if (k < n) call stdlib_zgemv('no transpose', k, n - k, -cone, a(1, k + 1), lda, &
                                  w(imax, kw + 1), ldw, cone, w(1, kw - 1), 1)
                       ! jmax is the column-index of the largest off-diagonal
                       ! element in row imax, and rowmax is its absolute value.
                       ! determine both rowmax and jmax.
                       if (imax /= k) then
                          jmax = imax + stdlib_izamax(k - imax, w(imax + 1, kw - 1), 1)
                          rowmax = cabs1(w(jmax, kw - 1))
                       else
                          rowmax = zero
                       end if
                       if (imax > 1) then
                          itemp = stdlib_izamax(imax - 1, w(1, kw - 1), 1)
                          dtemp = cabs1(w(itemp, kw - 1))
                          if (dtemp > rowmax) then
                             rowmax = dtemp
                             jmax = itemp
                          end if
                       end if
                       ! equivalent to testing for
                       ! cabs1( w( imax, kw-1 ) )>=alpha*rowmax
                       ! (used to handle nan and inf)
                       if (.not. (cabs1(w(imax, kw - 1)) < alpha*rowmax)) then
                          ! interchange rows and columns k and imax,
                          ! use 1-by-1 pivot block
                          kp = imax
                          ! copy column kw-1 of w to column kw of w
                          call stdlib_zcopy(k, w(1, kw - 1), 1, w(1, kw), 1)
                          done = .true.
                       ! equivalent to testing for rowmax==colmax,
                       ! (used to handle nan and inf)
                       else if ((p == jmax) .or. (rowmax <= colmax)) then
                          ! interchange rows and columns k-1 and imax,
                          ! use 2-by-2 pivot block
                          kp = imax
                          kstep = 2
                          done = .true.
                       else
                          ! pivot not found: set params and repeat
                          p = imax
                          colmax = rowmax
                          imax = jmax
                          ! copy updated jmaxth (next imaxth) column to kth of w
                          call stdlib_zcopy(k, w(1, kw - 1), 1, w(1, kw), 1)
                       end if
                       ! end pivot search loop body
                    if (.not. done) goto 12
                 end if
                 ! ============================================================
                 kk = k - kstep + 1
                 ! kkw is the column of w which corresponds to column kk of a
                 kkw = nb + kk - n
                 if ((kstep == 2) .and. (p /= k)) then
                    ! copy non-updated column k to column p
                    call stdlib_zcopy(k - p, a(p + 1, k), 1, a(p, p + 1), lda)
                    call stdlib_zcopy(p, a(1, k), 1, a(1, p), 1)
                    ! interchange rows k and p in last n-k+1 columns of a
                    ! and last n-k+2 columns of w
                    call stdlib_zswap(n - k + 1, a(k, k), lda, a(p, k), lda)
                    call stdlib_zswap(n - kk + 1, w(k, kkw), ldw, w(p, kkw), ldw)
                 end if
                 ! updated column kp is already stored in column kkw of w
                 if (kp /= kk) then
                    ! copy non-updated column kk to column kp
                    a(kp, k) = a(kk, k)
                    call stdlib_zcopy(k - 1 - kp, a(kp + 1, kk), 1, a(kp, kp + 1), lda)
                    call stdlib_zcopy(kp, a(1, kk), 1, a(1, kp), 1)
                    ! interchange rows kk and kp in last n-kk+1 columns
                    ! of a and w
                    call stdlib_zswap(n - kk + 1, a(kk, kk), lda, a(kp, kk), lda)
                    call stdlib_zswap(n - kk + 1, w(kk, kkw), ldw, w(kp, kkw), ldw)
                 end if
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column kw of w now holds
                    ! w(k) = u(k)*d(k)
                    ! where u(k) is the k-th column of u
                    ! store u(k) in column k of a
                    call stdlib_zcopy(k, w(1, kw), 1, a(1, k), 1)
                    if (k > 1) then
                       if (cabs1(a(k, k)) >= sfmin) then
                          r1 = cone/a(k, k)
                          call stdlib_zscal(k - 1, r1, a(1, k), 1)
                       else if (a(k, k) /= czero) then
                          do ii = 1, k - 1
                             a(ii, k) = a(ii, k)/a(k, k)
                          end do
                       end if
                       ! store the superdiagonal element of d in array e
                       e(k) = czero
                    end if
                 else
                    ! 2-by-2 pivot block d(k): columns kw and kw-1 of w now
                    ! hold
                    ! ( w(k-1) w(k) ) = ( u(k-1) u(k) )*d(k)
                    ! where u(k) and u(k-1) are the k-th and (k-1)-th columns
                    ! of u
                    if (k > 2) then
                       ! store u(k) and u(k-1) in columns k and k-1 of a
                       d12 = w(k - 1, kw)
                       d11 = w(k, kw)/d12
                       d22 = w(k - 1, kw - 1)/d12
                       t = cone/(d11*d22 - cone)
                       do j = 1, k - 2
                          a(j, k - 1) = t*((d11*w(j, kw - 1) - w(j, kw))/d12)
                          a(j, k) = t*((d22*w(j, kw) - w(j, kw - 1))/d12)
                       end do
                    end if
                    ! copy diagonal elements of d(k) to a,
                    ! copy superdiagonal element of d(k) to e(k) and
                    ! zero out superdiagonal entry of a
                    a(k - 1, k - 1) = w(k - 1, kw - 1)
                    a(k - 1, k) = czero
                    a(k, k) = w(k, kw)
                    e(k) = w(k - 1, kw)
                    e(k - 1) = czero
                 end if
                 ! end column k is nonsingular
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -p
                 ipiv(k - 1) = -kp
              end if
              ! decrease k and return to the start of the main loop
              k = k - kstep
              go to 10
30      continue
              ! update the upper triangle of a11 (= a(1:k,1:k)) as
              ! a11 := a11 - u12*d*u12**t = a11 - u12*w**t
              ! computing blocks of nb columns at a time
              do j = ((k - 1)/nb)*nb + 1, 1, -nb
                 jb = min(nb, k - j + 1)
                 ! update the upper triangle of the diagonal block
                 do jj = j, j + jb - 1
                    call stdlib_zgemv('no transpose', jj - j + 1, n - k, -cone, a(j, k + 1), lda, w(jj, &
                               kw + 1), ldw, cone, a(j, jj), 1)
                 end do
                 ! update the rectangular superdiagonal block
                 if (j >= 2) call stdlib_zgemm('no transpose', 'transpose', j - 1, jb, n - k, -cone, a( &
                           1, k + 1), lda, w(j, kw + 1), ldw, cone, a(1, j), lda)
              end do
              ! set kb to the number of columns factorized
              kb = n - k
           else
              ! factorize the leading columns of a using the lower triangle
              ! of a and working forwards, and compute the matrix w = l21*d
              ! for use in updating a22
              ! initialize the unused last entry of the subdiagonal array e.
              e(n) = czero
              ! k is the main loop index, increasing from 1 in steps of 1 or 2
              k = 1
70      continue
              ! exit from loop
              if ((k >= nb .and. nb < n) .or. k > n) go to 90
              kstep = 1
              p = k
              ! copy column k of a to column k of w and update it
              call stdlib_zcopy(n - k + 1, a(k, k), 1, w(k, k), 1)
              if (k > 1) call stdlib_zgemv('no transpose', n - k + 1, k - 1, -cone, a(k, 1), lda, w(k, &
                        1), ldw, cone, w(k, k), 1)
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = cabs1(w(k, k))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k < n) then
                 imax = k + stdlib_izamax(n - k, w(k + 1, k), 1)
                 colmax = cabs1(w(imax, k))
              else
                 colmax = zero
              end if
              if (max(absakk, colmax) == zero) then
                 ! column k is zero or underflow: set info and continue
                 if (info == 0) info = k
                 kp = k
                 call stdlib_zcopy(n - k + 1, w(k, k), 1, a(k, k), 1)
                 ! set e( k ) to zero
                 if (k < n) e(k) = czero
              else
                 ! ============================================================
                 ! test for interchange
                 ! equivalent to testing for absakk>=alpha*colmax
                 ! (used to handle nan and inf)
                 if (.not. (absakk < alpha*colmax)) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    done = .false.
                    ! loop until pivot found
72      continue
                       ! begin pivot search loop body
                       ! copy column imax to column k+1 of w and update it
                       call stdlib_zcopy(imax - k, a(imax, k), lda, w(k, k + 1), 1)
                       call stdlib_zcopy(n - imax + 1, a(imax, imax), 1, w(imax, k + 1), 1)
                       if (k > 1) call stdlib_zgemv('no transpose', n - k + 1, k - 1, -cone, a(k, 1), &
                                 lda, w(imax, 1), ldw, cone, w(k, k + 1), 1)
                       ! jmax is the column-index of the largest off-diagonal
                       ! element in row imax, and rowmax is its absolute value.
                       ! determine both rowmax and jmax.
                       if (imax /= k) then
                          jmax = k - 1 + stdlib_izamax(imax - k, w(k, k + 1), 1)
                          rowmax = cabs1(w(jmax, k + 1))
                       else
                          rowmax = zero
                       end if
                       if (imax < n) then
                          itemp = imax + stdlib_izamax(n - imax, w(imax + 1, k + 1), 1)
                          dtemp = cabs1(w(itemp, k + 1))
                          if (dtemp > rowmax) then
                             rowmax = dtemp
                             jmax = itemp
                          end if
                       end if
                       ! equivalent to testing for
                       ! cabs1( w( imax, k+1 ) )>=alpha*rowmax
                       ! (used to handle nan and inf)
                       if (.not. (cabs1(w(imax, k + 1)) < alpha*rowmax)) then
                          ! interchange rows and columns k and imax,
                          ! use 1-by-1 pivot block
                          kp = imax
                          ! copy column k+1 of w to column k of w
                          call stdlib_zcopy(n - k + 1, w(k, k + 1), 1, w(k, k), 1)
                          done = .true.
                       ! equivalent to testing for rowmax==colmax,
                       ! (used to handle nan and inf)
                       else if ((p == jmax) .or. (rowmax <= colmax)) then
                          ! interchange rows and columns k+1 and imax,
                          ! use 2-by-2 pivot block
                          kp = imax
                          kstep = 2
                          done = .true.
                       else
                          ! pivot not found: set params and repeat
                          p = imax
                          colmax = rowmax
                          imax = jmax
                          ! copy updated jmaxth (next imaxth) column to kth of w
                          call stdlib_zcopy(n - k + 1, w(k, k + 1), 1, w(k, k), 1)
                       end if
                       ! end pivot search loop body
                    if (.not. done) goto 72
                 end if
                 ! ============================================================
                 kk = k + kstep - 1
                 if ((kstep == 2) .and. (p /= k)) then
                    ! copy non-updated column k to column p
                    call stdlib_zcopy(p - k, a(k, k), 1, a(p, k), lda)
                    call stdlib_zcopy(n - p + 1, a(p, k), 1, a(p, p), 1)
                    ! interchange rows k and p in first k columns of a
                    ! and first k+1 columns of w
                    call stdlib_zswap(k, a(k, 1), lda, a(p, 1), lda)
                    call stdlib_zswap(kk, w(k, 1), ldw, w(p, 1), ldw)
                 end if
                 ! updated column kp is already stored in column kk of w
                 if (kp /= kk) then
                    ! copy non-updated column kk to column kp
                    a(kp, k) = a(kk, k)
                    call stdlib_zcopy(kp - k - 1, a(k + 1, kk), 1, a(kp, k + 1), lda)
                    call stdlib_zcopy(n - kp + 1, a(kp, kk), 1, a(kp, kp), 1)
                    ! interchange rows kk and kp in first kk columns of a and w
                    call stdlib_zswap(kk, a(kk, 1), lda, a(kp, 1), lda)
                    call stdlib_zswap(kk, w(kk, 1), ldw, w(kp, 1), ldw)
                 end if
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k of w now holds
                    ! w(k) = l(k)*d(k)
                    ! where l(k) is the k-th column of l
                    ! store l(k) in column k of a
                    call stdlib_zcopy(n - k + 1, w(k, k), 1, a(k, k), 1)
                    if (k < n) then
                       if (cabs1(a(k, k)) >= sfmin) then
                          r1 = cone/a(k, k)
                          call stdlib_zscal(n - k, r1, a(k + 1, k), 1)
                       else if (a(k, k) /= czero) then
                          do ii = k + 1, n
                             a(ii, k) = a(ii, k)/a(k, k)
                          end do
                       end if
                       ! store the subdiagonal element of d in array e
                       e(k) = czero
                    end if
                 else
                    ! 2-by-2 pivot block d(k): columns k and k+1 of w now hold
                    ! ( w(k) w(k+1) ) = ( l(k) l(k+1) )*d(k)
                    ! where l(k) and l(k+1) are the k-th and (k+1)-th columns
                    ! of l
                    if (k < n - 1) then
                       ! store l(k) and l(k+1) in columns k and k+1 of a
                       d21 = w(k + 1, k)
                       d11 = w(k + 1, k + 1)/d21
                       d22 = w(k, k)/d21
                       t = cone/(d11*d22 - cone)
                       do j = k + 2, n
                          a(j, k) = t*((d11*w(j, k) - w(j, k + 1))/d21)
                          a(j, k + 1) = t*((d22*w(j, k + 1) - w(j, k))/d21)
                       end do
                    end if
                    ! copy diagonal elements of d(k) to a,
                    ! copy subdiagonal element of d(k) to e(k) and
                    ! zero out subdiagonal entry of a
                    a(k, k) = w(k, k)
                    a(k + 1, k) = czero
                    a(k + 1, k + 1) = w(k + 1, k + 1)
                    e(k) = w(k + 1, k)
                    e(k + 1) = czero
                 end if
                 ! end column k is nonsingular
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -p
                 ipiv(k + 1) = -kp
              end if
              ! increase k and return to the start of the main loop
              k = k + kstep
              go to 70
90      continue
              ! update the lower triangle of a22 (= a(k:n,k:n)) as
              ! a22 := a22 - l21*d*l21**t = a22 - l21*w**t
              ! computing blocks of nb columns at a time
              do j = k, n, nb
                 jb = min(nb, n - j + 1)
                 ! update the lower triangle of the diagonal block
                 do jj = j, j + jb - 1
                    call stdlib_zgemv('no transpose', j + jb - jj, k - 1, -cone, a(jj, 1), lda, w(jj, &
                               1), ldw, cone, a(jj, jj), 1)
                 end do
                 ! update the rectangular subdiagonal block
                 if (j + jb <= n) call stdlib_zgemm('no transpose', 'transpose', n - j - jb + 1, jb, k - 1, - &
                           cone, a(j + jb, 1), lda, w(j, 1), ldw, cone, a(j + jb, j), lda)
              end do
              ! set kb to the number of columns factorized
              kb = k - 1
           end if
           return
           ! end of stdlib_zlasyf_rk
     end subroutine stdlib_zlasyf_rk

     ! ZLASYF_ROOK computes a partial factorization of a complex symmetric
     ! matrix A using the bounded Bunch-Kaufman ("rook") diagonal
     ! pivoting method. The partial factorization has the form:
     ! A  =  ( I  U12 ) ( A11  0  ) (  I       0    )  if UPLO = 'U', or:
     ! ( 0  U22 ) (  0   D  ) ( U12**T U22**T )
     ! A  =  ( L11  0 ) (  D   0  ) ( L11**T L21**T )  if UPLO = 'L'
     ! ( L21  I ) (  0  A22 ) (  0       I    )
     ! where the order of D is at most NB. The actual order is returned in
     ! the argument KB, and is either NB or NB-1, or N if N <= NB.
     ! ZLASYF_ROOK is an auxiliary routine called by ZSYTRF_ROOK. It uses
     ! blocked code (calling Level 3 BLAS) to update the submatrix
     ! A11 (if UPLO = 'U') or A22 (if UPLO = 'L').

     subroutine stdlib_zlasyf_rook(uplo, n, nb, kb, a, lda, ipiv, w, ldw, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, kb, lda, ldw, n, nb
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *), w(ldw, *)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: sevten = 17.0_dp
           
           ! .. local scalars ..
           logical(lk) :: done
           integer(ilp) :: imax, itemp, j, jb, jj, jmax, jp1, jp2, k, kk, kw, kkw, kp, kstep, p, &
                     ii
           real(dp) :: absakk, alpha, colmax, rowmax, dtemp, sfmin
           complex(dp) :: d11, d12, d21, d22, r1, t, z
     
           ! .. intrinsic functions ..
           intrinsic :: abs, max, min, sqrt, aimag, dble
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(z) = abs(real(z, KIND=dp)) + abs(aimag(z))
           ! .. executable statements ..
           info = 0
           ! initialize alpha for use in choosing pivot block size.
           alpha = (one + sqrt(sevten))/eight
           ! compute machine safe minimum
           sfmin = stdlib_dlamch('s')
           if (stdlib_lsame(uplo, 'u')) then
              ! factorize the trailing columns of a using the upper triangle
              ! of a and working backwards, and compute the matrix w = u12*d
              ! for use in updating a11
              ! k is the main loop index, decreasing from n in steps of 1 or 2
              k = n
10      continue
              ! kw is the column of w which corresponds to column k of a
              kw = nb + k - n
              ! exit from loop
              if ((k <= n - nb + 1 .and. nb < n) .or. k < 1) go to 30
              kstep = 1
              p = k
              ! copy column k of a to column kw of w and update it
              call stdlib_zcopy(k, a(1, k), 1, w(1, kw), 1)
              if (k < n) call stdlib_zgemv('no transpose', k, n - k, -cone, a(1, k + 1), lda, w(k, &
                        kw + 1), ldw, cone, w(1, kw), 1)
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = cabs1(w(k, kw))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k > 1) then
                 imax = stdlib_izamax(k - 1, w(1, kw), 1)
                 colmax = cabs1(w(imax, kw))
              else
                 colmax = zero
              end if
              if (max(absakk, colmax) == zero) then
                 ! column k is zero or underflow: set info and continue
                 if (info == 0) info = k
                 kp = k
                 call stdlib_zcopy(k, w(1, kw), 1, a(1, k), 1)
              else
                 ! ============================================================
                 ! test for interchange
                 ! equivalent to testing for absakk>=alpha*colmax
                 ! (used to handle nan and inf)
                 if (.not. (absakk < alpha*colmax)) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    done = .false.
                    ! loop until pivot found
12      continue
                       ! begin pivot search loop body
                       ! copy column imax to column kw-1 of w and update it
                       call stdlib_zcopy(imax, a(1, imax), 1, w(1, kw - 1), 1)
                       call stdlib_zcopy(k - imax, a(imax, imax + 1), lda, w(imax + 1, kw - 1), 1)
                                 
                       if (k < n) call stdlib_zgemv('no transpose', k, n - k, -cone, a(1, k + 1), lda, &
                                  w(imax, kw + 1), ldw, cone, w(1, kw - 1), 1)
                       ! jmax is the column-index of the largest off-diagonal
                       ! element in row imax, and rowmax is its absolute value.
                       ! determine both rowmax and jmax.
                       if (imax /= k) then
                          jmax = imax + stdlib_izamax(k - imax, w(imax + 1, kw - 1), 1)
                          rowmax = cabs1(w(jmax, kw - 1))
                       else
                          rowmax = zero
                       end if
                       if (imax > 1) then
                          itemp = stdlib_izamax(imax - 1, w(1, kw - 1), 1)
                          dtemp = cabs1(w(itemp, kw - 1))
                          if (dtemp > rowmax) then
                             rowmax = dtemp
                             jmax = itemp
                          end if
                       end if
                       ! equivalent to testing for
                       ! cabs1( w( imax, kw-1 ) )>=alpha*rowmax
                       ! (used to handle nan and inf)
                       if (.not. (cabs1(w(imax, kw - 1)) < alpha*rowmax)) then
                          ! interchange rows and columns k and imax,
                          ! use 1-by-1 pivot block
                          kp = imax
                          ! copy column kw-1 of w to column kw of w
                          call stdlib_zcopy(k, w(1, kw - 1), 1, w(1, kw), 1)
                          done = .true.
                       ! equivalent to testing for rowmax==colmax,
                       ! (used to handle nan and inf)
                       else if ((p == jmax) .or. (rowmax <= colmax)) then
                          ! interchange rows and columns k-1 and imax,
                          ! use 2-by-2 pivot block
                          kp = imax
                          kstep = 2
                          done = .true.
                       else
                          ! pivot not found: set params and repeat
                          p = imax
                          colmax = rowmax
                          imax = jmax
                          ! copy updated jmaxth (next imaxth) column to kth of w
                          call stdlib_zcopy(k, w(1, kw - 1), 1, w(1, kw), 1)
                       end if
                       ! end pivot search loop body
                    if (.not. done) goto 12
                 end if
                 ! ============================================================
                 kk = k - kstep + 1
                 ! kkw is the column of w which corresponds to column kk of a
                 kkw = nb + kk - n
                 if ((kstep == 2) .and. (p /= k)) then
                    ! copy non-updated column k to column p
                    call stdlib_zcopy(k - p, a(p + 1, k), 1, a(p, p + 1), lda)
                    call stdlib_zcopy(p, a(1, k), 1, a(1, p), 1)
                    ! interchange rows k and p in last n-k+1 columns of a
                    ! and last n-k+2 columns of w
                    call stdlib_zswap(n - k + 1, a(k, k), lda, a(p, k), lda)
                    call stdlib_zswap(n - kk + 1, w(k, kkw), ldw, w(p, kkw), ldw)
                 end if
                 ! updated column kp is already stored in column kkw of w
                 if (kp /= kk) then
                    ! copy non-updated column kk to column kp
                    a(kp, k) = a(kk, k)
                    call stdlib_zcopy(k - 1 - kp, a(kp + 1, kk), 1, a(kp, kp + 1), lda)
                    call stdlib_zcopy(kp, a(1, kk), 1, a(1, kp), 1)
                    ! interchange rows kk and kp in last n-kk+1 columns
                    ! of a and w
                    call stdlib_zswap(n - kk + 1, a(kk, kk), lda, a(kp, kk), lda)
                    call stdlib_zswap(n - kk + 1, w(kk, kkw), ldw, w(kp, kkw), ldw)
                 end if
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column kw of w now holds
                    ! w(k) = u(k)*d(k)
                    ! where u(k) is the k-th column of u
                    ! store u(k) in column k of a
                    call stdlib_zcopy(k, w(1, kw), 1, a(1, k), 1)
                    if (k > 1) then
                       if (cabs1(a(k, k)) >= sfmin) then
                          r1 = cone/a(k, k)
                          call stdlib_zscal(k - 1, r1, a(1, k), 1)
                       else if (a(k, k) /= czero) then
                          do ii = 1, k - 1
                             a(ii, k) = a(ii, k)/a(k, k)
                          end do
                       end if
                    end if
                 else
                    ! 2-by-2 pivot block d(k): columns kw and kw-1 of w now
                    ! hold
                    ! ( w(k-1) w(k) ) = ( u(k-1) u(k) )*d(k)
                    ! where u(k) and u(k-1) are the k-th and (k-1)-th columns
                    ! of u
                    if (k > 2) then
                       ! store u(k) and u(k-1) in columns k and k-1 of a
                       d12 = w(k - 1, kw)
                       d11 = w(k, kw)/d12
                       d22 = w(k - 1, kw - 1)/d12
                       t = cone/(d11*d22 - cone)
                       do j = 1, k - 2
                          a(j, k - 1) = t*((d11*w(j, kw - 1) - w(j, kw))/d12)
                          a(j, k) = t*((d22*w(j, kw) - w(j, kw - 1))/d12)
                       end do
                    end if
                    ! copy d(k) to a
                    a(k - 1, k - 1) = w(k - 1, kw - 1)
                    a(k - 1, k) = w(k - 1, kw)
                    a(k, k) = w(k, kw)
                 end if
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -p
                 ipiv(k - 1) = -kp
              end if
              ! decrease k and return to the start of the main loop
              k = k - kstep
              go to 10
30      continue
              ! update the upper triangle of a11 (= a(1:k,1:k)) as
              ! a11 := a11 - u12*d*u12**t = a11 - u12*w**t
              ! computing blocks of nb columns at a time
              do j = ((k - 1)/nb)*nb + 1, 1, -nb
                 jb = min(nb, k - j + 1)
                 ! update the upper triangle of the diagonal block
                 do jj = j, j + jb - 1
                    call stdlib_zgemv('no transpose', jj - j + 1, n - k, -cone, a(j, k + 1), lda, w(jj, &
                               kw + 1), ldw, cone, a(j, jj), 1)
                 end do
                 ! update the rectangular superdiagonal block
                 if (j >= 2) call stdlib_zgemm('no transpose', 'transpose', j - 1, jb, n - k, -cone, a( &
                           1, k + 1), lda, w(j, kw + 1), ldw, cone, a(1, j), lda)
              end do
              ! put u12 in standard form by partially undoing the interchanges
              ! in columns k+1:n
              j = k + 1
60      continue
                 kstep = 1
                 jp1 = 1
                 jj = j
                 jp2 = ipiv(j)
                 if (jp2 < 0) then
                    jp2 = -jp2
                    j = j + 1
                    jp1 = -ipiv(j)
                    kstep = 2
                 end if
                 j = j + 1
                 if (jp2 /= jj .and. j <= n) call stdlib_zswap(n - j + 1, a(jp2, j), lda, a(jj, j), &
                           lda)
                 jj = j - 1
                 if (jp1 /= jj .and. kstep == 2) call stdlib_zswap(n - j + 1, a(jp1, j), lda, a(jj, j &
                           ), lda)
              if (j <= n) go to 60
              ! set kb to the number of columns factorized
              kb = n - k
           else
              ! factorize the leading columns of a using the lower triangle
              ! of a and working forwards, and compute the matrix w = l21*d
              ! for use in updating a22
              ! k is the main loop index, increasing from 1 in steps of 1 or 2
              k = 1
70      continue
              ! exit from loop
              if ((k >= nb .and. nb < n) .or. k > n) go to 90
              kstep = 1
              p = k
              ! copy column k of a to column k of w and update it
              call stdlib_zcopy(n - k + 1, a(k, k), 1, w(k, k), 1)
              if (k > 1) call stdlib_zgemv('no transpose', n - k + 1, k - 1, -cone, a(k, 1), lda, w(k, &
                        1), ldw, cone, w(k, k), 1)
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = cabs1(w(k, k))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k < n) then
                 imax = k + stdlib_izamax(n - k, w(k + 1, k), 1)
                 colmax = cabs1(w(imax, k))
              else
                 colmax = zero
              end if
              if (max(absakk, colmax) == zero) then
                 ! column k is zero or underflow: set info and continue
                 if (info == 0) info = k
                 kp = k
                 call stdlib_zcopy(n - k + 1, w(k, k), 1, a(k, k), 1)
              else
                 ! ============================================================
                 ! test for interchange
                 ! equivalent to testing for absakk>=alpha*colmax
                 ! (used to handle nan and inf)
                 if (.not. (absakk < alpha*colmax)) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    done = .false.
                    ! loop until pivot found
72      continue
                       ! begin pivot search loop body
                       ! copy column imax to column k+1 of w and update it
                       call stdlib_zcopy(imax - k, a(imax, k), lda, w(k, k + 1), 1)
                       call stdlib_zcopy(n - imax + 1, a(imax, imax), 1, w(imax, k + 1), 1)
                       if (k > 1) call stdlib_zgemv('no transpose', n - k + 1, k - 1, -cone, a(k, 1), &
                                 lda, w(imax, 1), ldw, cone, w(k, k + 1), 1)
                       ! jmax is the column-index of the largest off-diagonal
                       ! element in row imax, and rowmax is its absolute value.
                       ! determine both rowmax and jmax.
                       if (imax /= k) then
                          jmax = k - 1 + stdlib_izamax(imax - k, w(k, k + 1), 1)
                          rowmax = cabs1(w(jmax, k + 1))
                       else
                          rowmax = zero
                       end if
                       if (imax < n) then
                          itemp = imax + stdlib_izamax(n - imax, w(imax + 1, k + 1), 1)
                          dtemp = cabs1(w(itemp, k + 1))
                          if (dtemp > rowmax) then
                             rowmax = dtemp
                             jmax = itemp
                          end if
                       end if
                       ! equivalent to testing for
                       ! cabs1( w( imax, k+1 ) )>=alpha*rowmax
                       ! (used to handle nan and inf)
                       if (.not. (cabs1(w(imax, k + 1)) < alpha*rowmax)) then
                          ! interchange rows and columns k and imax,
                          ! use 1-by-1 pivot block
                          kp = imax
                          ! copy column k+1 of w to column k of w
                          call stdlib_zcopy(n - k + 1, w(k, k + 1), 1, w(k, k), 1)
                          done = .true.
                       ! equivalent to testing for rowmax==colmax,
                       ! (used to handle nan and inf)
                       else if ((p == jmax) .or. (rowmax <= colmax)) then
                          ! interchange rows and columns k+1 and imax,
                          ! use 2-by-2 pivot block
                          kp = imax
                          kstep = 2
                          done = .true.
                       else
                          ! pivot not found: set params and repeat
                          p = imax
                          colmax = rowmax
                          imax = jmax
                          ! copy updated jmaxth (next imaxth) column to kth of w
                          call stdlib_zcopy(n - k + 1, w(k, k + 1), 1, w(k, k), 1)
                       end if
                       ! end pivot search loop body
                    if (.not. done) goto 72
                 end if
                 ! ============================================================
                 kk = k + kstep - 1
                 if ((kstep == 2) .and. (p /= k)) then
                    ! copy non-updated column k to column p
                    call stdlib_zcopy(p - k, a(k, k), 1, a(p, k), lda)
                    call stdlib_zcopy(n - p + 1, a(p, k), 1, a(p, p), 1)
                    ! interchange rows k and p in first k columns of a
                    ! and first k+1 columns of w
                    call stdlib_zswap(k, a(k, 1), lda, a(p, 1), lda)
                    call stdlib_zswap(kk, w(k, 1), ldw, w(p, 1), ldw)
                 end if
                 ! updated column kp is already stored in column kk of w
                 if (kp /= kk) then
                    ! copy non-updated column kk to column kp
                    a(kp, k) = a(kk, k)
                    call stdlib_zcopy(kp - k - 1, a(k + 1, kk), 1, a(kp, k + 1), lda)
                    call stdlib_zcopy(n - kp + 1, a(kp, kk), 1, a(kp, kp), 1)
                    ! interchange rows kk and kp in first kk columns of a and w
                    call stdlib_zswap(kk, a(kk, 1), lda, a(kp, 1), lda)
                    call stdlib_zswap(kk, w(kk, 1), ldw, w(kp, 1), ldw)
                 end if
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k of w now holds
                    ! w(k) = l(k)*d(k)
                    ! where l(k) is the k-th column of l
                    ! store l(k) in column k of a
                    call stdlib_zcopy(n - k + 1, w(k, k), 1, a(k, k), 1)
                    if (k < n) then
                       if (cabs1(a(k, k)) >= sfmin) then
                          r1 = cone/a(k, k)
                          call stdlib_zscal(n - k, r1, a(k + 1, k), 1)
                       else if (a(k, k) /= czero) then
                          do ii = k + 1, n
                             a(ii, k) = a(ii, k)/a(k, k)
                          end do
                       end if
                    end if
                 else
                    ! 2-by-2 pivot block d(k): columns k and k+1 of w now hold
                    ! ( w(k) w(k+1) ) = ( l(k) l(k+1) )*d(k)
                    ! where l(k) and l(k+1) are the k-th and (k+1)-th columns
                    ! of l
                    if (k < n - 1) then
                       ! store l(k) and l(k+1) in columns k and k+1 of a
                       d21 = w(k + 1, k)
                       d11 = w(k + 1, k + 1)/d21
                       d22 = w(k, k)/d21
                       t = cone/(d11*d22 - cone)
                       do j = k + 2, n
                          a(j, k) = t*((d11*w(j, k) - w(j, k + 1))/d21)
                          a(j, k + 1) = t*((d22*w(j, k + 1) - w(j, k))/d21)
                       end do
                    end if
                    ! copy d(k) to a
                    a(k, k) = w(k, k)
                    a(k + 1, k) = w(k + 1, k)
                    a(k + 1, k + 1) = w(k + 1, k + 1)
                 end if
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -p
                 ipiv(k + 1) = -kp
              end if
              ! increase k and return to the start of the main loop
              k = k + kstep
              go to 70
90      continue
              ! update the lower triangle of a22 (= a(k:n,k:n)) as
              ! a22 := a22 - l21*d*l21**t = a22 - l21*w**t
              ! computing blocks of nb columns at a time
              do j = k, n, nb
                 jb = min(nb, n - j + 1)
                 ! update the lower triangle of the diagonal block
                 do jj = j, j + jb - 1
                    call stdlib_zgemv('no transpose', j + jb - jj, k - 1, -cone, a(jj, 1), lda, w(jj, &
                               1), ldw, cone, a(jj, jj), 1)
                 end do
                 ! update the rectangular subdiagonal block
                 if (j + jb <= n) call stdlib_zgemm('no transpose', 'transpose', n - j - jb + 1, jb, k - 1, - &
                           cone, a(j + jb, 1), lda, w(j, 1), ldw, cone, a(j + jb, j), lda)
              end do
              ! put l21 in standard form by partially undoing the interchanges
              ! in columns 1:k-1
              j = k - 1
120    continue
                 kstep = 1
                 jp1 = 1
                 jj = j
                 jp2 = ipiv(j)
                 if (jp2 < 0) then
                    jp2 = -jp2
                    j = j - 1
                    jp1 = -ipiv(j)
                    kstep = 2
                 end if
                 j = j - 1
                 if (jp2 /= jj .and. j >= 1) call stdlib_zswap(j, a(jp2, 1), lda, a(jj, 1), lda)
                           
                 jj = j + 1
                 if (jp1 /= jj .and. kstep == 2) call stdlib_zswap(j, a(jp1, 1), lda, a(jj, 1), &
                           lda)
              if (j >= 1) go to 120
              ! set kb to the number of columns factorized
              kb = k - 1
           end if
           return
           ! end of stdlib_zlasyf_rook
     end subroutine stdlib_zlasyf_rook

     ! ZLAT2C converts a COMPLEX*16 triangular matrix, SA, to a COMPLEX
     ! triangular matrix, A.
     ! RMAX is the overflow for the SINGLE PRECISION arithmetic
     ! ZLAT2C checks that all the entries of A are between -RMAX and
     ! RMAX. If not the conversion is aborted and a flag is raised.
     ! This is an auxiliary routine so there is no argument checking.

     subroutine stdlib_zlat2c(uplo, n, a, lda, sa, ldsa, info)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, lda, ldsa, n
           ! .. array arguments ..
           complex(sp) :: sa(ldsa, *)
           complex(dp) :: a(lda, *)
        ! =====================================================================
           ! .. local scalars ..
           integer(ilp) :: i, j
           real(dp) :: rmax
           logical(lk) :: upper
           ! .. intrinsic functions ..
           intrinsic :: dble, aimag
     
           ! .. executable statements ..
           rmax = stdlib_slamch('o')
           upper = stdlib_lsame(uplo, 'u')
           if (upper) then
              do j = 1, n
                 do i = 1, j
                    if ((real(a(i, j), KIND=dp) < -rmax) .or. (real(a(i, j), KIND=dp) > rmax) &
                     .or. (aimag(a(i, j)) < -rmax) .or. (aimag(a(i, j)) > rmax)) &
                               then
                       info = 1
                       go to 50
                    end if
                    sa(i, j) = a(i, j)
                 end do
              end do
           else
              do j = 1, n
                 do i = j, n
                    if ((real(a(i, j), KIND=dp) < -rmax) .or. (real(a(i, j), KIND=dp) > rmax) &
                     .or. (aimag(a(i, j)) < -rmax) .or. (aimag(a(i, j)) > rmax)) &
                               then
                       info = 1
                       go to 50
                    end if
                    sa(i, j) = a(i, j)
                 end do
              end do
           end if
50      continue
           return
           ! end of stdlib_zlat2c
     end subroutine stdlib_zlat2c

     ! ZLATBS solves one of the triangular systems
     ! A * x = s*b,  A**T * x = s*b,  or  A**H * x = s*b,
     ! with scaling to prevent overflow, where A is an upper or lower
     ! triangular band matrix.  Here A**T denotes the transpose of A, x and b
     ! are n-element vectors, and s is a scaling factor, usually less than
     ! or equal to 1, chosen so that the components of x will be less than
     ! the overflow threshold.  If the unscaled problem will not cause
     ! overflow, the Level 2 BLAS routine ZTBSV is called.  If the matrix A
     ! is singular (A(j,j) = 0 for some j), then s is set to 0 and a
     ! non-trivial solution to A*x = 0 is returned.

     subroutine stdlib_zlatbs(uplo, trans, diag, normin, n, kd, ab, ldab, x, scale, cnorm, info)
               
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: diag, normin, trans, uplo
           integer(ilp) :: info, kd, ldab, n
           real(dp) :: scale
           ! .. array arguments ..
           real(dp) :: cnorm(*)
           complex(dp) :: ab(ldab, *), x(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: notran, nounit, upper
           integer(ilp) :: i, imax, j, jfirst, jinc, jlast, jlen, maind
           real(dp) :: bignum, grow, rec, smlnum, tjj, tmax, tscal, xbnd, xj, xmax
           complex(dp) :: csumj, tjjs, uscal, zdum
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, dcmplx, conjg, aimag, max, min
           ! .. statement functions ..
           real(dp) :: cabs1, cabs2
           ! .. statement function definitions ..
           cabs1(zdum) = abs(real(zdum, KIND=dp)) + abs(aimag(zdum))
           cabs2(zdum) = abs(real(zdum, KIND=dp)/2.d0) + abs(aimag(zdum)/2.d0)
           ! .. executable statements ..
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           notran = stdlib_lsame(trans, 'n')
           nounit = stdlib_lsame(diag, 'n')
           ! test the input parameters.
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (.not. notran .and. .not. stdlib_lsame(trans, 't') .and. .not. stdlib_lsame( &
                     trans, 'c')) then
              info = -2
           else if (.not. nounit .and. .not. stdlib_lsame(diag, 'u')) then
              info = -3
           else if (.not. stdlib_lsame(normin, 'y') .and. .not. stdlib_lsame(normin, 'n')) &
                     then
              info = -4
           else if (n < 0) then
              info = -5
           else if (kd < 0) then
              info = -6
           else if (ldab < kd + 1) then
              info = -8
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zlatbs', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           ! determine machine dependent parameters to control overflow.
           smlnum = stdlib_dlamch('safe minimum')
           bignum = one/smlnum
           call stdlib_dlabad(smlnum, bignum)
           smlnum = smlnum/stdlib_dlamch('precision')
           bignum = one/smlnum
           scale = one
           if (stdlib_lsame(normin, 'n')) then
              ! compute the 1-norm of each column, not including the diagonal.
              if (upper) then
                 ! a is upper triangular.
                 do j = 1, n
                    jlen = min(kd, j - 1)
                    cnorm(j) = stdlib_dzasum(jlen, ab(kd + 1 - jlen, j), 1)
                 end do
              else
                 ! a is lower triangular.
                 do j = 1, n
                    jlen = min(kd, n - j)
                    if (jlen > 0) then
                       cnorm(j) = stdlib_dzasum(jlen, ab(2, j), 1)
                    else
                       cnorm(j) = zero
                    end if
                 end do
              end if
           end if
           ! scale the column norms by tscal if the maximum element in cnorm is
           ! greater than bignum/2.
           imax = stdlib_idamax(n, cnorm, 1)
           tmax = cnorm(imax)
           if (tmax <= bignum*half) then
              tscal = one
           else
              tscal = half/(smlnum*tmax)
              call stdlib_dscal(n, tscal, cnorm, 1)
           end if
           ! compute a bound on the computed solution vector to see if the
           ! level 2 blas routine stdlib_ztbsv can be used.
           xmax = zero
           do j = 1, n
              xmax = max(xmax, cabs2(x(j)))
           end do
           xbnd = xmax
           if (notran) then
              ! compute the growth in a * x = b.
              if (upper) then
                 jfirst = n
                 jlast = 1
                 jinc = -1
                 maind = kd + 1
              else
                 jfirst = 1
                 jlast = n
                 jinc = 1
                 maind = 1
              end if
              if (tscal /= one) then
                 grow = zero
                 go to 60
              end if
              if (nounit) then
                 ! a is non-unit triangular.
                 ! compute grow = 1/g(j) and xbnd = 1/m(j).
                 ! initially, g(0) = max{x(i), i=1,...,n}.
                 grow = half/max(xbnd, smlnum)
                 xbnd = grow
                 do j = jfirst, jlast, jinc
                    ! exit the loop if the growth factor is too small.
                    if (grow <= smlnum) go to 60
                    tjjs = ab(maind, j)
                    tjj = cabs1(tjjs)
                    if (tjj >= smlnum) then
                       ! m(j) = g(j-1) / abs(a(j,j))
                       xbnd = min(xbnd, min(one, tjj)*grow)
                    else
                       ! m(j) could overflow, set xbnd to 0.
                       xbnd = zero
                    end if
                    if (tjj + cnorm(j) >= smlnum) then
                       ! g(j) = g(j-1)*( 1 + cnorm(j) / abs(a(j,j)) )
                       grow = grow*(tjj/(tjj + cnorm(j)))
                    else
                       ! g(j) could overflow, set grow to 0.
                       grow = zero
                    end if
                 end do
                 grow = xbnd
              else
                 ! a is unit triangular.
                 ! compute grow = 1/g(j), where g(0) = max{x(i), i=1,...,n}.
                 grow = min(one, half/max(xbnd, smlnum))
                 do j = jfirst, jlast, jinc
                    ! exit the loop if the growth factor is too small.
                    if (grow <= smlnum) go to 60
                    ! g(j) = g(j-1)*( 1 + cnorm(j) )
                    grow = grow*(one/(one + cnorm(j)))
                 end do
              end if
60      continue
           else
              ! compute the growth in a**t * x = b  or  a**h * x = b.
              if (upper) then
                 jfirst = 1
                 jlast = n
                 jinc = 1
                 maind = kd + 1
              else
                 jfirst = n
                 jlast = 1
                 jinc = -1
                 maind = 1
              end if
              if (tscal /= one) then
                 grow = zero
                 go to 90
              end if
              if (nounit) then
                 ! a is non-unit triangular.
                 ! compute grow = 1/g(j) and xbnd = 1/m(j).
                 ! initially, m(0) = max{x(i), i=1,...,n}.
                 grow = half/max(xbnd, smlnum)
                 xbnd = grow
                 do j = jfirst, jlast, jinc
                    ! exit the loop if the growth factor is too small.
                    if (grow <= smlnum) go to 90
                    ! g(j) = max( g(j-1), m(j-1)*( 1 + cnorm(j) ) )
                    xj = one + cnorm(j)
                    grow = min(grow, xbnd/xj)
                    tjjs = ab(maind, j)
                    tjj = cabs1(tjjs)
                    if (tjj >= smlnum) then
                       ! m(j) = m(j-1)*( 1 + cnorm(j) ) / abs(a(j,j))
                       if (xj > tjj) xbnd = xbnd*(tjj/xj)
                    else
                       ! m(j) could overflow, set xbnd to 0.
                       xbnd = zero
                    end if
                 end do
                 grow = min(grow, xbnd)
              else
                 ! a is unit triangular.
                 ! compute grow = 1/g(j), where g(0) = max{x(i), i=1,...,n}.
                 grow = min(one, half/max(xbnd, smlnum))
                 do j = jfirst, jlast, jinc
                    ! exit the loop if the growth factor is too small.
                    if (grow <= smlnum) go to 90
                    ! g(j) = ( 1 + cnorm(j) )*g(j-1)
                    xj = one + cnorm(j)
                    grow = grow/xj
                 end do
              end if
90      continue
           end if
           if ((grow*tscal) > smlnum) then
              ! use the level 2 blas solve if the reciprocal of the bound on
              ! elements of x is not too small.
              call stdlib_ztbsv(uplo, trans, diag, n, kd, ab, ldab, x, 1)
           else
              ! use a level 1 blas solve, scaling intermediate results.
              if (xmax > bignum*half) then
                 ! scale x so that its components are less than or equal to
                 ! bignum in absolute value.
                 scale = (bignum*half)/xmax
                 call stdlib_zdscal(n, scale, x, 1)
                 xmax = bignum
              else
                 xmax = xmax*two
              end if
              if (notran) then
                 ! solve a * x = b
                 loop_120: do j = jfirst, jlast, jinc
                    ! compute x(j) = b(j) / a(j,j), scaling x if necessary.
                    xj = cabs1(x(j))
                    if (nounit) then
                       tjjs = ab(maind, j)*tscal
                    else
                       tjjs = tscal
                       if (tscal == one) go to 110
                    end if
                    tjj = cabs1(tjjs)
                    if (tjj > smlnum) then
                          ! abs(a(j,j)) > smlnum:
                       if (tjj < one) then
                          if (xj > tjj*bignum) then
                                ! scale x by 1/b(j).
                             rec = one/xj
                             call stdlib_zdscal(n, rec, x, 1)
                             scale = scale*rec
                             xmax = xmax*rec
                          end if
                       end if
                       x(j) = stdlib_zladiv(x(j), tjjs)
                       xj = cabs1(x(j))
                    else if (tjj > zero) then
                          ! 0 < abs(a(j,j)) <= smlnum:
                       if (xj > tjj*bignum) then
                             ! scale x by (1/abs(x(j)))*abs(a(j,j))*bignum
                             ! to avoid overflow when dividing by a(j,j).
                          rec = (tjj*bignum)/xj
                          if (cnorm(j) > one) then
                                ! scale by 1/cnorm(j) to avoid overflow when
                                ! multiplying x(j) times column j.
                             rec = rec/cnorm(j)
                          end if
                          call stdlib_zdscal(n, rec, x, 1)
                          scale = scale*rec
                          xmax = xmax*rec
                       end if
                       x(j) = stdlib_zladiv(x(j), tjjs)
                       xj = cabs1(x(j))
                    else
                          ! a(j,j) = 0:  set x(1:n) = 0, x(j) = 1, and
                          ! scale = 0, and compute a solution to a*x = 0.
                       do i = 1, n
                          x(i) = zero
                       end do
                       x(j) = one
                       xj = one
                       scale = zero
                       xmax = zero
                    end if
110    continue
                    ! scale x if necessary to avoid overflow when adding a
                    ! multiple of column j of a.
                    if (xj > one) then
                       rec = one/xj
                       if (cnorm(j) > (bignum - xmax)*rec) then
                          ! scale x by 1/(2*abs(x(j))).
                          rec = rec*half
                          call stdlib_zdscal(n, rec, x, 1)
                          scale = scale*rec
                       end if
                    else if (xj*cnorm(j) > (bignum - xmax)) then
                       ! scale x by 1/2.
                       call stdlib_zdscal(n, half, x, 1)
                       scale = scale*half
                    end if
                    if (upper) then
                       if (j > 1) then
                          ! compute the update
                             ! x(max(1,j-kd):j-1) := x(max(1,j-kd):j-1) -
                                                   ! x(j)* a(max(1,j-kd):j-1,j)
                          jlen = min(kd, j - 1)
                          call stdlib_zaxpy(jlen, -x(j)*tscal, ab(kd + 1 - jlen, j), 1, x(j - jlen &
                                    ), 1)
                          i = stdlib_izamax(j - 1, x, 1)
                          xmax = cabs1(x(i))
                       end if
                    else if (j < n) then
                       ! compute the update
                          ! x(j+1:min(j+kd,n)) := x(j+1:min(j+kd,n)) -
                                                ! x(j) * a(j+1:min(j+kd,n),j)
                       jlen = min(kd, n - j)
                       if (jlen > 0) call stdlib_zaxpy(jlen, -x(j)*tscal, ab(2, j), 1, x(j + 1), &
                                  1)
                       i = j + stdlib_izamax(n - j, x(j + 1), 1)
                       xmax = cabs1(x(i))
                    end if
                 end do loop_120
              else if (stdlib_lsame(trans, 't')) then
                 ! solve a**t * x = b
                 loop_170: do j = jfirst, jlast, jinc
                    ! compute x(j) = b(j) - sum a(k,j)*x(k).
                                          ! k<>j
                    xj = cabs1(x(j))
                    uscal = tscal
                    rec = one/max(xmax, one)
                    if (cnorm(j) > (bignum - xj)*rec) then
                       ! if x(j) could overflow, scale x by 1/(2*xmax).
                       rec = rec*half
                       if (nounit) then
                          tjjs = ab(maind, j)*tscal
                       else
                          tjjs = tscal
                       end if
                       tjj = cabs1(tjjs)
                       if (tjj > one) then
                             ! divide by a(j,j) when scaling x if a(j,j) > 1.
                          rec = min(one, rec*tjj)
                          uscal = stdlib_zladiv(uscal, tjjs)
                       end if
                       if (rec < one) then
                          call stdlib_zdscal(n, rec, x, 1)
                          scale = scale*rec
                          xmax = xmax*rec
                       end if
                    end if
                    csumj = zero
                    if (uscal == cmplx(one, KIND=dp)) then
                       ! if the scaling needed for a in the dot product is 1,
                       ! call stdlib_zdotu to perform the dot product.
                       if (upper) then
                          jlen = min(kd, j - 1)
                          csumj = stdlib_zdotu(jlen, ab(kd + 1 - jlen, j), 1, x(j - jlen), 1)
                                    
                       else
                          jlen = min(kd, n - j)
                          if (jlen > 1) csumj = stdlib_zdotu(jlen, ab(2, j), 1, x(j + 1), 1)
                                    
                       end if
                    else
                       ! otherwise, use in-line code for the dot product.
                       if (upper) then
                          jlen = min(kd, j - 1)
                          do i = 1, jlen
                             csumj = csumj + (ab(kd + i - jlen, j)*uscal)*x(j - jlen - 1 + i)
                          end do
                       else
                          jlen = min(kd, n - j)
                          do i = 1, jlen
                             csumj = csumj + (ab(i + 1, j)*uscal)*x(j + i)
                          end do
                       end if
                    end if
                    if (uscal == cmplx(tscal, KIND=dp)) then
                       ! compute x(j) := ( x(j) - csumj ) / a(j,j) if 1/a(j,j)
                       ! was not used to scale the dotproduct.
                       x(j) = x(j) - csumj
                       xj = cabs1(x(j))
                       if (nounit) then
                          ! compute x(j) = x(j) / a(j,j), scaling if necessary.
                          tjjs = ab(maind, j)*tscal
                       else
                          tjjs = tscal
                          if (tscal == one) go to 160
                       end if
                       tjj = cabs1(tjjs)
                       if (tjj > smlnum) then
                             ! abs(a(j,j)) > smlnum:
                          if (tjj < one) then
                             if (xj > tjj*bignum) then
                                   ! scale x by 1/abs(x(j)).
                                rec = one/xj
                                call stdlib_zdscal(n, rec, x, 1)
                                scale = scale*rec
                                xmax = xmax*rec
                             end if
                          end if
                          x(j) = stdlib_zladiv(x(j), tjjs)
                       else if (tjj > zero) then
                             ! 0 < abs(a(j,j)) <= smlnum:
                          if (xj > tjj*bignum) then
                                ! scale x by (1/abs(x(j)))*abs(a(j,j))*bignum.
                             rec = (tjj*bignum)/xj
                             call stdlib_zdscal(n, rec, x, 1)
                             scale = scale*rec
                             xmax = xmax*rec
                          end if
                          x(j) = stdlib_zladiv(x(j), tjjs)
                       else
                             ! a(j,j) = 0:  set x(1:n) = 0, x(j) = 1, and
                             ! scale = 0 and compute a solution to a**t *x = 0.
                          do i = 1, n
                             x(i) = zero
                          end do
                          x(j) = one
                          scale = zero
                          xmax = zero
                       end if
160    continue
                    else
                       ! compute x(j) := x(j) / a(j,j) - csumj if the dot
                       ! product has already been divided by 1/a(j,j).
                       x(j) = stdlib_zladiv(x(j), tjjs) - csumj
                    end if
                    xmax = max(xmax, cabs1(x(j)))
                 end do loop_170
              else
                 ! solve a**h * x = b
                 loop_220: do j = jfirst, jlast, jinc
                    ! compute x(j) = b(j) - sum a(k,j)*x(k).
                                          ! k<>j
                    xj = cabs1(x(j))
                    uscal = tscal
                    rec = one/max(xmax, one)
                    if (cnorm(j) > (bignum - xj)*rec) then
                       ! if x(j) could overflow, scale x by 1/(2*xmax).
                       rec = rec*half
                       if (nounit) then
                          tjjs = conjg(ab(maind, j))*tscal
                       else
                          tjjs = tscal
                       end if
                       tjj = cabs1(tjjs)
                       if (tjj > one) then
                             ! divide by a(j,j) when scaling x if a(j,j) > 1.
                          rec = min(one, rec*tjj)
                          uscal = stdlib_zladiv(uscal, tjjs)
                       end if
                       if (rec < one) then
                          call stdlib_zdscal(n, rec, x, 1)
                          scale = scale*rec
                          xmax = xmax*rec
                       end if
                    end if
                    csumj = zero
                    if (uscal == cmplx(one, KIND=dp)) then
                       ! if the scaling needed for a in the dot product is 1,
                       ! call stdlib_zdotc to perform the dot product.
                       if (upper) then
                          jlen = min(kd, j - 1)
                          csumj = stdlib_zdotc(jlen, ab(kd + 1 - jlen, j), 1, x(j - jlen), 1)
                                    
                       else
                          jlen = min(kd, n - j)
                          if (jlen > 1) csumj = stdlib_zdotc(jlen, ab(2, j), 1, x(j + 1), 1)
                                    
                       end if
                    else
                       ! otherwise, use in-line code for the dot product.
                       if (upper) then
                          jlen = min(kd, j - 1)
                          do i = 1, jlen
                             csumj = csumj + (conjg(ab(kd + i - jlen, j))*uscal)*x(j - jlen - 1 + i)
                                       
                          end do
                       else
                          jlen = min(kd, n - j)
                          do i = 1, jlen
                             csumj = csumj + (conjg(ab(i + 1, j))*uscal)*x(j + i)
                          end do
                       end if
                    end if
                    if (uscal == cmplx(tscal, KIND=dp)) then
                       ! compute x(j) := ( x(j) - csumj ) / a(j,j) if 1/a(j,j)
                       ! was not used to scale the dotproduct.
                       x(j) = x(j) - csumj
                       xj = cabs1(x(j))
                       if (nounit) then
                          ! compute x(j) = x(j) / a(j,j), scaling if necessary.
                          tjjs = conjg(ab(maind, j))*tscal
                       else
                          tjjs = tscal
                          if (tscal == one) go to 210
                       end if
                       tjj = cabs1(tjjs)
                       if (tjj > smlnum) then
                             ! abs(a(j,j)) > smlnum:
                          if (tjj < one) then
                             if (xj > tjj*bignum) then
                                   ! scale x by 1/abs(x(j)).
                                rec = one/xj
                                call stdlib_zdscal(n, rec, x, 1)
                                scale = scale*rec
                                xmax = xmax*rec
                             end if
                          end if
                          x(j) = stdlib_zladiv(x(j), tjjs)
                       else if (tjj > zero) then
                             ! 0 < abs(a(j,j)) <= smlnum:
                          if (xj > tjj*bignum) then
                                ! scale x by (1/abs(x(j)))*abs(a(j,j))*bignum.
                             rec = (tjj*bignum)/xj
                             call stdlib_zdscal(n, rec, x, 1)
                             scale = scale*rec
                             xmax = xmax*rec
                          end if
                          x(j) = stdlib_zladiv(x(j), tjjs)
                       else
                             ! a(j,j) = 0:  set x(1:n) = 0, x(j) = 1, and
                             ! scale = 0 and compute a solution to a**h *x = 0.
                          do i = 1, n
                             x(i) = zero
                          end do
                          x(j) = one
                          scale = zero
                          xmax = zero
                       end if
210    continue
                    else
                       ! compute x(j) := x(j) / a(j,j) - csumj if the dot
                       ! product has already been divided by 1/a(j,j).
                       x(j) = stdlib_zladiv(x(j), tjjs) - csumj
                    end if
                    xmax = max(xmax, cabs1(x(j)))
                 end do loop_220
              end if
              scale = scale/tscal
           end if
           ! scale the column norms by 1/tscal for return.
           if (tscal /= one) then
              call stdlib_dscal(n, one/tscal, cnorm, 1)
           end if
           return
           ! end of stdlib_zlatbs
     end subroutine stdlib_zlatbs

     ! ZLATPS solves one of the triangular systems
     ! A * x = s*b,  A**T * x = s*b,  or  A**H * x = s*b,
     ! with scaling to prevent overflow, where A is an upper or lower
     ! triangular matrix stored in packed form.  Here A**T denotes the
     ! transpose of A, A**H denotes the conjugate transpose of A, x and b
     ! are n-element vectors, and s is a scaling factor, usually less than
     ! or equal to 1, chosen so that the components of x will be less than
     ! the overflow threshold.  If the unscaled problem will not cause
     ! overflow, the Level 2 BLAS routine ZTPSV is called. If the matrix A
     ! is singular (A(j,j) = 0 for some j), then s is set to 0 and a
     ! non-trivial solution to A*x = 0 is returned.

     subroutine stdlib_zlatps(uplo, trans, diag, normin, n, ap, x, scale, cnorm, info)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: diag, normin, trans, uplo
           integer(ilp) :: info, n
           real(dp) :: scale
           ! .. array arguments ..
           real(dp) :: cnorm(*)
           complex(dp) :: ap(*), x(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: notran, nounit, upper
           integer(ilp) :: i, imax, ip, j, jfirst, jinc, jlast, jlen
           real(dp) :: bignum, grow, rec, smlnum, tjj, tmax, tscal, xbnd, xj, xmax
           complex(dp) :: csumj, tjjs, uscal, zdum
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, dcmplx, conjg, aimag, max, min
           ! .. statement functions ..
           real(dp) :: cabs1, cabs2
           ! .. statement function definitions ..
           cabs1(zdum) = abs(real(zdum, KIND=dp)) + abs(aimag(zdum))
           cabs2(zdum) = abs(real(zdum, KIND=dp)/2.d0) + abs(aimag(zdum)/2.d0)
           ! .. executable statements ..
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           notran = stdlib_lsame(trans, 'n')
           nounit = stdlib_lsame(diag, 'n')
           ! test the input parameters.
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (.not. notran .and. .not. stdlib_lsame(trans, 't') .and. .not. stdlib_lsame( &
                     trans, 'c')) then
              info = -2
           else if (.not. nounit .and. .not. stdlib_lsame(diag, 'u')) then
              info = -3
           else if (.not. stdlib_lsame(normin, 'y') .and. .not. stdlib_lsame(normin, 'n')) &
                     then
              info = -4
           else if (n < 0) then
              info = -5
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zlatps', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           ! determine machine dependent parameters to control overflow.
           smlnum = stdlib_dlamch('safe minimum')
           bignum = one/smlnum
           call stdlib_dlabad(smlnum, bignum)
           smlnum = smlnum/stdlib_dlamch('precision')
           bignum = one/smlnum
           scale = one
           if (stdlib_lsame(normin, 'n')) then
              ! compute the 1-norm of each column, not including the diagonal.
              if (upper) then
                 ! a is upper triangular.
                 ip = 1
                 do j = 1, n
                    cnorm(j) = stdlib_dzasum(j - 1, ap(ip), 1)
                    ip = ip + j
                 end do
              else
                 ! a is lower triangular.
                 ip = 1
                 do j = 1, n - 1
                    cnorm(j) = stdlib_dzasum(n - j, ap(ip + 1), 1)
                    ip = ip + n - j + 1
                 end do
                 cnorm(n) = zero
              end if
           end if
           ! scale the column norms by tscal if the maximum element in cnorm is
           ! greater than bignum/2.
           imax = stdlib_idamax(n, cnorm, 1)
           tmax = cnorm(imax)
           if (tmax <= bignum*half) then
              tscal = one
           else
              tscal = half/(smlnum*tmax)
              call stdlib_dscal(n, tscal, cnorm, 1)
           end if
           ! compute a bound on the computed solution vector to see if the
           ! level 2 blas routine stdlib_ztpsv can be used.
           xmax = zero
           do j = 1, n
              xmax = max(xmax, cabs2(x(j)))
           end do
           xbnd = xmax
           if (notran) then
              ! compute the growth in a * x = b.
              if (upper) then
                 jfirst = n
                 jlast = 1
                 jinc = -1
              else
                 jfirst = 1
                 jlast = n
                 jinc = 1
              end if
              if (tscal /= one) then
                 grow = zero
                 go to 60
              end if
              if (nounit) then
                 ! a is non-unit triangular.
                 ! compute grow = 1/g(j) and xbnd = 1/m(j).
                 ! initially, g(0) = max{x(i), i=1,...,n}.
                 grow = half/max(xbnd, smlnum)
                 xbnd = grow
                 ip = jfirst*(jfirst + 1)/2
                 jlen = n
                 do j = jfirst, jlast, jinc
                    ! exit the loop if the growth factor is too small.
                    if (grow <= smlnum) go to 60
                    tjjs = ap(ip)
                    tjj = cabs1(tjjs)
                    if (tjj >= smlnum) then
                       ! m(j) = g(j-1) / abs(a(j,j))
                       xbnd = min(xbnd, min(one, tjj)*grow)
                    else
                       ! m(j) could overflow, set xbnd to 0.
                       xbnd = zero
                    end if
                    if (tjj + cnorm(j) >= smlnum) then
                       ! g(j) = g(j-1)*( 1 + cnorm(j) / abs(a(j,j)) )
                       grow = grow*(tjj/(tjj + cnorm(j)))
                    else
                       ! g(j) could overflow, set grow to 0.
                       grow = zero
                    end if
                    ip = ip + jinc*jlen
                    jlen = jlen - 1
                 end do
                 grow = xbnd
              else
                 ! a is unit triangular.
                 ! compute grow = 1/g(j), where g(0) = max{x(i), i=1,...,n}.
                 grow = min(one, half/max(xbnd, smlnum))
                 do j = jfirst, jlast, jinc
                    ! exit the loop if the growth factor is too small.
                    if (grow <= smlnum) go to 60
                    ! g(j) = g(j-1)*( 1 + cnorm(j) )
                    grow = grow*(one/(one + cnorm(j)))
                 end do
              end if
60      continue
           else
              ! compute the growth in a**t * x = b  or  a**h * x = b.
              if (upper) then
                 jfirst = 1
                 jlast = n
                 jinc = 1
              else
                 jfirst = n
                 jlast = 1
                 jinc = -1
              end if
              if (tscal /= one) then
                 grow = zero
                 go to 90
              end if
              if (nounit) then
                 ! a is non-unit triangular.
                 ! compute grow = 1/g(j) and xbnd = 1/m(j).
                 ! initially, m(0) = max{x(i), i=1,...,n}.
                 grow = half/max(xbnd, smlnum)
                 xbnd = grow
                 ip = jfirst*(jfirst + 1)/2
                 jlen = 1
                 do j = jfirst, jlast, jinc
                    ! exit the loop if the growth factor is too small.
                    if (grow <= smlnum) go to 90
                    ! g(j) = max( g(j-1), m(j-1)*( 1 + cnorm(j) ) )
                    xj = one + cnorm(j)
                    grow = min(grow, xbnd/xj)
                    tjjs = ap(ip)
                    tjj = cabs1(tjjs)
                    if (tjj >= smlnum) then
                       ! m(j) = m(j-1)*( 1 + cnorm(j) ) / abs(a(j,j))
                       if (xj > tjj) xbnd = xbnd*(tjj/xj)
                    else
                       ! m(j) could overflow, set xbnd to 0.
                       xbnd = zero
                    end if
                    jlen = jlen + 1
                    ip = ip + jinc*jlen
                 end do
                 grow = min(grow, xbnd)
              else
                 ! a is unit triangular.
                 ! compute grow = 1/g(j), where g(0) = max{x(i), i=1,...,n}.
                 grow = min(one, half/max(xbnd, smlnum))
                 do j = jfirst, jlast, jinc
                    ! exit the loop if the growth factor is too small.
                    if (grow <= smlnum) go to 90
                    ! g(j) = ( 1 + cnorm(j) )*g(j-1)
                    xj = one + cnorm(j)
                    grow = grow/xj
                 end do
              end if
90      continue
           end if
           if ((grow*tscal) > smlnum) then
              ! use the level 2 blas solve if the reciprocal of the bound on
              ! elements of x is not too small.
              call stdlib_ztpsv(uplo, trans, diag, n, ap, x, 1)
           else
              ! use a level 1 blas solve, scaling intermediate results.
              if (xmax > bignum*half) then
                 ! scale x so that its components are less than or equal to
                 ! bignum in absolute value.
                 scale = (bignum*half)/xmax
                 call stdlib_zdscal(n, scale, x, 1)
                 xmax = bignum
              else
                 xmax = xmax*two
              end if
              if (notran) then
                 ! solve a * x = b
                 ip = jfirst*(jfirst + 1)/2
                 loop_120: do j = jfirst, jlast, jinc
                    ! compute x(j) = b(j) / a(j,j), scaling x if necessary.
                    xj = cabs1(x(j))
                    if (nounit) then
                       tjjs = ap(ip)*tscal
                    else
                       tjjs = tscal
                       if (tscal == one) go to 110
                    end if
                    tjj = cabs1(tjjs)
                    if (tjj > smlnum) then
                          ! abs(a(j,j)) > smlnum:
                       if (tjj < one) then
                          if (xj > tjj*bignum) then
                                ! scale x by 1/b(j).
                             rec = one/xj
                             call stdlib_zdscal(n, rec, x, 1)
                             scale = scale*rec
                             xmax = xmax*rec
                          end if
                       end if
                       x(j) = stdlib_zladiv(x(j), tjjs)
                       xj = cabs1(x(j))
                    else if (tjj > zero) then
                          ! 0 < abs(a(j,j)) <= smlnum:
                       if (xj > tjj*bignum) then
                             ! scale x by (1/abs(x(j)))*abs(a(j,j))*bignum
                             ! to avoid overflow when dividing by a(j,j).
                          rec = (tjj*bignum)/xj
                          if (cnorm(j) > one) then
                                ! scale by 1/cnorm(j) to avoid overflow when
                                ! multiplying x(j) times column j.
                             rec = rec/cnorm(j)
                          end if
                          call stdlib_zdscal(n, rec, x, 1)
                          scale = scale*rec
                          xmax = xmax*rec
                       end if
                       x(j) = stdlib_zladiv(x(j), tjjs)
                       xj = cabs1(x(j))
                    else
                          ! a(j,j) = 0:  set x(1:n) = 0, x(j) = 1, and
                          ! scale = 0, and compute a solution to a*x = 0.
                       do i = 1, n
                          x(i) = zero
                       end do
                       x(j) = one
                       xj = one
                       scale = zero
                       xmax = zero
                    end if
110    continue
                    ! scale x if necessary to avoid overflow when adding a
                    ! multiple of column j of a.
                    if (xj > one) then
                       rec = one/xj
                       if (cnorm(j) > (bignum - xmax)*rec) then
                          ! scale x by 1/(2*abs(x(j))).
                          rec = rec*half
                          call stdlib_zdscal(n, rec, x, 1)
                          scale = scale*rec
                       end if
                    else if (xj*cnorm(j) > (bignum - xmax)) then
                       ! scale x by 1/2.
                       call stdlib_zdscal(n, half, x, 1)
                       scale = scale*half
                    end if
                    if (upper) then
                       if (j > 1) then
                          ! compute the update
                             ! x(1:j-1) := x(1:j-1) - x(j) * a(1:j-1,j)
                          call stdlib_zaxpy(j - 1, -x(j)*tscal, ap(ip - j + 1), 1, x, 1)
                          i = stdlib_izamax(j - 1, x, 1)
                          xmax = cabs1(x(i))
                       end if
                       ip = ip - j
                    else
                       if (j < n) then
                          ! compute the update
                             ! x(j+1:n) := x(j+1:n) - x(j) * a(j+1:n,j)
                          call stdlib_zaxpy(n - j, -x(j)*tscal, ap(ip + 1), 1, x(j + 1), 1)
                                    
                          i = j + stdlib_izamax(n - j, x(j + 1), 1)
                          xmax = cabs1(x(i))
                       end if
                       ip = ip + n - j + 1
                    end if
                 end do loop_120
              else if (stdlib_lsame(trans, 't')) then
                 ! solve a**t * x = b
                 ip = jfirst*(jfirst + 1)/2
                 jlen = 1
                 loop_170: do j = jfirst, jlast, jinc
                    ! compute x(j) = b(j) - sum a(k,j)*x(k).
                                          ! k<>j
                    xj = cabs1(x(j))
                    uscal = tscal
                    rec = one/max(xmax, one)
                    if (cnorm(j) > (bignum - xj)*rec) then
                       ! if x(j) could overflow, scale x by 1/(2*xmax).
                       rec = rec*half
                       if (nounit) then
                          tjjs = ap(ip)*tscal
                       else
                          tjjs = tscal
                       end if
                       tjj = cabs1(tjjs)
                       if (tjj > one) then
                             ! divide by a(j,j) when scaling x if a(j,j) > 1.
                          rec = min(one, rec*tjj)
                          uscal = stdlib_zladiv(uscal, tjjs)
                       end if
                       if (rec < one) then
                          call stdlib_zdscal(n, rec, x, 1)
                          scale = scale*rec
                          xmax = xmax*rec
                       end if
                    end if
                    csumj = zero
                    if (uscal == cmplx(one, KIND=dp)) then
                       ! if the scaling needed for a in the dot product is 1,
                       ! call stdlib_zdotu to perform the dot product.
                       if (upper) then
                          csumj = stdlib_zdotu(j - 1, ap(ip - j + 1), 1, x, 1)
                       else if (j < n) then
                          csumj = stdlib_zdotu(n - j, ap(ip + 1), 1, x(j + 1), 1)
                       end if
                    else
                       ! otherwise, use in-line code for the dot product.
                       if (upper) then
                          do i = 1, j - 1
                             csumj = csumj + (ap(ip - j + i)*uscal)*x(i)
                          end do
                       else if (j < n) then
                          do i = 1, n - j
                             csumj = csumj + (ap(ip + i)*uscal)*x(j + i)
                          end do
                       end if
                    end if
                    if (uscal == cmplx(tscal, KIND=dp)) then
                       ! compute x(j) := ( x(j) - csumj ) / a(j,j) if 1/a(j,j)
                       ! was not used to scale the dotproduct.
                       x(j) = x(j) - csumj
                       xj = cabs1(x(j))
                       if (nounit) then
                          ! compute x(j) = x(j) / a(j,j), scaling if necessary.
                          tjjs = ap(ip)*tscal
                       else
                          tjjs = tscal
                          if (tscal == one) go to 160
                       end if
                       tjj = cabs1(tjjs)
                       if (tjj > smlnum) then
                             ! abs(a(j,j)) > smlnum:
                          if (tjj < one) then
                             if (xj > tjj*bignum) then
                                   ! scale x by 1/abs(x(j)).
                                rec = one/xj
                                call stdlib_zdscal(n, rec, x, 1)
                                scale = scale*rec
                                xmax = xmax*rec
                             end if
                          end if
                          x(j) = stdlib_zladiv(x(j), tjjs)
                       else if (tjj > zero) then
                             ! 0 < abs(a(j,j)) <= smlnum:
                          if (xj > tjj*bignum) then
                                ! scale x by (1/abs(x(j)))*abs(a(j,j))*bignum.
                             rec = (tjj*bignum)/xj
                             call stdlib_zdscal(n, rec, x, 1)
                             scale = scale*rec
                             xmax = xmax*rec
                          end if
                          x(j) = stdlib_zladiv(x(j), tjjs)
                       else
                             ! a(j,j) = 0:  set x(1:n) = 0, x(j) = 1, and
                             ! scale = 0 and compute a solution to a**t *x = 0.
                          do i = 1, n
                             x(i) = zero
                          end do
                          x(j) = one
                          scale = zero
                          xmax = zero
                       end if
160    continue
                    else
                       ! compute x(j) := x(j) / a(j,j) - csumj if the dot
                       ! product has already been divided by 1/a(j,j).
                       x(j) = stdlib_zladiv(x(j), tjjs) - csumj
                    end if
                    xmax = max(xmax, cabs1(x(j)))
                    jlen = jlen + 1
                    ip = ip + jinc*jlen
                 end do loop_170
              else
                 ! solve a**h * x = b
                 ip = jfirst*(jfirst + 1)/2
                 jlen = 1
                 loop_220: do j = jfirst, jlast, jinc
                    ! compute x(j) = b(j) - sum a(k,j)*x(k).
                                          ! k<>j
                    xj = cabs1(x(j))
                    uscal = tscal
                    rec = one/max(xmax, one)
                    if (cnorm(j) > (bignum - xj)*rec) then
                       ! if x(j) could overflow, scale x by 1/(2*xmax).
                       rec = rec*half
                       if (nounit) then
                          tjjs = conjg(ap(ip))*tscal
                       else
                          tjjs = tscal
                       end if
                       tjj = cabs1(tjjs)
                       if (tjj > one) then
                             ! divide by a(j,j) when scaling x if a(j,j) > 1.
                          rec = min(one, rec*tjj)
                          uscal = stdlib_zladiv(uscal, tjjs)
                       end if
                       if (rec < one) then
                          call stdlib_zdscal(n, rec, x, 1)
                          scale = scale*rec
                          xmax = xmax*rec
                       end if
                    end if
                    csumj = zero
                    if (uscal == cmplx(one, KIND=dp)) then
                       ! if the scaling needed for a in the dot product is 1,
                       ! call stdlib_zdotc to perform the dot product.
                       if (upper) then
                          csumj = stdlib_zdotc(j - 1, ap(ip - j + 1), 1, x, 1)
                       else if (j < n) then
                          csumj = stdlib_zdotc(n - j, ap(ip + 1), 1, x(j + 1), 1)
                       end if
                    else
                       ! otherwise, use in-line code for the dot product.
                       if (upper) then
                          do i = 1, j - 1
                             csumj = csumj + (conjg(ap(ip - j + i))*uscal)*x(i)
                          end do
                       else if (j < n) then
                          do i = 1, n - j
                             csumj = csumj + (conjg(ap(ip + i))*uscal)*x(j + i)
                          end do
                       end if
                    end if
                    if (uscal == cmplx(tscal, KIND=dp)) then
                       ! compute x(j) := ( x(j) - csumj ) / a(j,j) if 1/a(j,j)
                       ! was not used to scale the dotproduct.
                       x(j) = x(j) - csumj
                       xj = cabs1(x(j))
                       if (nounit) then
                          ! compute x(j) = x(j) / a(j,j), scaling if necessary.
                          tjjs = conjg(ap(ip))*tscal
                       else
                          tjjs = tscal
                          if (tscal == one) go to 210
                       end if
                       tjj = cabs1(tjjs)
                       if (tjj > smlnum) then
                             ! abs(a(j,j)) > smlnum:
                          if (tjj < one) then
                             if (xj > tjj*bignum) then
                                   ! scale x by 1/abs(x(j)).
                                rec = one/xj
                                call stdlib_zdscal(n, rec, x, 1)
                                scale = scale*rec
                                xmax = xmax*rec
                             end if
                          end if
                          x(j) = stdlib_zladiv(x(j), tjjs)
                       else if (tjj > zero) then
                             ! 0 < abs(a(j,j)) <= smlnum:
                          if (xj > tjj*bignum) then
                                ! scale x by (1/abs(x(j)))*abs(a(j,j))*bignum.
                             rec = (tjj*bignum)/xj
                             call stdlib_zdscal(n, rec, x, 1)
                             scale = scale*rec
                             xmax = xmax*rec
                          end if
                          x(j) = stdlib_zladiv(x(j), tjjs)
                       else
                             ! a(j,j) = 0:  set x(1:n) = 0, x(j) = 1, and
                             ! scale = 0 and compute a solution to a**h *x = 0.
                          do i = 1, n
                             x(i) = zero
                          end do
                          x(j) = one
                          scale = zero
                          xmax = zero
                       end if
210    continue
                    else
                       ! compute x(j) := x(j) / a(j,j) - csumj if the dot
                       ! product has already been divided by 1/a(j,j).
                       x(j) = stdlib_zladiv(x(j), tjjs) - csumj
                    end if
                    xmax = max(xmax, cabs1(x(j)))
                    jlen = jlen + 1
                    ip = ip + jinc*jlen
                 end do loop_220
              end if
              scale = scale/tscal
           end if
           ! scale the column norms by 1/tscal for return.
           if (tscal /= one) then
              call stdlib_dscal(n, one/tscal, cnorm, 1)
           end if
           return
           ! end of stdlib_zlatps
     end subroutine stdlib_zlatps

     ! ZLATRD reduces NB rows and columns of a complex Hermitian matrix A to
     ! Hermitian tridiagonal form by a unitary similarity
     ! transformation Q**H * A * Q, and returns the matrices V and W which are
     ! needed to apply the transformation to the unreduced part of A.
     ! If UPLO = 'U', ZLATRD reduces the last NB rows and columns of a
     ! matrix, of which the upper triangle is supplied;
     ! if UPLO = 'L', ZLATRD reduces the first NB rows and columns of a
     ! matrix, of which the lower triangle is supplied.
     ! This is an auxiliary routine called by ZHETRD.

     subroutine stdlib_zlatrd(uplo, n, nb, a, lda, e, tau, w, ldw)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: lda, ldw, n, nb
           ! .. array arguments ..
           real(dp) :: e(*)
           complex(dp) :: a(lda, *), tau(*), w(ldw, *)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i, iw
           complex(dp) :: alpha
     
           ! .. intrinsic functions ..
           intrinsic :: dble, min
           ! .. executable statements ..
           ! quick return if possible
           if (n <= 0) return
           if (stdlib_lsame(uplo, 'u')) then
              ! reduce last nb columns of upper triangle
              loop_10: do i = n, n - nb + 1, -1
                 iw = i - n + nb
                 if (i < n) then
                    ! update a(1:i,i)
                    a(i, i) = real(a(i, i), KIND=dp)
                    call stdlib_zlacgv(n - i, w(i, iw + 1), ldw)
                    call stdlib_zgemv('no transpose', i, n - i, -cone, a(1, i + 1), lda, w(i, iw + 1 &
                              ), ldw, cone, a(1, i), 1)
                    call stdlib_zlacgv(n - i, w(i, iw + 1), ldw)
                    call stdlib_zlacgv(n - i, a(i, i + 1), lda)
                    call stdlib_zgemv('no transpose', i, n - i, -cone, w(1, iw + 1), ldw, a(i, i + 1 &
                              ), lda, cone, a(1, i), 1)
                    call stdlib_zlacgv(n - i, a(i, i + 1), lda)
                    a(i, i) = real(a(i, i), KIND=dp)
                 end if
                 if (i > 1) then
                    ! generate elementary reflector h(i) to annihilate
                    ! a(1:i-2,i)
                    alpha = a(i - 1, i)
                    call stdlib_zlarfg(i - 1, alpha, a(1, i), 1, tau(i - 1))
                    e(i - 1) = real(alpha, KIND=dp)
                    a(i - 1, i) = cone
                    ! compute w(1:i-1,i)
                    call stdlib_zhemv('upper', i - 1, cone, a, lda, a(1, i), 1, czero, w(1, iw), &
                               1)
                    if (i < n) then
                       call stdlib_zgemv('conjugate transpose', i - 1, n - i, cone, w(1, iw + 1), ldw, &
                                  a(1, i), 1, czero, w(i + 1, iw), 1)
                       call stdlib_zgemv('no transpose', i - 1, n - i, -cone, a(1, i + 1), lda, w(i + &
                                 1, iw), 1, cone, w(1, iw), 1)
                       call stdlib_zgemv('conjugate transpose', i - 1, n - i, cone, a(1, i + 1), lda, &
                                 a(1, i), 1, czero, w(i + 1, iw), 1)
                       call stdlib_zgemv('no transpose', i - 1, n - i, -cone, w(1, iw + 1), ldw, w(i + &
                                 1, iw), 1, cone, w(1, iw), 1)
                    end if
                    call stdlib_zscal(i - 1, tau(i - 1), w(1, iw), 1)
                    alpha = -chalf*tau(i - 1)*stdlib_zdotc(i - 1, w(1, iw), 1, a(1, i), 1)
                              
                    call stdlib_zaxpy(i - 1, alpha, a(1, i), 1, w(1, iw), 1)
                 end if
              end do loop_10
           else
              ! reduce first nb columns of lower triangle
              loop_20: do i = 1, nb
                 ! update a(i:n,i)
                 a(i, i) = real(a(i, i), KIND=dp)
                 call stdlib_zlacgv(i - 1, w(i, 1), ldw)
                 call stdlib_zgemv('no transpose', n - i + 1, i - 1, -cone, a(i, 1), lda, w(i, 1), &
                           ldw, cone, a(i, i), 1)
                 call stdlib_zlacgv(i - 1, w(i, 1), ldw)
                 call stdlib_zlacgv(i - 1, a(i, 1), lda)
                 call stdlib_zgemv('no transpose', n - i + 1, i - 1, -cone, w(i, 1), ldw, a(i, 1), &
                           lda, cone, a(i, i), 1)
                 call stdlib_zlacgv(i - 1, a(i, 1), lda)
                 a(i, i) = real(a(i, i), KIND=dp)
                 if (i < n) then
                    ! generate elementary reflector h(i) to annihilate
                    ! a(i+2:n,i)
                    alpha = a(i + 1, i)
                    call stdlib_zlarfg(n - i, alpha, a(min(i + 2, n), i), 1, tau(i))
                    e(i) = real(alpha, KIND=dp)
                    a(i + 1, i) = cone
                    ! compute w(i+1:n,i)
                    call stdlib_zhemv('lower', n - i, cone, a(i + 1, i + 1), lda, a(i + 1, i), 1, &
                              czero, w(i + 1, i), 1)
                    call stdlib_zgemv('conjugate transpose', n - i, i - 1, cone, w(i + 1, 1), ldw, a( &
                              i + 1, i), 1, czero, w(1, i), 1)
                    call stdlib_zgemv('no transpose', n - i, i - 1, -cone, a(i + 1, 1), lda, w(1, i) &
                              , 1, cone, w(i + 1, i), 1)
                    call stdlib_zgemv('conjugate transpose', n - i, i - 1, cone, a(i + 1, 1), lda, a( &
                              i + 1, i), 1, czero, w(1, i), 1)
                    call stdlib_zgemv('no transpose', n - i, i - 1, -cone, w(i + 1, 1), ldw, w(1, i) &
                              , 1, cone, w(i + 1, i), 1)
                    call stdlib_zscal(n - i, tau(i), w(i + 1, i), 1)
                    alpha = -chalf*tau(i)*stdlib_zdotc(n - i, w(i + 1, i), 1, a(i + 1, i), 1)
                              
                    call stdlib_zaxpy(n - i, alpha, a(i + 1, i), 1, w(i + 1, i), 1)
                 end if
              end do loop_20
           end if
           return
           ! end of stdlib_zlatrd
     end subroutine stdlib_zlatrd

     ! ZLATRS solves one of the triangular systems
     ! A * x = s*b,  A**T * x = s*b,  or  A**H * x = s*b,
     ! with scaling to prevent overflow.  Here A is an upper or lower
     ! triangular matrix, A**T denotes the transpose of A, A**H denotes the
     ! conjugate transpose of A, x and b are n-element vectors, and s is a
     ! scaling factor, usually less than or equal to 1, chosen so that the
     ! components of x will be less than the overflow threshold.  If the
     ! unscaled problem will not cause overflow, the Level 2 BLAS routine
     ! ZTRSV is called. If the matrix A is singular (A(j,j) = 0 for some j),
     ! then s is set to 0 and a non-trivial solution to A*x = 0 is returned.

     subroutine stdlib_zlatrs(uplo, trans, diag, normin, n, a, lda, x, scale, cnorm, info)
               
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: diag, normin, trans, uplo
           integer(ilp) :: info, lda, n
           real(dp) :: scale
           ! .. array arguments ..
           real(dp) :: cnorm(*)
           complex(dp) :: a(lda, *), x(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: notran, nounit, upper
           integer(ilp) :: i, imax, j, jfirst, jinc, jlast
           real(dp) :: bignum, grow, rec, smlnum, tjj, tmax, tscal, xbnd, xj, xmax
           complex(dp) :: csumj, tjjs, uscal, zdum
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, dcmplx, conjg, aimag, max, min
           ! .. statement functions ..
           real(dp) :: cabs1, cabs2
           ! .. statement function definitions ..
           cabs1(zdum) = abs(real(zdum, KIND=dp)) + abs(aimag(zdum))
           cabs2(zdum) = abs(real(zdum, KIND=dp)/2.d0) + abs(aimag(zdum)/2.d0)
           ! .. executable statements ..
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           notran = stdlib_lsame(trans, 'n')
           nounit = stdlib_lsame(diag, 'n')
           ! test the input parameters.
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (.not. notran .and. .not. stdlib_lsame(trans, 't') .and. .not. stdlib_lsame( &
                     trans, 'c')) then
              info = -2
           else if (.not. nounit .and. .not. stdlib_lsame(diag, 'u')) then
              info = -3
           else if (.not. stdlib_lsame(normin, 'y') .and. .not. stdlib_lsame(normin, 'n')) &
                     then
              info = -4
           else if (n < 0) then
              info = -5
           else if (lda < max(1, n)) then
              info = -7
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zlatrs', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           ! determine machine dependent parameters to control overflow.
           smlnum = stdlib_dlamch('safe minimum')
           bignum = one/smlnum
           call stdlib_dlabad(smlnum, bignum)
           smlnum = smlnum/stdlib_dlamch('precision')
           bignum = one/smlnum
           scale = one
           if (stdlib_lsame(normin, 'n')) then
              ! compute the 1-norm of each column, not including the diagonal.
              if (upper) then
                 ! a is upper triangular.
                 do j = 1, n
                    cnorm(j) = stdlib_dzasum(j - 1, a(1, j), 1)
                 end do
              else
                 ! a is lower triangular.
                 do j = 1, n - 1
                    cnorm(j) = stdlib_dzasum(n - j, a(j + 1, j), 1)
                 end do
                 cnorm(n) = zero
              end if
           end if
           ! scale the column norms by tscal if the maximum element in cnorm is
           ! greater than bignum/2.
           imax = stdlib_idamax(n, cnorm, 1)
           tmax = cnorm(imax)
           if (tmax <= bignum*half) then
              tscal = one
           else
              tscal = half/(smlnum*tmax)
              call stdlib_dscal(n, tscal, cnorm, 1)
           end if
           ! compute a bound on the computed solution vector to see if the
           ! level 2 blas routine stdlib_ztrsv can be used.
           xmax = zero
           do j = 1, n
              xmax = max(xmax, cabs2(x(j)))
           end do
           xbnd = xmax
           if (notran) then
              ! compute the growth in a * x = b.
              if (upper) then
                 jfirst = n
                 jlast = 1
                 jinc = -1
              else
                 jfirst = 1
                 jlast = n
                 jinc = 1
              end if
              if (tscal /= one) then
                 grow = zero
                 go to 60
              end if
              if (nounit) then
                 ! a is non-unit triangular.
                 ! compute grow = 1/g(j) and xbnd = 1/m(j).
                 ! initially, g(0) = max{x(i), i=1,...,n}.
                 grow = half/max(xbnd, smlnum)
                 xbnd = grow
                 do j = jfirst, jlast, jinc
                    ! exit the loop if the growth factor is too small.
                    if (grow <= smlnum) go to 60
                    tjjs = a(j, j)
                    tjj = cabs1(tjjs)
                    if (tjj >= smlnum) then
                       ! m(j) = g(j-1) / abs(a(j,j))
                       xbnd = min(xbnd, min(one, tjj)*grow)
                    else
                       ! m(j) could overflow, set xbnd to 0.
                       xbnd = zero
                    end if
                    if (tjj + cnorm(j) >= smlnum) then
                       ! g(j) = g(j-1)*( 1 + cnorm(j) / abs(a(j,j)) )
                       grow = grow*(tjj/(tjj + cnorm(j)))
                    else
                       ! g(j) could overflow, set grow to 0.
                       grow = zero
                    end if
                 end do
                 grow = xbnd
              else
                 ! a is unit triangular.
                 ! compute grow = 1/g(j), where g(0) = max{x(i), i=1,...,n}.
                 grow = min(one, half/max(xbnd, smlnum))
                 do j = jfirst, jlast, jinc
                    ! exit the loop if the growth factor is too small.
                    if (grow <= smlnum) go to 60
                    ! g(j) = g(j-1)*( 1 + cnorm(j) )
                    grow = grow*(one/(one + cnorm(j)))
                 end do
              end if
60      continue
           else
              ! compute the growth in a**t * x = b  or  a**h * x = b.
              if (upper) then
                 jfirst = 1
                 jlast = n
                 jinc = 1
              else
                 jfirst = n
                 jlast = 1
                 jinc = -1
              end if
              if (tscal /= one) then
                 grow = zero
                 go to 90
              end if
              if (nounit) then
                 ! a is non-unit triangular.
                 ! compute grow = 1/g(j) and xbnd = 1/m(j).
                 ! initially, m(0) = max{x(i), i=1,...,n}.
                 grow = half/max(xbnd, smlnum)
                 xbnd = grow
                 do j = jfirst, jlast, jinc
                    ! exit the loop if the growth factor is too small.
                    if (grow <= smlnum) go to 90
                    ! g(j) = max( g(j-1), m(j-1)*( 1 + cnorm(j) ) )
                    xj = one + cnorm(j)
                    grow = min(grow, xbnd/xj)
                    tjjs = a(j, j)
                    tjj = cabs1(tjjs)
                    if (tjj >= smlnum) then
                       ! m(j) = m(j-1)*( 1 + cnorm(j) ) / abs(a(j,j))
                       if (xj > tjj) xbnd = xbnd*(tjj/xj)
                    else
                       ! m(j) could overflow, set xbnd to 0.
                       xbnd = zero
                    end if
                 end do
                 grow = min(grow, xbnd)
              else
                 ! a is unit triangular.
                 ! compute grow = 1/g(j), where g(0) = max{x(i), i=1,...,n}.
                 grow = min(one, half/max(xbnd, smlnum))
                 do j = jfirst, jlast, jinc
                    ! exit the loop if the growth factor is too small.
                    if (grow <= smlnum) go to 90
                    ! g(j) = ( 1 + cnorm(j) )*g(j-1)
                    xj = one + cnorm(j)
                    grow = grow/xj
                 end do
              end if
90      continue
           end if
           if ((grow*tscal) > smlnum) then
              ! use the level 2 blas solve if the reciprocal of the bound on
              ! elements of x is not too small.
              call stdlib_ztrsv(uplo, trans, diag, n, a, lda, x, 1)
           else
              ! use a level 1 blas solve, scaling intermediate results.
              if (xmax > bignum*half) then
                 ! scale x so that its components are less than or equal to
                 ! bignum in absolute value.
                 scale = (bignum*half)/xmax
                 call stdlib_zdscal(n, scale, x, 1)
                 xmax = bignum
              else
                 xmax = xmax*two
              end if
              if (notran) then
                 ! solve a * x = b
                 loop_120: do j = jfirst, jlast, jinc
                    ! compute x(j) = b(j) / a(j,j), scaling x if necessary.
                    xj = cabs1(x(j))
                    if (nounit) then
                       tjjs = a(j, j)*tscal
                    else
                       tjjs = tscal
                       if (tscal == one) go to 110
                    end if
                    tjj = cabs1(tjjs)
                    if (tjj > smlnum) then
                          ! abs(a(j,j)) > smlnum:
                       if (tjj < one) then
                          if (xj > tjj*bignum) then
                                ! scale x by 1/b(j).
                             rec = one/xj
                             call stdlib_zdscal(n, rec, x, 1)
                             scale = scale*rec
                             xmax = xmax*rec
                          end if
                       end if
                       x(j) = stdlib_zladiv(x(j), tjjs)
                       xj = cabs1(x(j))
                    else if (tjj > zero) then
                          ! 0 < abs(a(j,j)) <= smlnum:
                       if (xj > tjj*bignum) then
                             ! scale x by (1/abs(x(j)))*abs(a(j,j))*bignum
                             ! to avoid overflow when dividing by a(j,j).
                          rec = (tjj*bignum)/xj
                          if (cnorm(j) > one) then
                                ! scale by 1/cnorm(j) to avoid overflow when
                                ! multiplying x(j) times column j.
                             rec = rec/cnorm(j)
                          end if
                          call stdlib_zdscal(n, rec, x, 1)
                          scale = scale*rec
                          xmax = xmax*rec
                       end if
                       x(j) = stdlib_zladiv(x(j), tjjs)
                       xj = cabs1(x(j))
                    else
                          ! a(j,j) = 0:  set x(1:n) = 0, x(j) = 1, and
                          ! scale = 0, and compute a solution to a*x = 0.
                       do i = 1, n
                          x(i) = zero
                       end do
                       x(j) = one
                       xj = one
                       scale = zero
                       xmax = zero
                    end if
110    continue
                    ! scale x if necessary to avoid overflow when adding a
                    ! multiple of column j of a.
                    if (xj > one) then
                       rec = one/xj
                       if (cnorm(j) > (bignum - xmax)*rec) then
                          ! scale x by 1/(2*abs(x(j))).
                          rec = rec*half
                          call stdlib_zdscal(n, rec, x, 1)
                          scale = scale*rec
                       end if
                    else if (xj*cnorm(j) > (bignum - xmax)) then
                       ! scale x by 1/2.
                       call stdlib_zdscal(n, half, x, 1)
                       scale = scale*half
                    end if
                    if (upper) then
                       if (j > 1) then
                          ! compute the update
                             ! x(1:j-1) := x(1:j-1) - x(j) * a(1:j-1,j)
                          call stdlib_zaxpy(j - 1, -x(j)*tscal, a(1, j), 1, x, 1)
                          i = stdlib_izamax(j - 1, x, 1)
                          xmax = cabs1(x(i))
                       end if
                    else
                       if (j < n) then
                          ! compute the update
                             ! x(j+1:n) := x(j+1:n) - x(j) * a(j+1:n,j)
                          call stdlib_zaxpy(n - j, -x(j)*tscal, a(j + 1, j), 1, x(j + 1), 1)
                                    
                          i = j + stdlib_izamax(n - j, x(j + 1), 1)
                          xmax = cabs1(x(i))
                       end if
                    end if
                 end do loop_120
              else if (stdlib_lsame(trans, 't')) then
                 ! solve a**t * x = b
                 loop_170: do j = jfirst, jlast, jinc
                    ! compute x(j) = b(j) - sum a(k,j)*x(k).
                                          ! k<>j
                    xj = cabs1(x(j))
                    uscal = tscal
                    rec = one/max(xmax, one)
                    if (cnorm(j) > (bignum - xj)*rec) then
                       ! if x(j) could overflow, scale x by 1/(2*xmax).
                       rec = rec*half
                       if (nounit) then
                          tjjs = a(j, j)*tscal
                       else
                          tjjs = tscal
                       end if
                       tjj = cabs1(tjjs)
                       if (tjj > one) then
                             ! divide by a(j,j) when scaling x if a(j,j) > 1.
                          rec = min(one, rec*tjj)
                          uscal = stdlib_zladiv(uscal, tjjs)
                       end if
                       if (rec < one) then
                          call stdlib_zdscal(n, rec, x, 1)
                          scale = scale*rec
                          xmax = xmax*rec
                       end if
                    end if
                    csumj = zero
                    if (uscal == cmplx(one, KIND=dp)) then
                       ! if the scaling needed for a in the dot product is 1,
                       ! call stdlib_zdotu to perform the dot product.
                       if (upper) then
                          csumj = stdlib_zdotu(j - 1, a(1, j), 1, x, 1)
                       else if (j < n) then
                          csumj = stdlib_zdotu(n - j, a(j + 1, j), 1, x(j + 1), 1)
                       end if
                    else
                       ! otherwise, use in-line code for the dot product.
                       if (upper) then
                          do i = 1, j - 1
                             csumj = csumj + (a(i, j)*uscal)*x(i)
                          end do
                       else if (j < n) then
                          do i = j + 1, n
                             csumj = csumj + (a(i, j)*uscal)*x(i)
                          end do
                       end if
                    end if
                    if (uscal == cmplx(tscal, KIND=dp)) then
                       ! compute x(j) := ( x(j) - csumj ) / a(j,j) if 1/a(j,j)
                       ! was not used to scale the dotproduct.
                       x(j) = x(j) - csumj
                       xj = cabs1(x(j))
                       if (nounit) then
                          tjjs = a(j, j)*tscal
                       else
                          tjjs = tscal
                          if (tscal == one) go to 160
                       end if
                          ! compute x(j) = x(j) / a(j,j), scaling if necessary.
                       tjj = cabs1(tjjs)
                       if (tjj > smlnum) then
                             ! abs(a(j,j)) > smlnum:
                          if (tjj < one) then
                             if (xj > tjj*bignum) then
                                   ! scale x by 1/abs(x(j)).
                                rec = one/xj
                                call stdlib_zdscal(n, rec, x, 1)
                                scale = scale*rec
                                xmax = xmax*rec
                             end if
                          end if
                          x(j) = stdlib_zladiv(x(j), tjjs)
                       else if (tjj > zero) then
                             ! 0 < abs(a(j,j)) <= smlnum:
                          if (xj > tjj*bignum) then
                                ! scale x by (1/abs(x(j)))*abs(a(j,j))*bignum.
                             rec = (tjj*bignum)/xj
                             call stdlib_zdscal(n, rec, x, 1)
                             scale = scale*rec
                             xmax = xmax*rec
                          end if
                          x(j) = stdlib_zladiv(x(j), tjjs)
                       else
                             ! a(j,j) = 0:  set x(1:n) = 0, x(j) = 1, and
                             ! scale = 0 and compute a solution to a**t *x = 0.
                          do i = 1, n
                             x(i) = zero
                          end do
                          x(j) = one
                          scale = zero
                          xmax = zero
                       end if
160    continue
                    else
                       ! compute x(j) := x(j) / a(j,j) - csumj if the dot
                       ! product has already been divided by 1/a(j,j).
                       x(j) = stdlib_zladiv(x(j), tjjs) - csumj
                    end if
                    xmax = max(xmax, cabs1(x(j)))
                 end do loop_170
              else
                 ! solve a**h * x = b
                 loop_220: do j = jfirst, jlast, jinc
                    ! compute x(j) = b(j) - sum a(k,j)*x(k).
                                          ! k<>j
                    xj = cabs1(x(j))
                    uscal = tscal
                    rec = one/max(xmax, one)
                    if (cnorm(j) > (bignum - xj)*rec) then
                       ! if x(j) could overflow, scale x by 1/(2*xmax).
                       rec = rec*half
                       if (nounit) then
                          tjjs = conjg(a(j, j))*tscal
                       else
                          tjjs = tscal
                       end if
                       tjj = cabs1(tjjs)
                       if (tjj > one) then
                             ! divide by a(j,j) when scaling x if a(j,j) > 1.
                          rec = min(one, rec*tjj)
                          uscal = stdlib_zladiv(uscal, tjjs)
                       end if
                       if (rec < one) then
                          call stdlib_zdscal(n, rec, x, 1)
                          scale = scale*rec
                          xmax = xmax*rec
                       end if
                    end if
                    csumj = zero
                    if (uscal == cmplx(one, KIND=dp)) then
                       ! if the scaling needed for a in the dot product is 1,
                       ! call stdlib_zdotc to perform the dot product.
                       if (upper) then
                          csumj = stdlib_zdotc(j - 1, a(1, j), 1, x, 1)
                       else if (j < n) then
                          csumj = stdlib_zdotc(n - j, a(j + 1, j), 1, x(j + 1), 1)
                       end if
                    else
                       ! otherwise, use in-line code for the dot product.
                       if (upper) then
                          do i = 1, j - 1
                             csumj = csumj + (conjg(a(i, j))*uscal)*x(i)
                          end do
                       else if (j < n) then
                          do i = j + 1, n
                             csumj = csumj + (conjg(a(i, j))*uscal)*x(i)
                          end do
                       end if
                    end if
                    if (uscal == cmplx(tscal, KIND=dp)) then
                       ! compute x(j) := ( x(j) - csumj ) / a(j,j) if 1/a(j,j)
                       ! was not used to scale the dotproduct.
                       x(j) = x(j) - csumj
                       xj = cabs1(x(j))
                       if (nounit) then
                          tjjs = conjg(a(j, j))*tscal
                       else
                          tjjs = tscal
                          if (tscal == one) go to 210
                       end if
                          ! compute x(j) = x(j) / a(j,j), scaling if necessary.
                       tjj = cabs1(tjjs)
                       if (tjj > smlnum) then
                             ! abs(a(j,j)) > smlnum:
                          if (tjj < one) then
                             if (xj > tjj*bignum) then
                                   ! scale x by 1/abs(x(j)).
                                rec = one/xj
                                call stdlib_zdscal(n, rec, x, 1)
                                scale = scale*rec
                                xmax = xmax*rec
                             end if
                          end if
                          x(j) = stdlib_zladiv(x(j), tjjs)
                       else if (tjj > zero) then
                             ! 0 < abs(a(j,j)) <= smlnum:
                          if (xj > tjj*bignum) then
                                ! scale x by (1/abs(x(j)))*abs(a(j,j))*bignum.
                             rec = (tjj*bignum)/xj
                             call stdlib_zdscal(n, rec, x, 1)
                             scale = scale*rec
                             xmax = xmax*rec
                          end if
                          x(j) = stdlib_zladiv(x(j), tjjs)
                       else
                             ! a(j,j) = 0:  set x(1:n) = 0, x(j) = 1, and
                             ! scale = 0 and compute a solution to a**h *x = 0.
                          do i = 1, n
                             x(i) = zero
                          end do
                          x(j) = one
                          scale = zero
                          xmax = zero
                       end if
210    continue
                    else
                       ! compute x(j) := x(j) / a(j,j) - csumj if the dot
                       ! product has already been divided by 1/a(j,j).
                       x(j) = stdlib_zladiv(x(j), tjjs) - csumj
                    end if
                    xmax = max(xmax, cabs1(x(j)))
                 end do loop_220
              end if
              scale = scale/tscal
           end if
           ! scale the column norms by 1/tscal for return.
           if (tscal /= one) then
              call stdlib_dscal(n, one/tscal, cnorm, 1)
           end if
           return
           ! end of stdlib_zlatrs
     end subroutine stdlib_zlatrs

     ! ZLATRZ factors the M-by-(M+L) complex upper trapezoidal matrix
     ! [ A1 A2 ] = [ A(1:M,1:M) A(1:M,N-L+1:N) ] as ( R  0 ) * Z by means
     ! of unitary transformations, where  Z is an (M+L)-by-(M+L) unitary
     ! matrix and, R and A1 are M-by-M upper triangular matrices.

     subroutine stdlib_zlatrz(m, n, l, a, lda, tau, work)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: l, lda, m, n
           ! .. array arguments ..
           complex(dp) :: a(lda, *), tau(*), work(*)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i
           complex(dp) :: alpha
     
           ! .. intrinsic functions ..
           intrinsic :: conjg
           ! .. executable statements ..
           ! quick return if possible
           if (m == 0) then
              return
           else if (m == n) then
              do i = 1, n
                 tau(i) = czero
              end do
              return
           end if
           do i = m, 1, -1
              ! generate elementary reflector h(i) to annihilate
              ! [ a(i,i) a(i,n-l+1:n) ]
              call stdlib_zlacgv(l, a(i, n - l + 1), lda)
              alpha = conjg(a(i, i))
              call stdlib_zlarfg(l + 1, alpha, a(i, n - l + 1), lda, tau(i))
              tau(i) = conjg(tau(i))
              ! apply h(i) to a(1:i-1,i:n) from the right
              call stdlib_zlarz('right', i - 1, n - i + 1, l, a(i, n - l + 1), lda, conjg(tau(i)), a( &
                        1, i), lda, work)
              a(i, i) = conjg(alpha)
           end do
           return
           ! end of stdlib_zlatrz
     end subroutine stdlib_zlatrz

     ! ZLAUNHR_COL_GETRFNP2 computes the modified LU factorization without
     ! pivoting of a complex general M-by-N matrix A. The factorization has
     ! the form:
     ! A - S = L * U,
     ! where:
     ! S is a m-by-n diagonal sign matrix with the diagonal D, so that
     ! D(i) = S(i,i), 1 <= i <= min(M,N). The diagonal D is constructed
     ! as D(i)=-SIGN(A(i,i)), where A(i,i) is the value after performing
     ! i-1 steps of Gaussian elimination. This means that the diagonal
     ! element at each step of "modified" Gaussian elimination is at
     ! least one in absolute value (so that division-by-zero not
     ! possible during the division by the diagonal element);
     ! L is a M-by-N lower triangular matrix with unit diagonal elements
     ! (lower trapezoidal if M > N);
     ! and U is a M-by-N upper triangular matrix
     ! (upper trapezoidal if M < N).
     ! This routine is an auxiliary routine used in the Householder
     ! reconstruction routine ZUNHR_COL. In ZUNHR_COL, this routine is
     ! applied to an M-by-N matrix A with orthonormal columns, where each
     ! element is bounded by one in absolute value. With the choice of
     ! the matrix S above, one can show that the diagonal element at each
     ! step of Gaussian elimination is the largest (in absolute value) in
     ! the column on or below the diagonal, so that no pivoting is required
     ! for numerical stability [1].
     ! For more details on the Householder reconstruction algorithm,
     ! including the modified LU factorization, see [1].
     ! This is the recursive version of the LU factorization algorithm.
     ! Denote A - S by B. The algorithm divides the matrix B into four
     ! submatrices:
     ! [  B11 | B12  ]  where B11 is n1 by n1,
     ! B = [ -----|----- ]        B21 is (m-n1) by n1,
     ! [  B21 | B22  ]        B12 is n1 by n2,
     ! B22 is (m-n1) by n2,
     ! with n1 = min(m,n)/2, n2 = n-n1.
     ! The subroutine calls itself to factor B11, solves for B21,
     ! solves for B12, updates B22, then calls itself to factor B22.
     ! For more details on the recursive LU algorithm, see [2].
     ! ZLAUNHR_COL_GETRFNP2 is called to factorize a block by the blocked
     ! routine ZLAUNHR_COL_GETRFNP, which uses blocked code calling
     ! Level 3 BLAS to update the submatrix. However, ZLAUNHR_COL_GETRFNP2
     ! is self-sufficient and can be used without ZLAUNHR_COL_GETRFNP.
     ! [1] "Reconstructing Householder vectors from tall-skinny QR",
     ! G. Ballard, J. Demmel, L. Grigori, M. Jacquelin, H.D. Nguyen,
     ! E. Solomonik, J. Parallel Distrib. Comput.,
     ! vol. 85, pp. 3-31, 2015.
     ! [2] "Recursion leads to automatic variable blocking for dense linear
     ! algebra algorithms", F. Gustavson, IBM J. of Res. and Dev.,
     ! vol. 41, no. 6, pp. 737-755, 1997.

     recursive subroutine stdlib_zlaunhr_col_getrfnp2(m, n, a, lda, d, info)
     
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: info, lda, m, n
           ! .. array arguments ..
           complex(dp) :: a(lda, *), d(*)
        ! =====================================================================
           
           ! .. local scalars ..
           real(dp) :: sfmin
           integer(ilp) :: i, iinfo, n1, n2
           complex(dp) :: z
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, dcmplx, aimag, sign, max, min
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(z) = abs(real(z, KIND=dp)) + abs(aimag(z))
           ! .. executable statements ..
           ! test the input parameters
           info = 0
           if (m < 0) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, m)) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zlaunhr_col_getrfnp2', -info)
              return
           end if
           ! quick return if possible
           if (min(m, n) == 0) return
           if (m == 1) then
              ! one row case, (also recursion termination case),
              ! use unblocked code
              ! transfer the sign
              d(1) = dcmplx(-sign(one, real(a(1, 1), KIND=dp)))
              ! construct the row of u
              a(1, 1) = a(1, 1) - d(1)
           else if (n == 1) then
              ! one column case, (also recursion termination case),
              ! use unblocked code
              ! transfer the sign
              d(1) = dcmplx(-sign(one, real(a(1, 1), KIND=dp)))
              ! construct the row of u
              a(1, 1) = a(1, 1) - d(1)
              ! scale the elements 2:m of the column
              ! determine machine safe minimum
              sfmin = stdlib_dlamch('s')
              ! construct the subdiagonal elements of l
              if (cabs1(a(1, 1)) >= sfmin) then
                 call stdlib_zscal(m - 1, cone/a(1, 1), a(2, 1), 1)
              else
                 do i = 2, m
                    a(i, 1) = a(i, 1)/a(1, 1)
                 end do
              end if
           else
              ! divide the matrix b into four submatrices
              n1 = min(m, n)/2
              n2 = n - n1
              ! factor b11, recursive call
              call stdlib_zlaunhr_col_getrfnp2(n1, n1, a, lda, d, iinfo)
              ! solve for b21
              call stdlib_ztrsm('r', 'u', 'n', 'n', m - n1, n1, cone, a, lda, a(n1 + 1, 1), lda)
                        
              ! solve for b12
              call stdlib_ztrsm('l', 'l', 'n', 'u', n1, n2, cone, a, lda, a(1, n1 + 1), lda)
                        
              ! update b22, i.e. compute the schur complement
              ! b22 := b22 - b21*b12
              call stdlib_zgemm('n', 'n', m - n1, n2, n1, -cone, a(n1 + 1, 1), lda, a(1, n1 + 1), &
                        lda, cone, a(n1 + 1, n1 + 1), lda)
              ! factor b22, recursive call
              call stdlib_zlaunhr_col_getrfnp2(m - n1, n2, a(n1 + 1, n1 + 1), lda, d(n1 + 1), iinfo)
                        
           end if
           return
           ! end of stdlib_zlaunhr_col_getrfnp2
     end subroutine stdlib_zlaunhr_col_getrfnp2

     ! ZLAUU2 computes the product U * U**H or L**H * L, where the triangular
     ! factor U or L is stored in the upper or lower triangular part of
     ! the array A.
     ! If UPLO = 'U' or 'u' then the upper triangle of the result is stored,
     ! overwriting the factor U in A.
     ! If UPLO = 'L' or 'l' then the lower triangle of the result is stored,
     ! overwriting the factor L in A.
     ! This is the unblocked form of the algorithm, calling Level 2 BLAS.

     subroutine stdlib_zlauu2(uplo, n, a, lda, info)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, lda, n
           ! .. array arguments ..
           complex(dp) :: a(lda, *)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: i
           real(dp) :: aii
     
           ! .. intrinsic functions ..
           intrinsic :: dble, dcmplx, max
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, n)) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zlauu2', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           if (upper) then
              ! compute the product u * u**h.
              do i = 1, n
                 aii = real(a(i, i), KIND=dp)
                 if (i < n) then
                    a(i, i) = aii*aii + dble(stdlib_zdotc(n - i, a(i, i + 1), lda, a(i, i + 1), &
                              lda))
                    call stdlib_zlacgv(n - i, a(i, i + 1), lda)
                    call stdlib_zgemv('no transpose', i - 1, n - i, cone, a(1, i + 1), lda, a(i, i + 1 &
                              ), lda, cmplx(aii, KIND=dp), a(1, i), 1)
                    call stdlib_zlacgv(n - i, a(i, i + 1), lda)
                 else
                    call stdlib_zdscal(i, aii, a(1, i), 1)
                 end if
              end do
           else
              ! compute the product l**h * l.
              do i = 1, n
                 aii = real(a(i, i), KIND=dp)
                 if (i < n) then
                    a(i, i) = aii*aii + dble(stdlib_zdotc(n - i, a(i + 1, i), 1, a(i + 1, i), 1) &
                               )
                    call stdlib_zlacgv(i - 1, a(i, 1), lda)
                    call stdlib_zgemv('conjugate transpose', n - i, i - 1, cone, a(i + 1, 1), lda, a( &
                              i + 1, i), 1, cmplx(aii, KIND=dp), a(i, 1), lda)
                    call stdlib_zlacgv(i - 1, a(i, 1), lda)
                 else
                    call stdlib_zdscal(i, aii, a(i, 1), lda)
                 end if
              end do
           end if
           return
           ! end of stdlib_zlauu2
     end subroutine stdlib_zlauu2

     ! ZLAUUM computes the product U * U**H or L**H * L, where the triangular
     ! factor U or L is stored in the upper or lower triangular part of
     ! the array A.
     ! If UPLO = 'U' or 'u' then the upper triangle of the result is stored,
     ! overwriting the factor U in A.
     ! If UPLO = 'L' or 'l' then the lower triangle of the result is stored,
     ! overwriting the factor L in A.
     ! This is the blocked form of the algorithm, calling Level 3 BLAS.

     subroutine stdlib_zlauum(uplo, n, a, lda, info)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, lda, n
           ! .. array arguments ..
           complex(dp) :: a(lda, *)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: i, ib, nb
     
           ! .. intrinsic functions ..
           intrinsic :: max, min
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, n)) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zlauum', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           ! determine the block size for this environment.
           nb = stdlib_ilaenv(1, 'stdlib_zlauum', uplo, n, -1, -1, -1)
           if (nb <= 1 .or. nb >= n) then
              ! use unblocked code
              call stdlib_zlauu2(uplo, n, a, lda, info)
           else
              ! use blocked code
              if (upper) then
                 ! compute the product u * u**h.
                 do i = 1, n, nb
                    ib = min(nb, n - i + 1)
                    call stdlib_ztrmm('right', 'upper', 'conjugate transpose', 'non-unit', i - 1, &
                              ib, cone, a(i, i), lda, a(1, i), lda)
                    call stdlib_zlauu2('upper', ib, a(i, i), lda, info)
                    if (i + ib <= n) then
                       call stdlib_zgemm('no transpose', 'conjugate transpose', i - 1, ib, n - i - ib + 1, &
                                  cone, a(1, i + ib), lda, a(i, i + ib), lda, cone, a(1, i), lda)
                       call stdlib_zherk('upper', 'no transpose', ib, n - i - ib + 1, one, a(i, i + ib), &
                                  lda, one, a(i, i), lda)
                    end if
                 end do
              else
                 ! compute the product l**h * l.
                 do i = 1, n, nb
                    ib = min(nb, n - i + 1)
                    call stdlib_ztrmm('left', 'lower', 'conjugate transpose', 'non-unit', ib, i - 1, &
                               cone, a(i, i), lda, a(i, 1), lda)
                    call stdlib_zlauu2('lower', ib, a(i, i), lda, info)
                    if (i + ib <= n) then
                       call stdlib_zgemm('conjugate transpose', 'no transpose', ib, i - 1, n - i - ib + 1, &
                                  cone, a(i + ib, i), lda, a(i + ib, 1), lda, cone, a(i, 1), lda)
                       call stdlib_zherk('lower', 'conjugate transpose', ib, n - i - ib + 1, one, a(i + &
                                 ib, i), lda, one, a(i, i), lda)
                    end if
                 end do
              end if
           end if
           return
           ! end of stdlib_zlauum
     end subroutine stdlib_zlauum

     ! ZPBCON estimates the reciprocal of the condition number (in the
     ! 1-norm) of a complex Hermitian positive definite band matrix using
     ! the Cholesky factorization A = U**H*U or A = L*L**H computed by
     ! ZPBTRF.
     ! An estimate is obtained for norm(inv(A)), and the reciprocal of the
     ! condition number is computed as RCOND = 1 / (ANORM * norm(inv(A))).

     subroutine stdlib_zpbcon(uplo, n, kd, ab, ldab, anorm, rcond, work, rwork, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, kd, ldab, n
           real(dp) :: anorm, rcond
           ! .. array arguments ..
           real(dp) :: rwork(*)
           complex(dp) :: ab(ldab, *), work(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: upper
           character :: normin
           integer(ilp) :: ix, kase
           real(dp) :: ainvnm, scale, scalel, scaleu, smlnum
           complex(dp) :: zdum
           ! .. local arrays ..
           integer(ilp) :: isave(3)
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, aimag
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(zdum) = abs(real(zdum, KIND=dp)) + abs(aimag(zdum))
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (kd < 0) then
              info = -3
           else if (ldab < kd + 1) then
              info = -5
           else if (anorm < zero) then
              info = -6
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zpbcon', -info)
              return
           end if
           ! quick return if possible
           rcond = zero
           if (n == 0) then
              rcond = one
              return
           else if (anorm == zero) then
              return
           end if
           smlnum = stdlib_dlamch('safe minimum')
           ! estimate the 1-norm of the inverse.
           kase = 0
           normin = 'n'
10      continue
           call stdlib_zlacn2(n, work(n + 1), work, ainvnm, kase, isave)
           if (kase /= 0) then
              if (upper) then
                 ! multiply by inv(u**h).
                 call stdlib_zlatbs('upper', 'conjugate transpose', 'non-unit', normin, n, kd, ab, &
                            ldab, work, scalel, rwork, info)
                 normin = 'y'
                 ! multiply by inv(u).
                 call stdlib_zlatbs('upper', 'no transpose', 'non-unit', normin, n, kd, ab, ldab, &
                           work, scaleu, rwork, info)
              else
                 ! multiply by inv(l).
                 call stdlib_zlatbs('lower', 'no transpose', 'non-unit', normin, n, kd, ab, ldab, &
                           work, scalel, rwork, info)
                 normin = 'y'
                 ! multiply by inv(l**h).
                 call stdlib_zlatbs('lower', 'conjugate transpose', 'non-unit', normin, n, kd, ab, &
                            ldab, work, scaleu, rwork, info)
              end if
              ! multiply by 1/scale if doing so will not cause overflow.
              scale = scalel*scaleu
              if (scale /= one) then
                 ix = stdlib_izamax(n, work, 1)
                 if (scale < cabs1(work(ix))*smlnum .or. scale == zero) go to 20
                 call stdlib_zdrscl(n, scale, work, 1)
              end if
              go to 10
           end if
           ! compute the estimate of the reciprocal condition number.
           if (ainvnm /= zero) rcond = (one/ainvnm)/anorm
20      continue
           return
           ! end of stdlib_zpbcon
     end subroutine stdlib_zpbcon

     ! ZPBEQU computes row and column scalings intended to equilibrate a
     ! Hermitian positive definite band matrix A and reduce its condition
     ! number (with respect to the two-norm).  S contains the scale factors,
     ! S(i) = 1/sqrt(A(i,i)), chosen so that the scaled matrix B with
     ! elements B(i,j) = S(i)*A(i,j)*S(j) has ones on the diagonal.  This
     ! choice of S puts the condition number of B within a factor N of the
     ! smallest possible condition number over all possible diagonal
     ! scalings.

     subroutine stdlib_zpbequ(uplo, n, kd, ab, ldab, s, scond, amax, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, kd, ldab, n
           real(dp) :: amax, scond
           ! .. array arguments ..
           real(dp) :: s(*)
           complex(dp) :: ab(ldab, *)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: i, j
           real(dp) :: smin
     
           ! .. intrinsic functions ..
           intrinsic :: dble, max, min, sqrt
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (kd < 0) then
              info = -3
           else if (ldab < kd + 1) then
              info = -5
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zpbequ', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) then
              scond = one
              amax = zero
              return
           end if
           if (upper) then
              j = kd + 1
           else
              j = 1
           end if
           ! initialize smin and amax.
           s(1) = real(ab(j, 1), KIND=dp)
           smin = s(1)
           amax = s(1)
           ! find the minimum and maximum diagonal elements.
           do i = 2, n
              s(i) = real(ab(j, i), KIND=dp)
              smin = min(smin, s(i))
              amax = max(amax, s(i))
           end do
           if (smin <= zero) then
              ! find the first non-positive diagonal element and return.
              do i = 1, n
                 if (s(i) <= zero) then
                    info = i
                    return
                 end if
              end do
           else
              ! set the scale factors to the reciprocals
              ! of the diagonal elements.
              do i = 1, n
                 s(i) = one/sqrt(s(i))
              end do
              ! compute scond = min(s(i)) / max(s(i))
              scond = sqrt(smin)/sqrt(amax)
           end if
           return
           ! end of stdlib_zpbequ
     end subroutine stdlib_zpbequ

     ! ZPBSTF computes a split Cholesky factorization of a complex
     ! Hermitian positive definite band matrix A.
     ! This routine is designed to be used in conjunction with ZHBGST.
     ! The factorization has the form  A = S**H*S  where S is a band matrix
     ! of the same bandwidth as A and the following structure:
     ! S = ( U    )
     ! ( M  L )
     ! where U is upper triangular of order m = (n+kd)/2, and L is lower
     ! triangular of order n-m.

     subroutine stdlib_zpbstf(uplo, n, kd, ab, ldab, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, kd, ldab, n
           ! .. array arguments ..
           complex(dp) :: ab(ldab, *)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: j, kld, km, m
           real(dp) :: ajj
     
           ! .. intrinsic functions ..
           intrinsic :: dble, max, min, sqrt
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (kd < 0) then
              info = -3
           else if (ldab < kd + 1) then
              info = -5
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zpbstf', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           kld = max(1, ldab - 1)
           ! set the splitting point m.
           m = (n + kd)/2
           if (upper) then
              ! factorize a(m+1:n,m+1:n) as l**h*l, and update a(1:m,1:m).
              do j = n, m + 1, -1
                 ! compute s(j,j) and test for non-positive-definiteness.
                 ajj = real(ab(kd + 1, j), KIND=dp)
                 if (ajj <= zero) then
                    ab(kd + 1, j) = ajj
                    go to 50
                 end if
                 ajj = sqrt(ajj)
                 ab(kd + 1, j) = ajj
                 km = min(j - 1, kd)
                 ! compute elements j-km:j-1 of the j-th column and update the
                 ! the leading submatrix within the band.
                 call stdlib_zdscal(km, one/ajj, ab(kd + 1 - km, j), 1)
                 call stdlib_zher('upper', km, -one, ab(kd + 1 - km, j), 1, ab(kd + 1, j - km), kld)
                           
              end do
              ! factorize the updated submatrix a(1:m,1:m) as u**h*u.
              do j = 1, m
                 ! compute s(j,j) and test for non-positive-definiteness.
                 ajj = real(ab(kd + 1, j), KIND=dp)
                 if (ajj <= zero) then
                    ab(kd + 1, j) = ajj
                    go to 50
                 end if
                 ajj = sqrt(ajj)
                 ab(kd + 1, j) = ajj
                 km = min(kd, m - j)
                 ! compute elements j+1:j+km of the j-th row and update the
                 ! trailing submatrix within the band.
                 if (km > 0) then
                    call stdlib_zdscal(km, one/ajj, ab(kd, j + 1), kld)
                    call stdlib_zlacgv(km, ab(kd, j + 1), kld)
                    call stdlib_zher('upper', km, -one, ab(kd, j + 1), kld, ab(kd + 1, j + 1), kld)
                              
                    call stdlib_zlacgv(km, ab(kd, j + 1), kld)
                 end if
              end do
           else
              ! factorize a(m+1:n,m+1:n) as l**h*l, and update a(1:m,1:m).
              do j = n, m + 1, -1
                 ! compute s(j,j) and test for non-positive-definiteness.
                 ajj = real(ab(1, j), KIND=dp)
                 if (ajj <= zero) then
                    ab(1, j) = ajj
                    go to 50
                 end if
                 ajj = sqrt(ajj)
                 ab(1, j) = ajj
                 km = min(j - 1, kd)
                 ! compute elements j-km:j-1 of the j-th row and update the
                 ! trailing submatrix within the band.
                 call stdlib_zdscal(km, one/ajj, ab(km + 1, j - km), kld)
                 call stdlib_zlacgv(km, ab(km + 1, j - km), kld)
                 call stdlib_zher('lower', km, -one, ab(km + 1, j - km), kld, ab(1, j - km), kld)
                           
                 call stdlib_zlacgv(km, ab(km + 1, j - km), kld)
              end do
              ! factorize the updated submatrix a(1:m,1:m) as u**h*u.
              do j = 1, m
                 ! compute s(j,j) and test for non-positive-definiteness.
                 ajj = real(ab(1, j), KIND=dp)
                 if (ajj <= zero) then
                    ab(1, j) = ajj
                    go to 50
                 end if
                 ajj = sqrt(ajj)
                 ab(1, j) = ajj
                 km = min(kd, m - j)
                 ! compute elements j+1:j+km of the j-th column and update the
                 ! trailing submatrix within the band.
                 if (km > 0) then
                    call stdlib_zdscal(km, one/ajj, ab(2, j), 1)
                    call stdlib_zher('lower', km, -one, ab(2, j), 1, ab(1, j + 1), kld)
                 end if
              end do
           end if
           return
50      continue
           info = j
           return
           ! end of stdlib_zpbstf
     end subroutine stdlib_zpbstf

     ! ZPBTF2 computes the Cholesky factorization of a complex Hermitian
     ! positive definite band matrix A.
     ! The factorization has the form
     ! A = U**H * U ,  if UPLO = 'U', or
     ! A = L  * L**H,  if UPLO = 'L',
     ! where U is an upper triangular matrix, U**H is the conjugate transpose
     ! of U, and L is lower triangular.
     ! This is the unblocked version of the algorithm, calling Level 2 BLAS.

     subroutine stdlib_zpbtf2(uplo, n, kd, ab, ldab, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, kd, ldab, n
           ! .. array arguments ..
           complex(dp) :: ab(ldab, *)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: j, kld, kn
           real(dp) :: ajj
     
           ! .. intrinsic functions ..
           intrinsic :: dble, max, min, sqrt
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (kd < 0) then
              info = -3
           else if (ldab < kd + 1) then
              info = -5
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zpbtf2', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           kld = max(1, ldab - 1)
           if (upper) then
              ! compute the cholesky factorization a = u**h * u.
              do j = 1, n
                 ! compute u(j,j) and test for non-positive-definiteness.
                 ajj = real(ab(kd + 1, j), KIND=dp)
                 if (ajj <= zero) then
                    ab(kd + 1, j) = ajj
                    go to 30
                 end if
                 ajj = sqrt(ajj)
                 ab(kd + 1, j) = ajj
                 ! compute elements j+1:j+kn of row j and update the
                 ! trailing submatrix within the band.
                 kn = min(kd, n - j)
                 if (kn > 0) then
                    call stdlib_zdscal(kn, one/ajj, ab(kd, j + 1), kld)
                    call stdlib_zlacgv(kn, ab(kd, j + 1), kld)
                    call stdlib_zher('upper', kn, -one, ab(kd, j + 1), kld, ab(kd + 1, j + 1), kld)
                              
                    call stdlib_zlacgv(kn, ab(kd, j + 1), kld)
                 end if
              end do
           else
              ! compute the cholesky factorization a = l*l**h.
              do j = 1, n
                 ! compute l(j,j) and test for non-positive-definiteness.
                 ajj = real(ab(1, j), KIND=dp)
                 if (ajj <= zero) then
                    ab(1, j) = ajj
                    go to 30
                 end if
                 ajj = sqrt(ajj)
                 ab(1, j) = ajj
                 ! compute elements j+1:j+kn of column j and update the
                 ! trailing submatrix within the band.
                 kn = min(kd, n - j)
                 if (kn > 0) then
                    call stdlib_zdscal(kn, one/ajj, ab(2, j), 1)
                    call stdlib_zher('lower', kn, -one, ab(2, j), 1, ab(1, j + 1), kld)
                 end if
              end do
           end if
           return
30      continue
           info = j
           return
           ! end of stdlib_zpbtf2
     end subroutine stdlib_zpbtf2

     ! ZPBTRS solves a system of linear equations A*X = B with a Hermitian
     ! positive definite band matrix A using the Cholesky factorization
     ! A = U**H *U or A = L*L**H computed by ZPBTRF.

     subroutine stdlib_zpbtrs(uplo, n, kd, nrhs, ab, ldab, b, ldb, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, kd, ldab, ldb, n, nrhs
           ! .. array arguments ..
           complex(dp) :: ab(ldab, *), b(ldb, *)
        ! =====================================================================
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: j
     
           ! .. intrinsic functions ..
           intrinsic :: max
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (kd < 0) then
              info = -3
           else if (nrhs < 0) then
              info = -4
           else if (ldab < kd + 1) then
              info = -6
           else if (ldb < max(1, n)) then
              info = -8
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zpbtrs', -info)
              return
           end if
           ! quick return if possible
           if (n == 0 .or. nrhs == 0) return
           if (upper) then
              ! solve a*x = b where a = u**h *u.
              do j = 1, nrhs
                 ! solve u**h *x = b, overwriting b with x.
                 call stdlib_ztbsv('upper', 'conjugate transpose', 'non-unit', n, kd, ab, ldab, b( &
                            1, j), 1)
                 ! solve u*x = b, overwriting b with x.
                 call stdlib_ztbsv('upper', 'no transpose', 'non-unit', n, kd, ab, ldab, b(1, j) &
                           , 1)
              end do
           else
              ! solve a*x = b where a = l*l**h.
              do j = 1, nrhs
                 ! solve l*x = b, overwriting b with x.
                 call stdlib_ztbsv('lower', 'no transpose', 'non-unit', n, kd, ab, ldab, b(1, j) &
                           , 1)
                 ! solve l**h *x = b, overwriting b with x.
                 call stdlib_ztbsv('lower', 'conjugate transpose', 'non-unit', n, kd, ab, ldab, b( &
                            1, j), 1)
              end do
           end if
           return
           ! end of stdlib_zpbtrs
     end subroutine stdlib_zpbtrs

     ! ZPOCON estimates the reciprocal of the condition number (in the
     ! 1-norm) of a complex Hermitian positive definite matrix using the
     ! Cholesky factorization A = U**H*U or A = L*L**H computed by ZPOTRF.
     ! An estimate is obtained for norm(inv(A)), and the reciprocal of the
     ! condition number is computed as RCOND = 1 / (ANORM * norm(inv(A))).

     subroutine stdlib_zpocon(uplo, n, a, lda, anorm, rcond, work, rwork, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, lda, n
           real(dp) :: anorm, rcond
           ! .. array arguments ..
           real(dp) :: rwork(*)
           complex(dp) :: a(lda, *), work(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: upper
           character :: normin
           integer(ilp) :: ix, kase
           real(dp) :: ainvnm, scale, scalel, scaleu, smlnum
           complex(dp) :: zdum
           ! .. local arrays ..
           integer(ilp) :: isave(3)
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, aimag, max
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(zdum) = abs(real(zdum, KIND=dp)) + abs(aimag(zdum))
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, n)) then
              info = -4
           else if (anorm < zero) then
              info = -5
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zpocon', -info)
              return
           end if
           ! quick return if possible
           rcond = zero
           if (n == 0) then
              rcond = one
              return
           else if (anorm == zero) then
              return
           end if
           smlnum = stdlib_dlamch('safe minimum')
           ! estimate the 1-norm of inv(a).
           kase = 0
           normin = 'n'
10      continue
           call stdlib_zlacn2(n, work(n + 1), work, ainvnm, kase, isave)
           if (kase /= 0) then
              if (upper) then
                 ! multiply by inv(u**h).
                 call stdlib_zlatrs('upper', 'conjugate transpose', 'non-unit', normin, n, a, lda, &
                            work, scalel, rwork, info)
                 normin = 'y'
                 ! multiply by inv(u).
                 call stdlib_zlatrs('upper', 'no transpose', 'non-unit', normin, n, a, lda, work, &
                           scaleu, rwork, info)
              else
                 ! multiply by inv(l).
                 call stdlib_zlatrs('lower', 'no transpose', 'non-unit', normin, n, a, lda, work, &
                           scalel, rwork, info)
                 normin = 'y'
                 ! multiply by inv(l**h).
                 call stdlib_zlatrs('lower', 'conjugate transpose', 'non-unit', normin, n, a, lda, &
                            work, scaleu, rwork, info)
              end if
              ! multiply by 1/scale if doing so will not cause overflow.
              scale = scalel*scaleu
              if (scale /= one) then
                 ix = stdlib_izamax(n, work, 1)
                 if (scale < cabs1(work(ix))*smlnum .or. scale == zero) go to 20
                 call stdlib_zdrscl(n, scale, work, 1)
              end if
              go to 10
           end if
           ! compute the estimate of the reciprocal condition number.
           if (ainvnm /= zero) rcond = (one/ainvnm)/anorm
20      continue
           return
           ! end of stdlib_zpocon
     end subroutine stdlib_zpocon

     ! ZPOEQU computes row and column scalings intended to equilibrate a
     ! Hermitian positive definite matrix A and reduce its condition number
     ! (with respect to the two-norm).  S contains the scale factors,
     ! S(i) = 1/sqrt(A(i,i)), chosen so that the scaled matrix B with
     ! elements B(i,j) = S(i)*A(i,j)*S(j) has ones on the diagonal.  This
     ! choice of S puts the condition number of B within a factor N of the
     ! smallest possible condition number over all possible diagonal
     ! scalings.

     subroutine stdlib_zpoequ(n, a, lda, s, scond, amax, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: info, lda, n
           real(dp) :: amax, scond
           ! .. array arguments ..
           real(dp) :: s(*)
           complex(dp) :: a(lda, *)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i
           real(dp) :: smin
     
           ! .. intrinsic functions ..
           intrinsic :: dble, max, min, sqrt
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           if (n < 0) then
              info = -1
           else if (lda < max(1, n)) then
              info = -3
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zpoequ', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) then
              scond = one
              amax = zero
              return
           end if
           ! find the minimum and maximum diagonal elements.
           s(1) = real(a(1, 1), KIND=dp)
           smin = s(1)
           amax = s(1)
           do i = 2, n
              s(i) = real(a(i, i), KIND=dp)
              smin = min(smin, s(i))
              amax = max(amax, s(i))
           end do
           if (smin <= zero) then
              ! find the first non-positive diagonal element and return.
              do i = 1, n
                 if (s(i) <= zero) then
                    info = i
                    return
                 end if
              end do
           else
              ! set the scale factors to the reciprocals
              ! of the diagonal elements.
              do i = 1, n
                 s(i) = one/sqrt(s(i))
              end do
              ! compute scond = min(s(i)) / max(s(i))
              scond = sqrt(smin)/sqrt(amax)
           end if
           return
           ! end of stdlib_zpoequ
     end subroutine stdlib_zpoequ

     ! ZPOEQUB computes row and column scalings intended to equilibrate a
     ! Hermitian positive definite matrix A and reduce its condition number
     ! (with respect to the two-norm).  S contains the scale factors,
     ! S(i) = 1/sqrt(A(i,i)), chosen so that the scaled matrix B with
     ! elements B(i,j) = S(i)*A(i,j)*S(j) has ones on the diagonal.  This
     ! choice of S puts the condition number of B within a factor N of the
     ! smallest possible condition number over all possible diagonal
     ! scalings.
     ! This routine differs from ZPOEQU by restricting the scaling factors
     ! to a power of the radix.  Barring over- and underflow, scaling by
     ! these factors introduces no additional rounding errors.  However, the
     ! scaled diagonal entries are no longer approximately 1 but lie
     ! between sqrt(radix) and 1/sqrt(radix).

     subroutine stdlib_zpoequb(n, a, lda, s, scond, amax, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: info, lda, n
           real(dp) :: amax, scond
           ! .. array arguments ..
           complex(dp) :: a(lda, *)
           real(dp) :: s(*)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i
           real(dp) :: smin, base, tmp
     
           ! .. intrinsic functions ..
           intrinsic :: max, min, sqrt, log, int, real, aimag
           ! .. executable statements ..
           ! test the input parameters.
           ! positive definite only performs 1 pass of equilibration.
           info = 0
           if (n < 0) then
              info = -1
           else if (lda < max(1, n)) then
              info = -3
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zpoequb', -info)
              return
           end if
           ! quick return if possible.
           if (n == 0) then
              scond = one
              amax = zero
              return
           end if
           base = stdlib_dlamch('b')
           tmp = -0.5_dp/log(base)
           ! find the minimum and maximum diagonal elements.
           s(1) = real(a(1, 1), KIND=dp)
           smin = s(1)
           amax = s(1)
           do i = 2, n
              s(i) = real(a(i, i), KIND=dp)
              smin = min(smin, s(i))
              amax = max(amax, s(i))
           end do
           if (smin <= zero) then
              ! find the first non-positive diagonal element and return.
              do i = 1, n
                 if (s(i) <= zero) then
                    info = i
                    return
                 end if
              end do
           else
              ! set the scale factors to the reciprocals
              ! of the diagonal elements.
              do i = 1, n
                 s(i) = base**int(tmp*log(s(i)))
              end do
              ! compute scond = min(s(i)) / max(s(i)).
              scond = sqrt(smin)/sqrt(amax)
           end if
           return
           ! end of stdlib_zpoequb
     end subroutine stdlib_zpoequb

     ! ZPOTF2 computes the Cholesky factorization of a complex Hermitian
     ! positive definite matrix A.
     ! The factorization has the form
     ! A = U**H * U ,  if UPLO = 'U', or
     ! A = L  * L**H,  if UPLO = 'L',
     ! where U is an upper triangular matrix and L is lower triangular.
     ! This is the unblocked version of the algorithm, calling Level 2 BLAS.

     subroutine stdlib_zpotf2(uplo, n, a, lda, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, lda, n
           ! .. array arguments ..
           complex(dp) :: a(lda, *)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: j
           real(dp) :: ajj
     
           ! .. intrinsic functions ..
           intrinsic :: dble, max, sqrt
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, n)) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zpotf2', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           if (upper) then
              ! compute the cholesky factorization a = u**h *u.
              do j = 1, n
                 ! compute u(j,j) and test for non-positive-definiteness.
                 ajj = real(a(j, j), KIND=dp) - dble(stdlib_zdotc(j - 1, a(1, j), 1, a(1, j) &
                           , 1))
                 if (ajj <= zero .or. stdlib_disnan(ajj)) then
                    a(j, j) = ajj
                    go to 30
                 end if
                 ajj = sqrt(ajj)
                 a(j, j) = ajj
                 ! compute elements j+1:n of row j.
                 if (j < n) then
                    call stdlib_zlacgv(j - 1, a(1, j), 1)
                    call stdlib_zgemv('transpose', j - 1, n - j, -cone, a(1, j + 1), lda, a(1, j), &
                              1, cone, a(j, j + 1), lda)
                    call stdlib_zlacgv(j - 1, a(1, j), 1)
                    call stdlib_zdscal(n - j, one/ajj, a(j, j + 1), lda)
                 end if
              end do
           else
              ! compute the cholesky factorization a = l*l**h.
              do j = 1, n
                 ! compute l(j,j) and test for non-positive-definiteness.
                 ajj = real(a(j, j), KIND=dp) - dble(stdlib_zdotc(j - 1, a(j, 1), lda, a(j, &
                           1), lda))
                 if (ajj <= zero .or. stdlib_disnan(ajj)) then
                    a(j, j) = ajj
                    go to 30
                 end if
                 ajj = sqrt(ajj)
                 a(j, j) = ajj
                 ! compute elements j+1:n of column j.
                 if (j < n) then
                    call stdlib_zlacgv(j - 1, a(j, 1), lda)
                    call stdlib_zgemv('no transpose', n - j, j - 1, -cone, a(j + 1, 1), lda, a(j, 1) &
                              , lda, cone, a(j + 1, j), 1)
                    call stdlib_zlacgv(j - 1, a(j, 1), lda)
                    call stdlib_zdscal(n - j, one/ajj, a(j + 1, j), 1)
                 end if
              end do
           end if
           go to 40
30      continue
           info = j
40      continue
           return
           ! end of stdlib_zpotf2
     end subroutine stdlib_zpotf2

     ! ZPOTRF2 computes the Cholesky factorization of a Hermitian
     ! positive definite matrix A using the recursive algorithm.
     ! The factorization has the form
     ! A = U**H * U,  if UPLO = 'U', or
     ! A = L  * L**H,  if UPLO = 'L',
     ! where U is an upper triangular matrix and L is lower triangular.
     ! This is the recursive version of the algorithm. It divides
     ! the matrix into four submatrices:
     ! [  A11 | A12  ]  where A11 is n1 by n1 and A22 is n2 by n2
     ! A = [ -----|----- ]  with n1 = n/2
     ! [  A21 | A22  ]       n2 = n-n1
     ! The subroutine calls itself to factor A11. Update and scale A21
     ! or A12, update A22 then call itself to factor A22.

     recursive subroutine stdlib_zpotrf2(uplo, n, a, lda, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, lda, n
           ! .. array arguments ..
           complex(dp) :: a(lda, *)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: n1, n2, iinfo
           real(dp) :: ajj
     
           ! .. intrinsic functions ..
           intrinsic :: max, dble, sqrt
           ! .. executable statements ..
           ! test the input parameters
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, n)) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zpotrf2', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           ! n=1 case
           if (n == 1) then
              ! test for non-positive-definiteness
              ajj = real(a(1, 1), KIND=dp)
              if (ajj <= zero .or. stdlib_disnan(ajj)) then
                 info = 1
                 return
              end if
              ! factor
              a(1, 1) = sqrt(ajj)
           ! use recursive code
           else
              n1 = n/2
              n2 = n - n1
              ! factor a11
              call stdlib_zpotrf2(uplo, n1, a(1, 1), lda, iinfo)
              if (iinfo /= 0) then
                 info = iinfo
                 return
              end if
              ! compute the cholesky factorization a = u**h*u
              if (upper) then
                 ! update and scale a12
                 call stdlib_ztrsm('l', 'u', 'c', 'n', n1, n2, cone, a(1, 1), lda, a(1, n1 + 1), &
                            lda)
                 ! update and factor a22
                 call stdlib_zherk(uplo, 'c', n2, n1, -one, a(1, n1 + 1), lda, one, a(n1 + 1, n1 + 1 &
                           ), lda)
                 call stdlib_zpotrf2(uplo, n2, a(n1 + 1, n1 + 1), lda, iinfo)
                 if (iinfo /= 0) then
                    info = iinfo + n1
                    return
                 end if
              ! compute the cholesky factorization a = l*l**h
              else
                 ! update and scale a21
                 call stdlib_ztrsm('r', 'l', 'c', 'n', n2, n1, cone, a(1, 1), lda, a(n1 + 1, 1), &
                            lda)
                 ! update and factor a22
                 call stdlib_zherk(uplo, 'n', n2, n1, -one, a(n1 + 1, 1), lda, one, a(n1 + 1, n1 + 1 &
                           ), lda)
                 call stdlib_zpotrf2(uplo, n2, a(n1 + 1, n1 + 1), lda, iinfo)
                 if (iinfo /= 0) then
                    info = iinfo + n1
                    return
                 end if
              end if
           end if
           return
           ! end of stdlib_zpotrf2
     end subroutine stdlib_zpotrf2

     ! ZPOTRS solves a system of linear equations A*X = B with a Hermitian
     ! positive definite matrix A using the Cholesky factorization
     ! A = U**H * U or A = L * L**H computed by ZPOTRF.

     subroutine stdlib_zpotrs(uplo, n, nrhs, a, lda, b, ldb, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, lda, ldb, n, nrhs
           ! .. array arguments ..
           complex(dp) :: a(lda, *), b(ldb, *)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: upper
     
           ! .. intrinsic functions ..
           intrinsic :: max
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (nrhs < 0) then
              info = -3
           else if (lda < max(1, n)) then
              info = -5
           else if (ldb < max(1, n)) then
              info = -7
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zpotrs', -info)
              return
           end if
           ! quick return if possible
           if (n == 0 .or. nrhs == 0) return
           if (upper) then
              ! solve a*x = b where a = u**h *u.
              ! solve u**h *x = b, overwriting b with x.
              call stdlib_ztrsm('left', 'upper', 'conjugate transpose', 'non-unit', n, nrhs, cone, &
                         a, lda, b, ldb)
              ! solve u*x = b, overwriting b with x.
              call stdlib_ztrsm('left', 'upper', 'no transpose', 'non-unit', n, nrhs, cone, a, &
                        lda, b, ldb)
           else
              ! solve a*x = b where a = l*l**h.
              ! solve l*x = b, overwriting b with x.
              call stdlib_ztrsm('left', 'lower', 'no transpose', 'non-unit', n, nrhs, cone, a, &
                        lda, b, ldb)
              ! solve l**h *x = b, overwriting b with x.
              call stdlib_ztrsm('left', 'lower', 'conjugate transpose', 'non-unit', n, nrhs, cone, &
                         a, lda, b, ldb)
           end if
           return
           ! end of stdlib_zpotrs
     end subroutine stdlib_zpotrs

     ! ZPPCON estimates the reciprocal of the condition number (in the
     ! 1-norm) of a complex Hermitian positive definite packed matrix using
     ! the Cholesky factorization A = U**H*U or A = L*L**H computed by
     ! ZPPTRF.
     ! An estimate is obtained for norm(inv(A)), and the reciprocal of the
     ! condition number is computed as RCOND = 1 / (ANORM * norm(inv(A))).

     subroutine stdlib_zppcon(uplo, n, ap, anorm, rcond, work, rwork, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, n
           real(dp) :: anorm, rcond
           ! .. array arguments ..
           real(dp) :: rwork(*)
           complex(dp) :: ap(*), work(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: upper
           character :: normin
           integer(ilp) :: ix, kase
           real(dp) :: ainvnm, scale, scalel, scaleu, smlnum
           complex(dp) :: zdum
           ! .. local arrays ..
           integer(ilp) :: isave(3)
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, aimag
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(zdum) = abs(real(zdum, KIND=dp)) + abs(aimag(zdum))
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (anorm < zero) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zppcon', -info)
              return
           end if
           ! quick return if possible
           rcond = zero
           if (n == 0) then
              rcond = one
              return
           else if (anorm == zero) then
              return
           end if
           smlnum = stdlib_dlamch('safe minimum')
           ! estimate the 1-norm of the inverse.
           kase = 0
           normin = 'n'
10      continue
           call stdlib_zlacn2(n, work(n + 1), work, ainvnm, kase, isave)
           if (kase /= 0) then
              if (upper) then
                 ! multiply by inv(u**h).
                 call stdlib_zlatps('upper', 'conjugate transpose', 'non-unit', normin, n, ap, &
                           work, scalel, rwork, info)
                 normin = 'y'
                 ! multiply by inv(u).
                 call stdlib_zlatps('upper', 'no transpose', 'non-unit', normin, n, ap, work, &
                           scaleu, rwork, info)
              else
                 ! multiply by inv(l).
                 call stdlib_zlatps('lower', 'no transpose', 'non-unit', normin, n, ap, work, &
                           scalel, rwork, info)
                 normin = 'y'
                 ! multiply by inv(l**h).
                 call stdlib_zlatps('lower', 'conjugate transpose', 'non-unit', normin, n, ap, &
                           work, scaleu, rwork, info)
              end if
              ! multiply by 1/scale if doing so will not cause overflow.
              scale = scalel*scaleu
              if (scale /= one) then
                 ix = stdlib_izamax(n, work, 1)
                 if (scale < cabs1(work(ix))*smlnum .or. scale == zero) go to 20
                 call stdlib_zdrscl(n, scale, work, 1)
              end if
              go to 10
           end if
           ! compute the estimate of the reciprocal condition number.
           if (ainvnm /= zero) rcond = (one/ainvnm)/anorm
20      continue
           return
           ! end of stdlib_zppcon
     end subroutine stdlib_zppcon

     ! ZPPEQU computes row and column scalings intended to equilibrate a
     ! Hermitian positive definite matrix A in packed storage and reduce
     ! its condition number (with respect to the two-norm).  S contains the
     ! scale factors, S(i)=1/sqrt(A(i,i)), chosen so that the scaled matrix
     ! B with elements B(i,j)=S(i)*A(i,j)*S(j) has ones on the diagonal.
     ! This choice of S puts the condition number of B within a factor N of
     ! the smallest possible condition number over all possible diagonal
     ! scalings.

     subroutine stdlib_zppequ(uplo, n, ap, s, scond, amax, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, n
           real(dp) :: amax, scond
           ! .. array arguments ..
           real(dp) :: s(*)
           complex(dp) :: ap(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: i, jj
           real(dp) :: smin
     
           ! .. intrinsic functions ..
           intrinsic :: dble, max, min, sqrt
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zppequ', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) then
              scond = one
              amax = zero
              return
           end if
           ! initialize smin and amax.
           s(1) = real(ap(1), KIND=dp)
           smin = s(1)
           amax = s(1)
           if (upper) then
              ! uplo = 'u':  upper triangle of a is stored.
              ! find the minimum and maximum diagonal elements.
              jj = 1
              do i = 2, n
                 jj = jj + i
                 s(i) = real(ap(jj), KIND=dp)
                 smin = min(smin, s(i))
                 amax = max(amax, s(i))
              end do
           else
              ! uplo = 'l':  lower triangle of a is stored.
              ! find the minimum and maximum diagonal elements.
              jj = 1
              do i = 2, n
                 jj = jj + n - i + 2
                 s(i) = real(ap(jj), KIND=dp)
                 smin = min(smin, s(i))
                 amax = max(amax, s(i))
              end do
           end if
           if (smin <= zero) then
              ! find the first non-positive diagonal element and return.
              do i = 1, n
                 if (s(i) <= zero) then
                    info = i
                    return
                 end if
              end do
           else
              ! set the scale factors to the reciprocals
              ! of the diagonal elements.
              do i = 1, n
                 s(i) = one/sqrt(s(i))
              end do
              ! compute scond = min(s(i)) / max(s(i))
              scond = sqrt(smin)/sqrt(amax)
           end if
           return
           ! end of stdlib_zppequ
     end subroutine stdlib_zppequ

     ! ZPPTRF computes the Cholesky factorization of a complex Hermitian
     ! positive definite matrix A stored in packed format.
     ! The factorization has the form
     ! A = U**H * U,  if UPLO = 'U', or
     ! A = L  * L**H,  if UPLO = 'L',
     ! where U is an upper triangular matrix and L is lower triangular.

     subroutine stdlib_zpptrf(uplo, n, ap, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, n
           ! .. array arguments ..
           complex(dp) :: ap(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: j, jc, jj
           real(dp) :: ajj
     
           ! .. intrinsic functions ..
           intrinsic :: dble, sqrt
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zpptrf', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           if (upper) then
              ! compute the cholesky factorization a = u**h * u.
              jj = 0
              do j = 1, n
                 jc = jj + 1
                 jj = jj + j
                 ! compute elements 1:j-1 of column j.
                 if (j > 1) call stdlib_ztpsv('upper', 'conjugate transpose', 'non-unit', j - 1, ap, &
                           ap(jc), 1)
                 ! compute u(j,j) and test for non-positive-definiteness.
                 ajj = real(ap(jj), KIND=dp) - dble(stdlib_zdotc(j - 1, ap(jc), 1, ap(jc), &
                           1))
                 if (ajj <= zero) then
                    ap(jj) = ajj
                    go to 30
                 end if
                 ap(jj) = sqrt(ajj)
              end do
           else
              ! compute the cholesky factorization a = l * l**h.
              jj = 1
              do j = 1, n
                 ! compute l(j,j) and test for non-positive-definiteness.
                 ajj = real(ap(jj), KIND=dp)
                 if (ajj <= zero) then
                    ap(jj) = ajj
                    go to 30
                 end if
                 ajj = sqrt(ajj)
                 ap(jj) = ajj
                 ! compute elements j+1:n of column j and update the trailing
                 ! submatrix.
                 if (j < n) then
                    call stdlib_zdscal(n - j, one/ajj, ap(jj + 1), 1)
                    call stdlib_zhpr('lower', n - j, -one, ap(jj + 1), 1, ap(jj + n - j + 1))
                    jj = jj + n - j + 1
                 end if
              end do
           end if
           go to 40
30      continue
           info = j
40      continue
           return
           ! end of stdlib_zpptrf
     end subroutine stdlib_zpptrf

     ! ZPPTRS solves a system of linear equations A*X = B with a Hermitian
     ! positive definite matrix A in packed storage using the Cholesky
     ! factorization A = U**H * U or A = L * L**H computed by ZPPTRF.

     subroutine stdlib_zpptrs(uplo, n, nrhs, ap, b, ldb, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, ldb, n, nrhs
           ! .. array arguments ..
           complex(dp) :: ap(*), b(ldb, *)
        ! =====================================================================
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: i
     
           ! .. intrinsic functions ..
           intrinsic :: max
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (nrhs < 0) then
              info = -3
           else if (ldb < max(1, n)) then
              info = -6
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zpptrs', -info)
              return
           end if
           ! quick return if possible
           if (n == 0 .or. nrhs == 0) return
           if (upper) then
              ! solve a*x = b where a = u**h * u.
              do i = 1, nrhs
                 ! solve u**h *x = b, overwriting b with x.
                 call stdlib_ztpsv('upper', 'conjugate transpose', 'non-unit', n, ap, b(1, i), &
                           1)
                 ! solve u*x = b, overwriting b with x.
                 call stdlib_ztpsv('upper', 'no transpose', 'non-unit', n, ap, b(1, i), 1)
                           
              end do
           else
              ! solve a*x = b where a = l * l**h.
              do i = 1, nrhs
                 ! solve l*y = b, overwriting b with x.
                 call stdlib_ztpsv('lower', 'no transpose', 'non-unit', n, ap, b(1, i), 1)
                           
                 ! solve l**h *x = y, overwriting b with x.
                 call stdlib_ztpsv('lower', 'conjugate transpose', 'non-unit', n, ap, b(1, i), &
                           1)
              end do
           end if
           return
           ! end of stdlib_zpptrs
     end subroutine stdlib_zpptrs

     ! ZPSTF2 computes the Cholesky factorization with complete
     ! pivoting of a complex Hermitian positive semidefinite matrix A.
     ! The factorization has the form
     ! P**T * A * P = U**H * U ,  if UPLO = 'U',
     ! P**T * A * P = L  * L**H,  if UPLO = 'L',
     ! where U is an upper triangular matrix and L is lower triangular, and
     ! P is stored as vector PIV.
     ! This algorithm does not attempt to check that A is positive
     ! semidefinite. This version of the algorithm calls level 2 BLAS.

     subroutine stdlib_zpstf2(uplo, n, a, lda, piv, rank, tol, work, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           real(dp) :: tol
           integer(ilp) :: info, lda, n, rank
           character :: uplo
           ! .. array arguments ..
           complex(dp) :: a(lda, *)
           real(dp) :: work(2*n)
           integer(ilp) :: piv(n)
        ! =====================================================================
           
           ! .. local scalars ..
           complex(dp) :: ztemp
           real(dp) :: ajj, dstop, dtemp
           integer(ilp) :: i, itemp, j, pvt
           logical(lk) :: upper
     
           ! .. intrinsic functions ..
           intrinsic :: dble, conjg, max, sqrt
           ! .. executable statements ..
           ! test the input parameters
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, n)) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zpstf2', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           ! initialize piv
           do i = 1, n
              piv(i) = i
           end do
           ! compute stopping value
           do i = 1, n
              work(i) = real(a(i, i), KIND=dp)
           end do
           pvt = maxloc(work(1:n), 1)
           ajj = real(a(pvt, pvt), KIND=dp)
           if (ajj <= zero .or. stdlib_disnan(ajj)) then
              rank = 0
              info = 1
              go to 200
           end if
           ! compute stopping value if not supplied
           if (tol < zero) then
              dstop = n*stdlib_dlamch('epsilon')*ajj
           else
              dstop = tol
           end if
           ! set first chalf of work to zero, holds dot products
           do i = 1, n
              work(i) = 0
           end do
           if (upper) then
              ! compute the cholesky factorization p**t * a * p = u**h* u
              loop_150: do j = 1, n
              ! find pivot, test for exit, else swap rows and columns
              ! update dot products, compute possible pivots which are
              ! stored in the second chalf of work
                 do i = j, n
                    if (j > 1) then
                       work(i) = work(i) + dble(conjg(a(j - 1, i))*a(j - 1, i))
                    end if
                    work(n + i) = real(a(i, i), KIND=dp) - work(i)
                 end do
                 if (j > 1) then
                    itemp = maxloc(work((n + j):(2*n)), 1)
                    pvt = itemp + j - 1
                    ajj = work(n + pvt)
                    if (ajj <= dstop .or. stdlib_disnan(ajj)) then
                       a(j, j) = ajj
                       go to 190
                    end if
                 end if
                 if (j /= pvt) then
                    ! pivot ok, so can now swap pivot rows and columns
                    a(pvt, pvt) = a(j, j)
                    call stdlib_zswap(j - 1, a(1, j), 1, a(1, pvt), 1)
                    if (pvt < n) call stdlib_zswap(n - pvt, a(j, pvt + 1), lda, a(pvt, pvt + 1), lda)
                              
                    do i = j + 1, pvt - 1
                       ztemp = conjg(a(j, i))
                       a(j, i) = conjg(a(i, pvt))
                       a(i, pvt) = ztemp
                    end do
                    a(j, pvt) = conjg(a(j, pvt))
                    ! swap dot products and piv
                    dtemp = work(j)
                    work(j) = work(pvt)
                    work(pvt) = dtemp
                    itemp = piv(pvt)
                    piv(pvt) = piv(j)
                    piv(j) = itemp
                 end if
                 ajj = sqrt(ajj)
                 a(j, j) = ajj
                 ! compute elements j+1:n of row j
                 if (j < n) then
                    call stdlib_zlacgv(j - 1, a(1, j), 1)
                    call stdlib_zgemv('trans', j - 1, n - j, -cone, a(1, j + 1), lda, a(1, j), 1, &
                              cone, a(j, j + 1), lda)
                    call stdlib_zlacgv(j - 1, a(1, j), 1)
                    call stdlib_zdscal(n - j, one/ajj, a(j, j + 1), lda)
                 end if
              end do loop_150
           else
              ! compute the cholesky factorization p**t * a * p = l * l**h
              loop_180: do j = 1, n
              ! find pivot, test for exit, else swap rows and columns
              ! update dot products, compute possible pivots which are
              ! stored in the second chalf of work
                 do i = j, n
                    if (j > 1) then
                       work(i) = work(i) + dble(conjg(a(i, j - 1))*a(i, j - 1))
                    end if
                    work(n + i) = real(a(i, i), KIND=dp) - work(i)
                 end do
                 if (j > 1) then
                    itemp = maxloc(work((n + j):(2*n)), 1)
                    pvt = itemp + j - 1
                    ajj = work(n + pvt)
                    if (ajj <= dstop .or. stdlib_disnan(ajj)) then
                       a(j, j) = ajj
                       go to 190
                    end if
                 end if
                 if (j /= pvt) then
                    ! pivot ok, so can now swap pivot rows and columns
                    a(pvt, pvt) = a(j, j)
                    call stdlib_zswap(j - 1, a(j, 1), lda, a(pvt, 1), lda)
                    if (pvt < n) call stdlib_zswap(n - pvt, a(pvt + 1, j), 1, a(pvt + 1, pvt), 1)
                              
                    do i = j + 1, pvt - 1
                       ztemp = conjg(a(i, j))
                       a(i, j) = conjg(a(pvt, i))
                       a(pvt, i) = ztemp
                    end do
                    a(pvt, j) = conjg(a(pvt, j))
                    ! swap dot products and piv
                    dtemp = work(j)
                    work(j) = work(pvt)
                    work(pvt) = dtemp
                    itemp = piv(pvt)
                    piv(pvt) = piv(j)
                    piv(j) = itemp
                 end if
                 ajj = sqrt(ajj)
                 a(j, j) = ajj
                 ! compute elements j+1:n of column j
                 if (j < n) then
                    call stdlib_zlacgv(j - 1, a(j, 1), lda)
                    call stdlib_zgemv('no trans', n - j, j - 1, -cone, a(j + 1, 1), lda, a(j, 1), &
                              lda, cone, a(j + 1, j), 1)
                    call stdlib_zlacgv(j - 1, a(j, 1), lda)
                    call stdlib_zdscal(n - j, one/ajj, a(j + 1, j), 1)
                 end if
              end do loop_180
           end if
           ! ran to completion, a has full rank
           rank = n
           go to 200
190    continue
           ! rank is number of steps completed.  set info = 1 to signal
           ! that the factorization cannot be used to solve a system.
           rank = j - 1
           info = 1
200    continue
           return
           ! end of stdlib_zpstf2
     end subroutine stdlib_zpstf2

     ! ZPTCON computes the reciprocal of the condition number (in the
     ! 1-norm) of a complex Hermitian positive definite tridiagonal matrix
     ! using the factorization A = L*D*L**H or A = U**H*D*U computed by
     ! ZPTTRF.
     ! Norm(inv(A)) is computed by a direct method, and the reciprocal of
     ! the condition number is computed as
     ! RCOND = 1 / (ANORM * norm(inv(A))).

     subroutine stdlib_zptcon(n, d, e, anorm, rcond, rwork, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: info, n
           real(dp) :: anorm, rcond
           ! .. array arguments ..
           real(dp) :: d(*), rwork(*)
           complex(dp) :: e(*)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i, ix
           real(dp) :: ainvnm
     
           ! .. intrinsic functions ..
           intrinsic :: abs
           ! .. executable statements ..
           ! test the input arguments.
           info = 0
           if (n < 0) then
              info = -1
           else if (anorm < zero) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zptcon', -info)
              return
           end if
           ! quick return if possible
           rcond = zero
           if (n == 0) then
              rcond = one
              return
           else if (anorm == zero) then
              return
           end if
           ! check that d(1:n) is positive.
           do i = 1, n
              if (d(i) <= zero) return
           end do
           ! solve m(a) * x = e, where m(a) = (m(i,j)) is given by
              ! m(i,j) =  abs(a(i,j)), i = j,
              ! m(i,j) = -abs(a(i,j)), i .ne. j,
           ! and e = [ 1, 1, ..., 1 ]**t.  note m(a) = m(l)*d*m(l)**h.
           ! solve m(l) * x = e.
           rwork(1) = one
           do i = 2, n
              rwork(i) = one + rwork(i - 1)*abs(e(i - 1))
           end do
           ! solve d * m(l)**h * x = b.
           rwork(n) = rwork(n)/d(n)
           do i = n - 1, 1, -1
              rwork(i) = rwork(i)/d(i) + rwork(i + 1)*abs(e(i))
           end do
           ! compute ainvnm = max(x(i)), 1<=i<=n.
           ix = stdlib_idamax(n, rwork, 1)
           ainvnm = abs(rwork(ix))
           ! compute the reciprocal condition number.
           if (ainvnm /= zero) rcond = (one/ainvnm)/anorm
           return
           ! end of stdlib_zptcon
     end subroutine stdlib_zptcon

     ! ZPTTRF computes the L*D*L**H factorization of a complex Hermitian
     ! positive definite tridiagonal matrix A.  The factorization may also
     ! be regarded as having the form A = U**H *D*U.

     subroutine stdlib_zpttrf(n, d, e, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: info, n
           ! .. array arguments ..
           real(dp) :: d(*)
           complex(dp) :: e(*)
        ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i, i4
           real(dp) :: eii, eir, f, g
     
           ! .. intrinsic functions ..
           intrinsic :: dble, dcmplx, aimag, mod
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           if (n < 0) then
              info = -1
              call stdlib_xerbla('stdlib_zpttrf', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           ! compute the l*d*l**h (or u**h *d*u) factorization of a.
           i4 = mod(n - 1, 4)
           do i = 1, i4
              if (d(i) <= zero) then
                 info = i
                 go to 30
              end if
              eir = real(e(i), KIND=dp)
              eii = aimag(e(i))
              f = eir/d(i)
              g = eii/d(i)
              e(i) = cmplx(f, g, KIND=dp)
              d(i + 1) = d(i + 1) - f*eir - g*eii
           end do
           loop_20: do i = i4 + 1, n - 4, 4
              ! drop out of the loop if d(i) <= 0: the matrix is not positive
              ! definite.
              if (d(i) <= zero) then
                 info = i
                 go to 30
              end if
              ! solve for e(i) and d(i+1).
              eir = real(e(i), KIND=dp)
              eii = aimag(e(i))
              f = eir/d(i)
              g = eii/d(i)
              e(i) = cmplx(f, g, KIND=dp)
              d(i + 1) = d(i + 1) - f*eir - g*eii
              if (d(i + 1) <= zero) then
                 info = i + 1
                 go to 30
              end if
              ! solve for e(i+1) and d(i+2).
              eir = real(e(i + 1), KIND=dp)
              eii = aimag(e(i + 1))
              f = eir/d(i + 1)
              g = eii/d(i + 1)
              e(i + 1) = cmplx(f, g, KIND=dp)
              d(i + 2) = d(i + 2) - f*eir - g*eii
              if (d(i + 2) <= zero) then
                 info = i + 2
                 go to 30
              end if
              ! solve for e(i+2) and d(i+3).
              eir = real(e(i + 2), KIND=dp)
              eii = aimag(e(i + 2))
              f = eir/d(i + 2)
              g = eii/d(i + 2)
              e(i + 2) = cmplx(f, g, KIND=dp)
              d(i + 3) = d(i + 3) - f*eir - g*eii
              if (d(i + 3) <= zero) then
                 info = i + 3
                 go to 30
              end if
              ! solve for e(i+3) and d(i+4).
              eir = real(e(i + 3), KIND=dp)
              eii = aimag(e(i + 3))
              f = eir/d(i + 3)
              g = eii/d(i + 3)
              e(i + 3) = cmplx(f, g, KIND=dp)
              d(i + 4) = d(i + 4) - f*eir - g*eii
           end do loop_20
           ! check d(n) for positive definiteness.
           if (d(n) <= zero) info = n
30      continue
           return
           ! end of stdlib_zpttrf
     end subroutine stdlib_zpttrf

     ! ZPTTS2 solves a tridiagonal system of the form
     ! A * X = B
     ! using the factorization A = U**H *D*U or A = L*D*L**H computed by ZPTTRF.
     ! D is a diagonal matrix specified in the vector D, U (or L) is a unit
     ! bidiagonal matrix whose superdiagonal (subdiagonal) is specified in
     ! the vector E, and X and B are N by NRHS matrices.

     subroutine stdlib_zptts2(iuplo, n, nrhs, d, e, b, ldb)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: iuplo, ldb, n, nrhs
           ! .. array arguments ..
           real(dp) :: d(*)
           complex(dp) :: b(ldb, *), e(*)
        ! =====================================================================
           ! .. local scalars ..
           integer(ilp) :: i, j
     
           ! .. intrinsic functions ..
           intrinsic :: conjg
           ! .. executable statements ..
           ! quick return if possible
           if (n <= 1) then
              if (n == 1) call stdlib_zdscal(nrhs, 1.d0/d(1), b, ldb)
              return
           end if
           if (iuplo == 1) then
              ! solve a * x = b using the factorization a = u**h *d*u,
              ! overwriting each right hand side vector with its solution.
              if (nrhs <= 2) then
                 j = 1
10      continue
                 ! solve u**h * x = b.
                 do i = 2, n
                    b(i, j) = b(i, j) - b(i - 1, j)*conjg(e(i - 1))
                 end do
                 ! solve d * u * x = b.
                 do i = 1, n
                    b(i, j) = b(i, j)/d(i)
                 end do
                 do i = n - 1, 1, -1
                    b(i, j) = b(i, j) - b(i + 1, j)*e(i)
                 end do
                 if (j < nrhs) then
                    j = j + 1
                    go to 10
                 end if
              else
                 do j = 1, nrhs
                    ! solve u**h * x = b.
                    do i = 2, n
                       b(i, j) = b(i, j) - b(i - 1, j)*conjg(e(i - 1))
                    end do
                    ! solve d * u * x = b.
                    b(n, j) = b(n, j)/d(n)
                    do i = n - 1, 1, -1
                       b(i, j) = b(i, j)/d(i) - b(i + 1, j)*e(i)
                    end do
                 end do
              end if
           else
              ! solve a * x = b using the factorization a = l*d*l**h,
              ! overwriting each right hand side vector with its solution.
              if (nrhs <= 2) then
                 j = 1
80      continue
                 ! solve l * x = b.
                 do i = 2, n
                    b(i, j) = b(i, j) - b(i - 1, j)*e(i - 1)
                 end do
                 ! solve d * l**h * x = b.
                 do i = 1, n
                    b(i, j) = b(i, j)/d(i)
                 end do
                 do i = n - 1, 1, -1
                    b(i, j) = b(i, j) - b(i + 1, j)*conjg(e(i))
                 end do
                 if (j < nrhs) then
                    j = j + 1
                    go to 80
                 end if
              else
                 do j = 1, nrhs
                    ! solve l * x = b.
                    do i = 2, n
                       b(i, j) = b(i, j) - b(i - 1, j)*e(i - 1)
                    end do
                    ! solve d * l**h * x = b.
                    b(n, j) = b(n, j)/d(n)
                    do i = n - 1, 1, -1
                       b(i, j) = b(i, j)/d(i) - b(i + 1, j)*conjg(e(i))
                    end do
                 end do
              end if
           end if
           return
           ! end of stdlib_zptts2
     end subroutine stdlib_zptts2

     ! ZROT   applies a plane rotation, where the cos (C) is real and the
     ! sin (S) is complex, and the vectors CX and CY are complex.

     subroutine stdlib_zrot(n, cx, incx, cy, incy, c, s)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: incx, incy, n
           real(dp) :: c
           complex(dp) :: s
           ! .. array arguments ..
           complex(dp) :: cx(*), cy(*)
       ! =====================================================================
           ! .. local scalars ..
           integer(ilp) :: i, ix, iy
           complex(dp) :: stemp
           ! .. intrinsic functions ..
           intrinsic :: conjg
           ! .. executable statements ..
           if (n <= 0) return
           if (incx == 1 .and. incy == 1) go to 20
           ! code for unequal increments or equal increments not equal to 1
           ix = 1
           iy = 1
           if (incx < 0) ix = (-n + 1)*incx + 1
           if (incy < 0) iy = (-n + 1)*incy + 1
           do i = 1, n
              stemp = c*cx(ix) + s*cy(iy)
              cy(iy) = c*cy(iy) - conjg(s)*cx(ix)
              cx(ix) = stemp
              ix = ix + incx
              iy = iy + incy
           end do
           return
           ! code for both increments equal to 1
20      continue
           do i = 1, n
              stemp = c*cx(i) + s*cy(i)
              cy(i) = c*cy(i) - conjg(s)*cx(i)
              cx(i) = stemp
           end do
           return
     end subroutine stdlib_zrot

     ! ZSPMV  performs the matrix-vector operation
     ! y := alpha*A*x + beta*y,
     ! where alpha and beta are scalars, x and y are n element vectors and
     ! A is an n by n symmetric matrix, supplied in packed form.

     subroutine stdlib_zspmv(uplo, n, alpha, ap, x, incx, beta, y, incy)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: incx, incy, n
           complex(dp) :: alpha, beta
           ! .. array arguments ..
           complex(dp) :: ap(*), x(*), y(*)
       ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i, info, ix, iy, j, jx, jy, k, kk, kx, ky
           complex(dp) :: temp1, temp2
     
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           if (.not. stdlib_lsame(uplo, 'u') .and. .not. stdlib_lsame(uplo, 'l')) then
              info = 1
           else if (n < 0) then
              info = 2
           else if (incx == 0) then
              info = 6
           else if (incy == 0) then
              info = 9
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zspmv ', info)
              return
           end if
           ! quick return if possible.
           if ((n == 0) .or. ((alpha == czero) .and. (beta == cone))) return
           ! set up the start points in  x  and  y.
           if (incx > 0) then
              kx = 1
           else
              kx = 1 - (n - 1)*incx
           end if
           if (incy > 0) then
              ky = 1
           else
              ky = 1 - (n - 1)*incy
           end if
           ! start the operations. in this version the elements of the array ap
           ! are accessed sequentially with cone pass through ap.
           ! first form  y := beta*y.
           if (beta /= cone) then
              if (incy == 1) then
                 if (beta == czero) then
                    do i = 1, n
                       y(i) = czero
                    end do
                 else
                    do i = 1, n
                       y(i) = beta*y(i)
                    end do
                 end if
              else
                 iy = ky
                 if (beta == czero) then
                    do i = 1, n
                       y(iy) = czero
                       iy = iy + incy
                    end do
                 else
                    do i = 1, n
                       y(iy) = beta*y(iy)
                       iy = iy + incy
                    end do
                 end if
              end if
           end if
           if (alpha == czero) return
           kk = 1
           if (stdlib_lsame(uplo, 'u')) then
              ! form  y  when ap contains the upper triangle.
              if ((incx == 1) .and. (incy == 1)) then
                 do j = 1, n
                    temp1 = alpha*x(j)
                    temp2 = czero
                    k = kk
                    do i = 1, j - 1
                       y(i) = y(i) + temp1*ap(k)
                       temp2 = temp2 + ap(k)*x(i)
                       k = k + 1
                    end do
                    y(j) = y(j) + temp1*ap(kk + j - 1) + alpha*temp2
                    kk = kk + j
                 end do
              else
                 jx = kx
                 jy = ky
                 do j = 1, n
                    temp1 = alpha*x(jx)
                    temp2 = czero
                    ix = kx
                    iy = ky
                    do k = kk, kk + j - 2
                       y(iy) = y(iy) + temp1*ap(k)
                       temp2 = temp2 + ap(k)*x(ix)
                       ix = ix + incx
                       iy = iy + incy
                    end do
                    y(jy) = y(jy) + temp1*ap(kk + j - 1) + alpha*temp2
                    jx = jx + incx
                    jy = jy + incy
                    kk = kk + j
                 end do
              end if
           else
              ! form  y  when ap contains the lower triangle.
              if ((incx == 1) .and. (incy == 1)) then
                 do j = 1, n
                    temp1 = alpha*x(j)
                    temp2 = czero
                    y(j) = y(j) + temp1*ap(kk)
                    k = kk + 1
                    do i = j + 1, n
                       y(i) = y(i) + temp1*ap(k)
                       temp2 = temp2 + ap(k)*x(i)
                       k = k + 1
                    end do
                    y(j) = y(j) + alpha*temp2
                    kk = kk + (n - j + 1)
                 end do
              else
                 jx = kx
                 jy = ky
                 do j = 1, n
                    temp1 = alpha*x(jx)
                    temp2 = czero
                    y(jy) = y(jy) + temp1*ap(kk)
                    ix = jx
                    iy = jy
                    do k = kk + 1, kk + n - j
                       ix = ix + incx
                       iy = iy + incy
                       y(iy) = y(iy) + temp1*ap(k)
                       temp2 = temp2 + ap(k)*x(ix)
                    end do
                    y(jy) = y(jy) + alpha*temp2
                    jx = jx + incx
                    jy = jy + incy
                    kk = kk + (n - j + 1)
                 end do
              end if
           end if
           return
           ! end of stdlib_zspmv
     end subroutine stdlib_zspmv

     ! ZSPR    performs the symmetric rank 1 operation
     ! A := alpha*x*x**H + A,
     ! where alpha is a complex scalar, x is an n element vector and A is an
     ! n by n symmetric matrix, supplied in packed form.

     subroutine stdlib_zspr(uplo, n, alpha, x, incx, ap)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: incx, n
           complex(dp) :: alpha
           ! .. array arguments ..
           complex(dp) :: ap(*), x(*)
       ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i, info, ix, j, jx, k, kk, kx
           complex(dp) :: temp
     
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           if (.not. stdlib_lsame(uplo, 'u') .and. .not. stdlib_lsame(uplo, 'l')) then
              info = 1
           else if (n < 0) then
              info = 2
           else if (incx == 0) then
              info = 5
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zspr  ', info)
              return
           end if
           ! quick return if possible.
           if ((n == 0) .or. (alpha == czero)) return
           ! set the start point in x if the increment is not unity.
           if (incx <= 0) then
              kx = 1 - (n - 1)*incx
           else if (incx /= 1) then
              kx = 1
           end if
           ! start the operations. in this version the elements of the array ap
           ! are accessed sequentially with cone pass through ap.
           kk = 1
           if (stdlib_lsame(uplo, 'u')) then
              ! form  a  when upper triangle is stored in ap.
              if (incx == 1) then
                 do j = 1, n
                    if (x(j) /= czero) then
                       temp = alpha*x(j)
                       k = kk
                       do i = 1, j - 1
                          ap(k) = ap(k) + x(i)*temp
                          k = k + 1
                       end do
                       ap(kk + j - 1) = ap(kk + j - 1) + x(j)*temp
                    else
                       ap(kk + j - 1) = ap(kk + j - 1)
                    end if
                    kk = kk + j
                 end do
              else
                 jx = kx
                 do j = 1, n
                    if (x(jx) /= czero) then
                       temp = alpha*x(jx)
                       ix = kx
                       do k = kk, kk + j - 2
                          ap(k) = ap(k) + x(ix)*temp
                          ix = ix + incx
                       end do
                       ap(kk + j - 1) = ap(kk + j - 1) + x(jx)*temp
                    else
                       ap(kk + j - 1) = ap(kk + j - 1)
                    end if
                    jx = jx + incx
                    kk = kk + j
                 end do
              end if
           else
              ! form  a  when lower triangle is stored in ap.
              if (incx == 1) then
                 do j = 1, n
                    if (x(j) /= czero) then
                       temp = alpha*x(j)
                       ap(kk) = ap(kk) + temp*x(j)
                       k = kk + 1
                       do i = j + 1, n
                          ap(k) = ap(k) + x(i)*temp
                          k = k + 1
                       end do
                    else
                       ap(kk) = ap(kk)
                    end if
                    kk = kk + n - j + 1
                 end do
              else
                 jx = kx
                 do j = 1, n
                    if (x(jx) /= czero) then
                       temp = alpha*x(jx)
                       ap(kk) = ap(kk) + temp*x(jx)
                       ix = jx
                       do k = kk + 1, kk + n - j
                          ix = ix + incx
                          ap(k) = ap(k) + x(ix)*temp
                       end do
                    else
                       ap(kk) = ap(kk)
                    end if
                    jx = jx + incx
                    kk = kk + n - j + 1
                 end do
              end if
           end if
           return
           ! end of stdlib_zspr
     end subroutine stdlib_zspr

     ! ZSPTRF computes the factorization of a complex symmetric matrix A
     ! stored in packed format using the Bunch-Kaufman diagonal pivoting
     ! method:
     ! A = U*D*U**T  or  A = L*D*L**T
     ! where U (or L) is a product of permutation and unit upper (lower)
     ! triangular matrices, and D is symmetric and block diagonal with
     ! 1-by-1 and 2-by-2 diagonal blocks.

     subroutine stdlib_zsptrf(uplo, n, ap, ipiv, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: ap(*)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: sevten = 17.0_dp
           
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: i, imax, j, jmax, k, kc, kk, knc, kp, kpc, kstep, kx, npp
           real(dp) :: absakk, alpha, colmax, rowmax
           complex(dp) :: d11, d12, d21, d22, r1, t, wk, wkm1, wkp1, zdum
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, aimag, max, sqrt
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(zdum) = abs(real(zdum, KIND=dp)) + abs(aimag(zdum))
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zsptrf', -info)
              return
           end if
           ! initialize alpha for use in choosing pivot block size.
           alpha = (one + sqrt(sevten))/eight
           if (upper) then
              ! factorize a as u*d*u**t using the upper triangle of a
              ! k is the main loop index, decreasing from n to 1 in steps of
              ! 1 or 2
              k = n
              kc = (n - 1)*n/2 + 1
10      continue
              knc = kc
              ! if k < 1, exit from loop
              if (k < 1) go to 110
              kstep = 1
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = cabs1(ap(kc + k - 1))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value
              if (k > 1) then
                 imax = stdlib_izamax(k - 1, ap(kc), 1)
                 colmax = cabs1(ap(kc + imax - 1))
              else
                 colmax = zero
              end if
              if (max(absakk, colmax) == zero) then
                 ! column k is zero: set info and continue
                 if (info == 0) info = k
                 kp = k
              else
                 if (absakk >= alpha*colmax) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    rowmax = zero
                    jmax = imax
                    kx = imax*(imax + 1)/2 + imax
                    do j = imax + 1, k
                       if (cabs1(ap(kx)) > rowmax) then
                          rowmax = cabs1(ap(kx))
                          jmax = j
                       end if
                       kx = kx + j
                    end do
                    kpc = (imax - 1)*imax/2 + 1
                    if (imax > 1) then
                       jmax = stdlib_izamax(imax - 1, ap(kpc), 1)
                       rowmax = max(rowmax, cabs1(ap(kpc + jmax - 1)))
                    end if
                    if (absakk >= alpha*colmax*(colmax/rowmax)) then
                       ! no interchange, use 1-by-1 pivot block
                       kp = k
                    else if (cabs1(ap(kpc + imax - 1)) >= alpha*rowmax) then
                       ! interchange rows and columns k and imax, use 1-by-1
                       ! pivot block
                       kp = imax
                    else
                       ! interchange rows and columns k-1 and imax, use 2-by-2
                       ! pivot block
                       kp = imax
                       kstep = 2
                    end if
                 end if
                 kk = k - kstep + 1
                 if (kstep == 2) knc = knc - k + 1
                 if (kp /= kk) then
                    ! interchange rows and columns kk and kp in the leading
                    ! submatrix a(1:k,1:k)
                    call stdlib_zswap(kp - 1, ap(knc), 1, ap(kpc), 1)
                    kx = kpc + kp - 1
                    do j = kp + 1, kk - 1
                       kx = kx + j - 1
                       t = ap(knc + j - 1)
                       ap(knc + j - 1) = ap(kx)
                       ap(kx) = t
                    end do
                    t = ap(knc + kk - 1)
                    ap(knc + kk - 1) = ap(kpc + kp - 1)
                    ap(kpc + kp - 1) = t
                    if (kstep == 2) then
                       t = ap(kc + k - 2)
                       ap(kc + k - 2) = ap(kc + kp - 1)
                       ap(kc + kp - 1) = t
                    end if
                 end if
                 ! update the leading submatrix
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k now holds
                    ! w(k) = u(k)*d(k)
                    ! where u(k) is the k-th column of u
                    ! perform a rank-1 update of a(1:k-1,1:k-1) as
                    ! a := a - u(k)*d(k)*u(k)**t = a - w(k)*1/d(k)*w(k)**t
                    r1 = cone/ap(kc + k - 1)
                    call stdlib_zspr(uplo, k - 1, -r1, ap(kc), 1, ap)
                    ! store u(k) in column k
                    call stdlib_zscal(k - 1, r1, ap(kc), 1)
                 else
                    ! 2-by-2 pivot block d(k): columns k and k-1 now hold
                    ! ( w(k-1) w(k) ) = ( u(k-1) u(k) )*d(k)
                    ! where u(k) and u(k-1) are the k-th and (k-1)-th columns
                    ! of u
                    ! perform a rank-2 update of a(1:k-2,1:k-2) as
                    ! a := a - ( u(k-1) u(k) )*d(k)*( u(k-1) u(k) )**t
                       ! = a - ( w(k-1) w(k) )*inv(d(k))*( w(k-1) w(k) )**t
                    if (k > 2) then
                       d12 = ap(k - 1 + (k - 1)*k/2)
                       d22 = ap(k - 1 + (k - 2)*(k - 1)/2)/d12
                       d11 = ap(k + (k - 1)*k/2)/d12
                       t = cone/(d11*d22 - cone)
                       d12 = t/d12
                       do j = k - 2, 1, -1
                          wkm1 = d12*(d11*ap(j + (k - 2)*(k - 1)/2) - ap(j + (k - 1)*k/2))
                                    
                          wk = d12*(d22*ap(j + (k - 1)*k/2) - ap(j + (k - 2)*(k - 1)/2))
                                    
                          do i = j, 1, -1
                             ap(i + (j - 1)*j/2) = ap(i + (j - 1)*j/2) - ap(i + (k - 1)*k/2) &
                                       *wk - ap(i + (k - 2)*(k - 1)/2)*wkm1
                          end do
                          ap(j + (k - 1)*k/2) = wk
                          ap(j + (k - 2)*(k - 1)/2) = wkm1
                       end do
                    end if
                 end if
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -kp
                 ipiv(k - 1) = -kp
              end if
              ! decrease k and return to the start of the main loop
              k = k - kstep
              kc = knc - k
              go to 10
           else
              ! factorize a as l*d*l**t using the lower triangle of a
              ! k is the main loop index, increasing from 1 to n in steps of
              ! 1 or 2
              k = 1
              kc = 1
              npp = n*(n + 1)/2
60      continue
              knc = kc
              ! if k > n, exit from loop
              if (k > n) go to 110
              kstep = 1
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = cabs1(ap(kc))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value
              if (k < n) then
                 imax = k + stdlib_izamax(n - k, ap(kc + 1), 1)
                 colmax = cabs1(ap(kc + imax - k))
              else
                 colmax = zero
              end if
              if (max(absakk, colmax) == zero) then
                 ! column k is zero: set info and continue
                 if (info == 0) info = k
                 kp = k
              else
                 if (absakk >= alpha*colmax) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    ! jmax is the column-index of the largest off-diagonal
                    ! element in row imax, and rowmax is its absolute value
                    rowmax = zero
                    kx = kc + imax - k
                    do j = k, imax - 1
                       if (cabs1(ap(kx)) > rowmax) then
                          rowmax = cabs1(ap(kx))
                          jmax = j
                       end if
                       kx = kx + n - j
                    end do
                    kpc = npp - (n - imax + 1)*(n - imax + 2)/2 + 1
                    if (imax < n) then
                       jmax = imax + stdlib_izamax(n - imax, ap(kpc + 1), 1)
                       rowmax = max(rowmax, cabs1(ap(kpc + jmax - imax)))
                    end if
                    if (absakk >= alpha*colmax*(colmax/rowmax)) then
                       ! no interchange, use 1-by-1 pivot block
                       kp = k
                    else if (cabs1(ap(kpc)) >= alpha*rowmax) then
                       ! interchange rows and columns k and imax, use 1-by-1
                       ! pivot block
                       kp = imax
                    else
                       ! interchange rows and columns k+1 and imax, use 2-by-2
                       ! pivot block
                       kp = imax
                       kstep = 2
                    end if
                 end if
                 kk = k + kstep - 1
                 if (kstep == 2) knc = knc + n - k + 1
                 if (kp /= kk) then
                    ! interchange rows and columns kk and kp in the trailing
                    ! submatrix a(k:n,k:n)
                    if (kp < n) call stdlib_zswap(n - kp, ap(knc + kp - kk + 1), 1, ap(kpc + 1), 1)
                              
                    kx = knc + kp - kk
                    do j = kk + 1, kp - 1
                       kx = kx + n - j + 1
                       t = ap(knc + j - kk)
                       ap(knc + j - kk) = ap(kx)
                       ap(kx) = t
                    end do
                    t = ap(knc)
                    ap(knc) = ap(kpc)
                    ap(kpc) = t
                    if (kstep == 2) then
                       t = ap(kc + 1)
                       ap(kc + 1) = ap(kc + kp - k)
                       ap(kc + kp - k) = t
                    end if
                 end if
                 ! update the trailing submatrix
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k now holds
                    ! w(k) = l(k)*d(k)
                    ! where l(k) is the k-th column of l
                    if (k < n) then
                       ! perform a rank-1 update of a(k+1:n,k+1:n) as
                       ! a := a - l(k)*d(k)*l(k)**t = a - w(k)*(1/d(k))*w(k)**t
                       r1 = cone/ap(kc)
                       call stdlib_zspr(uplo, n - k, -r1, ap(kc + 1), 1, ap(kc + n - k + 1))
                       ! store l(k) in column k
                       call stdlib_zscal(n - k, r1, ap(kc + 1), 1)
                    end if
                 else
                    ! 2-by-2 pivot block d(k): columns k and k+1 now hold
                    ! ( w(k) w(k+1) ) = ( l(k) l(k+1) )*d(k)
                    ! where l(k) and l(k+1) are the k-th and (k+1)-th columns
                    ! of l
                    if (k < n - 1) then
                       ! perform a rank-2 update of a(k+2:n,k+2:n) as
                       ! a := a - ( l(k) l(k+1) )*d(k)*( l(k) l(k+1) )**t
                          ! = a - ( w(k) w(k+1) )*inv(d(k))*( w(k) w(k+1) )**t
                       ! where l(k) and l(k+1) are the k-th and (k+1)-th
                       ! columns of l
                       d21 = ap(k + 1 + (k - 1)*(2*n - k)/2)
                       d11 = ap(k + 1 + k*(2*n - k - 1)/2)/d21
                       d22 = ap(k + (k - 1)*(2*n - k)/2)/d21
                       t = cone/(d11*d22 - cone)
                       d21 = t/d21
                       do j = k + 2, n
                          wk = d21*(d11*ap(j + (k - 1)*(2*n - k)/2) - ap(j + k*(2*n - k - 1)/2))
                                    
                          wkp1 = d21*(d22*ap(j + k*(2*n - k - 1)/2) - ap(j + (k - 1)*(2*n - k)/2) &
                                     )
                          do i = j, n
                             ap(i + (j - 1)*(2*n - j)/2) = ap(i + (j - 1)*(2*n - j)/2) - ap( &
                                       i + (k - 1)*(2*n - k)/2)*wk - ap(i + k*(2*n - k - 1)/2)*wkp1
                          end do
                          ap(j + (k - 1)*(2*n - k)/2) = wk
                          ap(j + k*(2*n - k - 1)/2) = wkp1
                       end do
                    end if
                 end if
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -kp
                 ipiv(k + 1) = -kp
              end if
              ! increase k and return to the start of the main loop
              k = k + kstep
              kc = knc + n - k + 2
              go to 60
           end if
110    continue
           return
           ! end of stdlib_zsptrf
     end subroutine stdlib_zsptrf

     ! ZSPTRI computes the inverse of a complex symmetric indefinite matrix
     ! A in packed storage using the factorization A = U*D*U**T or
     ! A = L*D*L**T computed by ZSPTRF.

     subroutine stdlib_zsptri(uplo, n, ap, ipiv, work, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: ap(*), work(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: j, k, kc, kcnext, kp, kpc, kstep, kx, npp
           complex(dp) :: ak, akkp1, akp1, d, t, temp
     
           ! .. intrinsic functions ..
           intrinsic :: abs
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zsptri', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           ! check that the diagonal matrix d is nonsingular.
           if (upper) then
              ! upper triangular storage: examine d from bottom to top
              kp = n*(n + 1)/2
              do info = n, 1, -1
                 if (ipiv(info) > 0 .and. ap(kp) == czero) return
                 kp = kp - info
              end do
           else
              ! lower triangular storage: examine d from top to bottom.
              kp = 1
              do info = 1, n
                 if (ipiv(info) > 0 .and. ap(kp) == czero) return
                 kp = kp + n - info + 1
              end do
           end if
           info = 0
           if (upper) then
              ! compute inv(a) from the factorization a = u*d*u**t.
              ! k is the main loop index, increasing from 1 to n in steps of
              ! 1 or 2, depending on the size of the diagonal blocks.
              k = 1
              kc = 1
30      continue
              ! if k > n, exit from loop.
              if (k > n) go to 50
              kcnext = kc + k
              if (ipiv(k) > 0) then
                 ! 1 x 1 diagonal block
                 ! invert the diagonal block.
                 ap(kc + k - 1) = cone/ap(kc + k - 1)
                 ! compute column k of the inverse.
                 if (k > 1) then
                    call stdlib_zcopy(k - 1, ap(kc), 1, work, 1)
                    call stdlib_zspmv(uplo, k - 1, -cone, ap, work, 1, czero, ap(kc), 1)
                    ap(kc + k - 1) = ap(kc + k - 1) - stdlib_zdotu(k - 1, work, 1, ap(kc), 1)
                 end if
                 kstep = 1
              else
                 ! 2 x 2 diagonal block
                 ! invert the diagonal block.
                 t = ap(kcnext + k - 1)
                 ak = ap(kc + k - 1)/t
                 akp1 = ap(kcnext + k)/t
                 akkp1 = ap(kcnext + k - 1)/t
                 d = t*(ak*akp1 - cone)
                 ap(kc + k - 1) = akp1/d
                 ap(kcnext + k) = ak/d
                 ap(kcnext + k - 1) = -akkp1/d
                 ! compute columns k and k+1 of the inverse.
                 if (k > 1) then
                    call stdlib_zcopy(k - 1, ap(kc), 1, work, 1)
                    call stdlib_zspmv(uplo, k - 1, -cone, ap, work, 1, czero, ap(kc), 1)
                    ap(kc + k - 1) = ap(kc + k - 1) - stdlib_zdotu(k - 1, work, 1, ap(kc), 1)
                    ap(kcnext + k - 1) = ap(kcnext + k - 1) - stdlib_zdotu(k - 1, ap(kc), 1, ap( &
                              kcnext), 1)
                    call stdlib_zcopy(k - 1, ap(kcnext), 1, work, 1)
                    call stdlib_zspmv(uplo, k - 1, -cone, ap, work, 1, czero, ap(kcnext), 1)
                              
                    ap(kcnext + k) = ap(kcnext + k) - stdlib_zdotu(k - 1, work, 1, ap(kcnext), 1)
                              
                 end if
                 kstep = 2
                 kcnext = kcnext + k + 1
              end if
              kp = abs(ipiv(k))
              if (kp /= k) then
                 ! interchange rows and columns k and kp in the leading
                 ! submatrix a(1:k+1,1:k+1)
                 kpc = (kp - 1)*kp/2 + 1
                 call stdlib_zswap(kp - 1, ap(kc), 1, ap(kpc), 1)
                 kx = kpc + kp - 1
                 do j = kp + 1, k - 1
                    kx = kx + j - 1
                    temp = ap(kc + j - 1)
                    ap(kc + j - 1) = ap(kx)
                    ap(kx) = temp
                 end do
                 temp = ap(kc + k - 1)
                 ap(kc + k - 1) = ap(kpc + kp - 1)
                 ap(kpc + kp - 1) = temp
                 if (kstep == 2) then
                    temp = ap(kc + k + k - 1)
                    ap(kc + k + k - 1) = ap(kc + k + kp - 1)
                    ap(kc + k + kp - 1) = temp
                 end if
              end if
              k = k + kstep
              kc = kcnext
              go to 30
50      continue
           else
              ! compute inv(a) from the factorization a = l*d*l**t.
              ! k is the main loop index, increasing from 1 to n in steps of
              ! 1 or 2, depending on the size of the diagonal blocks.
              npp = n*(n + 1)/2
              k = n
              kc = npp
60      continue
              ! if k < 1, exit from loop.
              if (k < 1) go to 80
              kcnext = kc - (n - k + 2)
              if (ipiv(k) > 0) then
                 ! 1 x 1 diagonal block
                 ! invert the diagonal block.
                 ap(kc) = cone/ap(kc)
                 ! compute column k of the inverse.
                 if (k < n) then
                    call stdlib_zcopy(n - k, ap(kc + 1), 1, work, 1)
                    call stdlib_zspmv(uplo, n - k, -cone, ap(kc + n - k + 1), work, 1, czero, ap(kc + 1) &
                              , 1)
                    ap(kc) = ap(kc) - stdlib_zdotu(n - k, work, 1, ap(kc + 1), 1)
                 end if
                 kstep = 1
              else
                 ! 2 x 2 diagonal block
                 ! invert the diagonal block.
                 t = ap(kcnext + 1)
                 ak = ap(kcnext)/t
                 akp1 = ap(kc)/t
                 akkp1 = ap(kcnext + 1)/t
                 d = t*(ak*akp1 - cone)
                 ap(kcnext) = akp1/d
                 ap(kc) = ak/d
                 ap(kcnext + 1) = -akkp1/d
                 ! compute columns k-1 and k of the inverse.
                 if (k < n) then
                    call stdlib_zcopy(n - k, ap(kc + 1), 1, work, 1)
                    call stdlib_zspmv(uplo, n - k, -cone, ap(kc + (n - k + 1)), work, 1, czero, ap( &
                              kc + 1), 1)
                    ap(kc) = ap(kc) - stdlib_zdotu(n - k, work, 1, ap(kc + 1), 1)
                    ap(kcnext + 1) = ap(kcnext + 1) - stdlib_zdotu(n - k, ap(kc + 1), 1, ap(kcnext + &
                              2), 1)
                    call stdlib_zcopy(n - k, ap(kcnext + 2), 1, work, 1)
                    call stdlib_zspmv(uplo, n - k, -cone, ap(kc + (n - k + 1)), work, 1, czero, ap( &
                              kcnext + 2), 1)
                    ap(kcnext) = ap(kcnext) - stdlib_zdotu(n - k, work, 1, ap(kcnext + 2), 1)
                              
                 end if
                 kstep = 2
                 kcnext = kcnext - (n - k + 3)
              end if
              kp = abs(ipiv(k))
              if (kp /= k) then
                 ! interchange rows and columns k and kp in the trailing
                 ! submatrix a(k-1:n,k-1:n)
                 kpc = npp - (n - kp + 1)*(n - kp + 2)/2 + 1
                 if (kp < n) call stdlib_zswap(n - kp, ap(kc + kp - k + 1), 1, ap(kpc + 1), 1)
                 kx = kc + kp - k
                 do j = k + 1, kp - 1
                    kx = kx + n - j + 1
                    temp = ap(kc + j - k)
                    ap(kc + j - k) = ap(kx)
                    ap(kx) = temp
                 end do
                 temp = ap(kc)
                 ap(kc) = ap(kpc)
                 ap(kpc) = temp
                 if (kstep == 2) then
                    temp = ap(kc - n + k - 1)
                    ap(kc - n + k - 1) = ap(kc - n + kp - 1)
                    ap(kc - n + kp - 1) = temp
                 end if
              end if
              k = k - kstep
              kc = kcnext
              go to 60
80      continue
           end if
           return
           ! end of stdlib_zsptri
     end subroutine stdlib_zsptri

     ! ZSPTRS solves a system of linear equations A*X = B with a complex
     ! symmetric matrix A stored in packed format using the factorization
     ! A = U*D*U**T or A = L*D*L**T computed by ZSPTRF.

     subroutine stdlib_zsptrs(uplo, n, nrhs, ap, ipiv, b, ldb, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, ldb, n, nrhs
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: ap(*), b(ldb, *)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: j, k, kc, kp
           complex(dp) :: ak, akm1, akm1k, bk, bkm1, denom
     
           ! .. intrinsic functions ..
           intrinsic :: max
           ! .. executable statements ..
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (nrhs < 0) then
              info = -3
           else if (ldb < max(1, n)) then
              info = -7
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zsptrs', -info)
              return
           end if
           ! quick return if possible
           if (n == 0 .or. nrhs == 0) return
           if (upper) then
              ! solve a*x = b, where a = u*d*u**t.
              ! first solve u*d*x = b, overwriting b with x.
              ! k is the main loop index, decreasing from n to 1 in steps of
              ! 1 or 2, depending on the size of the diagonal blocks.
              k = n
              kc = n*(n + 1)/2 + 1
10      continue
              ! if k < 1, exit from loop.
              if (k < 1) go to 30
              kc = kc - k
              if (ipiv(k) > 0) then
                 ! 1 x 1 diagonal block
                 ! interchange rows k and ipiv(k).
                 kp = ipiv(k)
                 if (kp /= k) call stdlib_zswap(nrhs, b(k, 1), ldb, b(kp, 1), ldb)
                 ! multiply by inv(u(k)), where u(k) is the transformation
                 ! stored in column k of a.
                 call stdlib_zgeru(k - 1, nrhs, -cone, ap(kc), 1, b(k, 1), ldb, b(1, 1), ldb)
                           
                 ! multiply by the inverse of the diagonal block.
                 call stdlib_zscal(nrhs, cone/ap(kc + k - 1), b(k, 1), ldb)
                 k = k - 1
              else
                 ! 2 x 2 diagonal block
                 ! interchange rows k-1 and -ipiv(k).
                 kp = -ipiv(k)
                 if (kp /= k - 1) call stdlib_zswap(nrhs, b(k - 1, 1), ldb, b(kp, 1), ldb)
                 ! multiply by inv(u(k)), where u(k) is the transformation
                 ! stored in columns k-1 and k of a.
                 call stdlib_zgeru(k - 2, nrhs, -cone, ap(kc), 1, b(k, 1), ldb, b(1, 1), ldb)
                           
                 call stdlib_zgeru(k - 2, nrhs, -cone, ap(kc - (k - 1)), 1, b(k - 1, 1), ldb, b(1, &
                           1), ldb)
                 ! multiply by the inverse of the diagonal block.
                 akm1k = ap(kc + k - 2)
                 akm1 = ap(kc - 1)/akm1k
                 ak = ap(kc + k - 1)/akm1k
                 denom = akm1*ak - cone
                 do j = 1, nrhs
                    bkm1 = b(k - 1, j)/akm1k
                    bk = b(k, j)/akm1k
                    b(k - 1, j) = (ak*bkm1 - bk)/denom
                    b(k, j) = (akm1*bk - bkm1)/denom
                 end do
                 kc = kc - k + 1
                 k = k - 2
              end if
              go to 10
30      continue
              ! next solve u**t*x = b, overwriting b with x.
              ! k is the main loop index, increasing from 1 to n in steps of
              ! 1 or 2, depending on the size of the diagonal blocks.
              k = 1
              kc = 1
40      continue
              ! if k > n, exit from loop.
              if (k > n) go to 50
              if (ipiv(k) > 0) then
                 ! 1 x 1 diagonal block
                 ! multiply by inv(u**t(k)), where u(k) is the transformation
                 ! stored in column k of a.
                 call stdlib_zgemv('transpose', k - 1, nrhs, -cone, b, ldb, ap(kc), 1, cone, b(k, &
                            1), ldb)
                 ! interchange rows k and ipiv(k).
                 kp = ipiv(k)
                 if (kp /= k) call stdlib_zswap(nrhs, b(k, 1), ldb, b(kp, 1), ldb)
                 kc = kc + k
                 k = k + 1
              else
                 ! 2 x 2 diagonal block
                 ! multiply by inv(u**t(k+1)), where u(k+1) is the transformation
                 ! stored in columns k and k+1 of a.
                 call stdlib_zgemv('transpose', k - 1, nrhs, -cone, b, ldb, ap(kc), 1, cone, b(k, &
                            1), ldb)
                 call stdlib_zgemv('transpose', k - 1, nrhs, -cone, b, ldb, ap(kc + k), 1, cone, b( &
                           k + 1, 1), ldb)
                 ! interchange rows k and -ipiv(k).
                 kp = -ipiv(k)
                 if (kp /= k) call stdlib_zswap(nrhs, b(k, 1), ldb, b(kp, 1), ldb)
                 kc = kc + 2*k + 1
                 k = k + 2
              end if
              go to 40
50      continue
           else
              ! solve a*x = b, where a = l*d*l**t.
              ! first solve l*d*x = b, overwriting b with x.
              ! k is the main loop index, increasing from 1 to n in steps of
              ! 1 or 2, depending on the size of the diagonal blocks.
              k = 1
              kc = 1
60      continue
              ! if k > n, exit from loop.
              if (k > n) go to 80
              if (ipiv(k) > 0) then
                 ! 1 x 1 diagonal block
                 ! interchange rows k and ipiv(k).
                 kp = ipiv(k)
                 if (kp /= k) call stdlib_zswap(nrhs, b(k, 1), ldb, b(kp, 1), ldb)
                 ! multiply by inv(l(k)), where l(k) is the transformation
                 ! stored in column k of a.
                 if (k < n) call stdlib_zgeru(n - k, nrhs, -cone, ap(kc + 1), 1, b(k, 1), ldb, b(k + &
                           1, 1), ldb)
                 ! multiply by the inverse of the diagonal block.
                 call stdlib_zscal(nrhs, cone/ap(kc), b(k, 1), ldb)
                 kc = kc + n - k + 1
                 k = k + 1
              else
                 ! 2 x 2 diagonal block
                 ! interchange rows k+1 and -ipiv(k).
                 kp = -ipiv(k)
                 if (kp /= k + 1) call stdlib_zswap(nrhs, b(k + 1, 1), ldb, b(kp, 1), ldb)
                 ! multiply by inv(l(k)), where l(k) is the transformation
                 ! stored in columns k and k+1 of a.
                 if (k < n - 1) then
                    call stdlib_zgeru(n - k - 1, nrhs, -cone, ap(kc + 2), 1, b(k, 1), ldb, b(k + 2, &
                              1), ldb)
                    call stdlib_zgeru(n - k - 1, nrhs, -cone, ap(kc + n - k + 2), 1, b(k + 1, 1), ldb, b( &
                              k + 2, 1), ldb)
                 end if
                 ! multiply by the inverse of the diagonal block.
                 akm1k = ap(kc + 1)
                 akm1 = ap(kc)/akm1k
                 ak = ap(kc + n - k + 1)/akm1k
                 denom = akm1*ak - cone
                 do j = 1, nrhs
                    bkm1 = b(k, j)/akm1k
                    bk = b(k + 1, j)/akm1k
                    b(k, j) = (ak*bkm1 - bk)/denom
                    b(k + 1, j) = (akm1*bk - bkm1)/denom
                 end do
                 kc = kc + 2*(n - k) + 1
                 k = k + 2
              end if
              go to 60
80      continue
              ! next solve l**t*x = b, overwriting b with x.
              ! k is the main loop index, decreasing from n to 1 in steps of
              ! 1 or 2, depending on the size of the diagonal blocks.
              k = n
              kc = n*(n + 1)/2 + 1
90      continue
              ! if k < 1, exit from loop.
              if (k < 1) go to 100
              kc = kc - (n - k + 1)
              if (ipiv(k) > 0) then
                 ! 1 x 1 diagonal block
                 ! multiply by inv(l**t(k)), where l(k) is the transformation
                 ! stored in column k of a.
                 if (k < n) call stdlib_zgemv('transpose', n - k, nrhs, -cone, b(k + 1, 1), ldb, ap( &
                           kc + 1), 1, cone, b(k, 1), ldb)
                 ! interchange rows k and ipiv(k).
                 kp = ipiv(k)
                 if (kp /= k) call stdlib_zswap(nrhs, b(k, 1), ldb, b(kp, 1), ldb)
                 k = k - 1
              else
                 ! 2 x 2 diagonal block
                 ! multiply by inv(l**t(k-1)), where l(k-1) is the transformation
                 ! stored in columns k-1 and k of a.
                 if (k < n) then
                    call stdlib_zgemv('transpose', n - k, nrhs, -cone, b(k + 1, 1), ldb, ap(kc + 1), &
                               1, cone, b(k, 1), ldb)
                    call stdlib_zgemv('transpose', n - k, nrhs, -cone, b(k + 1, 1), ldb, ap(kc - (n - &
                              k)), 1, cone, b(k - 1, 1), ldb)
                 end if
                 ! interchange rows k and -ipiv(k).
                 kp = -ipiv(k)
                 if (kp /= k) call stdlib_zswap(nrhs, b(k, 1), ldb, b(kp, 1), ldb)
                 kc = kc - (n - k + 2)
                 k = k - 2
              end if
              go to 90
100    continue
           end if
           return
           ! end of stdlib_zsptrs
     end subroutine stdlib_zsptrs

     ! ZSTEIN computes the eigenvectors of a real symmetric tridiagonal
     ! matrix T corresponding to specified eigenvalues, using inverse
     ! iteration.
     ! The maximum number of iterations allowed for each eigenvector is
     ! specified by an internal parameter MAXITS (currently set to 5).
     ! Although the eigenvectors are real, they are stored in a complex
     ! array, which may be passed to ZUNMTR or ZUPMTR for back
     ! transformation to the eigenvectors of a complex Hermitian matrix
     ! which was reduced to tridiagonal form.

     subroutine stdlib_zstein(n, d, e, m, w, iblock, isplit, z, ldz, work, iwork, ifail, info)
               
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: info, ldz, m, n
           ! .. array arguments ..
           integer(ilp) :: iblock(*), ifail(*), isplit(*), iwork(*)
           real(dp) :: d(*), e(*), w(*), work(*)
           complex(dp) :: z(ldz, *)
       ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: odm3 = 1.0d-3
           real(dp), parameter :: odm1 = 1.0d-1
           integer(ilp), parameter :: maxits = 5
           integer(ilp), parameter :: extra = 2
           
           ! .. local scalars ..
           integer(ilp) :: b1, blksiz, bn, gpind, i, iinfo, indrv1, indrv2, indrv3, indrv4, indrv5, &
                      its, j, j1, jblk, jmax, jr, nblk, nrmchk
           real(dp) :: dtpcrt, eps, eps1, nrm, onenrm, ortol, pertol, scl, sep, tol, xj, xjm, &
                     ztr
           ! .. local arrays ..
           integer(ilp) :: iseed(4)
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, dcmplx, max, sqrt
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           do i = 1, m
              ifail(i) = 0
           end do
           if (n < 0) then
              info = -1
           else if (m < 0 .or. m > n) then
              info = -4
           else if (ldz < max(1, n)) then
              info = -9
           else
              do j = 2, m
                 if (iblock(j) < iblock(j - 1)) then
                    info = -6
                    go to 30
                 end if
                 if (iblock(j) == iblock(j - 1) .and. w(j) < w(j - 1)) then
                    info = -5
                    go to 30
                 end if
              end do
30      continue
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zstein', -info)
              return
           end if
           ! quick return if possible
           if (n == 0 .or. m == 0) then
              return
           else if (n == 1) then
              z(1, 1) = cone
              return
           end if
           ! get machine constants.
           eps = stdlib_dlamch('precision')
           ! initialize seed for random number generator stdlib_dlarnv.
           do i = 1, 4
              iseed(i) = 1
           end do
           ! initialize pointers.
           indrv1 = 0
           indrv2 = indrv1 + n
           indrv3 = indrv2 + n
           indrv4 = indrv3 + n
           indrv5 = indrv4 + n
           ! compute eigenvectors of matrix blocks.
           j1 = 1
           loop_180: do nblk = 1, iblock(m)
              ! find starting and ending indices of block nblk.
              if (nblk == 1) then
                 b1 = 1
              else
                 b1 = isplit(nblk - 1) + 1
              end if
              bn = isplit(nblk)
              blksiz = bn - b1 + 1
              if (blksiz == 1) go to 60
              gpind = j1
              ! compute reorthogonalization criterion and stopping criterion.
              onenrm = abs(d(b1)) + abs(e(b1))
              onenrm = max(onenrm, abs(d(bn)) + abs(e(bn - 1)))
              do i = b1 + 1, bn - 1
                 onenrm = max(onenrm, abs(d(i)) + abs(e(i - 1)) + abs(e(i)))
              end do
              ortol = odm3*onenrm
              dtpcrt = sqrt(odm1/blksiz)
              ! loop through eigenvalues of block nblk.
60      continue
              jblk = 0
              loop_170: do j = j1, m
                 if (iblock(j) /= nblk) then
                    j1 = j
                    cycle loop_180
                 end if
                 jblk = jblk + 1
                 xj = w(j)
                 ! skip all the work if the block size is one.
                 if (blksiz == 1) then
                    work(indrv1 + 1) = one
                    go to 140
                 end if
                 ! if eigenvalues j and j-1 are too close, add a relatively
                 ! small perturbation.
                 if (jblk > 1) then
                    eps1 = abs(eps*xj)
                    pertol = ten*eps1
                    sep = xj - xjm
                    if (sep < pertol) xj = xjm + pertol
                 end if
                 its = 0
                 nrmchk = 0
                 ! get random starting vector.
                 call stdlib_dlarnv(2, iseed, blksiz, work(indrv1 + 1))
                 ! copy the matrix t so it won't be destroyed in factorization.
                 call stdlib_dcopy(blksiz, d(b1), 1, work(indrv4 + 1), 1)
                 call stdlib_dcopy(blksiz - 1, e(b1), 1, work(indrv2 + 2), 1)
                 call stdlib_dcopy(blksiz - 1, e(b1), 1, work(indrv3 + 1), 1)
                 ! compute lu factors with partial pivoting  ( pt = lu )
                 tol = zero
                 call stdlib_dlagtf(blksiz, work(indrv4 + 1), xj, work(indrv2 + 2), work(indrv3 + &
                           1), tol, work(indrv5 + 1), iwork, iinfo)
                 ! update iteration count.
70      continue
                 its = its + 1
                 if (its > maxits) go to 120
                 ! normalize and scale the righthand side vector pb.
                 jmax = stdlib_idamax(blksiz, work(indrv1 + 1), 1)
                 scl = blksiz*onenrm*max(eps, abs(work(indrv4 + blksiz)))/abs(work(indrv1 + &
                           jmax))
                 call stdlib_dscal(blksiz, scl, work(indrv1 + 1), 1)
                 ! solve the system lu = pb.
                 call stdlib_dlagts(-1, blksiz, work(indrv4 + 1), work(indrv2 + 2), work(indrv3 + &
                           1), work(indrv5 + 1), iwork, work(indrv1 + 1), tol, iinfo)
                 ! reorthogonalize by modified gram-schmidt if eigenvalues are
                 ! close enough.
                 if (jblk == 1) go to 110
                 if (abs(xj - xjm) > ortol) gpind = j
                 if (gpind /= j) then
                    do i = gpind, j - 1
                       ztr = zero
                       do jr = 1, blksiz
                          ztr = ztr + work(indrv1 + jr)*real(z(b1 - 1 + jr, i), KIND=dp)
                       end do
                       do jr = 1, blksiz
                          work(indrv1 + jr) = work(indrv1 + jr) - ztr*real(z(b1 - 1 + jr, i), &
                                    KIND=dp)
                       end do
                    end do
                 end if
                 ! check the infinity norm of the iterate.
110    continue
                 jmax = stdlib_idamax(blksiz, work(indrv1 + 1), 1)
                 nrm = abs(work(indrv1 + jmax))
                 ! continue for additional iterations after norm reaches
                 ! stopping criterion.
                 if (nrm < dtpcrt) go to 70
                 nrmchk = nrmchk + 1
                 if (nrmchk < extra + 1) go to 70
                 go to 130
                 ! if stopping criterion was not satisfied, update info and
                 ! store eigenvector number in array ifail.
120    continue
                 info = info + 1
                 ifail(info) = j
                 ! accept iterate as jth eigenvector.
130    continue
                 scl = one/stdlib_dnrm2(blksiz, work(indrv1 + 1), 1)
                 jmax = stdlib_idamax(blksiz, work(indrv1 + 1), 1)
                 if (work(indrv1 + jmax) < zero) scl = -scl
                 call stdlib_dscal(blksiz, scl, work(indrv1 + 1), 1)
140    continue
                 do i = 1, n
                    z(i, j) = czero
                 end do
                 do i = 1, blksiz
                    z(b1 + i - 1, j) = cmplx(work(indrv1 + i), zero, KIND=dp)
                 end do
                 ! save the shift to check eigenvalue spacing at next
                 ! iteration.
                 xjm = xj
              end do loop_170
           end do loop_180
           return
           ! end of stdlib_zstein
     end subroutine stdlib_zstein

     ! ZSTEQR computes all eigenvalues and, optionally, eigenvectors of a
     ! symmetric tridiagonal matrix using the implicit QL or QR method.
     ! The eigenvectors of a full or band complex Hermitian matrix can also
     ! be found if ZHETRD or ZHPTRD or ZHBTRD has been used to reduce this
     ! matrix to tridiagonal form.

     subroutine stdlib_zsteqr(compz, n, d, e, z, ldz, work, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: compz
           integer(ilp) :: info, ldz, n
           ! .. array arguments ..
           real(dp) :: d(*), e(*), work(*)
           complex(dp) :: z(ldz, *)
        ! =====================================================================
           ! .. parameters ..
           integer(ilp), parameter :: maxit = 30
           
           ! .. local scalars ..
           integer(ilp) :: i, icompz, ii, iscale, j, jtot, k, l, l1, lend, lendm1, lendp1, lendsv, &
                     lm1, lsv, m, mm, mm1, nm1, nmaxit
           real(dp) :: anorm, b, c, eps, eps2, f, g, p, r, rt1, rt2, s, safmax, safmin, ssfmax, &
                     ssfmin, tst
     
           ! .. intrinsic functions ..
           intrinsic :: abs, max, sign, sqrt
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           if (stdlib_lsame(compz, 'n')) then
              icompz = 0
           else if (stdlib_lsame(compz, 'v')) then
              icompz = 1
           else if (stdlib_lsame(compz, 'i')) then
              icompz = 2
           else
              icompz = -1
           end if
           if (icompz < 0) then
              info = -1
           else if (n < 0) then
              info = -2
           else if ((ldz < 1) .or. (icompz > 0 .and. ldz < max(1, n))) then
              info = -6
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zsteqr', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           if (n == 1) then
              if (icompz == 2) z(1, 1) = cone
              return
           end if
           ! determine the unit roundoff and over/underflow thresholds.
           eps = stdlib_dlamch('e')
           eps2 = eps**2
           safmin = stdlib_dlamch('s')
           safmax = one/safmin
           ssfmax = sqrt(safmax)/three
           ssfmin = sqrt(safmin)/eps2
           ! compute the eigenvalues and eigenvectors of the tridiagonal
           ! matrix.
           if (icompz == 2) call stdlib_zlaset('full', n, n, czero, cone, z, ldz)
           nmaxit = n*maxit
           jtot = 0
           ! determine where the matrix splits and choose ql or qr iteration
           ! for each block, according to whether top or bottom diagonal
           ! element is smaller.
           l1 = 1
           nm1 = n - 1
10      continue
           if (l1 > n) go to 160
           if (l1 > 1) e(l1 - 1) = zero
           if (l1 <= nm1) then
              do m = l1, nm1
                 tst = abs(e(m))
                 if (tst == zero) go to 30
                 if (tst <= (sqrt(abs(d(m)))*sqrt(abs(d(m + 1))))*eps) then
                    e(m) = zero
                    go to 30
                 end if
              end do
           end if
           m = n
30      continue
           l = l1
           lsv = l
           lend = m
           lendsv = lend
           l1 = m + 1
           if (lend == l) go to 10
           ! scale submatrix in rows and columns l to lend
           anorm = stdlib_dlanst('i', lend - l + 1, d(l), e(l))
           iscale = 0
           if (anorm == zero) go to 10
           if (anorm > ssfmax) then
              iscale = 1
              call stdlib_dlascl('g', 0, 0, anorm, ssfmax, lend - l + 1, 1, d(l), n, info)
              call stdlib_dlascl('g', 0, 0, anorm, ssfmax, lend - l, 1, e(l), n, info)
           else if (anorm < ssfmin) then
              iscale = 2
              call stdlib_dlascl('g', 0, 0, anorm, ssfmin, lend - l + 1, 1, d(l), n, info)
              call stdlib_dlascl('g', 0, 0, anorm, ssfmin, lend - l, 1, e(l), n, info)
           end if
           ! choose between ql and qr iteration
           if (abs(d(lend)) < abs(d(l))) then
              lend = lsv
              l = lendsv
           end if
           if (lend > l) then
              ! ql iteration
              ! look for small subdiagonal element.
40      continue
              if (l /= lend) then
                 lendm1 = lend - 1
                 do m = l, lendm1
                    tst = abs(e(m))**2
                    if (tst <= (eps2*abs(d(m)))*abs(d(m + 1)) + safmin) go to 60
                 end do
              end if
              m = lend
60      continue
              if (m < lend) e(m) = zero
              p = d(l)
              if (m == l) go to 80
              ! if remaining matrix is 2-by-2, use stdlib_dlae2 or stdlib_slaev2
              ! to compute its eigensystem.
              if (m == l + 1) then
                 if (icompz > 0) then
                    call stdlib_dlaev2(d(l), e(l), d(l + 1), rt1, rt2, c, s)
                    work(l) = c
                    work(n - 1 + l) = s
                    call stdlib_zlasr('r', 'v', 'b', n, 2, work(l), work(n - 1 + l), z(1, l), &
                              ldz)
                 else
                    call stdlib_dlae2(d(l), e(l), d(l + 1), rt1, rt2)
                 end if
                 d(l) = rt1
                 d(l + 1) = rt2
                 e(l) = zero
                 l = l + 2
                 if (l <= lend) go to 40
                 go to 140
              end if
              if (jtot == nmaxit) go to 140
              jtot = jtot + 1
              ! form shift.
              g = (d(l + 1) - p)/(two*e(l))
              r = stdlib_dlapy2(g, one)
              g = d(m) - p + (e(l)/(g + sign(r, g)))
              s = one
              c = one
              p = zero
              ! inner loop
              mm1 = m - 1
              do i = mm1, l, -1
                 f = s*e(i)
                 b = c*e(i)
                 call stdlib_dlartg(g, f, c, s, r)
                 if (i /= m - 1) e(i + 1) = r
                 g = d(i + 1) - p
                 r = (d(i) - g)*s + two*c*b
                 p = s*r
                 d(i + 1) = g + p
                 g = c*r - b
                 ! if eigenvectors are desired, then save rotations.
                 if (icompz > 0) then
                    work(i) = c
                    work(n - 1 + i) = -s
                 end if
              end do
              ! if eigenvectors are desired, then apply saved rotations.
              if (icompz > 0) then
                 mm = m - l + 1
                 call stdlib_zlasr('r', 'v', 'b', n, mm, work(l), work(n - 1 + l), z(1, l), ldz &
                           )
              end if
              d(l) = d(l) - p
              e(l) = g
              go to 40
              ! eigenvalue found.
80      continue
              d(l) = p
              l = l + 1
              if (l <= lend) go to 40
              go to 140
           else
              ! qr iteration
              ! look for small superdiagonal element.
90      continue
              if (l /= lend) then
                 lendp1 = lend + 1
                 do m = l, lendp1, -1
                    tst = abs(e(m - 1))**2
                    if (tst <= (eps2*abs(d(m)))*abs(d(m - 1)) + safmin) go to 110
                 end do
              end if
              m = lend
110    continue
              if (m > lend) e(m - 1) = zero
              p = d(l)
              if (m == l) go to 130
              ! if remaining matrix is 2-by-2, use stdlib_dlae2 or stdlib_slaev2
              ! to compute its eigensystem.
              if (m == l - 1) then
                 if (icompz > 0) then
                    call stdlib_dlaev2(d(l - 1), e(l - 1), d(l), rt1, rt2, c, s)
                    work(m) = c
                    work(n - 1 + m) = s
                    call stdlib_zlasr('r', 'v', 'f', n, 2, work(m), work(n - 1 + m), z(1, l - 1), &
                              ldz)
                 else
                    call stdlib_dlae2(d(l - 1), e(l - 1), d(l), rt1, rt2)
                 end if
                 d(l - 1) = rt1
                 d(l) = rt2
                 e(l - 1) = zero
                 l = l - 2
                 if (l >= lend) go to 90
                 go to 140
              end if
              if (jtot == nmaxit) go to 140
              jtot = jtot + 1
              ! form shift.
              g = (d(l - 1) - p)/(two*e(l - 1))
              r = stdlib_dlapy2(g, one)
              g = d(m) - p + (e(l - 1)/(g + sign(r, g)))
              s = one
              c = one
              p = zero
              ! inner loop
              lm1 = l - 1
              do i = m, lm1
                 f = s*e(i)
                 b = c*e(i)
                 call stdlib_dlartg(g, f, c, s, r)
                 if (i /= m) e(i - 1) = r
                 g = d(i) - p
                 r = (d(i + 1) - g)*s + two*c*b
                 p = s*r
                 d(i) = g + p
                 g = c*r - b
                 ! if eigenvectors are desired, then save rotations.
                 if (icompz > 0) then
                    work(i) = c
                    work(n - 1 + i) = s
                 end if
              end do
              ! if eigenvectors are desired, then apply saved rotations.
              if (icompz > 0) then
                 mm = l - m + 1
                 call stdlib_zlasr('r', 'v', 'f', n, mm, work(m), work(n - 1 + m), z(1, m), ldz &
                           )
              end if
              d(l) = d(l) - p
              e(lm1) = g
              go to 90
              ! eigenvalue found.
130    continue
              d(l) = p
              l = l - 1
              if (l >= lend) go to 90
              go to 140
           end if
           ! undo scaling if necessary
140    continue
           if (iscale == 1) then
              call stdlib_dlascl('g', 0, 0, ssfmax, anorm, lendsv - lsv + 1, 1, d(lsv), n, info)
                        
              call stdlib_dlascl('g', 0, 0, ssfmax, anorm, lendsv - lsv, 1, e(lsv), n, info)
                        
           else if (iscale == 2) then
              call stdlib_dlascl('g', 0, 0, ssfmin, anorm, lendsv - lsv + 1, 1, d(lsv), n, info)
                        
              call stdlib_dlascl('g', 0, 0, ssfmin, anorm, lendsv - lsv, 1, e(lsv), n, info)
                        
           end if
           ! check for no convergence to an eigenvalue after a total
           ! of n*maxit iterations.
           if (jtot == nmaxit) then
              do i = 1, n - 1
                 if (e(i) /= zero) info = info + 1
              end do
              return
           end if
           go to 10
           ! order eigenvalues and eigenvectors.
160    continue
           if (icompz == 0) then
              ! use quick sort
              call stdlib_dlasrt('i', n, d, info)
           else
              ! use selection sort to minimize swaps of eigenvectors
              do ii = 2, n
                 i = ii - 1
                 k = i
                 p = d(i)
                 do j = ii, n
                    if (d(j) < p) then
                       k = j
                       p = d(j)
                    end if
                 end do
                 if (k /= i) then
                    d(k) = d(i)
                    d(i) = p
                    call stdlib_zswap(n, z(1, i), 1, z(1, k), 1)
                 end if
              end do
           end if
           return
           ! end of stdlib_zsteqr
     end subroutine stdlib_zsteqr

     ! ZSYCONV converts A given by ZHETRF into L and D or vice-versa.
     ! Get nondiagonal elements of D (returned in workspace) and
     ! apply or reverse permutation done in TRF.

     subroutine stdlib_zsyconv(uplo, way, n, a, lda, ipiv, e, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo, way
           integer(ilp) :: info, lda, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *), e(*)
        ! =====================================================================
           
           ! .. external subroutines ..
     
           logical(lk) :: upper, convert
           integer(ilp) :: i, ip, j
           complex(dp) :: temp
           ! .. executable statements ..
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           convert = stdlib_lsame(way, 'c')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (.not. convert .and. .not. stdlib_lsame(way, 'r')) then
              info = -2
           else if (n < 0) then
              info = -3
           else if (lda < max(1, n)) then
              info = -5
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zsyconv', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           if (upper) then
              ! a is upper
              if (convert) then
                 ! convert a (a is upper)
                 ! convert value
                 i = n
                 e(1) = czero
                 do while (i > 1)
                    if (ipiv(i) < 0) then
                       e(i) = a(i - 1, i)
                       e(i - 1) = czero
                       a(i - 1, i) = czero
                       i = i - 1
                    else
                       e(i) = czero
                    end if
                    i = i - 1
                 end do
                 ! convert permutations
                 i = n
                 do while (i >= 1)
                    if (ipiv(i) > 0) then
                       ip = ipiv(i)
                       if (i < n) then
                          do j = i + 1, n
                            temp = a(ip, j)
                            a(ip, j) = a(i, j)
                            a(i, j) = temp
                          end do
                       end if
                    else
                       ip = -ipiv(i)
                       if (i < n) then
                          do j = i + 1, n
                             temp = a(ip, j)
                             a(ip, j) = a(i - 1, j)
                             a(i - 1, j) = temp
                          end do
                       end if
                       i = i - 1
                    end if
                    i = i - 1
                 end do
              else
                 ! revert a (a is upper)
                 ! revert permutations
                 i = 1
                 do while (i <= n)
                    if (ipiv(i) > 0) then
                       ip = ipiv(i)
                       if (i < n) then
                       do j = i + 1, n
                         temp = a(ip, j)
                         a(ip, j) = a(i, j)
                         a(i, j) = temp
                       end do
                       end if
                    else
                      ip = -ipiv(i)
                      i = i + 1
                      if (i < n) then
                         do j = i + 1, n
                            temp = a(ip, j)
                            a(ip, j) = a(i - 1, j)
                            a(i - 1, j) = temp
                         end do
                      end if
                    end if
                    i = i + 1
                 end do
                 ! revert value
                 i = n
                 do while (i > 1)
                    if (ipiv(i) < 0) then
                       a(i - 1, i) = e(i)
                       i = i - 1
                    end if
                    i = i - 1
                 end do
              end if
           else
              ! a is lower
              if (convert) then
                 ! convert a (a is lower)
                 ! convert value
                 i = 1
                 e(n) = czero
                 do while (i <= n)
                    if (i < n .and. ipiv(i) < 0) then
                       e(i) = a(i + 1, i)
                       e(i + 1) = czero
                       a(i + 1, i) = czero
                       i = i + 1
                    else
                       e(i) = czero
                    end if
                    i = i + 1
                 end do
                 ! convert permutations
                 i = 1
                 do while (i <= n)
                    if (ipiv(i) > 0) then
                       ip = ipiv(i)
                       if (i > 1) then
                          do j = 1, i - 1
                             temp = a(ip, j)
                             a(ip, j) = a(i, j)
                             a(i, j) = temp
                          end do
                       end if
                    else
                       ip = -ipiv(i)
                       if (i > 1) then
                          do j = 1, i - 1
                             temp = a(ip, j)
                             a(ip, j) = a(i + 1, j)
                             a(i + 1, j) = temp
                          end do
                       end if
                       i = i + 1
                    end if
                    i = i + 1
                 end do
              else
                 ! revert a (a is lower)
                 ! revert permutations
                 i = n
                 do while (i >= 1)
                    if (ipiv(i) > 0) then
                       ip = ipiv(i)
                       if (i > 1) then
                          do j = 1, i - 1
                             temp = a(i, j)
                             a(i, j) = a(ip, j)
                             a(ip, j) = temp
                          end do
                       end if
                    else
                       ip = -ipiv(i)
                       i = i - 1
                       if (i > 1) then
                          do j = 1, i - 1
                             temp = a(i + 1, j)
                             a(i + 1, j) = a(ip, j)
                             a(ip, j) = temp
                          end do
                       end if
                    end if
                    i = i - 1
                 end do
                 ! revert value
                 i = 1
                 do while (i <= n - 1)
                    if (ipiv(i) < 0) then
                       a(i + 1, i) = e(i)
                       i = i + 1
                    end if
                    i = i + 1
                 end do
              end if
           end if
           return
           ! end of stdlib_zsyconv
     end subroutine stdlib_zsyconv

     ! If parameter WAY = 'C':
     ! ZSYCONVF converts the factorization output format used in
     ! ZSYTRF provided on entry in parameter A into the factorization
     ! output format used in ZSYTRF_RK (or ZSYTRF_BK) that is stored
     ! on exit in parameters A and E. It also converts in place details of
     ! the intechanges stored in IPIV from the format used in ZSYTRF into
     ! the format used in ZSYTRF_RK (or ZSYTRF_BK).
     ! If parameter WAY = 'R':
     ! ZSYCONVF performs the conversion in reverse direction, i.e.
     ! converts the factorization output format used in ZSYTRF_RK
     ! (or ZSYTRF_BK) provided on entry in parameters A and E into
     ! the factorization output format used in ZSYTRF that is stored
     ! on exit in parameter A. It also converts in place details of
     ! the intechanges stored in IPIV from the format used in ZSYTRF_RK
     ! (or ZSYTRF_BK) into the format used in ZSYTRF.
     ! ZSYCONVF can also convert in Hermitian matrix case, i.e. between
     ! formats used in ZHETRF and ZHETRF_RK (or ZHETRF_BK).

     subroutine stdlib_zsyconvf(uplo, way, n, a, lda, e, ipiv, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo, way
           integer(ilp) :: info, lda, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *), e(*)
        ! =====================================================================
           
           ! .. external subroutines ..
     
           logical(lk) :: upper, convert
           integer(ilp) :: i, ip
           ! .. executable statements ..
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           convert = stdlib_lsame(way, 'c')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (.not. convert .and. .not. stdlib_lsame(way, 'r')) then
              info = -2
           else if (n < 0) then
              info = -3
           else if (lda < max(1, n)) then
              info = -5
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zsyconvf', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           if (upper) then
              ! begin a is upper
              if (convert) then
                 ! convert a (a is upper)
                 ! convert value
                 ! assign superdiagonal entries of d to array e and czero out
                 ! corresponding entries in input storage a
                 i = n
                 e(1) = czero
                 do while (i > 1)
                    if (ipiv(i) < 0) then
                       e(i) = a(i - 1, i)
                       e(i - 1) = czero
                       a(i - 1, i) = czero
                       i = i - 1
                    else
                       e(i) = czero
                    end if
                    i = i - 1
                 end do
                 ! convert permutations and ipiv
                 ! apply permutations to submatrices of upper part of a
                 ! in factorization order where i decreases from n to 1
                 i = n
                 do while (i >= 1)
                    if (ipiv(i) > 0) then
                       ! 1-by-1 pivot interchange
                       ! swap rows i and ipiv(i) in a(1:i,n-i:n)
                       ip = ipiv(i)
                       if (i < n) then
                          if (ip /= i) then
                             call stdlib_zswap(n - i, a(i, i + 1), lda, a(ip, i + 1), lda)
                          end if
                       end if
                    else
                       ! 2-by-2 pivot interchange
                       ! swap rows i-1 and ipiv(i) in a(1:i,n-i:n)
                       ip = -ipiv(i)
                       if (i < n) then
                          if (ip /= (i - 1)) then
                             call stdlib_zswap(n - i, a(i - 1, i + 1), lda, a(ip, i + 1), lda)
                                       
                          end if
                       end if
                       ! convert ipiv
                       ! there is no interchnge of rows i and and ipiv(i),
                       ! so this should be reflected in ipiv format for
                       ! *sytrf_rk ( or *sytrf_bk)
                       ipiv(i) = i
                       i = i - 1
                    end if
                    i = i - 1
                 end do
              else
                 ! revert a (a is upper)
                 ! revert permutations and ipiv
                 ! apply permutations to submatrices of upper part of a
                 ! in reverse factorization order where i increases from 1 to n
                 i = 1
                 do while (i <= n)
                    if (ipiv(i) > 0) then
                       ! 1-by-1 pivot interchange
                       ! swap rows i and ipiv(i) in a(1:i,n-i:n)
                       ip = ipiv(i)
                       if (i < n) then
                          if (ip /= i) then
                             call stdlib_zswap(n - i, a(ip, i + 1), lda, a(i, i + 1), lda)
                          end if
                       end if
                    else
                       ! 2-by-2 pivot interchange
                       ! swap rows i-1 and ipiv(i) in a(1:i,n-i:n)
                       i = i + 1
                       ip = -ipiv(i)
                       if (i < n) then
                          if (ip /= (i - 1)) then
                             call stdlib_zswap(n - i, a(ip, i + 1), lda, a(i - 1, i + 1), lda)
                                       
                          end if
                       end if
                       ! convert ipiv
                       ! there is cone interchange of rows i-1 and ipiv(i-1),
                       ! so this should be recorded in two consecutive entries
                       ! in ipiv format for *sytrf
                       ipiv(i) = ipiv(i - 1)
                    end if
                    i = i + 1
                 end do
                 ! revert value
                 ! assign superdiagonal entries of d from array e to
                 ! superdiagonal entries of a.
                 i = n
                 do while (i > 1)
                    if (ipiv(i) < 0) then
                       a(i - 1, i) = e(i)
                       i = i - 1
                    end if
                    i = i - 1
                 end do
              ! end a is upper
              end if
           else
              ! begin a is lower
              if (convert) then
                 ! convert a (a is lower)
                 ! convert value
                 ! assign subdiagonal entries of d to array e and czero out
                 ! corresponding entries in input storage a
                 i = 1
                 e(n) = czero
                 do while (i <= n)
                    if (i < n .and. ipiv(i) < 0) then
                       e(i) = a(i + 1, i)
                       e(i + 1) = czero
                       a(i + 1, i) = czero
                       i = i + 1
                    else
                       e(i) = czero
                    end if
                    i = i + 1
                 end do
                 ! convert permutations and ipiv
                 ! apply permutations to submatrices of lower part of a
                 ! in factorization order where k increases from 1 to n
                 i = 1
                 do while (i <= n)
                    if (ipiv(i) > 0) then
                       ! 1-by-1 pivot interchange
                       ! swap rows i and ipiv(i) in a(i:n,1:i-1)
                       ip = ipiv(i)
                       if (i > 1) then
                          if (ip /= i) then
                             call stdlib_zswap(i - 1, a(i, 1), lda, a(ip, 1), lda)
                          end if
                       end if
                    else
                       ! 2-by-2 pivot interchange
                       ! swap rows i+1 and ipiv(i) in a(i:n,1:i-1)
                       ip = -ipiv(i)
                       if (i > 1) then
                          if (ip /= (i + 1)) then
                             call stdlib_zswap(i - 1, a(i + 1, 1), lda, a(ip, 1), lda)
                          end if
                       end if
                       ! convert ipiv
                       ! there is no interchnge of rows i and and ipiv(i),
                       ! so this should be reflected in ipiv format for
                       ! *sytrf_rk ( or *sytrf_bk)
                       ipiv(i) = i
                       i = i + 1
                    end if
                    i = i + 1
                 end do
              else
                 ! revert a (a is lower)
                 ! revert permutations and ipiv
                 ! apply permutations to submatrices of lower part of a
                 ! in reverse factorization order where i decreases from n to 1
                 i = n
                 do while (i >= 1)
                    if (ipiv(i) > 0) then
                       ! 1-by-1 pivot interchange
                       ! swap rows i and ipiv(i) in a(i:n,1:i-1)
                       ip = ipiv(i)
                       if (i > 1) then
                          if (ip /= i) then
                             call stdlib_zswap(i - 1, a(ip, 1), lda, a(i, 1), lda)
                          end if
                       end if
                    else
                       ! 2-by-2 pivot interchange
                       ! swap rows i+1 and ipiv(i) in a(i:n,1:i-1)
                       i = i - 1
                       ip = -ipiv(i)
                       if (i > 1) then
                          if (ip /= (i + 1)) then
                             call stdlib_zswap(i - 1, a(ip, 1), lda, a(i + 1, 1), lda)
                          end if
                       end if
                       ! convert ipiv
                       ! there is cone interchange of rows i+1 and ipiv(i+1),
                       ! so this should be recorded in consecutive entries
                       ! in ipiv format for *sytrf
                       ipiv(i) = ipiv(i + 1)
                    end if
                    i = i - 1
                 end do
                 ! revert value
                 ! assign subdiagonal entries of d from array e to
                 ! subgiagonal entries of a.
                 i = 1
                 do while (i <= n - 1)
                    if (ipiv(i) < 0) then
                       a(i + 1, i) = e(i)
                       i = i + 1
                    end if
                    i = i + 1
                 end do
              end if
              ! end a is lower
           end if
           return
           ! end of stdlib_zsyconvf
     end subroutine stdlib_zsyconvf

     ! If parameter WAY = 'C':
     ! ZSYCONVF_ROOK converts the factorization output format used in
     ! ZSYTRF_ROOK provided on entry in parameter A into the factorization
     ! output format used in ZSYTRF_RK (or ZSYTRF_BK) that is stored
     ! on exit in parameters A and E. IPIV format for ZSYTRF_ROOK and
     ! ZSYTRF_RK (or ZSYTRF_BK) is the same and is not converted.
     ! If parameter WAY = 'R':
     ! ZSYCONVF_ROOK performs the conversion in reverse direction, i.e.
     ! converts the factorization output format used in ZSYTRF_RK
     ! (or ZSYTRF_BK) provided on entry in parameters A and E into
     ! the factorization output format used in ZSYTRF_ROOK that is stored
     ! on exit in parameter A. IPIV format for ZSYTRF_ROOK and
     ! ZSYTRF_RK (or ZSYTRF_BK) is the same and is not converted.
     ! ZSYCONVF_ROOK can also convert in Hermitian matrix case, i.e. between
     ! formats used in ZHETRF_ROOK and ZHETRF_RK (or ZHETRF_BK).

     subroutine stdlib_zsyconvf_rook(uplo, way, n, a, lda, e, ipiv, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo, way
           integer(ilp) :: info, lda, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *), e(*)
        ! =====================================================================
           
           ! .. external subroutines ..
     
           logical(lk) :: upper, convert
           integer(ilp) :: i, ip, ip2
           ! .. executable statements ..
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           convert = stdlib_lsame(way, 'c')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (.not. convert .and. .not. stdlib_lsame(way, 'r')) then
              info = -2
           else if (n < 0) then
              info = -3
           else if (lda < max(1, n)) then
              info = -5
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zsyconvf_rook', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           if (upper) then
              ! begin a is upper
              if (convert) then
                 ! convert a (a is upper)
                 ! convert value
                 ! assign superdiagonal entries of d to array e and czero out
                 ! corresponding entries in input storage a
                 i = n
                 e(1) = czero
                 do while (i > 1)
                    if (ipiv(i) < 0) then
                       e(i) = a(i - 1, i)
                       e(i - 1) = czero
                       a(i - 1, i) = czero
                       i = i - 1
                    else
                       e(i) = czero
                    end if
                    i = i - 1
                 end do
                 ! convert permutations
                 ! apply permutations to submatrices of upper part of a
                 ! in factorization order where i decreases from n to 1
                 i = n
                 do while (i >= 1)
                    if (ipiv(i) > 0) then
                       ! 1-by-1 pivot interchange
                       ! swap rows i and ipiv(i) in a(1:i,n-i:n)
                       ip = ipiv(i)
                       if (i < n) then
                          if (ip /= i) then
                             call stdlib_zswap(n - i, a(i, i + 1), lda, a(ip, i + 1), lda)
                          end if
                       end if
                    else
                       ! 2-by-2 pivot interchange
                       ! swap rows i and ipiv(i) and i-1 and ipiv(i-1)
                       ! in a(1:i,n-i:n)
                       ip = -ipiv(i)
                       ip2 = -ipiv(i - 1)
                       if (i < n) then
                          if (ip /= i) then
                             call stdlib_zswap(n - i, a(i, i + 1), lda, a(ip, i + 1), lda)
                          end if
                          if (ip2 /= (i - 1)) then
                             call stdlib_zswap(n - i, a(i - 1, i + 1), lda, a(ip2, i + 1), lda)
                                       
                          end if
                       end if
                       i = i - 1
                    end if
                    i = i - 1
                 end do
              else
                 ! revert a (a is upper)
                 ! revert permutations
                 ! apply permutations to submatrices of upper part of a
                 ! in reverse factorization order where i increases from 1 to n
                 i = 1
                 do while (i <= n)
                    if (ipiv(i) > 0) then
                       ! 1-by-1 pivot interchange
                       ! swap rows i and ipiv(i) in a(1:i,n-i:n)
                       ip = ipiv(i)
                       if (i < n) then
                          if (ip /= i) then
                             call stdlib_zswap(n - i, a(ip, i + 1), lda, a(i, i + 1), lda)
                          end if
                       end if
                    else
                       ! 2-by-2 pivot interchange
                       ! swap rows i-1 and ipiv(i-1) and i and ipiv(i)
                       ! in a(1:i,n-i:n)
                       i = i + 1
                       ip = -ipiv(i)
                       ip2 = -ipiv(i - 1)
                       if (i < n) then
                          if (ip2 /= (i - 1)) then
                             call stdlib_zswap(n - i, a(ip2, i + 1), lda, a(i - 1, i + 1), lda)
                                       
                          end if
                          if (ip /= i) then
                             call stdlib_zswap(n - i, a(ip, i + 1), lda, a(i, i + 1), lda)
                          end if
                       end if
                    end if
                    i = i + 1
                 end do
                 ! revert value
                 ! assign superdiagonal entries of d from array e to
                 ! superdiagonal entries of a.
                 i = n
                 do while (i > 1)
                    if (ipiv(i) < 0) then
                       a(i - 1, i) = e(i)
                       i = i - 1
                    end if
                    i = i - 1
                 end do
              ! end a is upper
              end if
           else
              ! begin a is lower
              if (convert) then
                 ! convert a (a is lower)
                 ! convert value
                 ! assign subdiagonal entries of d to array e and czero out
                 ! corresponding entries in input storage a
                 i = 1
                 e(n) = czero
                 do while (i <= n)
                    if (i < n .and. ipiv(i) < 0) then
                       e(i) = a(i + 1, i)
                       e(i + 1) = czero
                       a(i + 1, i) = czero
                       i = i + 1
                    else
                       e(i) = czero
                    end if
                    i = i + 1
                 end do
                 ! convert permutations
                 ! apply permutations to submatrices of lower part of a
                 ! in factorization order where i increases from 1 to n
                 i = 1
                 do while (i <= n)
                    if (ipiv(i) > 0) then
                       ! 1-by-1 pivot interchange
                       ! swap rows i and ipiv(i) in a(i:n,1:i-1)
                       ip = ipiv(i)
                       if (i > 1) then
                          if (ip /= i) then
                             call stdlib_zswap(i - 1, a(i, 1), lda, a(ip, 1), lda)
                          end if
                       end if
                    else
                       ! 2-by-2 pivot interchange
                       ! swap rows i and ipiv(i) and i+1 and ipiv(i+1)
                       ! in a(i:n,1:i-1)
                       ip = -ipiv(i)
                       ip2 = -ipiv(i + 1)
                       if (i > 1) then
                          if (ip /= i) then
                             call stdlib_zswap(i - 1, a(i, 1), lda, a(ip, 1), lda)
                          end if
                          if (ip2 /= (i + 1)) then
                             call stdlib_zswap(i - 1, a(i + 1, 1), lda, a(ip2, 1), lda)
                          end if
                       end if
                       i = i + 1
                    end if
                    i = i + 1
                 end do
              else
                 ! revert a (a is lower)
                 ! revert permutations
                 ! apply permutations to submatrices of lower part of a
                 ! in reverse factorization order where i decreases from n to 1
                 i = n
                 do while (i >= 1)
                    if (ipiv(i) > 0) then
                       ! 1-by-1 pivot interchange
                       ! swap rows i and ipiv(i) in a(i:n,1:i-1)
                       ip = ipiv(i)
                       if (i > 1) then
                          if (ip /= i) then
                             call stdlib_zswap(i - 1, a(ip, 1), lda, a(i, 1), lda)
                          end if
                       end if
                    else
                       ! 2-by-2 pivot interchange
                       ! swap rows i+1 and ipiv(i+1) and i and ipiv(i)
                       ! in a(i:n,1:i-1)
                       i = i - 1
                       ip = -ipiv(i)
                       ip2 = -ipiv(i + 1)
                       if (i > 1) then
                          if (ip2 /= (i + 1)) then
                             call stdlib_zswap(i - 1, a(ip2, 1), lda, a(i + 1, 1), lda)
                          end if
                          if (ip /= i) then
                             call stdlib_zswap(i - 1, a(ip, 1), lda, a(i, 1), lda)
                          end if
                       end if
                    end if
                    i = i - 1
                 end do
                 ! revert value
                 ! assign subdiagonal entries of d from array e to
                 ! subgiagonal entries of a.
                 i = 1
                 do while (i <= n - 1)
                    if (ipiv(i) < 0) then
                       a(i + 1, i) = e(i)
                       i = i + 1
                    end if
                    i = i + 1
                 end do
              end if
              ! end a is lower
           end if
           return
           ! end of stdlib_zsyconvf_rook
     end subroutine stdlib_zsyconvf_rook

     ! ZSYEQUB computes row and column scalings intended to equilibrate a
     ! symmetric matrix A (with respect to the Euclidean norm) and reduce
     ! its condition number. The scale factors S are computed by the BIN
     ! algorithm (see references) so that the scaled matrix B with elements
     ! B(i,j) = S(i)*A(i,j)*S(j) has a condition number within a factor N of
     ! the smallest possible condition number over all possible diagonal
     ! scalings.

     subroutine stdlib_zsyequb(uplo, n, a, lda, s, scond, amax, work, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           integer(ilp) :: info, lda, n
           real(dp) :: amax, scond
           character :: uplo
           ! .. array arguments ..
           complex(dp) :: a(lda, *), work(*)
           real(dp) :: s(*)
        ! =====================================================================
           ! .. parameters ..
           integer(ilp), parameter :: max_iter = 100
           
           ! .. local scalars ..
           integer(ilp) :: i, j, iter
           real(dp) :: avg, std, tol, c0, c1, c2, t, u, si, d, base, smin, smax, smlnum, bignum, &
                     scale, sumsq
           logical(lk) :: up
           complex(dp) :: zdum
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, aimag, int, log, max, min, sqrt
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(zdum) = abs(real(zdum, KIND=dp)) + abs(aimag(zdum))
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           if (.not. (stdlib_lsame(uplo, 'u') .or. stdlib_lsame(uplo, 'l'))) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, n)) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zsyequb', -info)
              return
           end if
           up = stdlib_lsame(uplo, 'u')
           amax = zero
           ! quick return if possible.
           if (n == 0) then
              scond = one
              return
           end if
           do i = 1, n
              s(i) = zero
           end do
           amax = zero
           if (up) then
              do j = 1, n
                 do i = 1, j - 1
                    s(i) = max(s(i), cabs1(a(i, j)))
                    s(j) = max(s(j), cabs1(a(i, j)))
                    amax = max(amax, cabs1(a(i, j)))
                 end do
                 s(j) = max(s(j), cabs1(a(j, j)))
                 amax = max(amax, cabs1(a(j, j)))
              end do
           else
              do j = 1, n
                 s(j) = max(s(j), cabs1(a(j, j)))
                 amax = max(amax, cabs1(a(j, j)))
                 do i = j + 1, n
                    s(i) = max(s(i), cabs1(a(i, j)))
                    s(j) = max(s(j), cabs1(a(i, j)))
                    amax = max(amax, cabs1(a(i, j)))
                 end do
              end do
           end if
           do j = 1, n
              s(j) = 1.0d0/s(j)
           end do
           tol = one/sqrt(2.0d0*n)
           do iter = 1, max_iter
              scale = 0.0d0
              sumsq = 0.0d0
              ! beta = |a|s
              do i = 1, n
                 work(i) = zero
              end do
              if (up) then
                 do j = 1, n
                    do i = 1, j - 1
                       work(i) = work(i) + cabs1(a(i, j))*s(j)
                       work(j) = work(j) + cabs1(a(i, j))*s(i)
                    end do
                    work(j) = work(j) + cabs1(a(j, j))*s(j)
                 end do
              else
                 do j = 1, n
                    work(j) = work(j) + cabs1(a(j, j))*s(j)
                    do i = j + 1, n
                       work(i) = work(i) + cabs1(a(i, j))*s(j)
                       work(j) = work(j) + cabs1(a(i, j))*s(i)
                    end do
                 end do
              end if
              ! avg = s^t beta / n
              avg = 0.0d0
              do i = 1, n
                 avg = avg + s(i)*real(work(i), KIND=dp)
              end do
              avg = avg/n
              std = 0.0d0
              do i = n + 1, 2*n
                 work(i) = s(i - n)*work(i - n) - avg
              end do
              call stdlib_zlassq(n, work(n + 1), 1, scale, sumsq)
              std = scale*sqrt(sumsq/n)
              if (std < tol*avg) goto 999
              do i = 1, n
                 t = cabs1(a(i, i))
                 si = s(i)
                 c2 = (n - 1)*t
                 c1 = (n - 2)*(real(work(i), KIND=dp) - t*si)
                 c0 = -(t*si)*si + 2*real(work(i), KIND=dp)*si - n*avg
                 d = c1*c1 - 4*c0*c2
                 if (d <= 0) then
                    info = -1
                    return
                 end if
                 si = -2*c0/(c1 + sqrt(d))
                 d = si - s(i)
                 u = zero
                 if (up) then
                    do j = 1, i
                       t = cabs1(a(j, i))
                       u = u + s(j)*t
                       work(j) = work(j) + d*t
                    end do
                    do j = i + 1, n
                       t = cabs1(a(i, j))
                       u = u + s(j)*t
                       work(j) = work(j) + d*t
                    end do
                 else
                    do j = 1, i
                       t = cabs1(a(i, j))
                       u = u + s(j)*t
                       work(j) = work(j) + d*t
                    end do
                    do j = i + 1, n
                       t = cabs1(a(j, i))
                       u = u + s(j)*t
                       work(j) = work(j) + d*t
                    end do
                 end if
                 avg = avg + (u + real(work(i), KIND=dp))*d/n
                 s(i) = si
              end do
           end do
999   continue
           smlnum = stdlib_dlamch('safemin')
           bignum = one/smlnum
           smin = bignum
           smax = zero
           t = one/sqrt(avg)
           base = stdlib_dlamch('b')
           u = one/log(base)
           do i = 1, n
              s(i) = base**int(u*log(s(i)*t))
              smin = min(smin, s(i))
              smax = max(smax, s(i))
           end do
           scond = max(smin, smlnum)/min(smax, bignum)
     end subroutine stdlib_zsyequb

     ! ZSYMV  performs the matrix-vector  operation
     ! y := alpha*A*x + beta*y,
     ! where alpha and beta are scalars, x and y are n element vectors and
     ! A is an n by n symmetric matrix.

     subroutine stdlib_zsymv(uplo, n, alpha, a, lda, x, incx, beta, y, incy)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: incx, incy, lda, n
           complex(dp) :: alpha, beta
           ! .. array arguments ..
           complex(dp) :: a(lda, *), x(*), y(*)
       ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i, info, ix, iy, j, jx, jy, kx, ky
           complex(dp) :: temp1, temp2
     
           ! .. intrinsic functions ..
           intrinsic :: max
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           if (.not. stdlib_lsame(uplo, 'u') .and. .not. stdlib_lsame(uplo, 'l')) then
              info = 1
           else if (n < 0) then
              info = 2
           else if (lda < max(1, n)) then
              info = 5
           else if (incx == 0) then
              info = 7
           else if (incy == 0) then
              info = 10
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zsymv ', info)
              return
           end if
           ! quick return if possible.
           if ((n == 0) .or. ((alpha == czero) .and. (beta == cone))) return
           ! set up the start points in  x  and  y.
           if (incx > 0) then
              kx = 1
           else
              kx = 1 - (n - 1)*incx
           end if
           if (incy > 0) then
              ky = 1
           else
              ky = 1 - (n - 1)*incy
           end if
           ! start the operations. in this version the elements of a are
           ! accessed sequentially with cone pass through the triangular part
           ! of a.
           ! first form  y := beta*y.
           if (beta /= cone) then
              if (incy == 1) then
                 if (beta == czero) then
                    do i = 1, n
                       y(i) = czero
                    end do
                 else
                    do i = 1, n
                       y(i) = beta*y(i)
                    end do
                 end if
              else
                 iy = ky
                 if (beta == czero) then
                    do i = 1, n
                       y(iy) = czero
                       iy = iy + incy
                    end do
                 else
                    do i = 1, n
                       y(iy) = beta*y(iy)
                       iy = iy + incy
                    end do
                 end if
              end if
           end if
           if (alpha == czero) return
           if (stdlib_lsame(uplo, 'u')) then
              ! form  y  when a is stored in upper triangle.
              if ((incx == 1) .and. (incy == 1)) then
                 do j = 1, n
                    temp1 = alpha*x(j)
                    temp2 = czero
                    do i = 1, j - 1
                       y(i) = y(i) + temp1*a(i, j)
                       temp2 = temp2 + a(i, j)*x(i)
                    end do
                    y(j) = y(j) + temp1*a(j, j) + alpha*temp2
                 end do
              else
                 jx = kx
                 jy = ky
                 do j = 1, n
                    temp1 = alpha*x(jx)
                    temp2 = czero
                    ix = kx
                    iy = ky
                    do i = 1, j - 1
                       y(iy) = y(iy) + temp1*a(i, j)
                       temp2 = temp2 + a(i, j)*x(ix)
                       ix = ix + incx
                       iy = iy + incy
                    end do
                    y(jy) = y(jy) + temp1*a(j, j) + alpha*temp2
                    jx = jx + incx
                    jy = jy + incy
                 end do
              end if
           else
              ! form  y  when a is stored in lower triangle.
              if ((incx == 1) .and. (incy == 1)) then
                 do j = 1, n
                    temp1 = alpha*x(j)
                    temp2 = czero
                    y(j) = y(j) + temp1*a(j, j)
                    do i = j + 1, n
                       y(i) = y(i) + temp1*a(i, j)
                       temp2 = temp2 + a(i, j)*x(i)
                    end do
                    y(j) = y(j) + alpha*temp2
                 end do
              else
                 jx = kx
                 jy = ky
                 do j = 1, n
                    temp1 = alpha*x(jx)
                    temp2 = czero
                    y(jy) = y(jy) + temp1*a(j, j)
                    ix = jx
                    iy = jy
                    do i = j + 1, n
                       ix = ix + incx
                       iy = iy + incy
                       y(iy) = y(iy) + temp1*a(i, j)
                       temp2 = temp2 + a(i, j)*x(ix)
                    end do
                    y(jy) = y(jy) + alpha*temp2
                    jx = jx + incx
                    jy = jy + incy
                 end do
              end if
           end if
           return
           ! end of stdlib_zsymv
     end subroutine stdlib_zsymv

     ! ZSYR   performs the symmetric rank 1 operation
     ! A := alpha*x*x**H + A,
     ! where alpha is a complex scalar, x is an n element vector and A is an
     ! n by n symmetric matrix.

     subroutine stdlib_zsyr(uplo, n, alpha, x, incx, a, lda)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: incx, lda, n
           complex(dp) :: alpha
           ! .. array arguments ..
           complex(dp) :: a(lda, *), x(*)
       ! =====================================================================
           
           ! .. local scalars ..
           integer(ilp) :: i, info, ix, j, jx, kx
           complex(dp) :: temp
     
           ! .. intrinsic functions ..
           intrinsic :: max
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           if (.not. stdlib_lsame(uplo, 'u') .and. .not. stdlib_lsame(uplo, 'l')) then
              info = 1
           else if (n < 0) then
              info = 2
           else if (incx == 0) then
              info = 5
           else if (lda < max(1, n)) then
              info = 7
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zsyr  ', info)
              return
           end if
           ! quick return if possible.
           if ((n == 0) .or. (alpha == czero)) return
           ! set the start point in x if the increment is not unity.
           if (incx <= 0) then
              kx = 1 - (n - 1)*incx
           else if (incx /= 1) then
              kx = 1
           end if
           ! start the operations. in this version the elements of a are
           ! accessed sequentially with cone pass through the triangular part
           ! of a.
           if (stdlib_lsame(uplo, 'u')) then
              ! form  a  when a is stored in upper triangle.
              if (incx == 1) then
                 do j = 1, n
                    if (x(j) /= czero) then
                       temp = alpha*x(j)
                       do i = 1, j
                          a(i, j) = a(i, j) + x(i)*temp
                       end do
                    end if
                 end do
              else
                 jx = kx
                 do j = 1, n
                    if (x(jx) /= czero) then
                       temp = alpha*x(jx)
                       ix = kx
                       do i = 1, j
                          a(i, j) = a(i, j) + x(ix)*temp
                          ix = ix + incx
                       end do
                    end if
                    jx = jx + incx
                 end do
              end if
           else
              ! form  a  when a is stored in lower triangle.
              if (incx == 1) then
                 do j = 1, n
                    if (x(j) /= czero) then
                       temp = alpha*x(j)
                       do i = j, n
                          a(i, j) = a(i, j) + x(i)*temp
                       end do
                    end if
                 end do
              else
                 jx = kx
                 do j = 1, n
                    if (x(jx) /= czero) then
                       temp = alpha*x(jx)
                       ix = jx
                       do i = j, n
                          a(i, j) = a(i, j) + x(ix)*temp
                          ix = ix + incx
                       end do
                    end if
                    jx = jx + incx
                 end do
              end if
           end if
           return
           ! end of stdlib_zsyr
     end subroutine stdlib_zsyr

     ! ZSYSWAPR applies an elementary permutation on the rows and the columns of
     ! a symmetric matrix.

     subroutine stdlib_zsyswapr(uplo, n, a, lda, i1, i2)
        ! -- lapack auxiliary routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: i1, i2, lda, n
           ! .. array arguments ..
           complex(dp) :: a(lda, n)
        ! =====================================================================
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: i
           complex(dp) :: tmp
     
           ! .. executable statements ..
           upper = stdlib_lsame(uplo, 'u')
           if (upper) then
               ! upper
               ! first swap
                ! - swap column i1 and i2 from i1 to i1-1
              call stdlib_zswap(i1 - 1, a(1, i1), 1, a(1, i2), 1)
                ! second swap :
                ! - swap a(i1,i1) and a(i2,i2)
                ! - swap row i1 from i1+1 to i2-1 with col i2 from i1+1 to i2-1
              tmp = a(i1, i1)
              a(i1, i1) = a(i2, i2)
              a(i2, i2) = tmp
              do i = 1, i2 - i1 - 1
                 tmp = a(i1, i1 + i)
                 a(i1, i1 + i) = a(i1 + i, i2)
                 a(i1 + i, i2) = tmp
              end do
                ! third swap
                ! - swap row i1 and i2 from i2+1 to n
              do i = i2 + 1, n
                 tmp = a(i1, i)
                 a(i1, i) = a(i2, i)
                 a(i2, i) = tmp
              end do
             else
               ! lower
               ! first swap
                ! - swap row i1 and i2 from i1 to i1-1
              call stdlib_zswap(i1 - 1, a(i1, 1), lda, a(i2, 1), lda)
               ! second swap :
                ! - swap a(i1,i1) and a(i2,i2)
                ! - swap col i1 from i1+1 to i2-1 with row i2 from i1+1 to i2-1
               tmp = a(i1, i1)
               a(i1, i1) = a(i2, i2)
               a(i2, i2) = tmp
               do i = 1, i2 - i1 - 1
                  tmp = a(i1 + i, i1)
                  a(i1 + i, i1) = a(i2, i1 + i)
                  a(i2, i1 + i) = tmp
               end do
               ! third swap
                ! - swap col i1 and i2 from i2+1 to n
               do i = i2 + 1, n
                  tmp = a(i, i1)
                  a(i, i1) = a(i, i2)
                  a(i, i2) = tmp
               end do
           end if
     end subroutine stdlib_zsyswapr

     ! ZSYTF2 computes the factorization of a complex symmetric matrix A
     ! using the Bunch-Kaufman diagonal pivoting method:
     ! A = U*D*U**T  or  A = L*D*L**T
     ! where U (or L) is a product of permutation and unit upper (lower)
     ! triangular matrices, U**T is the transpose of U, and D is symmetric and
     ! block diagonal with 1-by-1 and 2-by-2 diagonal blocks.
     ! This is the unblocked version of the algorithm, calling Level 2 BLAS.

     subroutine stdlib_zsytf2(uplo, n, a, lda, ipiv, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, lda, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: sevten = 17.0_dp
           
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: i, imax, j, jmax, k, kk, kp, kstep
           real(dp) :: absakk, alpha, colmax, rowmax
           complex(dp) :: d11, d12, d21, d22, r1, t, wk, wkm1, wkp1, z
     
           ! .. intrinsic functions ..
           intrinsic :: abs, dble, aimag, max, sqrt
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(z) = abs(real(z, KIND=dp)) + abs(aimag(z))
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, n)) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zsytf2', -info)
              return
           end if
           ! initialize alpha for use in choosing pivot block size.
           alpha = (one + sqrt(sevten))/eight
           if (upper) then
              ! factorize a as u*d*u**t using the upper triangle of a
              ! k is the main loop index, decreasing from n to 1 in steps of
              ! 1 or 2
              k = n
10      continue
              ! if k < 1, exit from loop
              if (k < 1) go to 70
              kstep = 1
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = cabs1(a(k, k))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k > 1) then
                 imax = stdlib_izamax(k - 1, a(1, k), 1)
                 colmax = cabs1(a(imax, k))
              else
                 colmax = zero
              end if
              if (max(absakk, colmax) == zero .or. stdlib_disnan(absakk)) then
                 ! column k is zero or underflow, or contains a nan:
                 ! set info and continue
                 if (info == 0) info = k
                 kp = k
              else
                 if (absakk >= alpha*colmax) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    ! jmax is the column-index of the largest off-diagonal
                    ! element in row imax, and rowmax is its absolute value
                    jmax = imax + stdlib_izamax(k - imax, a(imax, imax + 1), lda)
                    rowmax = cabs1(a(imax, jmax))
                    if (imax > 1) then
                       jmax = stdlib_izamax(imax - 1, a(1, imax), 1)
                       rowmax = max(rowmax, cabs1(a(jmax, imax)))
                    end if
                    if (absakk >= alpha*colmax*(colmax/rowmax)) then
                       ! no interchange, use 1-by-1 pivot block
                       kp = k
                    else if (cabs1(a(imax, imax)) >= alpha*rowmax) then
                       ! interchange rows and columns k and imax, use 1-by-1
                       ! pivot block
                       kp = imax
                    else
                       ! interchange rows and columns k-1 and imax, use 2-by-2
                       ! pivot block
                       kp = imax
                       kstep = 2
                    end if
                 end if
                 kk = k - kstep + 1
                 if (kp /= kk) then
                    ! interchange rows and columns kk and kp in the leading
                    ! submatrix a(1:k,1:k)
                    call stdlib_zswap(kp - 1, a(1, kk), 1, a(1, kp), 1)
                    call stdlib_zswap(kk - kp - 1, a(kp + 1, kk), 1, a(kp, kp + 1), lda)
                    t = a(kk, kk)
                    a(kk, kk) = a(kp, kp)
                    a(kp, kp) = t
                    if (kstep == 2) then
                       t = a(k - 1, k)
                       a(k - 1, k) = a(kp, k)
                       a(kp, k) = t
                    end if
                 end if
                 ! update the leading submatrix
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k now holds
                    ! w(k) = u(k)*d(k)
                    ! where u(k) is the k-th column of u
                    ! perform a rank-1 update of a(1:k-1,1:k-1) as
                    ! a := a - u(k)*d(k)*u(k)**t = a - w(k)*1/d(k)*w(k)**t
                    r1 = cone/a(k, k)
                    call stdlib_zsyr(uplo, k - 1, -r1, a(1, k), 1, a, lda)
                    ! store u(k) in column k
                    call stdlib_zscal(k - 1, r1, a(1, k), 1)
                 else
                    ! 2-by-2 pivot block d(k): columns k and k-1 now hold
                    ! ( w(k-1) w(k) ) = ( u(k-1) u(k) )*d(k)
                    ! where u(k) and u(k-1) are the k-th and (k-1)-th columns
                    ! of u
                    ! perform a rank-2 update of a(1:k-2,1:k-2) as
                    ! a := a - ( u(k-1) u(k) )*d(k)*( u(k-1) u(k) )**t
                       ! = a - ( w(k-1) w(k) )*inv(d(k))*( w(k-1) w(k) )**t
                    if (k > 2) then
                       d12 = a(k - 1, k)
                       d22 = a(k - 1, k - 1)/d12
                       d11 = a(k, k)/d12
                       t = cone/(d11*d22 - cone)
                       d12 = t/d12
                       do j = k - 2, 1, -1
                          wkm1 = d12*(d11*a(j, k - 1) - a(j, k))
                          wk = d12*(d22*a(j, k) - a(j, k - 1))
                          do i = j, 1, -1
                             a(i, j) = a(i, j) - a(i, k)*wk - a(i, k - 1)*wkm1
                          end do
                          a(j, k) = wk
                          a(j, k - 1) = wkm1
                       end do
                    end if
                 end if
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -kp
                 ipiv(k - 1) = -kp
              end if
              ! decrease k and return to the start of the main loop
              k = k - kstep
              go to 10
           else
              ! factorize a as l*d*l**t using the lower triangle of a
              ! k is the main loop index, increasing from 1 to n in steps of
              ! 1 or 2
              k = 1
40      continue
              ! if k > n, exit from loop
              if (k > n) go to 70
              kstep = 1
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = cabs1(a(k, k))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k < n) then
                 imax = k + stdlib_izamax(n - k, a(k + 1, k), 1)
                 colmax = cabs1(a(imax, k))
              else
                 colmax = zero
              end if
              if (max(absakk, colmax) == zero .or. stdlib_disnan(absakk)) then
                 ! column k is zero or underflow, or contains a nan:
                 ! set info and continue
                 if (info == 0) info = k
                 kp = k
              else
                 if (absakk >= alpha*colmax) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    ! jmax is the column-index of the largest off-diagonal
                    ! element in row imax, and rowmax is its absolute value
                    jmax = k - 1 + stdlib_izamax(imax - k, a(imax, k), lda)
                    rowmax = cabs1(a(imax, jmax))
                    if (imax < n) then
                       jmax = imax + stdlib_izamax(n - imax, a(imax + 1, imax), 1)
                       rowmax = max(rowmax, cabs1(a(jmax, imax)))
                    end if
                    if (absakk >= alpha*colmax*(colmax/rowmax)) then
                       ! no interchange, use 1-by-1 pivot block
                       kp = k
                    else if (cabs1(a(imax, imax)) >= alpha*rowmax) then
                       ! interchange rows and columns k and imax, use 1-by-1
                       ! pivot block
                       kp = imax
                    else
                       ! interchange rows and columns k+1 and imax, use 2-by-2
                       ! pivot block
                       kp = imax
                       kstep = 2
                    end if
                 end if
                 kk = k + kstep - 1
                 if (kp /= kk) then
                    ! interchange rows and columns kk and kp in the trailing
                    ! submatrix a(k:n,k:n)
                    if (kp < n) call stdlib_zswap(n - kp, a(kp + 1, kk), 1, a(kp + 1, kp), 1)
                              
                    call stdlib_zswap(kp - kk - 1, a(kk + 1, kk), 1, a(kp, kk + 1), lda)
                    t = a(kk, kk)
                    a(kk, kk) = a(kp, kp)
                    a(kp, kp) = t
                    if (kstep == 2) then
                       t = a(k + 1, k)
                       a(k + 1, k) = a(kp, k)
                       a(kp, k) = t
                    end if
                 end if
                 ! update the trailing submatrix
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k now holds
                    ! w(k) = l(k)*d(k)
                    ! where l(k) is the k-th column of l
                    if (k < n) then
                       ! perform a rank-1 update of a(k+1:n,k+1:n) as
                       ! a := a - l(k)*d(k)*l(k)**t = a - w(k)*(1/d(k))*w(k)**t
                       r1 = cone/a(k, k)
                       call stdlib_zsyr(uplo, n - k, -r1, a(k + 1, k), 1, a(k + 1, k + 1), lda)
                                 
                       ! store l(k) in column k
                       call stdlib_zscal(n - k, r1, a(k + 1, k), 1)
                    end if
                 else
                    ! 2-by-2 pivot block d(k)
                    if (k < n - 1) then
                       ! perform a rank-2 update of a(k+2:n,k+2:n) as
                       ! a := a - ( l(k) l(k+1) )*d(k)*( l(k) l(k+1) )**t
                          ! = a - ( w(k) w(k+1) )*inv(d(k))*( w(k) w(k+1) )**t
                       ! where l(k) and l(k+1) are the k-th and (k+1)-th
                       ! columns of l
                       d21 = a(k + 1, k)
                       d11 = a(k + 1, k + 1)/d21
                       d22 = a(k, k)/d21
                       t = cone/(d11*d22 - cone)
                       d21 = t/d21
                       do j = k + 2, n
                          wk = d21*(d11*a(j, k) - a(j, k + 1))
                          wkp1 = d21*(d22*a(j, k + 1) - a(j, k))
                          do i = j, n
                             a(i, j) = a(i, j) - a(i, k)*wk - a(i, k + 1)*wkp1
                          end do
                          a(j, k) = wk
                          a(j, k + 1) = wkp1
                       end do
                    end if
                 end if
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -kp
                 ipiv(k + 1) = -kp
              end if
              ! increase k and return to the start of the main loop
              k = k + kstep
              go to 40
           end if
70      continue
           return
           ! end of stdlib_zsytf2
     end subroutine stdlib_zsytf2

     ! ZSYTF2_RK computes the factorization of a complex symmetric matrix A
     ! using the bounded Bunch-Kaufman (rook) diagonal pivoting method:
     ! A = P*U*D*(U**T)*(P**T) or A = P*L*D*(L**T)*(P**T),
     ! where U (or L) is unit upper (or lower) triangular matrix,
     ! U**T (or L**T) is the transpose of U (or L), P is a permutation
     ! matrix, P**T is the transpose of P, and D is symmetric and block
     ! diagonal with 1-by-1 and 2-by-2 diagonal blocks.
     ! This is the unblocked version of the algorithm, calling Level 2 BLAS.
     ! For more information see Further Details section.

     subroutine stdlib_zsytf2_rk(uplo, n, a, lda, e, ipiv, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, lda, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *), e(*)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: sevten = 17.0_dp
           
           ! .. local scalars ..
           logical(lk) :: upper, done
           integer(ilp) :: i, imax, j, jmax, itemp, k, kk, kp, kstep, p, ii
           real(dp) :: absakk, alpha, colmax, rowmax, dtemp, sfmin
           complex(dp) :: d11, d12, d21, d22, t, wk, wkm1, wkp1, z
     
           ! .. intrinsic functions ..
           intrinsic :: abs, max, sqrt, aimag, dble
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(z) = abs(real(z, KIND=dp)) + abs(aimag(z))
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, n)) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zsytf2_rk', -info)
              return
           end if
           ! initialize alpha for use in choosing pivot block size.
           alpha = (one + sqrt(sevten))/eight
           ! compute machine safe minimum
           sfmin = stdlib_dlamch('s')
           if (upper) then
              ! factorize a as u*d*u**t using the upper triangle of a
              ! initialize the first entry of array e, where superdiagonal
              ! elements of d are stored
              e(1) = czero
              ! k is the main loop index, decreasing from n to 1 in steps of
              ! 1 or 2
              k = n
10      continue
              ! if k < 1, exit from loop
              if (k < 1) go to 34
              kstep = 1
              p = k
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = cabs1(a(k, k))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k > 1) then
                 imax = stdlib_izamax(k - 1, a(1, k), 1)
                 colmax = cabs1(a(imax, k))
              else
                 colmax = zero
              end if
              if ((max(absakk, colmax) == zero)) then
                 ! column k is zero or underflow: set info and continue
                 if (info == 0) info = k
                 kp = k
                 ! set e( k ) to zero
                 if (k > 1) e(k) = czero
              else
                 ! test for interchange
                 ! equivalent to testing for (used to handle nan and inf)
                 ! absakk>=alpha*colmax
                 if (.not. (absakk < alpha*colmax)) then
                    ! no interchange,
                    ! use 1-by-1 pivot block
                    kp = k
                 else
                    done = .false.
                    ! loop until pivot found
12      continue
                       ! begin pivot search loop body
                       ! jmax is the column-index of the largest off-diagonal
                       ! element in row imax, and rowmax is its absolute value.
                       ! determine both rowmax and jmax.
                       if (imax /= k) then
                          jmax = imax + stdlib_izamax(k - imax, a(imax, imax + 1), lda)
                          rowmax = cabs1(a(imax, jmax))
                       else
                          rowmax = zero
                       end if
                       if (imax > 1) then
                          itemp = stdlib_izamax(imax - 1, a(1, imax), 1)
                          dtemp = cabs1(a(itemp, imax))
                          if (dtemp > rowmax) then
                             rowmax = dtemp
                             jmax = itemp
                          end if
                       end if
                       ! equivalent to testing for (used to handle nan and inf)
                       ! abs( a( imax, imax ) )>=alpha*rowmax
                       if (.not. (cabs1(a(imax, imax)) < alpha*rowmax)) then
                          ! interchange rows and columns k and imax,
                          ! use 1-by-1 pivot block
                          kp = imax
                          done = .true.
                       ! equivalent to testing for rowmax == colmax,
                       ! used to handle nan and inf
                       else if ((p == jmax) .or. (rowmax <= colmax)) then
                          ! interchange rows and columns k+1 and imax,
                          ! use 2-by-2 pivot block
                          kp = imax
                          kstep = 2
                          done = .true.
                       else
                          ! pivot not found, set variables and repeat
                          p = imax
                          colmax = rowmax
                          imax = jmax
                       end if
                       ! end pivot search loop body
                    if (.not. done) goto 12
                 end if
                 ! swap two rows and two columns
                 ! first swap
                 if ((kstep == 2) .and. (p /= k)) then
                    ! interchange rows and column k and p in the leading
                    ! submatrix a(1:k,1:k) if we have a 2-by-2 pivot
                    if (p > 1) call stdlib_zswap(p - 1, a(1, k), 1, a(1, p), 1)
                    if (p < (k - 1)) call stdlib_zswap(k - p - 1, a(p + 1, k), 1, a(p, p + 1), lda)
                              
                    t = a(k, k)
                    a(k, k) = a(p, p)
                    a(p, p) = t
                    ! convert upper triangle of a into u form by applying
                    ! the interchanges in columns k+1:n.
                    if (k < n) call stdlib_zswap(n - k, a(k, k + 1), lda, a(p, k + 1), lda)
                 end if
                 ! second swap
                 kk = k - kstep + 1
                 if (kp /= kk) then
                    ! interchange rows and columns kk and kp in the leading
                    ! submatrix a(1:k,1:k)
                    if (kp > 1) call stdlib_zswap(kp - 1, a(1, kk), 1, a(1, kp), 1)
                    if ((kk > 1) .and. (kp < (kk - 1))) call stdlib_zswap(kk - kp - 1, a(kp + 1, kk), &
                              1, a(kp, kp + 1), lda)
                    t = a(kk, kk)
                    a(kk, kk) = a(kp, kp)
                    a(kp, kp) = t
                    if (kstep == 2) then
                       t = a(k - 1, k)
                       a(k - 1, k) = a(kp, k)
                       a(kp, k) = t
                    end if
                    ! convert upper triangle of a into u form by applying
                    ! the interchanges in columns k+1:n.
                    if (k < n) call stdlib_zswap(n - k, a(kk, k + 1), lda, a(kp, k + 1), lda)
                 end if
                 ! update the leading submatrix
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k now holds
                    ! w(k) = u(k)*d(k)
                    ! where u(k) is the k-th column of u
                    if (k > 1) then
                       ! perform a rank-1 update of a(1:k-1,1:k-1) and
                       ! store u(k) in column k
                       if (cabs1(a(k, k)) >= sfmin) then
                          ! perform a rank-1 update of a(1:k-1,1:k-1) as
                          ! a := a - u(k)*d(k)*u(k)**t
                             ! = a - w(k)*1/d(k)*w(k)**t
                          d11 = cone/a(k, k)
                          call stdlib_zsyr(uplo, k - 1, -d11, a(1, k), 1, a, lda)
                          ! store u(k) in column k
                          call stdlib_zscal(k - 1, d11, a(1, k), 1)
                       else
                          ! store l(k) in column k
                          d11 = a(k, k)
                          do ii = 1, k - 1
                             a(ii, k) = a(ii, k)/d11
                          end do
                          ! perform a rank-1 update of a(k+1:n,k+1:n) as
                          ! a := a - u(k)*d(k)*u(k)**t
                             ! = a - w(k)*(1/d(k))*w(k)**t
                             ! = a - (w(k)/d(k))*(d(k))*(w(k)/d(k))**t
                          call stdlib_zsyr(uplo, k - 1, -d11, a(1, k), 1, a, lda)
                       end if
                       ! store the superdiagonal element of d in array e
                       e(k) = czero
                    end if
                 else
                    ! 2-by-2 pivot block d(k): columns k and k-1 now hold
                    ! ( w(k-1) w(k) ) = ( u(k-1) u(k) )*d(k)
                    ! where u(k) and u(k-1) are the k-th and (k-1)-th columns
                    ! of u
                    ! perform a rank-2 update of a(1:k-2,1:k-2) as
                    ! a := a - ( u(k-1) u(k) )*d(k)*( u(k-1) u(k) )**t
                       ! = a - ( ( a(k-1)a(k) )*inv(d(k)) ) * ( a(k-1)a(k) )**t
                    ! and store l(k) and l(k+1) in columns k and k+1
                    if (k > 2) then
                       d12 = a(k - 1, k)
                       d22 = a(k - 1, k - 1)/d12
                       d11 = a(k, k)/d12
                       t = cone/(d11*d22 - cone)
                       do j = k - 2, 1, -1
                          wkm1 = t*(d11*a(j, k - 1) - a(j, k))
                          wk = t*(d22*a(j, k) - a(j, k - 1))
                          do i = j, 1, -1
                             a(i, j) = a(i, j) - (a(i, k)/d12)*wk - (a(i, k - 1)/d12) &
                                       *wkm1
                          end do
                          ! store u(k) and u(k-1) in cols k and k-1 for row j
                          a(j, k) = wk/d12
                          a(j, k - 1) = wkm1/d12
                       end do
                    end if
                    ! copy superdiagonal elements of d(k) to e(k) and
                    ! zero out superdiagonal entry of a
                    e(k) = a(k - 1, k)
                    e(k - 1) = czero
                    a(k - 1, k) = czero
                 end if
                 ! end column k is nonsingular
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -p
                 ipiv(k - 1) = -kp
              end if
              ! decrease k and return to the start of the main loop
              k = k - kstep
              go to 10
34      continue
           else
              ! factorize a as l*d*l**t using the lower triangle of a
              ! initialize the unused last entry of the subdiagonal array e.
              e(n) = czero
              ! k is the main loop index, increasing from 1 to n in steps of
              ! 1 or 2
              k = 1
40      continue
              ! if k > n, exit from loop
              if (k > n) go to 64
              kstep = 1
              p = k
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = cabs1(a(k, k))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k < n) then
                 imax = k + stdlib_izamax(n - k, a(k + 1, k), 1)
                 colmax = cabs1(a(imax, k))
              else
                 colmax = zero
              end if
              if ((max(absakk, colmax) == zero)) then
                 ! column k is zero or underflow: set info and continue
                 if (info == 0) info = k
                 kp = k
                 ! set e( k ) to zero
                 if (k < n) e(k) = czero
              else
                 ! test for interchange
                 ! equivalent to testing for (used to handle nan and inf)
                 ! absakk>=alpha*colmax
                 if (.not. (absakk < alpha*colmax)) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    done = .false.
                    ! loop until pivot found
42      continue
                       ! begin pivot search loop body
                       ! jmax is the column-index of the largest off-diagonal
                       ! element in row imax, and rowmax is its absolute value.
                       ! determine both rowmax and jmax.
                       if (imax /= k) then
                          jmax = k - 1 + stdlib_izamax(imax - k, a(imax, k), lda)
                          rowmax = cabs1(a(imax, jmax))
                       else
                          rowmax = zero
                       end if
                       if (imax < n) then
                          itemp = imax + stdlib_izamax(n - imax, a(imax + 1, imax), 1)
                          dtemp = cabs1(a(itemp, imax))
                          if (dtemp > rowmax) then
                             rowmax = dtemp
                             jmax = itemp
                          end if
                       end if
                       ! equivalent to testing for (used to handle nan and inf)
                       ! abs( a( imax, imax ) )>=alpha*rowmax
                       if (.not. (cabs1(a(imax, imax)) < alpha*rowmax)) then
                          ! interchange rows and columns k and imax,
                          ! use 1-by-1 pivot block
                          kp = imax
                          done = .true.
                       ! equivalent to testing for rowmax == colmax,
                       ! used to handle nan and inf
                       else if ((p == jmax) .or. (rowmax <= colmax)) then
                          ! interchange rows and columns k+1 and imax,
                          ! use 2-by-2 pivot block
                          kp = imax
                          kstep = 2
                          done = .true.
                       else
                          ! pivot not found, set variables and repeat
                          p = imax
                          colmax = rowmax
                          imax = jmax
                       end if
                       ! end pivot search loop body
                    if (.not. done) goto 42
                 end if
                 ! swap two rows and two columns
                 ! first swap
                 if ((kstep == 2) .and. (p /= k)) then
                    ! interchange rows and column k and p in the trailing
                    ! submatrix a(k:n,k:n) if we have a 2-by-2 pivot
                    if (p < n) call stdlib_zswap(n - p, a(p + 1, k), 1, a(p + 1, p), 1)
                    if (p > (k + 1)) call stdlib_zswap(p - k - 1, a(k + 1, k), 1, a(p, k + 1), lda)
                              
                    t = a(k, k)
                    a(k, k) = a(p, p)
                    a(p, p) = t
                    ! convert lower triangle of a into l form by applying
                    ! the interchanges in columns 1:k-1.
                    if (k > 1) call stdlib_zswap(k - 1, a(k, 1), lda, a(p, 1), lda)
                 end if
                 ! second swap
                 kk = k + kstep - 1
                 if (kp /= kk) then
                    ! interchange rows and columns kk and kp in the trailing
                    ! submatrix a(k:n,k:n)
                    if (kp < n) call stdlib_zswap(n - kp, a(kp + 1, kk), 1, a(kp + 1, kp), 1)
                              
                    if ((kk < n) .and. (kp > (kk + 1))) call stdlib_zswap(kp - kk - 1, a(kk + 1, kk), &
                              1, a(kp, kk + 1), lda)
                    t = a(kk, kk)
                    a(kk, kk) = a(kp, kp)
                    a(kp, kp) = t
                    if (kstep == 2) then
                       t = a(k + 1, k)
                       a(k + 1, k) = a(kp, k)
                       a(kp, k) = t
                    end if
                    ! convert lower triangle of a into l form by applying
                    ! the interchanges in columns 1:k-1.
                    if (k > 1) call stdlib_zswap(k - 1, a(kk, 1), lda, a(kp, 1), lda)
                 end if
                 ! update the trailing submatrix
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k now holds
                    ! w(k) = l(k)*d(k)
                    ! where l(k) is the k-th column of l
                    if (k < n) then
                    ! perform a rank-1 update of a(k+1:n,k+1:n) and
                    ! store l(k) in column k
                       if (cabs1(a(k, k)) >= sfmin) then
                          ! perform a rank-1 update of a(k+1:n,k+1:n) as
                          ! a := a - l(k)*d(k)*l(k)**t
                             ! = a - w(k)*(1/d(k))*w(k)**t
                          d11 = cone/a(k, k)
                          call stdlib_zsyr(uplo, n - k, -d11, a(k + 1, k), 1, a(k + 1, k + 1), lda)
                                    
                          ! store l(k) in column k
                          call stdlib_zscal(n - k, d11, a(k + 1, k), 1)
                       else
                          ! store l(k) in column k
                          d11 = a(k, k)
                          do ii = k + 1, n
                             a(ii, k) = a(ii, k)/d11
                          end do
                          ! perform a rank-1 update of a(k+1:n,k+1:n) as
                          ! a := a - l(k)*d(k)*l(k)**t
                             ! = a - w(k)*(1/d(k))*w(k)**t
                             ! = a - (w(k)/d(k))*(d(k))*(w(k)/d(k))**t
                          call stdlib_zsyr(uplo, n - k, -d11, a(k + 1, k), 1, a(k + 1, k + 1), lda)
                                    
                       end if
                       ! store the subdiagonal element of d in array e
                       e(k) = czero
                    end if
                 else
                    ! 2-by-2 pivot block d(k): columns k and k+1 now hold
                    ! ( w(k) w(k+1) ) = ( l(k) l(k+1) )*d(k)
                    ! where l(k) and l(k+1) are the k-th and (k+1)-th columns
                    ! of l
                    ! perform a rank-2 update of a(k+2:n,k+2:n) as
                    ! a := a - ( l(k) l(k+1) ) * d(k) * ( l(k) l(k+1) )**t
                       ! = a - ( ( a(k)a(k+1) )*inv(d(k) ) * ( a(k)a(k+1) )**t
                    ! and store l(k) and l(k+1) in columns k and k+1
                    if (k < n - 1) then
                       d21 = a(k + 1, k)
                       d11 = a(k + 1, k + 1)/d21
                       d22 = a(k, k)/d21
                       t = cone/(d11*d22 - cone)
                       do j = k + 2, n
                          ! compute  d21 * ( w(k)w(k+1) ) * inv(d(k)) for row j
                          wk = t*(d11*a(j, k) - a(j, k + 1))
                          wkp1 = t*(d22*a(j, k + 1) - a(j, k))
                          ! perform a rank-2 update of a(k+2:n,k+2:n)
                          do i = j, n
                             a(i, j) = a(i, j) - (a(i, k)/d21)*wk - (a(i, k + 1)/d21) &
                                       *wkp1
                          end do
                          ! store l(k) and l(k+1) in cols k and k+1 for row j
                          a(j, k) = wk/d21
                          a(j, k + 1) = wkp1/d21
                       end do
                    end if
                    ! copy subdiagonal elements of d(k) to e(k) and
                    ! zero out subdiagonal entry of a
                    e(k) = a(k + 1, k)
                    e(k + 1) = czero
                    a(k + 1, k) = czero
                 end if
                 ! end column k is nonsingular
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -p
                 ipiv(k + 1) = -kp
              end if
              ! increase k and return to the start of the main loop
              k = k + kstep
              go to 40
64      continue
           end if
           return
           ! end of stdlib_zsytf2_rk
     end subroutine stdlib_zsytf2_rk

     ! ZSYTF2_ROOK computes the factorization of a complex symmetric matrix A
     ! using the bounded Bunch-Kaufman ("rook") diagonal pivoting method:
     ! A = U*D*U**T  or  A = L*D*L**T
     ! where U (or L) is a product of permutation and unit upper (lower)
     ! triangular matrices, U**T is the transpose of U, and D is symmetric and
     ! block diagonal with 1-by-1 and 2-by-2 diagonal blocks.
     ! This is the unblocked version of the algorithm, calling Level 2 BLAS.

     subroutine stdlib_zsytf2_rook(uplo, n, a, lda, ipiv, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, lda, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *)
        ! =====================================================================
           ! .. parameters ..
           real(dp), parameter :: sevten = 17.0_dp
           
           ! .. local scalars ..
           logical(lk) :: upper, done
           integer(ilp) :: i, imax, j, jmax, itemp, k, kk, kp, kstep, p, ii
           real(dp) :: absakk, alpha, colmax, rowmax, dtemp, sfmin
           complex(dp) :: d11, d12, d21, d22, t, wk, wkm1, wkp1, z
     
           ! .. intrinsic functions ..
           intrinsic :: abs, max, sqrt, aimag, dble
           ! .. statement functions ..
           real(dp) :: cabs1
           ! .. statement function definitions ..
           cabs1(z) = abs(real(z, KIND=dp)) + abs(aimag(z))
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, n)) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zsytf2_rook', -info)
              return
           end if
           ! initialize alpha for use in choosing pivot block size.
           alpha = (one + sqrt(sevten))/eight
           ! compute machine safe minimum
           sfmin = stdlib_dlamch('s')
           if (upper) then
              ! factorize a as u*d*u**t using the upper triangle of a
              ! k is the main loop index, decreasing from n to 1 in steps of
              ! 1 or 2
              k = n
10      continue
              ! if k < 1, exit from loop
              if (k < 1) go to 70
              kstep = 1
              p = k
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = cabs1(a(k, k))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k > 1) then
                 imax = stdlib_izamax(k - 1, a(1, k), 1)
                 colmax = cabs1(a(imax, k))
              else
                 colmax = zero
              end if
              if ((max(absakk, colmax) == zero)) then
                 ! column k is zero or underflow: set info and continue
                 if (info == 0) info = k
                 kp = k
              else
                 ! test for interchange
                 ! equivalent to testing for (used to handle nan and inf)
                 ! absakk>=alpha*colmax
                 if (.not. (absakk < alpha*colmax)) then
                    ! no interchange,
                    ! use 1-by-1 pivot block
                    kp = k
                 else
                    done = .false.
                    ! loop until pivot found
12      continue
                       ! begin pivot search loop body
                       ! jmax is the column-index of the largest off-diagonal
                       ! element in row imax, and rowmax is its absolute value.
                       ! determine both rowmax and jmax.
                       if (imax /= k) then
                          jmax = imax + stdlib_izamax(k - imax, a(imax, imax + 1), lda)
                          rowmax = cabs1(a(imax, jmax))
                       else
                          rowmax = zero
                       end if
                       if (imax > 1) then
                          itemp = stdlib_izamax(imax - 1, a(1, imax), 1)
                          dtemp = cabs1(a(itemp, imax))
                          if (dtemp > rowmax) then
                             rowmax = dtemp
                             jmax = itemp
                          end if
                       end if
                       ! equivalent to testing for (used to handle nan and inf)
                       ! cabs1( a( imax, imax ) )>=alpha*rowmax
                       if (.not. (cabs1(a(imax, imax)) < alpha*rowmax)) then
                          ! interchange rows and columns k and imax,
                          ! use 1-by-1 pivot block
                          kp = imax
                          done = .true.
                       ! equivalent to testing for rowmax == colmax,
                       ! used to handle nan and inf
                       else if ((p == jmax) .or. (rowmax <= colmax)) then
                          ! interchange rows and columns k+1 and imax,
                          ! use 2-by-2 pivot block
                          kp = imax
                          kstep = 2
                          done = .true.
                       else
                          ! pivot not found, set variables and repeat
                          p = imax
                          colmax = rowmax
                          imax = jmax
                       end if
                       ! end pivot search loop body
                    if (.not. done) goto 12
                 end if
                 ! swap two rows and two columns
                 ! first swap
                 if ((kstep == 2) .and. (p /= k)) then
                    ! interchange rows and column k and p in the leading
                    ! submatrix a(1:k,1:k) if we have a 2-by-2 pivot
                    if (p > 1) call stdlib_zswap(p - 1, a(1, k), 1, a(1, p), 1)
                    if (p < (k - 1)) call stdlib_zswap(k - p - 1, a(p + 1, k), 1, a(p, p + 1), lda)
                              
                    t = a(k, k)
                    a(k, k) = a(p, p)
                    a(p, p) = t
                 end if
                 ! second swap
                 kk = k - kstep + 1
                 if (kp /= kk) then
                    ! interchange rows and columns kk and kp in the leading
                    ! submatrix a(1:k,1:k)
                    if (kp > 1) call stdlib_zswap(kp - 1, a(1, kk), 1, a(1, kp), 1)
                    if ((kk > 1) .and. (kp < (kk - 1))) call stdlib_zswap(kk - kp - 1, a(kp + 1, kk), &
                              1, a(kp, kp + 1), lda)
                    t = a(kk, kk)
                    a(kk, kk) = a(kp, kp)
                    a(kp, kp) = t
                    if (kstep == 2) then
                       t = a(k - 1, k)
                       a(k - 1, k) = a(kp, k)
                       a(kp, k) = t
                    end if
                 end if
                 ! update the leading submatrix
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k now holds
                    ! w(k) = u(k)*d(k)
                    ! where u(k) is the k-th column of u
                    if (k > 1) then
                       ! perform a rank-1 update of a(1:k-1,1:k-1) and
                       ! store u(k) in column k
                       if (cabs1(a(k, k)) >= sfmin) then
                          ! perform a rank-1 update of a(1:k-1,1:k-1) as
                          ! a := a - u(k)*d(k)*u(k)**t
                             ! = a - w(k)*1/d(k)*w(k)**t
                          d11 = cone/a(k, k)
                          call stdlib_zsyr(uplo, k - 1, -d11, a(1, k), 1, a, lda)
                          ! store u(k) in column k
                          call stdlib_zscal(k - 1, d11, a(1, k), 1)
                       else
                          ! store l(k) in column k
                          d11 = a(k, k)
                          do ii = 1, k - 1
                             a(ii, k) = a(ii, k)/d11
                          end do
                          ! perform a rank-1 update of a(k+1:n,k+1:n) as
                          ! a := a - u(k)*d(k)*u(k)**t
                             ! = a - w(k)*(1/d(k))*w(k)**t
                             ! = a - (w(k)/d(k))*(d(k))*(w(k)/d(k))**t
                          call stdlib_zsyr(uplo, k - 1, -d11, a(1, k), 1, a, lda)
                       end if
                    end if
                 else
                    ! 2-by-2 pivot block d(k): columns k and k-1 now hold
                    ! ( w(k-1) w(k) ) = ( u(k-1) u(k) )*d(k)
                    ! where u(k) and u(k-1) are the k-th and (k-1)-th columns
                    ! of u
                    ! perform a rank-2 update of a(1:k-2,1:k-2) as
                    ! a := a - ( u(k-1) u(k) )*d(k)*( u(k-1) u(k) )**t
                       ! = a - ( ( a(k-1)a(k) )*inv(d(k)) ) * ( a(k-1)a(k) )**t
                    ! and store l(k) and l(k+1) in columns k and k+1
                    if (k > 2) then
                       d12 = a(k - 1, k)
                       d22 = a(k - 1, k - 1)/d12
                       d11 = a(k, k)/d12
                       t = cone/(d11*d22 - cone)
                       do j = k - 2, 1, -1
                          wkm1 = t*(d11*a(j, k - 1) - a(j, k))
                          wk = t*(d22*a(j, k) - a(j, k - 1))
                          do i = j, 1, -1
                             a(i, j) = a(i, j) - (a(i, k)/d12)*wk - (a(i, k - 1)/d12) &
                                       *wkm1
                          end do
                          ! store u(k) and u(k-1) in cols k and k-1 for row j
                          a(j, k) = wk/d12
                          a(j, k - 1) = wkm1/d12
                       end do
                    end if
                 end if
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -p
                 ipiv(k - 1) = -kp
              end if
              ! decrease k and return to the start of the main loop
              k = k - kstep
              go to 10
           else
              ! factorize a as l*d*l**t using the lower triangle of a
              ! k is the main loop index, increasing from 1 to n in steps of
              ! 1 or 2
              k = 1
40      continue
              ! if k > n, exit from loop
              if (k > n) go to 70
              kstep = 1
              p = k
              ! determine rows and columns to be interchanged and whether
              ! a 1-by-1 or 2-by-2 pivot block will be used
              absakk = cabs1(a(k, k))
              ! imax is the row-index of the largest off-diagonal element in
              ! column k, and colmax is its absolute value.
              ! determine both colmax and imax.
              if (k < n) then
                 imax = k + stdlib_izamax(n - k, a(k + 1, k), 1)
                 colmax = cabs1(a(imax, k))
              else
                 colmax = zero
              end if
              if ((max(absakk, colmax) == zero)) then
                 ! column k is zero or underflow: set info and continue
                 if (info == 0) info = k
                 kp = k
              else
                 ! test for interchange
                 ! equivalent to testing for (used to handle nan and inf)
                 ! absakk>=alpha*colmax
                 if (.not. (absakk < alpha*colmax)) then
                    ! no interchange, use 1-by-1 pivot block
                    kp = k
                 else
                    done = .false.
                    ! loop until pivot found
42      continue
                       ! begin pivot search loop body
                       ! jmax is the column-index of the largest off-diagonal
                       ! element in row imax, and rowmax is its absolute value.
                       ! determine both rowmax and jmax.
                       if (imax /= k) then
                          jmax = k - 1 + stdlib_izamax(imax - k, a(imax, k), lda)
                          rowmax = cabs1(a(imax, jmax))
                       else
                          rowmax = zero
                       end if
                       if (imax < n) then
                          itemp = imax + stdlib_izamax(n - imax, a(imax + 1, imax), 1)
                          dtemp = cabs1(a(itemp, imax))
                          if (dtemp > rowmax) then
                             rowmax = dtemp
                             jmax = itemp
                          end if
                       end if
                       ! equivalent to testing for (used to handle nan and inf)
                       ! cabs1( a( imax, imax ) )>=alpha*rowmax
                       if (.not. (cabs1(a(imax, imax)) < alpha*rowmax)) then
                          ! interchange rows and columns k and imax,
                          ! use 1-by-1 pivot block
                          kp = imax
                          done = .true.
                       ! equivalent to testing for rowmax == colmax,
                       ! used to handle nan and inf
                       else if ((p == jmax) .or. (rowmax <= colmax)) then
                          ! interchange rows and columns k+1 and imax,
                          ! use 2-by-2 pivot block
                          kp = imax
                          kstep = 2
                          done = .true.
                       else
                          ! pivot not found, set variables and repeat
                          p = imax
                          colmax = rowmax
                          imax = jmax
                       end if
                       ! end pivot search loop body
                    if (.not. done) goto 42
                 end if
                 ! swap two rows and two columns
                 ! first swap
                 if ((kstep == 2) .and. (p /= k)) then
                    ! interchange rows and column k and p in the trailing
                    ! submatrix a(k:n,k:n) if we have a 2-by-2 pivot
                    if (p < n) call stdlib_zswap(n - p, a(p + 1, k), 1, a(p + 1, p), 1)
                    if (p > (k + 1)) call stdlib_zswap(p - k - 1, a(k + 1, k), 1, a(p, k + 1), lda)
                              
                    t = a(k, k)
                    a(k, k) = a(p, p)
                    a(p, p) = t
                 end if
                 ! second swap
                 kk = k + kstep - 1
                 if (kp /= kk) then
                    ! interchange rows and columns kk and kp in the trailing
                    ! submatrix a(k:n,k:n)
                    if (kp < n) call stdlib_zswap(n - kp, a(kp + 1, kk), 1, a(kp + 1, kp), 1)
                              
                    if ((kk < n) .and. (kp > (kk + 1))) call stdlib_zswap(kp - kk - 1, a(kk + 1, kk), &
                              1, a(kp, kk + 1), lda)
                    t = a(kk, kk)
                    a(kk, kk) = a(kp, kp)
                    a(kp, kp) = t
                    if (kstep == 2) then
                       t = a(k + 1, k)
                       a(k + 1, k) = a(kp, k)
                       a(kp, k) = t
                    end if
                 end if
                 ! update the trailing submatrix
                 if (kstep == 1) then
                    ! 1-by-1 pivot block d(k): column k now holds
                    ! w(k) = l(k)*d(k)
                    ! where l(k) is the k-th column of l
                    if (k < n) then
                    ! perform a rank-1 update of a(k+1:n,k+1:n) and
                    ! store l(k) in column k
                       if (cabs1(a(k, k)) >= sfmin) then
                          ! perform a rank-1 update of a(k+1:n,k+1:n) as
                          ! a := a - l(k)*d(k)*l(k)**t
                             ! = a - w(k)*(1/d(k))*w(k)**t
                          d11 = cone/a(k, k)
                          call stdlib_zsyr(uplo, n - k, -d11, a(k + 1, k), 1, a(k + 1, k + 1), lda)
                                    
                          ! store l(k) in column k
                          call stdlib_zscal(n - k, d11, a(k + 1, k), 1)
                       else
                          ! store l(k) in column k
                          d11 = a(k, k)
                          do ii = k + 1, n
                             a(ii, k) = a(ii, k)/d11
                          end do
                          ! perform a rank-1 update of a(k+1:n,k+1:n) as
                          ! a := a - l(k)*d(k)*l(k)**t
                             ! = a - w(k)*(1/d(k))*w(k)**t
                             ! = a - (w(k)/d(k))*(d(k))*(w(k)/d(k))**t
                          call stdlib_zsyr(uplo, n - k, -d11, a(k + 1, k), 1, a(k + 1, k + 1), lda)
                                    
                       end if
                    end if
                 else
                    ! 2-by-2 pivot block d(k): columns k and k+1 now hold
                    ! ( w(k) w(k+1) ) = ( l(k) l(k+1) )*d(k)
                    ! where l(k) and l(k+1) are the k-th and (k+1)-th columns
                    ! of l
                    ! perform a rank-2 update of a(k+2:n,k+2:n) as
                    ! a := a - ( l(k) l(k+1) ) * d(k) * ( l(k) l(k+1) )**t
                       ! = a - ( ( a(k)a(k+1) )*inv(d(k) ) * ( a(k)a(k+1) )**t
                    ! and store l(k) and l(k+1) in columns k and k+1
                    if (k < n - 1) then
                       d21 = a(k + 1, k)
                       d11 = a(k + 1, k + 1)/d21
                       d22 = a(k, k)/d21
                       t = cone/(d11*d22 - cone)
                       do j = k + 2, n
                          ! compute  d21 * ( w(k)w(k+1) ) * inv(d(k)) for row j
                          wk = t*(d11*a(j, k) - a(j, k + 1))
                          wkp1 = t*(d22*a(j, k + 1) - a(j, k))
                          ! perform a rank-2 update of a(k+2:n,k+2:n)
                          do i = j, n
                             a(i, j) = a(i, j) - (a(i, k)/d21)*wk - (a(i, k + 1)/d21) &
                                       *wkp1
                          end do
                          ! store l(k) and l(k+1) in cols k and k+1 for row j
                          a(j, k) = wk/d21
                          a(j, k + 1) = wkp1/d21
                       end do
                    end if
                 end if
              end if
              ! store details of the interchanges in ipiv
              if (kstep == 1) then
                 ipiv(k) = kp
              else
                 ipiv(k) = -p
                 ipiv(k + 1) = -kp
              end if
              ! increase k and return to the start of the main loop
              k = k + kstep
              go to 40
           end if
70      continue
           return
           ! end of stdlib_zsytf2_rook
     end subroutine stdlib_zsytf2_rook

     ! ZSYTRF computes the factorization of a complex symmetric matrix A
     ! using the Bunch-Kaufman diagonal pivoting method.  The form of the
     ! factorization is
     ! A = U*D*U**T  or  A = L*D*L**T
     ! where U (or L) is a product of permutation and unit upper (lower)
     ! triangular matrices, and D is symmetric and block diagonal with
     ! 1-by-1 and 2-by-2 diagonal blocks.
     ! This is the blocked version of the algorithm, calling Level 3 BLAS.

     subroutine stdlib_zsytrf(uplo, n, a, lda, ipiv, work, lwork, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, lda, lwork, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *), work(*)
        ! =====================================================================
           ! .. local scalars ..
           logical(lk) :: lquery, upper
           integer(ilp) :: iinfo, iws, j, k, kb, ldwork, lwkopt, nb, nbmin
     
           ! .. intrinsic functions ..
           intrinsic :: max
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           lquery = (lwork == -1)
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, n)) then
              info = -4
           else if (lwork < 1 .and. .not. lquery) then
              info = -7
           end if
           if (info == 0) then
              ! determine the block size
              nb = stdlib_ilaenv(1, 'stdlib_zsytrf', uplo, n, -1, -1, -1)
              lwkopt = n*nb
              work(1) = lwkopt
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zsytrf', -info)
              return
           else if (lquery) then
              return
           end if
           nbmin = 2
           ldwork = n
           if (nb > 1 .and. nb < n) then
              iws = ldwork*nb
              if (lwork < iws) then
                 nb = max(lwork/ldwork, 1)
                 nbmin = max(2, stdlib_ilaenv(2, 'stdlib_zsytrf', uplo, n, -1, -1, -1))
                           
              end if
           else
              iws = 1
           end if
           if (nb < nbmin) nb = n
           if (upper) then
              ! factorize a as u*d*u**t using the upper triangle of a
              ! k is the main loop index, decreasing from n to 1 in steps of
              ! kb, where kb is the number of columns factorized by stdlib_zlasyf;
              ! kb is either nb or nb-1, or k for the last block
              k = n
10      continue
              ! if k < 1, exit from loop
              if (k < 1) go to 40
              if (k > nb) then
                 ! factorize columns k-kb+1:k of a and use blocked code to
                 ! update columns 1:k-kb
                 call stdlib_zlasyf(uplo, k, nb, kb, a, lda, ipiv, work, n, iinfo)
              else
                 ! use unblocked code to factorize columns 1:k of a
                 call stdlib_zsytf2(uplo, k, a, lda, ipiv, iinfo)
                 kb = k
              end if
              ! set info on the first occurrence of a zero pivot
              if (info == 0 .and. iinfo > 0) info = iinfo
              ! decrease k and return to the start of the main loop
              k = k - kb
              go to 10
           else
              ! factorize a as l*d*l**t using the lower triangle of a
              ! k is the main loop index, increasing from 1 to n in steps of
              ! kb, where kb is the number of columns factorized by stdlib_zlasyf;
              ! kb is either nb or nb-1, or n-k+1 for the last block
              k = 1
20      continue
              ! if k > n, exit from loop
              if (k > n) go to 40
              if (k <= n - nb) then
                 ! factorize columns k:k+kb-1 of a and use blocked code to
                 ! update columns k+kb:n
                 call stdlib_zlasyf(uplo, n - k + 1, nb, kb, a(k, k), lda, ipiv(k), work, n, &
                           iinfo)
              else
                 ! use unblocked code to factorize columns k:n of a
                 call stdlib_zsytf2(uplo, n - k + 1, a(k, k), lda, ipiv(k), iinfo)
                 kb = n - k + 1
              end if
              ! set info on the first occurrence of a zero pivot
              if (info == 0 .and. iinfo > 0) info = iinfo + k - 1
              ! adjust ipiv
              do j = k, k + kb - 1
                 if (ipiv(j) > 0) then
                    ipiv(j) = ipiv(j) + k - 1
                 else
                    ipiv(j) = ipiv(j) - k + 1
                 end if
              end do
              ! increase k and return to the start of the main loop
              k = k + kb
              go to 20
           end if
40      continue
           work(1) = lwkopt
           return
           ! end of stdlib_zsytrf
     end subroutine stdlib_zsytrf

     ! ZSYTRF_RK computes the factorization of a complex symmetric matrix A
     ! using the bounded Bunch-Kaufman (rook) diagonal pivoting method:
     ! A = P*U*D*(U**T)*(P**T) or A = P*L*D*(L**T)*(P**T),
     ! where U (or L) is unit upper (or lower) triangular matrix,
     ! U**T (or L**T) is the transpose of U (or L), P is a permutation
     ! matrix, P**T is the transpose of P, and D is symmetric and block
     ! diagonal with 1-by-1 and 2-by-2 diagonal blocks.
     ! This is the blocked version of the algorithm, calling Level 3 BLAS.
     ! For more information see Further Details section.

     subroutine stdlib_zsytrf_rk(uplo, n, a, lda, e, ipiv, work, lwork, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, lda, lwork, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *), e(*), work(*)
        ! =====================================================================
           ! .. local scalars ..
           logical(lk) :: lquery, upper
           integer(ilp) :: i, iinfo, ip, iws, k, kb, ldwork, lwkopt, nb, nbmin
     
           ! .. intrinsic functions ..
           intrinsic :: abs, max
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           lquery = (lwork == -1)
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, n)) then
              info = -4
           else if (lwork < 1 .and. .not. lquery) then
              info = -8
           end if
           if (info == 0) then
              ! determine the block size
              nb = stdlib_ilaenv(1, 'stdlib_zsytrf_rk', uplo, n, -1, -1, -1)
              lwkopt = n*nb
              work(1) = lwkopt
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zsytrf_rk', -info)
              return
           else if (lquery) then
              return
           end if
           nbmin = 2
           ldwork = n
           if (nb > 1 .and. nb < n) then
              iws = ldwork*nb
              if (lwork < iws) then
                 nb = max(lwork/ldwork, 1)
                 nbmin = max(2, stdlib_ilaenv(2, 'stdlib_zsytrf_rk', uplo, n, -1, -1, -1))
                           
              end if
           else
              iws = 1
           end if
           if (nb < nbmin) nb = n
           if (upper) then
              ! factorize a as u*d*u**t using the upper triangle of a
              ! k is the main loop index, decreasing from n to 1 in steps of
              ! kb, where kb is the number of columns factorized by stdlib_zlasyf_rk;
              ! kb is either nb or nb-1, or k for the last block
              k = n
10      continue
              ! if k < 1, exit from loop
              if (k < 1) go to 15
              if (k > nb) then
                 ! factorize columns k-kb+1:k of a and use blocked code to
                 ! update columns 1:k-kb
                 call stdlib_zlasyf_rk(uplo, k, nb, kb, a, lda, e, ipiv, work, ldwork, iinfo)
                           
              else
                 ! use unblocked code to factorize columns 1:k of a
                 call stdlib_zsytf2_rk(uplo, k, a, lda, e, ipiv, iinfo)
                 kb = k
              end if
              ! set info on the first occurrence of a zero pivot
              if (info == 0 .and. iinfo > 0) info = iinfo
              ! no need to adjust ipiv
              ! apply permutations to the leading panel 1:k-1
              ! read ipiv from the last block factored, i.e.
              ! indices  k-kb+1:k and apply row permutations to the
              ! last k+1 colunms k+1:n after that block
              ! (we can do the simple loop over ipiv with decrement -1,
              ! since the abs value of ipiv( i ) represents the row index
              ! of the interchange with row i in both 1x1 and 2x2 pivot cases)
              if (k < n) then
                 do i = k, (k - kb + 1), -1
                    ip = abs(ipiv(i))
                    if (ip /= i) then
                       call stdlib_zswap(n - k, a(i, k + 1), lda, a(ip, k + 1), lda)
                    end if
                 end do
              end if
              ! decrease k and return to the start of the main loop
              k = k - kb
              go to 10
              ! this label is the exit from main loop over k decreasing
              ! from n to 1 in steps of kb
15      continue
           else
              ! factorize a as l*d*l**t using the lower triangle of a
              ! k is the main loop index, increasing from 1 to n in steps of
              ! kb, where kb is the number of columns factorized by stdlib_zlasyf_rk;
              ! kb is either nb or nb-1, or n-k+1 for the last block
              k = 1
20      continue
              ! if k > n, exit from loop
              if (k > n) go to 35
              if (k <= n - nb) then
                 ! factorize columns k:k+kb-1 of a and use blocked code to
                 ! update columns k+kb:n
                 call stdlib_zlasyf_rk(uplo, n - k + 1, nb, kb, a(k, k), lda, e(k), ipiv(k), &
                           work, ldwork, iinfo)
              else
                 ! use unblocked code to factorize columns k:n of a
                 call stdlib_zsytf2_rk(uplo, n - k + 1, a(k, k), lda, e(k), ipiv(k), iinfo)
                           
                 kb = n - k + 1
              end if
              ! set info on the first occurrence of a zero pivot
              if (info == 0 .and. iinfo > 0) info = iinfo + k - 1
              ! adjust ipiv
              do i = k, k + kb - 1
                 if (ipiv(i) > 0) then
                    ipiv(i) = ipiv(i) + k - 1
                 else
                    ipiv(i) = ipiv(i) - k + 1
                 end if
              end do
              ! apply permutations to the leading panel 1:k-1
              ! read ipiv from the last block factored, i.e.
              ! indices  k:k+kb-1 and apply row permutations to the
              ! first k-1 colunms 1:k-1 before that block
              ! (we can do the simple loop over ipiv with increment 1,
              ! since the abs value of ipiv( i ) represents the row index
              ! of the interchange with row i in both 1x1 and 2x2 pivot cases)
              if (k > 1) then
                 do i = k, (k + kb - 1), 1
                    ip = abs(ipiv(i))
                    if (ip /= i) then
                       call stdlib_zswap(k - 1, a(i, 1), lda, a(ip, 1), lda)
                    end if
                 end do
              end if
              ! increase k and return to the start of the main loop
              k = k + kb
              go to 20
              ! this label is the exit from main loop over k increasing
              ! from 1 to n in steps of kb
35      continue
           ! end lower
           end if
           work(1) = lwkopt
           return
           ! end of stdlib_zsytrf_rk
     end subroutine stdlib_zsytrf_rk

     ! ZSYTRF_ROOK computes the factorization of a complex symmetric matrix A
     ! using the bounded Bunch-Kaufman ("rook") diagonal pivoting method.
     ! The form of the factorization is
     ! A = U*D*U**T  or  A = L*D*L**T
     ! where U (or L) is a product of permutation and unit upper (lower)
     ! triangular matrices, and D is symmetric and block diagonal with
     ! 1-by-1 and 2-by-2 diagonal blocks.
     ! This is the blocked version of the algorithm, calling Level 3 BLAS.

     subroutine stdlib_zsytrf_rook(uplo, n, a, lda, ipiv, work, lwork, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, lda, lwork, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *), work(*)
        ! =====================================================================
           ! .. local scalars ..
           logical(lk) :: lquery, upper
           integer(ilp) :: iinfo, iws, j, k, kb, ldwork, lwkopt, nb, nbmin
     
           ! .. intrinsic functions ..
           intrinsic :: max
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           lquery = (lwork == -1)
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, n)) then
              info = -4
           else if (lwork < 1 .and. .not. lquery) then
              info = -7
           end if
           if (info == 0) then
              ! determine the block size
              nb = stdlib_ilaenv(1, 'stdlib_zsytrf_rook', uplo, n, -1, -1, -1)
              lwkopt = max(1, n*nb)
              work(1) = lwkopt
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zsytrf_rook', -info)
              return
           else if (lquery) then
              return
           end if
           nbmin = 2
           ldwork = n
           if (nb > 1 .and. nb < n) then
              iws = ldwork*nb
              if (lwork < iws) then
                 nb = max(lwork/ldwork, 1)
                 nbmin = max(2, stdlib_ilaenv(2, 'stdlib_zsytrf_rook', uplo, n, -1, -1, -1))
                           
              end if
           else
              iws = 1
           end if
           if (nb < nbmin) nb = n
           if (upper) then
              ! factorize a as u*d*u**t using the upper triangle of a
              ! k is the main loop index, decreasing from n to 1 in steps of
              ! kb, where kb is the number of columns factorized by stdlib_zlasyf_rook;
              ! kb is either nb or nb-1, or k for the last block
              k = n
10      continue
              ! if k < 1, exit from loop
              if (k < 1) go to 40
              if (k > nb) then
                 ! factorize columns k-kb+1:k of a and use blocked code to
                 ! update columns 1:k-kb
                 call stdlib_zlasyf_rook(uplo, k, nb, kb, a, lda, ipiv, work, ldwork, iinfo)
                           
              else
                 ! use unblocked code to factorize columns 1:k of a
                 call stdlib_zsytf2_rook(uplo, k, a, lda, ipiv, iinfo)
                 kb = k
              end if
              ! set info on the first occurrence of a zero pivot
              if (info == 0 .and. iinfo > 0) info = iinfo
              ! no need to adjust ipiv
              ! decrease k and return to the start of the main loop
              k = k - kb
              go to 10
           else
              ! factorize a as l*d*l**t using the lower triangle of a
              ! k is the main loop index, increasing from 1 to n in steps of
              ! kb, where kb is the number of columns factorized by stdlib_zlasyf_rook;
              ! kb is either nb or nb-1, or n-k+1 for the last block
              k = 1
20      continue
              ! if k > n, exit from loop
              if (k > n) go to 40
              if (k <= n - nb) then
                 ! factorize columns k:k+kb-1 of a and use blocked code to
                 ! update columns k+kb:n
                 call stdlib_zlasyf_rook(uplo, n - k + 1, nb, kb, a(k, k), lda, ipiv(k), work, &
                           ldwork, iinfo)
              else
                 ! use unblocked code to factorize columns k:n of a
                 call stdlib_zsytf2_rook(uplo, n - k + 1, a(k, k), lda, ipiv(k), iinfo)
                 kb = n - k + 1
              end if
              ! set info on the first occurrence of a zero pivot
              if (info == 0 .and. iinfo > 0) info = iinfo + k - 1
              ! adjust ipiv
              do j = k, k + kb - 1
                 if (ipiv(j) > 0) then
                    ipiv(j) = ipiv(j) + k - 1
                 else
                    ipiv(j) = ipiv(j) - k + 1
                 end if
              end do
              ! increase k and return to the start of the main loop
              k = k + kb
              go to 20
           end if
40      continue
           work(1) = lwkopt
           return
           ! end of stdlib_zsytrf_rook
     end subroutine stdlib_zsytrf_rook

     ! ZSYTRI computes the inverse of a complex symmetric indefinite matrix
     ! A using the factorization A = U*D*U**T or A = L*D*L**T computed by
     ! ZSYTRF.

     subroutine stdlib_zsytri(uplo, n, a, lda, ipiv, work, info)
        ! -- lapack computational routine --
        ! -- lapack is a software package provided by univ. of tennessee,    --
        ! -- univ. of california berkeley, univ. of colorado denver and nag ltd..--
           ! .. scalar arguments ..
           character :: uplo
           integer(ilp) :: info, lda, n
           ! .. array arguments ..
           integer(ilp) :: ipiv(*)
           complex(dp) :: a(lda, *), work(*)
        ! =====================================================================
           
           ! .. local scalars ..
           logical(lk) :: upper
           integer(ilp) :: k, kp, kstep
           complex(dp) :: ak, akkp1, akp1, d, t, temp
     
           ! .. intrinsic functions ..
           intrinsic :: abs, max
           ! .. executable statements ..
           ! test the input parameters.
           info = 0
           upper = stdlib_lsame(uplo, 'u')
           if (.not. upper .and. .not. stdlib_lsame(uplo, 'l')) then
              info = -1
           else if (n < 0) then
              info = -2
           else if (lda < max(1, n)) then
              info = -4
           end if
           if (info /= 0) then
              call stdlib_xerbla('stdlib_zsytri', -info)
              return
           end if
           ! quick return if possible
           if (n == 0) return
           ! check that the diagonal matrix d is nonsingular.
           if (upper) then
              ! upper triangular storage: examine d from bottom to top
              do info = n, 1, -1
                 if (ipiv(info) > 0 .and. a(info, info) == czero) return
              end do
           else
              ! lower triangular storage: examine d from top to bottom.
              do info = 1, n
                 if (ipiv(info) > 0 .and. a(info, info) == czero) return
              end do
           end if
           info = 0
           if (upper) then
              ! compute inv(a) from the factorization a = u*d*u**t.
              ! k is the main loop index, increasing from 1 to n in steps of
              ! 1 or 2, depending on the size of the diagonal blocks.
              k = 1
30      continue
              ! if k > n, exit from loop.
              if (k > n) go to 40
              if (ipiv(k) > 0) then
                 ! 1 x 1 diagonal block
                 ! invert the diagonal block.
                 a(k, k) = cone/a(k, k)
                 ! compute column k of the inverse.
                 if (k > 1) then
                    call stdlib_zcopy(k - 1, a(1, k), 1, work, 1)
                    call stdlib_zsymv(uplo, k - 1, -cone, a, lda, work, 1, czero, a(1, k), 1)
                              
                    a(k, k) = a(k, k) - stdlib_zdotu(k - 1, work, 1, a(1, k), 1)
                 end if
                 kstep = 1
              else
                 ! 2 x 2 diagonal block
                 ! invert the diagonal block.
                 t = a(k, k + 1)
                 ak = a(k, k)/t
                 akp1 = a(k + 1, k + 1)/t
                 akkp1 = a(k, k + 1)/t
                 d = t*(ak*akp1 - cone)
                 a(k, k) = akp1/d
                 a(k + 1, k + 1) = ak/d
                 a(k, k + 1) = -akkp1/d
                 ! compute columns k and k+1 of the inverse.
                 if (k > 1) then
                    call stdlib_zcopy(k - 1, a(1, k), 1, work, 1)
                    call stdlib_zsymv(uplo, k - 1, -cone, a, lda, work, 1, czero, a(1, k), 1)
                              
                    a(k, k) = a(k, k) - stdlib_zdotu(k - 1, work, 1, a(1, k), 1)
                    a(k, k + 1) = a(k, k + 1) - stdlib_zdotu(k - 1, a(1, k), 1, a(1, k + 1), 1)
                              
                    call stdlib_zcopy(k - 1, a(1, k + 1), 1, work, 1)
                    call stdlib_zsymv(uplo, k - 1, -cone, a, lda, work, 1, czero, a(1, k + 1), 1)
                              
                    a(k + 1, k + 1) = a(k + 1, k + 1) - stdlib_zdotu(k - 1, work, 1, a(1, k + 1), 1)
                              
                 end if
                 kstep = 2
              end if
              kp = abs(ipiv(k))
              if (kp /= k) then
                 ! interchange rows and columns k and kp in the leading
                 ! submatrix a(1:k+1,1:k+1)
                 call stdlib_zswap(kp - 1, a(1, k), 1, a(1, kp), 1)
                 call stdlib_zswap(k - kp - 1, a(kp + 1, k), 1, a(kp, kp + 1), lda)
                 temp = a(k, k)
                 a(k, k) = a(kp, kp)
                 a(kp, kp) = temp
                 if (kstep == 2) then
                    temp = a(k, k + 1)
                    a(k, k + 1) = a(kp, k + 1)
                    a(kp, k + 1) = temp
                 end if
              end if
              k = k + kstep
              go to 30
40      continue
           else
              ! compute inv(a) from the factorization a = l*d*l**t.
              ! k is the main loop index, increasing from 1 to n in steps of
              ! 1 or 2, depending on the size of the diagonal blocks.
              k = n
50      continue
              ! if k < 1, exit from loop.
              if (k < 1) go to 60
              if (ipiv(k) > 0) then
                 ! 1 x 1 diagonal block
                 ! invert the diagonal block.
                 a(k, k) = cone/a(k, k)
                 ! compute column k of the inverse.
                 if (k < n) then
                    call stdlib_zcopy(n - k, a(k + 1, k), 1, work, 1)
                    call stdlib_zsymv(uplo, n - k, -cone, a(k + 1, k + 1), lda, work, 1, czero, a(k + &
                              1, k), 1)
                    a(k, k) = a(k, k) - stdlib_zdotu(n - k, work, 1, a(k + 1, k), 1)
                 end if
                 kstep = 1
              else
                 ! 2 x 2 diagonal block
                 ! invert the diagonal block.
                 t = a(k, k - 1)
                 ak = a(k - 1, k - 1)/t
                 akp1 = a(k, k)/t
                 akkp1 = a(k, k - 1)/t
      