**fnc 0.15** 2023-04-20 [[history][0.15a] / [diff][0.15b]]

- update in-tree sqlite to 3.42.0 to fix unused-but-set clang 14.03 build error
- latest upstream libfossil with fixes for clang 14.03 build errors

**fnc 0.14** 2023-04-18 [[history][0.14a] / [diff][0.14b]]

- show msg rather than error if timeline C keymap is used outside a work tree
- check path is in the requested version if T keymap is used with `fnc tl path`
- display the work tree path in checkout diff headlines
- fix diff display bug by resetting diff mode after timeline C keymap is used
- list only user-defined settings with `fnc config`, use --ls flag to show all
- fix unexpected behaviour when switching between diff and timeline views  
  after requesting a diff by tagging arbitrary commits with the `space` keymap
- disallow tagging different wiki pages to request a diff
- warn user rather than silently ignore attempts to tag non-diffable artifacts
- fix bug if timeline C keymap is used when a commit is already tagged
- change diff flags that modify diff views to resolve conflicts with libfossil
- catch trailing `\r` in CRLF files when finding scope for hunk headers
- show unchanged work tree report for all stash abort cases
- fix bug where the stash 'm' option was not available for the first hunk
- display "[current]" label with `fnc timeline -c <symbol>`
- disable landlock support for the `fnc stash` command to fix reparenting bug
- zap dead code
- latest upstream libfossil: [libf:9a8269d737]

**fnc 0.13** 2022-11-26 [[history][0.13a] / [diff][0.13b]]

- improve reporting of invalid diff command arguments (reported by Dan Shearer)
- accept libfossil global `-V|--verbose` option for all commands
- plug memleak when using the `p` keymap in blame view
- fix `fnc blame -r` and make it behave like `fossil blame -o` for familiarity
- improve `fnc timeline <path>` lookup of repository paths not in the work tree
- make tree navigation more intuitive when opening repository subtrees
- implement `[` & `]` keymaps to navigate to the previous/next hunk in the diff
- allow `fnc stash get` to take an optional `<stash_id>` argument
- document fnc(1) missing `W` diff view keymap to ignore end-of-line whitespace
- document optional `<stash_id>` argument of `fnc stash pop [stash_id]`
- fix typo producing gcc 12.1.0 compiler warning (comparison always true)
- improve scope matching for function prototype in diff hunk headers
- ifdef out `A_BOLD` attr on OpenBSD to fix diff view line highlight in xterm(1)
- display checkout hash and build date with `fnc -v` like fossil(1)
- miscellaneous diff API implementation improvements
- protect against out-of-bound reads now line_type array is optionally populated
- add `-b|--brief` option to `fnc diff` and `b` diff view keymap
- general fnc(1) manual page markup, syntax, and documentation improvements
- rename FNC_DIFF_COLOUR_CHUNK to FNC_DIFF_COLOUR_HUNK to match internal naming  
  (*breaking change: existing FNC_DIFF_COLOUR_CHUNK will be silently ignored*)
- ensure diff parser does not internally mark modified files as renamed
- improve const correctness with fsl_uuid_cstr where possible
- fix contrived empty diff case when work tree root is passed to `fnc diff`
- improve path handling of files on disk vs. files in the repository database
- produce less verbose output on error by not presumptuously dumping help
- zap unnecessary allocation and minor refactor in the path parser
- don't display empty diff in contrived modified checkout edge case
- catch missed fsl_content_get() fsl_unlink_file() & fsl_mprintf() return codes
- miscellaneous style(9) fixes
- fix missed format specifier argument in blame path error message
- ensure `fnc stash (get|pop)` doesn't report updated files as renames
- use "(checkout)" label in diff header when diffing or stashing the work tree
- internal stash refactor in preparation to move code into libfossil
- catched missed SIGINT and SIGTERM signals
- use CHAR_BIT for bitstring manipulation macros
- fix assumption of invalid command argument as a path to pass to `fnc timeline`
- merge upstream libfossil with various changes

**fnc 0.12** 2022-05-09 [[history][0.12a] / [diff][0.12b]]

- replace \\s regexp with portable [[:space:]] character class (patch by Ashish)
- fix blame->diff child split view regression from 0.9 introduced in [d05828fbb]

**fnc 0.11** 2022-05-08 [[history][0.11a] / [diff][0.11b]]

- handle diff of non-versioned files outside the work tree (reported by Dan)
- replace getpagesize() with portable sysconf(_SC_PAGESIZE) (patch by mgagnon)
- improve robustness by guarding against piped input abuse (reported by Dan)
- improve documentation regarding UTF-8 character encoding and fonts
- implement horizontal scroll of the log message summary line in timeline view
- fix out-of-bounds UB on 32-bit builds (reported by mgagnon)
- convert unified diff renderer to the improved line_type interface
- fix format specifier bug evinced on 32-bit builds (reported by mgagnon)
- improve unicode handling in terminals w/o UTF-8 support (reported by mgagnon)
- handle window resizing of horizontal and vertical splits (reported by mgagnon)
- improve regexp used to identify commit meta lines
- implement `fnc stash` to interactively select hunks to stash (cf. git add -p)
- fix diff regression introduced with `fnc stash` implementation [2870235eef78]
- simplify handling of diff driver error codes (i.e., binary, type, range)
- improve curses WINDOW reporter interface
- dynamically place help dialog title depending on viewport width
- improve return code RC macro to detect empty varargs token
- fix signed/unsigned comparison introduced in [41dfeb9ebb3d]
- display hunk index in `fnc stash` input prompt
- documentation improvements in README
- update in-tree SQLite lib to 3.38.5 with multiple bug fixes
- add `apply` alias for `fnc stash get` to facilitate Fossiler muscle memory
- simplify error, and tailor usage, reporting when handling invalid input
- remove redundant fcli_has_unused_args() call in main()

**fnc 0.10** 2022-03-24 [[history][0.10a] / [diff][0.10b]]

- fix gcc 9.3 compiler warnings (i.e., unused variable) (reported by stephan)
- restrict `C` key map for diffing local changes to check-in artifacts
- ensure timeline --branch option ignores cancelled branches (reported by sean)
- fix landlock initialisation of handled fs access perms (patch by Ashish)
- tighten landlock ruleset depending on which fnc command is called
- improve branch view rendering of last modified date and hash id
- colour branch header and make (in)active behaviour consistent with other views
- improve branch parsing of imported repositories (reported by Dan)
- fix OB1 error when branch entry length exceeds COLUMNS
- add timezone path to landlock ruleset (reported by Ashish)
- implement `P` key map to write a patch file of the currently viewed diff
- fix invalid write in landlock initialisation code (reported by Ashish)
- ensure unveil(2) initialisation handles `-R|--repo` invocations
- add create file to landlock ruleset for permitted dirs (reported by Ashish)
- make mandir if needed in makefile install target (reported by Dan)
- document `backspace` key map to cancel tl search/traversal (reported by Dan)
- return to blocking on user input when tl search is aborted (reported by Dan)
- implement persistent diff options for global and per-repo defaults
- implement `--whitespace-eol` and `W` key map to only ignore eol whitespace
- implement horizontal scroll in the in-app help
- add `Q` key map to in-app help to directly quit fnc
- implement blame navigation from diff view with `C-{j,k}` key maps

**fnc 0.9** 2022-03-04 [[history][0.9a] / [diff][0.9b]]

- Add blame command `--line` option to open annotated file at the specified line
- merge upstream libfossil changes that eliminate gcc compiler warnings
- adopt libfossil diff v1 implementation into fnc tree to replace v2 API
- refactor diff implementation to comport with code style
- fix `--whitespace` option (`w` keymap) diffv2 regression from 0.7 [105123b40e]
- implement diff `--line-numbers` opt (`L` keymap) to display file line numbers
- implement display of enclosing function in diff chunk headers (enabled by  
  default like CVS and Git, disabled with `--no-prototype` or `p` keymap); works  
  with all C-like languages, but not Lisps or markup languages
- upstream libfossil fix for segv bug when fsl_int_d and fsl_id_t differ in size
- fix incorrect malloc producing undefined behaviour on 32-bit platforms
- add unveil (c)reate permission to the checkout dir to fix some diff commands
- change conflicting diff and blame view key maps
- implement taggable timeline nodes to interactively diff arbitrary commits
- implement `C` timeline keymap to diff selected commit against local changes
- clean code of OS-dependent ifdefs by consolidating them in called functions
- add support for landlock Linux security module in Linux builds
- significant diff driver refactoring for finer granularity in view manipulation
- implement `--sbs` (`S` keymap) to display side-by-side formatted diffs
- add FNC_COLOUR_DIFF_SBS_EDIT option to set colour of edited lines in SBS diff 
- plug small memory leak when interactively changing diff format

**fnc 0.8** 2022-01-10 [[history][0.8a] / [diff][0.8b]]

- fix vertical split view init regression from 0.7 when terminal < 120 cols wide 
- fix DB lock when opening horizontal split that signals the timeline thread

**fnc 0.7** 2022-01-09 [[history][0.7a] / [diff][0.7b]]

- factor out common make(1) and gmake build bits
- make build depend on make file
- make all commands compatible with `-R|--repository` (i.e., no checkout needed)
- implement Vim-like smartcase for commands that filter repository results
- improve timeline arg parsing for more informative output upon invalid input
- plug small memory leak when the timeline command fails to initialise a view
- fix database locking issue when opening multiple tree views from the timeline
- add pledge(2) and unveil(2) support on OpenBSD builds
- add (s)ort keymap (i.e., `--sort` CLI option counterpart) to the branch view
- add (d)ate keymap to toggle display of last modified timestamp in tree view
- allow blame of empty files rather than erroring out
- fix NULL dereference UB when the ".." parent dir is selected in tree view
- merge upstream fix when annotating files with shallow history
- add support for configurable horizontal split view mode (timeline -> diff)
- keep the last/first line in view when paging down/up to stay oriented
- expand horizontal splitscreen support to include tree -> blame views
- improve handling of cached commit builder statements
- plug small memleak of file labels when traversing commits from the diff view
- display message rather than error out when binary files are blamed
- expand horizontal split coverage to include timeline -> tree views
- implement '#' keymap to display line numbers in blame view
- implement (L)ine keymap to navigate directly to the entered line in blame view
- convert diff code to use upstream v2 API
- keep lines on screen in view when using keymaps that modify diff content
- reset diff search state when traversing commits from the diff view
- apply upstream diff fix to render consecutive edited lines as one block
- implement '#' keymap to display line numbers in diff view
- improve `C-f/C-b` paging in the in-app help window
- add user-defined option to configure search highlight colours
- implement navigate to (L)ine keymap in diff view
- enhance timeline and diff view headers
- implement user-defined option to configure line selection cursor in diff view
- implement Vim-like `C-e/C-y` keymaps to scroll down/up one line in diff view
- implement horizontal scrolling in diff and blame views
- improve view request handling and optimise new view initialisation
- implement `C-n/C-p` keymap to navigate to the next/previous file in the diff
- implement (F)ile keymap to navigate directly to a file in the diff
- apply upstream diff v2 fix for rendering untouched lines as changed
- implement Vim-like `C-d/C-u` keymaps to scroll the view down/up half a page
- enhance search behaviour in all views

**fnc 0.6** 2021-11-22 [[history][0.6a] / [diff][0.6b]]

- implement support for user-defined colours in tl, diff, tree and blame views
- make branch view accessible from all other views
- optimise colour scheme initialisation
- implement new 'fnc config' interface to configure per-project settings
- improve build by making make file make(1) compatible
- rename old make file to GNUmakefile to keep gmake support
- more robust error handling of invalid user input to new config command
- fix tree symlink colour regular expression so symlink entries are colourised
- improve colourised header highlighting when in splitscreen mode
- fix display of colourised headers in tmux
- more robust handling of cached statements when switching views
- fix branch-to-tree-to-timeline segv bug when file is missing
- improve const correctness of fcli struct declarations
- enhance diff command with support for arbitrary repository blob artifacts
- quiet error reporting in non-debug builds
- fix commit builder bug that may omit timeline commits when switching views
- improved branch view resource deallocation
- implement new timeline command --filter option and key binding
- enhance timeline --type option with support for tag control artifacts
- general documentation improvements
- assorted updates from upstream libfossil including compiler warning fix
- expand support for user-defined colours to include the branch view

**fnc 0.5** 2021-11-03 [[history][0.5a] / [diff][0.5b]]

- simplify the build system to make-only and remove autosetup (patch from sdk)
- remove invalid fsl_errno_to_rc() call and redundant alloc error check
- reduce noise on app exit by removing redundant error output
- relocate fnc_strlcpy() and fnc_strlcat() routines to the library

**fnc 0.4** 2021-10-31 [[history][0.4a] / [diff][0.4b]]

- resolve database bug in the commit builder logic
- prune dead code leftover from the initial single-threaded blame implementation
- improve error handling of commands that return no records
- update in-app help with blame key bindings
- expand tree command's ability to display trees of versions with missing files
- improve tree command error handling of non-checkin artifacts
- make tree command compatible with the `-R <repository>` option
- add profiling (`--profile`) option to the build system
- notify user of invalid blame _P_ key binding selections with ephemeral message
- add coloured output and associated key binding/options to the timeline view
- ensure the full diff is displayed for non-standard initial check-ins
- initialise variables to squelch gcc-9.3 compiler warnings
- add command line aliases to all currently available commands
- add time-based annotation option to the blame command
- fix colour conflicts between certain views
- enhance diff interface with optional path arg to filter diffs between commits
- improve diff view by displaying full context when diffing consecutive commits
- make diff index parsing more robust when handling removed/missing files
- ensure diff honours the repository's `allow-symlinks` setting
- simplify help output when `-h|--help` is passed to command aliases
- invert diff metadata when `-i|--invert` or the _i_ key binding is used
- fix diff bug when the first commit is opened from the timeline view
- enhance diff command to enable diff of arbitrary file blobs
- optimise parsing of artifacts to determine which diff routine to call
- implement `fnc branch` which displays a navigable list of repository branches
- expand available sort options to the branch command
- simplify usage output on error or `-h|--help` with usage callback
- general man page and documentation improvements
- fix incorrect configure `--prefix` install path in the docs (reported by sdk)

**fnc 0.3** 2021-10-17 [[history][0.3a] / [diff][0.3b]]

- add in-app help with H|?|F1 key binding
- improvements to the build system
- decompose build_commits() to make reusable commit_builder() method
- dynamically size header so metadata is not truncated in timeline view
- fix highlight of coloured search results in tmux with A_REVERSE attribute
- correct install path of man pages with 'make install'
- implement 'fnc tree' command to navigate repository tree
- deduplicate code with utility functions fnc_home() and strtonumcheck()
- implement 'fnc path' convenience form of 'fnc timeline path'
- improve error reporting and cleaner code with rc wrapper
- make -R repo option available to 'fnc timeline' 
- make -R repo option compatible with 'fnc timeline path' invocation
- implement 'fnc blame' command with the new libfossil annotate API
- enable accessing the blame interface from the tree view
- fix handling of artifacts with no comment string
- substantial UX and performance improvements by making 'fnc blame' threaded
- fix bug in 'fnc blame --limit|-n' calls when lines were not annotated
- enable handling of master branches not named 'trunk' in 'fnc blame'
- enable accessing the tree interface from the timeline with new 't' key binding
- add '-C|--no-colour' and 'c' key binding to 'fnc blame'
- enhance and standardise parsing of path arguments for all commands

**fnc 0.2** 2021-09-04 [[history][0.2a] / [diff][0.2b]]

- fix iconv lib linking in macOS builds
- use pkg-config for detecting ncurses libs
- prune dead auto.def code
- bypass pkg-config in configure script on macOS systems
- major overhaul to use amalgamation build
- add key bindings to jump to start and end of view
- man page and documentation updates
- improve diff of current checkout to always show local changes on disk
- fix non-standard use of clang extension
- update autosetup to version 0.7.0
- add make (un)install rules
- replace strsep() with self-rolled implementation to build on CentOS 6.5
- fix bug where local changes only showed when diffing against current checkout
- enhance timeline --commit|-c option to accept symbolic check-in names
- add man page installation to make install target
- plug small memory leak in cmd_diff() routine
- fix screen rendering bug due to late deallocation of resources
- improve multibyte to wide character conversion error handling/reporting
- fix bug involving renamed files in diff view

**fnc 0.1** 2021-08-28 [[history][0.1a] / [diff][0.1b]]

- initial commit of infrastructure for the timeline command
- add branch names and tags to search criteria
- enhance parsing of malformed RFC822 email addresses in commit usernames
- display wiki page content of initial wiki commits
- make display of technote and ticket commits more consistent with fossil(1) ui
- fix bug where diff algorithm choked on binary files
- add coloured output to diff view
- replace BSD-specific getprogname() calls with libf API
- enhance diff view to display more informative control artifact commits
- add Linux support so we now build and run on OpenBSD, macOS, and Linux
- wrap commit comments to the current view width
- implement cmd_diff() to provide the 'fnc diff' interface
- tailor help/usage output to the specified command
- fix invalid memory read in diff routine
- add support for repository fingerprint version 1
- fix line wrap bug that truncated lines in fullscreen mode

[0.15a]: https://fnc.bsdbox.org/timeline?p=0.15&bt=0.14
[0.15b]: https://fnc.bsdbox.org/vdiff?from=0.14&to=0.15
[0.14a]: https://fnc.bsdbox.org/timeline?p=0.14&bt=0.13
[0.14b]: https://fnc.bsdbox.org/vdiff?from=0.13&to=0.14
[0.13a]: https://fnc.bsdbox.org/timeline?p=0.13&bt=0.12
[0.13b]: https://fnc.bsdbox.org/vdiff?from=0.12&to=0.13
[0.12a]: https://fnc.bsdbox.org/timeline?p=0.12&bt=0.11
[0.12b]: https://fnc.bsdbox.org/vdiff?from=0.11&to=0.12
[0.11a]: https://fnc.bsdbox.org/timeline?p=0.11&bt=0.10
[0.11b]: https://fnc.bsdbox.org/vdiff?from=0.10&to=0.11
[0.10a]: https://fnc.bsdbox.org/timeline?p=0.10&bt=0.9
[0.10b]: https://fnc.bsdbox.org/vdiff?from=0.9&to=0.10
[0.9a]: https://fnc.bsdbox.org/timeline?p=0.9&bt=0.8
[0.9b]: https://fnc.bsdbox.org/vdiff?from=0.8&to=0.9
[0.8a]: https://fnc.bsdbox.org/timeline?p=0.8&bt=0.7
[0.8b]: https://fnc.bsdbox.org/vdiff?from=0.7&to=0.8
[0.7a]: https://fnc.bsdbox.org/timeline?p=0.7&bt=0.6
[0.7b]: https://fnc.bsdbox.org/vdiff?from=0.6&to=0.7
[0.6a]: https://fnc.bsdbox.org/timeline?p=0.6&bt=0.5
[0.6b]: https://fnc.bsdbox.org/vdiff?from=0.5&to=0.6
[0.5a]: https://fnc.bsdbox.org/timeline?p=0.5&bt=0.4
[0.5b]: https://fnc.bsdbox.org/vdiff?from=0.4&to=0.5
[0.4a]: https://fnc.bsdbox.org/timeline?p=0.4&bt=0.3
[0.4b]: https://fnc.bsdbox.org/vdiff?from=0.3&to=0.4
[0.3a]: https://fnc.bsdbox.org/timeline?p=0.3&bt=0.2
[0.3b]: https://fnc.bsdbox.org/vdiff?from=689182448e&to=0.3
[0.2a]: https://fnc.bsdbox.org/timeline?p=0.2&bt=96e142ed8e
[0.2b]: https://fnc.bsdbox.org/vdiff?from=96e142ed8e&to=689182448e
[0.1a]: https://fnc.bsdbox.org/timeline?p=689182448e&bt=6eaea2465f
[0.1b]: https://fnc.bsdbox.org/vdiff?from=6eaea2465f&to=96e142ed8e
