# README

# fnc: an interactive text-based user interface for [Fossil]

`fnc` uses [ncurses] and [libfossil] to create a [`fossil ui`][fui] experience
in the terminal, and parse local changes at the hunk level to prepare atomic
commits.

Tested and confirmed to run on the following amd64 systems (additional
platforms noted inline):

1. OpenBSD 6.8-, 6.9-, 7.0-, 7.1-, and 7.2-{current,release}
2. macOS Catalina 10.15.7, Big Sur 11.5.2, and Ventura 13.0.1
3. Linux Mint 20.2 (32- and 64-bit ARM)
4. Ubuntu 18.04, 21.04, 21.10, and 22.04 running Linux 5.1{1,3} (32-bit ARM)
5. Debian GNU/Linux 8, 9, and 10
6. CentOS 6.5 (32-bit)

Alpha development notwithstanding, the `timeline`, `diff`, `tree`, `blame`,
`branch`, and `stash` commands are relatively stable; however, there is no
commitment to refrain from breaking changes.

# Install

* **OpenBSD**
  - `doas pkg_add fnc`
* **macOS**
  - `sudo port install fnc`
* **FreeBSD**
  - <u>package</u>: `pkg install fnc`
  - <u>port</u>: `cd /usr/ports/devel/fnc/ && make install clean`
* **NixOS**
  - `nix-env -iA nixos.fnc`
* **Alpine Linux**
  - `apk add fnc`  
  n.b. Ensure _testing_ repository is enabled (see <https://wiki.alpinelinux.org/wiki/Repositories#Testing>)

Check [repology] to find if a package is provided for your operating system.
If no package exists, [download] and install the binary on your path.

# Build

1. clone the repository
  - `fossil clone https://fnc.bsdbox.org`
2. move into the repository checkout
  - `cd fnc`
3. build fnc
  - `make`
4. install the `fnc` binary (*requires privileges*)
  - `doas make install`
5. move into an open Fossil checkout, and run it:
  - `cd ~/museum/repo && fossil open ../repo.fossil && fnc`

This will install the `fnc` executable and man page into `/usr/local/bin` and
`/usr/local/share/man/man1`, respectively. Alternatively, cryptographically
signed tarballs of the source code and binaries for some of the abovementioned
platforms are available to [download].

# Doc

Commands available in **fnc**:

1. [**stash**](https://fnc.bsdbox.org/uv/doc/fnc.1.html#stash)
  - interactively select hunks to stash from the diff of local changes on disk
2. [**timeline**](https://fnc.bsdbox.org/uv/doc/fnc.1.html#timeline)
  - hyperlinked chronological commit history of the repository
3. [**diff**](https://fnc.bsdbox.org/uv/doc/fnc.1.html#diff)
  - diff of all changes between commits or blobs
4. [**blame**](https://fnc.bsdbox.org/uv/doc/fnc.1.html#blame)
  - annotated file displaying commit attribution history of each line
5. [**tree**](https://fnc.bsdbox.org/uv/doc/fnc.1.html#tree)
  - navigable file hierarchy of the repository tree
6. [**branch**](https://fnc.bsdbox.org/uv/doc/fnc.1.html#branch)
  - hyperlinked list of all public and private branches
7. [**config**](https://fnc.bsdbox.org/uv/doc/fnc.1.html#config)
  - configure or view fnc settings

See `fnc --help` for a quick reference, and the [fnc(1)] manual page for more
comprehensive documentation. Runtime help can also be accessed with the `?`,
`F1`, or `H` key binding. The following video briefly demonstrates some of the
key bindings in use.

[![fnc demo][demoimg]][demo]

# Why

`fnc` is heavily inspired by [`tog`], which I missed when I left [Got] behind
and started using Fossil. The objective is to provide an alternative to
`fossil ui` without leaving the terminal.

# Problems & Patches

Please submit bug reports via [email], the [forum], or by creating a new
[ticket]. As a rule, all reports should include a bug reproduction recipe; that
is, either (1) the series of steps beginning with `fossil init` to create a new
repository through to the `fnc` command that triggers the unexpected behaviour;
or, if possible, (2) a shell script that contains all necessary ingredients to
reproduce the problem.

Patches are thoughtfully considered and can be sent to the [mailing list].
While `diff -up` patches (or `fnc` diffs saved with the [`P` keymap]) are
preferred, `fossil patch create` and `fossil diff` patches are also welcomed.
Please ensure code conforms to the C99 standard, and complies with OpenBSD's
KNF [style(9)]. Any patch containing user-visible code addition, modification,
or deletion (i.e., code that impacts user interfaces) should concomitantly
include updating documentation affected by the change.

# Screenshots

![stash](https://fnc.bsdbox.org/uv/img/fnc-stash.png "fnc stash")
![stash more](https://fnc.bsdbox.org/uv/img/fnc-stash-more.png "stash more")
![stash help](https://fnc.bsdbox.org/uv/img/fnc-stash-help.png "stash help")
![diff vsplit](https://fnc.bsdbox.org/uv/img/fnc-diff-vsplit.png "diff vertical split")
![diff hsplit renamed](https://fnc.bsdbox.org/uv/img/fnc-diff-hsplit-renamed.png "diff horizontal split file renamed")
![diff vsplit added](https://fnc.bsdbox.org/uv/img/fnc-diff-vsplit-added.png "diff vertical split file added")
![diff vsplit removed](https://fnc.bsdbox.org/uv/img/fnc-diff-vsplit-removed.png "diff vertical split file removed")
![blame vsplit](https://fnc.bsdbox.org/uv/img/fnc-blame-vsplit.png "blame vertical split")
![tree vsplit](https://fnc.bsdbox.org/uv/img/fnc-tree-vsplit.png "tree vertical split")
![branch hsplit](https://fnc.bsdbox.org/uv/img/fnc-branch-hsplit.png "branch horizontal split")
![runtime help](https://fnc.bsdbox.org/uv/img/fnc-runtime-help.png "fnc runtime help")
![timeline help](https://fnc.bsdbox.org/uv/img/fnc-timeline-help.png "fnc timeline help")

# Trivia

**fnc** [fɪŋk]  
*noun* (n.)  
1. an interactive ncurses browser for [Fossil] repositories  
*verb* (v.)  
2. to inform  
etymology  
From the German word *Fink*, meaning "finch", a type of bird.

[demoimg]:	https://fnc.bsdbox.org/uv/img/fnc-timeline-fullscreen.png
[demo]:		https://itac.bsdbox.org/fnc-demo.mp4
[download]:	https://fnc.bsdbox.org/uv/download.html
[email]:	mailto:fnc@bsdbox.org
[fnc(1)]:	https://fnc.bsdbox.org/uv/doc/fnc.1.html
[forum]:	https://fnc.bsdbox.org/forum
[Fossil]:	https://fossil-scm.org
[fui]:		https://fossil-scm.org/home/help?cmd=ui
[Got]:		https://gameoftrees.org
[libfossil]:	https://fossil.wanderinghorse.net/r/libfossil
[mailing list]:	https://itac.bsdbox.org/listinfo/fnc
[ncurses]:	https://invisible-island.net/ncurses/ncurses.html
[repology]:	https://repology.org/project/fnc/versions
[style(9)]:	https://man.openbsd.org/style.9
[ticket]:	https://fnc.bsdbox.org/ticket
[`tog`]:	https://gameoftrees.org/tog.1.html
[`P` keymap]:	https://fnc.bsdbox.org/uv/doc/fnc.1.html#P~3
