/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.jdbc.AbstractJdbcWrapper;
import com.google.cloud.spanner.jdbc.JdbcPreparedStatement;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class JdbcParameterMetaData
extends AbstractJdbcWrapper
implements ParameterMetaData {
    private final JdbcPreparedStatement statement;

    JdbcParameterMetaData(JdbcPreparedStatement statement) throws SQLException {
        this.statement = statement;
        statement.getParameters().fetchMetaData(statement.getConnection());
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public int getParameterCount() {
        AbstractStatementParser.ParametersInfo info = this.statement.getParametersInfo();
        return info.numberOfParameters;
    }

    @Override
    public int isNullable(int param) {
        Integer nullable = this.statement.getParameters().getNullable(param);
        return nullable == null ? 2 : nullable;
    }

    @Override
    public boolean isSigned(int param) {
        int type = this.getParameterType(param);
        return type == 8 || type == 6 || type == -5 || type == 4 || type == 5 || type == -6 || type == 3 || type == 2;
    }

    @Override
    public int getPrecision(int param) {
        Integer length = this.statement.getParameters().getScaleOrLength(param);
        return length == null ? 0 : length;
    }

    @Override
    public int getScale(int param) {
        return 0;
    }

    @Override
    public int getParameterType(int param) {
        Integer type = this.statement.getParameters().getType(param);
        if (type != null) {
            return type;
        }
        Object value = this.statement.getParameters().getParameter(param);
        if (value == null) {
            return 1111;
        }
        if (Boolean.class.isAssignableFrom(value.getClass())) {
            return 16;
        }
        if (Byte.class.isAssignableFrom(value.getClass())) {
            return -6;
        }
        if (Short.class.isAssignableFrom(value.getClass())) {
            return 5;
        }
        if (Integer.class.isAssignableFrom(value.getClass())) {
            return 4;
        }
        if (Long.class.isAssignableFrom(value.getClass())) {
            return -5;
        }
        if (Float.class.isAssignableFrom(value.getClass())) {
            return 6;
        }
        if (Double.class.isAssignableFrom(value.getClass())) {
            return 8;
        }
        if (BigDecimal.class.isAssignableFrom(value.getClass())) {
            return 2;
        }
        if (Date.class.isAssignableFrom(value.getClass())) {
            return 91;
        }
        if (Timestamp.class.isAssignableFrom(value.getClass())) {
            return 93;
        }
        if (Time.class.isAssignableFrom(value.getClass())) {
            return 92;
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            return -9;
        }
        if (byte[].class.isAssignableFrom(value.getClass())) {
            return -2;
        }
        return 1111;
    }

    @Override
    public String getParameterTypeName(int param) {
        return JdbcParameterMetaData.getSpannerTypeName(this.getParameterType(param));
    }

    @Override
    public String getParameterClassName(int param) {
        Object value = this.statement.getParameters().getParameter(param);
        if (value != null) {
            return value.getClass().getName();
        }
        Integer type = this.statement.getParameters().getType(param);
        if (type != null) {
            return JdbcParameterMetaData.getClassName(type);
        }
        return null;
    }

    @Override
    public int getParameterMode(int param) {
        return 1;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("CloudSpannerPreparedStatementParameterMetaData, parameter count: ").append(this.getParameterCount());
        for (int param = 1; param <= this.getParameterCount(); ++param) {
            res.append("\nParameter ").append(param).append(":\n\t Class name: ").append(this.getParameterClassName(param));
            res.append(",\n\t Parameter type name: ").append(this.getParameterTypeName(param));
            res.append(",\n\t Parameter type: ").append(this.getParameterType(param));
            res.append(",\n\t Parameter precision: ").append(this.getPrecision(param));
            res.append(",\n\t Parameter scale: ").append(this.getScale(param));
            res.append(",\n\t Parameter signed: ").append(this.isSigned(param));
            res.append(",\n\t Parameter nullable: ").append(this.isNullable(param));
            res.append(",\n\t Parameter mode: ").append(this.getParameterMode(param));
        }
        return res.toString();
    }
}

