/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import java.util.Objects;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class LongValueHashMap<K>
extends BaseHashMap {
    private Set<K> keySet;
    private Collection<Long> values;
    private Set<Map.Entry<K, Long>> entries;

    public LongValueHashMap() {
        this(8);
    }

    public LongValueHashMap(int n) throws IllegalArgumentException {
        super(n, 3, 2, false);
    }

    public LongValueHashMap(int n, ObjectComparator objectComparator) {
        this(n);
        this.comparator = objectComparator;
    }

    public long get(Object object) throws NoSuchElementException {
        if (object == null) {
            throw new NullPointerException();
        }
        int n = this.getLookup(object);
        if (n != -1) {
            return this.longValueTable[n];
        }
        throw new NoSuchElementException();
    }

    public long get(Object object, int n) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n2 = this.getLookup(object);
        if (n2 != -1) {
            return this.longValueTable[n2];
        }
        return n;
    }

    public boolean get(Object object, long[] lArray) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n = this.getLookup(object);
        if (n != -1) {
            lArray[0] = this.longValueTable[n];
            return true;
        }
        return false;
    }

    public Object getKey(long l) {
        BaseHashMap.BaseHashIterator baseHashIterator = new BaseHashMap.BaseHashIterator(this, false);
        while (baseHashIterator.hasNext()) {
            long l2 = baseHashIterator.nextLong();
            if (l2 != l) continue;
            return this.objectKeyTable[baseHashIterator.getLookup()];
        }
        return null;
    }

    public boolean put(Object object, long l) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n = this.size();
        super.addOrUpdate(0L, l, object, null);
        return n != this.size();
    }

    public boolean remove(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n = this.size();
        super.remove(0L, 0L, object, null, false, false);
        return n != this.size();
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return super.containsKey(object);
    }

    public void putAll(LongValueHashMap longValueHashMap) {
        Iterator iterator = longValueHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.put(e, longValueHashMap.get(e));
        }
    }

    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection<Long> values() {
        if (this.values == null) {
            this.values = new Values<Long>();
        }
        return this.values;
    }

    public Set<Map.Entry<K, Long>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values<Long>
    extends AbstractReadOnlyCollection<Long> {
        private Values() {
        }

        @Override
        public PrimitiveIterator<Long> iterator() {
            LongValueHashMap longValueHashMap = LongValueHashMap.this;
            Objects.requireNonNull(longValueHashMap);
            return new BaseHashMap.BaseHashIterator(longValueHashMap, false);
        }

        @Override
        public int size() {
            return LongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class KeySet<K>
    extends AbstractReadOnlyCollection<K>
    implements Set<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            LongValueHashMap longValueHashMap = LongValueHashMap.this;
            Objects.requireNonNull(longValueHashMap);
            return new BaseHashMap.BaseHashIterator(longValueHashMap, true);
        }

        @Override
        public int size() {
            return LongValueHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return LongValueHashMap.this.containsKey(object);
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Object[] toArray() {
            return LongValueHashMap.this.toArray(true);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return LongValueHashMap.this.toArray(TArray, true);
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(LongValueHashMap.this, true);
        }

        @Override
        public Map.Entry<K, Long> next() {
            Object object = super.next();
            Long l = LongValueHashMap.this.longValueTable[this.lookup];
            return new MapEntry<Object, Long>(object, l);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<K, Long>>
    implements Set<Map.Entry<K, Long>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, Long>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return LongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

