/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.snapshot;

import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.flywaydb.check.CompareEngine;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.extensibility.CommandExtension;
import org.flywaydb.core.extensibility.ConfigurationParameter;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.snapshot.SnapshotConfigurationExtension;
import org.flywaydb.snapshot.SnapshotResult;

public class SnapshotCommandExtension
implements CommandExtension {
    private static final Log LOG = LogFactory.getLog(SnapshotCommandExtension.class);
    public static final String COMMAND = "snapshot";

    public boolean handlesCommand(String command) {
        return command.equals(COMMAND);
    }

    public boolean handlesParameter(String parameter) {
        return false;
    }

    public OperationResult handle(String command, Configuration config, List<String> flags, FlywayTelemetryManager flywayTelemetryManager) throws FlywayException {
        if (!this.handlesCommand(command)) {
            return null;
        }
        LicenseGuard.guard((Configuration)config, Arrays.asList(Edition.TIER3), (String)"flyway snapshot");
        SnapshotConfigurationExtension configurationExtension = (SnapshotConfigurationExtension)config.getPluginRegister().getPlugin(SnapshotConfigurationExtension.class);
        List compareEngines = config.getPluginRegister().getPlugins(CompareEngine.class).stream().sorted().collect(Collectors.toList());
        configurationExtension.validate();
        for (CompareEngine compareEngine : compareEngines) {
            if (!compareEngine.handlesUrl(config.getUrl())) continue;
            String filename = configurationExtension.getFilename();
            String snapshot = compareEngine.generateSnapshot(configurationExtension, config);
            try (FileWriter fileWriter = new FileWriter(filename);){
                fileWriter.write(snapshot);
            }
            catch (Exception e) {
                throw new FlywayException("Unable to write snapshot to " + filename + ": " + e.getMessage());
            }
            LOG.info("Result of snapshot written to " + filename);
            return new SnapshotResult(true, filename);
        }
        throw new FlywayException("No compare engine found for the configured database.");
    }

    public String getDescription() {
        return "[enterprise] Produces a snapshot of the database specified in flyway.url";
    }

    public List<ConfigurationParameter> getConfigurationParameters() {
        ArrayList<ConfigurationParameter> configurationParameters = new ArrayList<ConfigurationParameter>();
        configurationParameters.add(new ConfigurationParameter(SnapshotConfigurationExtension.FILENAME, "Destination filename for the snapshot", true));
        return configurationParameters;
    }

    public String getExample() {
        return "flyway snapshot -" + "flyway.url".substring("flyway.".length()) + "=jdbc:example:jdbcurl -" + "flyway.user".substring("flyway.".length()) + "=username -" + "flyway.password".substring("flyway.".length()) + "=password ";
    }

    public List<Pair<String, String>> getUsage() {
        return Collections.singletonList(Pair.of((Object)COMMAND, (Object)this.getDescription()));
    }
}

