/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.check.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.flywaydb.check.codeanalysis.RulesEngineResult;
import org.flywaydb.check.codeanalysis.RulesEngineResultItem;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.FlywayExecutor;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.configuration.Configuration;

public class RulesEngineUtils {
    public static RulesEngineResult mergeResults(List<RulesEngineResult> results) {
        return new RulesEngineResult(results.stream().flatMap(r -> r.results.stream()).collect(Collectors.toMap(r -> r.filepath, r -> r.violations, (e, r) -> Stream.concat(e.stream(), r.stream()).collect(Collectors.toList()))).entrySet().stream().map(e -> new RulesEngineResultItem((String)e.getKey(), (List)e.getValue())).collect(Collectors.toList()));
    }

    public static List<String> getMigrations(Configuration flywayConfiguration, boolean hasCompareUrl) {
        return hasCompareUrl ? RulesEngineUtils.getPendingMigrations(flywayConfiguration) : RulesEngineUtils.getAllMigrations(flywayConfiguration);
    }

    private static List<String> getPendingMigrations(Configuration flywayConfiguration) {
        boolean schemaHistoryExists;
        List results = Arrays.stream(Flyway.configure().configuration(flywayConfiguration).load().info().pending()).collect(Collectors.toList());
        if (flywayConfiguration.getModernConfig().getFlyway().getBaselineVersion() != null && !(schemaHistoryExists = ((Boolean)new FlywayExecutor(flywayConfiguration).execute((migrationResolver, schemaHistory, database, defaultSchema, schemas, callbackExecutor, statementInterceptor) -> schemaHistory.exists(), true, null)).booleanValue())) {
            results = results.stream().filter(migrationInfo -> flywayConfiguration.getBaselineVersion().compareTo(migrationInfo.getVersion()) < 0).collect(Collectors.toList());
        }
        return results.stream().map(MigrationInfo::getPhysicalLocation).collect(Collectors.toList());
    }

    private static List<String> getAllMigrations(Configuration flywayConfiguration) {
        return Arrays.stream(flywayConfiguration.getLocations()).map(Location::getPath).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).flatMap(path -> {
            Stream stream;
            block8: {
                Stream<Path> files = Files.list(path);
                try {
                    stream = files.collect(Collectors.toList()).stream();
                    if (files == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (files != null) {
                            try {
                                files.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioException) {
                        throw new FlywayException((Throwable)ioException);
                    }
                }
                files.close();
            }
            return stream;
        }).map(Path::toString).filter(filename -> filename.endsWith(".sql")).collect(Collectors.toList());
    }
}

