/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.check.utils;

import java.util.List;
import org.flywaydb.check.CheckConfigurationExtension;
import org.flywaydb.check.CompareEngine;
import org.flywaydb.core.api.FlywayException;

public class CompareEngineUtils {
    public static CompareEngine getCompareEngine(CheckConfigurationExtension configurationExtension, List<CompareEngine> compareEngines, String command) {
        for (CompareEngine compareEngine : compareEngines) {
            if (!compareEngine.handlesDatabase(configurationExtension)) continue;
            return compareEngine;
        }
        String exception = "Unsupported database type for " + command;
        if (compareEngines.stream().noneMatch(p -> p.handlesUrl(configurationExtension.getUrl()))) {
            exception = exception + System.lineSeparator() + "\tCompare url: " + configurationExtension.getUrl();
        }
        if (compareEngines.stream().noneMatch(p -> p.handlesUrl(configurationExtension.getBuildUrl()))) {
            exception = exception + System.lineSeparator() + "\tBuild url: " + configurationExtension.getBuildUrl();
        }
        throw new FlywayException(exception);
    }
}

