/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.check.reports.html;

import java.util.ArrayList;
import java.util.List;
import org.flywaydb.check.codeanalysis.RulesEngineResult;
import org.flywaydb.check.codeanalysis.RulesEngineResultItem;
import org.flywaydb.check.codeanalysis.RulesEngineViolation;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.HtmlRenderer;
import org.flywaydb.core.extensibility.HtmlReportSummary;

public class RulesEngineHtmlRenderer
implements HtmlRenderer<RulesEngineResult> {
    public String render(RulesEngineResult rulesEngineResult, Configuration config) {
        StringBuilder body = new StringBuilder();
        for (RulesEngineResultItem result : rulesEngineResult.results) {
            body.append(RulesEngineHtmlRenderer.getResultDropdown(result));
        }
        return body.toString();
    }

    public String tabTitle(RulesEngineResult result, Configuration config) {
        return "Code Analysis";
    }

    public Class<RulesEngineResult> getType() {
        return RulesEngineResult.class;
    }

    private static String getResultDropdown(RulesEngineResultItem result) {
        StringBuilder dropdown = new StringBuilder();
        dropdown.append("<details open>\n");
        dropdown.append("<summary><h4>").append(result.filepath).append("</h4></summary>\n");
        dropdown.append("<ul>\n");
        for (RulesEngineViolation violation : result.violations) {
            dropdown.append("<li style=\"margin-bottom: 25px\">\n").append("Line ").append(violation.line_no).append(", Column ").append(violation.line_pos).append(" - ").append(violation.code).append(" : ").append(violation.description).append("\n</li>\n");
        }
        dropdown.append("</ul>\n");
        dropdown.append("</details>\n");
        return dropdown.toString();
    }

    public List<HtmlReportSummary> getHtmlSummary(RulesEngineResult result) {
        ArrayList<HtmlReportSummary> htmlResult = new ArrayList<HtmlReportSummary>();
        int violations = result.results.size();
        htmlResult.add(new HtmlReportSummary(violations > 0 ? "scError" : "scGood", "warningFilled", violations + " violation" + (violations != 1 ? "s" : "")));
        return htmlResult;
    }
}

