/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.check.reports.html;

import java.util.Arrays;
import java.util.List;
import org.flywaydb.check.ComparisonDifference;
import org.flywaydb.check.drift.DriftResult;
import org.flywaydb.check.result.CompareResult;
import org.flywaydb.check.utils.DiffUtils;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.HtmlRenderer;
import org.flywaydb.core.extensibility.HtmlReportSummary;
import org.flywaydb.core.internal.util.CollectionsUtils;
import org.flywaydb.core.internal.util.HtmlUtils;

public class CompareResultHtmlRenderer
implements HtmlRenderer<CompareResult> {
    public String render(CompareResult compareResult, Configuration config) {
        int i;
        String diffRightTitle;
        String diffLeftTitle;
        StringBuilder result = new StringBuilder();
        if (!(compareResult.getException() != null || CollectionsUtils.hasItems(compareResult.onlyInTarget) || CollectionsUtils.hasItems(compareResult.onlyInSource) || CollectionsUtils.hasItems(compareResult.differences))) {
            result.append(CompareResultHtmlRenderer.getEmptyReportMessage());
        }
        if (compareResult instanceof DriftResult) {
            diffLeftTitle = "Expected";
            diffRightTitle = "Actual";
        } else {
            diffLeftTitle = "Before";
            diffRightTitle = "After";
        }
        if (CollectionsUtils.hasItems(compareResult.onlyInTarget)) {
            for (i = 0; i < compareResult.onlyInTarget.size(); ++i) {
                if (i == 0) {
                    result.append("<details open>\n");
                    result.append("<summary><h3>Objects added</h3></summary>\n");
                }
                result.append(this.getDiff(compareResult.onlyInTarget.get(i), diffLeftTitle, diffRightTitle));
                if (i != compareResult.onlyInTarget.size() - 1) continue;
                result.append("</details>\n");
            }
        }
        if (CollectionsUtils.hasItems(compareResult.onlyInSource)) {
            for (i = 0; i < compareResult.onlyInSource.size(); ++i) {
                if (i == 0) {
                    result.append("<details open>\n");
                    result.append("<summary><h3>Objects deleted</h3></summary>\n");
                }
                result.append(this.getDiff(compareResult.onlyInSource.get(i), diffLeftTitle, diffRightTitle));
                if (i != compareResult.onlyInSource.size() - 1) continue;
                result.append("</details>\n");
            }
        }
        if (CollectionsUtils.hasItems(compareResult.differences)) {
            for (i = 0; i < compareResult.differences.size(); ++i) {
                if (i == 0) {
                    result.append("<details open>\n");
                    result.append("<summary><h3>Objects modified</h3></summary>\n");
                }
                result.append(this.getDiff(compareResult.differences.get(i), diffLeftTitle, diffRightTitle));
                if (i != compareResult.differences.size() - 1) continue;
                result.append("</details>\n");
            }
        }
        return result.toString();
    }

    public String tabTitle(CompareResult result, Configuration config) {
        return (result instanceof DriftResult ? "Drift" : "Change") + " report";
    }

    public Class<CompareResult> getType() {
        return CompareResult.class;
    }

    private static String getEmptyReportMessage() {
        return "<div style=\"width: 700px; background-color: #F2F2F2; margin: 100px auto; padding: 10px 0px\">\n<h2 style=\"text-align: center;\">No report to show: your database is in sync</h2>\n</div>";
    }

    private String getDiff(ComparisonDifference difference, String diffLeftTitle, String diffRightTitle) {
        return "<details style=\"margin-left: 20px\">\n<summary><h4 style=\"margin: 0\">" + HtmlUtils.htmlEncode((String)difference.name) + " <span style=\"background-color: grey; color: white; font-weight: normal; font-size: 0.7em; padding: 2px 5px 2px 5px; border-radius: 5px; font-weight: bold; vertical-align: middle;\">" + difference.objectType.substring(0, 1).toUpperCase() + difference.objectType.substring(1).toLowerCase() + "</span></h4></summary>\n<div style=\"display: flex; justify-content: space-around;\">\n<p>" + diffLeftTitle + "</p>\n<p>" + diffRightTitle + "</p>\n</div>\n" + DiffUtils.generateHTML(HtmlUtils.htmlEncode((String)difference.definitionBefore), HtmlUtils.htmlEncode((String)difference.definitionAfter)) + "</details>";
    }

    public List<HtmlReportSummary> getHtmlSummary(CompareResult result) {
        if (result.differences == null || result.onlyInSource == null || result.onlyInTarget == null) {
            return null;
        }
        return Arrays.asList(new HtmlReportSummary(result.onlyInTarget.size() > 0 ? "scGood" : "scAmbivalent", "addFilled", result.onlyInTarget.size() + " object(s) added"), new HtmlReportSummary(result.onlyInSource.size() > 0 ? "scError" : "scAmbivalent", "deleteFilled", result.onlyInSource.size() + " object(s) removed"), new HtmlReportSummary(result.differences.size() > 0 ? "scWarn" : "scAmbivalent", "editFilled", result.differences.size() + " object(s) changed"));
    }
}

