/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.check.dryrun;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.flywaydb.check.dryrun.DryRunResult;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.extensibility.CommandExtension;
import org.flywaydb.core.extensibility.EventTelemetryModel;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.internal.license.Edition;

public class DryRunCommandExtension
implements CommandExtension {
    public static final String COMMAND = "dryrun";

    public boolean handlesCommand(String command) {
        return command.equals(COMMAND);
    }

    public boolean handlesParameter(String parameter) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OperationResult handle(String command, Configuration config, List<String> flags, FlywayTelemetryManager flywayTelemetryManager) throws FlywayException {
        EventTelemetryModel telemetryModel = new EventTelemetryModel("change", flywayTelemetryManager);
        try {
            try {
                LicenseGuard.guard((Configuration)config, Arrays.asList(Edition.PRO, Edition.ENTERPRISE, Edition.TIER3), (String)"flyway check -dryrun");
            }
            catch (Exception e) {
                telemetryModel.setException(e);
                DryRunResult dryRunResult222 = new DryRunResult("");
                dryRunResult222.setException(e);
                dryRunResult222.setLicenseFailed(true);
                DryRunResult dryRunResult3 = dryRunResult222;
                telemetryModel.close();
                return dryRunResult3;
            }
            ByteArrayOutputStream dryRun = new ByteArrayOutputStream();
            Flyway.configure().configuration(config).dryRunOutput((OutputStream)dryRun).load().migrate();
            DryRunResult dryRunResult222 = new DryRunResult(((Object)dryRun).toString());
            return dryRunResult222;
        }
        finally {
            try {
                telemetryModel.close();
            }
            catch (Throwable throwable2) {
                Throwable throwable;
                throwable.addSuppressed(throwable2);
            }
        }
    }
}

