/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.check.drift;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.flywaydb.check.CheckConfigurationExtension;
import org.flywaydb.check.CompareEngine;
import org.flywaydb.check.drift.DriftResult;
import org.flywaydb.check.result.CompareResult;
import org.flywaydb.check.utils.CompareEngineUtils;
import org.flywaydb.check.utils.CompareResultUtils;
import org.flywaydb.check.utils.HtmlResultUtils;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.extensibility.CommandExtension;
import org.flywaydb.core.extensibility.EventTelemetryModel;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.internal.license.Edition;

public class DriftCommandExtension
implements CommandExtension {
    public static final String COMMAND = "drift";

    public boolean handlesCommand(String command) {
        return command.equals(COMMAND);
    }

    public boolean handlesParameter(String parameter) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OperationResult handle(String command, Configuration config, List<String> flags, FlywayTelemetryManager flywayTelemetryManager) throws FlywayException {
        EventTelemetryModel telemetryModel = new EventTelemetryModel(COMMAND, flywayTelemetryManager);
        try {
            try {
                LicenseGuard.guard((Configuration)config, Collections.singletonList(Edition.TIER3), (String)"flyway check -drift");
            }
            catch (Exception e) {
                telemetryModel.setException(e);
                DriftResult driftResult = new DriftResult();
                driftResult.setException(e);
                driftResult.setLicenseFailed(true);
                DriftResult driftResult2 = driftResult;
                telemetryModel.close();
                return driftResult2;
            }
            CheckConfigurationExtension configurationExtension = (CheckConfigurationExtension)config.getPluginRegister().getPlugin(CheckConfigurationExtension.class);
            List<CompareEngine> compareEngines = config.getPluginRegister().getPlugins(CompareEngine.class).stream().sorted().collect(Collectors.toList());
            CompareEngine compareEngine = CompareEngineUtils.getCompareEngine(configurationExtension, compareEngines, COMMAND);
            DriftResult driftResult = compareEngine.generateDriftReport(configurationExtension, config);
            driftResult = new DriftResult(CompareResultUtils.filterObject(CompareResultUtils.filterObject(driftResult, config.getTable()), config.getTable() + "_s_idx"));
            HtmlResultUtils.logSummary("Drift report summary:", this.getSummaryText(driftResult), driftResult, config);
            DriftResult driftResult3 = driftResult;
            return driftResult3;
        }
        finally {
            try {
                telemetryModel.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    private String getSummaryText(CompareResult result) {
        String added = ": " + result.onlyInTarget.size();
        String deleted = ": " + result.onlyInSource.size();
        String modified = ": " + result.differences.size();
        return "Added" + added + "        Deleted" + deleted + "        Modified" + modified;
    }
}

