/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.check.codeanalysis;

import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.flywaydb.check.codeanalysis.RulesEngineResultItem;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.output.HtmlResult;
import org.flywaydb.core.internal.util.JsonUtils;

public class RulesEngineResult
extends HtmlResult {
    private static final Type RESULTS_TYPE = new TypeToken<ArrayList<RulesEngineResultItem>>(){}.getType();
    public final List<RulesEngineResultItem> results = new ArrayList<RulesEngineResultItem>();
    private transient String majorViolationException;
    private transient String minorViolationException;

    public RulesEngineResult() {
        super(LocalDateTime.now(), "code");
    }

    public RulesEngineResult(List<RulesEngineResultItem> results) {
        this();
        this.results.addAll(results);
    }

    public RulesEngineResult(String result) {
        this();
        try {
            this.results.addAll((Collection)JsonUtils.getGson().fromJson(result, RESULTS_TYPE));
        }
        catch (JsonSyntaxException e) {
            throw new FlywayException("Unable to deserialize code analysis result. Output:" + System.lineSeparator() + result, (Throwable)e);
        }
    }

    public String getMajorViolationException() {
        return this.majorViolationException;
    }

    public void setMajorViolationException(String majorViolationException) {
        this.majorViolationException = majorViolationException;
    }

    public String getMinorViolationException() {
        return this.minorViolationException;
    }

    public void setMinorViolationException(String minorViolationException) {
        this.minorViolationException = minorViolationException;
    }
}

