/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.check;

import java.nio.file.Paths;
import java.util.List;
import org.flywaydb.check.codeanalysis.RulesEngineDialect;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.extensibility.ConfigurationExtension;
import org.flywaydb.core.internal.util.ClassUtils;

public class CheckConfigurationExtension
implements ConfigurationExtension {
    private static final String COMMAND = "CHECK";
    private static final String PROPERTY_PREFIX = "flyway." + "CHECK".toLowerCase() + ".";
    public static final String COMPARE_URL = PROPERTY_PREFIX + "url";
    public static final String COMPARE_USER = PROPERTY_PREFIX + "user";
    public static final String COMPARE_PASSWORD = PROPERTY_PREFIX + "password";
    public static final String COMPARE_BUILD_URL = PROPERTY_PREFIX + "buildUrl";
    public static final String COMPARE_BUILD_USER = PROPERTY_PREFIX + "buildUser";
    public static final String COMPARE_BUILD_PASSWORD = PROPERTY_PREFIX + "buildPassword";
    public static final String COMPARE_REPORT_FILENAME = PROPERTY_PREFIX + "reportFilename";
    public static final String COMPARE_NEXT_SNAPSHOT = PROPERTY_PREFIX + "nextSnapshot";
    public static final String COMPARE_DEPLOYED_SNAPSHOT = PROPERTY_PREFIX + "deployedSnapshot";
    public static final String COMPARE_APPLIED_MIGRATIONS = PROPERTY_PREFIX + "appliedMigrations";
    public static final String COMPARE_IGNORE_RULES_FILE = PROPERTY_PREFIX + "ignoreRulesFile";
    public static final String COMPARE_FILTER_FILE = PROPERTY_PREFIX + "filterFile";
    public static final String COMPARE_MAJOR_RULES = PROPERTY_PREFIX + "majorRules";
    public static final String COMPARE_MINOR_RULES = PROPERTY_PREFIX + "minorRules";
    public static final String COMPARE_MAJOR_TOLERANCE = PROPERTY_PREFIX + "majorTolerance";
    public static final String COMPARE_MINOR_TOLERANCE = PROPERTY_PREFIX + "minorTolerance";
    public static final String COMPARE_RULES_LOCATION = PROPERTY_PREFIX + "rulesLocation";
    public static final String COMPARE_RULES_DIALECT = PROPERTY_PREFIX + "rulesDialect";
    public static final String COMPARE_FAIL_ON_DRIFT = PROPERTY_PREFIX + "failOnDrift";
    private String url;
    private String user;
    private String password;
    private String buildUrl;
    private String buildUser;
    private String buildPassword;
    private String reportFilename;
    private String nextSnapshot;
    private String deployedSnapshot;
    private String[] appliedMigrations;
    private String ignoreRulesFile;
    private String filterFile;
    private String[] majorRules;
    private String[] minorRules;
    private int majorTolerance = -1;
    private int minorTolerance = -1;
    private String rulesLocation = Paths.get(ClassUtils.getInstallDir(CheckConfigurationExtension.class), "rules").toString();
    private RulesEngineDialect rulesDialect;
    private boolean failOnDrift = false;

    public String getNamespace() {
        return "check";
    }

    public String getConfigurationParameterFromEnvironmentVariable(String environmentVariable) {
        switch (environmentVariable) {
            case "FLYWAY_PLUGINS_CHECK_URL": {
                return COMPARE_URL;
            }
            case "FLYWAY_PLUGINS_CHECK_USER": {
                return COMPARE_USER;
            }
            case "FLYWAY_PLUGINS_CHECK_PASSWORD": {
                return COMPARE_PASSWORD;
            }
            case "FLYWAY_PLUGINS_CHECK_BUILD_URL": {
                return COMPARE_BUILD_URL;
            }
            case "FLYWAY_PLUGINS_CHECK_BUILD_USER": {
                return COMPARE_BUILD_USER;
            }
            case "FLYWAY_PLUGINS_CHECK_BUILD_PASSWORD": {
                return COMPARE_BUILD_PASSWORD;
            }
            case "FLYWAY_PLUGINS_CHECK_REPORT_FILENAME": {
                return COMPARE_REPORT_FILENAME;
            }
            case "FLYWAY_PLUGINS_CHECK_NEXT_SNAPSHOT": {
                return COMPARE_NEXT_SNAPSHOT;
            }
            case "FLYWAY_PLUGINS_CHECK_DEPLOYED_SNAPSHOT": {
                return COMPARE_DEPLOYED_SNAPSHOT;
            }
            case "FLYWAY_PLUGINS_CHECK_APPLIED_MIGRATIONS": {
                return COMPARE_APPLIED_MIGRATIONS;
            }
            case "FLYWAY_PLUGINS_CHECK_IGNORE_RULES_FILE": {
                return COMPARE_IGNORE_RULES_FILE;
            }
            case "FLYWAY_PLUGINS_CHECK_FILTER_FILE": {
                return COMPARE_FILTER_FILE;
            }
            case "FLYWAY_PLUGINS_CHECK_MAJOR_RULES": {
                return COMPARE_MAJOR_RULES;
            }
            case "FLYWAY_PLUGINS_CHECK_MINOR_RULES": {
                return COMPARE_MINOR_RULES;
            }
            case "FLYWAY_PLUGINS_CHECK_MAJOR_TOLERANCE": {
                return COMPARE_MAJOR_TOLERANCE;
            }
            case "FLYWAY_PLUGINS_CHECK_MINOR_TOLERANCE": {
                return COMPARE_MINOR_TOLERANCE;
            }
            case "FLYWAY_PLUGINS_CHECK_RULES_LOCATION": {
                return COMPARE_RULES_LOCATION;
            }
            case "FLYWAY_PLUGINS_CHECK_RULES_DIALECT": {
                return COMPARE_RULES_DIALECT;
            }
            case "FLYWAY_PLUGINS_CHECK_FAIL_ON_DRIFT": {
                return COMPARE_FAIL_ON_DRIFT;
            }
        }
        return null;
    }

    public void validate(List<String> flags) {
        if (flags.contains("-drift") && this.buildUrl == null && this.deployedSnapshot == null) {
            throw new FlywayException(COMMAND.toLowerCase() + " requires a " + COMPARE_BUILD_URL + " or a " + COMPARE_DEPLOYED_SNAPSHOT + " when " + "-drift" + " is being used");
        }
        if (flags.contains("-changes") && this.buildUrl == null && this.nextSnapshot == null) {
            throw new FlywayException(COMMAND.toLowerCase() + " requires a " + COMPARE_BUILD_URL + " or a " + COMPARE_NEXT_SNAPSHOT + " when " + "-changes" + " is being used");
        }
        if (this.buildUrl != null && this.buildUrl.equals(this.url)) {
            throw new FlywayException(COMMAND.toLowerCase() + " requires the " + COMPARE_BUILD_URL + " and the " + COMPARE_URL + " to be different");
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getBuildUrl() {
        return this.buildUrl;
    }

    public String getBuildUser() {
        return this.buildUser;
    }

    public String getBuildPassword() {
        return this.buildPassword;
    }

    public String getReportFilename() {
        return this.reportFilename;
    }

    public String getNextSnapshot() {
        return this.nextSnapshot;
    }

    public String getDeployedSnapshot() {
        return this.deployedSnapshot;
    }

    public String[] getAppliedMigrations() {
        return this.appliedMigrations;
    }

    public String getIgnoreRulesFile() {
        return this.ignoreRulesFile;
    }

    public String getFilterFile() {
        return this.filterFile;
    }

    public String[] getMajorRules() {
        return this.majorRules;
    }

    public String[] getMinorRules() {
        return this.minorRules;
    }

    public int getMajorTolerance() {
        return this.majorTolerance;
    }

    public int getMinorTolerance() {
        return this.minorTolerance;
    }

    public String getRulesLocation() {
        return this.rulesLocation;
    }

    public RulesEngineDialect getRulesDialect() {
        return this.rulesDialect;
    }

    public boolean isFailOnDrift() {
        return this.failOnDrift;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setBuildUrl(String buildUrl) {
        this.buildUrl = buildUrl;
    }

    public void setBuildUser(String buildUser) {
        this.buildUser = buildUser;
    }

    public void setBuildPassword(String buildPassword) {
        this.buildPassword = buildPassword;
    }

    public void setReportFilename(String reportFilename) {
        this.reportFilename = reportFilename;
    }

    public void setNextSnapshot(String nextSnapshot) {
        this.nextSnapshot = nextSnapshot;
    }

    public void setDeployedSnapshot(String deployedSnapshot) {
        this.deployedSnapshot = deployedSnapshot;
    }

    public void setAppliedMigrations(String[] appliedMigrations) {
        this.appliedMigrations = appliedMigrations;
    }

    public void setIgnoreRulesFile(String ignoreRulesFile) {
        this.ignoreRulesFile = ignoreRulesFile;
    }

    public void setFilterFile(String filterFile) {
        this.filterFile = filterFile;
    }

    public void setMajorRules(String[] majorRules) {
        this.majorRules = majorRules;
    }

    public void setMinorRules(String[] minorRules) {
        this.minorRules = minorRules;
    }

    public void setMajorTolerance(int majorTolerance) {
        this.majorTolerance = majorTolerance;
    }

    public void setMinorTolerance(int minorTolerance) {
        this.minorTolerance = minorTolerance;
    }

    public void setRulesLocation(String rulesLocation) {
        this.rulesLocation = rulesLocation;
    }

    public void setRulesDialect(RulesEngineDialect rulesDialect) {
        this.rulesDialect = rulesDialect;
    }

    public void setFailOnDrift(boolean failOnDrift) {
        this.failOnDrift = failOnDrift;
    }
}

