/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BinaryLogicalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.OrNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class AndNode
extends BinaryLogicalOperatorNode {
    AndNode(ValueNode valueNode, ValueNode valueNode2, ContextManager contextManager) throws StandardException {
        super(valueNode, valueNode2, "and", contextManager);
        this.shortCircuitValue = false;
    }

    AndNode(ValueNode valueNode, ValueNode valueNode2, String string, ContextManager contextManager) throws StandardException {
        super(valueNode, valueNode2, string, contextManager);
        this.shortCircuitValue = false;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        super.bindExpression(fromList, subqueryList, list);
        this.postBindFixup();
        return this;
    }

    @Override
    ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        if (this.leftOperand instanceof OrNode) {
            ((OrNode)this.leftOperand).setFirstOr();
        }
        this.leftOperand = this.leftOperand.preprocess(n, fromList, subqueryList, predicateList);
        if (this.leftOperand instanceof AndNode) {
            this.changeToCNF(false);
        }
        this.rightOperand = this.rightOperand.preprocess(n, fromList, subqueryList, predicateList);
        return this;
    }

    @Override
    ValueNode eliminateNots(boolean bl) throws StandardException {
        this.leftOperand = this.leftOperand.eliminateNots(bl);
        this.rightOperand = this.rightOperand.eliminateNots(bl);
        if (!bl) {
            return this;
        }
        OrNode orNode = new OrNode(this.leftOperand, this.rightOperand, this.getContextManager());
        orNode.setType(this.getTypeServices());
        return orNode;
    }

    @Override
    ValueNode putAndsOnTop() throws StandardException {
        this.rightOperand = this.rightOperand.putAndsOnTop();
        return this;
    }

    @Override
    boolean verifyPutAndsOnTop() {
        boolean bl = true;
        return bl;
    }

    @Override
    ValueNode changeToCNF(boolean bl) throws StandardException {
        AndNode andNode;
        ValueNode valueNode;
        AndNode andNode2 = this;
        if (!(this.rightOperand instanceof AndNode) && !this.rightOperand.isBooleanTrue()) {
            valueNode = new BooleanConstantNode(true, this.getContextManager());
            andNode = new AndNode(andNode2.getRightOperand(), valueNode, this.getContextManager());
            andNode2.setRightOperand(andNode);
            andNode.postBindFixup();
        }
        while (this.leftOperand instanceof AndNode) {
            valueNode = ((AndNode)this.leftOperand).getLeftOperand();
            andNode = (AndNode)this.leftOperand;
            AndNode andNode3 = (AndNode)this.leftOperand;
            ValueNode valueNode2 = this.rightOperand;
            this.leftOperand = valueNode;
            this.rightOperand = andNode3;
            andNode3.setLeftOperand(andNode.getRightOperand());
            andNode3.setRightOperand(valueNode2);
        }
        this.leftOperand = this.leftOperand.changeToCNF(bl);
        this.rightOperand = this.rightOperand.changeToCNF(bl);
        return this;
    }

    @Override
    boolean verifyChangeToCNF() {
        boolean bl = true;
        return bl;
    }

    void postBindFixup() throws StandardException {
        this.setType(this.resolveLogicalBinaryOperator(this.leftOperand.getTypeServices(), this.rightOperand.getTypeServices()));
    }
}

