/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.rulesengine.sqlfluff;

import java.util.ArrayList;
import org.flywaydb.check.CheckConfigurationExtension;
import org.flywaydb.check.codeanalysis.RulesEngine;
import org.flywaydb.check.codeanalysis.RulesEngineDialect;
import org.flywaydb.check.codeanalysis.RulesEngineResult;
import org.flywaydb.check.utils.RulesEngineUtils;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.rulesengine.sqlfluff.utils.SqlFluffUtils;

public class SqlFluffRulesEngine
implements RulesEngine {
    public String getPluginVersion() {
        try {
            return SqlFluffUtils.runSqlFluff("version", new String[0]).trim();
        }
        catch (Exception e) {
            return "not installed";
        }
    }

    public RulesEngineResult run(CheckConfigurationExtension configuration, Configuration flywayConfiguration) {
        SqlFluffUtils.validateInstallation();
        ArrayList<String> args = new ArrayList<String>();
        args.add("-f");
        args.add("json");
        args.add("--ignore");
        args.add("parsing");
        boolean hasCompareUrl = StringUtils.hasText((String)configuration.getUrl());
        RulesEngineDialect dialect = configuration.getRulesDialect();
        if (dialect == null && hasCompareUrl && (dialect = RulesEngineDialect.fromUrl((String)configuration.getUrl())) == RulesEngineDialect.TEXT) {
            dialect = RulesEngineDialect.ANSI;
        }
        if (dialect != null) {
            args.add("--dialect");
            args.add(dialect.name().toLowerCase());
        }
        args.addAll(RulesEngineUtils.getMigrations((Configuration)flywayConfiguration, (boolean)hasCompareUrl));
        String sqlFluffResult = SqlFluffUtils.runSqlFluff("lint", args.toArray(new String[0]));
        return new RulesEngineResult(SqlFluffUtils.processSqlFluffResult(sqlFluffResult));
    }
}

