/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.resolveenvironment;

import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.extensibility.CommandExtension;
import org.flywaydb.core.extensibility.ConfigurationParameter;
import org.flywaydb.core.extensibility.EventTelemetryModel;
import org.flywaydb.core.internal.configuration.models.ResolvedEnvironment;
import org.flywaydb.core.internal.database.DatabaseTypeRegister;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.resolveenvironment.ResolveEnvironmentConfigurationExtension;
import org.flywaydb.resolveenvironment.ResolveEnvironmentResult;

public class ResolveEnvironmentCommandExtension
implements CommandExtension {
    private static final String FLYWAY_ENABLE_RESOLVE_ENVIRONMENT = "FLYWAY_ENABLE_RESOLVE_ENVIRONMENT";
    private static final String FLYWAY_NEVER_RESOLVE_ENVIRONMENT = "FLYWAY_NEVER_RESOLVE_ENVIRONMENT";
    public static final String COMMAND = "resolve-environment";

    public boolean handlesCommand(String command) {
        return command.equals(COMMAND);
    }

    public boolean handlesParameter(String parameter) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OperationResult handle(String command, Configuration config, List<String> flags, FlywayTelemetryManager flywayTelemetryManager) throws FlywayException {
        EventTelemetryModel telemetryModel = new EventTelemetryModel(COMMAND, flywayTelemetryManager);
        try {
            ResolveEnvironmentConfigurationExtension configurationExtension = (ResolveEnvironmentConfigurationExtension)config.getPluginRegister().getPlugin(ResolveEnvironmentConfigurationExtension.class);
            ClassicConfiguration classic = new ClassicConfiguration(config);
            if (!StringUtils.hasText((String)System.getenv(FLYWAY_ENABLE_RESOLVE_ENVIRONMENT)) || StringUtils.hasText((String)System.getenv(FLYWAY_NEVER_RESOLVE_ENVIRONMENT))) {
                classic.setPassword("********");
                classic.setUrl(DatabaseTypeRegister.redactJdbcUrl((String)classic.getUrl()));
            }
            ResolvedEnvironment resolvedEnvironment = classic.getResolvedEnvironment(configurationExtension.getEnvironment());
            ResolveEnvironmentResult resolveEnvironmentResult = new ResolveEnvironmentResult(resolvedEnvironment);
            return resolveEnvironmentResult;
        }
        catch (Exception e) {
            telemetryModel.setException(e);
            throw e;
        }
        finally {
            try {
                telemetryModel.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    public List<ConfigurationParameter> getConfigurationParameters() {
        ArrayList<ConfigurationParameter> result = new ArrayList<ConfigurationParameter>();
        result.add(new ConfigurationParameter(FLYWAY_ENABLE_RESOLVE_ENVIRONMENT, "Environment variable, when set will resolve passwords", false));
        result.add(new ConfigurationParameter(FLYWAY_NEVER_RESOLVE_ENVIRONMENT, "Environment variable, when set will disable resolving passwords entirely", false));
        return result;
    }
}

