/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.jdbc.AbstractJdbcResultSet;
import com.google.cloud.spanner.jdbc.JdbcArray;
import com.google.cloud.spanner.jdbc.JdbcBlob;
import com.google.cloud.spanner.jdbc.JdbcClob;
import com.google.cloud.spanner.jdbc.JdbcDataType;
import com.google.cloud.spanner.jdbc.JdbcResultSetMetaData;
import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.cloud.spanner.jdbc.JdbcTypeConverter;
import com.google.common.base.Preconditions;
import com.google.rpc.Code;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

class JdbcResultSet
extends AbstractJdbcResultSet {
    private boolean closed = false;
    private final Statement statement;
    private boolean wasNull = false;
    private boolean nextReturnedFalse = false;
    private boolean nextCalledForMetaData = false;
    private boolean nextCalledForMetaDataResult = false;
    private long currentRow = 0L;

    static JdbcResultSet of(ResultSet resultSet) {
        Preconditions.checkNotNull((Object)resultSet);
        return new JdbcResultSet(null, resultSet);
    }

    static JdbcResultSet of(Statement statement, ResultSet resultSet) {
        Preconditions.checkNotNull((Object)statement);
        Preconditions.checkNotNull((Object)resultSet);
        return new JdbcResultSet(statement, resultSet);
    }

    private JdbcResultSet(Statement statement, ResultSet spanner) {
        super(spanner);
        this.statement = statement;
    }

    void checkClosedAndValidRow() throws SQLException {
        this.checkClosed();
        if (this.currentRow == 0L) {
            throw JdbcSqlExceptionFactory.of("ResultSet is before first row. Call next() first.", Code.FAILED_PRECONDITION);
        }
        if (this.nextReturnedFalse) {
            throw JdbcSqlExceptionFactory.of("ResultSet is after last row. There is no more data available.", Code.FAILED_PRECONDITION);
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        ++this.currentRow;
        if (this.nextCalledForMetaData) {
            this.nextReturnedFalse = !this.nextCalledForMetaDataResult;
            this.nextCalledForMetaData = false;
        } else {
            this.nextReturnedFalse = !this.spanner.next();
        }
        return !this.nextReturnedFalse;
    }

    @Override
    public void close() throws SQLException {
        this.spanner.close();
        this.closed = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosedAndValidRow();
        return this.wasNull;
    }

    private boolean isNull(int columnIndex) {
        this.wasNull = this.spanner.isNull(columnIndex - 1);
        return this.wasNull;
    }

    SQLException createInvalidToGetAs(String sqlType, Type.Code type) {
        return JdbcSqlExceptionFactory.of(String.format("Invalid column type to get as %s: %s", sqlType, type.name()), Code.INVALID_ARGUMENT);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = this.spanner.getColumnType(spannerIndex).getCode();
        switch (type) {
            case BOOL: {
                return isNull ? null : String.valueOf(this.spanner.getBoolean(spannerIndex));
            }
            case BYTES: {
                return isNull ? null : this.spanner.getBytes(spannerIndex).toBase64();
            }
            case DATE: {
                return isNull ? null : this.spanner.getDate(spannerIndex).toString();
            }
            case FLOAT64: {
                return isNull ? null : Double.toString(this.spanner.getDouble(spannerIndex));
            }
            case INT64: {
                return isNull ? null : Long.toString(this.spanner.getLong(spannerIndex));
            }
            case NUMERIC: {
                return isNull ? null : this.spanner.getBigDecimal(spannerIndex).toString();
            }
            case STRING: {
                return isNull ? null : this.spanner.getString(spannerIndex);
            }
            case TIMESTAMP: {
                return isNull ? null : this.spanner.getTimestamp(spannerIndex).toString();
            }
        }
        throw this.createInvalidToGetAs("string", type);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = this.spanner.getColumnType(spannerIndex).getCode();
        switch (type) {
            case BOOL: {
                return isNull ? false : this.spanner.getBoolean(spannerIndex);
            }
            case FLOAT64: {
                return isNull ? false : this.spanner.getDouble(spannerIndex) != 0.0;
            }
            case INT64: {
                return isNull ? false : this.spanner.getLong(spannerIndex) != 0L;
            }
            case NUMERIC: {
                return isNull ? false : !this.spanner.getBigDecimal(spannerIndex).equals(BigDecimal.ZERO);
            }
            case STRING: {
                return isNull ? false : Boolean.valueOf(this.spanner.getString(spannerIndex));
            }
        }
        throw this.createInvalidToGetAs("boolean", type);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = this.spanner.getColumnType(spannerIndex).getCode();
        switch (type) {
            case BOOL: {
                return isNull ? (byte)0 : (this.spanner.getBoolean(spannerIndex) ? (byte)1 : 0);
            }
            case FLOAT64: {
                return isNull ? (byte)0 : JdbcResultSet.checkedCastToByte(Double.valueOf(this.spanner.getDouble(spannerIndex)).longValue());
            }
            case INT64: {
                return isNull ? (byte)0 : JdbcResultSet.checkedCastToByte(this.spanner.getLong(spannerIndex));
            }
            case NUMERIC: {
                return isNull ? (byte)0 : JdbcResultSet.checkedCastToByte(this.spanner.getBigDecimal(spannerIndex));
            }
            case STRING: {
                return isNull ? (byte)0 : JdbcResultSet.checkedCastToByte(JdbcResultSet.parseLong(this.spanner.getString(spannerIndex)));
            }
        }
        throw this.createInvalidToGetAs("byte", type);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = this.spanner.getColumnType(spannerIndex).getCode();
        switch (type) {
            case BOOL: {
                return isNull ? (short)0 : (this.spanner.getBoolean(spannerIndex) ? (short)1 : 0);
            }
            case FLOAT64: {
                return isNull ? (short)0 : JdbcResultSet.checkedCastToShort(Double.valueOf(this.spanner.getDouble(spannerIndex)).longValue());
            }
            case INT64: {
                return isNull ? (short)0 : JdbcResultSet.checkedCastToShort(this.spanner.getLong(spannerIndex));
            }
            case NUMERIC: {
                return isNull ? (short)0 : JdbcResultSet.checkedCastToShort(this.spanner.getBigDecimal(spannerIndex));
            }
            case STRING: {
                return isNull ? (short)0 : JdbcResultSet.checkedCastToShort(JdbcResultSet.parseLong(this.spanner.getString(spannerIndex)));
            }
        }
        throw this.createInvalidToGetAs("short", type);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = this.spanner.getColumnType(spannerIndex).getCode();
        switch (type) {
            case BOOL: {
                return isNull ? 0 : (this.spanner.getBoolean(spannerIndex) ? 1 : 0);
            }
            case FLOAT64: {
                return isNull ? 0 : JdbcResultSet.checkedCastToInt(Double.valueOf(this.spanner.getDouble(spannerIndex)).longValue());
            }
            case INT64: {
                return isNull ? 0 : JdbcResultSet.checkedCastToInt(this.spanner.getLong(spannerIndex));
            }
            case NUMERIC: {
                return isNull ? 0 : JdbcResultSet.checkedCastToInt(this.spanner.getBigDecimal(spannerIndex));
            }
            case STRING: {
                return isNull ? 0 : JdbcResultSet.checkedCastToInt(JdbcResultSet.parseLong(this.spanner.getString(spannerIndex)));
            }
        }
        throw this.createInvalidToGetAs("int", type);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = this.spanner.getColumnType(spannerIndex).getCode();
        switch (type) {
            case BOOL: {
                return isNull ? 0L : (this.spanner.getBoolean(spannerIndex) ? 1L : 0L);
            }
            case FLOAT64: {
                return isNull ? 0L : Double.valueOf(this.spanner.getDouble(spannerIndex)).longValue();
            }
            case INT64: {
                return isNull ? 0L : this.spanner.getLong(spannerIndex);
            }
            case NUMERIC: {
                return isNull ? 0L : JdbcResultSet.checkedCastToLong(this.spanner.getBigDecimal(spannerIndex));
            }
            case STRING: {
                return isNull ? 0L : JdbcResultSet.parseLong(this.spanner.getString(spannerIndex));
            }
        }
        throw this.createInvalidToGetAs("long", type);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = this.spanner.getColumnType(spannerIndex).getCode();
        switch (type) {
            case BOOL: {
                return isNull ? 0.0f : (this.spanner.getBoolean(spannerIndex) ? 1.0f : 0.0f);
            }
            case FLOAT64: {
                return isNull ? 0.0f : JdbcResultSet.checkedCastToFloat(this.spanner.getDouble(spannerIndex));
            }
            case INT64: {
                return isNull ? 0.0f : JdbcResultSet.checkedCastToFloat(this.spanner.getLong(spannerIndex));
            }
            case NUMERIC: {
                return isNull ? 0.0f : this.spanner.getBigDecimal(spannerIndex).floatValue();
            }
            case STRING: {
                return isNull ? 0.0f : JdbcResultSet.checkedCastToFloat(JdbcResultSet.parseDouble(this.spanner.getString(spannerIndex)));
            }
        }
        throw this.createInvalidToGetAs("float", type);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = this.spanner.getColumnType(spannerIndex).getCode();
        switch (type) {
            case BOOL: {
                return isNull ? 0.0 : (this.spanner.getBoolean(spannerIndex) ? 1.0 : 0.0);
            }
            case FLOAT64: {
                return isNull ? 0.0 : this.spanner.getDouble(spannerIndex);
            }
            case INT64: {
                return isNull ? 0.0 : (double)this.spanner.getLong(spannerIndex);
            }
            case NUMERIC: {
                return isNull ? 0.0 : this.spanner.getBigDecimal(spannerIndex).doubleValue();
            }
            case STRING: {
                return isNull ? 0.0 : JdbcResultSet.parseDouble(this.spanner.getString(spannerIndex));
            }
        }
        throw this.createInvalidToGetAs("double", type);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        return this.isNull(columnIndex) ? null : this.spanner.getBytes(columnIndex - 1).toByteArray();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = this.spanner.getColumnType(spannerIndex).getCode();
        switch (type) {
            case DATE: {
                return isNull ? null : JdbcTypeConverter.toSqlDate(this.spanner.getDate(spannerIndex));
            }
            case STRING: {
                return isNull ? null : JdbcResultSet.parseDate(this.spanner.getString(spannerIndex));
            }
            case TIMESTAMP: {
                return isNull ? null : new Date(this.spanner.getTimestamp(spannerIndex).toSqlTimestamp().getTime());
            }
        }
        throw this.createInvalidToGetAs("date", type);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = this.spanner.getColumnType(spannerIndex).getCode();
        switch (type) {
            case STRING: {
                return isNull ? null : JdbcResultSet.parseTime(this.spanner.getString(spannerIndex));
            }
            case TIMESTAMP: {
                return isNull ? null : JdbcTypeConverter.toSqlTime(this.spanner.getTimestamp(spannerIndex));
            }
        }
        throw this.createInvalidToGetAs("time", type);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = this.spanner.getColumnType(spannerIndex).getCode();
        switch (type) {
            case DATE: {
                return isNull ? null : JdbcTypeConverter.toSqlTimestamp(this.spanner.getDate(spannerIndex));
            }
            case STRING: {
                return isNull ? null : JdbcResultSet.parseTimestamp(this.spanner.getString(spannerIndex));
            }
            case TIMESTAMP: {
                return isNull ? null : JdbcTypeConverter.toSqlTimestamp(this.spanner.getTimestamp(spannerIndex));
            }
        }
        throw this.createInvalidToGetAs("timestamp", type);
    }

    private InputStream getInputStream(String val, Charset charset) {
        if (val == null) {
            return null;
        }
        byte[] b = val.getBytes(charset);
        return new ByteArrayInputStream(b);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getInputStream(this.getString(columnIndex), StandardCharsets.US_ASCII);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getInputStream(this.getString(columnIndex), StandardCharsets.UTF_16LE);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        byte[] val = this.getBytes(columnIndex);
        return val == null ? null : new ByteArrayInputStream(val);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public JdbcResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.isBeforeFirst() && !this.nextCalledForMetaData) {
            this.nextCalledForMetaData = true;
            this.nextCalledForMetaDataResult = this.spanner.next();
        }
        return new JdbcResultSetMetaData(this, this.statement);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        Type type = this.spanner.getColumnType(columnIndex - 1);
        return this.isNull(columnIndex) ? null : this.getObject(type, columnIndex);
    }

    private Object getObject(Type type, int columnIndex) throws SQLException {
        if (type == Type.bool()) {
            return this.getBoolean(columnIndex);
        }
        if (type == Type.bytes()) {
            return this.getBytes(columnIndex);
        }
        if (type == Type.date()) {
            return this.getDate(columnIndex);
        }
        if (type == Type.float64()) {
            return this.getDouble(columnIndex);
        }
        if (type == Type.int64()) {
            return this.getLong(columnIndex);
        }
        if (type == Type.numeric()) {
            return this.getBigDecimal(columnIndex);
        }
        if (type == Type.string()) {
            return this.getString(columnIndex);
        }
        if (type == Type.timestamp()) {
            return this.getTimestamp(columnIndex);
        }
        if (type.getCode() == Type.Code.ARRAY) {
            return this.getArray(columnIndex);
        }
        throw JdbcSqlExceptionFactory.of("Unknown type: " + type.toString(), Code.INVALID_ARGUMENT);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            return this.spanner.getColumnIndex(columnLabel) + 1;
        }
        catch (IllegalArgumentException e) {
            throw JdbcSqlExceptionFactory.of("no column with label " + columnLabel + " found", Code.INVALID_ARGUMENT);
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        String val = this.getString(columnIndex);
        return val == null ? null : new StringReader(val);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getBigDecimal(columnIndex, false, 0);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getBigDecimal(this.findColumn(columnLabel), false, 0);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getBigDecimal(columnIndex, true, scale);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getBigDecimal(this.findColumn(columnLabel), true, scale);
    }

    private BigDecimal getBigDecimal(int columnIndex, boolean fixedScale, int scale) throws SQLException {
        BigDecimal res;
        int spannerIndex = columnIndex - 1;
        Type.Code type = this.spanner.getColumnType(spannerIndex).getCode();
        boolean isNull = this.isNull(columnIndex);
        switch (type) {
            case BOOL: {
                res = isNull ? null : (this.spanner.getBoolean(columnIndex - 1) ? BigDecimal.ONE : BigDecimal.ZERO);
                break;
            }
            case FLOAT64: {
                res = isNull ? null : BigDecimal.valueOf(this.spanner.getDouble(spannerIndex));
                break;
            }
            case INT64: {
                res = isNull ? null : BigDecimal.valueOf(this.spanner.getLong(spannerIndex));
                break;
            }
            case NUMERIC: {
                res = isNull ? null : this.spanner.getBigDecimal(spannerIndex);
                break;
            }
            case STRING: {
                try {
                    res = isNull ? null : new BigDecimal(this.spanner.getString(spannerIndex));
                    break;
                }
                catch (NumberFormatException e) {
                    throw JdbcSqlExceptionFactory.of("The column does not contain a valid BigDecimal", Code.INVALID_ARGUMENT, e);
                }
            }
            default: {
                throw this.createInvalidToGetAs("BigDecimal", type);
            }
        }
        if (res != null && fixedScale) {
            res = res.setScale(scale, RoundingMode.HALF_UP);
        }
        return res;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        return this.currentRow == 0L;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        return this.nextReturnedFalse;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        return this.currentRow == 1L;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        return JdbcResultSet.checkedCastToInt(this.currentRow);
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return this.statement;
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        if (this.isNull(columnIndex)) {
            return null;
        }
        Type type = this.spanner.getColumnType(columnIndex - 1);
        if (type.getCode() != Type.Code.ARRAY) {
            throw JdbcSqlExceptionFactory.of("Column with index " + columnIndex + " does not contain an array", Code.INVALID_ARGUMENT);
        }
        JdbcDataType dataType = JdbcDataType.getType(type.getArrayElementType().getCode());
        List<?> elements = dataType.getArrayElements(this.spanner, columnIndex - 1);
        return JdbcArray.createArray(dataType, elements);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkClosedAndValidRow();
        if (this.isNull(columnIndex)) {
            return null;
        }
        int spannerIndex = columnIndex - 1;
        Type.Code type = this.spanner.getColumnType(spannerIndex).getCode();
        switch (type) {
            case DATE: {
                return JdbcTypeConverter.toSqlDate(this.spanner.getDate(spannerIndex), cal);
            }
            case STRING: {
                return JdbcResultSet.parseDate(this.spanner.getString(spannerIndex), cal);
            }
            case TIMESTAMP: {
                return new Date(JdbcTypeConverter.getAsSqlTimestamp(this.spanner.getTimestamp(spannerIndex), cal).getTime());
            }
        }
        throw this.createInvalidToGetAs("date", type);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = this.spanner.getColumnType(spannerIndex).getCode();
        switch (type) {
            case STRING: {
                return isNull ? null : JdbcResultSet.parseTime(this.spanner.getString(spannerIndex), cal);
            }
            case TIMESTAMP: {
                return isNull ? null : JdbcTypeConverter.toSqlTime(this.spanner.getTimestamp(spannerIndex), cal);
            }
        }
        throw this.createInvalidToGetAs("time", type);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkClosedAndValidRow();
        if (this.isNull(columnIndex)) {
            return null;
        }
        int spannerIndex = columnIndex - 1;
        Type.Code type = this.spanner.getColumnType(spannerIndex).getCode();
        switch (type) {
            case DATE: {
                return JdbcTypeConverter.toSqlTimestamp(this.spanner.getDate(spannerIndex), cal);
            }
            case STRING: {
                return JdbcResultSet.parseTimestamp(this.spanner.getString(spannerIndex), cal);
            }
            case TIMESTAMP: {
                return JdbcTypeConverter.getAsSqlTimestamp(this.spanner.getTimestamp(spannerIndex), cal);
            }
        }
        throw this.createInvalidToGetAs("timestamp", type);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        try {
            return this.isNull(columnIndex) ? null : new URL(this.getString(columnIndex));
        }
        catch (MalformedURLException e) {
            throw JdbcSqlExceptionFactory.of("Invalid URL: " + this.spanner.getString(columnIndex - 1), Code.INVALID_ARGUMENT);
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return 2;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getString(columnLabel);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getCharacterStream(columnLabel);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.checkClosedAndValidRow();
        return this.convertObject(this.getObject(columnIndex), type, this.spanner.getColumnType(columnIndex - 1));
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        this.checkClosedAndValidRow();
        return this.convertObject(this.getObject(columnLabel), type, this.spanner.getColumnType(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this.checkClosedAndValidRow();
        return this.convertObject(this.getObject(columnIndex), map, this.spanner.getColumnType(columnIndex - 1));
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        this.checkClosedAndValidRow();
        return this.convertObject(this.getObject(columnLabel), map, this.spanner.getColumnType(columnLabel));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        byte[] val = this.getBytes(columnIndex);
        return val == null ? null : new JdbcBlob(val);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        byte[] val = this.getBytes(columnLabel);
        return val == null ? null : new JdbcBlob(val);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        String val = this.getString(columnIndex);
        return val == null ? null : new JdbcClob(val);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        String val = this.getString(columnLabel);
        return val == null ? null : new JdbcClob(val);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        String val = this.getString(columnIndex);
        return val == null ? null : new JdbcClob(val);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        String val = this.getString(columnLabel);
        return val == null ? null : new JdbcClob(val);
    }

    private <T> T convertObject(Object o, Class<T> javaType, Type type) throws SQLException {
        return (T)JdbcTypeConverter.convert(o, type, javaType);
    }

    private Object convertObject(Object o, Map<String, Class<?>> map, Type type) throws SQLException {
        if (map == null) {
            throw JdbcSqlExceptionFactory.of("Map may not be null", Code.INVALID_ARGUMENT);
        }
        if (o == null) {
            return null;
        }
        Class<?> javaType = map.get(type.getCode().name());
        if (javaType == null) {
            return o;
        }
        return JdbcTypeConverter.convert(o, type, javaType);
    }
}

