/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle.teams;

import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.internal.parser.Token;
import org.flywaydb.core.internal.parser.TokenType;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.sqlscript.ParsedSqlStatement;

public abstract class AbstractSQLPlusParsedSqlStatement
extends ParsedSqlStatement {
    AbstractSQLPlusParsedSqlStatement(int pos, int line, int col, String sql) {
        super(pos, line, col, AbstractSQLPlusParsedSqlStatement.clean(sql), Delimiter.SEMICOLON, true, false);
    }

    private static String clean(String sql) {
        String clean = sql.replace("\r", "").replace("-\n", " ").trim();
        if (clean.endsWith(";")) {
            return clean.substring(0, clean.length() - 1);
        }
        return clean;
    }

    protected final List<Token> filterTokens(List<Token> tokens) {
        tokens = this.discardComments(tokens);
        if ((tokens = this.discardBlankLines(tokens)).size() < 1 || !";".equals(tokens.get(tokens.size() - 1).getText())) {
            return tokens;
        }
        return tokens.subList(0, tokens.size() - 1);
    }

    private List<Token> discardComments(List<Token> tokens) {
        ArrayList<Token> nonCommentTokens = new ArrayList<Token>();
        for (Token token : tokens) {
            if (TokenType.COMMENT == token.getType()) continue;
            nonCommentTokens.add(token);
        }
        return nonCommentTokens;
    }

    private List<Token> discardBlankLines(List<Token> tokens) {
        ArrayList<Token> nonBlankLinesTokens = new ArrayList<Token>(tokens);
        while (((Token)nonBlankLinesTokens.get(0)).getType() == TokenType.BLANK_LINES) {
            nonBlankLinesTokens.remove(0);
        }
        while (((Token)nonBlankLinesTokens.get(nonBlankLinesTokens.size() - 1)).getType() == TokenType.BLANK_LINES) {
            nonBlankLinesTokens.remove(nonBlankLinesTokens.size() - 1);
        }
        return nonBlankLinesTokens;
    }
}

