/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class XMLTypeCompiler
extends BaseTypeCompiler {
    @Override
    public boolean convertible(TypeId typeId, boolean bl) {
        return typeId.isXMLTypeId();
    }

    @Override
    public boolean compatible(TypeId typeId) {
        return typeId.isXMLTypeId();
    }

    @Override
    public boolean storable(TypeId typeId, ClassFactory classFactory) {
        return typeId.isXMLTypeId();
    }

    @Override
    public String interfaceName() {
        return "org.apache.derby.iapi.types.XMLDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        int n = this.getStoredFormatIdFromTypeId();
        if (n == 456) {
            return "org.apache.derby.iapi.types.XML";
        }
        return null;
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dataTypeDescriptor) {
        return -1;
    }

    @Override
    String nullMethodName() {
        return "getNullXML";
    }

    @Override
    protected String dataValueMethodName() {
        int n = this.getStoredFormatIdFromTypeId();
        if (n == 456) {
            return "getXMLDataValue";
        }
        return null;
    }
}

