/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.ValueBinder;
import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.cloud.spanner.jdbc.JdbcTypeConverter;
import com.google.common.io.CharStreams;
import com.google.rpc.Code;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

class JdbcParameterStore {
    private static final int INITIAL_PARAMETERS_ARRAY_SIZE = 10;
    private ArrayList<JdbcParameter> parametersList = new ArrayList(10);
    private String table;
    private int highestIndex = 0;

    JdbcParameterStore() {
    }

    void clearParameters() {
        this.parametersList = new ArrayList(10);
        this.highestIndex = 0;
        this.table = null;
    }

    Object getParameter(int parameterIndex) {
        int arrayIndex = parameterIndex - 1;
        if (arrayIndex >= this.parametersList.size() || this.parametersList.get(arrayIndex) == null) {
            return null;
        }
        return this.parametersList.get(arrayIndex).value;
    }

    Integer getType(int parameterIndex) {
        int arrayIndex = parameterIndex - 1;
        if (arrayIndex >= this.parametersList.size() || this.parametersList.get(arrayIndex) == null) {
            return null;
        }
        return this.parametersList.get(arrayIndex).type;
    }

    Integer getNullable(int parameterIndex) {
        int arrayIndex = parameterIndex - 1;
        if (arrayIndex >= this.parametersList.size() || this.parametersList.get(arrayIndex) == null) {
            return null;
        }
        return this.parametersList.get(arrayIndex).nullable;
    }

    Integer getScaleOrLength(int parameterIndex) {
        int arrayIndex = parameterIndex - 1;
        if (arrayIndex >= this.parametersList.size() || this.parametersList.get(arrayIndex) == null) {
            return null;
        }
        return this.parametersList.get(arrayIndex).scaleOrLength;
    }

    String getColumn(int parameterIndex) {
        int arrayIndex = parameterIndex - 1;
        if (arrayIndex >= this.parametersList.size() || this.parametersList.get(arrayIndex) == null) {
            return null;
        }
        return this.parametersList.get(arrayIndex).column;
    }

    String getTable() {
        return this.table;
    }

    void setTable(String table) {
        this.table = table;
    }

    void setColumn(int parameterIndex, String column) throws SQLException {
        this.setParameter(parameterIndex, this.getParameter(parameterIndex), this.getType(parameterIndex), this.getScaleOrLength(parameterIndex), column, null);
    }

    void setType(int parameterIndex, Integer type) throws SQLException {
        this.setParameter(parameterIndex, this.getParameter(parameterIndex), type, this.getScaleOrLength(parameterIndex), this.getColumn(parameterIndex), null);
    }

    void setParameter(int parameterIndex, Object value) throws SQLException {
        this.setParameter(parameterIndex, value, null, null, null, null);
    }

    void setParameter(int parameterIndex, Object value, SQLType sqlType) throws SQLException {
        this.setParameter(parameterIndex, value, null, null, null, sqlType);
    }

    void setParameter(int parameterIndex, Object value, SQLType sqlType, Integer scaleOrLength) throws SQLException {
        this.setParameter(parameterIndex, value, null, scaleOrLength, null, sqlType);
    }

    void setParameter(int parameterIndex, Object value, Integer sqlType) throws SQLException {
        this.setParameter(parameterIndex, value, sqlType, null);
    }

    void setParameter(int parameterIndex, Object value, Integer sqlType, Integer scaleOrLength) throws SQLException {
        this.setParameter(parameterIndex, value, sqlType, scaleOrLength, null, null);
    }

    void setParameter(int parameterIndex, Object value, Integer sqlType, Integer scaleOrLength, String column, SQLType sqlTypeObject) throws SQLException {
        if (!(value instanceof Value)) {
            if (sqlTypeObject != null && sqlType == null) {
                sqlType = sqlTypeObject.getVendorTypeNumber();
            }
            if (sqlType != null) {
                this.checkTypeAndValueSupported(value, sqlType);
            }
        }
        this.highestIndex = Math.max(parameterIndex, this.highestIndex);
        int arrayIndex = parameterIndex - 1;
        if (arrayIndex >= this.parametersList.size() || this.parametersList.get(arrayIndex) == null) {
            this.parametersList.ensureCapacity(parameterIndex);
            while (this.parametersList.size() < parameterIndex) {
                this.parametersList.add(null);
            }
            this.parametersList.set(arrayIndex, new JdbcParameter());
        }
        JdbcParameter param = this.parametersList.get(arrayIndex);
        param.value = value;
        param.type = sqlType;
        param.scaleOrLength = scaleOrLength;
        param.column = column;
    }

    private void checkTypeAndValueSupported(Object value, int sqlType) throws SQLException {
        if (!this.isTypeSupported(sqlType)) {
            throw JdbcSqlExceptionFactory.of("Type " + sqlType + " is not supported", Code.INVALID_ARGUMENT);
        }
        if (!this.isValidTypeAndValue(value, sqlType)) {
            throw JdbcSqlExceptionFactory.of(value + " is not a valid value for type " + sqlType, Code.INVALID_ARGUMENT);
        }
    }

    private boolean isTypeSupported(int sqlType) {
        switch (sqlType) {
            case -16: 
            case -15: 
            case -9: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2011: 
            case 2013: 
            case 2014: {
                return true;
            }
        }
        return false;
    }

    private boolean isValidTypeAndValue(Object value, int sqlType) {
        if (value == null) {
            return true;
        }
        switch (sqlType) {
            case -7: 
            case 16: {
                return value instanceof Boolean || value instanceof Number;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return value instanceof Number;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return value instanceof String || value instanceof InputStream || value instanceof Reader || value instanceof URL;
            }
            case 91: 
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                return value instanceof java.sql.Date || value instanceof Time || value instanceof java.sql.Timestamp;
            }
            case -4: 
            case -3: 
            case -2: {
                return value instanceof byte[] || value instanceof InputStream;
            }
            case 2003: {
                return value instanceof Array;
            }
            case 2004: {
                return value instanceof Blob || value instanceof InputStream;
            }
            case 2005: {
                return value instanceof Clob || value instanceof Reader;
            }
            case 2011: {
                return value instanceof NClob || value instanceof Reader;
            }
        }
        return false;
    }

    int getHighestIndex() {
        return this.highestIndex;
    }

    void fetchMetaData(Connection connection) throws SQLException {
        if (this.table != null && !"".equals(this.table)) {
            try (ResultSet rsCols = connection.getMetaData().getColumns(null, null, this.table, null);){
                while (rsCols.next()) {
                    JdbcParameter param;
                    String col = rsCols.getString("COLUMN_NAME");
                    int arrayIndex = this.getParameterArrayIndex(col);
                    if (arrayIndex <= -1 || (param = this.parametersList.get(arrayIndex)) == null) continue;
                    param.scaleOrLength = rsCols.getInt("COLUMN_SIZE");
                    param.type = rsCols.getInt("DATA_TYPE");
                    param.nullable = rsCols.getInt("NULLABLE");
                }
            }
        }
    }

    private int getParameterArrayIndex(String columnName) {
        if (columnName != null) {
            for (int index = 0; index < this.highestIndex; ++index) {
                JdbcParameter param = this.parametersList.get(index);
                if (param == null || param.column == null || !columnName.equalsIgnoreCase(param.column)) continue;
                return index;
            }
        }
        return -1;
    }

    static ParametersInfo convertPositionalParametersToNamedParameters(String sql) throws SQLException {
        int POS_PARAM = 63;
        int SINGLE_QUOTE = 39;
        int DOUBLE_QUOTE = 34;
        int BACKTICK_QUOTE = 96;
        boolean isInQuoted = false;
        char startQuote = '\u0000';
        boolean lastCharWasEscapeChar = false;
        boolean isTripleQuoted = false;
        int paramIndex = 1;
        StringBuilder named = new StringBuilder(sql.length() + JdbcParameterStore.countOccurrencesOf('?', sql));
        for (int index = 0; index < sql.length(); ++index) {
            char c = sql.charAt(index);
            if (isInQuoted) {
                if (!(c != '\n' && c != '\r' || isTripleQuoted)) {
                    throw JdbcSqlExceptionFactory.of("SQL statement contains an unclosed literal: " + sql, Code.INVALID_ARGUMENT);
                }
                if (c == startQuote) {
                    if (lastCharWasEscapeChar) {
                        lastCharWasEscapeChar = false;
                    } else if (isTripleQuoted) {
                        if (sql.length() > index + 2 && sql.charAt(index + 1) == startQuote && sql.charAt(index + 2) == startQuote) {
                            isInQuoted = false;
                            startQuote = '\u0000';
                            isTripleQuoted = false;
                        }
                    } else {
                        isInQuoted = false;
                        startQuote = '\u0000';
                    }
                } else {
                    lastCharWasEscapeChar = c == '\\';
                }
                named.append(c);
                continue;
            }
            if (c == '?') {
                named.append("@p" + paramIndex);
                ++paramIndex;
                continue;
            }
            if (c == '\'' || c == '\"' || c == '`') {
                isInQuoted = true;
                startQuote = c;
                if (sql.length() > index + 2 && sql.charAt(index + 1) == startQuote && sql.charAt(index + 2) == startQuote) {
                    isTripleQuoted = true;
                }
            }
            named.append(c);
        }
        if (isInQuoted) {
            throw JdbcSqlExceptionFactory.of("SQL statement contains an unclosed literal: " + sql, Code.INVALID_ARGUMENT);
        }
        return new ParametersInfo(paramIndex - 1, named.toString());
    }

    private static int countOccurrencesOf(char c, String string) {
        int res = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++res;
        }
        return res;
    }

    Statement.Builder bindParameterValue(ValueBinder<Statement.Builder> binder, int index) throws SQLException {
        return this.setValue(binder, this.getParameter(index), this.getType(index));
    }

    Statement.Builder setValue(ValueBinder<Statement.Builder> binder, Object value, Integer sqlType) throws SQLException {
        Statement.Builder res;
        if (value instanceof Value) {
            res = (Statement.Builder)binder.to((Value)value);
        } else if (sqlType != null && sqlType == 2003) {
            if (value instanceof Array) {
                Array array = (Array)value;
                value = array.getArray();
                sqlType = array.getBaseType();
            }
            res = this.setArrayValue(binder, sqlType, value);
        } else {
            res = this.setSingleValue(binder, value, sqlType);
        }
        if (res == null && value != null) {
            throw JdbcSqlExceptionFactory.of("Unsupported parameter type: " + value.getClass().getName() + " - " + value.toString(), Code.INVALID_ARGUMENT);
        }
        return res;
    }

    private Statement.Builder setSingleValue(ValueBinder<Statement.Builder> binder, Object value, Integer sqlType) throws SQLException {
        if (value == null) {
            return this.setNullValue(binder, sqlType);
        }
        if (sqlType == null || sqlType == Integer.valueOf(1111)) {
            return this.setParamWithUnknownType(binder, value);
        }
        return this.setParamWithKnownType(binder, value, sqlType);
    }

    private Statement.Builder setParamWithKnownType(ValueBinder<Statement.Builder> binder, Object value, Integer sqlType) throws SQLException {
        switch (sqlType) {
            case -7: 
            case 16: {
                if (value instanceof Boolean) {
                    return (Statement.Builder)binder.to((Boolean)value);
                }
                if (value instanceof Number) {
                    return (Statement.Builder)binder.to(((Number)value).longValue() != 0L);
                }
                throw JdbcSqlExceptionFactory.of(value + " is not a valid boolean", Code.INVALID_ARGUMENT);
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                if (value instanceof Number) {
                    return (Statement.Builder)binder.to(((Number)value).longValue());
                }
                throw JdbcSqlExceptionFactory.of(value + " is not a valid long", Code.INVALID_ARGUMENT);
            }
            case 6: 
            case 7: 
            case 8: {
                if (value instanceof Number) {
                    return (Statement.Builder)binder.to(((Number)value).doubleValue());
                }
                throw JdbcSqlExceptionFactory.of(value + " is not a valid double", Code.INVALID_ARGUMENT);
            }
            case 2: 
            case 3: {
                if (value instanceof Number) {
                    if (value instanceof BigDecimal) {
                        return (Statement.Builder)binder.to((BigDecimal)value);
                    }
                    try {
                        return (Statement.Builder)binder.to(new BigDecimal(value.toString()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                throw JdbcSqlExceptionFactory.of(value + " is not a valid BigDecimal", Code.INVALID_ARGUMENT);
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                if (value instanceof String) {
                    return (Statement.Builder)binder.to((String)value);
                }
                if (value instanceof InputStream) {
                    InputStreamReader reader = new InputStreamReader((InputStream)value, StandardCharsets.US_ASCII);
                    try {
                        return (Statement.Builder)binder.to(CharStreams.toString((Readable)reader));
                    }
                    catch (IOException e) {
                        throw JdbcSqlExceptionFactory.of("could not set string from input stream", Code.INVALID_ARGUMENT, e);
                    }
                }
                if (value instanceof Reader) {
                    try {
                        return (Statement.Builder)binder.to(CharStreams.toString((Readable)((Reader)value)));
                    }
                    catch (IOException e) {
                        throw JdbcSqlExceptionFactory.of("could not set string from reader", Code.INVALID_ARGUMENT, e);
                    }
                }
                if (value instanceof URL) {
                    return (Statement.Builder)binder.to(((URL)value).toString());
                }
                if (value instanceof UUID) {
                    return (Statement.Builder)binder.to(((UUID)value).toString());
                }
                throw JdbcSqlExceptionFactory.of(value + " is not a valid string", Code.INVALID_ARGUMENT);
            }
            case 91: {
                if (value instanceof java.sql.Date) {
                    return (Statement.Builder)binder.to(JdbcTypeConverter.toGoogleDate((java.sql.Date)value));
                }
                if (value instanceof Time) {
                    return (Statement.Builder)binder.to(JdbcTypeConverter.toGoogleDate((Time)value));
                }
                if (value instanceof java.sql.Timestamp) {
                    return (Statement.Builder)binder.to(JdbcTypeConverter.toGoogleDate((java.sql.Timestamp)value));
                }
                throw JdbcSqlExceptionFactory.of(value + " is not a valid date", Code.INVALID_ARGUMENT);
            }
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                if (value instanceof java.sql.Date) {
                    return (Statement.Builder)binder.to(JdbcTypeConverter.toGoogleTimestamp((java.sql.Date)value));
                }
                if (value instanceof Time) {
                    return (Statement.Builder)binder.to(JdbcTypeConverter.toGoogleTimestamp((Time)value));
                }
                if (value instanceof java.sql.Timestamp) {
                    return (Statement.Builder)binder.to(JdbcTypeConverter.toGoogleTimestamp((java.sql.Timestamp)value));
                }
                throw JdbcSqlExceptionFactory.of(value + " is not a valid timestamp", Code.INVALID_ARGUMENT);
            }
            case -4: 
            case -3: 
            case -2: {
                if (value instanceof byte[]) {
                    return (Statement.Builder)binder.to(ByteArray.copyFrom((byte[])((byte[])value)));
                }
                if (value instanceof InputStream) {
                    try {
                        return (Statement.Builder)binder.to(ByteArray.copyFrom((InputStream)((InputStream)value)));
                    }
                    catch (IOException e) {
                        throw JdbcSqlExceptionFactory.of("Could not copy bytes from input stream: " + e.getMessage(), Code.INVALID_ARGUMENT, e);
                    }
                }
                throw JdbcSqlExceptionFactory.of(value + " is not a valid byte array", Code.INVALID_ARGUMENT);
            }
            case 2003: {
                if (value instanceof Array) {
                    Array jdbcArray = (Array)value;
                    return this.setArrayValue(binder, sqlType, jdbcArray == null ? null : jdbcArray.getArray());
                }
                throw JdbcSqlExceptionFactory.of(value + " is not a valid array", Code.INVALID_ARGUMENT);
            }
            case 2004: {
                if (value instanceof Blob) {
                    try {
                        return (Statement.Builder)binder.to(ByteArray.copyFrom((InputStream)((Blob)value).getBinaryStream()));
                    }
                    catch (IOException e) {
                        throw JdbcSqlExceptionFactory.of("could not set bytes from blob", Code.INVALID_ARGUMENT, e);
                    }
                }
                if (value instanceof InputStream) {
                    try {
                        return (Statement.Builder)binder.to(ByteArray.copyFrom((InputStream)((InputStream)value)));
                    }
                    catch (IOException e) {
                        throw JdbcSqlExceptionFactory.of("could not set bytes from input stream", Code.INVALID_ARGUMENT, e);
                    }
                }
                throw JdbcSqlExceptionFactory.of(value + " is not a valid blob", Code.INVALID_ARGUMENT);
            }
            case 2005: 
            case 2011: {
                if (value instanceof Clob) {
                    try {
                        return (Statement.Builder)binder.to(CharStreams.toString((Readable)((Clob)value).getCharacterStream()));
                    }
                    catch (IOException e) {
                        throw JdbcSqlExceptionFactory.of("could not set string from clob", Code.INVALID_ARGUMENT, e);
                    }
                }
                if (value instanceof Reader) {
                    try {
                        return (Statement.Builder)binder.to(CharStreams.toString((Readable)((Reader)value)));
                    }
                    catch (IOException e) {
                        throw JdbcSqlExceptionFactory.of("could not set string from reader", Code.INVALID_ARGUMENT, e);
                    }
                }
                throw JdbcSqlExceptionFactory.of(value + " is not a valid clob", Code.INVALID_ARGUMENT);
            }
        }
        return null;
    }

    private Statement.Builder setParamWithUnknownType(ValueBinder<Statement.Builder> binder, Object value) throws SQLException {
        if (Boolean.class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.to((Boolean)value);
        }
        if (Byte.class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.to(((Byte)value).longValue());
        }
        if (Short.class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.to(((Short)value).longValue());
        }
        if (Integer.class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.to(((Integer)value).longValue());
        }
        if (Long.class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.to(((Long)value).longValue());
        }
        if (Float.class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.to(((Float)value).doubleValue());
        }
        if (Double.class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.to(((Double)value).doubleValue());
        }
        if (BigDecimal.class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.to((BigDecimal)value);
        }
        if (java.sql.Date.class.isAssignableFrom(value.getClass())) {
            java.sql.Date dateValue = (java.sql.Date)value;
            return (Statement.Builder)binder.to(JdbcTypeConverter.toGoogleDate(dateValue));
        }
        if (java.sql.Timestamp.class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.to(JdbcTypeConverter.toGoogleTimestamp((java.sql.Timestamp)value));
        }
        if (Time.class.isAssignableFrom(value.getClass())) {
            Time timeValue = (Time)value;
            return (Statement.Builder)binder.to(JdbcTypeConverter.toGoogleTimestamp(new java.sql.Timestamp(timeValue.getTime())));
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            String stringVal = (String)value;
            return (Statement.Builder)binder.to(stringVal);
        }
        if (Reader.class.isAssignableFrom(value.getClass())) {
            try {
                Reader readable = (Reader)value;
                return (Statement.Builder)binder.to(CharStreams.toString((Readable)readable));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read from readable", e);
            }
        }
        if (Clob.class.isAssignableFrom(value.getClass()) || NClob.class.isAssignableFrom(value.getClass())) {
            try {
                Clob clob = (Clob)value;
                return (Statement.Builder)binder.to(CharStreams.toString((Readable)clob.getCharacterStream()));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read from readable", e);
            }
        }
        if (Character.class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.to(((Character)value).toString());
        }
        if (Character[].class.isAssignableFrom(value.getClass())) {
            List<Character> list = Arrays.asList((Character[])value);
            StringBuilder s = new StringBuilder();
            for (Character c : list) {
                s.append(c.charValue());
            }
            return (Statement.Builder)binder.to(s.toString());
        }
        if (char[].class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.to(String.valueOf((char[])value));
        }
        if (URL.class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.to(((URL)value).toString());
        }
        if (UUID.class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.to(((UUID)value).toString());
        }
        if (byte[].class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.to(ByteArray.copyFrom((byte[])((byte[])value)));
        }
        if (InputStream.class.isAssignableFrom(value.getClass())) {
            try {
                return (Statement.Builder)binder.to(ByteArray.copyFrom((InputStream)((InputStream)value)));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not copy bytes from input stream: " + e.getMessage(), e);
            }
        }
        if (Blob.class.isAssignableFrom(value.getClass())) {
            try {
                return (Statement.Builder)binder.to(ByteArray.copyFrom((InputStream)((Blob)value).getBinaryStream()));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not copy bytes from input stream: " + e.getMessage(), e);
            }
        }
        if (Array.class.isAssignableFrom(value.getClass())) {
            try {
                Array jdbcArray = (Array)value;
                if (value != null) {
                    return this.setArrayValue(binder, jdbcArray.getBaseType(), jdbcArray.getArray());
                }
            }
            catch (SQLException e) {
                throw new IllegalArgumentException("Unsupported parameter type: " + value.getClass().getName() + " - " + value.toString());
            }
        }
        return null;
    }

    private Statement.Builder setArrayValue(ValueBinder<Statement.Builder> binder, int type, Object value) throws SQLException {
        if (value == null) {
            switch (type) {
                case -7: 
                case 16: {
                    return (Statement.Builder)binder.toBoolArray((boolean[])null);
                }
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    return (Statement.Builder)binder.toInt64Array((long[])null);
                }
                case 6: 
                case 7: 
                case 8: {
                    return (Statement.Builder)binder.toFloat64Array((double[])null);
                }
                case 2: 
                case 3: {
                    return (Statement.Builder)binder.toNumericArray(null);
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: 
                case 2011: {
                    return (Statement.Builder)binder.toStringArray((Iterable)null);
                }
                case 91: {
                    return (Statement.Builder)binder.toDateArray((Iterable)null);
                }
                case 92: 
                case 93: 
                case 2013: 
                case 2014: {
                    return (Statement.Builder)binder.toTimestampArray((Iterable)null);
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    return (Statement.Builder)binder.toBytesArray((Iterable)null);
                }
            }
            throw JdbcSqlExceptionFactory.unsupported("Unknown/unsupported array base type: " + type);
        }
        if (boolean[].class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.toBoolArray((boolean[])value);
        }
        if (Boolean[].class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.toBoolArray(Arrays.asList((Boolean[])value));
        }
        if (short[].class.isAssignableFrom(value.getClass())) {
            long[] l = new long[((short[])value).length];
            for (int i = 0; i < l.length; ++i) {
                l[i] = ((short[])value)[i];
            }
            return (Statement.Builder)binder.toInt64Array(l);
        }
        if (Short[].class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.toInt64Array(this.toLongList((Short[])value));
        }
        if (int[].class.isAssignableFrom(value.getClass())) {
            long[] l = new long[((int[])value).length];
            for (int i = 0; i < l.length; ++i) {
                l[i] = ((int[])value)[i];
            }
            return (Statement.Builder)binder.toInt64Array(l);
        }
        if (Integer[].class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.toInt64Array(this.toLongList((Integer[])value));
        }
        if (long[].class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.toInt64Array((long[])value);
        }
        if (Long[].class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.toInt64Array(this.toLongList((Long[])value));
        }
        if (float[].class.isAssignableFrom(value.getClass())) {
            double[] l = new double[((float[])value).length];
            for (int i = 0; i < l.length; ++i) {
                l[i] = ((float[])value)[i];
            }
            return (Statement.Builder)binder.toFloat64Array(l);
        }
        if (Float[].class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.toFloat64Array(this.toDoubleList((Float[])value));
        }
        if (double[].class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.toFloat64Array((double[])value);
        }
        if (Double[].class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.toFloat64Array(this.toDoubleList((Double[])value));
        }
        if (BigDecimal[].class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.toNumericArray(Arrays.asList((BigDecimal[])value));
        }
        if (java.sql.Date[].class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.toDateArray(JdbcTypeConverter.toGoogleDates((java.sql.Date[])value));
        }
        if (java.sql.Timestamp[].class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.toTimestampArray(JdbcTypeConverter.toGoogleTimestamps((java.sql.Timestamp[])value));
        }
        if (String[].class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.toStringArray(Arrays.asList((String[])value));
        }
        if (byte[][].class.isAssignableFrom(value.getClass())) {
            return (Statement.Builder)binder.toBytesArray(JdbcTypeConverter.toGoogleBytes((byte[][])value));
        }
        return null;
    }

    private List<Long> toLongList(Number[] input) {
        ArrayList<Long> res = new ArrayList<Long>(input.length);
        for (int i = 0; i < input.length; ++i) {
            res.add(input[i] == null ? null : Long.valueOf(input[i].longValue()));
        }
        return res;
    }

    private List<Double> toDoubleList(Number[] input) {
        ArrayList<Double> res = new ArrayList<Double>(input.length);
        for (int i = 0; i < input.length; ++i) {
            res.add(input[i] == null ? null : Double.valueOf(input[i].doubleValue()));
        }
        return res;
    }

    private Statement.Builder setNullValue(ValueBinder<Statement.Builder> binder, Integer sqlType) throws SQLException {
        if (sqlType == null) {
            return (Statement.Builder)binder.to((String)null);
        }
        switch (sqlType) {
            case -5: {
                return (Statement.Builder)binder.to((Long)null);
            }
            case -2: {
                return (Statement.Builder)binder.to((ByteArray)null);
            }
            case 2004: {
                return (Statement.Builder)binder.to((ByteArray)null);
            }
            case 16: {
                return (Statement.Builder)binder.to((Boolean)null);
            }
            case 1: {
                return (Statement.Builder)binder.to((String)null);
            }
            case 2005: {
                return (Statement.Builder)binder.to((String)null);
            }
            case 91: {
                return (Statement.Builder)binder.to((Date)null);
            }
            case 2: 
            case 3: {
                return (Statement.Builder)binder.to((BigDecimal)null);
            }
            case 8: {
                return (Statement.Builder)binder.to((Double)null);
            }
            case 6: {
                return (Statement.Builder)binder.to((Double)null);
            }
            case 4: {
                return (Statement.Builder)binder.to((Long)null);
            }
            case -16: {
                return (Statement.Builder)binder.to((String)null);
            }
            case -4: {
                return (Statement.Builder)binder.to((ByteArray)null);
            }
            case -1: {
                return (Statement.Builder)binder.to((String)null);
            }
            case -15: {
                return (Statement.Builder)binder.to((String)null);
            }
            case 2011: {
                return (Statement.Builder)binder.to((String)null);
            }
            case -9: {
                return (Statement.Builder)binder.to((String)null);
            }
            case 7: {
                return (Statement.Builder)binder.to((Double)null);
            }
            case 5: {
                return (Statement.Builder)binder.to((Long)null);
            }
            case 2009: {
                return (Statement.Builder)binder.to((String)null);
            }
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                return (Statement.Builder)binder.to((Timestamp)null);
            }
            case -6: {
                return (Statement.Builder)binder.to((Long)null);
            }
            case -3: {
                return (Statement.Builder)binder.to((ByteArray)null);
            }
            case 12: {
                return (Statement.Builder)binder.to((String)null);
            }
        }
        throw new IllegalArgumentException("Unsupported sql type for setting to null: " + sqlType);
    }

    static class ParametersInfo {
        final int numberOfParameters;
        final String sqlWithNamedParameters;

        private ParametersInfo(int numberOfParameters, String sqlWithNamedParameters) {
            this.numberOfParameters = numberOfParameters;
            this.sqlWithNamedParameters = sqlWithNamedParameters;
        }
    }

    private static final class JdbcParameter {
        private Object value;
        private Integer type;
        private Integer nullable;
        private Integer scaleOrLength;
        private String column;

        private JdbcParameter() {
        }
    }
}

