/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.info;

import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.stream.IntStream;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.ErrorDetails;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationPattern;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.info.MigrationInfoContext;
import org.flywaydb.core.internal.resolver.ResolvedMigrationImpl;
import org.flywaydb.core.internal.schemahistory.AppliedMigration;
import org.flywaydb.core.internal.util.AbbreviationUtils;

public class MigrationInfoImpl
implements MigrationInfo {
    private final ResolvedMigration resolvedMigration;
    private final AppliedMigration appliedMigration;
    private final MigrationInfoContext context;
    private final boolean outOfOrder;
    private final boolean deleted;
    private final boolean shouldNotExecuteMigration;
    private final boolean undone;

    MigrationInfoImpl(ResolvedMigration resolvedMigration, AppliedMigration appliedMigration, MigrationInfoContext context, boolean outOfOrder, boolean deleted, boolean undone) {
        this.resolvedMigration = resolvedMigration;
        this.appliedMigration = appliedMigration;
        this.context = context;
        this.outOfOrder = outOfOrder;
        this.deleted = deleted;
        this.shouldNotExecuteMigration = this.shouldNotExecuteMigration(resolvedMigration);
        this.undone = undone;
    }

    public ResolvedMigration getResolvedMigration() {
        return this.resolvedMigration;
    }

    public AppliedMigration getAppliedMigration() {
        return this.appliedMigration;
    }

    @Override
    public MigrationType getType() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getType();
        }
        return this.resolvedMigration.getType();
    }

    @Override
    public Integer getChecksum() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getChecksum();
        }
        return this.resolvedMigration.getChecksum();
    }

    @Override
    public MigrationVersion getVersion() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getVersion();
        }
        return this.resolvedMigration.getVersion();
    }

    @Override
    public String getDescription() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getDescription();
        }
        return this.resolvedMigration.getDescription();
    }

    @Override
    public String getScript() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getScript();
        }
        return this.resolvedMigration.getScript();
    }

    private boolean isMigrationInList(MigrationPattern[] cherryPick, ResolvedMigration migration) {
        return this.isMigrationInList(cherryPick, migration.getVersion(), migration.getDescription());
    }

    private boolean isMigrationInList(MigrationPattern[] cherryPick, AppliedMigration migration) {
        return this.isMigrationInList(cherryPick, migration.getVersion(), migration.getDescription());
    }

    private boolean isMigrationInList(MigrationPattern[] cherryPick, MigrationVersion version, String description) {
        boolean inMigrationList = false;
        for (MigrationPattern migration : cherryPick) {
            if (!migration.matches(version, description)) continue;
            inMigrationList = true;
            break;
        }
        return inMigrationList;
    }

    @Override
    public MigrationState getState() {
        if (this.undone) {
            return MigrationState.UNDONE;
        }
        if (this.deleted) {
            return MigrationState.DELETED;
        }
        if (this.appliedMigration == null) {
            if (this.context.cherryPick != null && !this.isMigrationInList(this.context.cherryPick, this.resolvedMigration)) {
                return MigrationState.IGNORED;
            }
            if (this.shouldNotExecuteMigration) {
                return MigrationState.IGNORED;
            }
            if (this.resolvedMigration.getVersion() != null) {
                if (this.resolvedMigration.getVersion().compareTo(this.context.baseline) < 0) {
                    return MigrationState.BELOW_BASELINE;
                }
                if (this.resolvedMigration.getType().isUndo()) {
                    return MigrationState.AVAILABLE;
                }
                if (this.context.target != null && this.context.target != MigrationVersion.NEXT && this.resolvedMigration.getVersion().compareTo(this.context.target) > 0) {
                    return MigrationState.ABOVE_TARGET;
                }
                if (this.resolvedMigration.getVersion().compareTo(this.context.lastApplied) < 0 && !this.context.outOfOrder) {
                    return MigrationState.IGNORED;
                }
                if (this.resolvedMigration.getVersion().compareTo(this.context.latestBaselineMigration) < 0 || this.resolvedMigration.getVersion().compareTo(this.context.latestBaselineMigration) == 0 && !this.resolvedMigration.getType().isBaselineMigration()) {
                    return MigrationState.IGNORED;
                }
            }
            return MigrationState.PENDING;
        }
        if (MigrationType.DELETE == this.appliedMigration.getType()) {
            return MigrationState.SUCCESS;
        }
        if (MigrationType.BASELINE == this.appliedMigration.getType()) {
            return MigrationState.BASELINE;
        }
        if (MigrationType.SQL_BASELINE == this.appliedMigration.getType() || MigrationType.JDBC_BASELINE == this.appliedMigration.getType() || MigrationType.SCRIPT_BASELINE == this.appliedMigration.getType()) {
            return MigrationState.BASELINE;
        }
        if (this.resolvedMigration == null && this.isRepeatableLatest()) {
            if (this.context.cherryPick != null && !this.isMigrationInList(this.context.cherryPick, this.appliedMigration)) {
                return MigrationState.IGNORED;
            }
            if (MigrationType.SCHEMA == this.appliedMigration.getType()) {
                return MigrationState.SUCCESS;
            }
            if (this.appliedMigration.getVersion() == null || this.getVersion().compareTo(this.context.lastResolved) < 0) {
                if (this.appliedMigration.isSuccess()) {
                    return MigrationState.MISSING_SUCCESS;
                }
                return MigrationState.MISSING_FAILED;
            }
            if (this.appliedMigration.isSuccess()) {
                return MigrationState.FUTURE_SUCCESS;
            }
            return MigrationState.FUTURE_FAILED;
        }
        if (this.context.cherryPick != null && !this.isMigrationInList(this.context.cherryPick, this.appliedMigration)) {
            return MigrationState.IGNORED;
        }
        if (!this.appliedMigration.isSuccess()) {
            return MigrationState.FAILED;
        }
        if (this.appliedMigration.getVersion() == null) {
            if (this.appliedMigration.getInstalledRank() == this.context.latestRepeatableRuns.get(this.appliedMigration.getDescription()).intValue()) {
                if (this.resolvedMigration != null && this.resolvedMigration.checksumMatches(this.appliedMigration.getChecksum())) {
                    return MigrationState.SUCCESS;
                }
                return MigrationState.OUTDATED;
            }
            return MigrationState.SUPERSEDED;
        }
        if (this.outOfOrder) {
            return MigrationState.OUT_OF_ORDER;
        }
        return MigrationState.SUCCESS;
    }

    private boolean isRepeatableLatest() {
        if (this.appliedMigration.getVersion() != null) {
            return true;
        }
        Integer latestRepeatableRank = this.context.latestRepeatableRuns.get(this.appliedMigration.getDescription());
        return latestRepeatableRank == null || this.appliedMigration.getInstalledRank() == latestRepeatableRank.intValue();
    }

    @Override
    public Date getInstalledOn() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getInstalledOn();
        }
        return null;
    }

    @Override
    public String getInstalledBy() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getInstalledBy();
        }
        return null;
    }

    @Override
    public Integer getInstalledRank() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getInstalledRank();
        }
        return null;
    }

    @Override
    public Integer getExecutionTime() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getExecutionTime();
        }
        return null;
    }

    @Override
    public String getPhysicalLocation() {
        if (this.resolvedMigration != null) {
            return this.resolvedMigration.getPhysicalLocation();
        }
        return "";
    }

    public ErrorDetails validate() {
        MigrationState state = this.getState();
        if (MigrationState.UNDONE.equals((Object)state)) {
            return null;
        }
        if (MigrationState.ABOVE_TARGET.equals((Object)state)) {
            return null;
        }
        if (MigrationState.DELETED.equals((Object)state)) {
            return null;
        }
        if (Arrays.stream(this.context.ignorePatterns).anyMatch(p -> p.matchesMigration(this.getVersion() != null, state))) {
            return null;
        }
        if (state.isFailed() && (!this.context.future || MigrationState.FUTURE_FAILED != state)) {
            if (this.getVersion() == null) {
                String errorMessage = "Detected failed repeatable migration: " + this.getDescription() + ". Please remove any half-completed changes then run repair to fix the schema history.";
                return new ErrorDetails(ErrorCode.FAILED_REPEATABLE_MIGRATION, errorMessage);
            }
            String errorMessage = "Detected failed migration to version " + this.getVersion() + " (" + this.getDescription() + "). Please remove any half-completed changes then run repair to fix the schema history.";
            return new ErrorDetails(ErrorCode.FAILED_VERSIONED_MIGRATION, errorMessage);
        }
        if (this.context.cherryPick != null && !this.isMigrationInList(this.context.cherryPick, this.getVersion(), this.getDescription())) {
            return null;
        }
        if (!(this.resolvedMigration != null || this.appliedMigration.getType().isSynthetic() || this.appliedMigration.getType().isUndo() || this.appliedMigration.getType().isBaselineMigration() || MigrationState.SUPERSEDED == state || this.context.missing && (MigrationState.MISSING_SUCCESS == state || MigrationState.MISSING_FAILED == state) || this.context.future && (MigrationState.FUTURE_SUCCESS == state || MigrationState.FUTURE_FAILED == state))) {
            if (this.appliedMigration.getVersion() != null) {
                String errorMessage = "Detected applied migration not resolved locally: " + this.getVersion() + ". If you removed this migration intentionally, run repair to mark the migration as deleted.";
                return new ErrorDetails(ErrorCode.APPLIED_VERSIONED_MIGRATION_NOT_RESOLVED, errorMessage);
            }
            String errorMessage = "Detected applied migration not resolved locally: " + this.getDescription() + ". If you removed this migration intentionally, run repair to mark the migration as deleted.";
            return new ErrorDetails(ErrorCode.APPLIED_REPEATABLE_MIGRATION_NOT_RESOLVED, errorMessage);
        }
        if (!this.context.ignored && MigrationState.IGNORED == state) {
            if (this.shouldNotExecuteMigration) {
                return null;
            }
            if (this.getVersion() != null) {
                String errorMessage = "Detected resolved migration not applied to database: " + this.getVersion() + ". To ignore this migration, set -ignoreIgnoredMigrations=true. To allow executing this migration, set -outOfOrder=true.";
                return new ErrorDetails(ErrorCode.RESOLVED_VERSIONED_MIGRATION_NOT_APPLIED, errorMessage);
            }
            String errorMessage = "Detected resolved repeatable migration not applied to database: " + this.getDescription() + ". To ignore this migration, set -ignoreIgnoredMigrations=true.";
            return new ErrorDetails(ErrorCode.RESOLVED_REPEATABLE_MIGRATION_NOT_APPLIED, errorMessage);
        }
        if (!this.context.pending && MigrationState.PENDING == state) {
            if (this.getVersion() != null) {
                String errorMessage = "Detected resolved migration not applied to database: " + this.getVersion() + ". To fix this error, either run migrate, or set -ignorePendingMigrations=true.";
                return new ErrorDetails(ErrorCode.RESOLVED_VERSIONED_MIGRATION_NOT_APPLIED, errorMessage);
            }
            String errorMessage = "Detected resolved repeatable migration not applied to database: " + this.getDescription() + ". To fix this error, either run migrate, or set -ignorePendingMigrations=true.";
            return new ErrorDetails(ErrorCode.RESOLVED_REPEATABLE_MIGRATION_NOT_APPLIED, errorMessage);
        }
        if (!this.context.pending && MigrationState.OUTDATED == state) {
            String errorMessage = "Detected outdated resolved repeatable migration that should be re-applied to database: " + this.getDescription() + ". Run migrate to execute this migration.";
            return new ErrorDetails(ErrorCode.OUTDATED_REPEATABLE_MIGRATION, errorMessage);
        }
        if (this.resolvedMigration != null && this.appliedMigration != null && this.getType() != MigrationType.DELETE && !this.getType().isUndo() && !this.getType().isBaselineMigration()) {
            String migrationIdentifier;
            String string = migrationIdentifier = this.appliedMigration.getVersion() == null ? this.appliedMigration.getScript() : "version " + this.appliedMigration.getVersion();
            if (this.getVersion() == null || this.getVersion().compareTo(this.context.baseline) > 0) {
                if (this.resolvedMigration.getType() != this.appliedMigration.getType()) {
                    String mismatchMessage = this.createMismatchMessage("type", migrationIdentifier, (Object)this.appliedMigration.getType(), (Object)this.resolvedMigration.getType());
                    return new ErrorDetails(ErrorCode.TYPE_MISMATCH, mismatchMessage);
                }
                if ((this.resolvedMigration.getVersion() != null || this.context.pending && MigrationState.OUTDATED != state && MigrationState.SUPERSEDED != state) && !this.resolvedMigration.checksumMatches(this.appliedMigration.getChecksum())) {
                    String mismatchMessage = this.createMismatchMessage("checksum", migrationIdentifier, this.appliedMigration.getChecksum(), this.resolvedMigration.getChecksum());
                    return new ErrorDetails(ErrorCode.CHECKSUM_MISMATCH, mismatchMessage);
                }
                if (this.descriptionMismatch(this.resolvedMigration, this.appliedMigration)) {
                    String mismatchMessage = this.createMismatchMessage("description", migrationIdentifier, this.appliedMigration.getDescription(), this.resolvedMigration.getDescription());
                    return new ErrorDetails(ErrorCode.DESCRIPTION_MISMATCH, mismatchMessage);
                }
            }
        }
        if (!this.context.pending && MigrationState.PENDING == state && this.resolvedMigration instanceof ResolvedMigrationImpl) {
            ((ResolvedMigrationImpl)this.resolvedMigration).validate();
        }
        return null;
    }

    private boolean shouldNotExecuteMigration(ResolvedMigration resolvedMigration) {
        return resolvedMigration != null && resolvedMigration.getExecutor() != null && !resolvedMigration.getExecutor().shouldExecute();
    }

    private boolean descriptionMismatch(ResolvedMigration resolvedMigration, AppliedMigration appliedMigration) {
        if ("<< no description >>".equals(appliedMigration.getDescription())) {
            return !"".equals(resolvedMigration.getDescription());
        }
        return !AbbreviationUtils.abbreviateDescription(resolvedMigration.getDescription()).equals(appliedMigration.getDescription());
    }

    private String createMismatchMessage(String mismatch, String migrationIdentifier, Object applied, Object resolved) {
        return String.format("Migration " + mismatch + " mismatch for migration %s\n-> Applied to database : %s\n-> Resolved locally    : %s. Either revert the changes to the migration, or run repair to update the schema history.", migrationIdentifier, applied, resolved);
    }

    private int getCherryPickIndex(MigrationInfo migrationInfo) {
        return IntStream.range(0, this.context.cherryPick.length).filter(i -> this.context.cherryPick[i].matches(migrationInfo.getVersion(), migrationInfo.getDescription())).findFirst().orElse(this.context.cherryPick.length);
    }

    @Override
    public int compareTo(MigrationInfo o) {
        if (this.context.cherryPick != null) {
            return this.getCherryPickIndex(this) - this.getCherryPickIndex(o);
        }
        if (this.getInstalledRank() != null && o.getInstalledRank() != null) {
            return this.getInstalledRank().compareTo(o.getInstalledRank());
        }
        MigrationState state = this.getState();
        MigrationState oState = o.getState();
        if (state == MigrationState.BELOW_BASELINE && oState.isApplied()) {
            return -1;
        }
        if (state.isApplied() && oState == MigrationState.BELOW_BASELINE) {
            return 1;
        }
        if (this.getInstalledRank() != null) {
            return -1;
        }
        if (o.getInstalledRank() != null) {
            return 1;
        }
        return this.compareVersion(o);
    }

    @Override
    public int compareVersion(MigrationInfo o) {
        if (this.getVersion() != null && o.getVersion() != null) {
            int v = this.getVersion().compareTo(o.getVersion());
            if (v != 0) {
                return v;
            }
            if (this.getType().isUndo() && o.getType().isUndo()) {
                return 0;
            }
            if (this.getType().isUndo()) {
                return 1;
            }
            if (o.getType().isUndo()) {
                return -1;
            }
            return 0;
        }
        if (this.getVersion() != null) {
            return -1;
        }
        if (o.getVersion() != null) {
            return 1;
        }
        return this.getDescription().compareTo(o.getDescription());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationInfoImpl that = (MigrationInfoImpl)o;
        if (!Objects.equals(this.appliedMigration, that.appliedMigration)) {
            return false;
        }
        if (!this.context.equals(that.context)) {
            return false;
        }
        return Objects.equals(this.resolvedMigration, that.resolvedMigration);
    }

    public int hashCode() {
        int result = this.resolvedMigration != null ? this.resolvedMigration.hashCode() : 0;
        result = 31 * result + (this.appliedMigration != null ? this.appliedMigration.hashCode() : 0);
        result = 31 * result + this.context.hashCode();
        return result;
    }
}

