/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.migration;

import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.internal.resolver.MigrationInfoHelper;
import org.flywaydb.core.internal.util.Pair;

public abstract class BaseJavaMigration
implements JavaMigration {
    private final MigrationVersion version;
    private final String description;
    private final boolean undo;
    private final boolean baseline;

    public BaseJavaMigration() {
        String shortName = this.getClass().getSimpleName();
        String prefix = null;
        this.undo = shortName.startsWith("U");
        this.baseline = shortName.startsWith("B");
        boolean repeatable = shortName.startsWith("R");
        if (this.undo || this.baseline) {
            prefix = shortName.substring(0, 1);
        }
        if (shortName.startsWith("V") || repeatable) {
            prefix = shortName.substring(0, 1);
        }
        if (prefix == null) {
            throw new FlywayException("Invalid Java-based migration class name: " + this.getClass().getName() + " => ensure it starts with V, R, U, S or implement org.flywaydb.core.api.migration.JavaMigration directly for non-default naming");
        }
        Pair<MigrationVersion, String> info = MigrationInfoHelper.extractVersionAndDescription(shortName, prefix, "__", new String[]{""}, repeatable);
        this.version = info.getLeft();
        this.description = info.getRight();
    }

    @Override
    public MigrationVersion getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Integer getChecksum() {
        return null;
    }

    @Override
    public boolean isUndo() {
        return this.undo;
    }

    @Override
    public boolean isBaselineMigration() {
        return this.baseline;
    }

    @Override
    public boolean canExecuteInTransaction() {
        return true;
    }
}

