/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.mysql.tidb;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.mysql.MySQLConnection;
import org.flywaydb.core.internal.database.mysql.MySQLDatabase;
import org.flywaydb.core.internal.exception.FlywaySqlException;

public class TiDBConnection
extends MySQLConnection {
    private static final String TIDB_TXN_MODE = "tidb_txn_mode";

    public TiDBConnection(MySQLDatabase database, Connection connection) {
        super(database, connection);
    }

    private void setTidbTxnMode() {
        try {
            this.jdbcTemplate.execute("SET tidb_txn_mode=pessimistic", new Object[0]);
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to set value for 'tidb_txn_mode' variable", e);
        }
    }

    public <T> T lock(Table table, Callable<T> callable) {
        this.setTidbTxnMode();
        return (T)super.lock(table, callable);
    }

    protected boolean canUseNamedLockTemplate() {
        return false;
    }
}

