/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFunction;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.longrunning.OperationFutureImpl;
import com.google.api.gax.paging.Page;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.Policy;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.Instance;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.InstanceConfig;
import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.InstanceInfo;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.base.Preconditions;
import com.google.longrunning.Operation;
import com.google.protobuf.FieldMask;
import com.google.spanner.admin.instance.v1.CreateInstanceMetadata;
import com.google.spanner.admin.instance.v1.UpdateInstanceMetadata;

class InstanceAdminClientImpl
implements InstanceAdminClient {
    private static final PathTemplate PROJECT_NAME_TEMPLATE = PathTemplate.create((String)"projects/{project}");
    private final DatabaseAdminClient dbClient;
    private final String projectId;
    private final SpannerRpc rpc;
    private final PolicyMarshaller policyMarshaller = new PolicyMarshaller();

    InstanceAdminClientImpl(String projectId, SpannerRpc rpc, DatabaseAdminClient dbClient) {
        this.projectId = projectId;
        this.rpc = rpc;
        this.dbClient = dbClient;
    }

    @Override
    public InstanceConfig getInstanceConfig(String configId) throws SpannerException {
        String instanceConfigName = new InstanceConfigId(this.projectId, configId).getName();
        return InstanceConfig.fromProto(this.rpc.getInstanceConfig(instanceConfigName), this);
    }

    @Override
    public Page<InstanceConfig> listInstanceConfigs(Options.ListOption ... options) {
        Options listOptions = Options.fromListOptions(options);
        Preconditions.checkArgument((!listOptions.hasFilter() ? 1 : 0) != 0, (Object)"Filter option is not supported by listInstanceConfigs");
        final int pageSize = listOptions.hasPageSize() ? listOptions.pageSize() : 0;
        SpannerImpl.PageFetcher<InstanceConfig, com.google.spanner.admin.instance.v1.InstanceConfig> pageFetcher = new SpannerImpl.PageFetcher<InstanceConfig, com.google.spanner.admin.instance.v1.InstanceConfig>(){

            @Override
            public SpannerRpc.Paginated<com.google.spanner.admin.instance.v1.InstanceConfig> getNextPage(String nextPageToken) {
                return InstanceAdminClientImpl.this.rpc.listInstanceConfigs(pageSize, nextPageToken);
            }

            @Override
            public InstanceConfig fromProto(com.google.spanner.admin.instance.v1.InstanceConfig proto) {
                return InstanceConfig.fromProto(proto, InstanceAdminClientImpl.this);
            }
        };
        if (listOptions.hasPageToken()) {
            pageFetcher.setNextPageToken(listOptions.pageToken());
        }
        return pageFetcher.getNextPage();
    }

    @Override
    public OperationFuture<Instance, CreateInstanceMetadata> createInstance(InstanceInfo instance) throws SpannerException {
        Preconditions.checkArgument((instance.getNodeCount() == 0 || instance.getProcessingUnits() == 0 ? 1 : 0) != 0, (Object)"Only one of nodeCount and processingUnits can be set when creating a new instance");
        String projectName = PROJECT_NAME_TEMPLATE.instantiate(new String[]{"project", this.projectId});
        OperationFuture<com.google.spanner.admin.instance.v1.Instance, CreateInstanceMetadata> rawOperationFuture = this.rpc.createInstance(projectName, instance.getId().getInstance(), instance.toProto());
        return new OperationFutureImpl(rawOperationFuture.getPollingFuture(), rawOperationFuture.getInitialFuture(), snapshot -> Instance.fromProto((com.google.spanner.admin.instance.v1.Instance)ProtoOperationTransformers.ResponseTransformer.create(com.google.spanner.admin.instance.v1.Instance.class).apply(snapshot), this, this.dbClient), (ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateInstanceMetadata.class), e -> {
            throw SpannerExceptionFactory.newSpannerException(e);
        });
    }

    @Override
    public Instance getInstance(String instanceId) throws SpannerException {
        String instanceName = new InstanceId(this.projectId, instanceId).getName();
        return Instance.fromProto(this.rpc.getInstance(instanceName), this, this.dbClient);
    }

    @Override
    public Page<Instance> listInstances(Options.ListOption ... options) throws SpannerException {
        Options listOptions = Options.fromListOptions(options);
        final int pageSize = listOptions.hasPageSize() ? listOptions.pageSize() : 0;
        final String filter = listOptions.filter();
        SpannerImpl.PageFetcher<Instance, com.google.spanner.admin.instance.v1.Instance> pageFetcher = new SpannerImpl.PageFetcher<Instance, com.google.spanner.admin.instance.v1.Instance>(){

            @Override
            public SpannerRpc.Paginated<com.google.spanner.admin.instance.v1.Instance> getNextPage(String nextPageToken) {
                return InstanceAdminClientImpl.this.rpc.listInstances(pageSize, nextPageToken, filter);
            }

            @Override
            public Instance fromProto(com.google.spanner.admin.instance.v1.Instance proto) {
                return Instance.fromProto(proto, InstanceAdminClientImpl.this, InstanceAdminClientImpl.this.dbClient);
            }
        };
        if (listOptions.hasPageToken()) {
            pageFetcher.setNextPageToken(listOptions.pageToken());
        }
        return pageFetcher.getNextPage();
    }

    @Override
    public void deleteInstance(String instanceId) throws SpannerException {
        this.rpc.deleteInstance(new InstanceId(this.projectId, instanceId).getName());
    }

    @Override
    public OperationFuture<Instance, UpdateInstanceMetadata> updateInstance(InstanceInfo instance, InstanceInfo.InstanceField ... fieldsToUpdate) {
        FieldMask fieldMask = fieldsToUpdate.length == 0 ? InstanceInfo.InstanceField.toFieldMask(InstanceInfo.InstanceField.defaultFieldsToUpdate(instance)) : InstanceInfo.InstanceField.toFieldMask(fieldsToUpdate);
        OperationFuture<com.google.spanner.admin.instance.v1.Instance, UpdateInstanceMetadata> rawOperationFuture = this.rpc.updateInstance(instance.toProto(), fieldMask);
        return new OperationFutureImpl(rawOperationFuture.getPollingFuture(), rawOperationFuture.getInitialFuture(), snapshot -> Instance.fromProto((com.google.spanner.admin.instance.v1.Instance)ProtoOperationTransformers.ResponseTransformer.create(com.google.spanner.admin.instance.v1.Instance.class).apply(snapshot), this, this.dbClient), (ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateInstanceMetadata.class), e -> {
            throw SpannerExceptionFactory.newSpannerException(e);
        });
    }

    @Override
    public Policy getInstanceIAMPolicy(String instanceId) {
        String instanceName = InstanceId.of(this.projectId, instanceId).getName();
        return this.policyMarshaller.fromPb(this.rpc.getInstanceAdminIAMPolicy(instanceName));
    }

    @Override
    public Policy setInstanceIAMPolicy(String instanceId, Policy policy) {
        Preconditions.checkNotNull((Object)policy);
        String instanceName = InstanceId.of(this.projectId, instanceId).getName();
        return this.policyMarshaller.fromPb(this.rpc.setInstanceAdminIAMPolicy(instanceName, this.policyMarshaller.toPb(policy)));
    }

    @Override
    public Iterable<String> testInstanceIAMPermissions(String instanceId, Iterable<String> permissions) {
        Preconditions.checkNotNull(permissions);
        String instanceName = InstanceId.of(this.projectId, instanceId).getName();
        return this.rpc.testInstanceAdminIAMPermissions(instanceName, permissions).getPermissionsList();
    }

    @Override
    public Instance.Builder newInstanceBuilder(InstanceId id) {
        return new Instance.Builder(this, this.dbClient, id);
    }

    @Override
    public void cancelOperation(String name) {
        this.rpc.cancelOperation((String)Preconditions.checkNotNull((Object)name));
    }

    @Override
    public Operation getOperation(String name) {
        return this.rpc.getOperation((String)Preconditions.checkNotNull((Object)name));
    }

    private static final class PolicyMarshaller
    extends Policy.DefaultMarshaller {
        private PolicyMarshaller() {
        }

        protected Policy fromPb(com.google.iam.v1.Policy policyPb) {
            return super.fromPb(policyPb);
        }

        protected com.google.iam.v1.Policy toPb(Policy policy) {
            return super.toPb(policy);
        }
    }
}

