/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.grpc;

import com.google.cloud.grpc.GcpManagedChannel;
import com.google.cloud.grpc.proto.AffinityConfig;
import com.google.common.base.MoreObjects;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class GcpClientCall<ReqT, RespT>
extends ClientCall<ReqT, RespT> {
    private static final Logger logger = Logger.getLogger(GcpClientCall.class.getName());
    private final MethodDescriptor<ReqT, RespT> methodDescriptor;
    private final CallOptions callOptions;
    private final GcpManagedChannel delegateChannel;
    private final AffinityConfig affinity;
    private GcpManagedChannel.ChannelRef delegateChannelRef = null;
    private ClientCall<ReqT, RespT> delegateCall = null;
    private List<String> keys = null;
    private boolean received = false;
    private final AtomicBoolean decremented = new AtomicBoolean(false);
    @GuardedBy(value="this")
    private final Queue<Runnable> calls = new ArrayDeque<Runnable>();
    @GuardedBy(value="this")
    private boolean started;
    private long startNanos = 0L;

    protected GcpClientCall(GcpManagedChannel delegateChannel, MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, AffinityConfig affinity) {
        this.methodDescriptor = methodDescriptor;
        this.callOptions = callOptions;
        this.delegateChannel = delegateChannel;
        this.affinity = affinity;
    }

    public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
        this.checkSendMessage(() -> this.delegateCall.start(this.getListener(responseListener), headers));
    }

    public void request(int numMessages) {
        this.checkSendMessage(() -> this.delegateCall.request(numMessages));
    }

    public void setMessageCompression(boolean enabled) {
        this.checkSendMessage(() -> this.delegateCall.setMessageCompression(enabled));
    }

    public void cancel(@Nullable String message, @Nullable Throwable cause) {
        this.checkSendMessage(() -> this.checkedCancel(message, cause));
    }

    public void halfClose() {
        this.checkSendMessage(() -> this.delegateCall.halfClose());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(ReqT message) {
        GcpClientCall gcpClientCall = this;
        synchronized (gcpClientCall) {
            if (!this.started) {
                this.startNanos = System.nanoTime();
                this.keys = this.delegateChannel.checkKeys(message, true, this.methodDescriptor);
                String key = null;
                if (this.keys != null && this.keys.size() == 1 && this.delegateChannel.getChannelRef(this.keys.get(0)) != null) {
                    key = this.keys.get(0);
                }
                this.delegateChannelRef = this.delegateChannel.getChannelRef(key);
                this.delegateChannelRef.activeStreamsCountIncr();
                this.delegateCall = this.delegateChannelRef.getChannel().newCall(this.methodDescriptor, this.callOptions);
                for (Runnable call : this.calls) {
                    call.run();
                }
                this.calls.clear();
                this.started = true;
            }
        }
        this.delegateCall.sendMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        GcpClientCall gcpClientCall = this;
        synchronized (gcpClientCall) {
            return this.started && this.delegateCall.isReady();
        }
    }

    public Attributes getAttributes() {
        GcpClientCall gcpClientCall = this;
        synchronized (gcpClientCall) {
            if (this.started) {
                return this.delegateCall.getAttributes();
            }
            throw new IllegalStateException("Calling getAttributes() before sendMessage().");
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("delegate", this.delegateCall).toString();
    }

    private void checkedCancel(@Nullable String message, @Nullable Throwable cause) {
        if (!this.decremented.getAndSet(true)) {
            this.delegateChannelRef.activeStreamsCountDecr(this.startNanos, Status.CANCELLED, true);
        }
        this.delegateCall.cancel(message, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSendMessage(Runnable call) {
        GcpClientCall gcpClientCall = this;
        synchronized (gcpClientCall) {
            if (this.started) {
                call.run();
            } else {
                this.calls.add(call);
            }
        }
    }

    private ClientCall.Listener<RespT> getListener(final ClientCall.Listener<RespT> responseListener) {
        return new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

            public void onClose(Status status, Metadata trailers) {
                if (!GcpClientCall.this.decremented.getAndSet(true)) {
                    GcpClientCall.this.delegateChannelRef.activeStreamsCountDecr(GcpClientCall.this.startNanos, status, false);
                }
                if (GcpClientCall.this.keys != null && status.getCode() == Status.Code.OK) {
                    if (GcpClientCall.this.affinity.getCommand() == AffinityConfig.Command.UNBIND) {
                        GcpClientCall.this.delegateChannel.unbind(GcpClientCall.this.keys);
                    } else if (GcpClientCall.this.affinity.getCommand() == AffinityConfig.Command.BIND) {
                        GcpClientCall.this.delegateChannel.bind(GcpClientCall.this.delegateChannelRef, GcpClientCall.this.keys);
                    }
                }
                responseListener.onClose(status, trailers);
            }

            public void onMessage(RespT message) {
                GcpClientCall.this.delegateChannelRef.messageReceived();
                if (!GcpClientCall.this.received) {
                    GcpClientCall.this.received = true;
                    if (GcpClientCall.this.keys == null) {
                        GcpClientCall.this.keys = GcpClientCall.this.delegateChannel.checkKeys(message, false, GcpClientCall.this.methodDescriptor);
                    }
                }
                responseListener.onMessage(message);
            }
        };
    }

    public static class SimpleGcpClientCall<ReqT, RespT>
    extends ForwardingClientCall<ReqT, RespT> {
        private final GcpManagedChannel.ChannelRef channelRef;
        private final ClientCall<ReqT, RespT> delegateCall;
        private long startNanos = 0L;
        private final AtomicBoolean decremented = new AtomicBoolean(false);

        protected SimpleGcpClientCall(GcpManagedChannel.ChannelRef channelRef, MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions) {
            this.channelRef = channelRef;
            this.delegateCall = channelRef.getChannel().newCall(methodDescriptor, callOptions);
        }

        protected ClientCall<ReqT, RespT> delegate() {
            return this.delegateCall;
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            this.startNanos = System.nanoTime();
            ForwardingClientCallListener.SimpleForwardingClientCallListener listener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                public void onClose(Status status, Metadata trailers) {
                    if (!decremented.getAndSet(true)) {
                        channelRef.activeStreamsCountDecr(startNanos, status, false);
                    }
                    super.onClose(status, trailers);
                }

                public void onMessage(RespT message) {
                    channelRef.messageReceived();
                    super.onMessage(message);
                }
            };
            this.channelRef.activeStreamsCountIncr();
            this.delegateCall.start((ClientCall.Listener)listener, headers);
        }

        public void cancel(String message, Throwable cause) {
            if (!this.decremented.getAndSet(true)) {
                this.channelRef.activeStreamsCountDecr(this.startNanos, Status.CANCELLED, true);
            }
            this.delegateCall.cancel(message, cause);
        }
    }
}

