/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.info.teams;

import java.util.Date;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.teams.MigrationFilter;

public class MigrationFilterImpl
implements MigrationFilter {
    public final Date fromDate;
    public final Date toDate;
    public final MigrationVersion fromVersion;
    public final MigrationVersion toVersion;
    public final MigrationState ofState;

    public MigrationFilterImpl(Date fromDate, Date toDate, MigrationVersion fromVersion, MigrationVersion toVersion, MigrationState ofState) {
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.fromVersion = fromVersion;
        this.toVersion = toVersion;
        this.ofState = ofState;
    }

    @Override
    public boolean matches(MigrationInfo info) {
        MigrationState state = info.getState();
        Date installedOn = info.getInstalledOn();
        MigrationVersion version = info.getVersion();
        boolean afterFromDate = this.fromDate == null || installedOn == null || installedOn.after(this.fromDate);
        boolean beforeToDate = this.toDate == null || installedOn != null && installedOn.before(this.toDate);
        boolean afterFromVersion = this.fromVersion == null || version == null || version.compareTo(this.fromVersion) >= 0;
        boolean beforeToVersion = this.toVersion == null || version != null && version.compareTo(this.toVersion) <= 0;
        boolean matchesState = this.ofState == null || this.ofState == state;
        return afterFromDate && beforeToDate && afterFromVersion && beforeToVersion && matchesState;
    }
}

