/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.navigator;

import java.io.IOException;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedLongKeyHashMap;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowSetNavigatorDataChange;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.Type;

public class RowSetNavigatorDataChangeMemory
implements RowSetNavigatorDataChange {
    public static final RowSetNavigatorDataChangeMemory emptyRowSet = new RowSetNavigatorDataChangeMemory(null);
    int size;
    int currentPos = -1;
    OrderedLongKeyHashMap list;
    Session session;

    public RowSetNavigatorDataChangeMemory(Session session) {
        this.session = session;
        this.list = new OrderedLongKeyHashMap(64, true);
    }

    @Override
    public void release() {
        this.beforeFirst();
        this.list.clear();
        this.size = 0;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getRowPosition() {
        return this.currentPos;
    }

    @Override
    public boolean next() {
        if (this.currentPos < this.size - 1) {
            ++this.currentPos;
            return true;
        }
        this.currentPos = this.size - 1;
        return false;
    }

    @Override
    public boolean beforeFirst() {
        this.currentPos = -1;
        return true;
    }

    @Override
    public Row getCurrentRow() {
        return (Row)this.list.getValueByIndex(this.currentPos);
    }

    @Override
    public Object[] getCurrentChangedData() {
        return (Object[])this.list.getSecondValueByIndex(this.currentPos);
    }

    @Override
    public int[] getCurrentChangedColumns() {
        return (int[])this.list.getThirdValueByIndex(this.currentPos);
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, ResultMetaData resultMetaData) throws IOException {
    }

    @Override
    public void read(RowInputInterface rowInputInterface, ResultMetaData resultMetaData) throws IOException {
    }

    @Override
    public void endMainDataSet() {
    }

    @Override
    public boolean addRow(Row row) {
        int n = this.list.getLookup(row.getId());
        if (n == -1) {
            this.list.put(row.getId(), row, null);
            ++this.size;
            return true;
        }
        if (this.list.getSecondValueByIndex(n) != null) {
            if (this.session.database.sqlEnforceTDCD) {
                throw Error.error(3900);
            }
            this.list.setSecondValueByIndex(n, null);
            this.list.setThirdValueByIndex(n, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean addUpdate(Row row, Object[] objectArray, int[] nArray) {
        int n = this.list.getLookup(row.getId());
        if (n == -1) {
            return false;
        }
        this.list.put(row.getId(), row, objectArray);
        this.list.setThirdValueByIndex(n, nArray);
        return true;
    }

    @Override
    public Object[] addRow(Session session, Row row, Object[] objectArray, Type[] typeArray, int[] nArray) {
        long l = row.getId();
        int n = this.list.getLookup(l);
        if (n == -1) {
            this.list.put(l, row, objectArray);
            this.list.setThirdValueByIndex(this.size, nArray);
            ++this.size;
            return objectArray;
        }
        Object[] objectArray2 = ((Row)this.list.getFirstByLookup(n)).getData();
        Object[] objectArray3 = (Object[])this.list.getSecondValueByIndex(n);
        if (objectArray3 == null) {
            if (session.database.sqlEnforceTDCD) {
                throw Error.error(3900);
            }
            return null;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (typeArray[n2].compare(session, objectArray[n2], objectArray3[n2]) == 0) continue;
            if (typeArray[n2].compare(session, objectArray2[n2], objectArray3[n2]) != 0) {
                if (!session.database.sqlEnforceTDCU) continue;
                throw Error.error(3900);
            }
            objectArray3[n2] = objectArray[n2];
        }
        int[] nArray2 = (int[])this.list.getThirdValueByIndex(n);
        nArray2 = ArrayUtil.union(nArray2, nArray);
        this.list.setThirdValueByIndex(n, nArray2);
        return objectArray3;
    }

    @Override
    public boolean containsDeletedRow(Row row) {
        int n = this.list.getLookup(row.getId());
        if (n == -1) {
            return false;
        }
        Object[] objectArray = (Object[])this.list.getSecondValueByIndex(n);
        return objectArray == null;
    }

    @Override
    public boolean containsUpdatedRow(Row row, Row row2, int[] nArray) {
        int n = this.list.getLookup(row2.getId());
        if (n > -1) {
            return true;
        }
        Object[] objectArray = row.getData();
        block0: for (int i = 0; i < this.size; ++i) {
            Row row3 = (Row)this.list.getValueByIndex(i);
            if (row3.getTable() != row.getTable()) continue;
            Type[] typeArray = row.getTable().getColumnTypes();
            Object[] objectArray2 = (Object[])this.list.getSecondValueByIndex(i);
            for (int j = 0; j < nArray.length; ++j) {
                int n2 = nArray[j];
                if (typeArray[n2].compare(this.session, objectArray[n2], objectArray2[n2]) != 0) continue block0;
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeCurrent() {
    }

    @Override
    public long getRowId() {
        return this.getCurrentRow().getId();
    }

    @Override
    public boolean isBeforeFirst() {
        return this.currentPos == -1;
    }

    @Override
    public Object[] getCurrent() {
        return this.getCurrentRow().getData();
    }

    @Override
    public Object getField(int n) {
        return this.getCurrentRow().getData()[n];
    }

    @Override
    public void setCurrent(Object[] objectArray) {
    }

    @Override
    public void reset() {
        this.beforeFirst();
    }

    @Override
    public int getRangePosition() {
        return 1;
    }

    @Override
    public RangeIterator getUpdateRowIterator() {
        return new UpdateRowIterator();
    }

    class UpdateRowIterator
    implements RangeIterator {
        UpdateRowIterator() {
        }

        @Override
        public void removeCurrent() {
        }

        @Override
        public void release() {
        }

        @Override
        public long getRowId() {
            return 0L;
        }

        public boolean beforeFirst() {
            return RowSetNavigatorDataChangeMemory.this.beforeFirst();
        }

        @Override
        public Row getCurrentRow() {
            return null;
        }

        @Override
        public boolean next() {
            return RowSetNavigatorDataChangeMemory.this.next();
        }

        @Override
        public boolean isBeforeFirst() {
            return RowSetNavigatorDataChangeMemory.this.isBeforeFirst();
        }

        @Override
        public Object[] getCurrent() {
            return RowSetNavigatorDataChangeMemory.this.getCurrentChangedData();
        }

        @Override
        public Object getField(int n) {
            return RowSetNavigatorDataChangeMemory.this.getCurrentChangedData()[n];
        }

        @Override
        public void setCurrent(Object[] objectArray) {
        }

        @Override
        public void reset() {
            this.beforeFirst();
        }

        @Override
        public int getRangePosition() {
            return 2;
        }
    }
}

