/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.sqlscript;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.flywaydb.core.api.callback.Error;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.callback.Warning;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Result;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.sqlscript.FlywaySqlScriptException;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.sqlscript.SqlStatementIterator;
import org.flywaydb.core.internal.util.AsciiTable;

public class DefaultSqlScriptExecutor
implements SqlScriptExecutor {
    private static final Log LOG = LogFactory.getLog(DefaultSqlScriptExecutor.class);
    private final JdbcTemplate jdbcTemplate;
    private static final int MAX_BATCH_SIZE = 100;
    private final CallbackExecutor callbackExecutor;
    private final boolean undo;
    private final boolean batch;
    protected final boolean outputQueryResults;
    private final StatementInterceptor statementInterceptor;

    public DefaultSqlScriptExecutor(JdbcTemplate jdbcTemplate, CallbackExecutor callbackExecutor, boolean undo, boolean batch, boolean outputQueryResults, StatementInterceptor statementInterceptor) {
        this.jdbcTemplate = jdbcTemplate;
        this.callbackExecutor = callbackExecutor;
        this.undo = undo;
        this.batch = batch;
        this.outputQueryResults = outputQueryResults;
        this.statementInterceptor = statementInterceptor;
    }

    @Override
    public void execute(SqlScript sqlScript) {
        if (this.statementInterceptor != null) {
            this.statementInterceptor.sqlScript(sqlScript.getResource());
        }
        ArrayList<SqlStatement> batchStatements = new ArrayList<SqlStatement>();
        try (SqlStatementIterator sqlStatementIterator = sqlScript.getSqlStatements();){
            while (sqlStatementIterator.hasNext()) {
                SqlStatement sqlStatement = (SqlStatement)sqlStatementIterator.next();
                if (this.statementInterceptor != null) {
                    this.callbackExecutor.onEachMigrateOrUndoStatementEvent(this.undo ? Event.BEFORE_EACH_UNDO_STATEMENT : Event.BEFORE_EACH_MIGRATE_STATEMENT, sqlStatement.getSql() + sqlStatement.getDelimiter(), null, null);
                    this.logStatementExecution(sqlStatement);
                    this.statementInterceptor.sqlStatement(sqlStatement);
                    this.callbackExecutor.onEachMigrateOrUndoStatementEvent(this.undo ? Event.AFTER_EACH_UNDO_STATEMENT : Event.AFTER_EACH_MIGRATE_STATEMENT, sqlStatement.getSql() + sqlStatement.getDelimiter(), Collections.emptyList(), Collections.emptyList());
                    continue;
                }
                if (this.batch) {
                    if (sqlStatement.isBatchable()) {
                        this.logStatementExecution(sqlStatement);
                        batchStatements.add(sqlStatement);
                        if (batchStatements.size() < 100) continue;
                        this.executeBatch(this.jdbcTemplate, sqlScript, batchStatements);
                        batchStatements = new ArrayList();
                        continue;
                    }
                    this.executeBatch(this.jdbcTemplate, sqlScript, batchStatements);
                    batchStatements = new ArrayList();
                    this.executeStatement(this.jdbcTemplate, sqlScript, sqlStatement);
                    continue;
                }
                this.executeStatement(this.jdbcTemplate, sqlScript, sqlStatement);
            }
        }
        if (this.batch) {
            this.executeBatch(this.jdbcTemplate, sqlScript, batchStatements);
        }
    }

    protected void logStatementExecution(SqlStatement sqlStatement) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing " + (this.batch && sqlStatement.isBatchable() ? "batchable " : "") + "SQL: " + sqlStatement.getSql());
        }
    }

    private void executeBatch(JdbcTemplate jdbcTemplate, SqlScript sqlScript, List<SqlStatement> batchStatements) {
        LOG.debug("Sending batch of " + batchStatements.size() + " statements to database ...");
        ArrayList<String> sqlBatch = new ArrayList<String>();
        for (SqlStatement sqlStatement : batchStatements) {
            this.callbackExecutor.onEachMigrateOrUndoStatementEvent(this.undo ? Event.BEFORE_EACH_UNDO_STATEMENT : Event.BEFORE_EACH_MIGRATE_STATEMENT, sqlStatement.getSql() + sqlStatement.getDelimiter(), null, null);
            sqlBatch.add(sqlStatement.getSql());
        }
        Results results = jdbcTemplate.executeBatch(sqlBatch);
        if (results.getException() != null) {
            this.handleException(results, sqlScript, batchStatements.get(0));
            for (int i = 0; i < results.getResults().size(); ++i) {
                SqlStatement sqlStatement = batchStatements.get(i);
                long updateCount = results.getResults().get(i).getUpdateCount();
                if (updateCount == -3L) {
                    this.callbackExecutor.onEachMigrateOrUndoStatementEvent(this.undo ? Event.AFTER_EACH_UNDO_STATEMENT_ERROR : Event.AFTER_EACH_MIGRATE_STATEMENT_ERROR, sqlStatement.getSql() + sqlStatement.getDelimiter(), results.getWarnings(), results.getErrors());
                    this.handleException(results, sqlScript, batchStatements.get(i));
                    continue;
                }
                if (updateCount == -2L) continue;
                this.callbackExecutor.onEachMigrateOrUndoStatementEvent(this.undo ? Event.AFTER_EACH_UNDO_STATEMENT : Event.AFTER_EACH_MIGRATE_STATEMENT, sqlStatement.getSql() + sqlStatement.getDelimiter(), results.getWarnings(), results.getErrors());
                this.handleUpdateCount(updateCount);
            }
            return;
        }
        for (int i = 0; i < results.getResults().size(); ++i) {
            SqlStatement sqlStatement = batchStatements.get(i);
            this.callbackExecutor.onEachMigrateOrUndoStatementEvent(this.undo ? Event.AFTER_EACH_UNDO_STATEMENT : Event.AFTER_EACH_MIGRATE_STATEMENT, sqlStatement.getSql() + sqlStatement.getDelimiter(), results.getWarnings(), results.getErrors());
        }
        this.handleResults(results, jdbcTemplate);
    }

    protected void executeStatement(JdbcTemplate jdbcTemplate, SqlScript sqlScript, SqlStatement sqlStatement) {
        this.logStatementExecution(sqlStatement);
        String sql = sqlStatement.getSql() + sqlStatement.getDelimiter();
        this.callbackExecutor.onEachMigrateOrUndoStatementEvent(this.undo ? Event.BEFORE_EACH_UNDO_STATEMENT : Event.BEFORE_EACH_MIGRATE_STATEMENT, sql, null, null);
        Results results = sqlStatement.execute(jdbcTemplate, this);
        if (results.getException() != null) {
            this.callbackExecutor.onEachMigrateOrUndoStatementEvent(this.undo ? Event.AFTER_EACH_UNDO_STATEMENT_ERROR : Event.AFTER_EACH_MIGRATE_STATEMENT_ERROR, sql, results.getWarnings(), results.getErrors());
            this.printWarnings(results);
            this.handleException(results, sqlScript, sqlStatement);
            return;
        }
        this.callbackExecutor.onEachMigrateOrUndoStatementEvent(this.undo ? Event.AFTER_EACH_UNDO_STATEMENT : Event.AFTER_EACH_MIGRATE_STATEMENT, sql, results.getWarnings(), results.getErrors());
        this.printWarnings(results);
        this.handleResults(results, jdbcTemplate);
    }

    protected void handleResults(Results results, JdbcTemplate jdbcTemplate) {
        for (Result result : results.getResults()) {
            long updateCount = result.getUpdateCount();
            if (updateCount != -1L) {
                this.handleUpdateCount(updateCount);
            }
            this.outputQueryResult(result);
        }
    }

    protected void outputQueryResult(Result result) {
        if (this.outputQueryResults && result.getColumns() != null) {
            LOG.info(new AsciiTable(result.getColumns(), result.getData(), true, "", "No rows returned").render());
        }
    }

    private void handleUpdateCount(long updateCount) {
        LOG.debug(updateCount + (updateCount == 1L ? "row" : "rows") + "affected");
    }

    protected void handleException(Results results, SqlScript sqlScript, SqlStatement sqlStatement) {
        for (Error error : results.getErrors()) {
            if (error.isHandled()) continue;
            throw new FlywaySqlScriptException(sqlScript.getResource(), sqlStatement, results.getException());
        }
    }

    private void printWarnings(Results results) {
        for (Warning warning : results.getWarnings()) {
            if (warning.isHandled()) continue;
            if ("00000".equals(warning.getState())) {
                LOG.info("DB: " + warning.getMessage());
                continue;
            }
            LOG.warn("DB: " + warning.getMessage() + " (SQL State: " + warning.getState() + " - Error Code: " + warning.getCode() + ")");
        }
    }
}

