/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle.teams;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.DataSource;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.JdbcUtils;

public class OracleDatabaseMetadata {
    private static final HashMap<DataSource, OracleDatabaseMetadata> metadataCache = new HashMap();
    public String oracleUser;
    public String oracleConnectIdentifier;
    public String oracleOVersion;
    public String oracleORelease;

    private void loadFromConfiguration(Configuration configuration, DatabaseType databaseType) {
        Connection connection = null;
        try {
            connection = JdbcUtils.openConnection(configuration.getDataSource(), configuration.getConnectRetries());
            DatabaseMetaData databaseMetaData = JdbcUtils.getDatabaseMetaData(connection);
            JdbcTemplate jdbcTemplate = new JdbcTemplate(connection, databaseType);
            this.oracleUser = jdbcTemplate.queryForString("SELECT USER FROM DUAL", new String[0]);
            String url = databaseMetaData.getURL();
            this.oracleConnectIdentifier = url == null ? "" : url.substring(url.indexOf("//") + 2);
            this.oracleOVersion = jdbcTemplate.queryForString("select banner from v$version where banner like 'Oracle Database%'", new String[0]);
            this.oracleORelease = jdbcTemplate.queryForString("SELECT VERSION FROM PRODUCT_COMPONENT_VERSION WHERE PRODUCT LIKE 'Oracle Database%'", new String[0]).replace(".", "0");
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to collect extra info", e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw new FlywaySqlException("Failed to close connection", e);
            }
        }
    }

    public static OracleDatabaseMetadata getDatabaseMetadata(Configuration configuration, DatabaseType databaseType) {
        DataSource dataSource = configuration.getDataSource();
        OracleDatabaseMetadata metadata = metadataCache.get(dataSource);
        if (metadata == null) {
            metadata = new OracleDatabaseMetadata();
            metadata.loadFromConfiguration(configuration, databaseType);
            metadataCache.put(dataSource, metadata);
        }
        return metadata;
    }
}

