/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.authentication.postgres.enterprise;

import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.authentication.ExternalAuthFileReader;
import org.flywaydb.core.internal.authentication.ExternalAuthPropertiesProvider;
import org.flywaydb.core.internal.util.StringUtils;

public class PgpassPropertiesProvider
implements ExternalAuthPropertiesProvider {
    private static final Log LOG = LogFactory.getLog(PgpassPropertiesProvider.class);
    private static final Pattern URL_REGEX = Pattern.compile("^jdbc:postgresql:(?://([^:/]*)(?::([^/]*))?/?)?([^?]+)?(?:\\?(?:.*user=([^&]*).*)?)?$");
    private final ExternalAuthFileReader pgpassFileReader;
    private final String url;
    private final String user;

    public PgpassPropertiesProvider(ExternalAuthFileReader pgpassFileReader, String url, String user) {
        this.pgpassFileReader = pgpassFileReader;
        this.url = url;
        this.user = user;
    }

    @Override
    public Properties get() {
        Properties properties = new Properties();
        String[] fields = this.matchedURL(this.url, this.user);
        if (fields == null) {
            return properties;
        }
        List<String> fileContents = this.pgpassFileReader.getAllContents();
        if (fileContents.isEmpty()) {
            return properties;
        }
        try {
            String password;
            String authFileContents = fileContents.get(0);
            if (authFileContents != null && (password = this.getPassword(authFileContents, fields[0], fields[1], fields[2], fields[3])) != null) {
                properties.put("password", password);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.debug("Malformed pgpass file. Ensure it contains lines of the form 'host:port:database:username:password'.");
        }
        return properties;
    }

    private String getPassword(String pgpassContents, String host, String port, String database, String user) {
        pgpassContents = pgpassContents.replace("\r\n", "\n");
        for (String pgpassLine : pgpassContents.split("\n")) {
            String[] pgpassFields;
            if (pgpassLine.startsWith("#") || !StringUtils.hasLength(pgpassLine) || !this.wildcardEquals(host, (pgpassFields = pgpassLine.split("(?<!\\\\):"))[0]) || !this.wildcardEquals(port, pgpassFields[1]) || !this.databaseMatches(database, pgpassFields[2], pgpassFields[3]) || !this.wildcardEquals(user, pgpassFields[3])) continue;
            return pgpassFields[4];
        }
        return null;
    }

    private String[] matchedURL(String url, String user) {
        Matcher urlPatternMatcher = URL_REGEX.matcher(url);
        if (!urlPatternMatcher.find()) {
            LOG.debug("Unable to extract <host>, <port>, <database> or <user> from url '" + url + "'");
            return null;
        }
        return new String[]{this.getOrDefault(urlPatternMatcher.group(1), "localhost"), this.getOrDefault(urlPatternMatcher.group(2), "5432"), this.getOrDefault(urlPatternMatcher.group(3), null), this.getOrDefault(urlPatternMatcher.group(4), user)};
    }

    private String getOrDefault(String toTry, String defaultString) {
        return StringUtils.hasLength(toTry) ? toTry : defaultString;
    }

    private boolean wildcardEquals(String field, String wildcardString) {
        if (wildcardString.equals("*")) {
            return true;
        }
        return field.equals(wildcardString);
    }

    private boolean databaseMatches(String database, String pgpassDatabase, String pgpassUser) {
        if (database == null) {
            return pgpassDatabase.equals(pgpassUser);
        }
        return this.wildcardEquals(database, pgpassDatabase);
    }
}

