/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.enterprise.spanner;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.enterprise.spanner.SpannerDatabase;
import org.flywaydb.core.internal.database.enterprise.spanner.SpannerSchema;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

public class SpannerTable
extends Table<SpannerDatabase, SpannerSchema> {
    private static final Log LOG = LogFactory.getLog(SpannerTable.class);

    public SpannerTable(JdbcTemplate jdbcTemplate, SpannerDatabase database, SpannerSchema schema, String name) {
        super(jdbcTemplate, database, schema, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        try (Connection c = ((SpannerDatabase)this.database).getNewRawConnection();){
            boolean bl;
            block12: {
                Statement s = c.createStatement();
                s.close();
                ResultSet tables = c.getMetaData().getTables("", "", this.name, null);
                try {
                    bl = tables.next();
                    if (tables == null) break block12;
                }
                catch (Throwable throwable) {
                    if (tables != null) {
                        try {
                            tables.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                tables.close();
            }
            return bl;
        }
    }

    @Override
    protected void doLock() throws SQLException {
    }

    @Override
    protected void doDrop() throws SQLException {
        try (Statement statement = this.jdbcTemplate.getConnection().createStatement();){
            statement.execute("DROP TABLE " + ((SpannerDatabase)this.database).quote(this.name));
        }
    }

    @Override
    public String toString() {
        return ((SpannerDatabase)this.database).quote(this.name);
    }
}

