/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration;

import java.util.Locale;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;

public class ConfigurationValidator {
    public void validate(Configuration configuration) {
        if (configuration.isBatch() && configuration.getErrorOverrides().length > 0) {
            throw new FlywayException("flyway.batch configuration option is incompatible with flyway.errorOverrides.\nIt is impossible to intercept the errors in a batch process.\nSet flyway.batch to false, or remove the error overrides.", ErrorCode.CONFIGURATION);
        }
        if (configuration.getDataSource() == null) {
            throw new FlywayException("Unable to connect to the database. Configure the url, user and password!", ErrorCode.CONFIGURATION);
        }
        for (String key : configuration.getPlaceholders().keySet()) {
            if (!key.toLowerCase(Locale.ENGLISH).startsWith("flyway:")) continue;
            throw new FlywayException("Invalid placeholder ('flyway:' prefix is reserved): " + key);
        }
    }
}

