/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.ValueBinder;
import com.google.cloud.spanner.connection.StatementParser;
import com.google.cloud.spanner.jdbc.AbstractJdbcPreparedStatement;
import com.google.cloud.spanner.jdbc.JdbcConnection;
import com.google.cloud.spanner.jdbc.JdbcParameterMetaData;
import com.google.cloud.spanner.jdbc.JdbcParameterStore;
import java.sql.ResultSet;
import java.sql.SQLException;

class JdbcPreparedStatement
extends AbstractJdbcPreparedStatement {
    private final String sql;
    private final String sqlWithoutComments;
    private final JdbcParameterStore.ParametersInfo parameters;

    JdbcPreparedStatement(JdbcConnection connection, String sql) throws SQLException {
        super(connection);
        this.sql = sql;
        this.sqlWithoutComments = StatementParser.removeCommentsAndTrim((String)this.sql);
        this.parameters = JdbcParameterStore.convertPositionalParametersToNamedParameters(this.sqlWithoutComments);
    }

    JdbcParameterStore.ParametersInfo getParametersInfo() throws SQLException {
        return this.parameters;
    }

    private Statement createStatement() throws SQLException {
        JdbcParameterStore.ParametersInfo paramInfo = this.getParametersInfo();
        Statement.Builder builder = Statement.newBuilder((String)paramInfo.sqlWithNamedParameters);
        for (int index = 1; index <= this.getParameters().getHighestIndex(); ++index) {
            this.getParameters().bindParameterValue((ValueBinder<Statement.Builder>)builder.bind("p" + index), index);
        }
        return builder.build();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        return this.executeQuery(this.createStatement(), new Options.QueryOption[0]);
    }

    ResultSet executeQueryWithOptions(Options.QueryOption ... options) throws SQLException {
        this.checkClosed();
        return this.executeQuery(this.createStatement(), options);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkClosed();
        return this.executeUpdate(this.createStatement());
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkClosed();
        return this.executeStatement(this.createStatement());
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkClosed();
        this.checkAndSetBatchType(this.sql);
        this.batchedStatements.add(this.createStatement());
    }

    @Override
    public JdbcParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        return new JdbcParameterMetaData(this);
    }
}

