/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import java.io.PrintStream;
import org.flywaydb.commandline.ConsoleLog;
import org.flywaydb.core.api.logging.Log;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

class ColorizedConsoleLog
implements Log {
    private final ConsoleLog log;

    public static void install(boolean force) {
        if (force) {
            System.setProperty("jansi.force", "true");
        }
        AnsiConsole.systemInstall();
    }

    public ColorizedConsoleLog(ConsoleLog log) {
        this.log = log;
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public void debug(String message) {
        this.colorizeBright(System.out, Ansi.Color.BLACK);
        this.log.debug(message);
        this.reset(System.out);
    }

    public void info(String message) {
        if (message.startsWith("Successfully")) {
            this.colorize(System.out, Ansi.Color.GREEN);
            this.log.info(message);
            this.reset(System.out);
        } else {
            this.log.info(message);
        }
    }

    public void warn(String message) {
        this.colorize(System.out, Ansi.Color.YELLOW);
        this.log.warn(message);
        this.reset(System.out);
    }

    public void error(String message) {
        this.colorize(System.err, Ansi.Color.RED);
        this.log.error(message);
        this.reset(System.err);
    }

    public void error(String message, Exception e) {
        this.colorize(System.err, Ansi.Color.RED);
        this.log.error(message, e);
        this.reset(System.err);
    }

    private void colorize(PrintStream stream, Ansi.Color color) {
        stream.print(Ansi.ansi().fg(color));
    }

    private void colorizeBright(PrintStream stream, Ansi.Color color) {
        stream.print(Ansi.ansi().fgBright(color));
    }

    private void reset(PrintStream stream) {
        stream.print(Ansi.ansi().reset());
    }
}

