/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc.pro;

import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Context;
import org.flywaydb.core.api.callback.Error;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.callback.Warning;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.jdbc.pro.ErrorOverride;

public class ErrorOverrideCallback
implements Callback {
    private static final Log LOG = LogFactory.getLog(ErrorOverrideCallback.class);
    private final List<ErrorOverride> errorOverrides = new ArrayList<ErrorOverride>();

    public ErrorOverrideCallback(String ... errorOverrides) {
        for (String errorOverride : errorOverrides) {
            this.errorOverrides.add(new ErrorOverride(errorOverride));
        }
    }

    @Override
    public boolean supports(Event event, Context context) {
        return event == Event.AFTER_EACH_MIGRATE_STATEMENT || event == Event.AFTER_EACH_MIGRATE_STATEMENT_ERROR || event == Event.AFTER_EACH_UNDO_STATEMENT || event == Event.AFTER_EACH_UNDO_STATEMENT_ERROR;
    }

    @Override
    public boolean canHandleInTransaction(Event event, Context context) {
        return false;
    }

    @Override
    public void handle(Event event, Context context) {
        for (ErrorOverride errorOverride : this.errorOverrides) {
            for (Error error : context.getStatement().getErrors()) {
                if (error.isHandled() || !errorOverride.appliesTo(error.getState(), error.getCode())) continue;
                switch (errorOverride.getBehavior()) {
                    case DEBUG: {
                        LOG.debug(error.getMessage() + " (SQL state: " + error.getState() + ", error code: " + error.getCode() + ")");
                        error.setHandled(true);
                        break;
                    }
                    case DEBUG_NO_DETAILS: {
                        LOG.debug(error.getMessage());
                        error.setHandled(true);
                        break;
                    }
                    case INFO: {
                        LOG.info(error.getMessage() + " (SQL state: " + error.getState() + ", error code: " + error.getCode() + ")");
                        error.setHandled(true);
                        break;
                    }
                    case INFO_NO_DETAILS: {
                        LOG.info(error.getMessage());
                        error.setHandled(true);
                        break;
                    }
                    case WARNING: {
                        LOG.warn(error.getMessage() + " (SQL state: " + error.getState() + ", error code: " + error.getCode() + ")");
                        error.setHandled(true);
                        break;
                    }
                    case WARNING_NO_DETAILS: {
                        LOG.warn(error.getMessage());
                        error.setHandled(true);
                    }
                }
            }
            for (Warning warning : context.getStatement().getWarnings()) {
                if (warning.isHandled() || !errorOverride.appliesTo(warning.getState(), warning.getCode())) continue;
                switch (errorOverride.getBehavior()) {
                    case DEBUG: {
                        LOG.debug(warning.getMessage() + " (SQL state: " + warning.getState() + ", error code: " + warning.getCode() + ")");
                        warning.setHandled(true);
                        break;
                    }
                    case DEBUG_NO_DETAILS: {
                        LOG.debug(warning.getMessage());
                        warning.setHandled(true);
                        break;
                    }
                    case INFO: {
                        LOG.info(warning.getMessage() + " (SQL state: " + warning.getState() + ", error code: " + warning.getCode() + ")");
                        warning.setHandled(true);
                        break;
                    }
                    case INFO_NO_DETAILS: {
                        LOG.info(warning.getMessage());
                        warning.setHandled(true);
                        break;
                    }
                    case ERROR: {
                        warning.setHandled(true);
                        throw new FlywayException(warning.getMessage() + " (SQL state: " + warning.getState() + ", error code: " + warning.getCode() + ")");
                    }
                    case ERROR_NO_DETAILS: {
                        warning.setHandled(true);
                        throw new FlywayException(warning.getMessage());
                    }
                }
            }
        }
    }

    @Override
    public String getCallbackName() {
        return "ErrorOverride";
    }
}

